#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "platform.h"
#include "mipc_msg_host.h"
#include "mipc_msg_tlv_api.h"

void send_atcmd(char *atcmd) {
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;

    printf("Send [%s]\n", atcmd);
    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_AT_REQ, MIPC_MSG_PS0);

    //SETP2: add paramters
    mipc_sys_at_req_add_atcmd(msg_req_ptr, strlen(atcmd) + 1 , atcmd);
    //SETP3: send to MD
    msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    //SETP5: process the cnf msg
    if (msg_cnf_ptr == NULL) {
        printf("TIMEOUT\n");
        return;
    }
    if (mipc_get_result(msg_cnf_ptr) == MIPC_RESULT_SUCCESS) {
        printf("%s", mipc_sys_at_cnf_get_atcmd(msg_cnf_ptr, NULL));
    } else {
        printf("ERROR\n");
    }

    //SETE6: free the cnf msg
    mipc_msg_deinit(msg_cnf_ptr);
}

int main(int argc, char *argv[])
{
    if (argc == 2) {
        printf("SETCOM: %s\n", argv[1]);
        SETCOM(argv[1]);
    } else {
        printf("%s <COM>\n", argv[0]);
        exit(0);
    }

    mipc_init("wwan");

    printf("=======================================================>> config\n");
    send_atcmd("AT+ERAT=3");
    send_atcmd("AT+EGMR=1,7,\"123451234512345\"");
#ifndef _LINUX
    send_atcmd("AT+EGDATA=2");
#endif

    printf("=======================================================>> set IA\n");
    do {
        mipc_msg_t *msg_req_ptr;
        mipc_msg_t *msg_cnf_ptr;

        //SETP1: build MIPC message
        msg_req_ptr = mipc_msg_init(MIPC_APN_SET_IA_REQ, MIPC_MSG_PS0);
        //SETP2: add paramters
        mipc_msg_add_tlv(msg_req_ptr, MIPC_APN_SET_IA_REQ_T_APN, sizeof("internet"), "internet");
        mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_APN_SET_IA_REQ_T_PDP_TYPE, MIPC_APN_PDP_TYPE_IPV4V6);
        mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_APN_SET_IA_REQ_T_ROAMING_TYPE, MIPC_APN_PDP_TYPE_IPV4V6);
        mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_APN_SET_IA_REQ_T_AUTH_TYPE, MIPC_APN_AUTH_TYPE_NONE);
        mipc_msg_add_tlv(msg_req_ptr, MIPC_APN_SET_IA_REQ_T_USERID, sizeof(""), "");
        mipc_msg_add_tlv(msg_req_ptr, MIPC_APN_SET_IA_REQ_T_PASSWORD, sizeof(""), "");
        mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_APN_SET_IA_REQ_T_BEARER_BITMASK, 0xffffffff);
        mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_APN_SET_IA_REQ_T_COMPRESSION, MIPC_APN_COMPRESSION_ENABLE);
        //SETP3: send to MD
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        //SETE4: free the req msg
        mipc_msg_deinit(msg_req_ptr);

        //SETP5: process the cnf msg
        if (msg_cnf_ptr == NULL) {
            printf("TIMEOUT\n");
            break;
        }

        do {
            uint32_t *t_result_ptr;
            if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
            if (*t_result_ptr == 0) { // SUCCESS
                printf("SUCCESS\n");
                break;
            }

            printf("ERROR\n");
            break;
        } while (0);

        //SETE6: free the cnf msg
        mipc_msg_deinit(msg_cnf_ptr);
    } while (0);

    printf("=======================================================>> radio on\n");
    do {
        mipc_msg_t *msg_req_ptr;
        mipc_msg_t *msg_cnf_ptr;

        //SETP1: build MIPC message
        msg_req_ptr = mipc_msg_init(MIPC_NW_SET_RADIO_STATE_REQ, MIPC_MSG_PS0);
        //SETP2: add paramters
        mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_NW_SET_RADIO_STATE_REQ_T_SW_STATE, 1);
        //SETP3: send to MD
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        //SETE4: free the req msg
        mipc_msg_deinit(msg_req_ptr);

        //SETP5: process the cnf msg
        if (msg_cnf_ptr == NULL) {
            printf("TIMEOUT\n");
            break;
        }

        do {
            uint32_t *t_result_ptr;
            if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
            if (*t_result_ptr == 0) { // SUCCESS
                uint8_t *t_sw_radio_state_ptr;
                uint8_t *t_hw_radio_state_ptr;
                if ((t_sw_radio_state_ptr = (uint8_t *)mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_NW_SET_RADIO_STATE_CNF_T_SW_STATE, NULL)) == NULL) break;
                if ((t_hw_radio_state_ptr = (uint8_t *)mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_NW_SET_RADIO_STATE_CNF_T_HW_STATE, NULL)) == NULL) break;
                printf("SUCCESS SW_RADIO_STATE=%d HW_RADIO_STATE=%d\n", *t_sw_radio_state_ptr, *t_hw_radio_state_ptr);
                break;
            }

            printf("ERROR\n");
            break;
        } while (0);

        //SETE6: free the cnf msg
        mipc_msg_deinit(msg_cnf_ptr);
    } while (0);

    printf("=======================================================>> wait PS attach\n");
    int i;
    for (i = 0;;i++) {
        do {
            mipc_msg_t *msg_req_ptr;
            mipc_msg_t *msg_cnf_ptr;

            //SETP1: build MIPC message
            msg_req_ptr = mipc_msg_init(MIPC_NW_GET_PS_REQ, MIPC_MSG_PS0);
            //SETP2: add paramters
            //SETP3: send to MD
            msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
            //SETE4: free the req msg
            mipc_msg_deinit(msg_req_ptr);

            //SETP5: process the cnf msg
            if (msg_cnf_ptr == NULL) {
                printf("TIMEOUT\n");
                break;
            }

            do {
                uint32_t *t_result_ptr;
                if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
                if (*t_result_ptr == 0) { // SUCCESS
                    mipc_nw_ps_reg_info_struct4 *reg_info = mipc_nw_get_ps_cnf_get_reg_info(msg_cnf_ptr, 0);
                    if ((reg_info->stat == 1) || (reg_info->stat == 5)) {
                        printf("attach successfully rat=0x%x\n", reg_info->rat);
                        exit(0);
                    } else {
                        // Some time we need to know the stat value for debugging.
                        printf("attach fail with state = %d, rat = 0x%x\n", reg_info->stat, reg_info->rat);
                    }
                }
            } while (0);

            //SETE6: free the cnf msg
            mipc_msg_deinit(msg_cnf_ptr);
        } while (0);
        printf("wait %d\n", i);
        SLEEP(1);
    }

    mipc_deinit();
}
