#include <stdio.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/un.h>
#include <sys/types.h>
#include <errno.h>
#include <libxml/tree.h>
#include <libxml/parser.h>
#include <dlfcn.h>
#include <pthread.h>
#include "lynq_atsvc_controller.h"
#include "atcid.h"
#include "atcid_serial.h"
#include "atcid_cmd_dispatch.h"
#include "transfer_controller.h"
#define FUNC __FUNCTION__
#define LINE __LINE__

#define SOCKET_ZERO   0
#define SOCKET_SUCC   1
#define SOCKET_FAIL  -1
#define SOCKET_BUF_SIZE 512
char register_atcmd_buff[SOCKET_BUF_SIZE] = {0};
char *white_list[] = {"AT","ATD","ATV","ATA","ATE","ATH","ATL","ATI","ATP","ATO","ATQ",NULL};
int g_atsvc_socket_fd = 0;
int g_atsvc_client_connect = -1;
//struct sockaddr_in server_addr;
//struct sockaddr_in lynqClient_addr;
static pthread_mutex_t s_startupMutex = PTHREAD_MUTEX_INITIALIZER;
int has_registe_cmd = 0;
struct sockaddr_un g_remote_addr = {0};
struct sockaddr_un g_local_addr = {0};

int g_create_socket = 0;

typedef enum
{
    INIT_SUCCESS=0,
    INIT_PULGIN_FAIL,
    INIT_SOCKET_FAIL,
    INIT_THREAD_FAIL
}init_reuslt_t;

typedef struct
{
    xmlChar* name;
    xmlChar* reg;
    xmlChar* cmd;
}plugin_conf_t;

plugin_msg_t plugin_msg_array[PLUGINE_MAX_COUNT] = {0};
void upper_string(char *org_string)
{
    int len = strlen(org_string);
    for(int i=0;i<len;i++)
    {
        if(org_string[i]>=97 && org_string[i]<=122)
        {
            org_string[i]=org_string[i]-32;
        }
    }
    return;
}

void lynq_atsvc_outcb_entity(char *output,int out_size,int type)
{
    if(NULL == output)
    {
        ALOGE("output is null");
    }
    int length = 0;
    length = strlen(output);
    if(length != out_size)
    {
        ALOGD("strlen length != output");
    }
    ALOGD("ouput:%s,len:%d",output,out_size);
    lynq_write_data_to_serail(output,out_size,type);
}


int create_socket(const int domain, const int type, const int protocol,const int port,const char *IP,const char *socket_name,void * addr,int backlog)
{
    ALOGD("[%d][%s]start create socket",LINE,FUNC);
    ALOGD("domain:%d,type:%d,protocol:%d,port:%d,IP:%s,socket_name:%s,backlog:%d",domain,type,protocol,port,IP,socket_name,backlog);
    int socket_fd = -1;
    char acBuf[1024] = {0};
    struct sockaddr_un *local_addr = NULL;
    local_addr = (struct sockaddr_un *)addr;
    socket_fd = socket(domain, type,protocol);
    if(0 > socket_fd)
    {
        ALOGD("create socket fail:fd = %d",socket_fd);
        return socket_fd;
    }
    switch (domain)
    {
        case AF_UNIX:
        {
            if (strlen(socket_name) > sizeof(local_addr->sun_path) - 1)
            {
                ALOGD("Server socket path too long: %s", socket_name);
                return (-strlen(socket_name));
            }
            if (remove(socket_name) == -1 && errno != ENOENT)
            { 
                ALOGD("remove-%s fail and errno:%d", socket_name,errno);
            }
            while(access(socket_name, R_OK)==0)
            {
                ALOGD("%s still exist", socket_name);
                usleep(10);
            }
            ALOGD("remove %s", socket_name);
            local_addr->sun_family = AF_UNIX;
            sprintf(local_addr->sun_path, socket_name);
            // local_addr->sun_family = AF_UNIX;
            // memset(local_addr->sun_path,'\0',sizeof(local_addr->sun_path));
            // strncpy(local_addr->sun_path, socket_name, sizeof(local_addr->sun_path) - 1);
            // unlink(socket_name);
            //sprintf(local_addr->sun_path, socket_name);
            //strncpy(local_addr.sun_path, socket_name)
            if(bind(socket_fd, (struct sockaddr *)local_addr, sizeof(struct sockaddr_un)) < 0)
            {
                ALOGD("bind failed name=[%s] reason=[%s]\n", socket_name, strerror(errno));
                //ALOGD("[%d][%s]bind fail and errno: %d",LINE,FUNC,errno);
                close(g_atsvc_socket_fd);
                return -1;
            }
            if(type == SOCK_STREAM)
            {
                if(listen(socket_fd,backlog) == -1)
                {
                    ALOGD("[%d]listen fd: %dfail",LINE);
                    close(g_atsvc_socket_fd);
                    return -1;
                }
            }
            break;
        }
        case AF_INET:
        {
            break;
        }
        default:
            break;
    }
    return socket_fd;
}

int send_msg(int socket_fd,const struct sockaddr *dest_addr,const char *msg)
{
    ALOGD("[%d][%s] msg is:%s",LINE,FUNC,msg);
    int ret = 0;
    ret = sendto(socket_fd,msg, sizeof(msg), 0, dest_addr, sizeof(dest_addr));
    if(0 > ret)
    {
        ALOGD("sendto fail,ret:%d,errno:%d",ret,errno);
        return ret;
    }
    else
    {
        ALOGD("sendto msg len:%d",ret);
        ALOGD("return %d",0);
        return 0;
    }
}
int lynq_dispatch_atcmd(char* atcmd)
{
    ALOGD("[%d][%s] enter",LINE,FUNC);
    char *needleP = NULL;
    if(NULL == atcmd)
    {
        ALOGD("[%d][%s] atcmd is null",LINE,FUNC);
        return -1;
    }
    ALOGD("[%d][%s]atcmd:%s",LINE,FUNC,atcmd);
    char* line_cut = cut_cmd_line(atcmd);
    if (line_cut == NULL)
    {
        ALOGD("[%d][%s]line_cut is null",LINE,FUNC);
        return -1;
    }
    for(int i = 0;white_list[i];i++)
    {
        if(strcmp(line_cut,white_list[i]) == 0)
        {
            ALOGD("[%d][%s]count %d,pass atcmd:%s",LINE,FUNC,i,line_cut);
            return -1;
        }
    }
    for(int i = 0;i < PLUGINE_MAX_COUNT;i++)
    {
        ALOGD("i:%d,state:%d,atcmd:%s",i,plugin_msg_array[i].state,plugin_msg_array[i].atcmd);
        if((plugin_msg_array[i].state == 1) && (NULL != plugin_msg_array[i].atcmd))
        {
            needleP =strstr(plugin_msg_array[i].atcmd,line_cut);
            if(NULL != needleP)
            {
                ALOGD("[%d][%s] find atcmd:%s",LINE,FUNC,line_cut);
                free(line_cut);
                return i;
            }
        }
    }
    free(line_cut);
    return -1;
}


int load_pulgin(const char * plugin_conf_path)
{
    ALOGD("[%d][%s]load pulgin",LINE,FUNC);
    int count = 0;
    char *atcmd = NULL;
    int atcmd_len = 0;
    xmlDocPtr pdoc = NULL;
    xmlNodePtr root = NULL;
    plugin_conf_t plugin_conf;
    memset(plugin_msg_array,0,sizeof(plugin_msg_array));
    pdoc = xmlReadFile(plugin_conf_path ,"UTF-8",XML_PARSE_RECOVER);
    if(NULL == pdoc)
    {
        ALOGD("[%d][%s]open file %s" ,LINE,FUNC, plugin_conf_path);
        return -1;
    }
    root = xmlDocGetRootElement(pdoc);
    if(NULL == root)
    {
        ALOGD("get xmlDocGetRootElement() empty document fail");
        return -1;
    }
    ALOGD("root->name :%s",root->name);
    root = root->xmlChildrenNode;
    while (root != NULL)
    {
        ALOGD("count is:%d",count);
        if(PLUGINE_MAX_COUNT <= count)
        {
            ALOGD("plugin too many!!!");
            break;
        }
        if ((!xmlStrcmp(root->name, (const xmlChar *)"module")))
        {
            ALOGD("find module");
            plugin_conf.name = xmlGetProp(root, "name");
            plugin_conf.reg = xmlGetProp(root, "register");
            plugin_conf.cmd = xmlGetProp(root, "cmd");
            if((NULL == plugin_conf.name)||(NULL == plugin_conf.reg)||(NULL == plugin_conf.cmd))
            {
                ALOGE("get prop fail,name:%s,reg:%s,cmd=%s",plugin_conf.name,plugin_conf.reg,plugin_conf.cmd);
                root = root->next;
                continue;
            }
            ALOGE("[%d][%s]plugin_conf name:%s,reg:%s,cmd=%s",LINE,FUNC,plugin_conf.name,plugin_conf.reg,plugin_conf.cmd);
            plugin_msg_array[count].dlHandle_plugin = dlopen(plugin_conf.name, RTLD_NOW);
            if(NULL == plugin_msg_array[count].dlHandle_plugin)
            {
                ALOGE("open lib %s fail",plugin_conf.name);
                root = root->next;
                continue;
            }
            ALOGD("plugin_msg_array[%d].dlHandle_plugin :%p",count,plugin_msg_array[count].dlHandle_plugin);
            plugin_msg_array[count].register_module = (lynq_atsvc_incb(*)(lynq_atsvc_outcb out_cb))dlsym(plugin_msg_array[count].dlHandle_plugin, plugin_conf.reg);
            if(NULL == plugin_msg_array[count].register_module)
            {
                ALOGD("open plugin_msg_array[%d].%p fail",count,plugin_msg_array[count].register_module);
                ALOGD("dlsym failed: %s", dlerror());
                root = root->next;
                continue;
            }
            plugin_msg_array[count].atsvc_incb = plugin_msg_array[count].register_module(lynq_atsvc_outcb_entity);
            if(NULL == plugin_msg_array[count].atsvc_incb)
            {
                ALOGE("call %s fail",plugin_conf.reg);
                root = root->next;
                continue;
            }
            atcmd_len = strlen(plugin_conf.cmd);
            atcmd = (char *)malloc(atcmd_len*(sizeof(char)+1));
            if(NULL == atcmd)
            {
                ALOGE("count %d atcmd malloc fail",count);
                root = root->next;
                continue;
            }
            plugin_msg_array[count].state = 1;
            memcpy(atcmd,plugin_conf.cmd,atcmd_len);
            atcmd[atcmd_len] = '\0';
            //plugin_msg_array[count].atcmd = atcmd;
            upper_string(atcmd);
            plugin_msg_array[count].atcmd = atcmd;
            count++;
        }
        root = root->next;
    }
    ALOGD("pcurnode->name return");
    xmlFreeDoc(pdoc);
    xmlCleanupParser();
    return 0;
}


int lynq_check_extension_atcmd(char * atcmd)
{
    ALOGD("[%d][%s] enter",LINE,FUNC);
    char *needleP = NULL;
    if(NULL == atcmd)
    {
        ALOGD("[%d][%s] atcmd is null",LINE,FUNC);
        return -1;
    }
    ALOGD("[%d][%s]atcmd:%s",LINE,FUNC,atcmd);
    char* line_cut = cut_cmd_line(atcmd);
    if (line_cut == NULL)
    {
        ALOGD("[%d][%s]line_cut is null",LINE,FUNC);
        return -1;
    }
    for(int i = 0;white_list[i];i++)
    {
        if(strcmp(line_cut,white_list[i]) == 0)
        {
            ALOGD("[%d][%s]count %d,pass atcmd:%s",LINE,FUNC,i,line_cut);
            return -1;
        }
    }
    needleP =strstr(register_atcmd_buff,line_cut);
    if(NULL != needleP)
    {
        ALOGD("[%d][%s] find atcmd:%s",LINE,FUNC,line_cut);
        free(line_cut);
        return 0;
    }
    free(line_cut);
    return -1;
}
int send_msg_to_at_extension(char *atcmd,int size)
{
    LOGATCI(LOG_ERR,"[%d][%s] enter",LINE,FUNC);
    if (g_atsvc_client_connect < 0)
    {
        LOGATCI(LOG_ERR, "fd invalid when send to atci service. errno = %d", errno);
        return -1;
    }
    if(NULL == atcmd)
    {
        LOGATCI(LOG_ERR, "atcmd is null.");
        return -1;
    }
    int sendLen = send(g_atsvc_client_connect, atcmd, size, 0);
    if (sendLen != size)
    {
        LOGATCI(LOG_ERR, "lose data when send to atci service. errno = %d", errno);
        return -1;
    }
    LOGATCI(LOG_DEBUG, "service send to app demo: %s", atcmd);
    return 0;
}
int actsvc_cmd_recv(int fd, char *buf, int len)
{
    int ret = 0;
    // fd_set rfds;
    // //FD_CLR(fd, &rfds);
    // FD_SET(fd, &rfds);
    // int res = -1;
    // ret = select(fd + 1, &rfds, NULL, NULL, NULL);
    // if (ret <= 0)
    // {
    //     ALOGE("acti_cmd_recv service select error, ret=%d, error=%s(%d),fd=%d", ret,strerror(errno), errno, fd);
    //     return SOCKET_FAIL;
    // }
    // res = FD_ISSET(fd, &rfds);
    // ALOGE("FD_ISSET num is %d ", res);
    // if (res)
    // {
        ALOGE("[%d][%s] recv before",LINE,FUNC);
        ret = recv(fd, buf, len, 0);
        ALOGE("[%d][%s] recv before",LINE,FUNC);
        if (ret < 0)
        {
            ALOGE("acti_cmd_recv service select error, ret=%d, error=%s(%d),fd=%d", ret,strerror(errno), errno, fd);
            return SOCKET_FAIL;
        }
        else if(ret == 0)
        {
            ALOGE("acti_cmd_recv service recv error, ret=%d, error=%s(%d),fd=%d", ret,strerror(errno), errno, fd);
            return SOCKET_ZERO;
        }
        else
        {
            ALOGD("[%d][%s] buf is:%s",LINE,FUNC,buf);
            return SOCKET_SUCC;
        }
    // }
    // else
    // {
    //     ALOGE("FD_ISSET is error num is %d ", res);
    //     return SOCKET_ZERO;
    // }
    //return SOCKET_SUCC;
}

void *start_at_extension_Socket(void * param)
{
    ALOGD("[%d][%s]enter",LINE,FUNC);
    socklen_t client_len;
    int ret;
    char parser_buf[SOCKET_BUF_SIZE];
    TryNewSocket:
    g_atsvc_socket_fd = create_socket(AF_UNIX, SOCK_STREAM,0, 0, NULL,RIL_SOCKET_NAME, (void *)&g_local_addr, 2);
    if(0 > g_atsvc_socket_fd)
    {
        ALOGD("init socket fail and fd:%d",g_atsvc_socket_fd);
        g_create_socket++;
        if(g_create_socket == 10)
        {
            ALOGD("create_socket max try count is %d\n", g_create_socket);
            return NULL;
        }
        else
        {
            ALOGD("create_socket try again %d\n", g_create_socket);
            usleep(500*1000);
            goto TryNewSocket;
        }
    }
    g_create_socket = 0;
    TryNewLink:
    ALOGE("[%d][%s] TryNewLink!", LINE,FUNC);
    client_len = sizeof(g_local_addr);
    int conn = accept(g_atsvc_socket_fd,(struct sockaddr *) &g_local_addr, &client_len);
    if (conn <= 0)
    {
        ALOGE("[%d][%s] accept error!",LINE,FUNC);
        close(conn);
        return NULL;
    }
    ALOGD("Accept a client , fd is %d", conn);
    if(g_atsvc_client_connect >= 0)
    {
        ALOGE("g_atsvc_client_connect need close!");
        close(g_atsvc_client_connect);
        //g_atsvc_client_connect = -1;
    }
    g_atsvc_client_connect = conn;
    /* tranlate data */
    while (true)
    {
        memset(parser_buf, 0, sizeof(parser_buf));
        if(has_registe_cmd == 0)
        {
            memset(register_atcmd_buff, 0, sizeof(register_atcmd_buff));
            ret = actsvc_cmd_recv(conn, register_atcmd_buff, SOCKET_BUF_SIZE);
            upper_string(register_atcmd_buff);
            ALOGE("[%d][%s] ret %d has_registe_cmd %d",LINE,FUNC,ret,has_registe_cmd);
            if (ret < 0)
            {
                ALOGE("[%d][%s]receive CMD error",LINE,FUNC);
                continue;
            }
            else if(ret == SOCKET_ZERO)
            {
                ALOGE("maybe client socket closed 1. retry new link!");
              goto TryNewLink;
            }
            has_registe_cmd = 1;
        }
        else
        {
            ret = actsvc_cmd_recv(conn, parser_buf, SOCKET_BUF_SIZE);
            ALOGE("[%d][%s] ret %d has_registe_cmd %d",LINE,FUNC,ret,has_registe_cmd);
            if (ret < 0)
            {
                ALOGE("[%d][%s]receive CMD error",LINE,FUNC);
                continue;
            }
            else if(ret == SOCKET_ZERO)
            {
                ALOGE("maybe client socket closed 1. retry new link!");
              goto TryNewLink;
            }
            lynq_write_data_to_serail(parser_buf,strlen(parser_buf),0);
        }
    }
    return NULL;
}

void start_at_extension_loop(void)
{
    pthread_t at_extension_socket_thread;
    ALOGD("[%d][%s]enter",LINE,FUNC);
    pthread_mutex_lock(&s_startupMutex);

    pthread_attr_t attr;
    pthread_attr_init(&attr);
    pthread_attr_setdetachstate(&attr, PTHREAD_CREATE_DETACHED);

    int result = pthread_create(&at_extension_socket_thread, &attr, start_at_extension_Socket, NULL);
    if (result != 0)
    {
        ALOGE("Failed to create ATCI thread: %s", strerror(result));
        goto done;
    }
done:
    pthread_mutex_unlock(&s_startupMutex);
}

int lynq_atsvc_init(int count,const char * plugin_conf_path)
{
    ALOGD("start [%d][%s]",LINE,FUNC);
    int res = 0;
    /*
    g_atsvc_socket_fd = create_socket(AF_UNIX, SOCK_STREAM,0, 0, NULL,RIL_SOCKET_NAME, (void *)&g_local_addr, 2);
    if(0 > g_atsvc_socket_fd)
    {
        ALOGD("init socket fail and fd:%d",g_atsvc_socket_fd);
        //return INIT_SOCKET_FAIL;
    }
    */
    res = init_pseudo_terminal();
    if(res != 0)
    {
        ALOGD("init pseudo terminal fail");
    }
    start_at_extension_loop();
    res = load_pulgin(PLUGIN_CONF_PATH);
    if(0 > res)
    {
        for(int i = 0;i < PLUGINE_MAX_COUNT; i++)
        {
            if(NULL != plugin_msg_array[i].atcmd)
            {
                free(plugin_msg_array[i].atcmd);
            }
        }
        ALOGD("load_pulgin fail,code is %d",res);
        return INIT_PULGIN_FAIL;
    }
    for(int i = 0;i < PLUGINE_MAX_COUNT; i++)
    {
        if(NULL != plugin_msg_array[i].atcmd)
        {
            ALOGD("atcmd:%s",plugin_msg_array[i].atcmd);
        }
    }
    //todo at liblynq-at-extension
    /*create thread for reacive ril msg*/
    /*load pulgin from plugin config*/
    return 0;
}
