/**********************************************************************************************
* @file lynq_atsvc_controller.h
* @brief Control the initialization of lynq at, and dispacthing, etc.
* @details None
* @author   Hong Liu。
* @date     2022-11-24
* @version  V1.0
* @copyright   Copyright (c) MobileTek 
***********************************************************************************************/


#ifndef LYNQ_ATSVC_COBTROLLER_H
#define LYNQ_ATSVC_COBTROLLER_H 1

#include <sys/types.h>
#include <sys/socket.h>

#include <pthread.h>
#define PLUGIN_CONF_PATH "/data/atsvc/lynq_atsvc_plugin.xml"
#define RIL_SOCKET_NAME "/dev/socket/lynq_atsvc_socket_1"
#define PLUGINE_MAX_COUNT 16



/**********************************************************************************************
* @brief this is a callback function,atsvc will call this function if the at command is this \
**module command
* @param input [IN] at command
* @param length [IN] at command length
* @return NULL
************************************************************************************************/
typedef void ( *lynq_atsvc_incb )(const char *input,const int length);

/**********************************************************************************************
* @brief this is a callback function,plugin will call this function when the plugin needs to \
**return the response or urc
* @param input [IN] response or urc
* @param length [IN] response or urc length
* @param type 
** 0:response 
** 1:unsolictedresponse
* @return NULL
************************************************************************************************/
typedef void ( *lynq_atsvc_outcb )(char *output,int out_size,int type);

/**********************************************************************************************
* @brief this is a register function, atsvc will call this function when a plugin register in atsvc.
* @param lynq_atsvc_outcb [IN]
* @return lynq_atsvc_incb
************************************************************************************************/
typedef lynq_atsvc_incb (*lynq_register_module)(lynq_atsvc_outcb out_cb);


typedef struct
{
    lynq_atsvc_incb atsvc_incb;
    lynq_register_module register_module;
    void *dlHandle_plugin;
    char * atcmd;
    int state;
}plugin_msg_t;

extern plugin_msg_t plugin_msg_array[PLUGINE_MAX_COUNT];
extern int has_registe_cmd;
/**********************************************************************************************
* @brief initalize lynq atsvc,it will load plugin and create socket process
* @param plugin_conf_path [IN] plugin config file path
* @return 
*     0:success
*     1:load pugin config file fail
*     2:create socket fail
*     3:create thread fail
************************************************************************************************/
int lynq_atsvc_init(int count,const char * plugin_conf_path);
int lynq_check_extension_atcmd(char * atcmd);
int send_msg_to_at_extension(char *atcmd,int size);
int create_socket(const int domain, const int type, const int protocol,const int port,const char *IP,const char *socket_name,void * addr,int backlog);
int send_msg(int socket_fd,const struct sockaddr *dest_addr,const char *msg);
int lynq_dispatch_atcmd(char* atcmd);



#endif


