#ifndef __CCCI_INTERFACE_H__
#define __CCCI_INTERFACE_H__

#include <stdio.h>
#include <string.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <unistd.h>

typedef enum {
    MD_SYS1 = 0,
    MD_SYS2 = 1,
    MD_SYS3 = 2,
    MD_SYS5 = 4,
} CCCI_MD;

typedef enum {
    INVALID = 0,
    CCCI,            /* for 6575/77 */
    DUAL_CCCI,       /* for 6589/82/72/92/71/80 */
    ECCCI,           /* for 6595 and later LTE projects */
    EEMCS,           /* for 6582/92 LTE */
    EDSDA,           /* for 6595 DSDA (emd_ctl) */
    ECCCI_FSM,       /* ECCCI with FSM modification, since N0 kernel 3.18/4.4 */
} CCCI_VERSION;

typedef enum {
    MD_BOOT_MODE_INVALID = 0,
    MD_BOOT_MODE_NORMAL,
    MD_BOOT_MODE_META,
    MD_BOOT_MODE_MAX,
} MD_BOOT_MODE;

enum {
    MD_STATE_INVALID = 0,
    MD_STATE_BOOTING = 1,
    MD_STATE_READY = 2,
    MD_STATE_EXCEPTION = 3
};

#define USR_CCCI_MD1_CTRL_NAME        "/dev/ccci_monitor"
#define USR_CCCI_MD3_CTRL_NAME        "/dev/ccci3_monitor"

/**
 * ccci_get_version - get version of CCCI driver
 *
 * RETURNS:
 * see the defination of CCCI_VERSION
 */
static inline CCCI_VERSION ccci_get_version(void)
{
    int fd, ret;
    char ver_str[2];
    fd = open("/sys/kernel/ccci/version", O_RDONLY);
    if (fd < 0)
        return ECCCI;
    ret = read(fd, ver_str, sizeof(ver_str));
    close(fd);
    if (ret < 1)
        return INVALID;
    return (CCCI_VERSION) (ver_str[0] - '0');
}

/************************************* IOCTL command set *************************************/
#define CCCI_IOC_MAGIC 'C'
#define CCCI_IOC_MD_RESET                _IO(CCCI_IOC_MAGIC,  0) /* mdlogger META/muxreport */
#define CCCI_IOC_GET_MD_STATE            _IOR(CCCI_IOC_MAGIC, 1, unsigned int) /* audio */
#define CCCI_IOC_GET_MD_INFO             _IOR(CCCI_IOC_MAGIC, 8, unsigned int) /* md_init */
#define CCCI_IOC_DO_STOP_MD              _IO(CCCI_IOC_MAGIC,  12) /* md_init */
#define CCCI_IOC_DO_START_MD             _IO(CCCI_IOC_MAGIC,  13) /* md_init */
#define CCCI_IOC_SEND_BATTERY_INFO       _IO(CCCI_IOC_MAGIC,  21) /* md_init */
#define CCCI_IOC_RELOAD_MD_TYPE          _IO(CCCI_IOC_MAGIC,  25)    /* META  md_init // muxreport */
#define CCCI_IOC_SET_MD_IMG_EXIST        _IOW(CCCI_IOC_MAGIC, 29, unsigned int)    /* md_init */
#define CCCI_IOC_GET_MD_IMG_EXIST        _IOR(CCCI_IOC_MAGIC, 30, unsigned int)    /* META */
#define CCCI_IOC_GET_MD_TYPE             _IOR(CCCI_IOC_MAGIC, 31, unsigned int)    /* RILD */
#define CCCI_IOC_STORE_MD_TYPE           _IOW(CCCI_IOC_MAGIC, 32, unsigned int)    /* RILD */
#define CCCI_IOC_GET_MD_TYPE_SAVING      _IOR(CCCI_IOC_MAGIC, 33, unsigned int)    /* META */

#define CCCI_IOC_SEND_SIGNAL_TO_USER     _IOW(CCCI_IOC_MAGIC, 43, unsigned int)    /* md_init */
#define CCCI_IOC_IGNORE_MD_EXCP          _IO(CCCI_IOC_MAGIC,  44)                  /* RILD */
#define CCCI_IOC_RESET_MD1_MD3_PCCIF     _IO(CCCI_IOC_MAGIC,  45)                  /* md_init */
#define CCCI_IOC_RESET_AP                _IOW(CCCI_IOC_MAGIC, 46, unsigned int)    /* md_init */
/* set MD boot env data before power on MD */
#define CCCI_IOC_SET_BOOT_DATA           _IOW(CCCI_IOC_MAGIC, 47, unsigned int[16])

#define CCCI_IOC_GET_MD_BOOT_MODE       _IOR(CCCI_IOC_MAGIC, 59, unsigned int) /* md_init */

#define CCCI_IPC_MAGIC 'P'    /* only for IPC user */
#define CCCI_IPC_UPDATE_TIME        _IO(CCCI_IPC_MAGIC,4)
#define CCCI_IPC_WAIT_TIME_UPDATE   _IO(CCCI_IPC_MAGIC,5)
#define CCCI_IPC_UPDATE_TIMEZONE    _IO(CCCI_IPC_MAGIC,6)

#endif /*__CCCI_INTERFACE_H__    */
