/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
/*
 * File name:  rfx_controller.cpp
 * Author: Jun Liu (MTK80064)
 * Description:
 *  Implementation of base controller class.
 */

/*****************************************************************************
 * Include
 *****************************************************************************/
#include "RfxController.h"
#include "RfxRootController.h"
#include "RfxSlotRootController.h"
#include "RfxStatusManager.h"
#include "RfxLog.h"


#define RFX_LOG_TAG "RfxController"
#define LOG_BUF_SIZE 1024
/*****************************************************************************
 * Class RfxWaitReponseTimerHelper
 *****************************************************************************/

RFX_IMPLEMENT_CLASS("RfxWaitReponseTimerHelper", RfxWaitReponseTimerHelper, RfxObject);

void RfxWaitReponseTimerHelper::onTimer() {
    m_callback1.invoke(m_reponse_msg);
    int token = m_reponse_msg->getToken();
    RFX_LOG_D(RFX_LOG_TAG, "RfxWaitReponseTimerHelper::onTimer. msg token: %d", token);
    RfxController* controller = m_controller.promote().get();
    if(controller != NULL) {
        controller->removeCachedResponse(token);
        controller->setProcessedMsg(m_reponse_msg->getPId(), m_reponse_msg->getPTimeStamp());
    }
    RfxWaitReponseTimerHelper *_this = this;
    RFX_OBJ_CLOSE(_this);
}

/*****************************************************************************
 * Class RfxController
 *****************************************************************************/

RFX_IMPLEMENT_CLASS("RfxController", RfxController, RfxObject);

extern bool responseToRilj(const sp<RfxMessage>& message);

RfxController::RfxController() :
    m_slot_id(RFX_SLOT_ID_UNKNOWN) {
}

RfxController::RfxController(int slot_id) : m_slot_id(slot_id)
{
}
RfxController::~RfxController() {
}


RfxController *RfxController::findController(int slot_id, const RfxClassInfo *class_info) {

    RfxController *ret = NULL;

    if (!class_info->isKindOf(RFX_OBJ_CLASS_INFO(RfxController))) {
        return ret;
    }

    RfxController *root = getSlotRoot(slot_id);
    RfxObject *parent;

    if (root == NULL) {
        parent = RFX_OBJ_GET_INSTANCE(RfxRootController);
    } else {
        parent = static_cast<RfxObject *>(root);
    }

    RfxObject *obj = findObject(parent, class_info);

    ret = RFX_OBJ_DYNAMIC_CAST(obj, RfxController);

    // if can't find a controller in slot tree,
    // find in non-slot based tree
    if (ret == NULL && slot_id >= 0 && slot_id < RFX_SLOT_COUNT) {
        root = getSlotRoot(RFX_SLOT_ID_UNKNOWN);
        RFX_ASSERT(root != NULL);
        parent = static_cast<RfxObject *>(root);
        RfxObject *obj = findObject(parent, class_info);
        ret = RFX_OBJ_DYNAMIC_CAST(obj, RfxController);
    }

    return ret;
}

RfxController *RfxController::getSlotRoot(int slot_id) const {

    return RFX_OBJ_GET_INSTANCE(RfxRootController)->getSlotRootController(slot_id);
}

void RfxController::registerToHandleRequest(int slot_id, const int *request_id_list,
                        size_t length, HANDLER_PRIORITY priority) {
    RfxRootController *root = RFX_OBJ_GET_INSTANCE(RfxRootController);
    root->registerToHandleRequest(this, slot_id, request_id_list, length, priority);
}

void RfxController::registerToHandleUrc(int slot_id, const int *urc_id_list, size_t length) {
    RfxRootController *root = RFX_OBJ_GET_INSTANCE(RfxRootController);
    root->registerToHandleUrc(this, slot_id, urc_id_list, length);
}

void RfxController::unregisterToHandleRequest(int slot_id, const int *request_id_list,
            size_t length, HANDLER_PRIORITY priority) {
    RfxRootController *root = RFX_OBJ_GET_INSTANCE(RfxRootController);
    root->unregisterToHandleRequest(slot_id, request_id_list, length, priority);
}

void RfxController::unregisterToHandleUrc(int slot_id,
                                     const int *urc_id_list, size_t length) {
    RfxRootController *root = RFX_OBJ_GET_INSTANCE(RfxRootController);
    root->unregisterToHandleUrc(slot_id, urc_id_list, length);
}

#if 0
bool RfxController::responseToRilj(const sp<RfxMessage>& message) {
    //return RFX_OBJ_GET_INSTANCE(RfxRilAdapter)->responseToRilj(message);
    return true;
}
#endif
int RfxController::getSlotId() const {
    return m_slot_id;
}

RfxStatusManager *RfxController::getStatusManager(int slot_id) const {
    return RFX_OBJ_GET_INSTANCE(RfxRootController)->getStatusManager(slot_id);
}


void RfxController::onInit() {
    RfxObject::onInit();
    if (m_slot_id == RFX_SLOT_ID_UNKNOWN) {
        RfxObject *parent = getParent();
        RfxController *controller = RFX_OBJ_DYNAMIC_CAST(parent, RfxController);
        if (controller != NULL) {
            m_slot_id = controller->getSlotId();
        }
    }
}

void RfxController::onDeinit() {
    RFX_LOG_D(RFX_LOG_TAG, "onDeinit() %p, %s", this, getClassInfo()->getClassName());
    RFX_OBJ_GET_INSTANCE(RfxRootController)->clearRegistry(this);
    RfxObject::onDeinit();
}


bool RfxController::processMessage(const sp<RfxMessage>& message) {
    if (!onPreviewMessage(message)) {
        RFX_OBJ_GET_INSTANCE(RfxRootController)->suspendMessage(this, message);
        return true;
    }
    if (message->getType() == REQUEST) {
        return onHandleRequest(message);
    } else if (message->getType() == URC) {
        return onHandleUrc(message);
    } else if (message->getType() == RESPONSE) {
        //sp<RfxMessage> msg = processBlackListResponse(message);
        return onHandleResponse(message);
    }
    return false;
}

bool RfxController::checkIfResumeMessage(const sp<RfxMessage>& message) {
    return onCheckIfResumeMessage(message);
}

bool RfxController::checkIfRemoveSuspendedMessage(const sp<RfxMessage>& message) {
    return onCheckIfRemoveSuspendedMessage(message);
}

bool RfxController::onPreviewMessage(const sp<RfxMessage>& message) {
    RFX_UNUSED(message);
    return true;
}

bool RfxController::onCheckIfTransferParcelToObj(const sp<RfxMessage>& message) {
    return false;
}

bool RfxController::onHandleRequest(const sp<RfxMessage>& message) {
    return true;
}

bool RfxController::onHandleUrc(const sp<RfxMessage>& message) {
    return responseToRilj(message);

}
bool RfxController::onHandleResponse(const sp<RfxMessage>& message) {
    return responseToRilj(message);
}

bool RfxController::onCheckIfResumeMessage(const sp<RfxMessage>& message) {
    RFX_UNUSED(message);
    return false;
}

bool RfxController::onCheckIfRemoveSuspendedMessage(const sp<RfxMessage>& message) {
    RFX_UNUSED(message);
    return false;
}


void RfxController::removeCachedResponse(int token) {
    size_t count = m_wait_reponse_msg_list.size();
    bool deleteTokenSuccess = false;
    for (size_t index = 0; index < count; index++) {
        RfxWaitReponseEntry messageTmp = m_wait_reponse_msg_list.itemAt(index);
        if (messageTmp.m_reponse_msg->getToken() == token) {
            m_wait_reponse_msg_list.removeAt(index);
            deleteTokenSuccess = true;
            break;
        }
    }
    RFX_LOG_D(RFX_LOG_TAG, "remove cached reponse %s, token: %d, result: %d",
        toString().string(), token, deleteTokenSuccess);
}

void RfxController::setProcessedMsg(int id, nsecs_t timeStamp) {
    RfxController::ProcessedMsgInfo info(id, timeStamp);
    RFX_LOG_D(RFX_LOG_TAG, "setProcessedMsg %s, id: %d, pTimeStamp:%11u",
            toString().string(), id, timeStamp);
    m_processed_msg_list.add(info);
}

int RfxController::getProceesedMsgIndex(int id, nsecs_t timeStamp) {
    size_t count = m_processed_msg_list.size();
    for (size_t i = 0; i < count; i++) {
        const ProcessedMsgInfo &info = m_processed_msg_list.itemAt(i);
        if (info.id == id && info.pTimeStamp== timeStamp) {
            return (int)i;
        }
    }
    return -1;
}

String8 RfxController::toString() {
    return String8::format("%p, %s", this, getClassInfo()->getClassName());
}

void RfxController::clearMessages() {
    clearWaitResponseList();
    for (RfxObject *i = getFirstChildObj(); i != NULL; i = i->getNextObj()) {
        RfxController *controller = RFX_OBJ_DYNAMIC_CAST(i, RfxController);
        if (controller != NULL) {
            controller->clearMessages();
        }
    }
}

void RfxController::clearWaitResponseList() {
    size_t count = m_wait_reponse_msg_list.size();
    for (size_t i = 0; i < count; i++) {
        RfxWaitReponseEntry messageTmp = m_wait_reponse_msg_list.itemAt(i);
        if (messageTmp.m_timer_handle != NULL) {
            RfxTimer::stop(messageTmp.m_timer_handle);
            messageTmp.deleteEntryHelper();
        }
    }
    m_wait_reponse_msg_list.clear();
}


