/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 */
/* MediaTek Inc. (C) 2020. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
/*****************************************************************************
 * Include
 *****************************************************************************/
#include <string.h>
#include <linux/sockios.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <telephony/mtk_ril.h>
#include <cutils/jstring.h>

#include "MipcUtils.h"
#include "RfxLog.h"

/*****************************************************************************
 * Define
 *****************************************************************************/
#define RFX_LOG_TAG "MipcUtils"

#define DEBUG 1
#define _IN6_IS_ULA(a)  \
    ((((a)->s6_addr[0] & 0xff) == 0xfc) || (((a)->s6_addr[0] & 0xff) == 0xfd))

/* Negative values for private RIL errno's */
#define RIL_ERRNO_INVALID_RESPONSE -1

static void writeStringToParcel(Parcel &p, const char *s) {
    char16_t *s16;
    size_t s16_len;
    s16 = strdup8to16(s, &s16_len);
    p.writeString16(s16, s16_len);
    free(s16);
}

void safeFree(void *ptr){
    if (ptr == NULL)
        return;
    free(ptr);
    ptr = NULL;
}

int mapPdpTypeFromStringToEnum(const char * pdnType, mipc_apn_pdp_type_enum *apnPdpType){

    if(pdnType == NULL){
        *apnPdpType = MIPC_APN_ENUM_PDP_TYPE_DEFAULT;
        return 0;
    }

    RFX_LOG_D(RFX_LOG_TAG, "%s pdnType %s", __FUNCTION__, pdnType);

    if (strcmp(pdnType, "IPV4V6") == 0)
        *apnPdpType = MIPC_APN_ENUM_PDP_TYPE_IPV4V6;
    else if (strcmp(pdnType, "IPV6") == 0)
        *apnPdpType = MIPC_APN_ENUM_PDP_TYPE_IPV6;
    else if (strcmp(pdnType, "IP") == 0)
        *apnPdpType = MIPC_APN_ENUM_PDP_TYPE_IPV4;
    else
        *apnPdpType = MIPC_APN_ENUM_PDP_TYPE_DEFAULT;
    return 0;
}

int mapAuthTypeFromStringToEnum(const char * authType, mipc_apn_auth_type_enum *apnAuthType){
    if(authType == NULL){
        *apnAuthType = MIPC_APN_ENUM_AUTH_TYPE_NONE;
        return 0;
    }

    RFX_LOG_D(RFX_LOG_TAG, "%s pdnType %s", __FUNCTION__, authType);

    if (strcmp(authType, "PAP") == 0)
        *apnAuthType = MIPC_APN_ENUM_AUTH_TYPE_PAP;
    else if (strcmp(authType, "CHAP") == 0)
        *apnAuthType = MIPC_APN_ENUM_AUTH_TYPE_CHAP;
    else
        *apnAuthType = MIPC_APN_ENUM_AUTH_TYPE_NONE;
    return 0;
}

void dumpSetupDataRequestPrameters(char **pStrings, int32_t countStrings){
    #if DEBUG
    RFX_LOG_D(RFX_LOG_TAG, "%s countStrings[%d] dump Setup Data Request Prameters begin", __FUNCTION__, countStrings);
    for(int i = 0; i < countStrings; i++){
        RFX_LOG_D(RFX_LOG_TAG, "%s Prameters[%d][%s]", __FUNCTION__, i, pStrings[i]);
    }
    RFX_LOG_D(RFX_LOG_TAG, "%s dump Setup Data Request Prameters end", __FUNCTION__);
    #else

    #endif
}

void dumpApnIaInfo(const mipc_apn_ia_struct_v *apnIa){
    #if DEBUG
    RFX_LOG_D(RFX_LOG_TAG,"%s IA ia_list_count: %d apn:%s pdp_type:%d\n", __FUNCTION__, apnIa->ia_list_count, apnIa->ia_list[0].apn, apnIa->ia_list[0].pdp_type);
    #else

    #endif
}

void dumpApnInfo(RIL_MtkDataProfileInfo **dataProfilePtrs, const int num){
    #if DEBUG

    if (dataProfilePtrs == NULL){
        RFX_LOG_D(RFX_LOG_TAG,"NULL dataProfilePtrs ");
        return;
    }

    RFX_LOG_D(RFX_LOG_TAG,"dump APN info begin num[%d]", num);
    for(int i = 0; i < num; i++){
        RFX_LOG_D(RFX_LOG_TAG,"dump APN info[%d] begin", i);

        if ( dataProfilePtrs[i] == NULL){
            RFX_LOG_D(RFX_LOG_TAG,"NULL dataProfilePtrs[%d]", i);
            continue;
        }

        RFX_LOG_D(RFX_LOG_TAG,"profileId[%d]", dataProfilePtrs[i]->profileId);

        if (dataProfilePtrs[i]->apn)
            RFX_LOG_D(RFX_LOG_TAG,"profileId[%s]", dataProfilePtrs[i]->apn);

        if (dataProfilePtrs[i]->protocol)
            RFX_LOG_D(RFX_LOG_TAG,"protocol[%s]", dataProfilePtrs[i]->protocol);

        if (dataProfilePtrs[i]->roamingProtocol)
            RFX_LOG_D(RFX_LOG_TAG,"roamingProtocol[%s]", dataProfilePtrs[i]->roamingProtocol);

        RFX_LOG_D(RFX_LOG_TAG,"authType[%d]", dataProfilePtrs[i]->authType);

        if (dataProfilePtrs[i]->user)
            RFX_LOG_D(RFX_LOG_TAG,"user[%s]", dataProfilePtrs[i]->user);

        if (dataProfilePtrs[i]->password)
            RFX_LOG_D(RFX_LOG_TAG,"password[%s]", dataProfilePtrs[i]->password);

        RFX_LOG_D(RFX_LOG_TAG,"type[%d]", dataProfilePtrs[i]->type);

        RFX_LOG_D(RFX_LOG_TAG,"dump APN info[%d] end", i);
    }
    RFX_LOG_D(RFX_LOG_TAG,"dump APN info end");
    #else

    #endif
}

static void memsetAndFreeStrings(int numPointers, ...) {
    va_list ap;
    va_start(ap, numPointers);
    for (int i = 0; i < numPointers; i++) {
        char *ptr = va_arg(ap, char *);
        if (ptr) {
#ifdef MEMSET_FREED
#define MAX_STRING_LENGTH 4096
            memset(ptr, 0, strnlen(ptr, MAX_STRING_LENGTH));
#endif
            free(ptr);
        }
    }
    va_end(ap);
}

void freeSetDataProfileData(int numProfiles, RIL_MtkDataProfileInfo *dataProfiles, RIL_MtkDataProfileInfo **dataProfilePtrs, int numfields, ...){
    va_list args;
    va_start(args, numfields);

    if (dataProfiles == NULL || dataProfilePtrs == NULL)
        return;

    // Iterate through each string-type field that need to be free.
    for (int i = 0; i < numfields; i++) {
        // Iterate through each data profile and free that specific string-type field.
        // The type 'char *T::*' is a type of pointer to a 'char *' member inside T structure.
        char *RIL_MtkDataProfileInfo::*ptr = va_arg(args, char *RIL_MtkDataProfileInfo::*);
        for (int j = 0; j < numProfiles; j++) {
            memsetAndFreeStrings(1, dataProfiles[j].*ptr);
        }
    }

    va_end(args);

    free(dataProfiles);
    free(dataProfilePtrs);
}

bool isIpv6Global(char *ipv6Addr) {
    char *address = NULL;
    String8 cmd("");

    address = strsep(&ipv6Addr, "/");
    cmd.append(String8::format("{IPv6 address:%s, IPv6 prefix length:%s}", address, ipv6Addr));

    if (address != NULL) {
        struct sockaddr_in6 sa;
        int ret = 0;

        if (strncasecmp("FE80", address, strlen("FE80")) == 0) {
            RFX_LOG_I(RFX_LOG_TAG, "[%s] not global -> %s", __FUNCTION__, cmd.string());
            return false;
        }

        // ret: -1, error occurs, ret: 0, invalid address, ret: 1, success;
        ret = inet_pton(AF_INET6, address, &(sa.sin6_addr));
        if (ret <= 0) {
            RFX_LOG_E(RFX_LOG_TAG, "[%s] inet_pton ret: %d -> %s",
                    __FUNCTION__, ret, cmd.string());
            return false;
        }

        if (IN6_IS_ADDR_MULTICAST(&sa.sin6_addr)) {
            RFX_LOG_D(RFX_LOG_TAG, "[%s] multi-cast -> %s",  __FUNCTION__, cmd.string());
            if (IN6_IS_ADDR_MC_GLOBAL(&sa.sin6_addr)) {
                RFX_LOG_I(RFX_LOG_TAG, "[%s] global -> %s", __FUNCTION__, cmd.string());
                return true;
            } else {
                RFX_LOG_I(RFX_LOG_TAG, "[%s] not global -> %s", __FUNCTION__, cmd.string());
            }
        } else {
            if (IN6_IS_ADDR_LINKLOCAL(&sa.sin6_addr)) {
                RFX_LOG_I(RFX_LOG_TAG, "[%s] link-local -> %s", __FUNCTION__, cmd.string());
            } else if (IN6_IS_ADDR_SITELOCAL(&sa.sin6_addr)) {
                RFX_LOG_I(RFX_LOG_TAG, "[%s] site-local -> %s", __FUNCTION__, cmd.string());
            } else if (IN6_IS_ADDR_V4MAPPED(&sa.sin6_addr)) {
                RFX_LOG_I(RFX_LOG_TAG, "[%s] v4mapped -> %s", __FUNCTION__, cmd.string());
            } else if (IN6_IS_ADDR_V4COMPAT(&sa.sin6_addr)) {
                RFX_LOG_I(RFX_LOG_TAG, "[%s] v4compat -> %s", __FUNCTION__, cmd.string());
            } else if (IN6_IS_ADDR_LOOPBACK(&sa.sin6_addr)) {
                RFX_LOG_I(RFX_LOG_TAG, "[%s] host -> %s", __FUNCTION__, cmd.string());
            } else if (IN6_IS_ADDR_UNSPECIFIED(&sa.sin6_addr)) {
                RFX_LOG_I(RFX_LOG_TAG, "[%s] unspecified -> %s", __FUNCTION__, cmd.string());
            } else if (_IN6_IS_ULA(&sa.sin6_addr)) {
                RFX_LOG_I(RFX_LOG_TAG, "[%s] take uni-local as global -> %s",
                        __FUNCTION__, cmd.string());
                return true;
            } else {
                RFX_LOG_I(RFX_LOG_TAG, "[%s] global -> %s", __FUNCTION__, cmd.string());
                return true;
            }
        }
    } else {
        RFX_LOG_E(RFX_LOG_TAG, "[%s] input ipv6 address is null!!", __FUNCTION__);
    }
    return false;
}


int responseDataCallListV11(Parcel &p, void *response, size_t responselen) {
    if (response == NULL && responselen != 0) {
                RLOGE("invalid response: NULL");
                return RIL_ERRNO_INVALID_RESPONSE;
    }

    if (responselen % sizeof(MTK_RIL_Data_Call_Response_v11) != 0) {
        RLOGE("invalid response length %d expected multiple of %d",
        (int)responselen, (int)sizeof(MTK_RIL_Data_Call_Response_v11));
        return RIL_ERRNO_INVALID_RESPONSE;
    }

    // Write version
    p.writeInt32(11);

    int num = responselen / sizeof(MTK_RIL_Data_Call_Response_v11);
    p.writeInt32(num);

    MTK_RIL_Data_Call_Response_v11 *p_cur = (MTK_RIL_Data_Call_Response_v11 *) response;
    int i;
    for (i = 0; i < num; i++) {
        p.writeInt32((int)p_cur[i].status);
        p.writeInt32(p_cur[i].suggestedRetryTime);
        p.writeInt32(p_cur[i].cid);
        p.writeInt32(p_cur[i].active);
        writeStringToParcel(p, p_cur[i].type);
        writeStringToParcel(p, p_cur[i].ifname);
        writeStringToParcel(p, p_cur[i].addresses);
        writeStringToParcel(p, p_cur[i].dnses);
        writeStringToParcel(p, p_cur[i].gateways);
        writeStringToParcel(p, p_cur[i].pcscf);
        p.writeInt32(p_cur[i].mtu);
        p.writeInt32(p_cur[i].rat);
        RLOGD("%s[status=%d,retry=%d,cid=%d,%s,%s,%s,%s,%s,%s,%s,%d,rat=%d],", __FUNCTION__,
        p_cur[i].status,
        p_cur[i].suggestedRetryTime,
        p_cur[i].cid,
        (p_cur[i].active==0)?"down":"up",
        (char*)p_cur[i].type,
        (char*)p_cur[i].ifname,
        (char*)p_cur[i].addresses,
        (char*)p_cur[i].dnses,
        (char*)p_cur[i].gateways,
        (char*)p_cur[i].pcscf,
        p_cur[i].mtu,
        p_cur[i].rat);
    }

    return 0;
}