// SPDX-License-Identifier: MediaTekProprietary
/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  Copyright (c) [2020], MediaTek Inc. All rights reserved.
*  This software/firmware and related documentation ("MediaTek Software") are
*  protected under relevant copyright laws.
*
*  The information contained herein is confidential and proprietary to
*  MediaTek Inc. and/or its licensors. Except as otherwise provided in the
*  applicable licensing terms with MediaTek Inc. and/or its licensors, any
*  reproduction, modification, use or disclosure of MediaTek Software, and
*  information contained herein, in whole or in part, shall be strictly
*  prohibited.
*****************************************************************************/

#ifndef __RP_ECALL_CONTROLLER_H__
#define __RP_ECALL_CONTROLLER_H__

#include <string>

#include "RfxController.h"
#include "RpUtils.h"
#include "RilParcelUtils.h"
#include <telephony/mtk_ril_request_info.h>

#ifdef __cplusplus
extern "C" {
#endif
#include "mipc_ecall_api.h"
#include "mipc_msg_tlv_const.h"
#ifdef __cplusplus
}
#endif

/*****************************************************************************
 * Class RpEcallController
 *****************************************************************************/
class RpEcallController : public RfxController {
    RFX_DECLARE_CLASS(RpEcallController);  // Required: declare this class

public:
    RpEcallController();

    virtual ~RpEcallController();

// Override
protected:

    virtual void onInit();
    virtual void onDeinit();
    virtual bool onHandleRequest(const sp<RfxMessage>& message);

private:
    std::string mLog_tag;
    String8 mEccListWithCard;
    String8 mEccListNoCard;
    bool mIsSimInsert;
    String8 mGsmEcc;

private:
    void registerInd(mipc_sim_ps_id_enum sim_ps_id,void *cb_priv_ptr);

    void handleEcallFastMakeEcall(const sp<RfxMessage> &request);
    void handleEcallUpdateMsd(const sp<RfxMessage>& request);
    void handleEcallResetIvs(const sp<RfxMessage>& request);
    void handleEcallSetRegState(const sp<RfxMessage>& request);
    int handleEcallGetSimInfo();
    void handleEcallSetTestAddr(const sp<RfxMessage>& request);
    void handleEcallSetReconfAddr(const sp<RfxMessage> &request);
    void handleEcallSetAddrPri(const sp<RfxMessage> &request);

    void checkEccNumberAndServiceCategory(char* number, const sp<RfxMessage> &request);
    bool isEmergencyNumber(String8 number);
    int getServiceCategory(String8 number);
    bool isEccMatchInList(String8 number, String8 eccList);

    std::string IdToString(int request);
};

#endif /* __RP_ECALL_CONTROLLER_H__ */
