// SPDX-License-Identifier: MediaTekProprietary
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2015. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

/*****************************************************************************
 * Include
 *****************************************************************************/

#include "RpImsController.h"

#include <sys/un.h>
#include <errno.h>
#include <unistd.h>
#include <cutils/jstring.h>
#include <string>
#ifdef __cplusplus
extern "C" {
#endif
#include "mipc_msg_host.h"
#include "mipc_msg_tlv_const.h"
#include "mipc_msg_tlv_api.h"
#ifdef __cplusplus
}
#endif

#include "RfxDispatchThread.h"
#include "Rfx.h"
#include "rfx_properties.h"
#include "RilParcelUtils.h"
#include <telephony/mtk_ril_request_info.h>
#include "RfxRootController.h"
#include "RpUtils.h"

using namespace std;

#define RFX_LOG_TAG "RpImsController"

/*****************************************************************************
 * Class RfxDataController
 * The class is created if the slot is single mode, LWG or C,
 *****************************************************************************/

RFX_IMPLEMENT_CLASS("RpImsController", RpImsController, RfxController);

RpImsController::RpImsController() {
}

RpImsController::~RpImsController() {
}

void mipc_ims_state_ind_cb(mipc_msg_t *msg_ptr, void *priv_ptr) {
    mipc_result_enum result;
    mipc_sim_ps_id_enum sim_ps_id;
    sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;
    Parcel *parcel = NULL;

    mipc_ims_state_ind_event_const_enum event = mipc_ims_state_ind_get_event(msg_ptr,
        (mipc_ims_state_ind_event_const_enum)mipc_ims_state_ind_event_const_NONE);
    switch (event) {
        case MIPC_IMS_STATE_IND_EVENT_REG_STATE:
        {
            uint8_t reg_state = mipc_ims_state_ind_get_reg_state(msg_ptr,0xFF);
            uint32_t ext_info =  mipc_ims_state_ind_get_ext_info(msg_ptr,0xFFFFFFFF);
            parcel = new Parcel();
            parcel->writeInt32(3); //length of the ints
            parcel->writeInt32(reg_state);
            parcel->writeInt32(ext_info);
            parcel->writeInt32(mipc_sim_id_to_slot_id(sim_ps_id));
            rfx_enqueue_urc_message(RIL_UNSOL_IMS_REGISTRATION_INFO,parcel,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);

            rfx_enqueue_urc_message(RIL_UNSOL_RESPONSE_IMS_NETWORK_STATE_CHANGED,
                    NULL, mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
            break;
        }
        default:
            break;
    }
}

void RpImsController::onInit() {
    RfxController::onInit();  // Required: invoke super class implementation
    int32_t ret;
    RFX_LOG_D(RFX_LOG_TAG, "RpImsController onInit");

    const int request_id_list[] = {
            RIL_REQUEST_SET_IMS_ENABLE,
            RIL_REQUEST_SET_IMSCFG,
            RIL_REQUEST_IMS_REGISTRATION_STATE,
    };
    // register request id list
    registerToHandleRequest(request_id_list,
            sizeof(request_id_list) / sizeof(int));

    ret = mipc_msg_register_ind_api((mipc_msg_sim_ps_id_enum)slot_id_to_mipc_sim_id(getSlotId()),
        MIPC_IMS_STATE_IND, (void*)mipc_ims_state_ind_cb, NULL, NULL);
    if (ret == -1) {
        RFX_LOG_D(RFX_LOG_TAG, "Register IMS_STATE_IND fail\n");
    }
    RFX_LOG_D(RFX_LOG_TAG, "RpImsController onInit done");
}

void RpImsController::onDeinit() {
    RFX_LOG_D(RFX_LOG_TAG, "onDeinit");
    RfxController::onDeinit();
}

bool RpImsController::onHandleRequest(const sp<RfxMessage>& message) {
    RFX_LOG_D(RFX_LOG_TAG, "Handle request %d", message->getId());

    RfxDispatchThread::addMessageToPendingQueue(message);

    switch (message->getId()) {
    case RIL_REQUEST_SET_IMS_ENABLE:
        handleSetImsEnableRequest(message);
        break;
    case RIL_REQUEST_SET_IMSCFG:
        handleSetImsCfgRequest(message);
        break;
    case RIL_REQUEST_IMS_REGISTRATION_STATE:
        handleImsRegistrationState(message);
        break;
    default:
        RFX_LOG_D(RFX_LOG_TAG, "unknown request, ignore!");
        break;
    }
    return true;
}

extern "C" {
int isImsSupport() {
    int isImsSupport = 0;
    char prop_value[RFX_PROPERTY_VALUE_MAX] = {0};
    rfx_property_get("persist.vendor.ims.support", prop_value, "1");
    isImsSupport = atoi(prop_value);
    RFX_LOG_D(RFX_LOG_TAG, "isImsSupport = %d", isImsSupport);
    return isImsSupport;
}
}

extern "C" {
void mipc_ims_set_config_cb(mipc_msg_t *msg_ptr, void *priv_ptr) {
    mipc_result_enum result;
    mipc_sim_ps_id_enum sim_ps_id;
    result = mipc_get_result(msg_ptr);
    sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;
    if (result == MIPC_RESULT_SUCCESS) {
        rfx_enqueue_response_message(NULL,priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }else {
        rfx_enqueue_response_message(NULL,priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),result);
    }
}
}

void RpImsController::handleSetImsEnableRequest(const sp<RfxMessage>& request) {
    RFX_LOG_D(RFX_LOG_TAG, "handleSetImsEnableRequest with clientId: %d, with token: %d",
            request->getClientId(), request->getToken());
    do {
        Parcel *p = request->getParcel();
        int32_t status;
        int count;
        int enable;
        if(p != NULL) {
            status = p->readInt32(&count);
            if (status != 0) {
                RFX_LOG_D(RFX_LOG_TAG,"handleSetImsEnableRequest readerror\n");
                break;
            }

            status = p->readInt32(&enable);
            if (status != 0) {
                RFX_LOG_D(RFX_LOG_TAG,"handleSetImsEnableRequest readerror\n");
                break;
            }
        }

        uint8_t data[6]={0,0,0,0,1,1};
        mipc_msg_t *msg_req_ptr = NULL;

        if (isImsSupport()) {
            data[0] = enable;
        } else {
            data[4] = 0;
            data[5] = 0;
        }

        RFX_LOG_D(RFX_LOG_TAG,"handleSetImsEnableRequest enable = %d, ims support = %d\n", data[0], isImsSupport());

        msg_req_ptr = mipc_msg_init(MIPC_IMS_SET_CONFIG_REQ, (mipc_msg_sim_ps_id_enum)slot_id_to_mipc_sim_id(request->getSlotId()));
        if(msg_req_ptr) {
            mipc_ims_set_config_req_add_class(msg_req_ptr, MIPC_IMS_CONFIG_CLASS_IMS_FEATURE);
            mipc_ims_set_config_req_add_data(msg_req_ptr, 6, (void*)data);
            mipc_msg_async_api(msg_req_ptr,(void*)mipc_ims_set_config_cb,NULL,(void *)request->getRilToken());
            mipc_msg_deinit(msg_req_ptr);
            return;
        }
    }while(0);

    rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_GENERIC_FAILURE);
}

void RpImsController::handleSetImsCfgRequest(const sp<RfxMessage>& request) {
    RFX_LOG_D(RFX_LOG_TAG, "handleSetImsCfgRequest with clientId: %d, with token: %d",
            request->getClientId(), request->getToken());
    int volte = 0, vilte = 0, vowifi = 0, viwifi = 0, sms = 0, eims = 0;

    do {
        Parcel *p = request->getParcel();
        int32_t status;
        int count;
        if(isImsSupport() && (p != NULL)) {
            status = p->readInt32(&count);
            if (status != 0) {
                RFX_LOG_D(RFX_LOG_TAG,"handleSetImsCfgRequest readerror\n");
                break;
            }
            status = p->readInt32(&volte);
            if (status != 0) {
                RFX_LOG_D(RFX_LOG_TAG,"handleSetImsCfgRequest readerror\n");
                break;
            }
            status = p->readInt32(&vilte);
            if (status != 0) {
                RFX_LOG_D(RFX_LOG_TAG,"handleSetImsCfgRequest readerror\n");
                break;
            }
            status = p->readInt32(&vowifi);
            if (status != 0) {
                RFX_LOG_D(RFX_LOG_TAG,"handleSetImsCfgRequest readerror\n");
                break;
            }
            status = p->readInt32(&viwifi);
            if (status != 0) {
                RFX_LOG_D(RFX_LOG_TAG,"handleSetImsCfgRequest readerror\n");
                break;
            }
            status = p->readInt32(&sms);
            if (status != 0) {
                RFX_LOG_D(RFX_LOG_TAG,"handleSetImsCfgRequest readerror\n");
                break;
            }
            status = p->readInt32(&eims);
            if (status != 0) {
                RFX_LOG_D(RFX_LOG_TAG,"handleSetImsCfgRequest readerror\n");
                break;
            }
        }

        uint8_t data[6]={volte,vilte,vowifi,viwifi,sms,eims};
        mipc_msg_t *msg_req_ptr;
        RFX_LOG_D(RFX_LOG_TAG,"handleSetImsCfgRequest isImsSupport()=%d, volte=%d,vilte=%d,vowifi=%d,viwifi=%d,sms=%d,eims=%d\n",
            isImsSupport(), volte,vilte,vowifi,viwifi,sms,eims);

        msg_req_ptr = mipc_msg_init(MIPC_IMS_SET_CONFIG_REQ, (mipc_msg_sim_ps_id_enum)slot_id_to_mipc_sim_id(request->getSlotId()));
        if(msg_req_ptr) {
            mipc_ims_set_config_req_add_class(msg_req_ptr, MIPC_IMS_CONFIG_CLASS_IMS_FEATURE);
            mipc_ims_set_config_req_add_data(msg_req_ptr, 6, (void*)data);
            mipc_msg_async_api(msg_req_ptr,(void*)mipc_ims_set_config_cb,NULL,(void *)request->getRilToken());
            mipc_msg_deinit(msg_req_ptr);
            return;
        }
    }while(0);

    rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_GENERIC_FAILURE);
}

extern "C" {
void mipc_get_ims_reg_state_cb(mipc_msg_t *msg_ptr, void *priv_ptr) {
    mipc_result_enum result;
    mipc_sim_ps_id_enum sim_ps_id;
    result = mipc_get_result(msg_ptr);
    sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;
    Parcel *p = NULL;

    if (result == MIPC_RESULT_SUCCESS) {
        mipc_ims_state_ind_event_const_enum event = mipc_ims_get_state_cnf_get_event(msg_ptr,mipc_ims_state_ind_event_const_NONE);
        switch(event) {
            case MIPC_IMS_STATE_IND_EVENT_REG_STATE:
            {
                mipc_ims_state_const_enum reg_state =
                    mipc_ims_get_state_cnf_get_reg_state(msg_ptr,mipc_ims_state_const_NONE);
                p = new Parcel();
                p->writeInt32(2); // int length
                p->writeInt32(reg_state);
                p->writeInt32(1); // RADIO_TECH_3GPP
                break;
            }
            default:
                break;
        }
        rfx_enqueue_response_message(p,priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }else {
        rfx_enqueue_response_message(NULL,priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),result);
    }
}
}
void RpImsController::handleImsRegistrationState(const sp<RfxMessage>& request) {
    RFX_LOG_D(RFX_LOG_TAG, "handleImsRegistrationState with clientId: %d, with token: %d",
            request->getClientId(), request->getToken());
    mipc_msg_t *msg_req_ptr;

    msg_req_ptr = mipc_msg_init(MIPC_IMS_GET_STATE_REQ, (mipc_msg_sim_ps_id_enum)slot_id_to_mipc_sim_id(request->getSlotId()));
    if(msg_req_ptr) {
        mipc_ims_get_state_req_add_event(msg_req_ptr,MIPC_IMS_STATE_IND_EVENT_REG_STATE);
        mipc_msg_async_api(msg_req_ptr,(void*)mipc_get_ims_reg_state_cb,NULL,(void *)request->getRilToken());
        mipc_msg_deinit(msg_req_ptr);
        return;
    }
    rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_GENERIC_FAILURE);
}


