// SPDX-License-Identifier: MediaTekProprietary
/*****************************************************************************
 *  Copyright Statement:
 *  --------------------
 *  Copyright (c) [2020], MediaTek Inc. All rights reserved.
 *  This software/firmware and related documentation ("MediaTek Software") are
 *  protected under relevant copyright laws.
 *
 *  The information contained herein is confidential and proprietary to
 *  MediaTek Inc. and/or its licensors. Except as otherwise provided in the
 *  applicable licensing terms with MediaTek Inc. and/or its licensors, any
 *  reproduction, modification, use or disclosure of MediaTek Software, and
 *  information contained herein, in whole or in part, shall be strictly
 *  prohibited.
 *****************************************************************************/
#include <utils/Errors.h>
#include <binder/Parcel.h>
#include <string.h>
#include <sstream>
#include "RfxDispatchThread.h"
#include "Rfx.h"
#include "RpSimController.h"
#include "RfxRootController.h"
#include "RpSsController.h"
#include "RpSsUtils.h"
#include "rfx_properties.h"
#include "mipc_ss_api.h"


#define RFX_LOG_TAG "RILD_RpSimController"
#define PROPERTY_ICCID_PREIFX "vendor.ril.iccid.sim"
#define PROPERTY_GSM_MCC_MNC_PREIFX "vendor.ril.data.gsm_mcc_mnc"
#define PROPERTY_GSM_RIL_FULLUICCTYPE_PREIFX "vendor.gsm.ril.fulluicctype"
#define PROPERTY_GSM_RIL_UICCTYPE_PREIFX "vendor.gsm.ril.uicctype"

using std::string;
using android::Parcel;
using android::status_t;
using android::NO_ERROR;

static string getTag(mipc_sim_ps_id_enum sim_ps_id) {
    string tag = "";
    tag.append("[slot").append(to_string(mipc_sim_id_to_slot_id(sim_ps_id))).append("]").append(RFX_LOG_TAG);
    return tag;
}

extern "C" {

static bool isSimInserted(mipc_sim_ps_id_enum sim_ps_id) {
    String8 iccid = RFX_OBJ_GET_INSTANCE(RfxRootController)->getStatusManager(mipc_sim_id_to_slot_id(sim_ps_id))->getString8Value(RFX_STATUS_KEY_SIM_ICCID);
//xf.li@20231120 modify for T8TSK-291 start
    RFX_LOG_D(getTag(sim_ps_id).c_str(),"%s, iccid: (has got)", __FUNCTION__);
//xf.li@20231120 modify for T8TSK-291 end
    if ((!iccid.isEmpty())){
        return true;
    }
    return false;
}

static void mipc_sim_pin_protect_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_pin_protect_struct *result_ptr, void *cb_priv_ptr) {
}

static string dump_sim_chg_pinX_ret(mipc_sim_change_pin_struct *ptr, void *cb_priv_ptr){
    android::RequestInfo *info = (android::RequestInfo *)cb_priv_ptr;
    string str("");
    str.append("request:").append(requestToString(info->pCI->requestNumber));
    str.append(",result_code:").append(std::to_string(ptr->result_code));
    str.append(",pin_type:").append(std::to_string(ptr->pin_type));
    str.append(",pin_state:").append(std::to_string(ptr->pin_state));
    str.append(",remaining_attempts:").append(std::to_string(ptr->remaining_attempts));
    return str;
}

static void mipc_sim_chg_pinX_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_change_pin_struct *result_ptr, void *cb_priv_ptr) {
    RFX_LOG_D(getTag(sim_ps_id).c_str(),"%s, %s", __FUNCTION__, dump_sim_chg_pinX_ret(result_ptr,cb_priv_ptr).c_str());
    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),result_ptr->result_code);
    }else {
        Parcel * p = new Parcel();
        p->writeInt32(1);
        p->writeInt32(result_ptr->remaining_attempts);
        rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}

static string dump_sim_verify_pinX_ret(mipc_sim_verify_pin_struct *ptr, void *cb_priv_ptr){
    android::RequestInfo *info = (android::RequestInfo *)cb_priv_ptr;
    string str("");
    str.append("request:").append(requestToString(info->pCI->requestNumber));
    str.append(",result_code:").append(std::to_string(ptr->result_code));
    str.append(",pin_type:").append(std::to_string(ptr->pin_type));
    str.append(",pin_state:").append(std::to_string(ptr->pin_state));
    str.append(",remaining_attempts:").append(std::to_string(ptr->remaining_attempts));
    return str;
}

static void mipc_sim_verify_pinX_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_verify_pin_struct *result_ptr, void *cb_priv_ptr) {
    RFX_LOG_D(getTag(sim_ps_id).c_str(),"%s, %s", __FUNCTION__, dump_sim_verify_pinX_ret(result_ptr,cb_priv_ptr).c_str());
    Parcel * p = new Parcel();
    p->writeInt32(1);
    p->writeInt32(result_ptr->remaining_attempts);
    rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),result_ptr->result_code);
}

static string dump_sim_unblock_pinX_ret(mipc_sim_unblock_pin_struct *ptr, void *cb_priv_ptr){
    android::RequestInfo *info = (android::RequestInfo *)cb_priv_ptr;
    string str("");
    str.append("request:").append(requestToString(info->pCI->requestNumber));
    str.append(",result_code:").append(std::to_string(ptr->result_code));
    str.append(",pin_type:").append(std::to_string(ptr->pin_type));
    str.append(",pin_state:").append(std::to_string(ptr->pin_state));
    str.append(",remaining_attempts:").append(std::to_string(ptr->remaining_attempts));
    return str;
}

static void mipc_sim_unblock_pinX_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_unblock_pin_struct *result_ptr, void *cb_priv_ptr) {
    RFX_LOG_D(getTag(sim_ps_id).c_str(),"%s, %s", __FUNCTION__, dump_sim_unblock_pinX_ret(result_ptr,cb_priv_ptr).c_str());
    Parcel * p = new Parcel();
    p->writeInt32(1);
    p->writeInt32(result_ptr->remaining_attempts);
    rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),result_ptr->result_code);
}

static void mipc_sim_pin_info_get_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_pin_info_struct *result_ptr, void *cb_priv_ptr) {
}
static void mipc_sim_pin_list_get_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_pin_list_struct *result_ptr, void *cb_priv_ptr) {
}
static void mipc_sim_state_get_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_state_struct *result_ptr, void *cb_priv_ptr) {
}

static string dump_mipc_sim_status(mipc_sim_status_struct *ptr,void *cb_priv_ptr) {
    string str("");
    if(cb_priv_ptr){
        android::RequestInfo *info = (android::RequestInfo *)cb_priv_ptr;
        str.append(" request:").append(requestToString(info->pCI->requestNumber));
    } else {
        str.append(" request:").append("LOCAL_GET_SIM_STATUS");
    }
    str.append(",result_code:").append(std::to_string(ptr->result_code));
    str.append(",status:").append(std::to_string(ptr->sim_status));
    str.append(",sim_id:").append(std::to_string(ptr->sim_id));
    str.append(",ps_id:").append(std::to_string(ptr->ps_id));
    if(ptr->card_present_state == UINT8_MAX) {
        str.append(",card_present_state:").append("");
    } else {
        str.append(",card_present_state:").append(std::to_string(ptr->card_present_state));
    }
    if(ptr->upin_status == UINT8_MAX) {
        str.append(",upin_status:").append("");
    } else {
        str.append(",upin_status:").append(std::to_string(ptr->upin_status));
    }
    if(ptr->test_sim  == UINT8_MAX) {
        str.append(",test_sim:").append("");
    } else {
        str.append(",test_sim:").append(std::to_string(ptr->test_sim));
    }
    if(ptr->gsm_app_idx == UINT8_MAX) {
        str.append(",gsm_app_idx:").append("");
    } else {
        str.append(",gsm_app_idx:").append(std::to_string(ptr->gsm_app_idx));
    }
    if(ptr->cdma_app_idx == UINT8_MAX) {
        str.append(",cdma_app_idx:").append("");
    } else {
        str.append(",cdma_app_idx:").append(std::to_string(ptr->cdma_app_idx));
    }
    if(ptr->isim_app_idx == UINT8_MAX) {
        str.append(",isim_app_idx:").append("");
    } else {
        str.append(",isim_app_idx:").append(std::to_string(ptr->isim_app_idx));
    }

    str.append(",app_count:").append(std::to_string(ptr->app_count));
    str.append(",app_list:");
    for(uint8_t i = 0; i < ptr->app_count ; i++) {
        str.append(",app_list[").append(std::to_string(i)).append("]");
        str.append(",app_type:").append(std::to_string(ptr->app_list[i].app_type));
        str.append(",app_state:").append(std::to_string(ptr->app_list[i].app_state));
        str.append(",pin_status:").append(std::to_string(ptr->app_list[i].pin_status));
        str.append(",sub_status:").append(std::to_string(ptr->app_list[i].sub_status));
        str.append(",pin1_replaced:").append(std::to_string(ptr->app_list[i].pin1_replaced));
        str.append(",pin1_state:").append(std::to_string(ptr->app_list[i].pin1_state));
        str.append(",pin2_state:").append(std::to_string(ptr->app_list[i].pin2_state));
        if(strlen(ptr->app_list[i].aid) > 0) {
            str.append(",app_state:").append(string(ptr->app_list[i].aid));
        } else {
            str.append(",app_state:").append("");
        }
        if(strlen(ptr->app_list[i].app_label) > 0) {
            str.append(",app_label:").append(string(ptr->app_list[i].app_label));
        } else {
            str.append(",app_label:").append("");
        }

    }
    if(strlen(ptr->eid) > 0 ){
        str.append(",eid:").append(string(ptr->eid));
    } else {
        str.append(",eid:").append("");
    }
    if(strlen(ptr->iccid) > 0) {
//xf.li@20231120 modify for T8TSK-291 start
        str.append(",iccid:").append("(has got)");
//xf.li@20231120 modify for T8TSK-291 end
    } else {
        str.append(",iccid:").append("");
    }
    if(strlen(ptr->atr) > 0) {
        str.append(",atr:").append(string(ptr->atr));
    } else {
        str.append(",atr:").append("");
    }

    return str;
}

static void handleCardType(uint8_t app_type,mipc_sim_ps_id_enum sim_ps_id) {
    RFX_LOG_D(getTag(sim_ps_id).c_str(),"%s, app_type: %lu", __FUNCTION__,app_type);
    int slot = mipc_sim_id_to_slot_id(sim_ps_id);
    string type("");
    int typeValue = 0;
    string fullUiccCardType(PROPERTY_GSM_RIL_FULLUICCTYPE_PREIFX);
    string propUicc(PROPERTY_GSM_RIL_UICCTYPE_PREIFX);
    if(slot > 0) {
        propUicc.append(".").append(std::to_string(slot+1));
        fullUiccCardType.append(".").append(std::to_string(slot+1));
    }
    if(app_type == mipc_sim_app_type_const_enum::MIPC_SIM_APP_TYPE_USIM) {
        if(type.empty()) {
            type.append("USIM");
        } else {
            type.append(",USIM");
        }
        typeValue |= RFX_CARD_TYPE_USIM;
        rfx_property_set(propUicc.c_str(), "USIM");
    } else if(app_type == mipc_sim_app_type_const_enum::MIPC_SIM_APP_TYPE_CSIM) {
        if(type.empty()) {
            type.append("RUIM,CSIM");
        } else {
            type.append(",RUIM,CSIM");
        }
        rfx_property_set(propUicc.c_str(), "CSIM");
        typeValue |= RFX_CARD_TYPE_RUIM;
        typeValue |= RFX_CARD_TYPE_CSIM;
    } else if(app_type == mipc_sim_app_type_const_enum::MIPC_SIM_APP_TYPE_ISIM) {
        if(type.empty()) {
            type.append("ISIM");
        } else {
            type.append(",ISIM");
        }
        typeValue |= RFX_CARD_TYPE_ISIM;
    } else if(app_type == mipc_sim_app_type_const_enum::MIPC_SIM_APP_TYPE_UNKNOWN) {
        type.append("N/A");
        rfx_property_set(fullUiccCardType.c_str(), "");
        rfx_property_set(propUicc.c_str(), "");
    } else {
        //only for test
        if(type.empty()) {
            type.append("USIM");
        } else {
            type.append(",USIM");
        }
        typeValue |= RFX_CARD_TYPE_USIM;
        rfx_property_set(propUicc.c_str(), "USIM");
    }
    rfx_property_set(fullUiccCardType.c_str(), type.c_str());
    RFX_OBJ_GET_INSTANCE(RfxRootController)->getStatusManager(slot)->setIntValue(RFX_STATUS_KEY_CARD_TYPE, typeValue);
    if (typeValue >= 0) {
        RFX_OBJ_GET_INSTANCE(RfxRootController)->getStatusManager(slot)->setBoolValue(RFX_STATUS_KEY_MODEM_SIM_TASK_READY, true, true);
    }
}

static void sendSimStatusAppInfo(Parcel *p, int num_apps, mipc_app_status_desc_struct4 app_list[],int slot) {
    p->writeInt32(num_apps);
    for (int i = 0; i < num_apps; i++) {
        p->writeInt32(app_list[i].app_type);
        p->writeInt32(app_list[i].app_state);
        p->writeInt32(app_list[i].sub_status);
        writeStringToParcel(p, (const char*) (app_list[i].aid));
        writeStringToParcel(p, (const char*) (app_list[i].app_label));
        p->writeInt32(app_list[i].pin1_replaced);
        p->writeInt32(app_list[i].pin1_state);
        p->writeInt32(app_list[i].pin2_state);
    }
}

int transferMipcSimResultCode(mipc_result_enum result_code) {
    switch(result_code) {
        case MIPC_RESULT_SIM_NOT_INSERTED:
            return RIL_E_SIM_ABSENT;
        case MIPC_RESULT_PIN_REQUIRED:
        case MIPC_RESULT_PIN_DISABLED:
            return RIL_E_PASSWORD_INCORRECT;
        case MIPC_RESULT_BUSY:
            return RIL_E_SIM_BUSY;
        case MIPC_RESULT_BAD_SIM:
            return RIL_E_SIM_ERR;
        case MIPC_RESULT_FAILURE:
            return RIL_E_GENERIC_FAILURE;
        default:
            return result_code;
    }
}

static void mipc_sim_status_get_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_status_struct *result_ptr, void *cb_priv_ptr) {
    RFX_LOG_D(getTag(sim_ps_id).c_str(),"%s, %s", __FUNCTION__, dump_mipc_sim_status(result_ptr,cb_priv_ptr).c_str());
    if(cb_priv_ptr &&
            !(result_ptr->result_code == MIPC_RESULT_SUCCESS ||
            result_ptr->result_code == MIPC_RESULT_SIM_NOT_INSERTED ||
            result_ptr->result_code == MIPC_RESULT_PIN_REQUIRED ||
            result_ptr->result_code == MIPC_RESULT_PIN_DISABLED)) {
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),transferMipcSimResultCode(result_ptr->result_code));
    } else {
        if(result_ptr->gsm_app_idx >= 0 && result_ptr->gsm_app_idx < result_ptr->app_count){
            handleCardType(result_ptr->app_list[result_ptr->gsm_app_idx].app_type,sim_ps_id);
        }else {
            handleCardType(0,sim_ps_id);
        }
        if(cb_priv_ptr) {
            //RIL_CardStatus_v7
            Parcel * p = new Parcel();
            p->writeInt32(result_ptr->card_present_state);
            p->writeInt32(result_ptr->upin_status);
            p->writeInt32(result_ptr->gsm_app_idx);
            p->writeInt32(result_ptr->cdma_app_idx);
            p->writeInt32(result_ptr->isim_app_idx);
            sendSimStatusAppInfo(p, result_ptr->app_count, result_ptr->app_list,mipc_sim_id_to_slot_id(sim_ps_id));

            p->writeInt32(result_ptr->sim_id);
            writeStringToParcel(p, (const char *)result_ptr->atr);
            writeStringToParcel(p, (const char *)result_ptr->iccid);
            rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
        }
    }
}

static void mipc_sim_iccid_get_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_iccid_struct *result_ptr, void *cb_priv_ptr) {
    android::RequestInfo *info = (android::RequestInfo *)cb_priv_ptr;
    string str("");
    str.append("request:").append(requestToString(info->pCI->requestNumber));
    if(strlen(result_ptr->iccid) > 0 ) {
//xf.li@20231120 modify for T8TSK-291 start
        str.append("iccid: ").append("(has got)");
//xf.li@20231120 modify for T8TSK-291 end
    } else {
        str.append("");
    }
//xf.li@20231120 modify for T8TSK-291 start
    RFX_LOG_D(getTag(sim_ps_id).c_str(),"%s, iccid: (has got), result: %d", __FUNCTION__, result_ptr->result_code);
//xf.li@20231120 modify for T8TSK-291 end
    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),result_ptr->result_code);
    }else {
        //RIL_CardStatus_v6
        Parcel * p = new Parcel();
        string iccid("");
        if(strlen(result_ptr->iccid) > 0 ) {
            iccid.append(result_ptr->iccid);
        }
        writeStringToParcel(p, iccid.c_str());
        rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}

static string dump_sim_euicc_slots_status_get_ret(mipc_sim_get_euicc_slots_status_struct *ptr, void *cb_priv_ptr){
    android::RequestInfo *info = (android::RequestInfo *)cb_priv_ptr;
    string str("");
    str.append("request:").append(requestToString(info->pCI->requestNumber));
    str.append(",result_code:").append(std::to_string(ptr->result_code));
    str.append(",slots_info_count:").append(std::to_string(ptr->slots_info_count));
    for(uint8_t i = 0; i < ptr->slots_info_count ; i++) {
        str.append(",pin_state[").append(std::to_string(i)).append("]: ").append(std::string((ptr->slots_info_list)[i].card_state));
        str.append(",slots_state[").append(std::to_string(i)).append("]: ").append(std::to_string((ptr->slots_info_list)[i].slots_state));
        str.append(",logical_idx[").append(std::to_string(i)).append("]: ").append(std::to_string((ptr->slots_info_list)[i].logical_idx));
        str.append(",atr[").append(std::to_string(i)).append("]: ").append(std::string((ptr->slots_info_list)[i].atr));
        str.append(",eid[").append(std::to_string(i)).append("]: ").append(std::string((ptr->slots_info_list)[i].eid));
        str.append(",iccid[").append(std::to_string(i)).append("]: ").append(std::string((ptr->slots_info_list)[i].iccid));
    }
    return str;
}

static void mipc_sim_euicc_slots_status_get_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_get_euicc_slots_status_struct *result_ptr, void *cb_priv_ptr) {
    RFX_LOG_D(getTag(sim_ps_id).c_str(),"%s, %s", __FUNCTION__,dump_sim_euicc_slots_status_get_ret(result_ptr,cb_priv_ptr).c_str());
    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),result_ptr->result_code);
    } else {
        Parcel * p = new Parcel();
        string eid("");
        if(result_ptr->slots_info_count > mipc_sim_id_to_slot_id(sim_ps_id)) {
            eid.append((result_ptr->slots_info_list)[mipc_sim_id_to_slot_id(sim_ps_id)].eid);
        }
        writeStringToParcel(p, eid.c_str());
        rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}

static string dump_sim_pin_count_query_ret(mipc_sim_pin_count_query_struct *ptr, void *cb_priv_ptr){
    android::RequestInfo *info = (android::RequestInfo *)cb_priv_ptr;
    string str("");
    str.append("request:").append(requestToString(info->pCI->requestNumber));
    str.append(",result_code:").append(std::to_string(ptr->result_code));
    str.append(",pin1:").append(std::to_string(ptr->pin1));
    str.append(",pin2:").append(std::to_string(ptr->pin2));
    str.append(",puk1:").append(std::to_string(ptr->puk1));
    str.append(",puk2:").append(std::to_string(ptr->puk2));
    return str;
}

static void mipc_sim_pin_count_query_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_pin_count_query_struct *result_ptr, void *cb_priv_ptr) {
    RFX_LOG_D(getTag(sim_ps_id).c_str(),"%s, %s", __FUNCTION__,dump_sim_pin_count_query_ret(result_ptr,cb_priv_ptr).c_str());
    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),result_ptr->result_code);
    } else {
        Parcel * p = new Parcel();
        p->writeInt32(4);
        p->writeInt32(result_ptr->pin1);
        p->writeInt32(result_ptr->pin2);
        p->writeInt32(result_ptr->puk1);
        p->writeInt32(result_ptr->puk2);
        rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}

static string dump_sim_imsi_get(mipc_sim_imsi_struct *ptr, void *cb_priv_ptr){
    android::RequestInfo *info = (android::RequestInfo *)cb_priv_ptr;
    string str("");
    str.append("request:").append(requestToString(info->pCI->requestNumber));
    str.append(",result_code:").append(std::to_string(ptr->result_code));
//xf.li@20231120 modify for T8TSK-291 start
    str.append(",imsi:").append("(has got)");
//xf.li@20231120 modify for T8TSK-291 end
    str.append(",mnc_len:").append(std::to_string(ptr->mnc_len));
    return str;
}

static void mipc_sim_imsi_get_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_imsi_struct *result_ptr, void *cb_priv_ptr) {
    RFX_LOG_D(getTag(sim_ps_id).c_str(),"%s, %s", __FUNCTION__, dump_sim_imsi_get(result_ptr,cb_priv_ptr).c_str());
    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),result_ptr->result_code);
    }else {
        Parcel * p = new Parcel();
        writeStringToParcel(p, (const char *)result_ptr->imsi);
        rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}

static void mipc_sim_msisdn_get_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_msisdn_struct_v *result_ptr, void *cb_priv_ptr) {
}
static void mipc_sim_atr_info_get_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_atr_info_struct *result_ptr, void *cb_priv_ptr) {
}

static string dump_sim_channel_open(mipc_sim_open_channel_info_struct *ptr, void *cb_priv_ptr){
    android::RequestInfo *info = (android::RequestInfo *)cb_priv_ptr;
    string str("");
    str.append("request:").append(requestToString(info->pCI->requestNumber));
    str.append(",result_code:").append(std::to_string(ptr->result_code));
    str.append(",sw:").append(std::to_string(ptr->sw));
    str.append(",channel:").append(std::to_string(ptr->channel));
    str.append(",resp:").append(string(strlen(ptr->resp) == 0 ? "" : ptr->resp));
    return str;
}

static void mipc_sim_channel_open_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_open_channel_info_struct *result_ptr, void *cb_priv_ptr) {
    RFX_LOG_D(getTag(sim_ps_id).c_str(),"%s, %s", __FUNCTION__, dump_sim_channel_open(result_ptr,cb_priv_ptr).c_str());
    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),result_ptr->result_code);
    }else {
        Parcel * p = new Parcel();
        p->writeInt32(3);
        p->writeInt32(result_ptr->channel);
        int sw1 = 0,sw2 = 0;
        string out;
        std::stringstream ss;
        ss << std::hex << result_ptr->sw;
        ss >> out;
        sscanf(out.c_str(), "%02x%02x", &(sw1), &(sw2));
        p->writeInt32(sw1);
        p->writeInt32(sw2);
        rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}

static void mipc_sim_channel_close_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_close_channel_info_struct *result_ptr, void *cb_priv_ptr) {
    RFX_LOG_D(getTag(sim_ps_id).c_str(),"%s, %d", __FUNCTION__, result_ptr->sw);
    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),result_ptr->result_code);
    }else {
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}

static string dump_sim_channel_restricted_access(mipc_sim_apdu_access_struct *ptr, void *cb_priv_ptr){
    android::RequestInfo *info = (android::RequestInfo *)cb_priv_ptr;
    string str("");
    str.append("request:").append(requestToString(info->pCI->requestNumber));
    str.append(",result_code:").append(std::to_string(ptr->result_code));
    str.append(",sw:").append(std::to_string(ptr->sw));
    str.append(",resp_len:").append(std::to_string(ptr->resp_len));
    str.append(",resp_apdu:").append(string(strlen(ptr->resp_apdu) == 0 ? "" : ptr->resp_apdu));
    return str;
}

const char HEX_DIGITS[16] = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F' };

unsigned char* byteArrayToHexString(unsigned char* array,int length)
{
    unsigned char* buf = (unsigned char*)calloc(1, length*2+1);
    assert(buf != NULL);
    int bufIndex = 0;
    int i = 0;
    for (i = 0 ; i < length; i++)
    {
        unsigned char b = array[i];
        buf[bufIndex++] = HEX_DIGITS[(b >> 4) & 0x0F];
        buf[bufIndex++] = HEX_DIGITS[b & 0x0F];
    }
    buf[bufIndex] = '\0';
    return buf;
}

static void mipc_sim_channel_restricted_access_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_apdu_access_struct *result_ptr, void *cb_priv_ptr) {
    RFX_LOG_D(getTag(sim_ps_id).c_str(),"%s, %s", __FUNCTION__, dump_sim_channel_restricted_access(result_ptr,cb_priv_ptr).c_str());
    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),result_ptr->result_code);
    }else {
        Parcel * p = new Parcel();
        int sw1 = 0,sw2 = 0;
        string out;
        std::stringstream ss;
        ss << std::hex << result_ptr->sw;
        ss >> out;
        sscanf(out.c_str(), "%02x%02x", &(sw1), &(sw2));
        p->writeInt32(sw1);
        p->writeInt32(sw2);

        char* temp = (char*)byteArrayToHexString((unsigned char*)result_ptr->resp_apdu, result_ptr->resp_len);
        RFX_LOG_D(getTag(sim_ps_id).c_str(),"%s, temp %s", __FUNCTION__, temp);
        writeStringToParcel(p, string(strlen(temp) == 0 ? "" : temp).c_str());
        if (temp != NULL) {
            free(temp);
        }

        rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}
static void mipc_sim_channel_generic_access_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_apdu_access_struct *result_ptr, void *cb_priv_ptr) {
}

static string dump_sim_extended_channel_generic_access(mipc_sim_extended_channel_generic_acess_struct *ptr, void *cb_priv_ptr){
    android::RequestInfo *info = (android::RequestInfo *)cb_priv_ptr;
    string str("");
    str.append("request:").append(requestToString(info->pCI->requestNumber));
    str.append(",result_code:").append(std::to_string(ptr->result_code));
    str.append(",sw:").append(std::to_string(ptr->sw));
    str.append(",resp_len:").append(std::to_string(ptr->resp_len));
    str.append(",resp_apdu:").append(string(strlen(ptr->resp_apdu) == 0 ? "" : ptr->resp_apdu));
    return str;
}

static void mipc_sim_extended_channel_generic_access_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_extended_channel_generic_acess_struct *result_ptr,
        void *cb_priv_ptr) {
    RFX_LOG_D(getTag(sim_ps_id).c_str(),"%s, %s", __FUNCTION__, dump_sim_extended_channel_generic_access(result_ptr,cb_priv_ptr).c_str());
    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),result_ptr->result_code);
    }else {
        Parcel * p = new Parcel();
        int sw1 = 0,sw2 = 0;
        string out;
        std::stringstream ss;
        ss << std::hex << result_ptr->sw;
        ss >> out;
        sscanf(out.c_str(), "%02x%02x", &(sw1), &(sw2));
        p->writeInt32(sw1);
        p->writeInt32(sw2);

        char* temp = (char*)byteArrayToHexString((unsigned char*)result_ptr->resp_apdu, result_ptr->resp_len);
        RFX_LOG_D(getTag(sim_ps_id).c_str(),"%s, temp %s", __FUNCTION__, temp);
        writeStringToParcel(p, string(strlen(temp) == 0 ? "" : temp).c_str());
        if (temp != NULL) {
            free(temp);
        }
        rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}

static void mipc_sim_long_apdu_read_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_long_apdu_access_struct_v *result_ptr, void *cb_priv_ptr) {
}

static void mipc_sim_app_list_get_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_app_list_struct *result_ptr, void *cb_priv_ptr) {
}
static void mipc_sim_file_status_get_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_file_status_struct *result_ptr, void *cb_priv_ptr) {
}
static void mipc_sim_reset_get_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_reset_struct *result_ptr, void *cb_priv_ptr) {
}
static void mipc_sim_reset_set_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_result_enum *result_ptr, void *cb_priv_ptr) {
}
static void mipc_sim_terminal_capability_get_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_terminal_capability_struct *result_ptr, void *cb_priv_ptr) {
}
static void mipc_sim_terminal_capability_set_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_result_enum *result_ptr, void *cb_priv_ptr) {
}
static void mipc_sim_pin_ext_set_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_pin_info_struct *result_ptr, void *cb_priv_ptr) {
}
static void mipc_sim_pin_ext_get_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_pin_info_struct *result_ptr, void *cb_priv_ptr) {
}
static void mipc_sim_gsm_auth_get_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_gsm_auth_info_struct *result_ptr, void *cb_priv_ptr) {
}

static string dump_sim_ext_auth_get(mipc_sim_ext_auth_info_struct *ptr, void *cb_priv_ptr){
    android::RequestInfo *info = (android::RequestInfo *)cb_priv_ptr;
    string str("");
    str.append("request:").append(requestToString(info->pCI->requestNumber));
    str.append(",result_code:").append(std::to_string(ptr->result_code));
    str.append(",sw:").append(std::to_string(ptr->sw));
    str.append(",resp_len:").append(std::to_string(ptr->resp_len));
    str.append(",resp:").append(string(strlen(ptr->resp) == 0 ? "" : ptr->resp));
    return str;
}

static void mipc_sim_ext_auth_get_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_ext_auth_info_struct *result_ptr, void *cb_priv_ptr) {
    RFX_LOG_D(getTag(sim_ps_id).c_str(),"%s, %s", __FUNCTION__, dump_sim_ext_auth_get(result_ptr,cb_priv_ptr).c_str());
    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),result_ptr->result_code);
    }else {
        android::RequestInfo *info = (android::RequestInfo *)cb_priv_ptr;
        int request = info->pCI->requestNumber;
        Parcel * p = new Parcel();
        if(request == RIL_REQUEST_SIM_AUTHENTICATION) {
            int sw1 = 0,sw2 = 0;
            string out;
            std::stringstream ss;
            ss << std::hex << result_ptr->sw;
            ss >> out;
            sscanf(out.c_str(), "%02x%02x", &(sw1), &(sw2));
            p->writeInt32(sw1);
            p->writeInt32(sw2);
            writeStringToParcel(p, string(strlen(result_ptr->resp) == 0 ? "" : result_ptr->resp).c_str());
        } else { //RIL_REQUEST_ISIM_AUTHENTICATION
            char* temp = (char*)byteArrayToHexString((unsigned char*)result_ptr->resp, result_ptr->resp_len);
            RFX_LOG_D(getTag(sim_ps_id).c_str(),"%s, temp %s", __FUNCTION__, temp);
            writeStringToParcel(p, string(strlen(temp) == 0 ? "" : temp).c_str());
            if (temp != NULL) {
                free(temp);
            }
        }
        rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}

static string dump_sim_get_facility(mipc_sim_get_facility_info_struct *ptr, void *cb_priv_ptr){
    android::RequestInfo *info = (android::RequestInfo *)cb_priv_ptr;
    string str("");
    str.append("request:").append(requestToString(info->pCI->requestNumber));
    str.append(",result_code:").append(std::to_string(ptr->result_code));
    str.append(",status:").append(ptr->status == 0 ? "inactive":"active");
    return str;
}

static void mipc_sim_get_facility_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_get_facility_info_struct *result_ptr, void *cb_priv_ptr) {
    RFX_LOG_D(getTag(sim_ps_id).c_str(),"%s, %s", __FUNCTION__, dump_sim_get_facility(result_ptr,cb_priv_ptr).c_str());
    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),result_ptr->result_code);
    }else {
        Parcel * p = new Parcel();
        p->writeInt32(1);
        p->writeInt32(result_ptr->status);
        rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}

static string dump_sim_set_facility(mipc_sim_set_facility_info_struct *ptr, void *cb_priv_ptr){
    android::RequestInfo *info = (android::RequestInfo *)cb_priv_ptr;
    string str("");
    str.append("request:").append(requestToString(info->pCI->requestNumber));
    str.append(",result_code:").append(std::to_string(ptr->result_code));
    str.append(",retry_count:").append(std::to_string(ptr->retry_count));
    return str;
}

static void mipc_sim_set_facility_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_set_facility_info_struct *result_ptr, void *cb_priv_ptr) {
    RFX_LOG_D(getTag(sim_ps_id).c_str(),"%s, %s", __FUNCTION__, dump_sim_set_facility(result_ptr,cb_priv_ptr).c_str());
    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),result_ptr->result_code);
    }else {
        Parcel * p = new Parcel();
        p->writeInt32(1);
        p->writeInt32(result_ptr->retry_count);
        rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}

static void mipc_sim_get_euicc_slots_status_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_get_euicc_slots_status_struct *result_ptr, void *cb_priv_ptr) {
}
static void mipc_sim_access_profile_connect_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_access_profile_connect_struct *result_ptr, void *cb_priv_ptr) {
}
static void mipc_sim_access_profile_disconnect_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_access_profile_disconnect_struct *result_ptr,
        void *cb_priv_ptr) {
}
static void mipc_sim_access_profile_power_on_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_access_profile_power_on_struct *result_ptr,
        void *cb_priv_ptr) {
}
static void mipc_sim_access_profile_power_off_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_access_profile_power_off_struct *result_ptr,
        void *cb_priv_ptr) {
}
static void mipc_sim_access_profile_reset_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_access_profile_reset_struct *result_ptr, void *cb_priv_ptr) {
}
static void mipc_sim_access_profile_apdu_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_access_profile_apdu_struct *result_ptr, void *cb_priv_ptr) {
}
static void mipc_sim_set_sim_power_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_set_sim_power_struct *result_ptr, void *cb_priv_ptr) {
}
static void mipc_sim_set_physical_slots_mapping_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_set_physical_slots_mapping_struct *result_ptr,
        void *cb_priv_ptr) {
}
static void mipc_sim_uicc_file_access_record_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_uicc_file_access_record_struct *result_ptr,
        void *cb_priv_ptr) {
}
static void mipc_sim_uicc_file_access_binary_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_uicc_file_access_binary_struct *result_ptr,
        void *cb_priv_ptr) {
}
static void mipc_sim_get_physical_slots_mapping_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_get_physical_slots_mapping_struct *result_ptr,
        void *cb_priv_ptr) {
}

static string dump_sim_euicc_slots_status_ind_cb(mipc_sim_euicc_slots_status_ind_struct *ptr, void *cb_priv_ptr){
    string str("");
    str.append(",result_code:").append(std::to_string(ptr->result_code));
    str.append(",slots_info_count:").append(std::to_string(ptr->slots_info_count));
    for(uint8_t i = 0; i < ptr->slots_info_count ; i++) {
        str.append(",pin_state[").append(std::to_string(i)).append("]: ").append(std::string((ptr->slots_info_list)[i].card_state));
        str.append(",slots_state[").append(std::to_string(i)).append("]: ").append(std::to_string((ptr->slots_info_list)[i].slots_state));
        str.append(",logical_idx[").append(std::to_string(i)).append("]: ").append(std::to_string((ptr->slots_info_list)[i].logical_idx));
        str.append(",atr[").append(std::to_string(i)).append("]: ").append(std::string((ptr->slots_info_list)[i].atr));
        str.append(",eid[").append(std::to_string(i)).append("]: ").append(std::string((ptr->slots_info_list)[i].eid));
        str.append(",iccid[").append(std::to_string(i)).append("]: ").append(std::string((ptr->slots_info_list)[i].iccid));
    }
    return str;
}

static void mipc_sim_euicc_slots_status_ind_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_euicc_slots_status_ind_struct *result_ptr, void *cb_priv_ptr) {
    RFX_LOG_D(getTag(sim_ps_id).c_str(), "%s MIPC_SIM_EUICC_SLOTS_STATUS_IND, %s", __FUNCTION__,dump_sim_euicc_slots_status_ind_cb(result_ptr, cb_priv_ptr).c_str());
}

static void mipc_sim_iccid_ind_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_iccid_ind_struct *result_ptr, void *cb_priv_ptr) {
//xf.li@20231120 modify for T8TSK-291 start
    RFX_LOG_D(getTag(sim_ps_id).c_str(), "%s MIPC_SIM_ICCID_IND, ICCID= has got", __FUNCTION__);
//xf.li@20231120 modify for T8TSK-291 end
    String8 iccid("");
    iccid.append(string(result_ptr->iccid).c_str());
    RFX_OBJ_GET_INSTANCE(RfxRootController)->getStatusManager(mipc_sim_id_to_slot_id(sim_ps_id))->setString8Value(RFX_STATUS_KEY_SIM_ICCID, iccid);

    string iccidKey(PROPERTY_ICCID_PREIFX);
    iccidKey.append(to_string(mipc_sim_id_to_slot_id(sim_ps_id)+1));
    rfx_property_set(iccidKey.c_str(), iccid.string());
}

static void mipc_sim_imsi_get_after_sim_statechanged_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_imsi_struct *result_ptr, void *cb_priv_ptr) {
    //xf.li@20231120 modify for T8TSK-291 start
    RFX_LOG_D(getTag(sim_ps_id).c_str(),"%s imsi (has got),%d", __FUNCTION__,result_ptr->result_code);
    //xf.li@20231120 modify for T8TSK-291 end
    string mccMncKey("");
    char mccmnc[7] = { 0 };
    mccMncKey.append(PROPERTY_GSM_MCC_MNC_PREIFX);
    mccMncKey.append(to_string(mipc_sim_id_to_slot_id(sim_ps_id)));
    RFX_LOG_D(getTag(sim_ps_id).c_str(),"%s mccMncKey: %s", __FUNCTION__,mccMncKey.c_str());
    String8 imsi("");
    if(result_ptr->result_code == MIPC_RESULT_SUCCESS) {
        char old_value[RFX_PROPERTY_VALUE_MAX] = {0};
        rfx_property_get(mccMncKey.c_str(), old_value, "");
        RFX_LOG_D(getTag(sim_ps_id).c_str(),"%s S imsi", __FUNCTION__);
        imsi.append(string(result_ptr->imsi).c_str());
//xf.li@20231120 modify for T8TSK-291 start
        RFX_LOG_D(getTag(sim_ps_id).c_str(),"%s E imsi: (has got), mnc len: %d", __FUNCTION__, result_ptr->mnc_len);
//xf.li@20231120 modify for T8TSK-291 end
        memcpy(mccmnc,result_ptr->imsi,3+result_ptr->mnc_len);
        RFX_LOG_D(getTag(sim_ps_id).c_str(), "%s old_mccmcn:%s, new_mccmnc:%s", __FUNCTION__,(old_value==NULL ? "":string(old_value).c_str()), ((mccmnc==NULL ? "":string(mccmnc).c_str())));
        if(string(mccmnc) != string(old_value) ) {
            rfx_property_set(mccMncKey.c_str(), mccmnc);
        }
    } else {
        rfx_property_set(mccMncKey.c_str(), "");
    }
    RFX_OBJ_GET_INSTANCE(RfxRootController)->getStatusManager(mipc_sim_id_to_slot_id(sim_ps_id))->setString8Value(RFX_STATUS_KEY_GSM_IMSI, imsi);
    rfx_enqueue_urc_message(RIL_UNSOL_RESPONSE_SIM_STATUS_CHANGED,NULL,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
}

void getMccMnc(mipc_sim_ps_id_enum sim_ps_id) {
    RFX_LOG_D(getTag(sim_ps_id).c_str(), "%s", __FUNCTION__);
    string mccMncKey("");
    mccMncKey.append(PROPERTY_GSM_MCC_MNC_PREIFX);
    mccMncKey.append(to_string(mipc_sim_id_to_slot_id(sim_ps_id)));
    char value[RFX_PROPERTY_VALUE_MAX] = {0};
    int ret = 0;
    RFX_LOG_D(getTag(sim_ps_id).c_str(), "%s mccMncKey %s", __FUNCTION__,mccMncKey.c_str());
    rfx_property_get(mccMncKey.c_str(), value, "");
    RFX_LOG_D(getTag(sim_ps_id).c_str(), "%s %s", __FUNCTION__,value==NULL ? "":string(value).c_str());
    uint8_t mode  = 0; //GSM
    ret = mipc_sim_imsi_get_async(sim_ps_id, mipc_sim_imsi_get_after_sim_statechanged_cb,
        NULL, mode);
    if(ret == MIPC_API_RESULT_SUCCESS) {
        return;
    }
    //RIL_Errno err = RIL_E_SUCCESS;
    //rfx_enqueue_urc_message(RIL_UNSOL_RESPONSE_SIM_STATUS_CHANGED,NULL,mipc_sim_id_to_slot_id(sim_ps_id),err);
}

static void mipc_sim_status_ind_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_status_struct *result_ptr, void *cb_priv_ptr) {
    RFX_LOG_D(getTag(sim_ps_id).c_str(), "%s RIL_UNSOL_RESPONSE_SIM_STATUS_CHANGED, sim_status=%d, sim_id=%d,ps_id=%d", __FUNCTION__,
            result_ptr->sim_status, result_ptr->sim_id, result_ptr->ps_id);
    mipc_sim_status_get_async(sim_ps_id, mipc_sim_status_get_cb, NULL, 1);
    getMccMnc(sim_ps_id);
}

static void mipc_sim_state_ind_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_state_struct *result_ptr, void *cb_priv_ptr) {
    RFX_LOG_D(getTag(sim_ps_id).c_str(), "%s MIPC_SIM_STATE_IND, sim_state=%d, sim_id=%d,ps_id=%d, is_present=%lu, sub_state=%d", __FUNCTION__,
            result_ptr->sim_state, result_ptr->sim_id,result_ptr->ps_id, result_ptr->is_present,result_ptr->sub_state);
}
static void mipc_sim_status_change_with_cause_ind_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_status_change_with_cause_ind_struct *result_ptr,
        void *cb_priv_ptr) {
    RFX_LOG_D(getTag(sim_ps_id).c_str(), "%s MIPC_SIM_STATUS_CHANGE_WITH_CAUSE_IND, is_sim_inserted=%d, cause=%d,result_code=%d", __FUNCTION__,
            result_ptr->is_sim_inserted, result_ptr->cause,result_ptr->result_code);
    RIL_Errno err = RIL_E_SUCCESS;
    if(result_ptr->cause == mipc_sim_cause_const_enum::MIPC_SIM_CAUSE_SIM_PLUG_OUT) {
        rfx_enqueue_urc_message(RIL_UNSOL_SIM_PLUG_OUT,NULL,mipc_sim_id_to_slot_id(sim_ps_id),err);
    } else if(result_ptr->cause == mipc_sim_cause_const_enum::MIPC_SIM_CAUSE_SIM_PLUG_IN) {
        rfx_enqueue_urc_message(RIL_UNSOL_SIM_PLUG_IN,NULL,mipc_sim_id_to_slot_id(sim_ps_id),err);
    }
}

static void mipc_sim_physical_slots_mapping_done_ind_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_physical_slots_mapping_done_ind_struct *result_ptr,
        void *cb_priv_ptr) {
    RFX_LOG_D(getTag(sim_ps_id).c_str(), "%s MIPC_SIM_PHYSICAL_SLOTS_MAPPING_DONE_IND,result_code=%d", __FUNCTION__,result_ptr->result_code);
}

static void mipc_stk_sim_refresh_ind_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_stk_sim_refresh_ind_struct *result_ptr, void *cb_priv_ptr) {
    RFX_LOG_D(getTag(sim_ps_id).c_str(), "%s MIPC_STK_SIM_REFRESH_IND,result_code=%d, sim_refresh_result=%d, ef_id=%d, aid=%d", __FUNCTION__,
            result_ptr->result_code,result_ptr->sim_refresh_result, result_ptr->ef_id, ((strlen(result_ptr->aid) == 0) ? "":result_ptr->aid));
    RIL_Errno err = RIL_E_SUCCESS;
    Parcel *parcel = new Parcel();
    parcel->writeInt32(result_ptr->sim_refresh_result);
    parcel->writeInt32((result_ptr->ef_id == UINT32_MAX) ? -1:result_ptr->ef_id);
    writeStringToParcel(parcel, ((result_ptr->aid == NULL || (result_ptr->aid != NULL && strlen(result_ptr->aid) == 0)) ? "": result_ptr->aid));
    rfx_enqueue_urc_message(RIL_UNSOL_SIM_REFRESH,parcel,mipc_sim_id_to_slot_id(sim_ps_id),err);
}

static void mipc_sim_csim_imsi_change_ind_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_csim_imsi_change_ind_struct *result_ptr, void *cb_priv_ptr) {
    RFX_LOG_D(getTag(sim_ps_id).c_str(), "%s MIPC_SIM_CSIM_IMSI_CHANGE_IND,status=%d", __FUNCTION__, result_ptr->status);
    RIL_Errno err = RIL_E_SUCCESS;
    Parcel *parcel = new Parcel();
    parcel->writeInt32(1);
    parcel->writeInt32(result_ptr->status);
    rfx_enqueue_urc_message(RIL_UNSOL_UICC_SUBSCRIPTION_STATUS_CHANGED,parcel,mipc_sim_id_to_slot_id(sim_ps_id),err);
}

}

RFX_IMPLEMENT_CLASS("RpSimController", RpSimController, RfxController);

void RpSimController::registerInd(mipc_sim_ps_id_enum sim_ps_id, void *cb_priv_ptr) {
    mipc_api_result_enum ret;
    ret = mipc_sim_status_register(sim_ps_id, mipc_sim_status_ind_cb, cb_priv_ptr);
    if (ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_E(mLog_tag.c_str(),"register MIPC_SIM_STATUS_IND fail");
    }
    ret = mipc_sim_state_register(sim_ps_id, mipc_sim_state_ind_cb, cb_priv_ptr);
    if (ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_E(mLog_tag.c_str(),"register MIPC_SIM_STATE_IND fail");
    }
    ret = mipc_sim_euicc_slots_status_register(sim_ps_id, mipc_sim_euicc_slots_status_ind_cb, cb_priv_ptr);
    if (ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_E(mLog_tag.c_str(),"register MIPC_SIM_EUICC_SLOTS_STATUS_IND fail");
    }
    ret = mipc_sim_iccid_register(sim_ps_id, mipc_sim_iccid_ind_cb, cb_priv_ptr);
    if (ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_E(mLog_tag.c_str(),"register MIPC_SIM_ICCID_IND fail");
    }
    ret = mipc_sim_status_change_with_cause_register(sim_ps_id, mipc_sim_status_change_with_cause_ind_cb, cb_priv_ptr);
    if (ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_E(mLog_tag.c_str(),"register MIPC_SIM_STATUS_CHANGE_WITH_CAUSE_IND fail");
    }
    ret = mipc_sim_physical_slots_mapping_done_register(sim_ps_id, mipc_sim_physical_slots_mapping_done_ind_cb, cb_priv_ptr);
    if (ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_E(mLog_tag.c_str(),"register MIPC_SIM_PHYSICAL_SLOTS_MAPPING_DONE_IND fail");
    }
    ret = mipc_stk_sim_refresh_register(sim_ps_id, mipc_stk_sim_refresh_ind_cb, cb_priv_ptr);
    if (ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_E(mLog_tag.c_str(),"register MIPC_STK_SIM_REFRESH_IND fail");
    }
    ret = mipc_sim_csim_imsi_change_register(sim_ps_id, mipc_sim_csim_imsi_change_ind_cb, cb_priv_ptr);
    if (ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_E(mLog_tag.c_str(),"register MIPC_SIM_CSIM_IMSI_CHANGE_IND fail");
    }
}

RpSimController::RpSimController() {
    mLog_tag = "";
}

RpSimController::~RpSimController() {
    // TODO Auto-generated destructor stub
}

void RpSimController::onInit() {
    RfxController::onInit();  // Required: invoke super class implementation
    mLog_tag.append("[slot").append(to_string(getSlotId())).append("]").append(RFX_LOG_TAG);
    RFX_LOG_D(mLog_tag.c_str(), "%s", __FUNCTION__);
    string mccMncKey("");
    mccMncKey.append(PROPERTY_GSM_MCC_MNC_PREIFX);
    mccMncKey.append(to_string(getSlotId()));
    rfx_property_set(mccMncKey.c_str(), "");

    string iccidKey(PROPERTY_ICCID_PREIFX);
    iccidKey.append(to_string(getSlotId()+1));
    rfx_property_set(iccidKey.c_str(), "");

    string fullUiccCardType(PROPERTY_GSM_RIL_FULLUICCTYPE_PREIFX);
    string propUicc(PROPERTY_GSM_RIL_UICCTYPE_PREIFX);
    if(getSlotId() > 0) {
        propUicc.append(".").append(std::to_string(getSlotId()+1));
        fullUiccCardType.append(".").append(std::to_string(getSlotId()+1));
    }
    rfx_property_set(fullUiccCardType.c_str(), "");
    rfx_property_set(propUicc.c_str(), "");

    registerInd(slot_id_to_mipc_sim_id(getSlotId()),NULL);
    const int request_id_list[] = {
            RIL_REQUEST_GET_SIM_STATUS,
            RIL_REQUEST_ENTER_SIM_PIN,
            RIL_REQUEST_ENTER_SIM_PIN2,
            RIL_REQUEST_ENTER_SIM_PUK,
            RIL_REQUEST_ENTER_SIM_PUK2,
            RIL_REQUEST_CHANGE_SIM_PIN,
            RIL_REQUEST_CHANGE_SIM_PIN2,
            RIL_REQUEST_ENTER_NETWORK_DEPERSONALIZATION,
            RIL_REQUEST_GET_IMSI,
            RIL_REQUEST_SIM_IO,
            RIL_REQUEST_QUERY_FACILITY_LOCK,
            RIL_REQUEST_SET_FACILITY_LOCK,
            RIL_REQUEST_SIM_AUTHENTICATION,
            RIL_REQUEST_ISIM_AUTHENTICATION,
            RIL_REQUEST_SIM_TRANSMIT_APDU_BASIC, //MIPC_SIM_EXTENDED_CHANNEL_GENERIC_ACCESS_REQ
            RIL_REQUEST_SIM_TRANSMIT_APDU_CHANNEL,
            RIL_REQUEST_SIM_OPEN_CHANNEL,
            RIL_REQUEST_SIM_CLOSE_CHANNEL,
            RIL_REQUEST_SIM_GET_ICCID,
            RIL_REQUEST_QUERY_EID,
            RIL_REQUEST_QUERY_SIM_RETRY_COUNT,
    };

    // register request id list
    registerToHandleRequest(request_id_list,sizeof(request_id_list) / sizeof(int));
//xf.li@20230925 add for sim status is 2 start
    mipc_sim_status_get_async(slot_id_to_mipc_sim_id(getSlotId()), mipc_sim_status_get_cb, NULL, 1);
    getMccMnc(slot_id_to_mipc_sim_id(getSlotId()));
//xf.li@20230925 add for sim status is 2 end
    RFX_LOG_D(mLog_tag.c_str(), "%s done", __FUNCTION__);

}

void RpSimController::onDeinit() {
    RFX_LOG_D(mLog_tag.c_str(), "%s", __FUNCTION__);
    RfxController::onDeinit();
}

bool RpSimController::onHandleRequest(const android::sp<RfxMessage> &message) {
    RFX_LOG_D(mLog_tag.c_str(), "Handle request %s", IdToString(message->getId()).c_str());

     RfxDispatchThread::addMessageToPendingQueue(message);

     switch (message->getId()) {
     case RIL_REQUEST_GET_SIM_STATUS: {
         handleGetSimStatus(message);
         break;
     }
     case RIL_REQUEST_ENTER_SIM_PIN: {
         handleEnterSimPinX(message);
         break;
     }
     case RIL_REQUEST_ENTER_SIM_PIN2: {
         handleEnterSimPinX(message);
         break;
     }
     case RIL_REQUEST_ENTER_SIM_PUK: {
         handleEnterSimPUKX(message);
         break;
     }
     case RIL_REQUEST_ENTER_SIM_PUK2: {
         handleEnterSimPUKX(message);
         break;
     }
     case RIL_REQUEST_CHANGE_SIM_PIN: {
         handleChangeSimPinX(message);
         break;
     }
     case RIL_REQUEST_CHANGE_SIM_PIN2: {
         handleChangeSimPinX(message);
         break;
     }
     case RIL_REQUEST_ENTER_NETWORK_DEPERSONALIZATION: {
         handleEnterSimPinX(message);
         break;
     }
     case RIL_REQUEST_GET_IMSI: {
         handleGetImsi(message);
         break;
     }
     case RIL_REQUEST_SIM_IO: {
         handleSimIo(message);
         break;
     }
     case RIL_REQUEST_QUERY_FACILITY_LOCK: {
         handleQueryFacilityLock(message);
         break;
     }
     case RIL_REQUEST_SET_FACILITY_LOCK: {
         handleSetFacilityLock(message);
         break;
     }
     case RIL_REQUEST_SIM_AUTHENTICATION: {
         handleSimAuth(message);
         break;
     }
     case RIL_REQUEST_ISIM_AUTHENTICATION: {
         handleIsimAuth(message);
         break;
     }
     case RIL_REQUEST_SIM_TRANSMIT_APDU_BASIC: {
         handleSimTranApduBasic(message);
         break;
     }
     case RIL_REQUEST_SIM_TRANSMIT_APDU_CHANNEL: {
         handleSimTranApduChann(message);
         break;
     }
     case RIL_REQUEST_SIM_OPEN_CHANNEL: {
         handleSimOpenChannel(message);
         break;
     }
     case RIL_REQUEST_SIM_CLOSE_CHANNEL: {
         handleSimCloseChannel(message);
         break;
     }
     case RIL_REQUEST_SIM_GET_ICCID: {
         handleSimGetIccid(message);
         break;
     }
     case RIL_REQUEST_QUERY_EID: {
         handleQueryEid(message);
         break;
     }
     case RIL_REQUEST_QUERY_SIM_RETRY_COUNT: {
         handleQuerySimRetryCount(message);
         break;
     }
     default:
         RFX_LOG_E(mLog_tag.c_str(), "unknown request, ignore!");
         rfx_enqueue_response_message(NULL,message->getRilToken(),(RIL_SOCKET_ID)message->getSlotId(),RIL_E_GENERIC_FAILURE);
         break;
     }
     return true;
}

void RpSimController::handleGetSimStatus(const android::sp<RfxMessage> &message) {
    RFX_LOG_E(mLog_tag.c_str(), "%s", __FUNCTION__);
    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;
    //1 means full mode
    do {
        if(message->getRilToken() == NULL) {
            RFX_LOG_E(mLog_tag.c_str(), "%s ril token is null, parameter error", __FUNCTION__);
            break;
        }
        ret = mipc_sim_status_get_async(slot_id_to_mipc_sim_id(message->getSlotId()), mipc_sim_status_get_cb, (void*) message->getRilToken(), 1);
    } while(0);

    if(ret != MIPC_API_RESULT_SUCCESS) {
         RFX_LOG_E(mLog_tag.c_str(), "%s fail", __FUNCTION__);
         rfx_enqueue_response_message(NULL,message->getRilToken(),(RIL_SOCKET_ID)message->getSlotId(),RIL_E_GENERIC_FAILURE);
     }

    RFX_LOG_D(mLog_tag.c_str(), "%s done", __FUNCTION__);
}

void RpSimController::handleEnterSimPinX(const android::sp<RfxMessage> &message) {
    RFX_LOG_D(mLog_tag.c_str(), "%s", __FUNCTION__);
    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;
    int32_t countStrings = 0;
    status_t status;
    char* pinX = NULL;

    do {
        if(message->getRilToken() == NULL) {
            RFX_LOG_E(mLog_tag.c_str(), "%s ril token is null, parameter error", __FUNCTION__);
            break;
        }

        Parcel *p = message->getParcel();

        if(p == NULL) {
            break;
        }
        status = p->readInt32 (&countStrings);
        if (status != android::NO_ERROR) {
            break;
        }
        if(countStrings < 1) { //don't card aid,only card pin
            break;
        }
        pinX = strdupReadString(p);
        RFX_LOG_D(mLog_tag.c_str(), "pin:%s", (pinX==NULL? "": pinX));
        if(pinX == NULL) {
            break;
        }
        mipc_sim_pin_type_const_enum pin_type = mipc_sim_pin_type_const_enum::MIPC_SIM_PIN_TYPE_NONE;
        if(message->getId() == RIL_REQUEST_ENTER_SIM_PIN) {
            pin_type = mipc_sim_pin_type_const_enum::MIPC_SIM_PIN_TYPE_PIN1;
        } else if(message->getId() == RIL_REQUEST_ENTER_SIM_PIN2) {
            pin_type = mipc_sim_pin_type_const_enum::MIPC_SIM_PIN_TYPE_PIN2;
        }else if( message->getId() == RIL_REQUEST_ENTER_NETWORK_DEPERSONALIZATION) {
            pin_type = mipc_sim_pin_type_const_enum::MIPC_SIM_PIN_TYPE_NW; //TBD
        }
        ret = mipc_sim_verify_pin_async(slot_id_to_mipc_sim_id(message->getSlotId()), mipc_sim_verify_pinX_cb, (void*) message->getRilToken(),
                pin_type, pinX);
    }while(0);

    if(ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_E(mLog_tag.c_str(), "%s fail", __FUNCTION__);
        rfx_enqueue_response_message(NULL,message->getRilToken(),(RIL_SOCKET_ID)message->getSlotId(),RIL_E_GENERIC_FAILURE);
    }
    if(pinX) {
        free(pinX);
    }
    RFX_LOG_D(mLog_tag.c_str(), "%s done", __FUNCTION__);
}

void RpSimController::handleEnterSimPin2(const android::sp<RfxMessage> &message) {
}

void RpSimController::handleEnterSimPUKX(const android::sp<RfxMessage> &message) {
    RFX_LOG_D(mLog_tag.c_str(), "%s", __FUNCTION__);
    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;
    int32_t countStrings = 0;
    status_t status;
    char* pukX = NULL;
    char* pinX = NULL;

    do {
        if(message->getRilToken() == NULL) {
            RFX_LOG_E(mLog_tag.c_str(), "%s ril token is null, parameter error", __FUNCTION__);
            break;
        }

        Parcel *p = message->getParcel();

        if(p == NULL) {
            break;
        }
        status = p->readInt32 (&countStrings);
        if (status != android::NO_ERROR) {
            break;
        }
        if(countStrings < 2) { //don't card aid,only card puk, newpin
            break;
        }
        pukX = strdupReadString(p);
        RFX_LOG_D(mLog_tag.c_str(), "pukX:%s", (pukX==NULL? "": pukX));
        if(pukX == NULL) {
            break;
        }
        pinX = strdupReadString(p);
        RFX_LOG_D(mLog_tag.c_str(), "pin:%s", (pinX==NULL? "": pinX));
        if(pinX == NULL) {
            break;
        }
        mipc_sim_pin_type_const_enum pin_type = mipc_sim_pin_type_const_enum::MIPC_SIM_PIN_TYPE_NONE;
        if(message->getId() == RIL_REQUEST_ENTER_SIM_PUK) {
            pin_type = mipc_sim_pin_type_const_enum::MIPC_SIM_PIN_TYPE_PUK1;
        }else if(message->getId() == RIL_REQUEST_ENTER_SIM_PUK2) {
            pin_type = mipc_sim_pin_type_const_enum::MIPC_SIM_PIN_TYPE_PUK2;
        }

        ret = mipc_sim_unblock_pin_async(slot_id_to_mipc_sim_id(message->getSlotId()), mipc_sim_unblock_pinX_cb, (void*) message->getRilToken(),
                pin_type,  pukX, pinX);

    }while(0);
    if(ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_E(mLog_tag.c_str(), "%s fail", __FUNCTION__);
        rfx_enqueue_response_message(NULL,message->getRilToken(),(RIL_SOCKET_ID)message->getSlotId(),RIL_E_GENERIC_FAILURE);
    }
    if(pinX) {
        free(pinX);
    }
    if(pukX) {
        free(pukX);
    }
    RFX_LOG_D(mLog_tag.c_str(), "%s done", __FUNCTION__);
}

void RpSimController::handleEnterSimPUK2(const android::sp<RfxMessage> &message) {
}

void RpSimController::handleChangeSimPinX(const android::sp<RfxMessage> &message) {
    RFX_LOG_D(mLog_tag.c_str(), "%s", __FUNCTION__);
    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;
    int32_t countStrings = 0;
    status_t status;
    char* old_pinX = NULL;
    char* new_pinX = NULL;

    do {
        if(message->getRilToken() == NULL) {
            RFX_LOG_E(mLog_tag.c_str(), "%s ril token is null, parameter error", __FUNCTION__);
            break;
        }
        Parcel *p = message->getParcel();

        if(p == NULL) {
            break;
        }
        status = p->readInt32 (&countStrings);
        if (status != android::NO_ERROR) {
            break;
        }
        if(countStrings < 2) { //don't card aid,only card pin
            break;
        }
        old_pinX = strdupReadString(p);
        new_pinX = strdupReadString(p);
        RFX_LOG_D(mLog_tag.c_str(), "old_pinX:%s, new_pinX:%s", (old_pinX==NULL? "": old_pinX),(new_pinX==NULL? "": new_pinX));
        if(old_pinX == NULL || new_pinX == NULL) {
            break;
        }
        mipc_sim_pin_type_const_enum pin_type = mipc_sim_pin_type_const_enum::MIPC_SIM_PIN_TYPE_NONE;
        if(message->getId() == RIL_REQUEST_CHANGE_SIM_PIN) {
            pin_type = mipc_sim_pin_type_const_enum::MIPC_SIM_PIN_TYPE_PIN1;
        } else if(message->getId() == RIL_REQUEST_CHANGE_SIM_PIN2) {
            pin_type = mipc_sim_pin_type_const_enum::MIPC_SIM_PIN_TYPE_PIN2;
        }
        ret = mipc_sim_change_pin_async(slot_id_to_mipc_sim_id(message->getSlotId()), mipc_sim_chg_pinX_cb, (void*) message->getRilToken(),
                pin_type, old_pinX, new_pinX);
    }while(0);

    if(ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_E(mLog_tag.c_str(), "%s fail", __FUNCTION__);
        rfx_enqueue_response_message(NULL,message->getRilToken(),(RIL_SOCKET_ID)message->getSlotId(),RIL_E_GENERIC_FAILURE);
    }
    if(old_pinX) {
        free(old_pinX);
    }
    if(new_pinX) {
        free(new_pinX);
    }
    RFX_LOG_D(mLog_tag.c_str(), "%s done", __FUNCTION__);
}

void RpSimController::handleChangeSimPin2(const android::sp<RfxMessage> &message) {
}

void RpSimController::handleEnterNetworkDePeronal(const android::sp<RfxMessage> &message) {
}

void RpSimController::handleGetImsi(const android::sp<RfxMessage> &message) {
    RFX_LOG_D(mLog_tag.c_str(), "%s", __FUNCTION__);
    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;

    do {
        if(message->getRilToken() == NULL) {
            RFX_LOG_E(mLog_tag.c_str(), "%s ril token is null, parameter error", __FUNCTION__);
            break;
        }
        //TBD
        uint8_t mode  = 0; //GSM
        ret = mipc_sim_imsi_get_async(slot_id_to_mipc_sim_id(message->getSlotId()), mipc_sim_imsi_get_cb, (void*) message->getRilToken(), mode);
    }while(0);

    if(ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_E(mLog_tag.c_str(), "%s fail", __FUNCTION__);
        rfx_enqueue_response_message(NULL,message->getRilToken(),(RIL_SOCKET_ID)message->getSlotId(),RIL_E_GENERIC_FAILURE);
    }
    RFX_LOG_D(mLog_tag.c_str(), "%s done", __FUNCTION__);
}

void RpSimController::handleSimIo(const android::sp<RfxMessage> &message) {
    RFX_LOG_D(mLog_tag.c_str(), "%s", __FUNCTION__);
    int32_t t;
    int size;
    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;
    status_t status;
    mipc_sim_app_type_const_enum app_id = mipc_sim_app_type_const_enum::MIPC_SIM_APP_TYPE_MF;//TBD
    uint8_t session_id = UINT8_MAX; //TBD
    mipc_sim_access_command_const_enum cmd = mipc_sim_access_command_const_enum::mipc_sim_access_command_const_NONE;//TBD
    uint16_t file_id = 0;
    uint8_t p1 = 0;
    uint8_t p2 = 0;
    uint16_t p3 = 0;
    uint16_t data_len = 0;
    char* data_ptr = NULL;
    char* path_id_ptr = NULL;
    char* pin2 = NULL;
    char* aidPtr = NULL;

    do {
        if(message->getRilToken() == NULL) {
            RFX_LOG_E(mLog_tag.c_str(), "%s ril token is null, parameter error", __FUNCTION__);
            break;
        }
        Parcel *p = message->getParcel();

        if(p == NULL) {
            break;
        }

        status = p->readInt32(&t);
        if (status != android::NO_ERROR) {
            break;
        }
        cmd = (mipc_sim_access_command_const_enum)t;

        status = p->readInt32(&t);
        if (status != android::NO_ERROR) {
            break;
        }
        file_id = (int)t;

        path_id_ptr = strdupReadString(p);
        if(string(path_id_ptr).empty()) {
            RFX_LOG_E(mLog_tag.c_str(), "%s Path must always be provided", __FUNCTION__);
            break;
        }

        status = p->readInt32(&t);
        if (status != android::NO_ERROR) {
            break;
        }
        p1 = (int)t;

        status = p->readInt32(&t);
        if (status != android::NO_ERROR) {
            break;
        }
        p2 = (int)t;

        status = p->readInt32(&t);
        if (status != android::NO_ERROR) {
            break;
        }
        p3 = (int)t;

        data_ptr = strdupReadString(p);
        if (data_ptr != NULL) {
            RFX_LOG_E(mLog_tag.c_str(), "data_ptr %d", __FUNCTION__,data_ptr);
            if(string(data_ptr).empty()) {
                RFX_LOG_D(mLog_tag.c_str(), "%s data_ptr = NULL", __FUNCTION__);
                if(data_ptr) {
                    free(data_ptr);
                }
                data_ptr = NULL;
            }
        } else {
            RFX_LOG_E(mLog_tag.c_str(), "data_ptr NULL", __FUNCTION__);
        }
        pin2 = strdupReadString(p);
        if (pin2 != NULL) {
            RFX_LOG_E(mLog_tag.c_str(), "pin2 %d", __FUNCTION__,pin2);
            if(string(pin2).empty()) {
                RFX_LOG_D(mLog_tag.c_str(), "%s pin2 = NULL", __FUNCTION__);
                if(pin2) {
                    free(pin2);
                }
                pin2 = NULL;
            }
        } else {
            RFX_LOG_E(mLog_tag.c_str(), "pin2 NULL", __FUNCTION__);
        }
        aidPtr = strdupReadString(p);
        if (aidPtr != NULL) {
            RFX_LOG_E(mLog_tag.c_str(), "aidPtr %d", __FUNCTION__,aidPtr);
            if(string(aidPtr).empty()) {
                RFX_LOG_D(mLog_tag.c_str(), "%s aidPtr = NULL", __FUNCTION__);
                if(aidPtr) {
                    free(aidPtr);
                }
                aidPtr = NULL;
            }
        } else {
            RFX_LOG_E(mLog_tag.c_str(), "aidPtr NULL", __FUNCTION__);
        }
        app_id = queryAppTypeId(aidPtr==NULL? "": aidPtr);
        RFX_LOG_D(mLog_tag.c_str(), "cmd:%d, file_id:%d,path:%s,p1=%d,p2=%d,p3=%u,data=%s,pin2=%s,aid=%s, app_id=%d", cmd, file_id,
                (path_id_ptr==NULL? "": path_id_ptr), p1, p2, p3, (data_ptr==NULL? "": data_ptr), (pin2==NULL? "": pin2), (aidPtr==NULL? "": aidPtr),app_id);

        ret = mipc_sim_channel_restricted_access_async(slot_id_to_mipc_sim_id(message->getSlotId()), mipc_sim_channel_restricted_access_cb, (void*) message->getRilToken(),
                app_id, session_id, cmd, file_id, p1, p2, p3, (data_ptr==NULL? 0: strlen(data_ptr)), data_ptr, path_id_ptr);
    }while(0);

    if(ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_E(mLog_tag.c_str(), "%s fail", __FUNCTION__);
        rfx_enqueue_response_message(NULL,message->getRilToken(),(RIL_SOCKET_ID)message->getSlotId(),RIL_E_GENERIC_FAILURE);
    }

    if(data_ptr) {
        free(data_ptr);
    }
    if(path_id_ptr) {
        free(path_id_ptr);
    }
    if(pin2) {
        free(pin2);
    }
    if(aidPtr) {
        free(aidPtr);
    }
    RFX_LOG_D(mLog_tag.c_str(), "%s done", __FUNCTION__);
}

void RpSimController::handleQueryFacilityLock(const android::sp<RfxMessage> &message) {
    RFX_LOG_D(mLog_tag.c_str(), "%s", __FUNCTION__);
    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;
    int32_t countStrings = 0;
    status_t status;
    mipc_sim_app_type_const_enum app_id = mipc_sim_app_type_const_enum::MIPC_SIM_APP_TYPE_UNKNOWN;
    char* facility = NULL;
    char* password = NULL;
    char* service_class = NULL;
    char* aid = NULL;

    do {
        if(message->getRilToken() == NULL) {
            RFX_LOG_E(mLog_tag.c_str(), "%s ril token is null, parameter error", __FUNCTION__);
            break;
        }
        Parcel *p = message->getParcel();

        if(p == NULL) {
            break;
        }
        status = p->readInt32 (&countStrings);
        if (status != android::NO_ERROR) {
            break;
        }
        if(countStrings < 4) { //don't card aid,only card pin
            break;
        }
        facility = strdupReadString(p);
        password = strdupReadString(p);
        service_class = strdupReadString(p);
        aid = strdupReadString(p);
        app_id = queryAppTypeId(aid==NULL? "": aid);
        RFX_LOG_D(mLog_tag.c_str(), "facility:%s, aid=%s, app_id=%d, service_class=%s", (facility==NULL? "": facility), (aid==NULL? "": aid), app_id, service_class);
        if(facility == NULL) {
            break;
        }
        if (isCallBarringUsage(facility)) {
            RFX_LOG_D(mLog_tag.c_str(), "%s is call barring", facility);
            ret = mipc_ss_query_call_barring_async(slot_id_to_mipc_sim_id(message->getSlotId()),
                    mipc_ss_query_call_barring_cb, (void*) message->getRilToken(),
                    convertfacilityToMipcEnum(facility),
                    (mipc_ss_service_class_const_enum) std::stoi(service_class));
        } else {
            ret = mipc_sim_get_facility_async(slot_id_to_mipc_sim_id(message->getSlotId()),
                    mipc_sim_get_facility_cb, (void*) message->getRilToken(),app_id, facility);
        }
    }while(0);

    if(ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_E(mLog_tag.c_str(), "%s fail", __FUNCTION__);
        rfx_enqueue_response_message(NULL,message->getRilToken(),(RIL_SOCKET_ID)message->getSlotId(),RIL_E_GENERIC_FAILURE);
    }
    if(facility) {
        free(facility);
    }
    if(password) {
        free(password);
    }
    if(service_class) {
        free(service_class);
    }
    if(aid) {
        free(aid);
    }
    RFX_LOG_D(mLog_tag.c_str(), "%s done", __FUNCTION__);
}

void RpSimController::handleSetFacilityLock(const android::sp<RfxMessage> &message) {
    RFX_LOG_D(mLog_tag.c_str(), "%s", __FUNCTION__);
    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;
    int32_t countStrings = 0;
    status_t status;
    mipc_sim_app_type_const_enum app_id = mipc_sim_app_type_const_enum::MIPC_SIM_APP_TYPE_UNKNOWN;
    char* facility = NULL;
    char* mode = NULL;
    char* pass_word = NULL;
    char* service_class = NULL;
    char* aid = NULL;

    do {
        if(message->getRilToken() == NULL) {
            RFX_LOG_E(mLog_tag.c_str(), "%s ril token is null, parameter error", __FUNCTION__);
            break;
        }
        Parcel *p = message->getParcel();

        if(p == NULL) {
            break;
        }
        status = p->readInt32 (&countStrings);
        if (status != android::NO_ERROR) {
            break;
        }
        if(countStrings < 5) { //don't card aid,only card pin
            break;
        }
        facility = strdupReadString(p);
        mode = strdupReadString(p);
        pass_word = strdupReadString(p);
        service_class = strdupReadString(p);
        aid = strdupReadString(p);
        app_id = queryAppTypeId(aid==NULL? "": aid);
        RFX_LOG_D(mLog_tag.c_str(), "facility:%s,mode=%s,pass_word=%s, app_id=%d", (facility==NULL? "": facility),(mode==NULL? "": mode),(pass_word==NULL? "": pass_word),app_id);
        if(facility == NULL || pass_word == NULL) {
            break;
        }
        if (isCallBarringUsage(facility)) {
            RFX_LOG_D(mLog_tag.c_str(), "%s is call barring", facility);
            ret = mipc_ss_set_call_barring_async(slot_id_to_mipc_sim_id(message->getSlotId()),
                    mipc_ss_set_call_barring_cb, (void*) message->getRilToken(),
                    std::stoi(mode) ? MIPC_SS_CALL_BARRING_LOCK_LOCK : MIPC_SS_CALL_BARRING_LOCK_UNLOCK,
                    convertfacilityToMipcEnum(facility),
                    pass_word,
                    (mipc_ss_service_class_const_enum) std::stoi(service_class));
        } else {
            ret = mipc_sim_set_facility_async(slot_id_to_mipc_sim_id(message->getSlotId()),
                    mipc_sim_set_facility_cb, (void*) message->getRilToken(),
                    app_id, facility,pass_word,std::stoi(mode));
        }
    }while(0);

    if(ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_E(mLog_tag.c_str(), "%s fail", __FUNCTION__);
        rfx_enqueue_response_message(NULL,message->getRilToken(),(RIL_SOCKET_ID)message->getSlotId(),RIL_E_GENERIC_FAILURE);
    }
    if(facility) {
        free(facility);
    }
    if(mode) {
        free(mode);
    }
    if(pass_word) {
        free(pass_word);
    }
    if(service_class) {
        free(service_class);
    }
    if(aid) {
        free(aid);
    }
    RFX_LOG_D(mLog_tag.c_str(), "%s done", __FUNCTION__);
}

void RpSimController::handleSimAuth(const android::sp<RfxMessage> &message) {
    RFX_LOG_D(mLog_tag.c_str(), "%s", __FUNCTION__);
    int32_t  t;
    status_t status;
    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;
    mipc_sim_app_type_const_enum app_id = mipc_sim_app_type_const_enum::MIPC_SIM_APP_TYPE_UNKNOWN;
    int authContext;
    char *authData = NULL;
    char *aid = NULL;

    do {
        if(message->getRilToken() == NULL) {
            RFX_LOG_E(mLog_tag.c_str(), "%s ril token is null, parameter error", __FUNCTION__);
            break;
        }
        Parcel *p = message->getParcel();

        if(p == NULL) {
            break;
        }

        status = p->readInt32(&t);
        if (status != android::NO_ERROR) {
            break;
        }
        authContext = (int)t;

        authData = strdupReadString(p);
        if(authData == NULL) {
            break;
        }
        aid = strdupReadString(p);
        if(aid == NULL) {
            break;
        }
        app_id = queryAppTypeId(aid);
        RFX_LOG_D(mLog_tag.c_str(), "authContext=%d, authData: %s, aid: %s, app_id= %d", authContext, authData, aid, app_id);
        ret = mipc_sim_ext_auth_get_async(slot_id_to_mipc_sim_id(message->getSlotId()), mipc_sim_ext_auth_get_cb, (void*) message->getRilToken(), UINT8_MAX, authContext, strlen(authData),authData, app_id);
    }while(0);

    if(ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_E(mLog_tag.c_str(), "%s fail", __FUNCTION__);
        rfx_enqueue_response_message(NULL,message->getRilToken(),(RIL_SOCKET_ID)message->getSlotId(),RIL_E_GENERIC_FAILURE);
    }

    if(authData) {
        free(authData);
    }
    if(aid) {
        free(aid);
    }
    RFX_LOG_D(mLog_tag.c_str(), "%s done", __FUNCTION__);
}

void RpSimController::handleIsimAuth(const android::sp<RfxMessage> &message) {
    RFX_LOG_D(mLog_tag.c_str(), "%s", __FUNCTION__);
    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;
    mipc_sim_app_type_const_enum app_id = mipc_sim_app_type_const_enum::MIPC_SIM_APP_TYPE_UNKNOWN;
    char *authData = NULL;

    do {
        if(message->getRilToken() == NULL) {
            RFX_LOG_E(mLog_tag.c_str(), "%s ril token is null, parameter error", __FUNCTION__);
            break;
        }
        Parcel *p = message->getParcel();

        if(p == NULL) {
            break;
        }

        authData = strdupReadString(p);
        if(authData == NULL) {
            break;
        }

        app_id = queryAppTypeId("");
        RFX_LOG_D(mLog_tag.c_str(), "authData: %s,app_id= %d", authData, app_id);
        ret = mipc_sim_ext_auth_get_async(slot_id_to_mipc_sim_id(message->getSlotId()), mipc_sim_ext_auth_get_cb, (void*) message->getRilToken(), UINT8_MAX, 0, strlen(authData),authData, app_id);
    }while(0);

    if(ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_E(mLog_tag.c_str(), "%s fail", __FUNCTION__);
        rfx_enqueue_response_message(NULL,message->getRilToken(),(RIL_SOCKET_ID)message->getSlotId(),RIL_E_GENERIC_FAILURE);
    }

    if(authData) {
        free(authData);
    }
    RFX_LOG_D(mLog_tag.c_str(), "%s done", __FUNCTION__);
}

void RpSimController::handleSimTranApduBasic(const android::sp<RfxMessage> &message) {
    RFX_LOG_D(mLog_tag.c_str(), "%s", __FUNCTION__);
    int32_t t;
    int size;
    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;
    status_t status;
    int session_id = 0;
    int cla = 0;
    int ins = UINT8_MAX;
    int p1 = 0;
    int p2 = 0;
    int p3 = 0;
    int data_len = 0;
    char* data_ptr = NULL;
    char *byteData = NULL;
    uint16_t len = 0;
    uint16_t bLen = 0;

    do {
        if(message->getRilToken() == NULL) {
            RFX_LOG_E(mLog_tag.c_str(), "%s ril token is null, parameter error", __FUNCTION__);
            break;
        }
        Parcel *p = message->getParcel();

        if(p == NULL) {
            break;
        }

        status = p->readInt32(&t);
        if (status != android::NO_ERROR) {
            break;
        }
        //session_id = (int)t; //NO NEED

        status = p->readInt32(&t);
        cla = (int)t;

        status = p->readInt32(&t);
        ins = (int)t; //instruction

        status = p->readInt32(&t);
        if (status != android::NO_ERROR) {
            break;
        }
        p1 = (int)t;

        status = p->readInt32(&t);
        if (status != android::NO_ERROR) {
            break;
        }
        p2 = (int)t;

        status = p->readInt32(&t);
        if (status != android::NO_ERROR) {
            break;
        }
        p3 = (int)t;

        data_ptr = strdupReadString(p);
        if(data_ptr && (string(data_ptr).empty())) {
            data_ptr = NULL;
        } else {
            if (data_ptr != NULL) {
                len = strlen(data_ptr);
                bLen = hexStringToByteArrayEx((unsigned char*)data_ptr, len, (unsigned char **)&byteData);
            }
        }
        RFX_LOG_D(mLog_tag.c_str(), "session_id:%d, cla:%d, ins:%d,p1=%d,p2=%d,p3=%d,data=%s", session_id, cla, ins, p1, p2, p3, (byteData==NULL? "": byteData));
        ret = mipc_sim_extended_channel_generic_access_async(slot_id_to_mipc_sim_id(message->getSlotId()), mipc_sim_extended_channel_generic_access_cb,
                (void*) message->getRilToken(), session_id, cla, ins, p1, p2, p3, bLen, byteData);
    }while(0);

    if(ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_E(mLog_tag.c_str(), "%s fail", __FUNCTION__);
        rfx_enqueue_response_message(NULL,message->getRilToken(),(RIL_SOCKET_ID)message->getSlotId(),RIL_E_GENERIC_FAILURE);
    }

    if(data_ptr) {
        free(data_ptr);
    }
    if (byteData) {
        free(byteData);
    }
    RFX_LOG_D(mLog_tag.c_str(), "%s done", __FUNCTION__);
}

/**
 * Returns a copy of the given CLA byte where the channel number bits are
 * set as specified by the given channel number See GlobalPlatform Card
 * Specification 2.2.0.7: 11.1.4 Class Byte Coding.
 *
 * @param cla the CLA byte. Won't be modified
 * @param channelNumber within [0..3] (for first interindustry class byte
 *            coding) or [4..19] (for further interindustry class byte
 *            coding)
 * @return the CLA byte with set channel number bits. The seventh bit
 *         indicating the used coding (first/further interindustry class
 *         byte coding) might be modified
 */
 int RpSimController::setChannelToClassByte(int cla, int channelNumber) {
    if (channelNumber < 4) {
        // b7 = 0 indicates the first interindustry class byte coding
        cla = ((cla & 0xBC) | channelNumber);

    } else if (channelNumber < 20) {
        // b7 = 1 indicates the further interindustry class byte coding
        bool isSM = (cla & 0x0C) != 0;
        cla = ((cla & 0xB0) | 0x40 | (channelNumber - 4));
        if (isSM) {
            cla |= 0x20;
        }
    }
    return cla;
}


void RpSimController::handleSimTranApduChann(const android::sp<RfxMessage> &message) {
    RFX_LOG_D(mLog_tag.c_str(), "%s", __FUNCTION__);
    int32_t t;
    int size;
    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;
    status_t status;
    int session_id = 0;
    int cla = 0;
    int ins = UINT8_MAX;
    int p1 = 0;
    int p2 = 0;
    int p3 = 0;
    int data_len = 0;
    char* data_ptr = NULL;
    char *byteData = NULL;
    uint16_t len = 0;
    uint16_t bLen = 0;

    do {
        if(message->getRilToken() == NULL) {
            RFX_LOG_E(mLog_tag.c_str(), "%s ril token is null, parameter error", __FUNCTION__);
            break;
        }
        Parcel *p = message->getParcel();

        if(p == NULL) {
            break;
        }

        status = p->readInt32(&t);
        if (status != android::NO_ERROR) {
            break;
        }
        session_id = (int)t;

        status = p->readInt32(&t);

        cla = (int)t;
        // Set class byte according TS 102.221
        cla = setChannelToClassByte(cla, session_id);

        status = p->readInt32(&t);
        ins = (int)t; //instruction

        status = p->readInt32(&t);
        if (status != android::NO_ERROR) {
            break;
        }
        p1 = (int)t;

        status = p->readInt32(&t);
        if (status != android::NO_ERROR) {
            break;
        }
        p2 = (int)t;

        status = p->readInt32(&t);
        if (status != android::NO_ERROR) {
            break;
        }
        p3 = (int)t;

        data_ptr = strdupReadString(p);
        if(data_ptr && (string(data_ptr).empty())) {
            data_ptr = NULL;
        } else {
            if (data_ptr != NULL) {
                len = strlen(data_ptr);
                bLen = hexStringToByteArrayEx((unsigned char*)data_ptr, len, (unsigned char **)&byteData);
            }
        }

        RFX_LOG_D(mLog_tag.c_str(), "session_id:%d, cla:%d, ins:%d,p1=%d,p2=%d,p3=%d,data=%s", session_id, cla, ins, p1, p2, p3, (byteData==NULL? "": byteData));
        ret = mipc_sim_extended_channel_generic_access_async(slot_id_to_mipc_sim_id(message->getSlotId()), mipc_sim_extended_channel_generic_access_cb,
                (void*) message->getRilToken(), session_id, cla, ins, p1, p2, p3, bLen, byteData);
    }while(0);

    if(ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_E(mLog_tag.c_str(), "%s fail", __FUNCTION__);
        rfx_enqueue_response_message(NULL,message->getRilToken(),(RIL_SOCKET_ID)message->getSlotId(),RIL_E_GENERIC_FAILURE);
    }

    if(data_ptr) {
        free(data_ptr);
    }
    if (byteData) {
        free(byteData);
    }
    RFX_LOG_D(mLog_tag.c_str(), "%s done", __FUNCTION__);
}

void RpSimController::handleSimOpenChannel(const android::sp<RfxMessage> &message) {
    RFX_LOG_D(mLog_tag.c_str(), "%s", __FUNCTION__);
    int32_t t;
    int size;
    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;
    status_t status;
    //uint8_t app_id_len,
    char* app_id_ptr=NULL;
    uint8_t p2 = 0;
    uint8_t channel_group = 0;
    char app_id[16] = {'\0'};

    do {
        if(message->getRilToken() == NULL) {
            RFX_LOG_E(mLog_tag.c_str(), "%s ril token is null, parameter error", __FUNCTION__);
            break;
        }
        Parcel *p = message->getParcel();

        if(p == NULL) {
            break;
        }

        app_id_ptr = strdupReadString(p);
        if(string(app_id_ptr).empty()) {
            RFX_LOG_D(mLog_tag.c_str(), "%s app_id_ptr = NULL", __FUNCTION__);
            if(app_id_ptr) {
                free(app_id_ptr);
            }
            app_id_ptr = NULL;
            break;
        }

        if(app_id_ptr) {
            int result = str2byte(app_id_ptr, strlen(app_id_ptr), app_id);
            RFX_LOG_D(mLog_tag.c_str(), "str2byte(), result: %d", result);
        }
        status = p->readInt32(&t);
        if (status != android::NO_ERROR) {
            break;
        }
        p2 = (int)t;

        RFX_LOG_D(mLog_tag.c_str(), "app_id_ptr:%s, p2:%d", (app_id_ptr==NULL? "": app_id_ptr), p2);

        ret = mipc_sim_channel_open_async(slot_id_to_mipc_sim_id(message->getSlotId()), mipc_sim_channel_open_cb,(void*) message->getRilToken(),
                16, app_id, p2, channel_group);
    }while(0);

    if(ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_E(mLog_tag.c_str(), "%s fail", __FUNCTION__);
        rfx_enqueue_response_message(NULL,message->getRilToken(),(RIL_SOCKET_ID)message->getSlotId(),RIL_E_GENERIC_FAILURE);
    }

    if(app_id_ptr) {
        free(app_id_ptr);
    }

    RFX_LOG_D(mLog_tag.c_str(), "%s done", __FUNCTION__);
}

void RpSimController::handleSimCloseChannel(const android::sp<RfxMessage> &message) {
    RFX_LOG_D(mLog_tag.c_str(), "%s", __FUNCTION__);
    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;
    int32_t countStrings = 0;
    status_t status;
    int32_t t;
    uint8_t channel_id = 0;
    uint8_t channel_group = 0;

    do {
        if(message->getRilToken() == NULL) {
            RFX_LOG_E(mLog_tag.c_str(), "%s ril token is null, parameter error", __FUNCTION__);
            break;
        }
        Parcel *p = message->getParcel();

        if(p == NULL) {
            break;
        }
        status = p->readInt32 (&countStrings);
        if (status != android::NO_ERROR) {
            break;
        }
        if(countStrings < 1) { //don't card aid,only card pin
            break;
        }

        status = p->readInt32 (&t);
        if (status != android::NO_ERROR) {
            break;
        }
        channel_id = (uint8_t)t;

        RFX_LOG_D(mLog_tag.c_str(), "channel_id:%d", channel_id);

        ret = mipc_sim_channel_close_async(slot_id_to_mipc_sim_id(message->getSlotId()), mipc_sim_channel_close_cb, (void*) message->getRilToken(),channel_id,channel_group);
    }while(0);

    if(ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_E(mLog_tag.c_str(), "%s fail", __FUNCTION__);
        rfx_enqueue_response_message(NULL,message->getRilToken(),(RIL_SOCKET_ID)message->getSlotId(),RIL_E_GENERIC_FAILURE);
    }
    RFX_LOG_D(mLog_tag.c_str(), "%s done", __FUNCTION__);
}

/*
typedef enum {
    UICC_APP_ISIM = 0,
    UICC_APP_USIM = 1,
    UICC_APP_CSIM = 2,
    UICC_APP_SIM = 3,
    UICC_APP_RUIM = 4,

    UICC_APP_ID_END
} App_Id;
 */

mipc_sim_app_type_const_enum RpSimController::queryAppTypeId(string aid) {
    mipc_sim_app_type_const_enum appTypeId = mipc_sim_app_type_const_enum::MIPC_SIM_APP_TYPE_MFSIM; // Default is SIM
    //SIM_APP_TYPE

    if (aid.empty()) {
        // SIM or RUIM
        int cardType = getStatusManager()->getIntValue(RFX_STATUS_KEY_CARD_TYPE, -1);

        RFX_LOG_E(mLog_tag.c_str(), "queryAppTypeId aid is empty or \"(null)\", aid = %s, cardType = %d", aid.c_str(), cardType);
        if (cardType & RFX_CARD_TYPE_SIM) {
            appTypeId = mipc_sim_app_type_const_enum::MIPC_SIM_APP_TYPE_MFSIM; //TBD
        } else if (cardType & RFX_CARD_TYPE_USIM) {
            appTypeId = mipc_sim_app_type_const_enum::MIPC_SIM_APP_TYPE_USIM;
        } else if (cardType & RFX_CARD_TYPE_CSIM) {
            appTypeId = mipc_sim_app_type_const_enum::MIPC_SIM_APP_TYPE_CSIM;
        } else if (cardType & RFX_CARD_TYPE_RUIM) {
            appTypeId = mipc_sim_app_type_const_enum::MIPC_SIM_APP_TYPE_MFRUIM;
        } else {
            RFX_LOG_E(mLog_tag.c_str(), "Could not get app id because card type is not ready!");
        }
    } else if (strncmp(aid.c_str(), "A0000000871002", 14) == 0) {
        // USIM
        appTypeId = mipc_sim_app_type_const_enum::MIPC_SIM_APP_TYPE_USIM; // USIM
    } else if (strncmp(aid.c_str(), "A0000000871004", 14) == 0) {
        // ISIM
        appTypeId = mipc_sim_app_type_const_enum::MIPC_SIM_APP_TYPE_ISIM;
    } else if (strncmp(aid.c_str(), "A0000003431002", 14) == 0) {
        // CSIM
        appTypeId = mipc_sim_app_type_const_enum::MIPC_SIM_APP_TYPE_CSIM;
    } else if (strncmp(aid.c_str(), "A000000000RUIM", 14) == 0) {
        // RUIM
       appTypeId = mipc_sim_app_type_const_enum::MIPC_SIM_APP_TYPE_MFRUIM;
    } else {
        RFX_LOG_E(mLog_tag.c_str(), "Not support the aid %s", aid.c_str());
    }
    return appTypeId;
}

std::string RpSimController::IdToString(int request) {
    switch(request) {
    case RIL_REQUEST_GET_SIM_STATUS: return "RIL_REQUEST_GET_SIM_STATUS";//MIPC_SIM_STATUS_REQ
    case RIL_REQUEST_ENTER_SIM_PIN: return "RIL_REQUEST_ENTER_SIM_PIN";//MIPC_SIM_VERIFY_PIN_REQ
    case RIL_REQUEST_ENTER_SIM_PIN2: return "RIL_REQUEST_ENTER_SIM_PIN2";//MIPC_SIM_VERIFY_PIN_REQ
    case RIL_REQUEST_ENTER_SIM_PUK: return "RIL_REQUEST_ENTER_SIM_PUK";//MIPC_SIM_UNBLOCK_PIN_REQ
    case RIL_REQUEST_ENTER_SIM_PUK2: return "RIL_REQUEST_ENTER_SIM_PUK2";//MIPC_SIM_UNBLOCK_PIN_REQ
    case RIL_REQUEST_CHANGE_SIM_PIN: return "RIL_REQUEST_CHANGE_SIM_PIN";//MIPC_SIM_CHANGE_PIN_REQ
    case RIL_REQUEST_CHANGE_SIM_PIN2: return "RIL_REQUEST_CHANGE_SIM_PIN2";//MIPC_SIM_CHANGE_PIN_REQ
    case RIL_REQUEST_ENTER_NETWORK_DEPERSONALIZATION: return "RIL_REQUEST_ENTER_NETWORK_DEPERSONALIZATION";//MIPC_SIM_VERIFY_PIN_REQ
    case RIL_REQUEST_GET_IMSI: return "RIL_REQUEST_GET_IMSI";//MIPC_SIM_IMSI_REQ
    case RIL_REQUEST_SIM_IO: return "RIL_REQUEST_SIM_IO";//MIPC_SIM_CHANNEL_RESTRICTED_ACCESS_REQ
    case RIL_REQUEST_QUERY_FACILITY_LOCK: return "RIL_REQUEST_QUERY_FACILITY_LOCK";//MIPC_SIM_GET_FACILITY_REQ
    case RIL_REQUEST_SET_FACILITY_LOCK: return "RIL_REQUEST_SET_FACILITY_LOCK";//MIPC_SIM_SET_FACILITY_REQ
    case RIL_REQUEST_SIM_AUTHENTICATION: return "RIL_REQUEST_SIM_AUTHENTICATION";
    case RIL_REQUEST_ISIM_AUTHENTICATION: return "RIL_REQUEST_ISIM_AUTHENTICATION"; //MIPC_SIM_EXT_AUTH_GET_REQ?
    case RIL_REQUEST_SIM_TRANSMIT_APDU_BASIC: return "RIL_REQUEST_SIM_TRANSMIT_APDU_BASIC";
    case RIL_REQUEST_SIM_TRANSMIT_APDU_CHANNEL: return "RIL_REQUEST_SIM_TRANSMIT_APDU_CHANNEL";//MIPC_SIM_CHANNEL_RESTRICTED_ACCESS_REQ
    case RIL_REQUEST_SIM_OPEN_CHANNEL: return "RIL_REQUEST_SIM_OPEN_CHANNEL";//MIPC_SIM_OPEN_CHANNEL_REQ
    case RIL_REQUEST_SIM_CLOSE_CHANNEL: return "RIL_REQUEST_SIM_CLOSE_CHANNEL";//MIPC_SIM_CLOSE_CHANNEL_REQ
    case RIL_UNSOL_SIM_REFRESH: return "RIL_UNSOL_SIM_REFRESH";
    case RIL_UNSOL_UICC_SUBSCRIPTION_STATUS_CHANGED: return "RIL_UNSOL_UICC_SUBSCRIPTION_STATUS_CHANGED";
    case RIL_UNSOL_RESPONSE_SIM_STATUS_CHANGED: return "RIL_UNSOL_RESPONSE_SIM_STATUS_CHANGED";//MIPC_SIM_STATUS_IND
    case RIL_UNSOL_SIM_PLUG_OUT: return "RIL_UNSOL_SIM_PLUG_OUT";//MIPC_SIM_STATUS_CHANGE_WITH_CAUSE_IND
    case RIL_UNSOL_SIM_PLUG_IN: return "RIL_UNSOL_SIM_PLUG_IN"; //MIPC_SIM_STATUS_CHANGE_WITH_CAUSE_IND
    case RIL_REQUEST_SIM_GET_ICCID: return "RIL_REQUEST_SIM_GET_ICCID"; //MIPC_SIM_ICCID_REQ
    case RIL_REQUEST_QUERY_EID: return "RIL_REQUEST_QUERY_EID"; //RIL_REQUEST_QUERY_EID
    case RIL_REQUEST_QUERY_SIM_RETRY_COUNT: return "RIL_REQUEST_QUERY_SIM_RETRY_COUNT"; //RIL_REQUEST_QUERY_SIM_RETRY_COUNT
    default: return "UNKNOWN";
    }
}

void RpSimController::handleSimGetIccid(const android::sp<RfxMessage> &message) {
    RFX_LOG_E(mLog_tag.c_str(), "%s", __FUNCTION__);
    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;
    //1 means full mode
    do {
        if(message->getRilToken() == NULL) {
            RFX_LOG_E(mLog_tag.c_str(), "%s ril token is null, parameter error", __FUNCTION__);
            break;
        }
        ret = mipc_sim_iccid_get_async(slot_id_to_mipc_sim_id(message->getSlotId()), mipc_sim_iccid_get_cb, (void*) message->getRilToken());
    } while(0);

    if(ret != MIPC_API_RESULT_SUCCESS) {
         RFX_LOG_E(mLog_tag.c_str(), "%s fail", __FUNCTION__);
         rfx_enqueue_response_message(NULL,message->getRilToken(),(RIL_SOCKET_ID)message->getSlotId(),RIL_E_GENERIC_FAILURE);
     }

    RFX_LOG_D(mLog_tag.c_str(), "%s done", __FUNCTION__);
}

void RpSimController::handleQueryEid(const android::sp<RfxMessage> &message) {
    RFX_LOG_E(mLog_tag.c_str(), "%s", __FUNCTION__);
    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;
    do {
        if(message->getRilToken() == NULL) {
            RFX_LOG_E(mLog_tag.c_str(), "%s ril token is null, parameter error", __FUNCTION__);
            break;
        }
        ret = mipc_sim_get_euicc_slots_status_async(slot_id_to_mipc_sim_id(message->getSlotId()), mipc_sim_euicc_slots_status_get_cb, (void*) message->getRilToken());

    } while(0);

    if(ret != MIPC_API_RESULT_SUCCESS) {
         RFX_LOG_E(mLog_tag.c_str(), "%s fail", __FUNCTION__);
         rfx_enqueue_response_message(NULL,message->getRilToken(),(RIL_SOCKET_ID)message->getSlotId(),RIL_E_GENERIC_FAILURE);
     }

    RFX_LOG_D(mLog_tag.c_str(), "%s done", __FUNCTION__);
}

void RpSimController::handleQuerySimRetryCount(const android::sp<RfxMessage> &message) {
    RFX_LOG_E(mLog_tag.c_str(), "%s", __FUNCTION__);
    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;
    do {
        if(message->getRilToken() == NULL) {
            RFX_LOG_E(mLog_tag.c_str(), "%s ril token is null, parameter error", __FUNCTION__);
            break;
        }
        ret = mipc_sim_pin_count_query_async(slot_id_to_mipc_sim_id(message->getSlotId()), mipc_sim_pin_count_query_cb, (void*) message->getRilToken());
    } while(0);

    if(ret != MIPC_API_RESULT_SUCCESS) {
         RFX_LOG_E(mLog_tag.c_str(), "%s fail", __FUNCTION__);
         rfx_enqueue_response_message(NULL,message->getRilToken(),(RIL_SOCKET_ID)message->getSlotId(),RIL_E_GENERIC_FAILURE);
     }

    RFX_LOG_D(mLog_tag.c_str(), "%s done", __FUNCTION__);
}

int RpSimController::hexStringToByteArrayEx(unsigned char* hexString,
        int hexStringLen, unsigned char ** byte) {
    int length = hexStringLen/2;
    unsigned char* buffer = (unsigned char*)malloc((length + 1)*sizeof(char));
    int i = 0;

    if (NULL == buffer) {
        RFX_LOG_E(mLog_tag.c_str(), "%s malloc return NULL.", __FUNCTION__);
        return 0;
    }
    memset(buffer, 0, ((length + 1)*sizeof(char)));
    for (i = 0 ; i < hexStringLen ; i += 2)
    {
        buffer[i / 2] = (unsigned char)((toByte(hexString[i]) << 4) | toByte(hexString[i+1]));
    }

    *byte = buffer;

    return (hexStringLen/2);
}

int RpSimController::toByte(char c) {
    if (c >= '0' && c <= '9') return (c - '0');
    if (c >= 'A' && c <= 'F') return (c - 'A' + 10);
    if (c >= 'a' && c <= 'f') return (c - 'a' + 10);

    RFX_LOG_E(mLog_tag.c_str(), "%s toByte, Error: %c", __FUNCTION__, c);
    return 0;
}

