//SPDX-License-Identifier: MediaTekProprietary
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2015. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

/*****************************************************************************
 * Include
 *****************************************************************************/

#include "RpSysController.h"

#include <sys/un.h>
#include <errno.h>
#include <unistd.h>
#include <cutils/jstring.h>
#include <string>
#ifdef __cplusplus
extern "C" {
#endif
#include "mipc_sys_api.h"
#ifdef __cplusplus
}
#endif

#include "RfxDispatchThread.h"
#include "Rfx.h"
#include "RilParcelUtils.h"
#include <telephony/mtk_ril_request_info.h>
#include "RfxRootController.h"
#include "RpUtils.h"
#include "RtcCapabilitySwitchChecker.h"
#include "RtcCapabilitySwitchUtil.h"
#include <libmtkrilutils.h>
#include <ratconfig.h>

using namespace std;

#define RFX_LOG_TAG "RpSysController"

static int m_max_capability;
static int m_new_main_slot;
static int m_new_main_slot_by_modem_id;
static bool m_is_started;
bool RpSysController::s_first_instance = true;
Mutex RpSysController::s_first_instance_mutex;

static string getTag(mipc_sim_ps_id_enum sim_ps_id) {
    string tag = "";
    tag.append("[slot").append(to_string(mipc_sim_id_to_slot_id(sim_ps_id))).append("]").append(RFX_LOG_TAG);
    return tag;
}

/*****************************************************************************
 * Class RfxDataController
 * The class is created if the slot is single mode, LWG or C,
 *****************************************************************************/

RFX_IMPLEMENT_CLASS("RpSysController", RpSysController, RfxController);

RpSysController::RpSysController() :
        m_cslot(0), m_first_urc(true), m_pending_request(NULL), m_pChecker(NULL) {
}

RpSysController::~RpSysController() {
}

//urc and response use the the same callback function
extern "C" {
void mipc_sys_at_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_sys_at_struct *result_ptr,
    void *cb_priv_ptr
) {
    //RFX_LOG_D(RFX_LOG_TAG,"mipc_sys_at_cb:sim_ps_id %d data %s\n",sim_ps_id,result_ptr->data);
    Parcel * parcel = NULL;
    RIL_Errno err = RIL_E_SUCCESS;
    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        err = (RIL_Errno)result_ptr->result_code;// Todo
        goto out;
    }else {
        parcel = new Parcel();
        int32_t len =  strlen(result_ptr->data);

        parcel->writeInt32(len);
        parcel->write((void *)result_ptr->data, len);
    }
out:
    if(cb_priv_ptr) {
        rfx_enqueue_response_message(parcel,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),err);
    } else {
        rfx_enqueue_urc_message(RIL_UNSOL_OEM_HOOK_RAW,parcel,mipc_sim_id_to_slot_id(sim_ps_id),err);
    }
#ifdef MIPC_UNITTEST
    String8 str("test");
    RFX_OBJ_GET_INSTANCE(RfxRootController)->getStatusManager(mipc_sim_id_to_slot_id(sim_ps_id))->setString8Value(RFX_STATUS_KEY_TELEPHONY_ASSISTANT_STATUS, str);
#endif
}


void mipc_sys_info_get_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_sys_info_struct *result_ptr,
    void *cb_priv_ptr
) {
//xf.li@20231204 modify for T8TSK-291 start
    RFX_LOG_D(RFX_LOG_TAG,"mipc_sys_info_get_cb:sim_ps_id %d data imei(has got) firmware_info %s\n",
        sim_ps_id,result_ptr->firmware_info);
//xf.li@20231204 modify for T8TSK-291 end
    Parcel * parcel = NULL;
    RIL_Errno err = RIL_E_SUCCESS;
    android::RequestInfo *requestInfo = (android::RequestInfo *)cb_priv_ptr;
    if (requestInfo == NULL) {
        RFX_LOG_E(getTag(sim_ps_id).c_str(),"mipc_sys_info_get_cb fail with null cb_priv_ptr\n");
        return;
    }
    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        err = (RIL_Errno)result_ptr->result_code;// Todo
    }else {
        parcel = new Parcel();
        switch (requestInfo->pCI->requestNumber) {
            case RIL_REQUEST_GET_IMEI:
            {
                writeStringToParcel(parcel,(char *)result_ptr->device_id); ////result_ptr->device_id
                break;
            }
            case RIL_REQUEST_GET_IMEISV:
            {
                writeStringToParcel(parcel,(char *)result_ptr->imeisv);
                break;
            }
            case RIL_REQUEST_BASEBAND_VERSION:
            {
                writeStringToParcel(parcel,(char *)result_ptr->firmware_info);
                break;
            }
            case RIL_REQUEST_DEVICE_IDENTITY:
            default:
            {
                parcel->writeInt32(2);
                writeStringToParcel(parcel,(char *)result_ptr->device_id); ////result_ptr->device_id
                writeStringToParcel(parcel,(char *)result_ptr->imeisv);
                //writeStringToParcel(parcel,(char *)result_ptr->esn);
                //writeStringToParcel(parcel,(char *)result_ptr->meid);
                break;
            }
        }
    }
    rfx_enqueue_response_message(parcel,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),err);
}

void mipc_sys_mapping_set_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_sys_mapping_struct *result_ptr,
    void *cb_priv_ptr) {

    RFX_LOG_D(getTag(sim_ps_id).c_str(),"mipc_sys_mapping_set_cb:sim_ps_id %d\n",sim_ps_id);

    Parcel * parcel = NULL;
    RIL_Errno err = RIL_E_SUCCESS;

    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        err = (RIL_Errno)result_ptr->result_code;// Todo

        // Should do retry in MD
    }else {

    }
}

void mipc_sys_mapping_get_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_sys_mapping_struct *result_ptr,
    void *cb_priv_ptr) {

    RFX_LOG_D(getTag(sim_ps_id).c_str(),"mipc_sys_mapping_get_cb:sim_ps_id %d\n",sim_ps_id);

    Parcel * parcel = NULL;
    RIL_Errno err = RIL_E_SUCCESS;

    int radio_capability;
    int session_id = -1;
    RIL_RadioCapability rc;
    memset(&rc, 0, sizeof(RIL_RadioCapability));
    rc.version = RIL_RADIO_CAPABILITY_VERSION;
    rc.session = session_id;
    rc.phase = RC_PHASE_UNSOL_RSP;
    rc.status = RC_STATUS_SUCCESS;
    radio_capability = RFX_OBJ_GET_INSTANCE(RfxRootController)->getStatusManager(mipc_sim_id_to_slot_id(sim_ps_id))->getIntValue(RFX_STATUS_KEY_SLOT_CAPABILITY, 0);
/* TODO
    if(RtcCapabilitySwitchUtil::isDisableC2kCapability() == false &&
            RatConfig_isC2kSupported()) {
        // always send CDMA capability from Android Q
        radio_capability |= (RAF_CDMA_GROUP | RAF_EVDO_GROUP);
    }
*/
    RFX_LOG_D(getTag(sim_ps_id).c_str(), "requestGetRadioCapability, cap[%d] = %d, sizeof(RIL_RadioCapability)=%d",
         mipc_sim_id_to_slot_id(sim_ps_id), radio_capability, (int)sizeof(RIL_RadioCapability));
    rc.rat = radio_capability;
    //TODO getLogicalModemId(rc.logicalModemUuid, MAX_UUID_LENGTH, mipc_sim_id_to_slot_id(sim_ps_id));

    Parcel *p_rsp = new Parcel();
    p_rsp->writeInt32(rc.version);
    p_rsp->writeInt32(rc.session);
    p_rsp->writeInt32(rc.phase);
    p_rsp->writeInt32(rc.rat);
    writeStringToParcel(p_rsp, rc.logicalModemUuid);
    p_rsp->writeInt32(rc.status);

    rfx_enqueue_response_message(p_rsp,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
}

}



void RpSysController::onTelephonyAssistantStatusChanged(RfxStatusKeyEnum key,
        RfxVariant old_value, RfxVariant value) {
    RFX_UNUSED(key);
    RFX_UNUSED(old_value);
    RFX_LOG_D(RFX_LOG_TAG, "onTelephonyAssistantStatusChanged");
}

void RpSysController::onInit() {
    RfxController::onInit();  // Required: invoke super class implementation

    RFX_LOG_D(RFX_LOG_TAG, "RpSysController[%d] %s+", m_slot_id, __FUNCTION__);

    m_max_capability = 0;
    m_new_main_slot = 0;
    m_new_main_slot_by_modem_id = -1;
    m_is_started = false;

    const int request_id_list[] = {
            RIL_REQUEST_OEM_HOOK_RAW,  // 10
            RIL_REQUEST_DEVICE_IDENTITY,
            RIL_REQUEST_GET_IMEI,
            RIL_REQUEST_GET_IMEISV,
            RIL_REQUEST_BASEBAND_VERSION,
            RIL_REQUEST_GET_RADIO_CAPABILITY,
            RIL_REQUEST_SET_RADIO_CAPABILITY,
    };

    mipc_sys_at_register(slot_id_to_mipc_sim_id(getSlotId()),mipc_sys_at_cb,NULL);

    getCapabilityChecker();

    int old_major_sim = getMajorSim();
    int main_sim = queryMainProtocol();

    s_first_instance_mutex.lock();
    if (s_first_instance) {
        RFX_LOG_D(RFX_LOG_TAG, "[%d]%s first instance", m_slot_id, __FUNCTION__);
        s_first_instance = false;
        rfx_property_set(
                "persist.vendor.radio.simswitch", String8::format("%d", main_sim).string());
        getNonSlotScopeStatusManager()->setIntValue(
                RFX_STATUS_KEY_MAIN_CAPABILITY_SLOT, main_sim - 1, false, false);
        queryNoResetSupport();
        queryTplusWSupport();
        queryKeep3GMode();
        if(false == isTplusWSupport()) {
            queryActiveMode();
        }
    }
    s_first_instance_mutex.unlock();

    RFX_LOG_D(RFX_LOG_TAG, "%s old_major_sim=%d, main_sim=%d",
            __FUNCTION__, old_major_sim, main_sim);

    queryBearer();
    //sendRadioCapabilityDoneIfNeeded();
    //sendEGRAT();
    //sendEvent(RFX_MSG_EVENT_CAPABILITY_INIT_DONE, RfxVoidData(), m_channel_id, m_slot_id);

    // register request id list
    registerToHandleRequest(request_id_list,
            sizeof(request_id_list) / sizeof(int));

    resetLock(MAX_RFX_SLOT_ID, RFX_STATUS_KEY_CAPABILITY_SWITCH_STATE);
    if (isPendingUndoneSwitch()) {
        //TODO m_new_main_slot = getUndoneSwitch();
        //TODO registerStatusKeys();
        RFX_LOG_E(RFX_LOG_TAG, "[%d]%s Has pending undo switch, m_new_main_slot=%d",
                m_slot_id, __FUNCTION__, m_new_main_slot);
    }

    if(getGeminiMode() == GEMINI_MODE_L_AND_L &&
        getSimCount() == 2 && isCtVolteSupport()) {
        for (int i = 0; i < getSimCount(); i++) {
             getStatusManager(i)->registerStatusChanged(
                     RFX_STATUS_KEY_VOLTE_STATE, RfxStatusChangeCallback(
                     this, &RpSysController::onVolteStateChanged));
        }
    }

// No need when using MIPC
#if 0
    getNonSlotScopeStatusManager()->registerStatusChanged(
            RFX_STATUS_KEY_DEFAULT_DATA_SIM,
            RfxStatusChangeCallback(this, &RpSysController::onDefaultDataChanged));
#endif

#ifdef MIPC_UNITTEST
    getStatusManager()->registerStatusChanged(RFX_STATUS_KEY_TELEPHONY_ASSISTANT_STATUS,
            RfxStatusChangeCallback(this, &RpSysController::onTelephonyAssistantStatusChanged));
#endif

    char tempstr[RFX_PROPERTY_VALUE_MAX] = { 0 };
    memset(tempstr, 0, sizeof(tempstr));
    rfx_property_get("persist.vendor.radio.c_capability_slot", tempstr, "1");
    m_cslot = atoi(tempstr) - 1;

    RFX_LOG_D(RFX_LOG_TAG, "RpSysController[%d] %s-", m_slot_id, __FUNCTION__);
}

void RpSysController::onDeinit() {
    RFX_LOG_D(RFX_LOG_TAG, "RpSysController[%d] %s+", m_slot_id, __FUNCTION__);

    if (m_pChecker != NULL){
        delete(m_pChecker);
        m_pChecker = NULL;
    }

    RfxController::onDeinit();
    RFX_LOG_D(RFX_LOG_TAG, "RpSysController[%d] %s-", m_slot_id, __FUNCTION__);
}

int RpSysController::queryMainProtocol() {
    int main_sim = getMajorSim();

    mipc_sys_mapping_struct mapping;
    mipc_api_result_enum ret = mipc_sys_mapping_get_sync(slot_id_to_mipc_sim_id(m_slot_id), &mapping);
    if (ret == MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_D(RFX_LOG_TAG, "%s count=%d", __FUNCTION__, mapping.mapping_list_count);

        if (mapping.mapping_list_count >= getSimCount()) {
              for (int i = 0; i < getSimCount(); i++) {
                  RFX_LOG_D(RFX_LOG_TAG, "%s mapping_list[%d]=%d",
                          __FUNCTION__, i, mapping.mapping_list[i].ps_id);

                  if (mapping.mapping_list[i].ps_id == 0) {
                      RFX_LOG_D(RFX_LOG_TAG, "%s main_sim=%d", __FUNCTION__, i + 1);
                      return (i + 1);
                  }
              }

        } else {
            RFX_LOG_W(RFX_LOG_TAG, "%s mapping_list_count(%d) < SimCount(%d)",
                    __FUNCTION__, mapping.mapping_list_count, getSimCount());
        }

    } else {
        RFX_LOG_E(RFX_LOG_TAG, "%s mipc_sys_mapping_get_sync fail", __FUNCTION__);
    }

    RFX_LOG_D(RFX_LOG_TAG, "%s return original main_sim=%d", __FUNCTION__, main_sim);
    return main_sim;
}

void RpSysController::queryTplusWSupport() {
    RFX_LOG_D(RFX_LOG_TAG, "queryTplusWSupport, 2735 don't support TDS");
    rfx_property_set("vendor.ril.simswitch.tpluswsupport", "1");
}

void RpSysController::queryKeep3GMode() {
    RFX_LOG_D(RFX_LOG_TAG, "queryKeep3GMode, 2735 don't support TDS");
    //keep_3g_mode, 0:keep TD-SCDMA, 1:keep WCDMA
    rfx_property_set("vendor.ril.nw.worldmode.keep_3g_mode", "1");
}

void RpSysController::queryNoResetSupport() {
    RFX_LOG_D(RFX_LOG_TAG, "queryNoResetSupport, Gen97 always support");
    rfx_property_set("vendor.ril.simswitch.no_reset_support", "1");
}

void RpSysController::queryActiveMode() {
    // Gen 97 is always on FDD mode
    rfx_property_set("vendor.ril.nw.worldmode.activemode", "1");
}

void RpSysController::queryBearer() {
    int err;
    int ret = 0;
    int ap_max_rat = RAF_GPRS;
    int radio_capability;
    int main_slot = getMajorSim() - 1;
    char tempstr[RFX_PROPERTY_VALUE_MAX] = { 0 };

    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s+", m_slot_id, __FUNCTION__);

#if 0
//For DEBUG
#define PROPERTY_BUILD_RAT_CONFIG    "ro.vendor.mtk.protocol1.rat.config"
#define PROPERTY_RAT_CONFIG     "ro.boot.opt.ps1.rat"
#define PROPERTY_IS_USING_DEFAULT_CONFIG    "ro.boot.opt_using_default"

    for (int i=0; i < getSimCount(); i++) {
        rfx_property_get(rat_properties[i], tempstr, "DEFAULT");
        RFX_LOG_D(RFX_LOG_TAG, "DEBUG [%s]=%s", rat_properties[i], tempstr);
    }

    rfx_property_get(PROPERTY_BUILD_RAT_CONFIG, tempstr, "DEFAULT");
    RFX_LOG_D(RFX_LOG_TAG, "DEBUG [%s]=%s", PROPERTY_BUILD_RAT_CONFIG, tempstr);
    rfx_property_get(PROPERTY_RAT_CONFIG, tempstr, "DEFAULT");
    RFX_LOG_D(RFX_LOG_TAG, "DEBUG [%s]=%s", PROPERTY_RAT_CONFIG, tempstr);
    rfx_property_get(PROPERTY_IS_USING_DEFAULT_CONFIG, tempstr, "DEFAULT");
    RFX_LOG_D(RFX_LOG_TAG, "DEBUG [%s]=%s", PROPERTY_IS_USING_DEFAULT_CONFIG, tempstr);

//rfx_property_set(PROPERTY_BUILD_RAT_CONFIG, "N/Lf/Lt/W/G");
//rfx_property_set(PROPERTY_RAT_CONFIG, "N/Lf/Lt/W/G");
//rfx_property_set(rat_properties[0], "N/Lf/Lt/W/G");
//rfx_property_set(rat_properties[1], "Lf/Lt/W/G");
#endif

    if (main_slot == m_slot_id) {
        rfx_property_get(rat_properties[0], tempstr, "G");
        RFX_LOG_D(RFX_LOG_TAG, "[%s]=%s", rat_properties[0], tempstr);

    } else if (main_slot > m_slot_id) {
        rfx_property_get(rat_properties[m_slot_id + 1], tempstr, "G");
        RFX_LOG_D(RFX_LOG_TAG, "[%s]=%s", rat_properties[m_slot_id + 1], tempstr);

    } else {
        rfx_property_get(rat_properties[m_slot_id], tempstr, "G");
        RFX_LOG_D(RFX_LOG_TAG, "[%s]=%s", rat_properties[m_slot_id], tempstr);
    }

    // query project config capability
    if (strchr(tempstr, 'G') != NULL && RatConfig_isGsmSupported()) {
        ap_max_rat |= RAF_GSM;
    }
    if (strchr(tempstr, 'W') != NULL && RatConfig_isWcdmaSupported()) {
        ap_max_rat |= RAF_UMTS;
    }
    if (strchr(tempstr, 'T') != NULL && RatConfig_isTdscdmaSupported()) {
        ap_max_rat |= RAF_TD_SCDMA;
    }
    if (strchr(tempstr, 'L') != NULL &&
        (RatConfig_isLteFddSupported() || RatConfig_isLteTddSupported())) {
        ap_max_rat |= RAF_LTE;
    }
    if (strchr(tempstr, 'N') != NULL && RatConfig_isNrSupported()) {
        ap_max_rat |= RAF_NR;
    }

    int major_slot = getMajorSim() - 1;
    if (major_slot == m_slot_id) {
        // use RAF_GPRS as the main protocol flag
        // for 3 SIMs project, if the rat value is same for two protocols
        // AOSP logic cannot find out the main protocol
        ap_max_rat |= RAF_GPRS;
    } else {
        ap_max_rat &= (~RAF_GPRS);
    }
    radio_capability = ap_max_rat;
    getStatusManager(m_slot_id)->setIntValue(
            RFX_STATUS_KEY_SLOT_FIXED_CAPABILITY, radio_capability, false, false);

    RFX_LOG_D(RFX_LOG_TAG, "ap_max_rat=%x, Fixed radio_capability=%d", ap_max_rat, radio_capability);

    if (major_slot != m_slot_id && getActiveMode() == 2 &&
        isTplusWSupport() == false &&
        getKeep3GMode() == 0) {
        // Remove 3G raf for non major SIMs in TDD mode
        radio_capability &= ~RAF_UMTS;
    }
    if(RtcCapabilitySwitchUtil::isDisableC2kCapability() == false &&
            RatConfig_isC2kSupported()) {
        memset(tempstr, 0, sizeof(tempstr));
        rfx_property_get("persist.vendor.radio.c_capability_slot", tempstr, "1");
        int cslot = atoi(tempstr) - 1;
        RFX_LOG_I(RFX_LOG_TAG, "queryBearer, cslot=%d", cslot);
        if (cslot == m_slot_id || (cslot < 0 && m_slot_id == 0)) {
            radio_capability |= (RAF_CDMA_GROUP | RAF_EVDO_GROUP);
        }
    }
    RFX_LOG_D(RFX_LOG_TAG, "ap_max_rat=%x, Final radio_capability=%d", ap_max_rat, radio_capability);
    getStatusManager(m_slot_id)->setIntValue(
            RFX_STATUS_KEY_SLOT_CAPABILITY, radio_capability, false, false);

    RFX_LOG_D(RFX_LOG_TAG, "[%d] %s-", m_slot_id, __FUNCTION__);
}


bool RpSysController::isPendingUndoneSwitch() {
    int undone_sim = getUndoneSwitch() + 1;
    int main_sim = getMajorSim();
    if (undone_sim != 0 && undone_sim != main_sim) {
        return true;
    }
    return false;
}

int RpSysController::getUndoneSwitch() {
    char temp[RFX_PROPERTY_VALUE_MAX] = { 0 };
    int ret;
    rfx_property_get("persist.vendor.radio.pendcapswt", temp, "-1");
    ret = atoi(temp);
    if ((ret < -1) || (ret >= getSimCount())) {
        ret = -1;
    }
    return ret;
}

bool RpSysController::onPreviewMessage(const sp<RfxMessage>& message) {
    int msg_id = message->getId();
    int msg_type = message->getType();
    bool ret = false;

    if (msg_type == REQUEST && msg_id == RIL_REQUEST_SET_RADIO_CAPABILITY) {
        RFX_LOG_D(RFX_LOG_TAG, "[%d]%s request %d", m_slot_id, __FUNCTION__, message->getId());

        RIL_RadioCapability capability;

        Parcel* p = message->getParcel();
        memset(&capability, 0, sizeof(RIL_RadioCapability));

        int start_position = p->dataPosition();
        p->readInt32(&capability.version);
        p->readInt32(&capability.session);
        p->readInt32(&capability.phase);
        p->readInt32(&capability.rat);
        strncpy(capability.logicalModemUuid, String8(p->readString16()).string(), MAX_UUID_LENGTH - 1);
        capability.logicalModemUuid[MAX_UUID_LENGTH - 1] = '\0';
        p->readInt32(&capability.status);
        p->setDataPosition(start_position);

        if (capability.phase == RC_PHASE_APPLY) {
            // record new main slot
            if (strstr(capability.logicalModemUuid, "0") != NULL) {
                m_new_main_slot = message->getSlotId();
                rfx_property_set("persist.vendor.radio.pendcapswt",
                                 String8::format("%d", m_new_main_slot).string());
            }
            RFX_LOG_D(RFX_LOG_TAG, "[%d]%s set m_new_main_slot=%d", m_slot_id, __FUNCTION__, m_new_main_slot);
        }

        if (capability.phase != RC_PHASE_FINISH ) {
            ret = getCapabilityChecker()->isReadyForSwitch(true);
            RFX_LOG_D(RFX_LOG_TAG, "onPreview[%d]: isReadyForSwitch:%d", m_slot_id, ret);
            return ret;
        }
    }
    return true;
}

RtcCapabilitySwitchChecker * RpSysController::getCapabilityChecker(){
    if (m_pChecker == NULL){
        m_pChecker = new RtcCapabilitySwitchChecker();
        if (m_pChecker  == NULL){
            RFX_LOG_E(RFX_LOG_TAG, "%s %d new fail", __FUNCTION__, __LINE__);
            RFX_ASSERT(m_pChecker != NULL);
        }
    }
    //RFX_LOG_D(RFX_LOG_TAG, "%s %d m_pChecker[%p]", __FUNCTION__, __LINE__, m_pChecker);
    return  m_pChecker;
}

void RpSysController::calculateNewMainSlot(int capability, int slot, char* modemId) {
    int diff = (m_max_capability ^ capability);
    if (strstr(modemId, "0") != NULL) {
        m_new_main_slot_by_modem_id = slot;
    } else if ((strcmp(modemId, "") == 0) && (m_new_main_slot_by_modem_id == -1)) {
        RFX_LOG_D(RFX_LOG_TAG, "calculateMainSlot, modemId is wrong, switch to default data sim");
        m_new_main_slot_by_modem_id = getNonSlotScopeStatusManager()->getIntValue(
                RFX_STATUS_KEY_DEFAULT_DATA_SIM);
    }
    RFX_LOG_D(RFX_LOG_TAG,
         "calculateMainSlot,maxCap=%d, newMainSlot=%d, cap=%d, slot=%d, id=%s, newMainSlotById=%d",
         m_max_capability, m_new_main_slot, capability, slot, modemId, m_new_main_slot_by_modem_id);

    if (diff & RAF_LTE) {
        if (capability & RAF_LTE) {
            m_max_capability = capability;
            m_new_main_slot = slot;
        }
    } else if (diff & RAF_TD_SCDMA) {
        if (capability & RAF_TD_SCDMA) {
            m_max_capability = capability;
            m_new_main_slot = slot;
        }
    } else if (diff & RAF_UMTS) {
        if (capability & RAF_UMTS) {
            m_max_capability = capability;
            m_new_main_slot = slot;
        }
    }
    if (m_new_main_slot_by_modem_id != -1) {
        m_new_main_slot = m_new_main_slot_by_modem_id;
        RFX_LOG_D(RFX_LOG_TAG, "calculateMainSlot newMainSlot=%d", m_new_main_slot);
    }
}

bool RpSysController::onHandleRequest(const sp<RfxMessage>& message) {
    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s+ request %d", m_slot_id, __FUNCTION__, message->getId());

    bool ret = true;

    RfxDispatchThread::addMessageToPendingQueue(message);

    switch (message->getId()) {
    case RIL_REQUEST_OEM_HOOK_RAW:
        handleATRequest(message);
        break;
    case RIL_REQUEST_DEVICE_IDENTITY:
    case RIL_REQUEST_GET_IMEI:
    case RIL_REQUEST_GET_IMEISV:
    case RIL_REQUEST_BASEBAND_VERSION:
        handleRequestDeviceIdentity(message);
        break;
    case RIL_REQUEST_GET_RADIO_CAPABILITY:
        handleGetRadioCapability(message);
        break;
    case RIL_REQUEST_SET_RADIO_CAPABILITY:
        ret = handleSetRadioCapability(message);
        break;
    default:
        RFX_LOG_D(RFX_LOG_TAG, "unknown request, ignore!");
        break;
    }

    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s-", m_slot_id, __FUNCTION__);
    return ret;
}

void RpSysController::handleATRequest(const sp<RfxMessage>& request) {
    RFX_LOG_D(RFX_LOG_TAG, "handleATRequest with clientId: %d, with token: %d",
            request->getClientId(), request->getToken());
    int32_t len;
    int32_t status;
    const void *data;
    char *cdata;

    Parcel *p = request->getParcel();
    if(p != NULL) {
        status = p->readInt32(&len);
        if (status != 0) {
            RFX_LOG_D(RFX_LOG_TAG,"handleATRequest readerror\n");
            return;
        }

        if (((int)len) <= 0) {
            data = NULL;
            cdata = NULL;
            len = 0;
            RFX_LOG_D(RFX_LOG_TAG,"handleATRequest data NULL\n");

        } else {
            data = p->readInplace(len);

            cdata = (char *)malloc(len+1);
            memset(cdata, 0, sizeof(cdata));
            memcpy(cdata, data, len);
            cdata[len] = '\0';

            RFX_LOG_D(RFX_LOG_TAG,"handleATRequest data %s\n", data);
            RFX_LOG_D(RFX_LOG_TAG,"handleATRequest cdata %s, strlen=%d\n", cdata, strlen(cdata));
            RFX_LOG_D(RFX_LOG_TAG,"handleATRequest len %d\n", len);
        }
    }

    //assign parameter from request data to mipc api parameter
    mipc_api_result_enum result = mipc_sys_at_async(slot_id_to_mipc_sim_id(request->getSlotId()),mipc_sys_at_cb, (void *)request->getRilToken(), (const char *)cdata);
    if (result == MIPC_API_RESULT_FAIL) {
        rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_GENERIC_FAILURE);
    }

    if (NULL != cdata) {
        free(cdata);
    }
}

void RpSysController::handleRequestDeviceIdentity(const sp<RfxMessage>& request) {

    mipc_sys_info_get_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_sys_info_get_cb,request->getRilToken());

}

void RpSysController::handleGetRadioCapability(const sp<RfxMessage>& request) {
    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s+", m_slot_id, __FUNCTION__);

#if 0
// Use MIPC interface
    uint8_t mapping_list_count = getSimCount();
    mipc_sys_mapping_struct4 mapping_list[mapping_list_count];

    for (int i = RFX_SLOT_ID_0; i < getSimCount(); i++) {
        if (i == m_new_main_slot) {
            mapping_list[i] = 1;

        } else {
            mapping_list[i] = 0;
        }
    }

    mipc_sys_mapping_get_async(
        slot_id_to_mipc_sim_id(request->getSlotId()),
        MIPC_SYS_MAPPING_GET_CB cb,
        (void *)request->getRilToken())

#else
// Use rild internal infomation

    int radio_capability;
    int session_id = -1;
    RIL_RadioCapability rc;
    memset(&rc, 0, sizeof(RIL_RadioCapability));
    rc.version = RIL_RADIO_CAPABILITY_VERSION;
    rc.session = session_id;
    rc.phase = RC_PHASE_UNSOL_RSP;
    rc.status = RC_STATUS_SUCCESS;
    radio_capability = getStatusManager(m_slot_id)->getIntValue(RFX_STATUS_KEY_SLOT_CAPABILITY, 0);
    if(RtcCapabilitySwitchUtil::isDisableC2kCapability() == false &&
            RatConfig_isC2kSupported()) {
        // always send CDMA capability from Android Q
        radio_capability |= (RAF_CDMA_GROUP | RAF_EVDO_GROUP);
    }

    RFX_LOG_D(RFX_LOG_TAG, "requestGetRadioCapability, cap[%d] = %d, sizeof(RIL_RadioCapability)=%d",
         m_slot_id, radio_capability, (int)sizeof(RIL_RadioCapability));
    rc.rat = radio_capability;
    getLogicalModemId(rc.logicalModemUuid, MAX_UUID_LENGTH, m_slot_id);

    Parcel *p_rsp = new Parcel();
    p_rsp->writeInt32(rc.version);
    p_rsp->writeInt32(rc.session);
    p_rsp->writeInt32(rc.phase);
    p_rsp->writeInt32(rc.rat);
    writeStringToParcel(p_rsp, rc.logicalModemUuid);
    p_rsp->writeInt32(rc.status);

    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s logicalModemUuid=%s", m_slot_id, __FUNCTION__, rc.logicalModemUuid);

    rfx_enqueue_response_message(p_rsp,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_SUCCESS);

    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s-", m_slot_id, __FUNCTION__);
#endif
}

bool RpSysController::handleSetRadioCapability(const sp<RfxMessage>& request) {
    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s+", m_slot_id, __FUNCTION__);

//DEBUG
#if 0
    char* argv[7] = {"RIL_REQUEST_SET_RADIO_CAPABILITY", "0", "1", "2", "0","modem_sys1_ps0","0"};
    //version
    p.writeInt32(atoi(argv[1]));
    //session
    p.writeInt32(atoi(argv[2]));
    //phase
    p.writeInt32(atoi(argv[3]));
    //rat
    p.writeInt32(atoi(argv[4]));
    //logicalModemUuid
    writeStringToParcel(p,(const char *) argv[5]);
    //status
    p.writeInt32(atoi(argv[6]));
#endif
//DEBUG

    int status;
    int t = 0;
    RIL_RadioCapability capability;

    Parcel* p = request->getParcel();
    memset(&capability, 0, sizeof(RIL_RadioCapability));

    int start_position = p->dataPosition();
    status = p->readInt32(&capability.version);
    status = p->readInt32(&capability.session);
    status = p->readInt32(&capability.phase);
    status = p->readInt32(&capability.rat);
    strncpy(capability.logicalModemUuid, String8(p->readString16()).string(), MAX_UUID_LENGTH - 1);
    capability.logicalModemUuid[MAX_UUID_LENGTH - 1] = '\0';
    status = p->readInt32(&capability.status);
    p->setDataPosition(start_position);

    RFX_LOG_D(RFX_LOG_TAG, "%s RIL_REQUEST_SET_RADIO_CAPABILITY {version=%d, session=%d, phase=%d, rat=0x%x, rc->logicalModemUuid=%s, rc->status=%d",
        __FUNCTION__, capability.version, capability.session, capability.phase,
        capability.rat, capability.logicalModemUuid, capability.status);

    switch (capability.phase) {
        case RC_PHASE_START: {
            RFX_LOG_D(RFX_LOG_TAG, "%s RC_PHASE_START", __FUNCTION__);
            if ((strcmp(capability.logicalModemUuid, "") == 0) &&
                    (capability.rat == 0)) {
                RFX_LOG_I(RFX_LOG_TAG, "%s invalid modem uuid, return!", __FUNCTION__);
                rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_INVALID_ARGUMENTS);
                return false;
            }

            m_max_capability = 0;
            m_new_main_slot = 0;
            m_new_main_slot_by_modem_id = -1;
            m_is_started = true;

            rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_SUCCESS);
            break;
        }
        case RC_PHASE_APPLY: {
            RFX_LOG_D(RFX_LOG_TAG, "%s RC_PHASE_APPLY", __FUNCTION__);

            if (m_is_started == true) {
                // Legacy three-physes solution
                calculateNewMainSlot(capability.rat, request->getSlotId(),
                                     capability.logicalModemUuid);

                rfx_property_set("vendor.ril.rc.session.id1",
                                 String8::format("%d", capability.session).string());

                if (getCapabilityChecker()->isSkipCapabilitySwitch(m_new_main_slot)) {
                    m_is_started = false;

                    // update state key to broadcast the skipped sim switch
                    getNonSlotScopeStatusManager()->setIntValue(
                            RFX_STATUS_KEY_CAPABILITY_SWITCH_STATE,
                            CAPABILITY_SWITCH_STATE_NO_NEED);
                    getNonSlotScopeStatusManager()->setIntValue(
                            RFX_STATUS_KEY_CAPABILITY_SWITCH_STATE,
                            CAPABILITY_SWITCH_STATE_IDLE);

                    //No need to do, send urc to rilj directly
                    rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_SUCCESS);
                    updateRadioCapability();
                    return true;
                }

                ///TODO: check op rules
                m_pending_request = request;
                handleRequestSwitchCapability(request);
            } else {
                RFX_LOG_D(RFX_LOG_TAG, "%s New one-physe solution", __FUNCTION__);

                // New one-physe solution, only one apply request to new main slot
                if (!getCapabilityChecker()->isSkipCapabilitySwitch(m_new_main_slot)) {
                    m_pending_request = request;
                    handleRequestSwitchCapability(request);
                } else {
                    rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_SUCCESS);
                }
            }
            break;;
        }
        case RC_PHASE_FINISH: {
            RFX_LOG_D(RFX_LOG_TAG, "%s RC_PHASE_FINISH", __FUNCTION__);
            rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_SUCCESS);
            break;
        }
        default:
            RFX_LOG_E(RFX_LOG_TAG, "%s default", __FUNCTION__);
            rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_INVALID_ARGUMENTS);
            break;
    }

    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s-", m_slot_id, __FUNCTION__);

    return true;
}

void RpSysController::requestSetMajorSim(const sp<RfxMessage>& request) {
    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s+", m_slot_id, __FUNCTION__);

    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;

    int old_major_slot = getNonSlotScopeStatusManager()->getIntValue(
            RFX_STATUS_KEY_MAIN_CAPABILITY_SLOT, 0);

    RFX_LOG_I(RFX_LOG_TAG, "requestSetMajorSim old_major_slot=%d, m_new_main_slot=%d",
         old_major_slot, m_new_main_slot);

    mipc_sys_mapping_struct sys_mapping;
    uint8_t mapping_list_count = getSimCount();
    mipc_sys_mapping_struct4 ps_list[4] = {0};

    if (m_new_main_slot == 0) {
        // PS1 on SIM1
        ps_list[0].ps_id = 0;
        ps_list[1].ps_id = 1;
        ps_list[2].ps_id = 2;
        ps_list[3].ps_id = 3;
    } else if (m_new_main_slot == 1) {
        // PS1 on SIM2
        ps_list[0].ps_id = 1;
        ps_list[1].ps_id = 0;
        ps_list[2].ps_id = 2;
        ps_list[3].ps_id = 3;
    }  else if (m_new_main_slot == 2) {
        // PS1 on SIM3
        ps_list[0].ps_id = 1;
        ps_list[1].ps_id = 2;
        ps_list[2].ps_id = 0;
        ps_list[3].ps_id = 3;
    }   else if (m_new_main_slot == 3) {
        // PS1 on SIM3
        ps_list[0].ps_id = 1;
        ps_list[1].ps_id = 2;
        ps_list[2].ps_id = 3;
        ps_list[3].ps_id = 0;
    }

    sys_mapping.mapping_list_count = mapping_list_count;
    for (int i=0; i<mapping_list_count; i++) {
        sys_mapping.mapping_list[i].ps_id = ps_list[i].ps_id;
    }

    int sid = m_slot_id;
    if (request != NULL) {
        RFX_LOG_D(RFX_LOG_TAG, "request != NULL, mslot=%d, requestid=%d, sid=%d", m_slot_id, request->getSlotId(), sid);
        sid = request->getSlotId();
    }
    RFX_LOG_D(RFX_LOG_TAG, "sendMipcRequest: mslot=%d, sid=%d", m_slot_id, sid);

    ret = mipc_sys_mapping_set_sync(
            slot_id_to_mipc_sim_id(sid),
            &sys_mapping,
            mapping_list_count,
            ps_list);

    RFX_LOG_D(RFX_LOG_TAG, "sendMipcRequest: ret=%d", ret);
    setSimSwitchProp(old_major_slot, m_new_main_slot);

    processSetMajorSimResponse(request);
    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s-", m_slot_id, __FUNCTION__);
}

void RpSysController::processSetMajorSimResponse(const sp<RfxMessage> &message) {
    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s+", m_slot_id, __FUNCTION__);

    char property_value[RFX_PROPERTY_VALUE_MAX] = { 0 };
    int session_id;

    rfx_property_get("vendor.ril.rc.session.id1", property_value, "-1");
    session_id = atoi(property_value);
    if (message != NULL && message->getError() != RIL_E_SUCCESS) {
        RFX_LOG_E(RFX_LOG_TAG, "processSetMajorSimResponse fail");

    } else {
        int modem_off_state = getLockState(MAX_RFX_SLOT_ID, RFX_STATUS_KEY_MODEM_OFF_STATE);
        if (modem_off_state == MODEM_OFF_BY_SIM_SWITCH) {
            resetLock(MAX_RFX_SLOT_ID, RFX_STATUS_KEY_MODEM_OFF_STATE);
        }
        getNonSlotScopeStatusManager()->setIntValue(RFX_STATUS_KEY_CAPABILITY_SWITCH_STATE,
                CAPABILITY_SWITCH_STATE_ENDING);
        if (m_pending_request != NULL && message != NULL) {
            rfx_enqueue_response_message(NULL,message->getRilToken(),(RIL_SOCKET_ID)message->getSlotId(),RIL_E_SUCCESS);
            m_pending_request = NULL;
        }
        rfx_property_set("persist.vendor.radio.pendcapswt", String8::format("%d", -1).string());
        updateRadioCapability();
        notifySetRatDone();
    }

    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s-", m_slot_id, __FUNCTION__);
}

void RpSysController::handleRequestSwitchCapability(const sp<RfxMessage>& request) {
    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s+", m_slot_id, __FUNCTION__);

    setAllLocks();
    // backupRadioPower();
    // powerOffRadio();
    requestSetMajorSim(request);

    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s-", m_slot_id, __FUNCTION__);
}

// No need when using MIPC
#if 0
void RpSysController::onDefaultDataChanged(RfxStatusKeyEnum key,
        RfxVariant old_value, RfxVariant new_value) {
    int old_slot = old_value.asInt();
    int new_slot = new_value.asInt();
    RFX_LOG_D(RFX_LOG_TAG, "%s+ %s(%d==>%d", __FUNCTION__,
            RfxStatusManager::getKeyString(key), old_slot, new_slot);

    rfx_property_set("persist.vendor.radio.pendcapswt",
                     String8::format("%d", new_slot).string());

    /*
    if (m_checker_controller->isReadyForSwitch(true) && m_is_started == false) {
        checkAndSwitchCapability();
    } else {
        logD(RFX_LOG_TAG, "onDefaultDataChanged, not ready for switch");
        registerStatusKeys();
    }
    */

    RFX_LOG_D(RFX_LOG_TAG, "%s-", __FUNCTION__);
}
#endif

void RpSysController::onVolteStateChanged(RfxStatusKeyEnum key,
        RfxVariant old_value, RfxVariant new_value) {
    RFX_LOG_D(RFX_LOG_TAG, "%s+", __FUNCTION__);

    int old_state = old_value.asInt();
    int high_priority_slot = getCapabilityChecker()->getHigherPrioritySlot();
    RFX_LOG_D(RFX_LOG_TAG, "onVolteStateChanged:%s(%s==>%s), high_priority_slot = %d",
         RfxStatusManager::getKeyString(key), old_value.toString().string(),
         new_value.toString().string(), high_priority_slot);

    if (high_priority_slot >= 0 && old_state != -1) {
        if (getCapabilityChecker()->isReadyForSwitch(true) && m_is_started == false) {
            checkAndSwitchCapability();
        } else {
            RFX_LOG_D(RFX_LOG_TAG, "onVolteStateChanged, not ready for switch");
            registerStatusKeys();
        }
    }

    RFX_LOG_D(RFX_LOG_TAG, "%s-", __FUNCTION__);
}

void RpSysController::notifySetRatDone() {
    int state = getLockState(MAX_RFX_SLOT_ID, RFX_STATUS_KEY_CAPABILITY_SWITCH_STATE);
    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s+ state: %d", m_slot_id, __FUNCTION__, state);
    if (state == CAPABILITY_SWITCH_STATE_ENDING) {
        getNonSlotScopeStatusManager()->setIntValue(
                RFX_STATUS_KEY_CAPABILITY_SWITCH_STATE, CAPABILITY_SWITCH_STATE_IDLE);
        resetLock(MAX_RFX_SLOT_ID, RFX_STATUS_KEY_CAPABILITY_SWITCH_STATE);
        m_is_started = false;
    }

    for (int i = 0; i < getSimCount(); i++) {
        RadioPowerLock radio_lock = (RadioPowerLock) getLockState(i, RFX_STATUS_KEY_RADIO_LOCK);
        if (radio_lock == RADIO_LOCK_BY_SIM_SWITCH) {
            resetLock(i, RFX_STATUS_KEY_RADIO_LOCK);
        }
    }

    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s-", m_slot_id, __FUNCTION__);
}

void RpSysController::setSimSwitchProp(int old_major_slot, int new_major_slot) {
    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s+", m_slot_id, __FUNCTION__);

    switchCapability(old_major_slot, new_major_slot);
    rfx_property_set("persist.vendor.radio.simswitch",
                     String8::format("%d", new_major_slot + 1).string());
    getNonSlotScopeStatusManager()->setIntValue(
            RFX_STATUS_KEY_MAIN_CAPABILITY_SLOT, new_major_slot, false, false);

    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s-", m_slot_id, __FUNCTION__);
}

void RpSysController::switchCapability(int old_major_slot, int new_major_slot) {
    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s+, old:%d -> new:%d",
            m_slot_id, __FUNCTION__, old_major_slot, new_major_slot);

    int tmp_capability;
    int cslot = -1;
    char tempstr[RFX_PROPERTY_VALUE_MAX] = { 0 };

    if (getSimCount() > 2) {
        return shiftCapability(old_major_slot, new_major_slot);
    }
    if (old_major_slot != 0) {
        tmp_capability = getStatusManager(old_major_slot)->getIntValue(
                RFX_STATUS_KEY_SLOT_FIXED_CAPABILITY, 0);
        getStatusManager(old_major_slot)->setIntValue(
                RFX_STATUS_KEY_SLOT_FIXED_CAPABILITY, getStatusManager(0)->getIntValue(
                        RFX_STATUS_KEY_SLOT_FIXED_CAPABILITY, 0), false, false);
        getStatusManager(0)->setIntValue(
                RFX_STATUS_KEY_SLOT_FIXED_CAPABILITY, tmp_capability, false, false);
    }
    if (new_major_slot != 0) {
        tmp_capability = getStatusManager(new_major_slot)->getIntValue(
                RFX_STATUS_KEY_SLOT_FIXED_CAPABILITY, 0);
        getStatusManager(new_major_slot)->setIntValue(
                RFX_STATUS_KEY_SLOT_FIXED_CAPABILITY, getStatusManager(0)->getIntValue(
                        RFX_STATUS_KEY_SLOT_FIXED_CAPABILITY, 0), false, false);
        getStatusManager(0)->setIntValue(
                RFX_STATUS_KEY_SLOT_FIXED_CAPABILITY, tmp_capability, false, false);
    }
    if (RtcCapabilitySwitchUtil::isDisableC2kCapability() == false && RatConfig_isC2kSupported()) {
        memset(tempstr, 0, sizeof(tempstr));
        rfx_property_get("persist.vendor.radio.c_capability_slot", tempstr, "1");
        cslot = atoi(tempstr) - 1;
        RFX_LOG_I(RFX_LOG_TAG, "switchCapability, cslot=%d", cslot);
    }
    if (old_major_slot != 0 && new_major_slot != 0) {
        tmp_capability = getStatusManager(0)->getIntValue(
                RFX_STATUS_KEY_SLOT_FIXED_CAPABILITY, 0);
        if (getActiveMode() == 2 && isTplusWSupport() == false &&
            getKeep3GMode() == 0) {
            // Remove 3G raf for non major SIMs in TDD mode
            tmp_capability &= ~RAF_UMTS;
        }
        if (cslot == 0) {
            tmp_capability |= (RAF_CDMA_GROUP | RAF_EVDO_GROUP);
        }
        getStatusManager(0)->setIntValue(
                RFX_STATUS_KEY_SLOT_CAPABILITY, tmp_capability, false, false);
    }

    tmp_capability = getStatusManager(old_major_slot)->getIntValue(
            RFX_STATUS_KEY_SLOT_FIXED_CAPABILITY, 0);
    if (getActiveMode() == 2 && isTplusWSupport() == false &&
        getKeep3GMode() == 0) {
        // Remove 3G raf for non major SIMs in TDD mode
        tmp_capability &= ~RAF_UMTS;
    }
    if (cslot == old_major_slot) {
        tmp_capability |= (RAF_CDMA_GROUP | RAF_EVDO_GROUP);
    }
    getStatusManager(old_major_slot)->setIntValue(
            RFX_STATUS_KEY_SLOT_CAPABILITY, tmp_capability, false, false);

    tmp_capability = getStatusManager(new_major_slot)->getIntValue(
            RFX_STATUS_KEY_SLOT_FIXED_CAPABILITY, 0);
    if (cslot == new_major_slot) {
        tmp_capability |= (RAF_CDMA_GROUP | RAF_EVDO_GROUP);
    }
    getStatusManager(new_major_slot)->setIntValue(
            RFX_STATUS_KEY_SLOT_CAPABILITY, tmp_capability, false, false);

    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s-", m_slot_id, __FUNCTION__);
}

void RpSysController::shiftCapability(int old_major_slot, int new_major_slot) {
    RFX_LOG_D(RFX_LOG_TAG, "%s+", __FUNCTION__);

    if (old_major_slot == new_major_slot) {
        RFX_LOG_D(RFX_LOG_TAG, "shiftCapability:old=new=%d", old_major_slot);
        return;
    }
    int step = (new_major_slot > old_major_slot) ? 1 : -1;
    for (int i = old_major_slot; i != new_major_slot; i += step) {
        switchFixedCapability(i, i + step);
        setCapabilityByConfig(i, false);
    }
    setCapabilityByConfig(new_major_slot, true);

    RFX_LOG_D(RFX_LOG_TAG, "%s-", __FUNCTION__);
}

void RpSysController::switchFixedCapability(int slot_a, int slot_b) {
    RFX_LOG_D(RFX_LOG_TAG, "%s+", __FUNCTION__);

    int tmp_capability = getStatusManager(slot_a)->getIntValue(
            RFX_STATUS_KEY_SLOT_FIXED_CAPABILITY, 0);
    getStatusManager(slot_a)->setIntValue(
            RFX_STATUS_KEY_SLOT_FIXED_CAPABILITY, getStatusManager(slot_b)->getIntValue(
                    RFX_STATUS_KEY_SLOT_FIXED_CAPABILITY, 0), false, false);
    getStatusManager(slot_b)->setIntValue(
            RFX_STATUS_KEY_SLOT_FIXED_CAPABILITY, tmp_capability, false, false);

    RFX_LOG_D(RFX_LOG_TAG, "%s-", __FUNCTION__);
}

void RpSysController::setCapabilityByConfig(int slot, bool is_major_slot) {
    RFX_LOG_D(RFX_LOG_TAG, "%s+", __FUNCTION__);

    int cslot = -1;
    char tempstr[RFX_PROPERTY_VALUE_MAX] = { 0 };
    if (RtcCapabilitySwitchUtil::isDisableC2kCapability() == false && RatConfig_isC2kSupported()) {
        memset(tempstr, 0, sizeof(tempstr));
        rfx_property_get("persist.vendor.radio.c_capability_slot", tempstr, "1");
        cslot = atoi(tempstr) - 1;
    }
    int tmp_capability = getStatusManager(slot)->getIntValue(
        RFX_STATUS_KEY_SLOT_FIXED_CAPABILITY, 0);
    if (!is_major_slot && getActiveMode() == 2 && isTplusWSupport() == false &&
        getKeep3GMode() == 0) {
        // Remove 3G raf for non major SIMs in TDD mode
        tmp_capability &= ~RAF_UMTS;
    }
    if (cslot == slot) {
        tmp_capability |= (RAF_CDMA_GROUP | RAF_EVDO_GROUP);
    }
    RFX_LOG_D(RFX_LOG_TAG, "setCapabilityByConfig, cslot=%d,capa=%d", cslot, tmp_capability);
    getStatusManager(slot)->setIntValue(
            RFX_STATUS_KEY_SLOT_CAPABILITY, tmp_capability, false, false);

    RFX_LOG_D(RFX_LOG_TAG, "%s+", __FUNCTION__);
}

int RpSysController::getActiveMode() {
    char world_mode_prop[RFX_PROPERTY_VALUE_MAX] = {0};
    int world_mode = 0;

    rfx_property_get("vendor.ril.nw.worldmode.activemode", world_mode_prop, "1");
    world_mode = atoi(world_mode_prop);

    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s world_mode=%d", m_slot_id, __FUNCTION__, world_mode);

    return world_mode;
}

void RpSysController::setAllLocks(void) {
    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s", m_slot_id, __FUNCTION__);

    setLock(MAX_RFX_SLOT_ID, RFX_STATUS_KEY_MODEM_OFF_STATE);
    for (int i = RFX_SLOT_ID_0; i < getSimCount(); i++) {
        setLock(i, RFX_STATUS_KEY_RADIO_LOCK);
    }
    setLock(MAX_RFX_SLOT_ID, RFX_STATUS_KEY_CAPABILITY_SWITCH_STATE);
}

void RpSysController::setLock(int slot_id, RfxStatusKeyEnum key) {
    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s slot=%d, key=%d", m_slot_id, __FUNCTION__, slot_id, (int)key);
    switch (key) {
        case RFX_STATUS_KEY_MODEM_OFF_STATE: {
            getNonSlotScopeStatusManager()->setIntValue(key, MODEM_OFF_BY_SIM_SWITCH);
            break;
        }
        case RFX_STATUS_KEY_RADIO_LOCK: {
            if (slot_id >= RFX_SLOT_ID_0 && slot_id < MAX_RFX_SLOT_ID) {
                getStatusManager(slot_id)->setIntValue(key, RADIO_LOCK_BY_SIM_SWITCH);
            }
            break;
        }
        case RFX_STATUS_KEY_CAPABILITY_SWITCH_STATE: {
            getNonSlotScopeStatusManager()->setIntValue(key, CAPABILITY_SWITCH_STATE_START);
            break;
        }

        default:
            break;
    }
}

int RpSysController::getLockState(int slot_id, RfxStatusKeyEnum key) {
    int ret = -1;
    switch (key) {
        case RFX_STATUS_KEY_MODEM_OFF_STATE: {
            ret = getNonSlotScopeStatusManager()->getIntValue(
                    key, MODEM_OFF_IN_IDLE);
            break;
        }
        case RFX_STATUS_KEY_RADIO_LOCK: {
            if (slot_id >= RFX_SLOT_ID_0 && slot_id < MAX_RFX_SLOT_ID) {
                ret = getStatusManager(slot_id)->getIntValue(key, RADIO_LOCK_IDLE);
            }
            break;
        }
        case RFX_STATUS_KEY_CAPABILITY_SWITCH_STATE: {
            ret = getNonSlotScopeStatusManager()->getIntValue(key);
            break;
        }

        default:
            break;
    }

    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s slot_id=%d, key=%d, ret=%d",
            m_slot_id, __FUNCTION__, slot_id, (int)key, ret);
    return ret;
}

void RpSysController::resetLock(int slot_id, RfxStatusKeyEnum key) {
    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s slot_id=%d, key=%d",
            m_slot_id, __FUNCTION__, slot_id, key);

    switch (key) {
        case RFX_STATUS_KEY_MODEM_OFF_STATE: {
            getNonSlotScopeStatusManager()->setIntValue(key, MODEM_OFF_IN_IDLE);
            break;
        }
        case RFX_STATUS_KEY_RADIO_LOCK: {
            if (slot_id >= RFX_SLOT_ID_0 && slot_id < MAX_RFX_SLOT_ID) {
                getStatusManager(slot_id)->setIntValue(key, RADIO_LOCK_IDLE);
            }
            break;
        }
        case RFX_STATUS_KEY_CAPABILITY_SWITCH_STATE: {
            getNonSlotScopeStatusManager()->setIntValue(key, CAPABILITY_SWITCH_STATE_IDLE);
            break;
        }

        default:
            break;
    }
}

void RpSysController::checkAndSwitchCapability() {
    RFX_LOG_D(RFX_LOG_TAG, "%s+", __FUNCTION__);

    int high_priority_slot = getCapabilityChecker()->getHigherPrioritySlot();
    RFX_LOG_D(RFX_LOG_TAG, "checkAndSwitchCapability, high_priority_slot=%d", high_priority_slot);

    if (high_priority_slot >= 0) {
        m_new_main_slot = high_priority_slot;
    }
    if (getCapabilityChecker()->isSkipCapabilitySwitch(m_new_main_slot)) {
        return;
    }

    handleRequestSwitchCapability(NULL);

    RFX_LOG_D(RFX_LOG_TAG, "%s-", __FUNCTION__);
}

void RpSysController::registerStatusKeys() {
    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s+", m_slot_id, __FUNCTION__);

    for (int i = 0; i < getSimCount(); i++) {
        getStatusManager(i)->registerStatusChanged(
                RFX_STATUS_KEY_RADIO_LOCK,
                RfxStatusChangeCallback(this, &RpSysController::onStatusKeyChanged));
        if(getGeminiMode() == GEMINI_MODE_L_AND_L && getSimCount() == 2) {
            getStatusManager(i)->registerStatusChanged(
                    RFX_STATUS_KEY_GSM_IMSI, RfxStatusChangeCallback(
                    this, &RpSysController::onStatusKeyChanged));
            getStatusManager(i)->registerStatusChanged(
                    RFX_STATUS_KEY_C2K_IMSI, RfxStatusChangeCallback(
                    this, &RpSysController::onStatusKeyChanged));
        }

        // L5 will check phone call / ECC / sim state related, no need registered here.
        /*
        getStatusManager(i)->registerStatusChanged(
                RFX_STATUS_KEY_EMERGENCY_MODE,
                RfxStatusChangeCallback(this, &RpSysController::onStatusKeyChanged));
        getStatusManager(i)->registerStatusChanged(
                RFX_STATUS_KEY_AP_VOICE_CALL_COUNT,
                RfxStatusChangeCallback(this, &RpSysController::onStatusKeyChanged));
        getStatusManager(i)->registerStatusChanged(
                RFX_STATUS_KEY_EMERGENCY_CALLBACK_MODE,
                RfxStatusChangeCallback(this, &RpSysController::onStatusKeyChanged));
        getStatusManager(i)->registerStatusChanged(
                RFX_STATUS_KEY_SIM_STATE,
                RfxStatusChangeCallback(this, &RpSysController::onStatusKeyChanged));
        */
    }
    getNonSlotScopeStatusManager()->registerStatusChanged(
            RFX_STATUS_KEY_MODEM_OFF_STATE,
            RfxStatusChangeCallback(this, &RpSysController::onStatusKeyChanged));
    getNonSlotScopeStatusManager()->registerStatusChanged(
            RFX_STATUS_KEY_CAPABILITY_SWITCH_WAIT_MODULE,
            RfxStatusChangeCallback(this, &RpSysController::onStatusKeyChanged));
    getNonSlotScopeStatusManager()->registerStatusChanged(
            RFX_STATUS_KEY_CAPABILITY_SWITCH_STATE,
            RfxStatusChangeCallback(this, &RpSysController::onStatusKeyChanged));

    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s-", m_slot_id, __FUNCTION__);
}

void RpSysController::unregisterStatusKeys() {
    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s+", m_slot_id, __FUNCTION__);

    for (int i = 0; i < getSimCount(); i++) {
        getStatusManager(i)->unRegisterStatusChanged(
                RFX_STATUS_KEY_RADIO_LOCK,
                RfxStatusChangeCallback(this, &RpSysController::onStatusKeyChanged));
        if(getGeminiMode() == GEMINI_MODE_L_AND_L && getSimCount() == 2) {
            getStatusManager(i)->unRegisterStatusChanged(
                    RFX_STATUS_KEY_GSM_IMSI, RfxStatusChangeCallback(
                    this, &RpSysController::onStatusKeyChanged));
            getStatusManager(i)->unRegisterStatusChanged(
                    RFX_STATUS_KEY_C2K_IMSI, RfxStatusChangeCallback(
                    this, &RpSysController::onStatusKeyChanged));
        }

        // L5 will check phone call / ECC / sim state related, no need registered here.
        /*
        getStatusManager(i)->unRegisterStatusChanged(
                RFX_STATUS_KEY_EMERGENCY_MODE,
                RfxStatusChangeCallback(this, &RpSysController::onStatusKeyChanged));
        getStatusManager(i)->unRegisterStatusChanged(
                RFX_STATUS_KEY_AP_VOICE_CALL_COUNT,
                RfxStatusChangeCallback(this, &RpSysController::onStatusKeyChanged));
        getStatusManager(i)->unRegisterStatusChanged(
                RFX_STATUS_KEY_EMERGENCY_CALLBACK_MODE,
                RfxStatusChangeCallback(this, &RpSysController::onStatusKeyChanged));
        getStatusManager(i)->unRegisterStatusChanged(
                RFX_STATUS_KEY_SIM_STATE,
                RfxStatusChangeCallback(this, &RpSysController::onStatusKeyChanged));
        */
    }
    getNonSlotScopeStatusManager()->unRegisterStatusChanged(
            RFX_STATUS_KEY_MODEM_OFF_STATE,
            RfxStatusChangeCallback(this, &RpSysController::onStatusKeyChanged));
    getNonSlotScopeStatusManager()->unRegisterStatusChanged(
            RFX_STATUS_KEY_CAPABILITY_SWITCH_WAIT_MODULE,
            RfxStatusChangeCallback(this, &RpSysController::onStatusKeyChanged));
    getNonSlotScopeStatusManager()->unRegisterStatusChanged(
            RFX_STATUS_KEY_CAPABILITY_SWITCH_STATE,
            RfxStatusChangeCallback(this, &RpSysController::onStatusKeyChanged));

    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s-", m_slot_id, __FUNCTION__);
}

void RpSysController::onStatusKeyChanged(RfxStatusKeyEnum key,
        RfxVariant old_value, RfxVariant new_value) {
    if ((key == RFX_STATUS_KEY_GSM_IMSI) || (key == RFX_STATUS_KEY_C2K_IMSI)) {
        RFX_LOG_D(RFX_LOG_TAG, "[%d]onStatusKeyChanged:%s", m_slot_id, RfxStatusManager::getKeyString(key));
    } else {
        RFX_LOG_D(RFX_LOG_TAG, "[%d]onStatusKeyChanged:%s(%s==>%s)", m_slot_id, RfxStatusManager::getKeyString(key),
                old_value.toString().string(), new_value.toString().string());
    }

    if (getCapabilityChecker()->isReadyForSwitch(true) && m_is_started == false) {
        unregisterStatusKeys();
        checkAndSwitchCapability();
    }
}

void RpSysController::updateRadioCapability() {
    char temp[RFX_PROPERTY_VALUE_MAX] = { 0 };
    memset(temp, 0, sizeof(temp));
    rfx_property_get("persist.vendor.radio.c_capability_slot", temp, "1");
    int cslot = atoi(temp) - 1;
    updateRadioCapability(cslot);
}

// Only allow to be called by RtcModeSwitchController for once after SIM switch
void RpSysController::updateRadioCapability(int cslot) {
    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s+, cslot=%d", m_slot_id, __FUNCTION__, cslot);

    char property_value[RFX_PROPERTY_VALUE_MAX] = { 0 };
    int session_id;

    rfx_property_get("vendor.ril.rc.session.id1", property_value, "-1");
    session_id = atoi(property_value);
    if (session_id != -1 || getNonSlotScopeStatusManager()->getIntValue(
            RFX_STATUS_KEY_CAPABILITY_SWITCH_STATE) == CAPABILITY_SWITCH_STATE_ENDING) {
        updateRadioCapability(cslot, session_id);
        // Clear session id and set radio state if SIM switch has been done successfully
        rfx_property_set("vendor.ril.rc.session.id1", "-1");
        if (RtcCapabilitySwitchUtil::isDssNoResetSupport() == false) {
            for (int i = 0; i < getSimCount(); i++) {
                getStatusManager(i)->setIntValue(
                        RFX_STATUS_KEY_RADIO_STATE, RADIO_STATE_OFF, false, false);
            }
        }
        /*
        getNonSlotScopeStatusManager()->registerStatusChanged(
                RFX_STATUS_KEY_MODESWITCH_FINISHED,
                RfxStatusChangeCallback(this, &RtcCapabilityGetController::onModeSwitchFinished));
        */
    } else if (cslot != m_cslot || m_first_urc) {
        updateRadioCapability(cslot, session_id);
    } else {
        RFX_LOG_I(RFX_LOG_TAG, "updateRadioCapability cslot=%d is same with before.", cslot);
    }

    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s-", m_slot_id, __FUNCTION__);
}

void RpSysController::updateRadioCapability(int cslot, int session_id) {
    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s+ cslot=%d, session_id=%d", m_slot_id, __FUNCTION__, cslot, session_id);

    char property_value[RFX_PROPERTY_VALUE_MAX] = { 0 };
    int radio_capability;

    m_cslot = cslot;
    m_first_urc = false;

    if (RtcCapabilitySwitchUtil::isDisableC2kCapability()) {
        for (int i = 0; i < getSimCount(); i++) {
            radio_capability = getStatusManager(i)->getIntValue(RFX_STATUS_KEY_SLOT_CAPABILITY, 0);
            RFX_LOG_I(RFX_LOG_TAG, "updateRadioCapability, no c2k, session=%d, capability[%d] = 0x%x",
                 session_id, i, radio_capability);
            sendRadioCapabilityURC(i, session_id, radio_capability);
        }
    } else {
        for (int i = 0; i < getSimCount(); i++) {
            radio_capability = getStatusManager(i)->getIntValue(RFX_STATUS_KEY_SLOT_CAPABILITY, 0);
            if (i == cslot) {
                radio_capability |= (RAF_CDMA_GROUP | RAF_EVDO_GROUP);
            } else {
                radio_capability &= ~(RAF_CDMA_GROUP | RAF_EVDO_GROUP);
            }
            RFX_LOG_I(RFX_LOG_TAG, "updateRadioCapability, cslot=%d, session=%d, capability[%d] = 0x%x",
                 cslot, session_id, i, radio_capability);
            getStatusManager(i)->setIntValue(
                    RFX_STATUS_KEY_SLOT_CAPABILITY, radio_capability, false, false);

            // always send CDMA capability from Android Q
            radio_capability |= (RAF_CDMA_GROUP | RAF_EVDO_GROUP);
            sendRadioCapabilityURC(i, session_id, radio_capability);
        }
    }

    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s-", m_slot_id, __FUNCTION__);
}

void RpSysController::sendRadioCapabilityURC(int slot_id, int session_id, int radio_capability) {
    RFX_LOG_D(RFX_LOG_TAG, "%s+ slot_id=%d, session_id=%d, radio_capability=0x%x", __FUNCTION__,
            slot_id, session_id, radio_capability);

    RIL_RadioCapability rc;

    memset(&rc, 0, sizeof(RIL_RadioCapability));
    rc.version = RIL_RADIO_CAPABILITY_VERSION;
    rc.session = session_id;
    rc.phase = RC_PHASE_UNSOL_RSP;
    rc.status = RC_STATUS_SUCCESS;
    rc.rat = radio_capability;
    getLogicalModemId(rc.logicalModemUuid, MAX_UUID_LENGTH, slot_id);

    Parcel *parcel = new Parcel();
    parcel->writeInt32(rc.version);
    parcel->writeInt32(rc.session);
    parcel->writeInt32(rc.phase);
    parcel->writeInt32(rc.rat);
    writeStringToParcel(parcel, rc.logicalModemUuid);
    parcel->writeInt32(rc.status);

    rfx_enqueue_urc_message(RIL_UNSOL_RADIO_CAPABILITY,parcel,(RIL_SOCKET_ID)slot_id,RIL_E_SUCCESS);

    RFX_LOG_D(RFX_LOG_TAG, "%s-", __FUNCTION__);
}

