//SPDX-License-Identifier: MediaTekProprietary
/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  Copyright (c) [2020], MediaTek Inc. All rights reserved.
*  This software/firmware and related documentation ("MediaTek Software") are
*  protected under relevant copyright laws.
*
*  The information contained herein is confidential and proprietary to
*  MediaTek Inc. and/or its licensors. Except as otherwise provided in the
*  applicable licensing terms with MediaTek Inc. and/or its licensors, any
*  reproduction, modification, use or disclosure of MediaTek Software, and
*  information contained herein, in whole or in part, shall be strictly
*  prohibited.
*****************************************************************************/
#include "mipc_ecall_api.h"
#include <stddef.h>

static mipc_api_result_enum mipc_call_ivs_onekey_ecall_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_call_ivs_onekey_ecall_struct *result_ptr)
{
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    do {
        void* val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);
    return result;
}

static void mipc_call_ivs_onekey_ecall_cb(mipc_msg_t *msg_ptr, MIPC_CALL_IVS_ONEKEY_ECALL_CB cb, void *cb_priv_ptr)
{
    mipc_call_ivs_onekey_ecall_struct *result_ptr = (mipc_call_ivs_onekey_ecall_struct *)ALLOC(sizeof(mipc_call_ivs_onekey_ecall_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_call_ivs_onekey_ecall_struct));
        mipc_call_ivs_onekey_ecall_cnf_decode(msg_ptr, result_ptr);
    }
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);
    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_call_ivs_onekey_ecall(MIPC_CALL_IVS_ONEKEY_ECALL_CB cb,
        void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id,
        mipc_ecall_type_const_enum ecall_type,
        mipc_ecall_msd_format_const_enum ecall_format,
        unsigned int msd_length,
        unsigned char* msd_data,
        mipc_call_ivs_onekey_ecall_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_CALL_IVS_ONEKEY_ECALL_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_CALL_IVS_ONEKEY_ECALL_REQ_T_TYPE, ecall_type);
    if (msd_length > 0) {
        mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_CALL_IVS_ONEKEY_ECALL_REQ_T_MSD_FORMAT, ecall_format);
        if (msd_data) {
            mipc_msg_add_tlv(msg_req_ptr, MIPC_CALL_IVS_ONEKEY_ECALL_REQ_T_MSD, (msd_length < MIPC_MAX_ECALL_MSD_DATA_LEN ? msd_length :MIPC_MAX_ECALL_MSD_DATA_LEN), msd_data);
        } else {
            return MIPC_API_RESULT_FAIL;
        }
    }
    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_call_ivs_onekey_ecall_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_call_ivs_onekey_ecall_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_call_ivs_onekey_ecall_sync(mipc_sim_ps_id_enum sim_ps_id,
        mipc_call_ivs_onekey_ecall_struct *result_ptr,
        mipc_ecall_type_const_enum ecall_type,
        mipc_ecall_msd_format_const_enum ecall_format,
        unsigned int msd_length,
        unsigned char* msd_data)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_call_ivs_onekey_ecall(NULL, NULL, sim_ps_id, ecall_type, ecall_format, msd_length, msd_data, result_ptr);
}

mipc_api_result_enum mipc_call_ivs_onekey_ecall_async(mipc_sim_ps_id_enum sim_ps_id,
        MIPC_CALL_IVS_ONEKEY_ECALL_CB cb, void *cb_priv_ptr,
        mipc_ecall_type_const_enum ecall_type,
        mipc_ecall_msd_format_const_enum ecall_format,
        unsigned int msd_length,
        unsigned char* msd_data)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_call_ivs_onekey_ecall(cb, cb_priv_ptr, sim_ps_id, ecall_type, ecall_format, msd_length, msd_data, NULL);
}

static mipc_api_result_enum mipc_ecall_ivs_update_msd_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_ecall_ivs_update_msd_struct *result_ptr)
{
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    do {
        void* val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);
    return result;
}

static void mipc_ecall_ivs_update_msd_cb(mipc_msg_t *msg_ptr, MIPC_ECALL_IVS_UPDATE_MSD_CB cb, void *cb_priv_ptr)
{
    mipc_ecall_ivs_update_msd_struct *result_ptr = (mipc_ecall_ivs_update_msd_struct *)ALLOC(sizeof(mipc_ecall_ivs_update_msd_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_ecall_ivs_update_msd_struct));
        mipc_ecall_ivs_update_msd_cnf_decode(msg_ptr, result_ptr);
    }
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);
    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_ecall_ivs_update_msd(MIPC_ECALL_IVS_UPDATE_MSD_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id,
        mipc_ecall_msd_format_const_enum msd_format,
        unsigned int msd_length,
        unsigned char* msd_data,
        mipc_ecall_ivs_update_msd_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_ECALL_IVS_UPDATE_MSD_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_ECALL_IVS_UPDATE_MSD_REQ_T_MSD_FORMAT, msd_format);
    if (msd_data) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_ECALL_IVS_UPDATE_MSD_REQ_T_MSD_DATA, (msd_length < MIPC_MAX_ECALL_MSD_DATA_LEN ? msd_length :MIPC_MAX_ECALL_MSD_DATA_LEN), msd_data);
    }

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_ecall_ivs_update_msd_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_ecall_ivs_update_msd_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_ecall_ivs_update_msd_sync(mipc_sim_ps_id_enum sim_ps_id,
        mipc_ecall_ivs_update_msd_struct *result_ptr,
        mipc_ecall_msd_format_const_enum msd_format,
        unsigned int msd_length,
        unsigned char* msd_data)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_ecall_ivs_update_msd(NULL, NULL, sim_ps_id, msd_format, msd_length, msd_data, result_ptr);
}

mipc_api_result_enum mipc_ecall_ivs_update_msd_async(mipc_sim_ps_id_enum sim_ps_id,
        MIPC_ECALL_IVS_UPDATE_MSD_CB cb, void *cb_priv_ptr,
        mipc_ecall_msd_format_const_enum msd_format,
        unsigned int msd_length,
        unsigned char* msd_data)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_ecall_ivs_update_msd(cb, cb_priv_ptr, sim_ps_id, msd_format, msd_length, msd_data, NULL);
}

static mipc_api_result_enum mipc_ecall_ivs_reset_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_ecall_ivs_reset_struct *result_ptr)
{
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    do {
        void* val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);
    return result;
}

static void mipc_ecall_ivs_reset_cb(mipc_msg_t *msg_ptr, MIPC_ECALL_IVS_RESET_CB cb, void *cb_priv_ptr)
{
    mipc_ecall_ivs_reset_struct *result_ptr = (mipc_ecall_ivs_reset_struct *)ALLOC(sizeof(mipc_ecall_ivs_reset_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_ecall_ivs_reset_struct));
        mipc_ecall_ivs_reset_cnf_decode(msg_ptr, result_ptr);
    }
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);
    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_ecall_ivs_reset(MIPC_ECALL_IVS_RESET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id,
        mipc_ecall_ivs_reset_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_ECALL_IVS_RESET_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_ecall_ivs_reset_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_ecall_ivs_reset_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_ecall_ivs_reset_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_ecall_ivs_reset_struct *result_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_ecall_ivs_reset(NULL, NULL, sim_ps_id, result_ptr);
}

mipc_api_result_enum mipc_ecall_ivs_reset_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_ECALL_IVS_RESET_CB cb, void *cb_priv_ptr)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_ecall_ivs_reset(cb, cb_priv_ptr, sim_ps_id, NULL);
}

static mipc_api_result_enum mipc_ecall_ivs_set_reg_state_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_ecall_ivs_set_reg_state_struct *result_ptr)
{
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    do {
        void* val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);
    return result;
}

static void mipc_ecall_ivs_set_reg_state_cb(mipc_msg_t *msg_ptr, MIPC_ECALL_IVS_SET_REG_STATE_CB cb, void *cb_priv_ptr)
{
    mipc_ecall_ivs_set_reg_state_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_ecall_ivs_set_reg_state_struct));
    mipc_ecall_ivs_set_reg_state_cnf_decode(msg_ptr, &result_ptr);
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
}

static mipc_api_result_enum mipc_ecall_ivs_set_reg_state(MIPC_ECALL_IVS_SET_REG_STATE_CB cb,
        void *cb_priv_ptr,
        mipc_sim_ps_id_enum sim_ps_id,
        mipc_nw_register_mode_const_enum reg_state,
        mipc_ecall_ivs_set_reg_state_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_NW_SET_REGISTER_STATE_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_NW_SET_REGISTER_STATE_REQ_T_MODE, reg_state);

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_ecall_ivs_set_reg_state_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_ecall_ivs_set_reg_state_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_ecall_ivs_set_reg_state_sync(mipc_sim_ps_id_enum sim_ps_id,
        mipc_ecall_ivs_set_reg_state_struct *result_ptr,
        mipc_nw_register_mode_const_enum reg_state)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_ecall_ivs_set_reg_state(NULL, NULL, sim_ps_id, reg_state, result_ptr);
}

mipc_api_result_enum mipc_ecall_ivs_set_reg_state_async(mipc_sim_ps_id_enum sim_ps_id,
        MIPC_ECALL_IVS_SET_REG_STATE_CB cb, void *cb_priv_ptr,
        mipc_nw_register_mode_const_enum reg_state)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_ecall_ivs_set_reg_state(cb, cb_priv_ptr, sim_ps_id, reg_state, NULL);
}

static mipc_api_result_enum mipc_ecall_ivs_get_sim_info_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_ecall_ivs_get_sim_info_struct *result_ptr)
{
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;
    uint16_t val_len = 0;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    do {
        void* val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }

        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_ECALL_IVS_GET_SIM_INFO_CNF_T_SIM_TYPE, NULL);
        if (NULL == val_ptr) break;
        result_ptr->sim_type = (uint32_t)(*((uint32_t*)val_ptr));

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);
    return result;
}

static void mipc_ecall_ivs_get_sim_info_cb(mipc_msg_t *msg_ptr, MIPC_ECALL_IVS_GET_SIM_INFO_CB cb, void *cb_priv_ptr)
{
    mipc_ecall_ivs_get_sim_info_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_ecall_ivs_get_sim_info_struct));
    mipc_ecall_ivs_get_sim_info_cnf_decode(msg_ptr, &result_ptr);
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
}

static mipc_api_result_enum mipc_ecall_ivs_get_sim_info(MIPC_ECALL_IVS_GET_SIM_INFO_CB cb,
        void *cb_priv_ptr,
        mipc_sim_ps_id_enum sim_ps_id,
        mipc_ecall_ivs_get_sim_info_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_ECALL_IVS_GET_SIM_INFO_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_ecall_ivs_get_sim_info_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_ecall_ivs_get_sim_info_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_ecall_ivs_get_sim_info_sync(mipc_sim_ps_id_enum sim_ps_id,
        mipc_ecall_ivs_get_sim_info_struct *result_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_ecall_ivs_get_sim_info(NULL, NULL, sim_ps_id, result_ptr);
}

mipc_api_result_enum mipc_ecall_ivs_get_sim_info_async(mipc_sim_ps_id_enum sim_ps_id,
        MIPC_ECALL_IVS_GET_SIM_INFO_CB cb, void *cb_priv_ptr) {
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_ecall_ivs_get_sim_info(cb, cb_priv_ptr, sim_ps_id, NULL);
}

static mipc_api_result_enum mipc_ecall_ivs_set_test_addr_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_ecall_ivs_set_test_addr_struct *result_ptr)
{
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    do {
        void* val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);
    return result;
}

static void mipc_ecall_ivs_set_test_addr_cb(mipc_msg_t *msg_ptr, MIPC_ECALL_IVS_SET_TEST_ADDR_CB cb, void *cb_priv_ptr)
{
    mipc_ecall_ivs_set_test_addr_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_ecall_ivs_set_test_addr_struct));
    mipc_ecall_ivs_set_test_addr_cnf_decode(msg_ptr, &result_ptr);
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
}

static mipc_api_result_enum mipc_ecall_ivs_set_test_addr(MIPC_ECALL_IVS_SET_TEST_ADDR_CB cb,
        void *cb_priv_ptr,
        mipc_sim_ps_id_enum sim_ps_id,
        char* test_address,
	    mipc_call_dial_address_type_const_enum address_type,
        mipc_ecall_ivs_set_test_addr_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_ECALL_IVS_SET_TEST_ADDR_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    if (test_address) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_ECALL_IVS_SET_TEST_ADDR_REQ_T_ADDRESS,
			(strlen(test_address) < MIPC_MAX_DIAL_ADDRESS_LEN ? strlen(test_address) :MIPC_MAX_DIAL_ADDRESS_LEN), test_address);
    }
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_ECALL_IVS_SET_TEST_ADDR_REQ_T_ADDR_TYPE, address_type);

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_ecall_ivs_set_test_addr_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_ecall_ivs_set_test_addr_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_ecall_ivs_set_test_addr_sync(mipc_sim_ps_id_enum sim_ps_id,
        mipc_ecall_ivs_set_test_addr_struct *result_ptr,
        char* test_address,
        mipc_call_dial_address_type_const_enum address_type)
{
    if (NULL == result_ptr || NULL == test_address) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_ecall_ivs_set_test_addr(NULL, NULL, sim_ps_id, test_address, address_type, result_ptr);
}

mipc_api_result_enum mipc_ecall_ivs_set_test_addr_async(mipc_sim_ps_id_enum sim_ps_id,
        MIPC_ECALL_IVS_SET_TEST_ADDR_CB cb, void *cb_priv_ptr,
        char* test_address,
        mipc_call_dial_address_type_const_enum address_type)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_ecall_ivs_set_test_addr(cb, cb_priv_ptr, sim_ps_id, test_address, address_type, NULL);
}

static mipc_api_result_enum mipc_ecall_ivs_set_reconf_addr_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_ecall_ivs_set_reconf_addr_struct *result_ptr)
{
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    do {
        void* val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);
    return result;
}

static void mipc_ecall_ivs_set_reconf_addr_cb(mipc_msg_t *msg_ptr, MIPC_ECALL_IVS_SET_RECONF_ADDR_CB cb, void *cb_priv_ptr)
{
    mipc_ecall_ivs_set_reconf_addr_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_ecall_ivs_set_addr_pri_struct));
    mipc_ecall_ivs_set_reconf_addr_cnf_decode(msg_ptr, &result_ptr);
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
}

static mipc_api_result_enum mipc_ecall_ivs_set_reconf_addr(MIPC_ECALL_IVS_SET_RECONF_ADDR_CB cb,
        void *cb_priv_ptr,
        mipc_sim_ps_id_enum sim_ps_id,
        char* reconf_address,
        mipc_call_dial_address_type_const_enum address_type,
        mipc_ecall_ivs_set_reconf_addr_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_ECALL_IVS_SET_RECONF_ADDR_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    if (reconf_address) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_ECALL_IVS_SET_RECONF_ADDR_REQ_T_ADDRESS,
            (strlen(reconf_address) < MIPC_MAX_DIAL_ADDRESS_LEN ? strlen(reconf_address) :MIPC_MAX_DIAL_ADDRESS_LEN), reconf_address);
    }
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_ECALL_IVS_SET_RECONF_ADDR_REQ_T_ADDR_TYPE, address_type);

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_ecall_ivs_set_reconf_addr_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_ecall_ivs_set_reconf_addr_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_ecall_ivs_set_reconf_addr_sync(mipc_sim_ps_id_enum sim_ps_id,
        mipc_ecall_ivs_set_reconf_addr_struct *result_ptr,
        char* reconf_address,
        mipc_call_dial_address_type_const_enum address_type)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_ecall_ivs_set_reconf_addr(NULL, NULL, sim_ps_id, reconf_address, address_type, result_ptr);
}

mipc_api_result_enum mipc_ecall_ivs_set_reconf_addr_async(mipc_sim_ps_id_enum sim_ps_id,
        MIPC_ECALL_IVS_SET_RECONF_ADDR_CB cb, void *cb_priv_ptr,
        char* reconf_address,
        mipc_call_dial_address_type_const_enum address_type)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_ecall_ivs_set_reconf_addr(cb, cb_priv_ptr, sim_ps_id, reconf_address, address_type, NULL);
}

static mipc_api_result_enum mipc_ecall_ivs_set_addr_pri_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_ecall_ivs_set_addr_pri_struct *result_ptr)
{
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    do {
        void* val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);
    return result;
}

static void mipc_ecall_ivs_set_addr_pri_cb(mipc_msg_t *msg_ptr, MIPC_ECALL_IVS_SET_ADDR_PRI_CB cb, void *cb_priv_ptr)
{
    mipc_ecall_ivs_set_addr_pri_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_ecall_ivs_set_addr_pri_struct));
    mipc_ecall_ivs_set_addr_pri_cnf_decode(msg_ptr, &result_ptr);
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
}

static mipc_api_result_enum mipc_ecall_ivs_set_addr_pri(MIPC_ECALL_IVS_SET_ADDR_PRI_CB cb,
        void *cb_priv_ptr,
        mipc_sim_ps_id_enum sim_ps_id,
        mipc_ecall_address_priority_class_const_enum first_pri,
        mipc_ecall_address_priority_class_const_enum second_pri,
        mipc_ecall_address_priority_class_const_enum third_pri,
        mipc_ecall_address_priority_class_const_enum fourth_pri,
        mipc_ecall_ivs_set_addr_pri_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_ECALL_IVS_SET_ADDR_PRI_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_ECALL_IVS_SET_ADDR_PRI_REQ_T_FIRST_PRI, first_pri);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_ECALL_IVS_SET_ADDR_PRI_REQ_T_SECOND_PRI, second_pri);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_ECALL_IVS_SET_ADDR_PRI_REQ_T_THIRD_PRI, third_pri);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_ECALL_IVS_SET_ADDR_PRI_REQ_T_FOURTH_PRI, fourth_pri);

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_ecall_ivs_set_addr_pri_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_ecall_ivs_set_addr_pri_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_ecall_ivs_set_addr_pri_sync(mipc_sim_ps_id_enum sim_ps_id,
        mipc_ecall_ivs_set_addr_pri_struct *result_ptr,
        mipc_ecall_address_priority_class_const_enum first_pri,
        mipc_ecall_address_priority_class_const_enum second_pri,
        mipc_ecall_address_priority_class_const_enum third_pri,
        mipc_ecall_address_priority_class_const_enum fourth_pri)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_ecall_ivs_set_addr_pri(NULL, NULL, sim_ps_id, first_pri, second_pri, third_pri, fourth_pri, result_ptr);
}

mipc_api_result_enum mipc_ecall_ivs_set_addr_pri_async(mipc_sim_ps_id_enum sim_ps_id,
        MIPC_ECALL_IVS_SET_ADDR_PRI_CB cb, void *cb_priv_ptr,
        mipc_ecall_address_priority_class_const_enum first_pri,
        mipc_ecall_address_priority_class_const_enum second_pri,
        mipc_ecall_address_priority_class_const_enum third_pri,
        mipc_ecall_address_priority_class_const_enum fourth_pri)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_ecall_ivs_set_addr_pri(cb, cb_priv_ptr, sim_ps_id, first_pri, second_pri, third_pri, fourth_pri, NULL);
}

//////////////////////////////////////////INDICATIONS////////////////////////////////////////////
static mipc_api_result_enum mipc_ecall_status_ind(mipc_msg_t *msg_ptr, mipc_ecall_status_ind_struct *result_ptr)
{
    void *val_ptr;
    uint8_t api_error = 1;

    do {
        result_ptr->result_code = MIPC_RESULT_SUCCESS;

        if ((val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_ECALL_STATUS_IND_T_STATE, NULL)) == NULL) break;
        result_ptr->state = (mipc_ecall_status_const_enum) * ((uint8_t *)val_ptr);
        if ((val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_ECALL_STATUS_IND_T_CALL_ID, NULL)) == NULL) break;
        result_ptr->callid = (uint8_t) * ((uint8_t *)val_ptr);

        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_ecall_status_ind_cb(mipc_msg_t *msg_ptr, MIPC_ECALL_STATUS_IND_CB cb, void *cb_priv_ptr)
{
    mipc_ecall_status_ind_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_ecall_status_ind_struct));
    if (mipc_ecall_status_ind(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    }
}

mipc_api_result_enum mipc_ecall_status_register(mipc_sim_ps_id_enum sim_ps_id, MIPC_ECALL_STATUS_IND_CB cb, void *cb_priv_ptr)
{
    void *callback;
    if (cb) {
        callback = (void *)mipc_ecall_status_ind_cb;
    } else {
        callback = NULL;
    }

    if (mipc_msg_register_ind_api((mipc_msg_sim_ps_id_enum)sim_ps_id, MIPC_ECALL_STATUS_IND, callback, (MIPC_API_CB)cb, cb_priv_ptr) == 0) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        return MIPC_API_RESULT_FAIL;
    }
}

