// SPDX-License-Identifier: MediaTekProprietary
/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  Copyright (c) [2020], MediaTek Inc. All rights reserved.
*  This software/firmware and related documentation ("MediaTek Software") are
*  protected under relevant copyright laws.
*
*  The information contained herein is confidential and proprietary to
*  MediaTek Inc. and/or its licensors. Except as otherwise provided in the
*  applicable licensing terms with MediaTek Inc. and/or its licensors, any
*  reproduction, modification, use or disclosure of MediaTek Software, and
*  information contained herein, in whole or in part, shall be strictly
*  prohibited.
*****************************************************************************/

#define SIM_DEFAULT_ELEMENT_COUNT 10
#define SIM_MAX_DATA_LEN 32768
#include <stddef.h>
#include "mipc_sim_api.h"
#include "mtk_log.h"
#include "mipc_msg_tlv_api.h"

#define LOG_TAG "MIPC_SIM_API"

static mipc_api_result_enum mipc_sim_status_get_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_status_struct *result_ptr)
{
    void* val_ptr;
    uint16_t val_len = 0;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    RLOGD("[id%d]S mipc_sim_status_get_cnf_decode", msg_cnf_ptr->hdr.msg_sim_ps_id);

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_STATUS_CNF_T_STATUS, NULL);
        if (NULL == val_ptr) break;
        result_ptr->sim_status = (mipc_sim_status_const_enum)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_STATUS_CNF_T_SIM_ID, NULL);
        if (NULL == val_ptr) break;
        result_ptr->sim_id = (uint8_t)(*((uint32_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_STATUS_CNF_T_PS_ID, NULL);
        if (NULL == val_ptr) break;
        result_ptr->ps_id = (uint8_t)(*((uint32_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_STATUS_CNF_T_CARD_PRESENT_STATE, NULL);
        if (val_ptr) {
            /*lei add for sim status 2022/7/6*/
            //result_ptr->card_present_state  = (mipc_sim_card_present_state_const_enum)(*((uint32_t*)val_ptr));
            result_ptr->card_present_state  = (mipc_sim_card_present_state_const_enum)(*((uint8_t*)val_ptr));
            RLOGD("[id%d]S mipc_sim_status_get_cnf_decode card_present_state %d", msg_cnf_ptr->hdr.msg_sim_ps_id, result_ptr->card_present_state);
            /*lei add for sim status 2022/7/6*/
        } else {
            //result_ptr->card_present_state = UINT8_MAX;
            /*lei add for sim status 2022/7/6*/
            result_ptr->card_present_state = UINT8_MAX;
            RLOGD("[id%d]S mipc_sim_status_get_cnf_decode card_present_state2 %d", msg_cnf_ptr->hdr.msg_sim_ps_id, result_ptr->card_present_state);
            /*lei add for sim status 2022/7/6*/
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_STATUS_CNF_T_UPIN_STATUS, NULL);
        if (val_ptr) {
            result_ptr->upin_status  = (uint8_t)(*((uint32_t*)val_ptr));
        } else {
            result_ptr->upin_status = UINT8_MAX;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_STATUS_CNF_T_TEST_SIM, NULL);
        if (val_ptr) {
            result_ptr->test_sim  = (uint8_t)(*((uint32_t*)val_ptr));
        } else {
            result_ptr->test_sim = UINT8_MAX;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_STATUS_CNF_T_GSM_APP_IDX, NULL);
        if (val_ptr) {
            result_ptr->gsm_app_idx  = (uint8_t)(*((uint32_t*)val_ptr));
        } else {
            result_ptr->gsm_app_idx = UINT8_MAX;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_STATUS_CNF_T_CDMA_APP_IDX, NULL);
        if (val_ptr) {
            result_ptr->cdma_app_idx  = (uint8_t)(*((uint32_t*)val_ptr));
        } else {
            result_ptr->cdma_app_idx = UINT8_MAX;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_STATUS_CNF_T_ISIM_APP_IDX, NULL);
        if (val_ptr) {
            result_ptr->isim_app_idx  = (uint8_t)(*((uint32_t*)val_ptr));
        } else {
            result_ptr->isim_app_idx = UINT8_MAX;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_STATUS_CNF_T_APP_COUNT, NULL);
        if (val_ptr) {
            result_ptr->app_count  = (uint8_t)(*((uint32_t*)val_ptr));
        } else {
            result_ptr->app_count = 0;
        }
        if(result_ptr->app_count > 0) {
            val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_STATUS_CNF_T_APP_LIST, &val_len);
            if (val_ptr) {
                RLOGD("MIPC_SIM_STATUS_CNF_T_APP_LIST length: %lu, %lu, %lu", val_len, sizeof(mipc_app_status_desc_struct4), result_ptr->app_count);
                MEMCPY(result_ptr->app_list, val_ptr, (result_ptr->app_count)*sizeof(mipc_app_status_desc_struct4));
            } else {
                break;
            }
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_STATUS_CNF_T_EID, &val_len);
        if (val_ptr) {
            MEMCPY(result_ptr->eid, val_ptr, (val_len<(MIPC_MAX_SIM_EID_LEN+1) ? val_len : (MIPC_MAX_SIM_EID_LEN+1)));
        } else {
            (result_ptr->eid)[0]=0;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_STATUS_CNF_T_ICCID, &val_len);
        RLOGD("[id%d]mipc_sim_status_get_cnf_decode val_len %d, %d",msg_cnf_ptr->hdr.msg_sim_ps_id, val_len, MIPC_SIM_FIX_ICCID_LEN);
        if (val_ptr) {
            MEMCPY(result_ptr->iccid, val_ptr, (val_len<(MIPC_SIM_FIX_ICCID_LEN+1) ? val_len : (MIPC_SIM_FIX_ICCID_LEN+1)));
        } else {
            (result_ptr->iccid)[0] = 0;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_STATUS_CNF_T_ATR, &val_len);
        if (val_ptr) {
            MEMCPY(result_ptr->atr, val_ptr, (val_len<(MIPC_MAX_ATR_LEN+1) ? val_len : (MIPC_MAX_ATR_LEN+1)));
        } else {
            (result_ptr->atr)[0] = 0;
        }
        result = MIPC_API_RESULT_SUCCESS;
        RLOGD("[id%d]E mipc_sim_status_get_cnf_decode", msg_cnf_ptr->hdr.msg_sim_ps_id);
    } while (0);
    RLOGD("[id%d]End mipc_sim_status_get_cnf_decode result: %d", msg_cnf_ptr->hdr.msg_sim_ps_id, result);
    return result;
}

static void mipc_sim_status_get_config_cb(mipc_msg_t *msg_ptr, MIPC_SIM_STATUS_GET_CB cb, void *cb_priv_ptr)
{
    mipc_sim_status_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_sim_status_struct));
    if(mipc_sim_status_get_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        mtkLogD(LOG_TAG, "[id%d]mipc_sim_status_get_config_cb run cb", msg_ptr->hdr.msg_sim_ps_id);
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogD(LOG_TAG, "[id%d]MIPC_SIM_STATUS_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }

}

static mipc_api_result_enum mipc_sim_status_get(MIPC_SIM_STATUS_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, uint8_t mode,  mipc_sim_status_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_STATUS_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;
    mtkLogD(LOG_TAG, "[id%d]mipc_sim_status_get", sim_ps_id);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_STATUS_REQ_T_MODE, mode);
    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_status_get_config_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_status_get_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

static mipc_api_result_enum mipc_sim_status_ind_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_status_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_STATUS_IND_T_STATUS, NULL);
        if (NULL == val_ptr) break;
        result_ptr->sim_status = (mipc_sim_status_const_enum)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_STATUS_IND_T_SIM_ID, NULL);
        if (NULL == val_ptr) break;
        result_ptr->sim_id = (uint8_t)(*((uint32_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_STATUS_IND_T_PS_ID, NULL);
        if (NULL == val_ptr) break;
        result_ptr->ps_id = (uint8_t)(*((uint32_t*)val_ptr));
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_status_ind_config_cb(mipc_msg_t *msg_ptr, MIPC_SIM_STATUS_IND_CB cb, void *cb_priv_ptr)
{
    mipc_sim_status_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_sim_status_struct));
    if (mipc_sim_status_ind_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_STATUS_IND, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }

}

static mipc_api_result_enum mipc_sim_state_get_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_state_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_STATE_CNF_T_STATE, NULL);
        if (NULL == val_ptr) break;
        result_ptr->sim_state = (mipc_sim_state_const_enum)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_STATE_CNF_T_SIM_ID, NULL);
        if (NULL == val_ptr) break;
        result_ptr->sim_id = (uint8_t)(*((uint32_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_STATE_CNF_T_PS_ID, NULL);
        if (NULL == val_ptr) break;
        result_ptr->ps_id = (uint8_t)(*((uint32_t*)val_ptr));
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);
    return result;
}

static void mipc_sim_state_get_config_cb(mipc_msg_t *msg_ptr, MIPC_SIM_STATE_GET_CB cb, void *cb_priv_ptr)
{
    mipc_sim_state_struct result_ptr;
    MEMSET(&result_ptr, 0, sizeof(mipc_sim_state_struct));
    if(mipc_sim_state_get_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_STATE_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }

}

static mipc_api_result_enum mipc_sim_state_get(MIPC_SIM_STATE_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sim_state_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_STATE_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_state_get_config_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_state_get_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

static mipc_api_result_enum mipc_sim_state_ind_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_state_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_STATE_IND_T_STATE, NULL);
        if (NULL == val_ptr) break;

        result_ptr->sim_state = (mipc_sim_state_const_enum)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_STATE_IND_T_SIM_ID, NULL);
        if (NULL == val_ptr) break;

        result_ptr->sim_id = (uint8_t)(*((uint32_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_STATE_IND_T_PS_ID, NULL);
        if (NULL == val_ptr) break;

        result_ptr->ps_id = (uint8_t)(*((uint32_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_STATE_IND_T_IS_PRESENT, NULL);
        if (NULL == val_ptr) {
            result_ptr->is_present = UINT32_MAX;
        } else {
            result_ptr->is_present = (uint32_t)(*((uint32_t*)val_ptr));
        }

        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_STATE_IND_T_SUB_STATE, NULL);
        if (NULL == val_ptr) {
            result_ptr->sub_state = MIPC_SIM_SUB_STATE_UNKNOWN;
        } else {
            result_ptr->sub_state = (mipc_sim_sub_state_const_enum)(*((uint8_t*)val_ptr));
        }

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_state_ind_config_cb(mipc_msg_t *msg_ptr, MIPC_SIM_STATE_IND_CB cb, void *cb_priv_ptr)
{
    mipc_sim_state_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_sim_state_struct));
    if( mipc_sim_state_ind_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    }else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_STATE_IND, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }
}

static mipc_api_result_enum mipc_sim_imsi_get_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_imsi_struct *result_ptr)
{
    void* val_ptr;
    uint16_t val_len = 0;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        mtkLogE(LOG_TAG, "[id%d]mipc_sim_imsi_get_cnf_decode timeout", msg_cnf_ptr->hdr.msg_sim_ps_id);
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        mtkLogD(LOG_TAG, "[id%d]mipc_sim_imsi_get_cnf_decode result_code %d", msg_cnf_ptr->hdr.msg_sim_ps_id, result_ptr->result_code);
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_IMSI_CNF_T_IMSI, &val_len); //val_len: #define LU5SIM_IMSI_LEN 16
        if (NULL == val_ptr) break;
        //#define MIPC_MAX_IMSI_LEN                                  (20) /* Maximum IMSI length */
        mtkLogD(LOG_TAG, "[id%d]val_len %d, MIPC_MAX_IMSI_LEN %d", msg_cnf_ptr->hdr.msg_sim_ps_id, val_len, MIPC_MAX_IMSI_LEN);
        MEMSET(result_ptr->imsi, 0, MIPC_MAX_IMSI_LEN+1);
        MEMCPY(result_ptr->imsi, val_ptr, val_len < (MIPC_MAX_IMSI_LEN) ? val_len:(MIPC_MAX_IMSI_LEN+1));
//xf.li@20231120 modify for T8TSK-291 start
        mtkLogD(LOG_TAG, "[id%d]imsi (has got)", msg_cnf_ptr->hdr.msg_sim_ps_id);
//xf.li@20231120 modify for T8TSK-291 end
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_IMSI_CNF_T_MNC_LEN, &val_len);
        if (NULL == val_ptr) break;
        result_ptr->mnc_len =  (uint8_t)(*((uint32_t*)val_ptr));
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}


static void mipc_sim_imsi_get_config_cb(mipc_msg_t *msg_ptr, MIPC_SIM_IMSI_GET_CB cb, void *cb_priv_ptr)
{
    mipc_sim_imsi_struct result_ptr;
    MEMSET(&result_ptr, 0, sizeof(mipc_sim_imsi_struct));
    mtkLogD(LOG_TAG, "slot %d, S mipc_sim_imsi_get_config_cb", (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id);
    if (mipc_sim_imsi_get_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        mtkLogD(LOG_TAG, "slot %d, cb", (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id);
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
       } else {
           mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_IMSI_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
       }
}

static mipc_api_result_enum mipc_sim_imsi_get(MIPC_SIM_IMSI_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id,  uint8_t mode, mipc_sim_imsi_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_IMSI_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;
    mtkLogD(LOG_TAG, "slot %d, mipc_sim_imsi_get", sim_ps_id);

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_IMSI_REQ_T_MODE, mode);
    if (cb) {
        mtkLogD(LOG_TAG, "slot %d, S mipc_sim_imsi_get", sim_ps_id);
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_imsi_get_config_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mtkLogD(LOG_TAG, "slot %d, E mipc_sim_imsi_get", sim_ps_id);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_imsi_get_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

static mipc_api_result_enum mipc_sim_iccid_get_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_iccid_struct *result_ptr)
{
    void* val_ptr;
    uint16_t val_len;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    MEMSET(result_ptr, 0, sizeof(*result_ptr));
    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_ICCID_CNF_T_ICCID, &val_len);
        if (NULL == val_ptr) break;
        MEMCPY(result_ptr->iccid, val_ptr, (val_len < (MIPC_SIM_FIX_ICCID_LEN + 1) ? val_len : (MIPC_SIM_FIX_ICCID_LEN + 1)) );
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_iccid_get_config_cb(mipc_msg_t *msg_ptr, MIPC_SIM_ICCID_GET_CB cb, void *cb_priv_ptr)
{
    mipc_sim_iccid_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_sim_iccid_struct));
    if( mipc_sim_iccid_get_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_ICCID_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }
}

static mipc_api_result_enum mipc_sim_iccid_get(MIPC_SIM_ICCID_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sim_iccid_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_ICCID_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_iccid_get_config_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_iccid_get_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

static mipc_api_result_enum mipc_sim_msisdn_get_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_msisdn_struct_v *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;
    uint8_t msisdn_count;
    uint16_t list_len = 0;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_MSISDN_CNF_T_MSISDN_COUNT, NULL);
        if (NULL == val_ptr) break;
        msisdn_count = (uint8_t)(*((uint32_t*)val_ptr));
        if (msisdn_count) {
            val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_MSISDN_CNF_T_MSISDN_LIST, &list_len);
            if (NULL == val_ptr) break;
            if (result_ptr->msisdn_list_count >= msisdn_count) {
                MEMCPY(result_ptr->msisdn_list, val_ptr, list_len);
                result_ptr->msisdn_list_count = msisdn_count;
            } else {
                MEMCPY(result_ptr->msisdn_list, val_ptr, (result_ptr->msisdn_list_count)*sizeof(mipc_sim_msisdn_struct4));
            }
        } else {
            result_ptr->msisdn_list_count = 0;
        }

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    //reset  apn_list_count
    if ((result == MIPC_API_RESULT_FAIL) || (MIPC_RESULT_SUCCESS != result_ptr->result_code)) result_ptr->msisdn_list_count = 0;

    return result;
}

static void mipc_sim_msisdn_get_config_cb(mipc_msg_t *msg_ptr, MIPC_SIM_MSISDN_GET_CB cb, void *cb_priv_ptr)
{
    size_t alloc_size = sizeof(mipc_sim_msisdn_struct_v) + SIM_DEFAULT_ELEMENT_COUNT * sizeof(mipc_sim_msisdn_struct_v);
    mipc_sim_msisdn_struct_v *result_ptr = (mipc_sim_msisdn_struct_v *)(alloc_size);
    result_ptr->msisdn_list_count = SIM_DEFAULT_ELEMENT_COUNT;

    if (result_ptr) {
        MEMSET(result_ptr, 0, alloc_size);
        mipc_sim_msisdn_get_cnf_decode(msg_ptr, result_ptr);
    }
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);
    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sim_msisdn_get(MIPC_SIM_MSISDN_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sim_msisdn_struct_v *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_MSISDN_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_msisdn_get_config_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_msisdn_get_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

static mipc_api_result_enum mipc_sim_pin_protect_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_pin_protect_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));

        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_PIN_PROTECT_CNF_T_PIN_TYPE, NULL);
        if (NULL == val_ptr) break;
        result_ptr->pin_type = (mipc_sim_pin_type_const_enum)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_PIN_PROTECT_CNF_T_PIN_STATE, NULL);
        if (NULL == val_ptr) break;
        result_ptr->pin_state = (mipc_sim_pin_state_const_enum)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_PIN_PROTECT_CNF_T_REMAINING_ATTEMPTS, NULL);
        if (NULL == val_ptr) break;
        result_ptr->remaining_attempts = (uint8_t)(*((uint32_t*)val_ptr));
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_pin_protect_config_cb(mipc_msg_t *msg_ptr, MIPC_SIM_PIN_PROTECT_CB cb, void *cb_priv_ptr)
{
    mipc_sim_pin_protect_struct result_ptr;
    MEMSET(&result_ptr, 0, sizeof(mipc_sim_pin_protect_struct));
    if(mipc_sim_pin_protect_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_PIN_PROTECT_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }
}

static mipc_api_result_enum mipc_sim_pin_protect(MIPC_SIM_PIN_PROTECT_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id,  mipc_sim_pin_protect_struct *result_ptr, mipc_sim_pin_protection_const_enum protect_type, mipc_sim_pin_type_const_enum pin_type, char *pin_code_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_PIN_PROTECT_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_PIN_PROTECT_REQ_T_PIN_TYPE, pin_type);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_PIN_PROTECT_REQ_T_PIN_OP, protect_type);
    if (pin_code_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_PIN_PROTECT_REQ_T_PIN_CODE, strlen((const char*)(pin_code_ptr)), pin_code_ptr);
    }

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_pin_protect_config_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_pin_protect_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

static mipc_api_result_enum mipc_sim_verify_pin_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_verify_pin_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_VERIFY_PIN_CNF_T_PIN_TYPE, NULL);
        if (NULL == val_ptr) break;
        result_ptr->pin_type = (mipc_sim_pin_type_const_enum)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_VERIFY_PIN_CNF_T_PIN_STATE, NULL);
        if (NULL == val_ptr) break;
        result_ptr->pin_state = (mipc_sim_pin_state_const_enum)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_VERIFY_PIN_CNF_T_REMAINING_ATTEMPTS, NULL);
        if (NULL == val_ptr) break;
        result_ptr->remaining_attempts = (uint32_t)(*((uint32_t*)val_ptr));
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_verify_pin_config_cb(mipc_msg_t *msg_ptr, MIPC_SIM_VERIFY_PIN_CB cb, void *cb_priv_ptr)
{
    mipc_sim_verify_pin_struct result_ptr;
    MEMSET(&result_ptr, 0, sizeof(mipc_sim_verify_pin_struct));
    if(mipc_sim_verify_pin_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_VERIFY_PIN_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }
}

static mipc_api_result_enum mipc_sim_verify_pin(MIPC_SIM_VERIFY_PIN_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sim_verify_pin_struct *result_ptr, mipc_sim_pin_type_const_enum pin_type, char *pin_code_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_VERIFY_PIN_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_VERIFY_PIN_REQ_T_PIN_TYPE, pin_type);

    if (pin_code_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_VERIFY_PIN_REQ_T_PIN_CODE, (strlen((const char*)(pin_code_ptr))+1), pin_code_ptr);
    }

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_verify_pin_config_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_verify_pin_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

static mipc_api_result_enum mipc_sim_change_pin_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_change_pin_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_CHANGE_PIN_REQ_T_PIN_TYPE, NULL);
        if (NULL == val_ptr) break;
        result_ptr->pin_type = (mipc_sim_pin_type_const_enum)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_CHANGE_PIN_CNF_T_PIN_STATE, NULL);
        if (NULL == val_ptr) break;
        result_ptr->pin_state = (mipc_sim_pin_state_const_enum)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_CHANGE_PIN_CNF_T_REMAINING_ATTEMPTS, NULL);
        if (NULL == val_ptr) break;
        result_ptr->remaining_attempts = (uint32_t)(*((uint32_t*)val_ptr));
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_change_pin_config_cb(mipc_msg_t *msg_ptr, MIPC_SIM_CHG_PIN_CB cb, void *cb_priv_ptr)
{
    mipc_sim_change_pin_struct result_ptr;
    MEMSET(&result_ptr, 0, sizeof(mipc_sim_change_pin_struct));
    if( mipc_sim_change_pin_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_CHANGE_PIN_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }
}

static mipc_api_result_enum mipc_sim_change_pin(MIPC_SIM_CHG_PIN_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sim_change_pin_struct *result_ptr, mipc_sim_pin_type_const_enum pin_type, char *old_pin_code_ptr, char *new_pin_code_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_CHANGE_PIN_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_CHANGE_PIN_REQ_T_PIN_TYPE, pin_type);

    if (old_pin_code_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_CHANGE_PIN_REQ_T_OLD_PIN, strlen((const char*)(old_pin_code_ptr)), old_pin_code_ptr);
    }

    if (new_pin_code_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_CHANGE_PIN_REQ_T_NEW_PIN, strlen((const char*)(new_pin_code_ptr)), new_pin_code_ptr);
    }

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_change_pin_config_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_change_pin_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

static mipc_api_result_enum mipc_sim_unblock_pin_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_unblock_pin_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_UNBLOCK_PIN_CNF_T_PIN_TYPE, NULL);
        if (NULL == val_ptr) break;
        result_ptr->pin_type = (mipc_sim_pin_type_const_enum)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_UNBLOCK_PIN_CNF_T_PIN_STATE, NULL);
        if (NULL == val_ptr) break;
        result_ptr->pin_state = (mipc_sim_pin_state_const_enum)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_UNBLOCK_PIN_CNF_T_REMAINING_ATTEMPTS, NULL);
        if (NULL == val_ptr) break;
        result_ptr->remaining_attempts = (uint8_t)(*((uint32_t*)val_ptr));
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_unblock_pin_config_cb(mipc_msg_t *msg_ptr, MIPC_SIM_UNBLOCK_PIN_CB cb, void *cb_priv_ptr)
{
    mipc_sim_unblock_pin_struct result_ptr;
    MEMSET(&result_ptr, 0, sizeof(mipc_sim_unblock_pin_struct));
    if( mipc_sim_unblock_pin_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_UNBLOCK_PIN_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }
}

static mipc_api_result_enum mipc_sim_unblock_pin(MIPC_SIM_UNBLOCK_PIN_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sim_unblock_pin_struct *result_ptr, mipc_sim_pin_type_const_enum pin_type, char *puk_code_ptr, char *pin_code_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_UNBLOCK_PIN_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_UNBLOCK_PIN_REQ_T_PIN_TYPE, pin_type);

    if (puk_code_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_UNBLOCK_PIN_REQ_T_PUK_CODE, strlen((const char*)(puk_code_ptr)), puk_code_ptr);
    }

    if (pin_code_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_UNBLOCK_PIN_REQ_T_PIN_CODE, strlen((const char*)(pin_code_ptr)), pin_code_ptr);
    }

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_unblock_pin_config_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_unblock_pin_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

static mipc_api_result_enum mipc_sim_pin_info_get_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_pin_info_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_PIN_INFO_CNF_T_PIN_TYPE, NULL);
        if (NULL == val_ptr) break;
        result_ptr->pin_type = (mipc_sim_pin_type_const_enum)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_PIN_INFO_CNF_T_PIN_STATE, NULL);
        if (NULL == val_ptr) break;
        result_ptr->pin_state = (mipc_sim_pin_state_const_enum)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_PIN_INFO_CNF_T_REMAINING_ATTEMPTS, NULL);
        if (NULL == val_ptr) break;
        result_ptr->remaining_attempts = (uint8_t)(*((uint32_t*)val_ptr));
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_pin_info_get_config_cb(mipc_msg_t *msg_ptr, MIPC_SIM_PIN_INFO_GET_CB cb, void *cb_priv_ptr)
{
    mipc_sim_pin_info_struct result_ptr;
    MEMSET(&result_ptr, 0, sizeof(mipc_sim_pin_info_struct));
    if(mipc_sim_pin_info_get_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_GET_PIN_INFO_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }
}

static mipc_api_result_enum mipc_sim_pin_info_get(MIPC_SIM_PIN_INFO_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sim_pin_info_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_GET_PIN_INFO_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_pin_info_get_config_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_pin_info_get_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

static mipc_api_result_enum mipc_sim_pin_list_get_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_pin_list_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_PIN_LIST_CNF_T_PIN1, NULL);
        if (NULL == val_ptr) break;
        MEMCPY(&result_ptr->pin1_desc, val_ptr, sizeof(mipc_sim_pin_desc_struct4));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_PIN_LIST_CNF_T_PIN2, NULL);
        if (NULL == val_ptr) break;
        MEMCPY(&result_ptr->pin2_desc, val_ptr, sizeof(mipc_sim_pin_desc_struct4));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_PIN_LIST_CNF_T_NW_PIN, NULL);
        if (NULL == val_ptr) break;
        MEMCPY(&result_ptr->nw_pin_desc, val_ptr, sizeof(mipc_sim_pin_desc_struct4));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_PIN_LIST_CNF_T_SUB_NW_PIN, NULL);
        if (NULL == val_ptr) break;
        MEMCPY(&result_ptr->sub_nw_pin_desc, val_ptr, sizeof(mipc_sim_pin_desc_struct4));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_PIN_LIST_CNF_T_SP_PIN, NULL);
        if (NULL == val_ptr) break;
        MEMCPY(&result_ptr->sp_desc, val_ptr, sizeof(mipc_sim_pin_desc_struct4));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_PIN_LIST_CNF_T_CORP_PIN, NULL);
        if (NULL == val_ptr) break;
        MEMCPY(&result_ptr->corp_pin_desc, val_ptr, sizeof(mipc_sim_pin_desc_struct4));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_PIN_LIST_CNF_T_SIM_PIN, NULL);
        if (NULL == val_ptr) break;
        MEMCPY(&result_ptr->sim_pin_desc, val_ptr, sizeof(mipc_sim_pin_desc_struct4));
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_pin_list_get_config_cb(mipc_msg_t *msg_ptr, MIPC_SIM_PIN_LIST_GET_CB cb, void *cb_priv_ptr)
{
    mipc_sim_pin_list_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_sim_pin_list_struct));
    if(mipc_sim_pin_list_get_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_GET_PIN_LIST_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }

}

static mipc_api_result_enum mipc_sim_pin_list_get(MIPC_SIM_PIN_LIST_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sim_pin_list_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_GET_PIN_LIST_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_pin_list_get_config_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_pin_list_get_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

static mipc_api_result_enum mipc_sim_atr_info_get_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_atr_info_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_ATR_INFO_CNF_T_ATR_LEN, NULL);
        if (NULL == val_ptr) break;
        result_ptr->atr_len = (uint8_t)(*((uint32_t*)val_ptr));
        if(result_ptr->atr_len > 0) {
            val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_ATR_INFO_CNF_T_ATR, NULL);
            if (NULL == val_ptr) break;
            MEMCPY(result_ptr->atr, val_ptr, (result_ptr->atr_len > 80 ? 80 : result_ptr->atr_len));
        } else {
            (result_ptr->atr)[0] = 0;
        }

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_atr_info_get_config_cb(mipc_msg_t *msg_ptr, MIPC_SIM_ATR_INFO_GET_CB cb, void *cb_priv_ptr)
{
    mipc_sim_atr_info_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_sim_atr_info_struct));
    if(mipc_sim_atr_info_get_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_GET_ATR_INFO_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }

}

static mipc_api_result_enum mipc_sim_atr_info_get(MIPC_SIM_ATR_INFO_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sim_atr_info_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_GET_ATR_INFO_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_atr_info_get_config_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_atr_info_get_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

static mipc_api_result_enum mipc_sim_channel_open_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_open_channel_info_struct *result_ptr)
{
    void* val_ptr;
    uint16_t t_resp_len;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_OPEN_CHANNEL_CNF_T_SW, NULL);
        if (NULL == val_ptr) break;
        result_ptr->sw = (uint16_t)(*((uint32_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_OPEN_CHANNEL_CNF_T_CHANNEL, NULL);
        if(val_ptr) {
            result_ptr->channel = (uint8_t)(*((uint32_t*)val_ptr));
        } else {
            result_ptr->channel = 0;
        }

        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_OPEN_CHANNEL_CNF_T_RESP, &t_resp_len);
        if (val_ptr){
            MEMCPY(result_ptr->resp, val_ptr, (t_resp_len > 256 ? 256 : t_resp_len));
        } else {
            (result_ptr->resp)[0] = 0;
        }

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_channel_open_cb(mipc_msg_t *msg_ptr, MIPC_SIM_CHANNEL_OPEN_CB cb, void *cb_priv_ptr)
{
    mipc_sim_open_channel_info_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_sim_open_channel_info_struct));
    if(mipc_sim_channel_open_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_OPEN_CHANNEL_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }

}

static mipc_api_result_enum mipc_sim_channel_open(MIPC_SIM_CHANNEL_OPEN_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sim_open_channel_info_struct *result_ptr, uint8_t app_id_len, char *app_id_ptr, uint8_t p2, uint8_t channel_group)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_OPEN_CHANNEL_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_OPEN_CHANNEL_REQ_T_APP_ID_LEN, app_id_len);
    if (app_id_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_OPEN_CHANNEL_REQ_T_APP_ID, app_id_len, app_id_ptr);
    }
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_OPEN_CHANNEL_REQ_T_P2, p2);
    //mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_OPEN_CHANNEL_REQ_T_CHANNEL_GROUP, channel_group);

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_channel_open_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_channel_open_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

static mipc_api_result_enum mipc_sim_channel_close_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_close_channel_info_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_CLOSE_CHANNEL_CNF_T_SW, NULL);
        if (NULL == val_ptr) break;
        result_ptr->sw = (uint16_t)(*((uint32_t*)val_ptr));
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_channel_close_cb(mipc_msg_t *msg_ptr, MIPC_SIM_CHANNEL_CLOSE_CB cb, void *cb_priv_ptr)
{
    mipc_sim_close_channel_info_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_sim_close_channel_info_struct));
    if(mipc_sim_channel_close_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_CLOSE_CHANNEL_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }

}

static mipc_api_result_enum mipc_sim_channel_close(MIPC_SIM_CHANNEL_CLOSE_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sim_close_channel_info_struct *result_ptr, uint8_t channel_id, uint8_t channel_group)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_CLOSE_CHANNEL_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_CLOSE_CHANNEL_REQ_T_CHANNEL_ID, channel_id);
    //mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_CLOSE_CHANNEL_REQ_T_CHANNEL_GROUP, channel_group);

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_channel_close_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_channel_close_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

static mipc_api_result_enum mipc_sim_ext_auth_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_ext_auth_info_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_EXT_AUTH_CNF_T_SW, NULL);
        if (NULL == val_ptr) {
            break;
        }
        result_ptr->sw = (uint16_t)(*((uint16_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_EXT_AUTH_CNF_T_RSP_LEN, NULL);
        if (NULL == val_ptr) {
            break;
        }
        result_ptr->resp_len = (uint16_t)(*((uint16_t*)val_ptr));
        if(result_ptr->resp_len > 0) {
            val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_EXT_AUTH_CNF_T_RSP_DATA, NULL);
            if (NULL == val_ptr) {
                break;
            }
            MEMCPY(result_ptr->resp, val_ptr, (result_ptr->resp_len > MIPC_MAX_EXT_AUTH_RSP_DATA_LEN ? MIPC_MAX_EXT_AUTH_RSP_DATA_LEN : result_ptr->resp_len));
        } else {
            (result_ptr->resp)[0] = 0;
        }
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_ext_auth_cb(mipc_msg_t *msg_ptr, MIPC_SIM_EXT_AUTH_GET_CB cb, void *cb_priv_ptr)
{
    mipc_sim_ext_auth_info_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_sim_ext_auth_info_struct));
    if(mipc_sim_ext_auth_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_GET_EXT_AUTH_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }

}

static mipc_api_result_enum mipc_sim_ext_auth_get(MIPC_SIM_EXT_AUTH_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, uint8_t channel_id, uint8_t mode, uint16_t cmd_len, char *cmd_data, uint8_t app_id, mipc_sim_ext_auth_info_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_GET_EXT_AUTH_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    if(channel_id != UINT8_MAX) {
        mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_GET_EXT_AUTH_REQ_T_CH, channel_id);
    }
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_GET_EXT_AUTH_REQ_T_MODE, mode);
    mipc_msg_add_tlv_uint16(msg_req_ptr, MIPC_SIM_GET_EXT_AUTH_REQ_T_CMD_LEN, cmd_len);
    mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_GET_EXT_AUTH_REQ_T_CMD_DATA, cmd_len, cmd_data);
    if(app_id != UINT8_MAX) {
        mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_GET_EXT_AUTH_REQ_T_APP_ID, app_id);
    }
    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_ext_auth_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_ext_auth_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

static mipc_api_result_enum mipc_sim_gsm_auth_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_gsm_auth_info_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_GSM_AUTH_CNF_T_SW, NULL);
        if (NULL == val_ptr) {
            //printf("NULL ptr\n");
            break;
        }
        result_ptr->sw = (uint16_t)(*((uint16_t*)val_ptr));
        //KC1 and SRES1
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_GSM_AUTH_CNF_T_KC1, NULL);
        if (NULL == val_ptr) break;
        MEMCPY(result_ptr->kc1, val_ptr, 8);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_GSM_AUTH_CNF_T_SRES1, NULL);
        if (NULL == val_ptr) break;
        MEMCPY(result_ptr->sres1, val_ptr, 4);
        //KC2 and SRES2
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_GSM_AUTH_CNF_T_KC2, NULL);
        if (NULL == val_ptr) break;
        MEMCPY(result_ptr->kc2, val_ptr, 8);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_GSM_AUTH_CNF_T_SRES2, NULL);
        if (NULL == val_ptr) break;
        MEMCPY(result_ptr->sres2, val_ptr, 4);
        //KC3 and SRES3
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_GSM_AUTH_CNF_T_KC3, NULL);
        if (NULL == val_ptr) break;
        MEMCPY(result_ptr->kc3, val_ptr, 8);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_GSM_AUTH_CNF_T_SRES3, NULL);
        if (NULL == val_ptr) break;
        MEMCPY(result_ptr->sres3, val_ptr, 4);

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_gsm_auth_cb(mipc_msg_t *msg_ptr, MIPC_SIM_GSM_AUTH_GET_CB cb, void *cb_priv_ptr)
{
    mipc_sim_gsm_auth_info_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_sim_gsm_auth_info_struct));
    if(mipc_sim_gsm_auth_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_GET_GSM_AUTH_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }

}

static mipc_api_result_enum mipc_sim_gsm_auth_get(MIPC_SIM_GSM_AUTH_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, uint8_t *rand1, uint8_t *rand2, uint8_t *rand3, mipc_sim_gsm_auth_info_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_GET_GSM_AUTH_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_GET_GSM_AUTH_REQ_T_RAND1, 16, rand1);
    mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_GET_GSM_AUTH_REQ_T_RAND2, 16, rand2);
    mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_GET_GSM_AUTH_REQ_T_RAND3, 16, rand3);

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_gsm_auth_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_gsm_auth_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

static mipc_api_result_enum mipc_sim_get_facility_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_get_facility_info_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_FACILITY_CNF_T_STATUS, NULL);
        if (NULL == val_ptr) {
            //printf("NULL ptr\n");
            break;
        }
        result_ptr->status = (uint8_t)(*((uint8_t*)val_ptr));

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_get_facility_cb(mipc_msg_t *msg_ptr, MIPC_SIM_GET_FACILITY_CB cb, void *cb_priv_ptr)
{
    mipc_sim_get_facility_info_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_sim_get_facility_info_struct));
    if(mipc_sim_get_facility_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_GET_FACILITY_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }

}

static mipc_api_result_enum mipc_sim_get_facility(MIPC_SIM_GET_FACILITY_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sim_app_type_const_enum app_id,char* facility_ptr, mipc_sim_get_facility_info_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_GET_FACILITY_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_GET_FACILITY_REQ_T_APP_ID, app_id);
    if (facility_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_CHANGE_PIN_REQ_T_OLD_PIN, strlen((const char*)(facility_ptr))+1, facility_ptr);
    }

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_get_facility_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_get_facility_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}



static mipc_api_result_enum mipc_sim_set_facility_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_set_facility_info_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_SET_FACILITY_CNF_T_RETRY_COUNT, NULL);
        if (NULL == val_ptr) {
            //printf("NULL ptr\n");
            break;
        }
        result_ptr->retry_count = (uint8_t)(*((uint8_t*)val_ptr));

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_set_facility_cb(mipc_msg_t *msg_ptr, MIPC_SIM_SET_FACILITY_CB cb, void *cb_priv_ptr)
{
    mipc_sim_set_facility_info_struct result_ptr;
    MEMSET(&result_ptr, 0, sizeof(mipc_sim_set_facility_info_struct));
    if(mipc_sim_set_facility_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_SET_FACILITY_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }

}

static mipc_api_result_enum mipc_sim_set_facility(MIPC_SIM_SET_FACILITY_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sim_app_type_const_enum app_id,char* facility_ptr, char* pass_word_ptr,uint8_t mode, mipc_sim_set_facility_info_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_SET_FACILITY_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_SET_FACILITY_REQ_T_APP_ID, app_id);
    if (facility_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_SET_FACILITY_REQ_T_FACILITY, strlen((const char*)(facility_ptr))+1, facility_ptr);
    }
    if (pass_word_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_SET_FACILITY_REQ_T_PASS_WORD, strlen((const char*)(pass_word_ptr))+1, pass_word_ptr);
    }
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_SET_FACILITY_REQ_T_MODE, mode);
    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_set_facility_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_set_facility_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sim_status_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_status_struct *result_ptr,uint8_t mode)
{
    if (NULL == result_ptr || (!((1 == mode) || (0 == mode)))) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_status_get(NULL, NULL, sim_ps_id, mode, result_ptr);
}

mipc_api_result_enum mipc_sim_status_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_STATUS_GET_CB cb, void *cb_priv_ptr, uint8_t mode)
{
    if (NULL == cb || (!((1 == mode) || (0 == mode)))) {
        return MIPC_API_RESULT_FAIL;
    }
    mtkLogD(LOG_TAG, "[id%d]mipc_sim_status_get_async", sim_ps_id);
    return mipc_sim_status_get(cb, cb_priv_ptr, sim_ps_id,mode, NULL);
}

mipc_api_result_enum mipc_sim_status_register( mipc_sim_ps_id_enum sim_ps_id,  MIPC_SIM_STATUS_IND_CB cb,  void *cb_priv_ptr)
{
    void *callback;
    if (cb) {
        callback = (void *)mipc_sim_status_ind_config_cb;
    } else {
        callback = NULL;
    }

    if (mipc_msg_register_ind_api((mipc_msg_sim_ps_id_enum)sim_ps_id, MIPC_SIM_STATUS_IND, callback, (MIPC_API_CB)cb, cb_priv_ptr) == 0) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        return MIPC_API_RESULT_FAIL;
    }
}

mipc_api_result_enum mipc_sim_state_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_state_struct *result_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_state_get(NULL, NULL, sim_ps_id, result_ptr);
}

mipc_api_result_enum mipc_sim_state_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_STATE_GET_CB cb, void *cb_priv_ptr)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_state_get(cb, cb_priv_ptr, sim_ps_id, NULL);
}

mipc_api_result_enum mipc_sim_state_register(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_STATE_IND_CB cb, void *cb_priv_ptr)
{
    void *callback;
    if (cb) {
        callback = (void *)mipc_sim_state_ind_config_cb;
    } else {
        callback = NULL;
    }

    if (mipc_msg_register_ind_api((mipc_msg_sim_ps_id_enum)sim_ps_id, MIPC_SIM_STATE_IND, callback, (MIPC_API_CB)cb, cb_priv_ptr) == 0) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        return MIPC_API_RESULT_FAIL;
    }
}

mipc_api_result_enum mipc_sim_imsi_get_sync( mipc_sim_ps_id_enum sim_ps_id, mipc_sim_imsi_struct *result_ptr, uint8_t mode)
{
    if ((NULL == result_ptr) || (!(mode == 0 || mode == 1))) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_imsi_get(NULL, NULL, sim_ps_id, mode, result_ptr);
}

mipc_api_result_enum mipc_sim_imsi_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_IMSI_GET_CB cb, void *cb_priv_ptr, uint8_t mode)
{
    if ((NULL == cb) || (!(mode == 0 || mode == 1))) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_imsi_get(cb, cb_priv_ptr, sim_ps_id,mode, NULL);
}

mipc_api_result_enum mipc_sim_iccid_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_iccid_struct *result_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_iccid_get(NULL, NULL, sim_ps_id, result_ptr);
}

mipc_api_result_enum mipc_sim_iccid_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_ICCID_GET_CB cb, void *cb_priv_ptr)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_iccid_get(cb, cb_priv_ptr, sim_ps_id, NULL);
}

mipc_api_result_enum mipc_sim_msisdn_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_msisdn_struct_v *result_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_msisdn_get(NULL, NULL, sim_ps_id, result_ptr);
}

mipc_api_result_enum mipc_sim_msisdn_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_MSISDN_GET_CB cb, void *cb_priv_ptr)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_msisdn_get(cb, cb_priv_ptr, sim_ps_id, NULL);
}

mipc_api_result_enum mipc_sim_pin_protect_sync(mipc_sim_ps_id_enum sim_ps_id,  mipc_sim_pin_protect_struct *result_ptr, mipc_sim_pin_protection_const_enum protect_type, mipc_sim_pin_type_const_enum pin_type, char *pin_code_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_pin_protect(NULL, NULL, sim_ps_id, result_ptr, protect_type, pin_type, pin_code_ptr);

}

mipc_api_result_enum mipc_sim_pin_protect_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_PIN_PROTECT_CB cb, void *cb_priv_ptr, mipc_sim_pin_protection_const_enum protect_type, mipc_sim_pin_type_const_enum pin_type, char *pin_code_ptr)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_pin_protect(cb, cb_priv_ptr, sim_ps_id, NULL, protect_type, pin_type, pin_code_ptr);
}

mipc_api_result_enum mipc_sim_verify_pin_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_verify_pin_struct *result_ptr, mipc_sim_pin_type_const_enum pin_type, char *pin_code_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_verify_pin(NULL, NULL, sim_ps_id, result_ptr, pin_type, pin_code_ptr);
}

mipc_api_result_enum mipc_sim_verify_pin_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_VERIFY_PIN_CB cb, void *cb_priv_ptr, mipc_sim_pin_type_const_enum pin_type, char *pin_code_ptr)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_verify_pin(cb, cb_priv_ptr, sim_ps_id, NULL, pin_type, pin_code_ptr);
}

mipc_api_result_enum mipc_sim_change_pin_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_change_pin_struct *result_ptr, mipc_sim_pin_type_const_enum pin_type, char *old_pin_code_ptr, char *new_pin_code_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_change_pin(NULL, NULL, sim_ps_id, result_ptr, pin_type, old_pin_code_ptr, new_pin_code_ptr);
}

mipc_api_result_enum mipc_sim_change_pin_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_CHG_PIN_CB cb, void *cb_priv_ptr, mipc_sim_pin_type_const_enum pin_type, char *old_pin_code_ptr, char *new_pin_code_ptr)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_change_pin(cb, cb_priv_ptr, sim_ps_id, NULL, pin_type, old_pin_code_ptr, new_pin_code_ptr);
}

mipc_api_result_enum mipc_sim_unblock_pin_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_unblock_pin_struct *result_ptr, mipc_sim_pin_type_const_enum pin_type, char *puk_code_ptr, char *pin_code_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_unblock_pin(NULL, NULL, sim_ps_id, result_ptr, pin_type, puk_code_ptr, pin_code_ptr);
}

mipc_api_result_enum mipc_sim_unblock_pin_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_UNBLOCK_PIN_CB cb, void *cb_priv_ptr, mipc_sim_pin_type_const_enum pin_type,  char *puk_code_ptr, char *pin_code_ptr)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_unblock_pin(cb, cb_priv_ptr, sim_ps_id, NULL, pin_type, puk_code_ptr, pin_code_ptr);
}

mipc_api_result_enum mipc_sim_pin_info_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_pin_info_struct *result_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_pin_info_get(NULL, NULL, sim_ps_id, result_ptr);

}

mipc_api_result_enum mipc_sim_pin_info_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_PIN_INFO_GET_CB cb, void *cb_priv_ptr)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_pin_info_get(cb, cb_priv_ptr, sim_ps_id, NULL);
}

mipc_api_result_enum mipc_sim_pin_list_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_pin_list_struct *result_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_pin_list_get(NULL, NULL, sim_ps_id, result_ptr);
}

mipc_api_result_enum mipc_sim_pin_list_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_PIN_LIST_GET_CB cb, void *cb_priv_ptr)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_pin_list_get(cb, cb_priv_ptr, sim_ps_id, NULL);
}

static mipc_api_result_enum mipc_sim_channel_generic_access_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_apdu_access_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;
    uint16_t list_len = 0;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_CHANNEL_GENERIC_ACCESS_CNF_T_SW, NULL);
        if (NULL == val_ptr) break;
        result_ptr->sw = *((uint16_t*)val_ptr);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_CHANNEL_GENERIC_ACCESS_CNF_T_RESP_LEN, NULL);
        if (NULL == val_ptr) break;
        result_ptr->resp_len = *((uint16_t*)val_ptr);
        if(result_ptr->resp_len > 0) {
            if ((val_ptr = (char *)mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_CHANNEL_GENERIC_ACCESS_CNF_T_RESP_APDU, &list_len)) == NULL) break;
            MEMCPY(result_ptr->resp_apdu, val_ptr, result_ptr->resp_len);
        } else {
            (result_ptr->resp_apdu)[0] = 0;
        }
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_channel_generic_access_cb(mipc_msg_t *msg_ptr, MIPC_SIM_CHANNEL_GENERIC_ACCESS_CB cb, void *cb_priv_ptr)
{
    mipc_sim_apdu_access_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_sim_apdu_access_struct));
    if(mipc_sim_channel_generic_access_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_CHANNEL_GENERIC_ACCESS_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }


}

static mipc_api_result_enum mipc_sim_channel_generic_access(MIPC_SIM_CHANNEL_GENERIC_ACCESS_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sim_apdu_access_struct *result_ptr, mipc_sim_app_type_const_enum app_id, uint8_t channel_id, uint16_t apdu_len, uint8_t *apdu_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_CHANNEL_GENERIC_ACCESS_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_CHANNEL_GENERIC_ACCESS_REQ_T_APP_ID, app_id);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_CHANNEL_GENERIC_ACCESS_REQ_T_CHANNEL_ID, channel_id);
    mipc_msg_add_tlv_uint16(msg_req_ptr, MIPC_SIM_CHANNEL_GENERIC_ACCESS_REQ_T_APDU_LEN, apdu_len);
    if (apdu_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_CHANNEL_GENERIC_ACCESS_REQ_T_APDU, apdu_len, apdu_ptr);
    }
    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_channel_generic_access_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_channel_generic_access_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sim_channel_generic_access_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_apdu_access_struct *result_ptr, mipc_sim_app_type_const_enum app_id, uint8_t channel_id, uint16_t apdu_len, uint8_t *apdu_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_channel_generic_access(NULL, NULL, sim_ps_id, result_ptr, app_id, channel_id, apdu_len, apdu_ptr);
}

mipc_api_result_enum mipc_sim_channel_generic_access_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_CHANNEL_GENERIC_ACCESS_CB cb, void *cb_priv_ptr, mipc_sim_app_type_const_enum app_id, uint8_t channel_id, uint16_t apdu_len, uint8_t *apdu_ptr)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_channel_generic_access(cb, cb_priv_ptr, sim_ps_id, NULL, app_id, channel_id, apdu_len, apdu_ptr);
}

static mipc_api_result_enum mipc_sim_channel_restricted_access_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_apdu_access_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;
    uint16_t list_len = 0;
    //printf("mipc_sim_channel_restricted_access_cnf_decode");

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_CHANNEL_RESTRICTED_ACCESS_CNF_T_SW, NULL);
        if (NULL == val_ptr) break;
        result_ptr->sw = *((uint16_t*)val_ptr);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_CHANNEL_RESTRICTED_ACCESS_CNF_T_RESP_LEN, NULL);
        if (NULL == val_ptr) break;
        result_ptr->resp_len = *((uint16_t*)val_ptr);
        if (result_ptr->resp_len > 0) {
            val_ptr = (char *)mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_CHANNEL_RESTRICTED_ACCESS_CNF_T_RESP_APDU, &list_len);
            if(val_ptr == NULL) {
                break;
            }
            MEMCPY(result_ptr->resp_apdu, val_ptr, result_ptr->resp_len);
            (result_ptr->resp_apdu)[result_ptr->resp_len +1]= '\0';
        } else {
            (result_ptr->resp_apdu)[0]= '\0';
        }
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_channel_restricted_access_cb(mipc_msg_t *msg_ptr, MIPC_SIM_CHANNEL_RESTRICTED_ACCESS_CB cb, void *cb_priv_ptr)
{
    mipc_sim_apdu_access_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_sim_apdu_access_struct));
    if(mipc_sim_channel_restricted_access_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_CHANNEL_RESTRICTED_ACCESS_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }

}

static mipc_api_result_enum mipc_sim_channel_restricted_access(MIPC_SIM_CHANNEL_RESTRICTED_ACCESS_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sim_apdu_access_struct *result_ptr, mipc_sim_app_type_const_enum app_id, uint8_t session_id, mipc_sim_access_command_const_enum cmd, uint16_t file_id, uint8_t p1, uint8_t p2, uint16_t p3, uint16_t data_len, char *data_ptr, char *path_id_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_CHANNEL_RESTRICTED_ACCESS_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_CHANNEL_RESTRICTED_ACCESS_REQ_T_APP_ID, app_id);
    if(UINT8_MAX != session_id) {
        mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_CHANNEL_RESTRICTED_ACCESS_REQ_T_SESSION_ID, session_id);
    }
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_CHANNEL_RESTRICTED_ACCESS_REQ_T_CMD, cmd);
    mipc_msg_add_tlv_uint16(msg_req_ptr, MIPC_SIM_CHANNEL_RESTRICTED_ACCESS_REQ_T_FILE_ID, file_id);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_CHANNEL_RESTRICTED_ACCESS_REQ_T_P1, p1);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_CHANNEL_RESTRICTED_ACCESS_REQ_T_P2, p2);
    mipc_msg_add_tlv_uint16(msg_req_ptr, MIPC_SIM_CHANNEL_RESTRICTED_ACCESS_REQ_T_P3, p3);
    mipc_msg_add_tlv_uint16(msg_req_ptr, MIPC_SIM_CHANNEL_RESTRICTED_ACCESS_REQ_T_DATA_LEN, data_len);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_CHANNEL_RESTRICTED_ACCESS_REQ_T_FCP_CONVERT, MIPC_SIM_FCP_CONVERT_ENABLE);
    if (data_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_CHANNEL_RESTRICTED_ACCESS_REQ_T_DATA, data_len, data_ptr);
    }
    if (path_id_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_CHANNEL_RESTRICTED_ACCESS_REQ_T_PATH, strlen((const char*)(path_id_ptr)), path_id_ptr);
    }
    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_channel_restricted_access_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_channel_restricted_access_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sim_channel_restricted_access_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_apdu_access_struct *result_ptr, mipc_sim_app_type_const_enum app_id, uint8_t session_id, mipc_sim_access_command_const_enum cmd, uint16_t file_id, uint8_t p1, uint8_t p2, uint16_t p3, uint16_t data_len, char *data_ptr, char *path_id_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_channel_restricted_access(NULL, NULL, sim_ps_id, result_ptr, app_id, session_id, cmd, file_id, p1, p2, p3, data_len, data_ptr, path_id_ptr);
}

mipc_api_result_enum mipc_sim_channel_restricted_access_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_CHANNEL_RESTRICTED_ACCESS_CB cb, void *cb_priv_ptr, mipc_sim_app_type_const_enum app_id, uint8_t session_id, mipc_sim_access_command_const_enum cmd, uint16_t file_id, uint8_t p1, uint8_t p2, uint16_t p3, uint16_t data_len, char *data_ptr, char *path_id_ptr)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_channel_restricted_access(cb, cb_priv_ptr, sim_ps_id, NULL, app_id, session_id, cmd, file_id, p1, p2, p3, data_len, data_ptr, path_id_ptr);
}

static mipc_api_result_enum mipc_sim_long_apdu_access_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_long_apdu_access_struct_v *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;
    uint16_t len = 0;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_LONG_APDU_ACCESS_CNF_T_VERSION, NULL);
        if (NULL == val_ptr) break;
        result_ptr->version = *((uint8_t*)val_ptr);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_LONG_APDU_ACCESS_CNF_T_SW, NULL);
        if (NULL == val_ptr) break;
        result_ptr->sw = *((uint16_t*)val_ptr);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_LONG_APDU_ACCESS_CNF_T_DATA_LEN, NULL);
        if (NULL != val_ptr) {
            len = *((uint16_t*)val_ptr);
            if (len < result_ptr->data_len) {
                result_ptr->data_len = len;
            }
            if ((result_ptr->data_len != 0) && ((val_ptr = (char *)mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_LONG_APDU_ACCESS_CNF_T_DATA, NULL)) == NULL)) break;
            MEMCPY(result_ptr->data, val_ptr, result_ptr->data_len);
        }
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);


    if ((result == MIPC_API_RESULT_FAIL) || (MIPC_RESULT_SUCCESS != result_ptr->result_code)) result_ptr->data_len = 0;

    return result;
}

static void mipc_sim_long_apdu_access_cb(mipc_msg_t *msg_ptr, MIPC_SIM_LONG_APDU_READ_CB cb, void *cb_priv_ptr)
{
    size_t alloc_size = sizeof(mipc_sim_long_apdu_access_struct_v) + SIM_MAX_DATA_LEN;
    mipc_sim_long_apdu_access_struct_v *result_ptr = (mipc_sim_long_apdu_access_struct_v *)ALLOC(alloc_size);

    if (result_ptr) {
        MEMSET(result_ptr, 0, alloc_size);
        result_ptr->data_len = SIM_MAX_DATA_LEN;
        if(mipc_sim_long_apdu_access_cnf_decode(msg_ptr, result_ptr) == MIPC_API_RESULT_SUCCESS) {
            cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);
        } else {
            mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_LONG_APDU_ACCESS_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
        }
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sim_long_apdu_access(MIPC_SIM_LONG_APDU_READ_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sim_long_apdu_access_struct_v *result_ptr, uint8_t version, uint8_t app_id_len, uint8_t app_id[16], char *path_id_ptr, uint16_t file_id, uint16_t file_offset, uint16_t num_of_bytes, char *local_pin_ptr, uint16_t binary_data_len, uint8_t *binary_data_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_LONG_APDU_ACCESS_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_LONG_APDU_ACCESS_REQ_T_VERSION, version);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_LONG_APDU_ACCESS_REQ_T_APP_ID_LEN, app_id_len);
    if (app_id) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_LONG_APDU_ACCESS_REQ_T_APP_ID, (app_id_len > 16 ? 16 : app_id_len), app_id);
    }
    if (path_id_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_LONG_APDU_ACCESS_REQ_T_PATH_ID, strlen((const char*)(path_id_ptr)), path_id_ptr);
    }
    mipc_msg_add_tlv_uint16(msg_req_ptr, MIPC_SIM_LONG_APDU_ACCESS_REQ_T_FILE_ID, file_id);
    mipc_msg_add_tlv_uint16(msg_req_ptr, MIPC_SIM_LONG_APDU_ACCESS_REQ_T_FILE_OFFSET, file_offset);
    mipc_msg_add_tlv_uint16(msg_req_ptr, MIPC_SIM_LONG_APDU_ACCESS_REQ_T_NUMBER_OF_BYTES, num_of_bytes);
    if (local_pin_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_LONG_APDU_ACCESS_REQ_T_LOCAL_PIN, strlen((const char*)(local_pin_ptr)), local_pin_ptr);
    }
    mipc_msg_add_tlv_uint16(msg_req_ptr, MIPC_SIM_LONG_APDU_ACCESS_REQ_T_BINARY_DATA_LEN, binary_data_len);
    if (binary_data_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_LONG_APDU_ACCESS_REQ_T_BINARY_DATA, binary_data_len, binary_data_ptr);
    }
    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_long_apdu_access_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_long_apdu_access_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sim_long_apdu_access_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_long_apdu_access_struct_v *result_ptr, uint8_t version, uint8_t app_id_len, uint8_t app_id[16], char *path_id_ptr, uint16_t file_id, uint16_t file_offset, uint16_t num_of_bytes, char *local_pin_ptr, uint16_t binary_data_len, uint8_t *binary_data_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_long_apdu_access(NULL, NULL, sim_ps_id, result_ptr, version, app_id_len, app_id, path_id_ptr, file_id, file_offset, num_of_bytes, local_pin_ptr, binary_data_len, binary_data_ptr);
}


mipc_api_result_enum mipc_sim_long_apdu_access_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_LONG_APDU_READ_CB cb, void *cb_priv_ptr, uint8_t version, uint8_t app_id_len, uint8_t app_id[16], char *path_id_ptr, uint16_t file_id, uint16_t file_offset, uint16_t num_of_bytes, char *local_pin_ptr, uint16_t binary_data_len, uint8_t *binary_data_ptr)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_long_apdu_access(cb, cb_priv_ptr, sim_ps_id, NULL, version, app_id_len, app_id, path_id_ptr, file_id, file_offset, num_of_bytes, local_pin_ptr, binary_data_len, binary_data_ptr);
}

static mipc_api_result_enum mipc_sim_common_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_result_enum *result_ptr)
{
    uint32_t *t_result_ptr;
    uint8_t api_error = 1;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            *result_ptr = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            *result_ptr = MIPC_RESULT_SUCCESS;
        } else {
            *result_ptr = MIPC_RESULT_FAILURE;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        *result_ptr = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sim_terminal_capability_set_cb(mipc_msg_t *msg_ptr, MIPC_SIM_TERMINAL_CAPABILITY_SET_CB cb, void *cb_priv_ptr)
{
    mipc_result_enum result_ptr;
    mipc_sim_common_cnf_decode(msg_ptr, &result_ptr);
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
}

static mipc_api_result_enum mipc_sim_terminal_capability_set(MIPC_SIM_TERMINAL_CAPABILITY_SET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_result_enum *result_ptr, uint8_t terminal_capability_count, uint16_t terminal_capability_data_len, uint8_t *terminal_capability_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_SET_TERMINAL_CAPABILITY_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_SET_TERMINAL_CAPABILITY_REQ_T_COUNT, terminal_capability_count);
    mipc_msg_add_tlv_uint16(msg_req_ptr, MIPC_SIM_SET_TERMINAL_CAPABILITY_REQ_T_TC_LEN, terminal_capability_data_len);

    if (terminal_capability_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_SET_TERMINAL_CAPABILITY_REQ_T_TC, terminal_capability_data_len, terminal_capability_ptr);
    }

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_terminal_capability_set_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret =  mipc_sim_common_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sim_terminal_capability_set_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_result_enum *result_ptr, uint8_t terminal_capability_count, uint16_t terminal_capability_data_len, uint8_t *terminal_capability_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_terminal_capability_set(NULL, NULL, sim_ps_id, result_ptr, terminal_capability_count, terminal_capability_data_len, terminal_capability_ptr);
}

mipc_api_result_enum mipc_sim_terminal_capability_set_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_TERMINAL_CAPABILITY_SET_CB cb, void *cb_priv_ptr, uint8_t terminal_capability_count, uint16_t terminal_capability_data_len, uint8_t *terminal_capability_ptr)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_terminal_capability_set(cb, cb_priv_ptr, sim_ps_id, NULL, terminal_capability_count, terminal_capability_data_len, terminal_capability_ptr);
}

static mipc_api_result_enum mipc_sim_terminal_capability_get_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_terminal_capability_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;
    //uint8_t msisdn_count;
    uint16_t list_len = 0;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_TERMINAL_CAPABILITY_CNF_T_COUNT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->terminal_capability_count = *((uint8_t*)val_ptr);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_TERMINAL_CAPABILITY_CNF_T_TC_LEN, NULL);
        if (NULL == val_ptr) break;
        result_ptr->terminal_capability_data_len = *((uint16_t*)val_ptr);
        if (result_ptr->terminal_capability_data_len) {
            val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_TERMINAL_CAPABILITY_CNF_T_TC, &list_len);
            if (NULL == val_ptr) break;
            MEMCPY(result_ptr->terminal_capability_list, val_ptr, list_len > result_ptr->terminal_capability_data_len ? result_ptr->terminal_capability_data_len : list_len);
        }
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;

}

static void mipc_sim_terminal_capability_get_cb(mipc_msg_t *msg_ptr, MIPC_SIM_TERMINAL_CAPABILITY_GET_CB cb, void *cb_priv_ptr)
{
    mipc_sim_terminal_capability_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_sim_terminal_capability_struct));
    if(mipc_sim_terminal_capability_get_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_GET_TERMINAL_CAPABILITY_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }
}

static mipc_api_result_enum mipc_sim_terminal_capability_get(MIPC_SIM_TERMINAL_CAPABILITY_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sim_terminal_capability_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_GET_TERMINAL_CAPABILITY_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_terminal_capability_get_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_terminal_capability_get_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sim_terminal_capability_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_terminal_capability_struct *result_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_terminal_capability_get(NULL, NULL, sim_ps_id, result_ptr);
}


mipc_api_result_enum mipc_sim_terminal_capability_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_TERMINAL_CAPABILITY_GET_CB cb, void *cb_priv_ptr)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_terminal_capability_get(cb, cb_priv_ptr, sim_ps_id, NULL);
}

static void mipc_sim_reset_set_cb(mipc_msg_t *msg_ptr, MIPC_SIM_RESET_SET_CB cb, void *cb_priv_ptr)
{
    mipc_result_enum result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_result_enum));
    if(mipc_sim_common_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_SET_RESET_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }

}

static mipc_api_result_enum mipc_sim_reset_set(MIPC_SIM_RESET_SET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_result_enum *result_ptr, mipc_sim_pass_through_mode_const_enum mode)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_SET_RESET_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_SET_RESET_REQ_T_MODE, mode);

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_reset_set_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_common_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sim_reset_set_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_result_enum *result_ptr, mipc_sim_pass_through_mode_const_enum mode)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_reset_set(NULL, NULL, sim_ps_id, result_ptr, mode);
}


mipc_api_result_enum mipc_sim_reset_set_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_RESET_SET_CB cb, void *cb_priv_ptr, mipc_sim_pass_through_mode_const_enum mode)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_reset_set(cb, cb_priv_ptr, sim_ps_id, NULL, mode);
}

static mipc_api_result_enum mipc_sim_reset_get_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_reset_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;
    //uint8_t msisdn_count;
    //uint16_t list_len = 0;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_RESET_CNF_T_MODE, NULL);
        if (NULL == val_ptr) break;
        result_ptr->mode = (mipc_sim_pass_through_mode_const_enum)(*((uint8_t*)val_ptr));
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;

}

static void mipc_sim_reset_get_cb(mipc_msg_t *msg_ptr, MIPC_SIM_RESET_GET_CB cb, void *cb_priv_ptr)
{
    mipc_sim_reset_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_sim_reset_struct));
    if(mipc_sim_reset_get_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_GET_RESET_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }

}

static mipc_api_result_enum mipc_sim_reset_get(MIPC_SIM_RESET_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sim_reset_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_GET_RESET_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_reset_get_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_reset_get_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sim_reset_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_reset_struct *result_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_reset_get(NULL, NULL, sim_ps_id, result_ptr);
}

mipc_api_result_enum mipc_sim_reset_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_RESET_GET_CB cb, void *cb_priv_ptr )
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_reset_get(cb, cb_priv_ptr, sim_ps_id, NULL);
}

static mipc_api_result_enum mipc_sim_app_list_get_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_app_list_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;
    uint16_t list_len = 0;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_APP_LIST_CNF_T_VERSION, NULL);
        if (NULL == val_ptr) break;
        result_ptr->version = (mipc_sim_pass_through_mode_const_enum)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_APP_LIST_CNF_T_APP_COUNT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->app_list_count = *((uint8_t*)val_ptr);
        if (result_ptr->app_list_count) {
            val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_APP_LIST_CNF_T_APP_LIST, &list_len);
            if (NULL == val_ptr) break;
            MEMCPY(result_ptr->app_list, val_ptr, list_len);
        }
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;

}

static void mipc_sim_app_list_get_cb(mipc_msg_t *msg_ptr, MIPC_SIM_APP_LIST_GET_CB cb, void *cb_priv_ptr)
{
    mipc_sim_app_list_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_sim_app_list_struct));
    if(mipc_sim_app_list_get_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_APP_LIST_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }

}

static mipc_api_result_enum mipc_sim_app_list_get(MIPC_SIM_APP_LIST_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sim_app_list_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_APP_LIST_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_app_list_get_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_app_list_get_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sim_app_list_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_app_list_struct *result_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_app_list_get(NULL, NULL, sim_ps_id, result_ptr);
}

mipc_api_result_enum mipc_sim_app_list_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_APP_LIST_GET_CB cb, void *cb_priv_ptr)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_app_list_get(cb, cb_priv_ptr, sim_ps_id, NULL);
}

static mipc_api_result_enum mipc_sim_file_status_get_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_file_status_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;
    uint16_t list_len = 0;
    //printf("mipc_sim_file_status_get_cnf_decode\n");

    if (msg_cnf_ptr == NULL) { //timeout
        ////printf("NULL\n");
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_FILE_STATUS_CNF_T_VERSION, NULL);
        if (NULL == val_ptr) break;
        result_ptr->version = *((uint8_t*)val_ptr);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_FILE_STATUS_CNF_T_SW, NULL);
        if (NULL == val_ptr) break;
        result_ptr->sw = *((uint16_t*)val_ptr);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_FILE_STATUS_CNF_T_FILE_ACCESSIBILITY, NULL);
        if (NULL == val_ptr) break;
        result_ptr->file_accessibility = (mipc_sim_file_accessibility_const_enum)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_FILE_STATUS_CNF_T_FILE_TYPE, NULL);
        if (NULL == val_ptr) break;
        result_ptr->file_type = (mipc_sim_file_type_const_enum)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_FILE_STATUS_CNF_T_FILE, NULL);
        if (NULL == val_ptr) break;
        result_ptr->file_structure = (mipc_sim_file_structure_const_enum)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_FILE_STATUS_CNF_T_ITEM_COUNT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->item_count = *((uint8_t*)val_ptr);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_FILE_STATUS_CNF_T_SIZE, NULL);
        if (NULL == val_ptr) break;
        result_ptr->size = *((uint8_t*)val_ptr);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_FILE_STATUS_CNF_T_LOCK_STATUS, &list_len);
        ////printf("*val_ptr:%d %d %d %d\n",  *((uint8_t*)val_ptr),  *((uint8_t*)val_ptr + 1), *((uint8_t*)val_ptr + 2),  *((uint8_t*)val_ptr + 3));

        ////printf("list_len:%d\n", list_len);
        if (NULL == val_ptr) break;
        MEMCPY(result_ptr->lock_status, val_ptr, list_len);
        //printf("lock_status:%d %d %d %d\n", result_ptr->lock_status[0], result_ptr->lock_status[1], result_ptr->lock_status[2], result_ptr->lock_status[3]);
        result_ptr->lock_status[0] = (mipc_sim_pin_type_const_enum)(*((uint8_t*)val_ptr));
        result_ptr->lock_status[1] = (mipc_sim_pin_type_const_enum)(*((uint8_t*)val_ptr + 1));
        result_ptr->lock_status[2] = (mipc_sim_pin_type_const_enum)(*((uint8_t*)val_ptr + 2));
        result_ptr->lock_status[3] = (mipc_sim_pin_type_const_enum)(*((uint8_t*)val_ptr + 3));
        //printf("lock_status:%d %d %d %d\n", result_ptr->lock_status[0], result_ptr->lock_status[1], result_ptr->lock_status[2], result_ptr->lock_status[3]);
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_file_status_get_cb(mipc_msg_t *msg_ptr, MIPC_SIM_FILE_STATUS_GET_CB cb, void *cb_priv_ptr)
{
    mipc_sim_file_status_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_sim_file_status_struct));
    if(mipc_sim_file_status_get_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_FILE_STATUS_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }

}

static mipc_api_result_enum mipc_sim_file_status_get(MIPC_SIM_FILE_STATUS_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sim_file_status_struct *result_ptr, uint8_t version, uint8_t app_id_len, uint8_t *app_id_ptr, uint8_t file_path_len, uint8_t *file_path_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_FILE_STATUS_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_FILE_STATUS_REQ_T_VERSION, version);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_FILE_STATUS_REQ_T_AID_LEN, app_id_len);
    if (app_id_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_FILE_STATUS_REQ_T_AID, app_id_len, app_id_ptr);
    }
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_FILE_STATUS_REQ_T_FILE_PATH_LEN, file_path_len);
    if (file_path_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_FILE_STATUS_REQ_T_FILE_PATH, file_path_len, file_path_ptr);
    }

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_file_status_get_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_file_status_get_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sim_file_status_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_file_status_struct *result_ptr, uint8_t version, uint8_t app_id_len, uint8_t *app_id_ptr, uint8_t file_path_len, uint8_t *file_path_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_file_status_get(NULL, NULL, sim_ps_id, result_ptr, version, app_id_len, app_id_ptr, file_path_len, file_path_ptr);
}

mipc_api_result_enum mipc_sim_file_status_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_FILE_STATUS_GET_CB cb, void *cb_priv_ptr, uint8_t version, uint8_t app_id_len, uint8_t *app_id_ptr, uint8_t file_path_len, uint8_t *file_path_ptr)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_file_status_get(cb, cb_priv_ptr, sim_ps_id, NULL, version, app_id_len, app_id_ptr, file_path_len, file_path_ptr);
}

static mipc_api_result_enum mipc_sim_pin_ext_set_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_pin_info_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_SET_PIN_EX_CNF_T_PIN_TYPE, NULL);
        if (NULL == val_ptr) break;
        result_ptr->pin_type = (mipc_sim_pin_type_const_enum)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_SET_PIN_EX_CNF_T_PIN_STATE, NULL);
        if (NULL == val_ptr) break;
        result_ptr->pin_state = (mipc_sim_pin_state_const_enum)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_SET_PIN_EX_CNF_T_REMAINING_ATTEMPTS, NULL);
        if (NULL == val_ptr) break;
        result_ptr->remaining_attempts = (uint8_t)(*((uint32_t*)val_ptr));
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_pin_ext_set_cb(mipc_msg_t *msg_ptr, MIPC_SIM_PIN_EXT_SET_CB cb, void *cb_priv_ptr)
{
    mipc_sim_pin_info_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_sim_pin_info_struct));
    if(mipc_sim_pin_ext_set_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_SET_PIN_EX_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }
}

static mipc_api_result_enum mipc_sim_pin_ext_set(MIPC_SIM_PIN_EXT_SET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sim_pin_info_struct *result_ptr, mipc_sim_pin_type_const_enum pin_type, mipc_sim_pin_operation_const_enum operation, char *pin_code_ptr, char *new_pin_code_ptr, uint8_t app_id_len, uint8_t *app_id_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_SET_PIN_EX_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_SET_PIN_EX_REQ_T_PIN_TYPE, pin_type);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_SET_PIN_EX_REQ_T_OP, operation);
    if (pin_code_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_SET_PIN_EX_REQ_T_PIN_CODE, strlen((const char*)(pin_code_ptr)), pin_code_ptr);
    }
    if (new_pin_code_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_SET_PIN_EX_REQ_T_NEW_PIN_CODE, strlen((const char*)(new_pin_code_ptr)), new_pin_code_ptr);
    }
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_SET_PIN_EX_REQ_T_AID_LEN, app_id_len);
    if (app_id_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_SET_PIN_EX_REQ_T_AID, app_id_len, app_id_ptr);
    }

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_pin_ext_set_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_pin_ext_set_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sim_pin_ext_set_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_pin_info_struct *result_ptr, mipc_sim_pin_type_const_enum pin_type, mipc_sim_pin_operation_const_enum operation, char *pin_code_ptr, char *new_pin_code_ptr, uint8_t app_id_len, uint8_t *app_id_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_pin_ext_set(NULL, NULL, sim_ps_id, result_ptr, pin_type, operation, pin_code_ptr, new_pin_code_ptr, app_id_len, app_id_ptr);
}

mipc_api_result_enum mipc_sim_pin_ext_set_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_PIN_EXT_SET_CB cb, void *cb_priv_ptr, mipc_sim_pin_type_const_enum pin_type, mipc_sim_pin_operation_const_enum operation, char *pin_code_ptr, char *new_pin_code_ptr, uint8_t app_id_len, uint8_t *app_id_ptr)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_pin_ext_set(cb, cb_priv_ptr, sim_ps_id, NULL, pin_type, operation, pin_code_ptr, new_pin_code_ptr, app_id_len, app_id_ptr);
}

static mipc_api_result_enum mipc_sim_pin_ext_get_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_pin_info_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_PIN_EX_CNF_T_PIN_TYPE, NULL);
        if (NULL == val_ptr) break;
        result_ptr->pin_type = (mipc_sim_pin_type_const_enum)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_PIN_EX_CNF_T_PIN_STATE, NULL);
        if (NULL == val_ptr) break;
        result_ptr->pin_state = (mipc_sim_pin_state_const_enum)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_PIN_EX_CNF_T_REMAINING_ATTEMPTS, NULL);
        if (NULL == val_ptr) break;
        result_ptr->remaining_attempts = (uint8_t)(*((uint32_t*)val_ptr));
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_pin_ext_get_cb(mipc_msg_t *msg_ptr, MIPC_SIM_PIN_EXT_GET_CB cb, void *cb_priv_ptr)
{
    mipc_sim_pin_info_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_sim_pin_info_struct));
    if(mipc_sim_pin_ext_get_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_GET_PIN_EX_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }

}

static mipc_api_result_enum mipc_sim_pin_ext_get(MIPC_SIM_PIN_EXT_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sim_pin_info_struct *result_ptr, uint8_t version, uint8_t app_id_len, uint8_t *app_id_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_GET_PIN_EX_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_GET_PIN_EX_REQ_T_VERSION, version);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_GET_PIN_EX_REQ_T_AID_LEN, app_id_len);
    if (app_id_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_GET_PIN_EX_REQ_T_AID, app_id_len, app_id_ptr);
    }

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_pin_ext_get_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_pin_ext_get_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}


mipc_api_result_enum mipc_sim_pin_ext_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_pin_info_struct *result_ptr, uint8_t version, uint8_t app_id_len, uint8_t *app_id_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_pin_ext_get(NULL, NULL, sim_ps_id, result_ptr, version, app_id_len, app_id_ptr);
}

mipc_api_result_enum mipc_sim_pin_ext_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_PIN_EXT_GET_CB cb, void *cb_priv_ptr, uint8_t version, uint8_t app_id_len, uint8_t *app_id_ptr)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_pin_ext_get(cb, cb_priv_ptr, sim_ps_id, NULL, version, app_id_len, app_id_ptr);
}



mipc_api_result_enum mipc_sim_atr_info_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_atr_info_struct *result_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_atr_info_get(NULL, NULL, sim_ps_id, result_ptr);
}

mipc_api_result_enum mipc_sim_atr_info_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_ATR_INFO_GET_CB cb, void *cb_priv_ptr)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_atr_info_get(cb, cb_priv_ptr, sim_ps_id, NULL);
}

mipc_api_result_enum mipc_sim_channel_open_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_open_channel_info_struct *result_ptr, uint8_t app_id_len, char *app_id_ptr, uint8_t p2, uint8_t channel_group)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_channel_open(NULL, NULL, sim_ps_id, result_ptr, app_id_len, app_id_ptr, p2, channel_group);
}

mipc_api_result_enum mipc_sim_channel_open_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_CHANNEL_OPEN_CB cb, void *cb_priv_ptr, uint8_t app_id_len, char *app_id_ptr, uint8_t p2, uint8_t channel_group)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_channel_open(cb, cb_priv_ptr, sim_ps_id, NULL, app_id_len, app_id_ptr, p2, channel_group);
}

mipc_api_result_enum mipc_sim_channel_close_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_close_channel_info_struct *result_ptr, uint8_t channel_id, uint8_t channel_group)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_channel_close(NULL, NULL, sim_ps_id, result_ptr, channel_id, channel_group);
}

mipc_api_result_enum mipc_sim_channel_close_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_CHANNEL_CLOSE_CB cb, void *cb_priv_ptr, uint8_t channel_id, uint8_t channel_group)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_channel_close(cb, cb_priv_ptr, sim_ps_id, NULL, channel_id, channel_group);
}
mipc_api_result_enum mipc_sim_ext_auth_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_EXT_AUTH_GET_CB cb, void *cb_priv_ptr, uint8_t channel_id, uint8_t mode, uint16_t cmd_len, char *cmd_data, uint8_t app_id)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_ext_auth_get(cb, cb_priv_ptr, sim_ps_id, channel_id, mode, cmd_len, cmd_data, app_id,  NULL);
}

mipc_api_result_enum mipc_sim_ext_auth_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_ext_auth_info_struct *result_ptr, uint8_t channel_id, uint8_t mode, uint16_t cmd_len, char* cmd_data, uint8_t app_id)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_ext_auth_get(NULL, NULL, sim_ps_id, channel_id, mode, cmd_len, cmd_data, app_id, result_ptr);
}

mipc_api_result_enum mipc_sim_gsm_auth_get_async(mipc_sim_ps_id_enum sim_ps_id,  MIPC_SIM_GSM_AUTH_GET_CB cb, void *cb_priv_ptr, uint8_t rand1_ptr[16], uint8_t rand2_ptr[16], uint8_t rand3_ptr[16])
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_gsm_auth_get(cb, cb_priv_ptr, sim_ps_id, rand1_ptr, rand2_ptr, rand3_ptr, NULL);
}

mipc_api_result_enum mipc_sim_gsm_auth_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_gsm_auth_info_struct *result_ptr, uint8_t rand1_ptr[16], uint8_t rand2_ptr[16], uint8_t rand3_ptr[16])
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_gsm_auth_get(NULL, NULL, sim_ps_id, rand1_ptr, rand2_ptr, rand3_ptr, result_ptr);
}

mipc_api_result_enum mipc_sim_get_facility_async(mipc_sim_ps_id_enum sim_ps_id,  MIPC_SIM_GET_FACILITY_CB cb, void *cb_priv_ptr, mipc_sim_app_type_const_enum app_id, char* facility)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_get_facility(cb, cb_priv_ptr, sim_ps_id, app_id,facility, NULL);
}

mipc_api_result_enum mipc_sim_get_facility_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_get_facility_info_struct *result_ptr, mipc_sim_app_type_const_enum app_id, char* facility)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_get_facility(NULL, NULL, sim_ps_id, app_id,facility, result_ptr);
}

mipc_api_result_enum mipc_sim_set_facility_async(mipc_sim_ps_id_enum sim_ps_id,  MIPC_SIM_SET_FACILITY_CB cb, void *cb_priv_ptr, mipc_sim_app_type_const_enum app_id, char* facility, char* pass_word, uint8_t mode)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_set_facility(cb, cb_priv_ptr, sim_ps_id, app_id,facility, pass_word, mode, NULL);
}

mipc_api_result_enum mipc_sim_set_facility_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_set_facility_info_struct *result_ptr, mipc_sim_app_type_const_enum app_id, char* facility, char* pass_word, uint8_t mode)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_set_facility(NULL, NULL, sim_ps_id, app_id,facility,  pass_word, mode, result_ptr);
}

static mipc_api_result_enum mipc_sim_get_euicc_slots_status_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_get_euicc_slots_status_struct *result_ptr)
{
    void* val_ptr;
    uint8_t count = 0;
    uint16_t val_len = 0;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }

        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_EUICC_SLOTS_STATUS_CNF_T_SLOTS_INFO_COUNT, NULL);
        if (NULL == val_ptr) break;
        count = (uint8_t)(*((uint8_t*)val_ptr));
        if (count < result_ptr->slots_info_count) {
            result_ptr->slots_info_count = count;
        }
        if (result_ptr->slots_info_count) {
            val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_EUICC_SLOTS_STATUS_CNF_T_SLOTS_INFO_LIST, &val_len);
            if (NULL == val_ptr) break;
            MEMCPY(result_ptr->slots_info_list, val_ptr, (result_ptr->slots_info_count)*sizeof(mipc_ecc_info_struct4));
        }

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_get_euicc_slots_status_cb(mipc_msg_t *msg_ptr, MIPC_SIM_GET_EUICC_SLOTS_STATUS_CB cb, void *cb_priv_ptr)
{
    mipc_sim_get_euicc_slots_status_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_sim_get_euicc_slots_status_struct));
    result_ptr.slots_info_count = MIPC_MAX_SIM_NUM;
    if(mipc_sim_get_euicc_slots_status_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_GET_EUICC_SLOTS_STATUS_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }
}

static mipc_api_result_enum mipc_sim_get_euicc_slots_status(MIPC_SIM_GET_EUICC_SLOTS_STATUS_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id,mipc_sim_get_euicc_slots_status_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_GET_EUICC_SLOTS_STATUS_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_get_euicc_slots_status_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_get_euicc_slots_status_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sim_get_euicc_slots_status_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_get_euicc_slots_status_struct *result_ptr) {
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_get_euicc_slots_status( NULL, NULL, sim_ps_id, result_ptr);

}

mipc_api_result_enum mipc_sim_get_euicc_slots_status_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_GET_EUICC_SLOTS_STATUS_CB cb, void *cb_priv_ptr) {
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_get_euicc_slots_status(cb, cb_priv_ptr, sim_ps_id, NULL);
}

static mipc_api_result_enum mipc_sim_access_profile_connect_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_access_profile_connect_struct *result_ptr)
{
    void* val_ptr;
    uint16_t val_len = 0;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }

        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_ACCESS_PROFILE_CONNECT_CNF_T_CUR_TYPE, NULL);
        if (NULL == val_ptr) break;
        result_ptr->cur_type = (uint8_t)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_ACCESS_PROFILE_CONNECT_CNF_T_SUPPORT_TYPE, NULL);
        if (NULL == val_ptr) break;
        result_ptr->support_type = (uint8_t)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_ACCESS_PROFILE_CONNECT_CNF_T_ATR, &val_len);
        if (NULL == val_ptr) break;
        MEMCPY(result_ptr->atr, val_ptr, (val_len<MIPC_MAX_ATR_LEN ? val_len : MIPC_MAX_ATR_LEN));

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_access_profile_connect_cb(mipc_msg_t *msg_ptr, MIPC_SIM_ACCESS_PROFILE_CONNECT_CB cb, void *cb_priv_ptr)
{
    mipc_sim_access_profile_connect_struct result_ptr;
    MEMSET(&result_ptr, 0, sizeof(mipc_sim_access_profile_connect_struct));
    if(mipc_sim_access_profile_connect_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_ACCESS_PROFILE_CONNECT_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }

}

static mipc_api_result_enum mipc_sim_access_profile_connect(MIPC_SIM_ACCESS_PROFILE_CONNECT_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id,mipc_sim_access_profile_connect_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_ACCESS_PROFILE_CONNECT_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_access_profile_connect_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_access_profile_connect_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sim_access_profile_connect_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_access_profile_connect_struct *result_ptr) {
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_access_profile_connect( NULL, NULL, sim_ps_id, result_ptr);

}

mipc_api_result_enum mipc_sim_access_profile_connect_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_ACCESS_PROFILE_CONNECT_CB cb, void *cb_priv_ptr) {
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_access_profile_connect(cb, cb_priv_ptr, sim_ps_id, NULL);
}

static mipc_api_result_enum mipc_sim_access_profile_disconnect_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_access_profile_disconnect_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_access_profile_disconnect_cb(mipc_msg_t *msg_ptr, MIPC_SIM_ACCESS_PROFILE_DISCONNECT_CB cb, void *cb_priv_ptr)
{
    mipc_sim_access_profile_disconnect_struct result_ptr;
    MEMSET(&result_ptr, 0, sizeof(mipc_sim_access_profile_disconnect_struct));
    if(mipc_sim_access_profile_disconnect_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_ACCESS_PROFILE_DISCONNECT_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }

}

static mipc_api_result_enum mipc_sim_access_profile_disconnect(MIPC_SIM_ACCESS_PROFILE_DISCONNECT_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id,mipc_sim_access_profile_disconnect_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_ACCESS_PROFILE_DISCONNECT_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_access_profile_disconnect_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_access_profile_disconnect_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sim_access_profile_disconnect_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_access_profile_disconnect_struct *result_ptr) {
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_access_profile_disconnect( NULL, NULL, sim_ps_id, result_ptr);

}

mipc_api_result_enum mipc_sim_access_profile_disconnect_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_ACCESS_PROFILE_DISCONNECT_CB cb,
        void *cb_priv_ptr) {
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_access_profile_disconnect(cb, cb_priv_ptr, sim_ps_id, NULL);
}

static mipc_api_result_enum mipc_sim_access_profile_power_on_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_access_profile_power_on_struct *result_ptr)
{
    void* val_ptr;
    uint16_t val_len = 0;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }

        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_ACCESS_PROFILE_POWER_ON_CNF_T_CUR_TYPE, NULL);
        if (NULL == val_ptr) break;
        result_ptr->cur_type = (uint8_t)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_ACCESS_PROFILE_POWER_ON_CNF_T_ATR, &val_len);
        if (NULL == val_ptr) break;
        MEMCPY(result_ptr->atr, val_ptr, (val_len<MIPC_MAX_ATR_LEN ? val_len : MIPC_MAX_ATR_LEN));

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_access_profile_power_on_cb(mipc_msg_t *msg_ptr, MIPC_SIM_ACCESS_PROFILE_POWER_ON_CB cb, void *cb_priv_ptr)
{
    mipc_sim_access_profile_power_on_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_sim_access_profile_power_on_struct));
    if(    mipc_sim_access_profile_power_on_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_ACCESS_PROFILE_POWER_ON_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }

}

static mipc_api_result_enum mipc_sim_access_profile_power_on(MIPC_SIM_ACCESS_PROFILE_POWER_ON_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, uint8_t type,mipc_sim_access_profile_power_on_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_ACCESS_PROFILE_POWER_ON_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_ACCESS_PROFILE_POWER_ON_REQ_T_TYPE, type);
    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_access_profile_power_on_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_access_profile_power_on_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sim_access_profile_power_on_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_access_profile_power_on_struct *result_ptr,
        uint8_t type) {
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_access_profile_power_on( NULL, NULL, sim_ps_id, type, result_ptr);

}

mipc_api_result_enum mipc_sim_access_profile_power_on_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_ACCESS_PROFILE_POWER_ON_CB cb, void *cb_priv_ptr,
        uint8_t type) {
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_access_profile_power_on(cb, cb_priv_ptr, sim_ps_id, type, NULL);
}

static mipc_api_result_enum mipc_sim_access_profile_power_off_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_access_profile_power_off_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_access_profile_power_off_cb(mipc_msg_t *msg_ptr, MIPC_SIM_ACCESS_PROFILE_POWER_OFF_CB cb, void *cb_priv_ptr)
{
    mipc_sim_access_profile_power_off_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_sim_access_profile_power_off_struct));
    if(    mipc_sim_access_profile_power_off_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_ACCESS_PROFILE_POWER_OFF_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }
}

static mipc_api_result_enum mipc_sim_access_profile_power_off(MIPC_SIM_ACCESS_PROFILE_POWER_OFF_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sim_access_profile_power_off_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_ACCESS_PROFILE_POWER_OFF_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_access_profile_power_off_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_access_profile_power_off_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sim_access_profile_power_off_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_access_profile_power_off_struct *result_ptr) {
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_access_profile_power_off(NULL, NULL, sim_ps_id, result_ptr);

}

mipc_api_result_enum mipc_sim_access_profile_power_off_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_ACCESS_PROFILE_POWER_OFF_CB cb,
        void *cb_priv_ptr) {
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_access_profile_power_off(cb, cb_priv_ptr, sim_ps_id, NULL);
}

static mipc_api_result_enum mipc_sim_access_profile_reset_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_access_profile_reset_struct *result_ptr)
{
    void* val_ptr;
    uint16_t val_len = 0;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }

        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_ACCESS_PROFILE_RESET_CNF_T_CUR_TYPE, NULL);
        if (NULL == val_ptr) break;
        result_ptr->cur_type = (uint8_t)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_ACCESS_PROFILE_RESET_CNF_T_ATR, &val_len);
        if (NULL == val_ptr) break;
        MEMCPY(result_ptr->atr, val_ptr, (val_len<MIPC_MAX_ATR_LEN ? val_len : MIPC_MAX_ATR_LEN));

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_access_profile_reset_cb(mipc_msg_t *msg_ptr, MIPC_SIM_ACCESS_PROFILE_RESET_CB cb, void *cb_priv_ptr)
{
    mipc_sim_access_profile_reset_struct result_ptr;
    MEMSET(&result_ptr, 0, sizeof(mipc_sim_access_profile_reset_struct));
    if(mipc_sim_access_profile_reset_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_ACCESS_PROFILE_RESET_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }
}

static mipc_api_result_enum mipc_sim_access_profile_reset(MIPC_SIM_ACCESS_PROFILE_RESET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, uint8_t type, mipc_sim_access_profile_reset_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_ACCESS_PROFILE_RESET_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_ACCESS_PROFILE_POWER_ON_REQ_T_TYPE, type);
    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_access_profile_reset_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_access_profile_reset_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sim_access_profile_reset_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_access_profile_reset_struct *result_ptr,
        uint8_t type) {
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_access_profile_reset( NULL, NULL, sim_ps_id, type, result_ptr);
}

mipc_api_result_enum mipc_sim_access_profile_reset_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_ACCESS_PROFILE_RESET_CB cb, void *cb_priv_ptr,
        uint8_t type) {
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_access_profile_reset(cb, cb_priv_ptr, sim_ps_id, type, NULL);
}

static mipc_api_result_enum mipc_sim_access_profile_apdu_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_access_profile_apdu_struct *result_ptr)
{
    void* val_ptr;
    uint16_t val_len = 0;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }

        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_ACCESS_PROFILE_APDU_CNF_T_APDU, &val_len);
        if (NULL == val_ptr) break;
        MEMCPY(result_ptr->apdu, val_ptr, (val_len<MIPC_MAX_SIM_APDU_STRING_LEN ? val_len : MIPC_MAX_SIM_APDU_STRING_LEN));

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_access_profile_apdu_cb(mipc_msg_t *msg_ptr, MIPC_SIM_ACCESS_PROFILE_APDU_CB cb, void *cb_priv_ptr)
{
    mipc_sim_access_profile_apdu_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_sim_access_profile_apdu_struct));
    if(mipc_sim_access_profile_apdu_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_ACCESS_PROFILE_APDU_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }

}

static mipc_api_result_enum mipc_sim_access_profile_apdu(MIPC_SIM_ACCESS_PROFILE_APDU_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, uint8_t type, char* apdu, mipc_sim_access_profile_apdu_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_ACCESS_PROFILE_APDU_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_ACCESS_PROFILE_POWER_ON_REQ_T_TYPE, type);
    if(apdu) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_ACCESS_PROFILE_APDU_REQ_T_APDU, strlen(apdu)<MIPC_MAX_SIM_APDU_STRING_LEN?strlen(apdu):MIPC_MAX_SIM_APDU_STRING_LEN, apdu);
    }
    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_access_profile_apdu_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_access_profile_apdu_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sim_access_profile_apdu_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_access_profile_apdu_struct *result_ptr, uint8_t type, char* apdu) {
    if (NULL == result_ptr || NULL == apdu) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_access_profile_apdu( NULL, NULL, sim_ps_id, type, apdu, result_ptr);

}

mipc_api_result_enum mipc_sim_access_profile_apdu_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_ACCESS_PROFILE_APDU_CB cb, void *cb_priv_ptr, uint8_t type, char* apdu) {
    if (NULL == cb || NULL == apdu) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_access_profile_apdu(cb, cb_priv_ptr, sim_ps_id, type, apdu, NULL);
}

static mipc_api_result_enum mipc_sim_set_sim_power_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_set_sim_power_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_set_sim_power_cb(mipc_msg_t *msg_ptr, MIPC_SIM_SET_SIM_POWER_CB cb, void *cb_priv_ptr)
{
    mipc_sim_set_sim_power_struct result_ptr;
    MEMSET(&result_ptr, 0, sizeof(mipc_sim_set_sim_power_struct));
    if(    mipc_sim_set_sim_power_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_SET_SIM_POWER_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }

}

static mipc_api_result_enum mipc_sim_set_sim_power(MIPC_SIM_SET_SIM_POWER_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, uint8_t mode,
        uint8_t sim_power, mipc_sim_set_sim_power_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_SET_SIM_POWER_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_SET_SIM_POWER_REQ_T_MODE, mode);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_SET_SIM_POWER_REQ_T_SIM_POWER, sim_power);
    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_set_sim_power_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_set_sim_power_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sim_set_sim_power_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_set_sim_power_struct *result_ptr, uint8_t mode,
        uint8_t sim_power) {
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_set_sim_power( NULL, NULL, sim_ps_id, mode, sim_power, result_ptr);
}

mipc_api_result_enum mipc_sim_set_sim_power_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_SET_SIM_POWER_CB cb, void *cb_priv_ptr, uint8_t mode,
        uint8_t sim_power) {
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_set_sim_power(cb, cb_priv_ptr, sim_ps_id, mode, sim_power, NULL);
}

static mipc_api_result_enum mipc_sim_set_physical_slots_mapping_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_set_physical_slots_mapping_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_set_physical_slots_mapping_cb(mipc_msg_t *msg_ptr, MIPC_SIM_SET_PHYSICAL_SLOTS_MAPPING_CB cb, void *cb_priv_ptr)
{
    mipc_sim_set_physical_slots_mapping_struct result_ptr;
    MEMSET(&result_ptr, 0, sizeof(mipc_sim_set_physical_slots_mapping_struct));
    if(mipc_sim_set_physical_slots_mapping_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_SET_PHYSICAL_SLOTS_MAPPING_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }

}

static mipc_api_result_enum mipc_sim_set_physical_slots_mapping(
        MIPC_SIM_SET_PHYSICAL_SLOTS_MAPPING_CB cb,
        void *cb_priv_ptr,
        mipc_sim_ps_id_enum sim_ps_id,
        uint8_t slots_num,
        uint8_t* slot_mapping_list,
        mipc_sim_set_physical_slots_mapping_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_SET_PHYSICAL_SLOTS_MAPPING_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_SET_PHYSICAL_SLOTS_MAPPING_REQ_T_SLOTS_NUM, slots_num);
    if (slot_mapping_list) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_SET_PHYSICAL_SLOTS_MAPPING_REQ_T_SLOTS_MAPPING_LIST, slots_num * sizeof(uint8_t), slot_mapping_list);
    }
    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_set_physical_slots_mapping_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_set_physical_slots_mapping_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sim_set_physical_slots_mapping_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_set_physical_slots_mapping_struct *result_ptr,
        uint8_t slots_num, uint8_t *slot_mapping_list) {
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_set_physical_slots_mapping(
    NULL,
    NULL, sim_ps_id, slots_num, slot_mapping_list, result_ptr);
}

mipc_api_result_enum mipc_sim_set_physical_slots_mapping_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_SET_PHYSICAL_SLOTS_MAPPING_CB cb,
        void *cb_priv_ptr, uint8_t slots_num, uint8_t *slot_mapping_list) {
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_set_physical_slots_mapping(cb, cb_priv_ptr, sim_ps_id, slots_num, slot_mapping_list,
    NULL);
}

static mipc_api_result_enum mipc_sim_extended_channel_generic_access_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_extended_channel_generic_acess_struct *result_ptr)
{
    void* val_ptr;
    uint16_t val_len = 0;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_EXTENDED_CHANNEL_GENERIC_ACCESS_CNF_T_SW, NULL);
        if (NULL == val_ptr) break;
        result_ptr->sw = (uint16_t)(*((uint16_t*)val_ptr));

        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_EXTENDED_CHANNEL_GENERIC_ACCESS_CNF_T_RESP_LEN, NULL);
        if (NULL == val_ptr) break;
        result_ptr->resp_len = (uint16_t)(*((uint16_t*)val_ptr));
        if(result_ptr->resp_len > 0) {
            val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_EXTENDED_CHANNEL_GENERIC_ACCESS_CNF_T_RESP_APDU, &val_len);
            if (NULL == val_ptr) break;
            MEMCPY(result_ptr->resp_apdu, val_ptr, (val_len<MIPC_MAX_SIM_CMD_EXTENDED_DATA_BYTE_LEN ? val_len : MIPC_MAX_SIM_CMD_EXTENDED_DATA_BYTE_LEN));
        } else {
            (result_ptr->resp_apdu)[0] = 0;
        }

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_extended_channel_generic_access_cb(mipc_msg_t *msg_ptr, MIPC_SIM_EXTENDED_CHANNEL_GENERIC_ACCESS_CB cb, void *cb_priv_ptr)
{
    mipc_sim_extended_channel_generic_acess_struct result_ptr;
    MEMSET(&result_ptr, 0, sizeof(mipc_sim_extended_channel_generic_acess_struct));
    if(mipc_sim_extended_channel_generic_access_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_EXTENDED_CHANNEL_GENERIC_ACCESS_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }


}

static mipc_api_result_enum mipc_sim_extended_channel_generic_access(
        MIPC_SIM_EXTENDED_CHANNEL_GENERIC_ACCESS_CB cb,
        void *cb_priv_ptr,
        mipc_sim_ps_id_enum sim_ps_id,
        uint8_t session_id,
        uint8_t cla,
        uint8_t ins,
        uint8_t p1,
        uint8_t p2,
        uint8_t p3,
        uint16_t data_len,
        char* data,
        mipc_sim_extended_channel_generic_acess_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_EXTENDED_CHANNEL_GENERIC_ACCESS_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_EXTENDED_CHANNEL_GENERIC_ACCESS_REQ_T_SESSION_ID, session_id);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_EXTENDED_CHANNEL_GENERIC_ACCESS_REQ_T_CLA, cla);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_EXTENDED_CHANNEL_GENERIC_ACCESS_REQ_T_INS, ins);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_EXTENDED_CHANNEL_GENERIC_ACCESS_REQ_T_P1, p1);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_EXTENDED_CHANNEL_GENERIC_ACCESS_REQ_T_P2, p2);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_EXTENDED_CHANNEL_GENERIC_ACCESS_REQ_T_P3, p3);//TBD
    mipc_msg_add_tlv_uint16(msg_req_ptr, MIPC_SIM_EXTENDED_CHANNEL_GENERIC_ACCESS_REQ_T_DATA_LEN, data_len);
    if (data) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_EXTENDED_CHANNEL_GENERIC_ACCESS_REQ_T_DATA, data_len, data);
    }
    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_extended_channel_generic_access_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_extended_channel_generic_access_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sim_extended_channel_generic_access_sync(mipc_sim_ps_id_enum sim_ps_id,
        mipc_sim_extended_channel_generic_acess_struct *result_ptr, uint8_t session_id, uint8_t cla, uint8_t ins, uint8_t p1, uint8_t p2, uint8_t p3,
        uint16_t data_len, char *data) {
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_extended_channel_generic_access(
    NULL,
    NULL, sim_ps_id, session_id, cla, ins, p1, p2, p3, data_len, data, result_ptr);
}

mipc_api_result_enum mipc_sim_extended_channel_generic_access_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_EXTENDED_CHANNEL_GENERIC_ACCESS_CB cb,
        void *cb_priv_ptr, uint8_t session_id, uint8_t cla, uint8_t ins, uint8_t p1, uint8_t p2, uint8_t p3, uint16_t data_len, char *data) {
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_extended_channel_generic_access(cb, cb_priv_ptr, sim_ps_id, session_id, cla, ins, p1, p2, p3, data_len, data,
    NULL);
}

static mipc_api_result_enum mipc_sim_uicc_file_access_record_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_uicc_file_access_record_struct *result_ptr)
{
    void* val_ptr;
    uint16_t val_len = 0;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_UICC_FILE_ACCESS_RECORD_CNF_T_SW, NULL);
        if (NULL == val_ptr) break;
        result_ptr->sw = (uint16_t)(*((uint16_t*)val_ptr));

        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_UICC_FILE_ACCESS_RECORD_CNF_T_RESP_LEN, NULL);
        if (NULL == val_ptr) break;
        result_ptr->resp_len = (uint16_t)(*((uint16_t*)val_ptr));
        if((result_ptr->resp_len) > 0) {
            val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_UICC_FILE_ACCESS_RECORD_CNF_T_RESP_APDU, &val_len);
            if (NULL == val_ptr) break;
            MEMCPY(result_ptr->resp_apdu, val_ptr, (val_len<MIPC_MAX_SIM_CMD_EXTENDED_DATA_BYTE_LEN ? val_len : MIPC_MAX_SIM_CMD_EXTENDED_DATA_BYTE_LEN));
        }

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_uicc_file_access_record_cb(mipc_msg_t *msg_ptr, MIPC_SIM_UICC_FILE_ACCESS_RECORD_CB cb, void *cb_priv_ptr)
{
    mipc_sim_uicc_file_access_record_struct result_ptr;
    MEMSET(&result_ptr, 0, sizeof(mipc_sim_uicc_file_access_record_struct));
    if(mipc_sim_uicc_file_access_record_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_UICC_FILE_ACCESS_RECORD_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }


}

static mipc_api_result_enum mipc_sim_uicc_file_access_record(
        MIPC_SIM_UICC_FILE_ACCESS_RECORD_CB cb,
        void *cb_priv_ptr,
        mipc_sim_ps_id_enum sim_ps_id,
        uint8_t* app_id,
        uint8_t app_id_len,
        uint16_t file_id,
        uint8_t record_num,
        uint16_t data_len,
        uint8_t* data,
        char* path,
        char* pin2,
        mipc_sim_uicc_file_access_record_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_UICC_FILE_ACCESS_RECORD_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    if (app_id) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_UICC_FILE_ACCESS_RECORD_REQ_T_APP_ID, app_id_len, app_id);
    }
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_UICC_FILE_ACCESS_RECORD_REQ_T_APP_ID_LEN, app_id_len);
    mipc_msg_add_tlv_uint16(msg_req_ptr, MIPC_SIM_UICC_FILE_ACCESS_RECORD_REQ_T_FILE_ID, file_id);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_UICC_FILE_ACCESS_RECORD_REQ_T_RECORD_NUM, record_num);
    mipc_msg_add_tlv_uint16(msg_req_ptr, MIPC_SIM_UICC_FILE_ACCESS_RECORD_REQ_T_DATA_LEN, data_len);
    if (data) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_UICC_FILE_ACCESS_RECORD_REQ_T_DATA, data_len, data);
    }
    if (path) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_UICC_FILE_ACCESS_RECORD_REQ_T_PATH, (strlen(path)<MIPC_MAX_SIM_PATH_STR_LEN?strlen(path):MIPC_MAX_SIM_PATH_STR_LEN), path);
    }
    if (pin2) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_UICC_FILE_ACCESS_RECORD_REQ_T_PIN2, (strlen(pin2)<MIPC_MAX_SIM_PIN_CODE_LEN?strlen(pin2):MIPC_MAX_SIM_PIN_CODE_LEN), pin2);
    }
    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_uicc_file_access_record_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_uicc_file_access_record_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sim_uicc_file_access_record_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_uicc_file_access_record_struct *result_ptr,
        uint8_t *app_id, uint8_t app_id_len, uint16_t file_id, uint8_t record_num, uint16_t data_len, uint8_t *data, char* path, char* pin2) {
    if (NULL == result_ptr || NULL == path) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_uicc_file_access_record(NULL, NULL, sim_ps_id, app_id, app_id_len, file_id, record_num, data_len, data, path, pin2, result_ptr);
}

mipc_api_result_enum mipc_sim_uicc_file_access_record_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_UICC_FILE_ACCESS_RECORD_CB cb, void *cb_priv_ptr,
        uint8_t *app_id, uint8_t app_id_len, uint16_t file_id, uint8_t record_num, uint16_t data_len, uint8_t *data, char* path, char* pin2) {
    if (NULL == cb || NULL == path) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_uicc_file_access_record(cb, cb_priv_ptr, sim_ps_id, app_id, app_id_len, file_id, record_num, data_len, data, path, pin2,NULL);
}

static mipc_api_result_enum mipc_sim_uicc_file_access_binary_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_uicc_file_access_binary_struct *result_ptr)
{
    void* val_ptr;
    uint16_t val_len = 0;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_UICC_FILE_ACCESS_BINARY_CNF_T_SW, NULL);
        if (NULL == val_ptr) break;
        result_ptr->sw = (uint16_t)(*((uint16_t*)val_ptr));

        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_UICC_FILE_ACCESS_BINARY_CNF_T_RESP_LEN, NULL);
        if (NULL == val_ptr) break;
        result_ptr->resp_len = (uint16_t)(*((uint16_t*)val_ptr));
        if((result_ptr->resp_len) > 0) {
            val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_UICC_FILE_ACCESS_BINARY_CNF_T_RESP_APDU, &val_len);
            if (NULL == val_ptr) break;
            MEMCPY(result_ptr->resp_apdu, val_ptr, (val_len<MIPC_MAX_SIM_CMD_EXTENDED_DATA_BYTE_LEN ? val_len : MIPC_MAX_SIM_CMD_EXTENDED_DATA_BYTE_LEN));
        }

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_uicc_file_access_binary_cb(mipc_msg_t *msg_ptr, MIPC_SIM_UICC_FILE_ACCESS_BINARY_CB cb, void *cb_priv_ptr)
{
    mipc_sim_uicc_file_access_binary_struct result_ptr;
    MEMSET(&result_ptr, 0, sizeof(mipc_sim_uicc_file_access_binary_struct));
    if(mipc_sim_uicc_file_access_binary_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_UICC_FILE_ACCESS_BINARY_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }
}

static mipc_api_result_enum mipc_sim_uicc_file_access_binary(
        MIPC_SIM_UICC_FILE_ACCESS_BINARY_CB cb,
        void *cb_priv_ptr,
        mipc_sim_ps_id_enum sim_ps_id,
        uint8_t* app_id,
        uint8_t app_id_len,
        uint16_t file_id,
        uint16_t offset,
        uint16_t data_len,
        uint8_t* data,
        char* path,
        char* pin2,
        mipc_sim_uicc_file_access_binary_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_UICC_FILE_ACCESS_BINARY_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    if (app_id) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_UICC_FILE_ACCESS_BINARY_REQ_T_APP_ID, app_id_len, app_id);
    }
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SIM_UICC_FILE_ACCESS_BINARY_REQ_T_APP_ID_LEN, app_id_len);
    mipc_msg_add_tlv_uint16(msg_req_ptr, MIPC_SIM_UICC_FILE_ACCESS_BINARY_REQ_T_FILE_ID, file_id);
    mipc_msg_add_tlv_uint16(msg_req_ptr, MIPC_SIM_UICC_FILE_ACCESS_BINARY_REQ_T_OFFSET, offset);
    mipc_msg_add_tlv_uint16(msg_req_ptr, MIPC_SIM_UICC_FILE_ACCESS_BINARY_REQ_T_DATA_LEN, data_len);
    if (data) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_UICC_FILE_ACCESS_BINARY_REQ_T_DATA, data_len, data);
    }
    if (path) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_UICC_FILE_ACCESS_BINARY_REQ_T_PATH, (strlen(path) < MIPC_MAX_SIM_PATH_STR_LEN ? strlen(path):MIPC_MAX_SIM_PATH_STR_LEN), path);
    }
    if (pin2) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SIM_UICC_FILE_ACCESS_BINARY_REQ_T_PIN2, (strlen(pin2) < MIPC_MAX_SIM_PIN_CODE_LEN ? strlen(pin2):MIPC_MAX_SIM_PIN_CODE_LEN), pin2);
    }
    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_uicc_file_access_binary_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_uicc_file_access_binary_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sim_uicc_file_access_binary_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_uicc_file_access_binary_struct *result_ptr,
        uint8_t *app_id, uint8_t app_id_len, uint16_t file_id, uint16_t offset, uint16_t data_len, uint8_t *data, char* path, char* pin2) {
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_uicc_file_access_binary(NULL,NULL, sim_ps_id, app_id, app_id_len, file_id, offset, data_len, data, path, pin2, result_ptr);
}

mipc_api_result_enum mipc_sim_uicc_file_access_binary_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_UICC_FILE_ACCESS_BINARY_CB cb, void *cb_priv_ptr,
        uint8_t *app_id, uint8_t app_id_len, uint16_t file_id, uint16_t offset, uint16_t data_len, uint8_t *data, char* path, char* pin2) {
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_uicc_file_access_binary(cb, cb_priv_ptr, sim_ps_id, app_id, app_id_len, file_id, offset, data_len, data, path, pin2,
    NULL);
}

static mipc_api_result_enum mipc_sim_get_physical_slots_mapping_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_get_physical_slots_mapping_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_GET_PHYSICAL_SLOTS_MAPPING_CNF_T_ACTIVE_PHYSICAL_SLOT_ID, NULL);
        if (NULL == val_ptr) break;
        result_ptr->active_physical_slot_id = (uint8_t)(*((uint8_t*)val_ptr));

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_get_physical_slots_mapping_cb(mipc_msg_t *msg_ptr, MIPC_SIM_GET_PHYSICAL_SLOTS_MAPPING_CB cb, void *cb_priv_ptr)
{
    mipc_sim_get_physical_slots_mapping_struct result_ptr;
    MEMSET(&result_ptr, 0, sizeof(mipc_sim_get_physical_slots_mapping_struct));
    if(mipc_sim_get_physical_slots_mapping_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_GET_PHYSICAL_SLOTS_MAPPING_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }
}

static mipc_api_result_enum mipc_sim_get_physical_slots_mapping(
        MIPC_SIM_GET_PHYSICAL_SLOTS_MAPPING_CB cb,
        void *cb_priv_ptr,
        mipc_sim_ps_id_enum sim_ps_id,
        mipc_sim_get_physical_slots_mapping_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_GET_PHYSICAL_SLOTS_MAPPING_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_get_physical_slots_mapping_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_get_physical_slots_mapping_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sim_get_physical_slots_mapping_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sim_get_physical_slots_mapping_struct *result_ptr) {
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_get_physical_slots_mapping(
    NULL,
    NULL, sim_ps_id, result_ptr);
}
mipc_api_result_enum mipc_sim_get_physical_slots_mapping_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_GET_PHYSICAL_SLOTS_MAPPING_CB cb,
        void *cb_priv_ptr) {
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_get_physical_slots_mapping(cb, cb_priv_ptr, sim_ps_id,
    NULL);
}

static mipc_api_result_enum mipc_sim_pin_count_query_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sim_pin_count_query_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_PIN_COUNT_QUERY_CNF_T_PIN1, NULL);
        if (NULL == val_ptr) break;
        result_ptr->pin1 = (uint8_t)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_PIN_COUNT_QUERY_CNF_T_PIN2, NULL);
        if (NULL == val_ptr) break;
        result_ptr->pin2 = (uint8_t)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_PIN_COUNT_QUERY_CNF_T_PUK1, NULL);
        if (NULL == val_ptr) break;
        result_ptr->puk1 = (uint8_t)(*((uint8_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SIM_PIN_COUNT_QUERY_CNF_T_PUK2, NULL);
        if (NULL == val_ptr) break;
        result_ptr->puk2 = (uint8_t)(*((uint8_t*)val_ptr));
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sim_pin_count_query_cb(mipc_msg_t *msg_ptr, MIPC_SIM_PIN_COUNT_QUERY_CB cb, void *cb_priv_ptr)
{
    mipc_sim_pin_count_query_struct result_ptr;
    MEMSET(&result_ptr, 0, sizeof(mipc_sim_pin_count_query_struct));
    if(mipc_sim_pin_count_query_cnf_decode(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_PIN_COUNT_QUERY_CNF, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }
}

static mipc_api_result_enum mipc_sim_pin_count_query (MIPC_SIM_PIN_COUNT_QUERY_CB cb,void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sim_pin_count_query_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SIM_PIN_COUNT_QUERY_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sim_pin_count_query_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sim_pin_count_query_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sim_pin_count_query_sync( mipc_sim_ps_id_enum sim_ps_id, mipc_sim_pin_count_query_struct *result_ptr) {
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_pin_count_query(NULL,NULL, sim_ps_id, result_ptr);
}

mipc_api_result_enum mipc_sim_pin_count_query_async( mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_PIN_COUNT_QUERY_CB cb, void *cb_priv_ptr) {
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sim_pin_count_query(cb, cb_priv_ptr, sim_ps_id, NULL);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sim_euicc_slots_status_ind(mipc_msg_t *msg_ptr, mipc_sim_euicc_slots_status_ind_struct *result_ptr)
{
    void *val_ptr;
    uint16_t val_len = 0;
    uint8_t count = 0;
    uint8_t api_error = 1;

    do {
        result_ptr->result_code = MIPC_RESULT_SUCCESS;
        if ((val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SIM_EUICC_SLOTS_STATUS_IND_T_SLOTS_INFO_COUNT, NULL)) == NULL) break;
        count = (uint8_t) * ((uint8_t *)val_ptr);
        if(count < result_ptr->slots_info_count) {
            result_ptr->slots_info_count = count;
        }
        if(result_ptr->slots_info_count) {
            if ((val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SIM_EUICC_SLOTS_STATUS_IND_T_SLOTS_INFO_LIST, &val_len)) == NULL) break;
            MEMCPY(result_ptr->slots_info_list, val_ptr, (result_ptr->slots_info_count)*(sizeof(mipc_sim_slots_info_struct4)));
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sim_euicc_slots_status_ind_cb(mipc_msg_t *msg_ptr, MIPC_SIM_EUICC_SLOTS_STATUS_IND_CB cb, void *cb_priv_ptr)
{
    mipc_sim_euicc_slots_status_ind_struct result_ptr;
    MEMSET(&result_ptr, 0, sizeof(mipc_sim_euicc_slots_status_ind_struct));
    result_ptr.slots_info_count = MIPC_MAX_SIM_NUM;
    if (mipc_sim_euicc_slots_status_ind(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_EUICC_SLOTS_STATUS_IND, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }
}

mipc_api_result_enum mipc_sim_euicc_slots_status_register(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_EUICC_SLOTS_STATUS_IND_CB cb, void *cb_priv_ptr) {
    void *callback;
    if (cb) {
        callback = (void*) mipc_sim_euicc_slots_status_ind_cb;
    } else {
        callback = NULL;
    }

    if (mipc_msg_register_ind_api((mipc_msg_sim_ps_id_enum) sim_ps_id, MIPC_SIM_EUICC_SLOTS_STATUS_IND, callback, (MIPC_API_CB) cb, cb_priv_ptr)
            == 0) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        return MIPC_API_RESULT_FAIL;
    }
}

//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sim_iccid_ind(mipc_msg_t *msg_ptr, mipc_sim_iccid_ind_struct *result_ptr)
{
    void *val_ptr;
    uint16_t val_len = 0;
    uint8_t api_error = 1;

    do {
        result_ptr->result_code = MIPC_RESULT_SUCCESS;
        if ((val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SIM_ICCID_IND_T_ICCID, &val_len)) == NULL) break;
        MEMCPY(result_ptr->iccid, val_ptr, (val_len < (MIPC_SIM_FIX_ICCID_LEN+1) ? val_len:(MIPC_SIM_FIX_ICCID_LEN+1)));
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sim_iccid_ind_cb(mipc_msg_t *msg_ptr, MIPC_SIM_ICCID_IND_CB cb, void *cb_priv_ptr)
{
    mipc_sim_iccid_ind_struct result_ptr;
    MEMSET(&result_ptr, 0, sizeof(mipc_sim_iccid_ind_struct));
    if (mipc_sim_iccid_ind(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_ICCID_IND, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }
}

mipc_api_result_enum mipc_sim_iccid_register(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_ICCID_IND_CB cb, void *cb_priv_ptr) {
    void *callback;
    if (cb) {
        callback = (void*) mipc_sim_iccid_ind_cb;
    } else {
        callback = NULL;
    }

    if (mipc_msg_register_ind_api((mipc_msg_sim_ps_id_enum) sim_ps_id, MIPC_SIM_ICCID_IND, callback, (MIPC_API_CB) cb, cb_priv_ptr)
            == 0) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        return MIPC_API_RESULT_FAIL;
    }
}

static mipc_api_result_enum mipc_sim_status_change_with_cause_ind(mipc_msg_t *msg_ptr, mipc_sim_status_change_with_cause_ind_struct *result_ptr)
{
    void *val_ptr;
    uint8_t api_error = 1;

    do {
        result_ptr->result_code = MIPC_RESULT_SUCCESS;
        if ((val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SIM_STATUS_CHANGE_WITH_CAUSE_IND_T_IS_SIM_INSERTED, NULL)) == NULL) break;
        result_ptr->is_sim_inserted = (uint8_t) * ((uint8_t *)val_ptr);
        if ((val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SIM_STATUS_CHANGE_WITH_CAUSE_IND_T_CAUSE, NULL)) == NULL) break;
        result_ptr->cause = (mipc_sim_cause_const_enum) * ((uint8_t *)val_ptr);
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sim_status_change_with_cause_ind_cb(mipc_msg_t *msg_ptr, MIPC_SIM_STATUS_CHANGE_WITH_CAUSE_IND_CB cb, void *cb_priv_ptr)
{
    mipc_sim_status_change_with_cause_ind_struct result_ptr;
    MEMSET(&result_ptr, 0, sizeof(mipc_sim_status_change_with_cause_ind_struct));
    if (mipc_sim_status_change_with_cause_ind(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_STATUS_CHANGE_WITH_CAUSE_IND, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }
}

mipc_api_result_enum mipc_sim_status_change_with_cause_register(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_STATUS_CHANGE_WITH_CAUSE_IND_CB cb,
        void *cb_priv_ptr) {
    void *callback;
    if (cb) {
        callback = (void*) mipc_sim_status_change_with_cause_ind_cb;
    } else {
        callback = NULL;
    }

    if (mipc_msg_register_ind_api((mipc_msg_sim_ps_id_enum) sim_ps_id, MIPC_SIM_STATUS_CHANGE_WITH_CAUSE_IND, callback, (MIPC_API_CB) cb, cb_priv_ptr)
            == 0) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        return MIPC_API_RESULT_FAIL;
    }
}

static mipc_api_result_enum mipc_sim_physical_slots_mapping_done_ind(mipc_msg_t *msg_ptr, mipc_sim_physical_slots_mapping_done_ind_struct *result_ptr)
{
    uint8_t api_error = 1;

    do {
        result_ptr->result_code = MIPC_RESULT_SUCCESS;
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sim_physical_slots_mapping_done_ind_cb(mipc_msg_t *msg_ptr, MIPC_SIM_PHYSICAL_SLOTS_MAPPING_DONE_IND_CB cb, void *cb_priv_ptr)
{
    mipc_sim_physical_slots_mapping_done_ind_struct result_ptr;
    MEMSET(&result_ptr, 0, sizeof(mipc_sim_physical_slots_mapping_done_ind_struct));
    if (mipc_sim_physical_slots_mapping_done_ind(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_PHYSICAL_SLOTS_MAPPING_DONE_IND, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }
}

mipc_api_result_enum mipc_sim_physical_slots_mapping_done_register(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_PHYSICAL_SLOTS_MAPPING_DONE_IND_CB cb,
        void *cb_priv_ptr) {
    void *callback;
    if (cb) {
        callback = (void*) mipc_sim_physical_slots_mapping_done_ind_cb;
    } else {
        callback = NULL;
    }

    if (mipc_msg_register_ind_api((mipc_msg_sim_ps_id_enum) sim_ps_id, MIPC_SIM_PHYSICAL_SLOTS_MAPPING_DONE_IND, callback, (MIPC_API_CB) cb, cb_priv_ptr)
            == 0) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        return MIPC_API_RESULT_FAIL;
    }
}

static mipc_api_result_enum mipc_stk_sim_refresh_ind(mipc_msg_t *msg_ptr, mipc_stk_sim_refresh_ind_struct *result_ptr)
{
    void *val_ptr;
    uint16_t val_len = 0;
    uint8_t api_error = 1;

    do {
        result_ptr->result_code = MIPC_RESULT_SUCCESS;
        if ((val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_STK_SIM_REFRESH_IND_T_SIM_REFRESH_RESULT, NULL)) == NULL) break;
        result_ptr->sim_refresh_result = mipc_stk_sim_refresh_ind_get_sim_refresh_result(msg_ptr, mipc_sim_refresh_result_type_const_NONE);
        if ((val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_STK_SIM_REFRESH_IND_T_EF_ID, NULL)) != NULL) {
            result_ptr->ef_id = mipc_stk_sim_refresh_ind_get_ef_id(msg_ptr, 0);
        } else {
            result_ptr->ef_id = UINT32_MAX;
        }
        if ((val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_STK_SIM_REFRESH_IND_T_AID, &val_len)) != NULL) {
            MEMCPY(result_ptr->aid, val_ptr, (val_len < (MIPC_MAX_AID_LEN) ? val_len:(MIPC_MAX_AID_LEN)));
        } else {
            (result_ptr->aid)[0] = 0;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_stk_sim_refresh_ind_cb(mipc_msg_t *msg_ptr, MIPC_STK_SIM_REFRESH_IND_CB cb, void *cb_priv_ptr)
{
    mipc_stk_sim_refresh_ind_struct result_ptr;
    MEMSET(&result_ptr, 0, sizeof(mipc_stk_sim_refresh_ind_struct));
    if (mipc_stk_sim_refresh_ind(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_STK_SIM_REFRESH_IND, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }
}

mipc_api_result_enum mipc_stk_sim_refresh_register(mipc_sim_ps_id_enum sim_ps_id, MIPC_STK_SIM_REFRESH_IND_CB cb, void *cb_priv_ptr) {
    void *callback;
    if (cb) {
        callback = (void*) mipc_stk_sim_refresh_ind_cb;
    } else {
        callback = NULL;
    }

    if (mipc_msg_register_ind_api((mipc_msg_sim_ps_id_enum) sim_ps_id, MIPC_STK_SIM_REFRESH_IND, callback, (MIPC_API_CB) cb, cb_priv_ptr)
            == 0) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        return MIPC_API_RESULT_FAIL;
    }
}

static mipc_api_result_enum mipc_sim_csim_imsi_change_ind(mipc_msg_t *msg_ptr, mipc_sim_csim_imsi_change_ind_struct *result_ptr)
{
    void *val_ptr;
    uint16_t val_len = 0;
    uint8_t api_error = 1;

    do {
        result_ptr->result_code = MIPC_RESULT_SUCCESS;
        if ((val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SIM_CSIM_IMSI_CHANGE_IND_T_STATUS, NULL)) == NULL) break;
        result_ptr->status = (uint8_t) * ((uint8_t *)val_ptr);
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sim_csim_imsi_change_ind_cb(mipc_msg_t *msg_ptr, MIPC_SIM_CSIM_IMSI_CHANGE_IND_CB cb, void *cb_priv_ptr)
{
    mipc_sim_csim_imsi_change_ind_struct result_ptr;
    MEMSET(&result_ptr, 0, sizeof(mipc_sim_csim_imsi_change_ind_struct));
    if (mipc_sim_csim_imsi_change_ind(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    } else {
        mtkLogE(LOG_TAG, "[id%d]MIPC_SIM_CSIM_IMSI_CHANGE_IND, decode fail", msg_ptr->hdr.msg_sim_ps_id);
    }
}

mipc_api_result_enum mipc_sim_csim_imsi_change_register(mipc_sim_ps_id_enum sim_ps_id, MIPC_SIM_CSIM_IMSI_CHANGE_IND_CB cb, void *cb_priv_ptr) {
    void *callback;
    if (cb) {
        callback = (void*) mipc_sim_csim_imsi_change_ind_cb;
    } else {
        callback = NULL;
    }

    if (mipc_msg_register_ind_api((mipc_msg_sim_ps_id_enum) sim_ps_id, MIPC_SIM_CSIM_IMSI_CHANGE_IND, callback, (MIPC_API_CB) cb, cb_priv_ptr)
            == 0) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        return MIPC_API_RESULT_FAIL;
    }
}
