// SPDX-License-Identifier: MediaTekProprietary
/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  Copyright (c) [2020], MediaTek Inc. All rights reserved.
*  This software/firmware and related documentation ("MediaTek Software") are
*  protected under relevant copyright laws.
*
*  The information contained herein is confidential and proprietary to
*  MediaTek Inc. and/or its licensors. Except as otherwise provided in the
*  applicable licensing terms with MediaTek Inc. and/or its licensors, any
*  reproduction, modification, use or disclosure of MediaTek Software, and
*  information contained herein, in whole or in part, shall be strictly
*  prohibited.
*****************************************************************************/

#include "mipc_msg.h"
#include "mipc_msg_host.h"
#include "mipc_msg_tlv_api.h"
#include "mipc_sms_api.h"
#include "mtk_log.h"

#define LOG_TAG "MIPC_SMS_API"

//decoder function: decode MIPC_MSG to RESULT_STRUCT
static mipc_api_result_enum mipc_sms_config_set_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sms_configuration_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sms_configuration_struct));
    } else {
        return result;
    }
    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    do {
        result_ptr->result_code = (mipc_result_enum)mipc_msg_get_val_uint32(msg_cnf_ptr, MIPC_T_RESULT, 0xFFFFFFFF);
        if (0xFFFFFFFF == result_ptr->result_code) break;
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        //but as debug mode, we show all the infos
        //if(MIPC_RESULT_SUCCESS != result_ptr->result_code) { result = MIPC_API_RESULT_SUCCESS; break; }
        result_ptr->sms_storage_state = (mipc_sms_storage_state_enum)mipc_msg_get_val_uint8(msg_cnf_ptr, MIPC_SMS_CFG_CNF_T_SMS_STATE, 0xFF);
        if (0xFF == result_ptr->sms_storage_state) break;
        result_ptr->format = (mipc_sms_format_enum)mipc_msg_get_val_uint8(msg_cnf_ptr, MIPC_SMS_CFG_CNF_T_FORMAT, 0xFF);
        if (0xFF == result_ptr->format) break;
        result_ptr->max_messages = mipc_msg_get_val_uint16(msg_cnf_ptr, MIPC_SMS_CFG_CNF_T_MAX_MESSAGE, 0xFFFF);
        if (0xFFFF == result_ptr->max_messages) break;
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SMS_CFG_CNF_T_SCA, NULL);
        if (NULL == val_ptr) break;
        MEMCPY(result_ptr->sc_address, val_ptr, 32);
        result_ptr->cdma_short_message_len = 0;
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}
static mipc_api_result_enum mipc_sms_config_get_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sms_configuration_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sms_configuration_struct));
    } else {
        return result;
    }
    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    do {
        result_ptr->result_code = (mipc_result_enum)mipc_msg_get_val_uint32(msg_cnf_ptr, MIPC_T_RESULT, 0xFFFFFFFF);
        if (0xFFFFFFFF == result_ptr->result_code) break;
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        //but as debug mode, we show all the infos
        //if(MIPC_RESULT_SUCCESS != result_ptr->result_code) { result = MIPC_API_RESULT_SUCCESS; break; }
        result_ptr->sms_storage_state = (mipc_sms_storage_state_enum)mipc_msg_get_val_uint8(msg_cnf_ptr, MIPC_SMS_CFG_CNF_T_SMS_STATE, 0xFF);
        if (0xFF == result_ptr->sms_storage_state) break;
        result_ptr->format = (mipc_sms_format_enum)mipc_msg_get_val_uint8(msg_cnf_ptr, MIPC_SMS_CFG_CNF_T_FORMAT, 0xFF);
        if (0xFF == result_ptr->format) break;
        uint16_t sca_len = 0;
        char* sca_ptr = mipc_sms_cfg_cnf_get_sca(msg_cnf_ptr, &sca_len);
        if(NULL != sca_ptr)
            MEMCPY(result_ptr->sc_address, sca_ptr, sca_len>sizeof(result_ptr->sc_address) ? sizeof(result_ptr->sc_address)-1: sca_len);
        result_ptr->cdma_short_message_len = 0;
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}
static mipc_api_result_enum mipc_sms_config_ind_decode(mipc_msg_t *msg_cnf_ptr, mipc_sms_configuration_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sms_configuration_struct));
    } else {
        return result;
    }
    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    do {
        result_ptr->result_code = (mipc_result_enum)mipc_msg_get_val_uint32(msg_cnf_ptr, MIPC_T_RESULT, 0xFFFFFFFF);
        if (0xFFFFFFFF == result_ptr->result_code) break;
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        //but as debug mode, we show all the infos
        //if(MIPC_RESULT_SUCCESS != result_ptr->result_code) { result = MIPC_API_RESULT_SUCCESS; break; }
        result_ptr->sms_storage_state = (mipc_sms_storage_state_enum)mipc_msg_get_val_uint8(msg_cnf_ptr, MIPC_SMS_CFG_IND_T_SMS_STATE, 0xFF);
        if (0xFF == result_ptr->sms_storage_state) break;
        result_ptr->format = (mipc_sms_format_enum)mipc_msg_get_val_uint8(msg_cnf_ptr, MIPC_SMS_CFG_IND_T_FORMAT, 0xFF);
        if (0xFF == result_ptr->format) break;
        result_ptr->max_messages = mipc_msg_get_val_uint16(msg_cnf_ptr, MIPC_SMS_CFG_IND_T_MAX_MESSAGE, 0xFFFF);
        if (0xFFFF == result_ptr->max_messages) break;
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SMS_CFG_IND_T_SCA, NULL);
        if (NULL == val_ptr) break;
        MEMCPY(result_ptr->sc_address, val_ptr, 32);
        result_ptr->cdma_short_message_len = 0;
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

//callback function for mipc_msg_async_api(), inculde <customer defined callback> & <decode function to translate MIPC to struct>
//cb:customer defined callback; cb_priv_ptr: prefer just cb from customer (or can combine other somethings in mipc_sms_config_req())
static void mipc_sms_config_set_cb(mipc_msg_t *msg_ptr, MIPC_API_CB cb, void *cb_priv_ptr)
{
    mipc_sms_configuration_struct result;
    mipc_sim_ps_id_enum sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;

    mipc_sms_config_set_cnf_decode(msg_ptr, &result);
    cb(sim_ps_id, &result, cb_priv_ptr);
}
static void mipc_sms_config_get_cb(mipc_msg_t *msg_ptr, MIPC_API_CB cb, void *cb_priv_ptr)
{
    mipc_sms_configuration_struct result;
    mipc_sim_ps_id_enum sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;

    mipc_sms_config_get_cnf_decode(msg_ptr, &result);
    cb(sim_ps_id, &result, cb_priv_ptr);
}
static void mipc_sms_config_ind_cb(mipc_msg_t *msg_ptr, MIPC_API_CB cb, void *cb_priv_ptr)
{
    mipc_sms_configuration_struct result;
    mipc_sim_ps_id_enum sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;

    mipc_sms_config_ind_decode(msg_ptr, &result);
    cb(sim_ps_id, &result, cb_priv_ptr);
}

//config_set used for sync & async
//if NULL!=cb, we use async function; else: we use sync function.
static mipc_api_result_enum mipc_sms_config_set(MIPC_SMS_CONFIGURATION_SET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sms_configuration_struct *result_ptr, char *sc_address_ptr, mipc_sms_format_enum format)
{
    mipc_msg_t *msg_req_ptr = NULL;
    mipc_msg_t *msg_cnf_ptr = NULL;

    if (sc_address_ptr && strlen(sc_address_ptr) > 20) {
        return MIPC_API_RESULT_FAIL;
    }
    msg_req_ptr = mipc_msg_init(MIPC_SMS_CFG_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    if (sc_address_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SMS_CFG_REQ_T_SET_SCA, MIPC_MAX_SMS_SCA_LEN, sc_address_ptr);
    }
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SMS_CFG_REQ_T_FORMAT, format);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SMS_CFG_REQ_T_GET_SMS_STATE, 1);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SMS_CFG_REQ_T_GET_STORE_STATUS, 1);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SMS_CFG_REQ_T_GET_SCA, 1);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SMS_CFG_REQ_T_PREFER_ACK, 1);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SMS_CFG_REQ_T_PREFER_STORAGE, 2);

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sms_config_set_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        mipc_api_result_enum ret;
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sms_config_set_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

static mipc_api_result_enum mipc_sms_config_set_null(MIPC_SMS_CONFIGURATION_SET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sms_configuration_struct *result_ptr, char *sc_address_ptr, mipc_sms_format_enum format)
{
    mipc_msg_t *msg_req_ptr = NULL;
    mipc_msg_t *msg_cnf_ptr = NULL;

    if (sc_address_ptr && strlen(sc_address_ptr) > 20) {
        return MIPC_API_RESULT_FAIL;
    }
    msg_req_ptr = mipc_msg_init(MIPC_SMS_CFG_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    if (sc_address_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SMS_CFG_REQ_T_SET_SCA, MIPC_MAX_SMS_SCA_LEN, sc_address_ptr);
    }

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sms_config_set_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        mipc_api_result_enum ret;
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sms_config_set_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}


//config_get used for sync & async
//if NULL!=cb, we use async function; else: we use sync function.
static mipc_api_result_enum mipc_sms_config_get(MIPC_SMS_CONFIGURATION_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sms_configuration_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SMS_CFG_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SMS_CFG_REQ_T_FORMAT, MIPC_SMS_FORMAT_QUERY);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SMS_CFG_REQ_T_GET_SMS_STATE, 1);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SMS_CFG_REQ_T_GET_STORE_STATUS, 1);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SMS_CFG_REQ_T_GET_SCA, 1);

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sms_config_get_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sms_config_set_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}
//decode fuction
static mipc_api_result_enum mipc_sms_send_decode(mipc_msg_t *msg_cnf_ptr, mipc_sms_send_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sms_send_struct));
    } else {
        return result;
    }

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    do {
        result_ptr->result_code = (mipc_result_enum)mipc_msg_get_val_uint32(msg_cnf_ptr, MIPC_T_RESULT, 0xFFFFFFFF);
        if (0xFFFFFFFF == result_ptr->result_code) break;
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        //but as debug mode, we show all the infos
        //if(MIPC_RESULT_SUCCESS != result_ptr->result_code) { result = MIPC_API_RESULT_SUCCESS; break; }
        if (MIPC_RESULT_SUCCESS == result_ptr->result_code) {
            val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SMS_SEND_CNF_T_MR, NULL);
            if (NULL == val_ptr) break;
            result_ptr->message_reference = *((uint8_t*)val_ptr);
        }
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

//callback function for mipc_msg_async_api(), inculde <customer defined callback> & <decode function to translate MIPC to struct>
//cb:customer defined callback; cb_priv_ptr: prefer just cb from customer
static void mipc_sms_send_cb(mipc_msg_t *msg_ptr, MIPC_API_CB cb, void *cb_priv_ptr)
{
    mipc_sms_send_struct result;
    mipc_sim_ps_id_enum sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;

    mipc_sms_send_decode(msg_ptr, &result);
    cb(sim_ps_id, &result, cb_priv_ptr);
}

//send used for sync & async
//if NULL!=cb, we use async function; else: we use sync function.
static mipc_api_result_enum mipc_sms_send(MIPC_SMS_SEND_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sms_send_struct *result_ptr, uint8_t pdu_len, uint8_t *pdu_ptr, mipc_sms_format_enum format, uint8_t more_msg_to_send)
{
    mipc_msg_t *msg_req_ptr = NULL;
    mipc_msg_t *msg_cnf_ptr = NULL;

    if (NULL == pdu_ptr || 256 < pdu_len + 1 + pdu_ptr[0]) {
        return MIPC_API_RESULT_FAIL;
    }
    msg_req_ptr = mipc_msg_init(MIPC_SMS_SEND_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SMS_SEND_REQ_T_FORMAT, format);
    mipc_msg_add_tlv(msg_req_ptr, MIPC_SMS_SEND_REQ_T_PDU, pdu_len + 1 + pdu_ptr[0], pdu_ptr);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SMS_SEND_REQ_T_PDU_LEN, pdu_len);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SMS_SEND_REQ_T_MORE_MSG_TO_SEND, more_msg_to_send);
    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sms_send_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        mipc_api_result_enum ret;
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sms_send_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

//decode fuction
static mipc_api_result_enum mipc_sms_read_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sms_read_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;
    uint16_t count = 0;

    if (result_ptr) {
        count = result_ptr->sms_pdu_list_count;
        MEMSET(result_ptr, 0, sizeof(mipc_sms_read_struct) + result_ptr->sms_pdu_list_count * sizeof(mipc_sms_pdu_struct4));
        result_ptr->sms_pdu_list_count = count;
    } else {
        return result;
    }
    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    do {
        result_ptr->result_code = (mipc_result_enum)mipc_msg_get_val_uint32(msg_cnf_ptr, MIPC_T_RESULT, 0xFFFFFFFF);
        if (0xFFFFFFFF == result_ptr->result_code) break;
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        //but as debug mode, we show all the infos
        //if(MIPC_RESULT_SUCCESS != result_ptr->result_code) { result = MIPC_API_RESULT_SUCCESS; break; }
        count = mipc_msg_get_val_uint16(msg_cnf_ptr, MIPC_SMS_READ_CNF_T_PDU_COUNT, 0xFFFF);
        if (0xFFFF == count) break;
        if (count < result_ptr->sms_pdu_list_count) {
            result_ptr->sms_pdu_list_count = count;
        }
        if (result_ptr->sms_pdu_list_count > 0) {
            result_ptr->format = (mipc_sms_format_enum)mipc_msg_get_val_uint8(msg_cnf_ptr, MIPC_SMS_READ_CNF_T_FORMAT, 0xFF);
            if (0xFF == result_ptr->format) break;
            val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SMS_READ_CNF_T_PDU_LIST, NULL);
            if (NULL == val_ptr) break;
            MEMCPY(result_ptr->sms_pdu_list, val_ptr, (result_ptr->sms_pdu_list_count)*sizeof(mipc_sms_pdu_struct4));
        }
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

//callback function for mipc_msg_async_api(), inculde <customer defined callback> & <decode function to translate MIPC to struct>
//cb:customer defined callback; cb_priv_ptr: prefer just cb from customer
static void mipc_sms_read_req_cb(mipc_msg_t *msg_ptr, MIPC_API_CB cb, void *cb_priv_ptr)
{
    uint32_t size = sizeof(mipc_sms_read_struct) + 10 * sizeof(mipc_sms_pdu_struct4);
    mipc_sim_ps_id_enum sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;
    mipc_sms_read_struct* result_ptr = (mipc_sms_read_struct*)ALLOC(size);
    MEMSET(result_ptr, 0, size);
    result_ptr->sms_pdu_list_count = 10;
    mipc_sms_read_cnf_decode(msg_ptr, result_ptr);
    cb(sim_ps_id, result_ptr, cb_priv_ptr);
    FREE(result_ptr);
}

//read used for sync & async
//if NULL!=cb, we use async function; else: we use sync function.
static mipc_api_result_enum mipc_sms_read(MIPC_SMS_READ_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sms_read_struct *result_ptr, mipc_sms_flag_enum flag, uint16_t message_index, mipc_sms_format_enum format)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SMS_READ_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SMS_READ_REQ_T_FLAG, flag);
    mipc_msg_add_tlv_uint16(msg_req_ptr, MIPC_SMS_READ_REQ_T_MESSAGE_INDEX, message_index);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SMS_READ_REQ_T_FORMAT, format);

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sms_read_req_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sms_read_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}


//decode fuction
static mipc_api_result_enum mipc_sms_new_sms_ind_decode(mipc_msg_t *msg_cnf_ptr, mipc_sms_read_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;
    uint16_t count = 0;

    if (result_ptr) {
        count = result_ptr->sms_pdu_list_count;
        MEMSET(result_ptr, 0, sizeof(mipc_sms_read_struct) + result_ptr->sms_pdu_list_count * sizeof(mipc_sms_pdu_struct4));
        result_ptr->sms_pdu_list_count = count;
    } else {
        return result;
    }

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    do {
        result_ptr->result_code = (mipc_result_enum)mipc_msg_get_val_uint32(msg_cnf_ptr, MIPC_T_RESULT, 0xFFFFFFFF);
        if (0xFFFFFFFF == result_ptr->result_code) break;
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        //but as debug mode, we show all the infos
        //if(MIPC_RESULT_SUCCESS != result_ptr->result_code) { result = MIPC_API_RESULT_SUCCESS; break; }
        count = mipc_msg_get_val_uint16(msg_cnf_ptr, MIPC_SMS_NEW_SMS_IND_T_PDU_COUNT, 0xFFFF);
        if (0xFFFF == count) break;
        if (count < result_ptr->sms_pdu_list_count) {
            result_ptr->sms_pdu_list_count = count;
        }
        if (result_ptr->sms_pdu_list_count > 0) {
            result_ptr->format = (mipc_sms_format_enum)mipc_msg_get_val_uint8(msg_cnf_ptr, MIPC_SMS_NEW_SMS_IND_T_FORMAT, 0xFF);
            if (0xFF == result_ptr->format) break;
            val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SMS_NEW_SMS_IND_T_PDU_LIST, NULL);
            if (NULL == val_ptr) break;
            MEMCPY(result_ptr->sms_pdu_list, val_ptr, (result_ptr->sms_pdu_list_count)*sizeof(mipc_sms_pdu_struct4));
        }
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}
//callback function for mipc_sms_ind_register(), inculde <customer defined callback> & <decode function to translate MIPC to struct>
//cb:customer defined callback; cb_priv_ptr: prefer just cb from customer (or can combine other somethings in mipc_sms_ind_register())
static void mipc_sms_new_sms_ind_cb(mipc_msg_t *msg_ptr, MIPC_API_CB cb, void *cb_priv_ptr)
{
    uint32_t size = sizeof(mipc_sms_read_struct) + 1 * sizeof(mipc_sms_pdu_struct4);
    mipc_sim_ps_id_enum sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;
    mipc_sms_read_struct* result_ptr = (mipc_sms_read_struct*)ALLOC(size);
    MEMSET(result_ptr, 0, size);
    result_ptr->sms_pdu_list_count = 1;
    mipc_sms_new_sms_ind_decode(msg_ptr, result_ptr);
    cb(sim_ps_id, result_ptr, cb_priv_ptr);
    FREE(result_ptr);
}
//decode fuction
static mipc_api_result_enum mipc_sms_delete_decode(mipc_msg_t *msg_cnf_ptr, mipc_sms_delete_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sms_delete_struct));
    } else {
        return result;
    }

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    do {
        result_ptr->result_code = (mipc_result_enum)mipc_msg_get_val_uint32(msg_cnf_ptr, MIPC_T_RESULT, 0xFFFFFFFF);
        if (0xFFFFFFFF == result_ptr->result_code) break;
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

//callback function for mipc_msg_async_api(), inculde <customer defined callback> & <decode function to translate MIPC to struct>
//cb:customer defined callback; cb_priv_ptr: prefer just cb from customer
static void mipc_sms_delete_cb(mipc_msg_t *msg_ptr, MIPC_API_CB cb, void *cb_priv_ptr)
{
    mipc_sms_delete_struct result;
    mipc_sim_ps_id_enum sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;
    MEMSET(&result, 0, sizeof(mipc_sms_delete_struct));
    mipc_sms_delete_decode(msg_ptr, &result);
    cb(sim_ps_id, &result, cb_priv_ptr);
}

//delete used for sync & async
//if NULL!=cb, we use async function; else: we use sync function.
static mipc_api_result_enum mipc_sms_delete(MIPC_SMS_DELETE_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sms_delete_struct *result_ptr, mipc_sms_flag_enum flag, uint16_t message_index)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SMS_DELETE_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SMS_DELETE_REQ_T_FLAG, flag);
    if (message_index > 0) {
	    mipc_msg_add_tlv_uint16(msg_req_ptr, MIPC_SMS_DELETE_REQ_T_MESSAGE_INDEX, message_index);
    }

    mtkLogD(LOG_TAG, "[%s] flag=%d, message_index=%d", __FUNCTION__, flag, message_index);

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sms_delete_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        mipc_msg_t *msg_cnf_ptr;
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sms_delete_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

//decode fuction
static mipc_api_result_enum mipc_sms_store_status_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sms_status_struct*result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sms_status_struct));
    } else {
        return result;
    }

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    do {
        result_ptr->result_code = (mipc_result_enum)mipc_msg_get_val_uint32(msg_cnf_ptr, MIPC_T_RESULT, 0xFFFFFFFF);
        if (0xFFFFFFFF == result_ptr->result_code) break;
        result_ptr->store_flag_btmp = (mipc_sms_store_flag_btmp_enum)mipc_msg_get_val_uint32(msg_cnf_ptr, MIPC_SMS_GET_STORE_STATUS_CNF_T_FLAG, 0);
        result_ptr->message_index = mipc_msg_get_val_uint16(msg_cnf_ptr, MIPC_SMS_GET_STORE_STATUS_CNF_T_MESSAGE_INDEX, 0);
        result_ptr->total = mipc_msg_get_val_uint16(msg_cnf_ptr, MIPC_SMS_GET_STORE_STATUS_CNF_T_MAX_MESSAGE, 0);
        result_ptr->used = mipc_msg_get_val_uint16(msg_cnf_ptr, MIPC_SMS_GET_STORE_STATUS_CNF_T_USED_MESSAGE, 0);
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}
static mipc_api_result_enum mipc_sms_store_status_ind_decode(mipc_msg_t *msg_cnf_ptr, mipc_sms_status_struct*result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sms_status_struct));
    } else {
        return result;
    }
    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    do {
        result_ptr->result_code = (mipc_result_enum)mipc_msg_get_val_uint32(msg_cnf_ptr, MIPC_T_RESULT, 0xFFFFFFFF);
        if (0xFFFFFFFF == result_ptr->result_code) break;
        result_ptr->store_flag_btmp = (mipc_sms_store_flag_btmp_enum)mipc_msg_get_val_uint32(msg_cnf_ptr, MIPC_SMS_STORE_STATUS_IND_T_FLAG, 0);
        if (0 == result_ptr->store_flag_btmp) break;
        result_ptr->message_index = mipc_msg_get_val_uint16(msg_cnf_ptr, MIPC_SMS_STORE_STATUS_IND_T_MESSAGE_INDEX, 0);
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

//callback function for mipc_msg_async_api(), inculde <customer defined callback> & <decode function to translate MIPC to struct>
//cb:customer defined callback; cb_priv_ptr: prefer just cb from customer
static void mipc_sms_store_status_req_cb(mipc_msg_t *msg_ptr, MIPC_API_CB cb, void *cb_priv_ptr)
{
    mipc_sms_status_struct result;
    mipc_sim_ps_id_enum sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;
    MEMSET(&result, 0, sizeof(mipc_sms_status_struct));
    mipc_sms_store_status_cnf_decode(msg_ptr, &result);
    cb(sim_ps_id, &result, cb_priv_ptr);
}
static void mipc_sms_store_status_ind_cb(mipc_msg_t *msg_ptr, MIPC_API_CB cb, void *cb_priv_ptr)
{
    mipc_sms_status_struct result;
    mipc_sim_ps_id_enum sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;
    MEMSET(&result, 0, sizeof(mipc_sms_status_struct));
    mipc_sms_store_status_ind_decode(msg_ptr, &result);
    cb(sim_ps_id, &result, cb_priv_ptr);
}

//get store status used for sync & async
//if NULL!=cb, we use async function; else: we use sync function.
static mipc_api_result_enum mipc_sms_store_status_get(MIPC_SMS_STORE_STATUS_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sms_status_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SMS_GET_STORE_STATUS_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_api_result_enum ret;

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sms_store_status_req_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        mipc_msg_t *msg_cnf_ptr;
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sms_store_status_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

static mipc_api_result_enum mipc_sms_write_decode(mipc_msg_t *msg_cnf_ptr, mipc_sms_write_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sms_write_struct));
    } else {
        return result;
    }

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    do {
        result_ptr->result_code = (mipc_result_enum)mipc_msg_get_val_uint32(msg_cnf_ptr, MIPC_T_RESULT, 0xFFFFFFFF);
        if (0xFFFFFFFF == result_ptr->result_code) break;
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        //but as debug mode, we show all the infos
        //if(MIPC_RESULT_SUCCESS != result_ptr->result_code) { result = MIPC_API_RESULT_SUCCESS; break; }
        if (MIPC_RESULT_SUCCESS == result_ptr->result_code) {
            result_ptr->message_index = mipc_msg_get_val_uint16(msg_cnf_ptr,MIPC_SMS_WRITE_CNF_T_MESSAGE_INDEX,0xffff);
        }
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

//callback function for mipc_msg_async_api(), inculde <customer defined callback> & <decode function to translate MIPC to struct>
//cb:customer defined callback; cb_priv_ptr: prefer just cb from customer
static void mipc_sms_write_cb(mipc_msg_t *msg_ptr, MIPC_API_CB cb, void *cb_priv_ptr)
{
    mipc_sms_write_struct result;
    mipc_sim_ps_id_enum sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;

    mipc_sms_write_decode(msg_ptr, &result);
    cb(sim_ps_id, &result, cb_priv_ptr);
}

//send used for sync & async
//if NULL!=cb, we use async function; else: we use sync function.
//mipc_sms_write(cb, cb_priv_ptr, sim_ps_id, NULL, pdu_len, pdu_ptr, format);
static mipc_api_result_enum mipc_sms_write(MIPC_SMS_WRITE_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sms_write_struct *result_ptr, uint8_t pdu_len, uint8_t *pdu_ptr,mipc_sms_status_enum status, mipc_sms_format_enum format)
{
    mipc_msg_t *msg_req_ptr = NULL;
    mipc_msg_t *msg_cnf_ptr = NULL;

    if (NULL == pdu_ptr || 256 < pdu_len + 1 + pdu_ptr[0]) {
        return MIPC_API_RESULT_FAIL;
    }
    msg_req_ptr = mipc_msg_init(MIPC_SMS_WRITE_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SMS_WRITE_REQ_T_FORMAT, format);
    mipc_msg_add_tlv(msg_req_ptr,MIPC_SMS_WRITE_REQ_T_PDU, pdu_len + 1 + pdu_ptr[0], pdu_ptr);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SMS_WRITE_REQ_T_PDU_LEN, pdu_len);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SMS_WRITE_REQ_T_STATUS, status);
    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sms_write_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        mipc_api_result_enum ret;
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sms_write_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sms_configuration_set_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sms_configuration_struct *result_ptr, char *sc_address_ptr, mipc_sms_format_enum format)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sms_config_set(NULL, NULL, sim_ps_id, result_ptr, sc_address_ptr, format);
}

mipc_api_result_enum mipc_sms_configuration_set_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SMS_CONFIGURATION_SET_CB cb, void *cb_priv_ptr, char *sc_address_ptr, mipc_sms_format_enum format)
{
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sms_config_set(cb, cb_priv_ptr, sim_ps_id, NULL, sc_address_ptr, format);
}

mipc_api_result_enum mipc_sms_configuration_set_async_null(mipc_sim_ps_id_enum sim_ps_id, MIPC_SMS_CONFIGURATION_SET_CB cb, void *cb_priv_ptr, char *sc_address_ptr, mipc_sms_format_enum format)
{
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sms_config_set_null(cb, cb_priv_ptr, sim_ps_id, NULL, sc_address_ptr, format);
}

mipc_api_result_enum mipc_sms_configuration_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sms_configuration_struct *result_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sms_config_get(NULL, NULL, sim_ps_id, result_ptr);
}

mipc_api_result_enum mipc_sms_configuration_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SMS_CONFIGURATION_GET_CB cb, void *cb_priv_ptr)
{
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sms_config_get(cb, cb_priv_ptr, sim_ps_id, NULL);
}

mipc_api_result_enum mipc_sms_configuration_register(mipc_sim_ps_id_enum sim_ps_id, MIPC_SMS_CONFIGURATION_IND_CB cb, void *cb_priv_ptr)
{
    void *callback;
    if (cb) {
        callback = (void *)mipc_sms_config_ind_cb;
    } else {
        callback = NULL;
    }

    if (mipc_msg_register_ind_api((mipc_msg_sim_ps_id_enum)sim_ps_id, MIPC_SMS_CFG_IND, callback, (MIPC_API_CB)cb, cb_priv_ptr) == 0) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        return MIPC_API_RESULT_FAIL;
    }
}

mipc_api_result_enum mipc_sms_read_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sms_read_struct *result_ptr, mipc_sms_flag_enum flag, uint16_t message_index, mipc_sms_format_enum format)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sms_read(NULL, NULL, sim_ps_id, result_ptr, flag, message_index, format);
}

mipc_api_result_enum mipc_sms_read_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SMS_READ_CB cb, void *cb_priv_ptr, mipc_sms_flag_enum flag, uint16_t message_index, mipc_sms_format_enum format)
{
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sms_read(cb, cb_priv_ptr, sim_ps_id, NULL, flag, message_index, format);
}

mipc_api_result_enum mipc_sms_ind_register(mipc_sim_ps_id_enum sim_ps_id, MIPC_SMS_IND_CB cb, void *cb_priv_ptr)
{
    void *callback;
    if (cb) {
        callback = (void *)mipc_sms_new_sms_ind_cb;
    } else {
        callback = NULL;
    }

    if (mipc_msg_register_ind_api((mipc_msg_sim_ps_id_enum)sim_ps_id, MIPC_SMS_NEW_SMS_IND, callback, (MIPC_API_CB)cb, cb_priv_ptr) == 0) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        return MIPC_API_RESULT_FAIL;
    }
}

mipc_api_result_enum mipc_sms_send_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sms_send_struct *result_ptr, uint8_t pdu_len, uint8_t *pdu_ptr, mipc_sms_format_enum format, uint8_t more_msg_to_send)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sms_send(NULL, NULL, sim_ps_id, result_ptr, pdu_len, pdu_ptr, format, more_msg_to_send);
}

mipc_api_result_enum mipc_sms_send_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SMS_SEND_CB cb, void *cb_priv_ptr, uint8_t pdu_len, uint8_t *pdu_ptr, mipc_sms_format_enum format, uint8_t more_msg_to_send)
{
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sms_send(cb, cb_priv_ptr, sim_ps_id, NULL, pdu_len, pdu_ptr, format, more_msg_to_send);
}

mipc_api_result_enum mipc_sms_delete_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sms_delete_struct *result_ptr, mipc_sms_flag_enum flag, uint16_t message_index)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sms_delete(NULL, NULL, sim_ps_id, result_ptr, flag, message_index);
}

mipc_api_result_enum mipc_sms_delete_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SMS_DELETE_CB cb, void *cb_priv_ptr, mipc_sms_flag_enum flag, uint16_t message_index)
{
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sms_delete(cb, cb_priv_ptr, sim_ps_id, NULL, flag, message_index);
}

mipc_api_result_enum mipc_sms_store_status_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sms_status_struct *result_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sms_store_status_get(NULL, NULL, sim_ps_id, result_ptr);
}

mipc_api_result_enum mipc_sms_store_status_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SMS_STORE_STATUS_GET_CB cb, void *cb_priv_ptr)
{
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sms_store_status_get(cb, cb_priv_ptr, sim_ps_id, NULL);
}

mipc_api_result_enum mipc_sms_store_status_register(mipc_sim_ps_id_enum sim_ps_id, MIPC_SMS_STORE_STATUS_IND_CB cb, void *cb_priv_ptr)
{
    void *callback;
    if (cb) {
        callback = (void *)mipc_sms_store_status_ind_cb;
    } else {
        callback = NULL;
    }

    if (mipc_msg_register_ind_api((mipc_msg_sim_ps_id_enum)sim_ps_id, MIPC_SMS_STORE_STATUS_IND, callback, (MIPC_API_CB)cb, cb_priv_ptr) == 0) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        return MIPC_API_RESULT_FAIL;
    }
}

mipc_api_result_enum mipc_sms_write_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SMS_WRITE_CB cb, void *cb_priv_ptr, uint8_t pdu_len, uint8_t *pdu_ptr,mipc_sms_status_enum status, mipc_sms_format_enum format)
{
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sms_write(cb, cb_priv_ptr, sim_ps_id, NULL, pdu_len, pdu_ptr,status, format);
}

uint16_t msg_txid_status = 0;
uint16_t msg_txid_new_sms = 0;

//decode fuction
static mipc_api_result_enum mipc_sms_new_sms_cmd_decode(mipc_msg_t *msg_cnf_ptr, mipc_sms_new_cmd_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;
    uint16_t count = 0;

    if (result_ptr) {
        count = result_ptr->sms_pdu_list_count;
        MEMSET(result_ptr, 0, sizeof(mipc_sms_new_cmd_struct) + result_ptr->sms_pdu_list_count * sizeof(mipc_sms_pdu_struct4));
        result_ptr->sms_pdu_list_count = count;
    } else {
        return result;
    }

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    do {
        #if 0
        result_ptr->result_code = (mipc_result_enum)mipc_msg_get_val_uint32(msg_cnf_ptr, MIPC_T_RESULT, 0xFFFFFFFF);
        if (0xFFFFFFFF == result_ptr->result_code){
            mtkLogD(RFX_LOG_TAG, "enter mipc_sms_new_sms_cmd_decode  result_ptr->result_code=0x%x\n",result_ptr->result_code);
            break;
        }
        #endif
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        //but as debug mode, we show all the infos
        //if(MIPC_RESULT_SUCCESS != result_ptr->result_code) { result = MIPC_API_RESULT_SUCCESS; break; }
        count = mipc_msg_get_val_uint16(msg_cnf_ptr, MIPC_SMS_NEW_SMS_CMD_T_PDU_COUNT, 0xFFFF);
        if (0xFFFF == count) break;
        if (count < result_ptr->sms_pdu_list_count) {
            result_ptr->sms_pdu_list_count = count;
        }
        if (result_ptr->sms_pdu_list_count > 0) {
            result_ptr->format = (mipc_sms_format_enum)mipc_msg_get_val_uint8(msg_cnf_ptr, MIPC_SMS_NEW_SMS_CMD_T_FORMAT, 0xFF);
            if (0xFF == result_ptr->format) break;
            val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SMS_NEW_SMS_CMD_T_PDU_LIST, NULL);
            if (NULL == val_ptr) break;
            MEMCPY(result_ptr->sms_pdu_list, val_ptr, (result_ptr->sms_pdu_list_count)*sizeof(mipc_sms_pdu_struct4));
        }
        msg_txid_new_sms = msg_cnf_ptr->hdr.msg_txid;
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}
//callback function for mipc_sms_new_sms_cmd_register(), inculde <customer defined callback> & <decode function to translate MIPC to struct>
//cb:customer defined callback; cb_priv_ptr: prefer just cb from customer (or can combine other somethings in mipc_sms_new_sms_cmd_register())
static void mipc_sms_new_sms_cmd_cb(mipc_msg_t *msg_ptr, MIPC_API_CB cb, void *cb_priv_ptr)
{
    uint32_t size = sizeof(mipc_sms_new_cmd_struct) + 1 * sizeof(mipc_sms_pdu_struct4);
    mipc_sim_ps_id_enum sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;
    mipc_sms_new_cmd_struct* result_ptr = (mipc_sms_new_cmd_struct*)ALLOC(size);
    MEMSET(result_ptr, 0, size);
    result_ptr->sms_pdu_list_count = 1;
    mipc_sms_new_sms_cmd_decode(msg_ptr, result_ptr);

    mtkLogD(LOG_TAG, "[%s] msg_txid=%d", __FUNCTION__, msg_txid_new_sms);

    cb(sim_ps_id, result_ptr, cb_priv_ptr);
    FREE(result_ptr);
}

mipc_api_result_enum mipc_sms_new_sms_cmd_register(mipc_sim_ps_id_enum sim_ps_id, MIPC_SMS_NEW_SMS_CMD_CB cb, void *cb_priv_ptr)
{
    void *callback;
    if (cb) {
        callback = (void *)mipc_sms_new_sms_cmd_cb;
    } else {
        callback = NULL;
    }

    if (mipc_msg_register_cmd_api(MIPC_SMS_NEW_SMS_CMD, callback, (MIPC_API_CB)cb, cb_priv_ptr) == 0) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        return MIPC_API_RESULT_FAIL;
    }
}

mipc_api_result_enum mipc_sms_acknowledge_rsp(
        mipc_sim_ps_id_enum sim_ps_id, uint8_t ack_success, uint8_t cause)
{
    mipc_msg_t *msg_req_ptr = NULL;
    int ret = 0;

    msg_req_ptr = mipc_msg_init_with_txid(MIPC_SMS_NEW_SMS_RSP,
        (mipc_msg_sim_ps_id_enum)sim_ps_id, msg_txid_new_sms);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SMS_NEW_SMS_RSP_T_NEW_SMS_ACK, ack_success);
    if (ack_success == MIPC_NEW_SMS_ACK_RP_ERROR)
        mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SMS_NEW_SMS_RSP_T_CAUSE, cause);

    ret = mipc_msg_rsp(msg_req_ptr);

    mipc_msg_deinit(msg_req_ptr);

    mtkLogD(LOG_TAG, "[%s] msg_txid=%d, ack=%d, ret=%d", __FUNCTION__,
        msg_txid_new_sms, ack_success, ret);

    return ((ret < 0) ? MIPC_API_RESULT_FAIL : MIPC_API_RESULT_SUCCESS);
}

mipc_api_result_enum mipc_sms_new_status_report_rsp(
	mipc_sim_ps_id_enum sim_ps_id, uint8_t ack_success, uint8_t cause)
{
    mipc_msg_t *msg_req_ptr = NULL;
    int ret = 0;

    msg_req_ptr = mipc_msg_init_with_txid(MIPC_SMS_NEW_STATUS_REPORT_RSP,
        (mipc_msg_sim_ps_id_enum)sim_ps_id, msg_txid_status);

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SMS_NEW_STATUS_REPORT_RSP_T_ACK_TYPE, ack_success);
    if (ack_success == MIPC_NEW_SMS_ACK_RP_ERROR)
        mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SMS_NEW_STATUS_REPORT_RSP_T_CAUSE, cause);

    ret = mipc_msg_rsp(msg_req_ptr);

    mipc_msg_deinit(msg_req_ptr);

    mtkLogD(LOG_TAG, "[%s] msg_txid=%d, ack=%d, ret=%d", __FUNCTION__,
        msg_txid_status, ack_success, ret);

    return ((ret < 0) ? MIPC_API_RESULT_FAIL : MIPC_API_RESULT_SUCCESS);
}

static mipc_api_result_enum mipc_sms_new_status_report_cmd_decode(mipc_msg_t *msg_cnf_ptr, mipc_sms_new_status_report_struct *result_ptr)
{
    uint8_t* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;
    uint16_t pdu_len = 0;

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sms_new_status_report_struct));
    } else {
        return result;
    }

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    do {
    //val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SMS_NEW_STATUS_REPORT_CMD_T_PDU, NULL);
    val_ptr = mipc_sms_new_status_report_ind_get_pdu(msg_cnf_ptr,&pdu_len);
    if (NULL == val_ptr) break;
    MEMCPY(result_ptr->pdu, val_ptr, 256);//?
    result_ptr->pdu_len = pdu_len;
    msg_txid_status = msg_cnf_ptr->hdr.msg_txid;
    result = MIPC_API_RESULT_SUCCESS;
    } while (0);
    return result;
}

//callback function for mipc_sms_new_status_report_cmd_register(), inculde <customer defined callback> & <decode function to translate MIPC to struct>
//cb:customer defined callback; cb_priv_ptr: prefer just cb from customer (or can combine other somethings in mipc_sms_new_sms_cmd_register())
static void mipc_sms_new_status_report_cmd_cb(mipc_msg_t *msg_ptr, MIPC_API_CB cb, void *cb_priv_ptr)
{
    mipc_sms_new_status_report_struct result;
    mipc_sim_ps_id_enum sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;
    mipc_sms_new_status_report_cmd_decode(msg_ptr, &result);

    mtkLogD(LOG_TAG, "[%s] msg_txid=%d", __FUNCTION__, msg_txid_status);

    cb(sim_ps_id, &result, cb_priv_ptr);
}


mipc_api_result_enum mipc_sms_new_status_report_cmd_register(mipc_sim_ps_id_enum sim_ps_id, MIPC_SMS_NEW_STATUS_REPORT_CMD_CB cb, void *cb_priv_ptr)
{
    void *callback;
    if (cb) {
        callback = (void *)mipc_sms_new_status_report_cmd_cb;
    } else {
        callback = NULL;
    }

    if (mipc_msg_register_cmd_api(MIPC_SMS_NEW_STATUS_REPORT_CMD, callback, (MIPC_API_CB)cb, cb_priv_ptr) == 0) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        return MIPC_API_RESULT_FAIL;
    }
}

static mipc_api_result_enum mipc_set_host_mem_avaiable_decode(mipc_msg_t *msg_cnf_ptr, mipc_set_host_mem_avaiable_struct *result_ptr) {
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        result_ptr->result_code = (mipc_result_enum)mipc_msg_get_val_uint32(msg_cnf_ptr, MIPC_T_RESULT, 0xFFFFFFFF);
        if (0xFFFFFFFF == result_ptr->result_code) break;

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_set_host_mem_avaiable_cb(mipc_msg_t *msg_ptr, MIPC_SET_HOST_MEM_AVAIABLE_CB cb, void *cb_priv_ptr) {
    mipc_set_host_mem_avaiable_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_set_host_mem_avaiable_struct));
    mipc_set_host_mem_avaiable_decode(msg_ptr, &result_ptr);
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
}

static mipc_api_result_enum mipc_set_host_mem_avaiable(MIPC_SET_HOST_MEM_AVAIABLE_CB cb,
        void *cb_priv_ptr,
        mipc_sim_ps_id_enum sim_ps_id,
        uint8_t avaiable,
        mipc_set_host_mem_avaiable_struct *result_ptr) {
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SMS_CFG_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SMS_CFG_REQ_T_SET_HOST_MEM_AVAILABLE, avaiable);

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_set_host_mem_avaiable_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_set_host_mem_avaiable_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_set_host_mem_avaiable_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_set_host_mem_avaiable_struct *result_ptr,
                 uint8_t avaiable) {
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_set_host_mem_avaiable( NULL, NULL, sim_ps_id, avaiable, result_ptr);
}

mipc_api_result_enum mipc_set_host_mem_avaiable_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SET_HOST_MEM_AVAIABLE_CB cb, void *cb_priv_ptr,
        uint8_t avaiable) {
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_set_host_mem_avaiable(cb, cb_priv_ptr, sim_ps_id, avaiable, NULL);
}

static mipc_api_result_enum mipc_sms_get_cbm_cfg_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sms_cbm_get_cfg_struct *result_ptr) {
    void* val_ptr;
    uint16_t val_len = 0;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        result_ptr->result_code = (mipc_result_enum)mipc_msg_get_val_uint32(msg_cnf_ptr, MIPC_T_RESULT, 0xFFFFFFFF);
        mtkLogD(LOG_TAG, "[%s] result=%d", __FUNCTION__, result_ptr->result_code);
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) break;

        // Get channel list by range type
        result_ptr->channel_range_num = mipc_msg_get_tlv_num(msg_cnf_ptr, MIPC_SMS_CBM_CFG_CNF_T_MSG_ID_RANGE);
        mtkLogD(LOG_TAG, "[%s] channel_range_num=%d", __FUNCTION__, result_ptr->channel_range_num);
        if (result_ptr->channel_range_num > 30) break;
        for (int i = 0; i < result_ptr->channel_range_num; i++) {
            result_ptr->channel_range[i] = mipc_msg_get_idx_uint32(msg_cnf_ptr, MIPC_SMS_CBM_CFG_CNF_T_MSG_ID_RANGE, i, 0);
            mtkLogD(LOG_TAG, "[%s] channel_range[%d]=%d", __FUNCTION__, i, result_ptr->channel_range[i]);
        }

        // Get channel list by single type
        result_ptr->channel_single_num = mipc_msg_get_tlv_num(msg_cnf_ptr, MIPC_SMS_CBM_CFG_CNF_T_MSG_ID_SINGLE);
        mtkLogD(LOG_TAG, "[%s] channel_single_num=%d", __FUNCTION__, result_ptr->channel_single_num);
        if (result_ptr->channel_single_num > 60) break;
        for (int i = 0; i < result_ptr->channel_single_num; i++) {
            result_ptr->channel_single[i] = mipc_msg_get_idx_uint16(msg_cnf_ptr, MIPC_SMS_CBM_CFG_CNF_T_MSG_ID_SINGLE, i, 0);
            mtkLogD(LOG_TAG, "[%s] channel_single[%d]=%d", __FUNCTION__, i, result_ptr->channel_single[i]);
        }

        // Get language list by range type
        result_ptr->dcs_range_num = mipc_msg_get_tlv_num(msg_cnf_ptr, MIPC_SMS_CBM_CFG_CNF_T_DCS_RANGE);
        mtkLogD(LOG_TAG, "[%s] dcs_range_num=%d", __FUNCTION__, result_ptr->dcs_range_num);
        if (result_ptr->dcs_range_num > 30) break;
        for (int i = 0; i < result_ptr->dcs_range_num; i++) {
            result_ptr->dcs_range[i] = mipc_msg_get_idx_uint16(msg_cnf_ptr, MIPC_SMS_CBM_CFG_CNF_T_DCS_RANGE, i, 0);
            mtkLogD(LOG_TAG, "[%s] dcs_range[%d]=%d", __FUNCTION__, i, result_ptr->dcs_range[i]);
        }

        // Get language list by single type
        result_ptr->dcs_single_num = mipc_msg_get_tlv_num(msg_cnf_ptr, MIPC_SMS_CBM_CFG_CNF_T_DCS_SINGLE);
        mtkLogD(LOG_TAG, "[%s] dcs_single_num=%d", __FUNCTION__, result_ptr->dcs_single_num);
        if (result_ptr->dcs_single_num > 60) break;
        for (int i = 0; i < result_ptr->dcs_single_num; i++) {
            result_ptr->dcs_single[i] = mipc_msg_get_idx_uint8(msg_cnf_ptr, MIPC_SMS_CBM_CFG_CNF_T_DCS_SINGLE, i, 0);
            mtkLogD(LOG_TAG, "[%s] dcs_single[%d]=%d", __FUNCTION__, i, result_ptr->dcs_single[i]);
        }

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sms_get_cbm_cfg_cb(mipc_msg_t *msg_ptr, MIPC_SMS_CBM_GET_CFG_CB cb, void *cb_priv_ptr) {
    mipc_sms_cbm_get_cfg_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_sms_cbm_get_cfg_struct));
    mipc_sms_get_cbm_cfg_cnf_decode(msg_ptr, &result_ptr);
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
}

static mipc_api_result_enum mipc_sms_get_cbm_cfg(MIPC_SMS_CBM_GET_CFG_CB cb,
        void *cb_priv_ptr,
        mipc_sim_ps_id_enum sim_ps_id,
        mipc_sms_cb_query_mode_enum query_type,
        mipc_sms_cbm_get_cfg_struct *result_ptr) {
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SMS_CBM_CFG_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mtkLogD(LOG_TAG, "[%s] query_type=%d", __FUNCTION__, query_type);

    if (query_type == MIPC_SMS_CB_QUERY_CHANNEL) {
        mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SMS_CBM_CFG_REQ_T_MSG_ID_CFG_TYPE, MIPC_SMS_CBM_CFG_TYPE_QUERY);
    } else {
        mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SMS_CBM_CFG_REQ_T_DCS_CFG_TYPE, MIPC_SMS_CBM_CFG_TYPE_QUERY);
    }

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sms_get_cbm_cfg_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sms_get_cbm_cfg_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sms_get_cbm_cfg_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sms_cbm_get_cfg_struct *result_ptr,
        mipc_sms_cb_query_mode_enum query_type) {
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sms_get_cbm_cfg( NULL, NULL, sim_ps_id, query_type, result_ptr);
}

mipc_api_result_enum mipc_sms_get_cbm_cfg_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SMS_CBM_GET_CFG_CB cb, void *cb_priv_ptr,
        mipc_sms_cb_query_mode_enum query_type) {
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }

    return mipc_sms_get_cbm_cfg(cb, cb_priv_ptr, sim_ps_id, query_type, NULL);
}

static mipc_api_result_enum mipc_sms_set_cbm_cfg_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_sms_cbm_set_cfg_struct *result_ptr) {
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        result_ptr->result_code = (mipc_result_enum)mipc_msg_get_val_uint32(msg_cnf_ptr, MIPC_T_RESULT, 0xFFFFFFFF);
        mtkLogD(LOG_TAG, "[%s] result=%d", __FUNCTION__, result_ptr->result_code);
        if (0xFFFFFFFF == result_ptr->result_code) break;

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sms_set_cbm_cfg_cb(mipc_msg_t *msg_ptr, MIPC_SMS_CBM_SET_CFG_CB cb, void *cb_priv_ptr) {
    mipc_sms_cbm_set_cfg_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_sms_cbm_set_cfg_struct));
    mipc_sms_set_cbm_cfg_cnf_decode(msg_ptr, &result_ptr);
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
}

static mipc_api_result_enum mipc_sms_set_cbm_cfg(MIPC_SMS_CBM_SET_CFG_CB cb,
        void *cb_priv_ptr,
        mipc_sim_ps_id_enum sim_ps_id,
        mipc_sms_cbm_cfg_type_const_enum cfg_type,
        uint16_t channel_range_num,
        uint32_t *channel_range,
        uint16_t channel_single_num,
        uint16_t *channel_single,
        uint16_t dcs_range_num,
        uint16_t *dcs_range,
        uint16_t dcs_single_num,
        uint8_t *dcs_single,
        uint16_t cbm_type,
        mipc_sms_cbm_set_cfg_struct *result_ptr) {
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SMS_CBM_CFG_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mtkLogD(LOG_TAG, "[%s] cfg_type=%d, channel num=(%d, %d), dcs num=(%d, %d), cbm_type=%d",
            __FUNCTION__, cfg_type, channel_range_num, channel_single_num, dcs_range_num, dcs_single_num, cbm_type);

    // Add for channel list
    if (channel_range_num > 0 || channel_single_num > 0) {
        mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SMS_CBM_CFG_REQ_T_MSG_ID_CFG_TYPE, cfg_type);

        if (channel_range_num > 0 && channel_range != NULL) {
            mipc_msg_tlv_array_t *a_ptr;
            a_ptr = mipc_msg_add_tlv_array(msg_req_ptr, MIPC_SMS_CBM_CFG_REQ_T_MSG_ID_RANGE, channel_range_num);
            for(int i = 0; i < channel_range_num ; i++) {
                mipc_msg_add_idx_uint32(msg_req_ptr, a_ptr, i, channel_range[i]);
                mtkLogD(LOG_TAG, "[%s] add channel_range[%d]=%d", __FUNCTION__, i, channel_range[i]);
            }
        }

        if (channel_single_num > 0 && channel_single != NULL) {
            mipc_msg_tlv_array_t *a_ptr;
            a_ptr = mipc_msg_add_tlv_array(msg_req_ptr, MIPC_SMS_CBM_CFG_REQ_T_MSG_ID_SINGLE, channel_single_num);
            for(int i = 0; i < channel_single_num ; i++) {
                mipc_msg_add_idx_uint16(msg_req_ptr, a_ptr, i, channel_single[i]);
                mtkLogD(LOG_TAG, "[%s] add channel_single[%d]=%d", __FUNCTION__, i, channel_single[i]);
            }
        }
    }

    // Add for language list
    if (dcs_range_num > 0 || dcs_single_num > 0) {
        mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SMS_CBM_CFG_REQ_T_DCS_CFG_TYPE, cfg_type);

        if (dcs_range_num > 0 && dcs_range_num != NULL) {
            mipc_msg_tlv_array_t *a_ptr;
            a_ptr = mipc_msg_add_tlv_array(msg_req_ptr, MIPC_SMS_CBM_CFG_REQ_T_DCS_RANGE, dcs_range_num);
            for(int i = 0; i < dcs_range_num ; i++) {
                mipc_msg_add_idx_uint16(msg_req_ptr, a_ptr, i, dcs_range[i]);
                mtkLogD(LOG_TAG, "[%s] add dcs_range[%d]=%d", __FUNCTION__, i, dcs_range[i]);
            }
        }

        if (dcs_single_num > 0 && dcs_single_num != NULL) {
            mipc_msg_tlv_array_t *a_ptr;
            a_ptr = mipc_msg_add_tlv_array(msg_req_ptr, MIPC_SMS_CBM_CFG_REQ_T_DCS_SINGLE, dcs_single_num);
            for(int i = 0; i < dcs_single_num ; i++) {
                mipc_msg_add_idx_uint8(msg_req_ptr, a_ptr, i, dcs_single[i]);
                mtkLogD(LOG_TAG, "[%s] add dcs_single[%d]=%d", __FUNCTION__, i, dcs_single[i]);
            }
        }
    }

    // cfg_type is none means this is a activiation request
    if (cfg_type == mipc_sms_cbm_cfg_type_const_NONE) {
        mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_SMS_CBM_CFG_REQ_T_OPEN_CBM_TYPE, cbm_type);
    }

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sms_set_cbm_cfg_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sms_set_cbm_cfg_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sms_set_cbm_cfg_sync(
        mipc_sim_ps_id_enum sim_ps_id, mipc_sms_cbm_set_cfg_struct *result_ptr,
        mipc_sms_cbm_cfg_type_const_enum cfg_type,
        uint16_t channel_range_num,
        uint32_t *channel_range,
        uint16_t channel_single_num,
        uint16_t *channel_single,
        uint16_t dcs_range_num,
        uint16_t *dcs_range,
        uint16_t dcs_single_num,
        uint8_t *dcs_single,
        uint16_t cbm_type) {
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }

    return mipc_sms_set_cbm_cfg(NULL, NULL, sim_ps_id, cfg_type,
            channel_range_num, channel_range,
            channel_single_num, channel_single,
            dcs_range_num, dcs_range,
            dcs_single_num, dcs_single,
            cbm_type,
            result_ptr);
}

mipc_api_result_enum mipc_sms_set_cbm_cfg_async(
        mipc_sim_ps_id_enum sim_ps_id, MIPC_SMS_CBM_SET_CFG_CB cb, void *cb_priv_ptr,
        mipc_sms_cbm_cfg_type_const_enum cfg_type,
        uint16_t channel_range_num,
        uint32_t *channel_range,
        uint16_t channel_single_num,
        uint16_t *channel_single,
        uint16_t dcs_range_num,
        uint16_t *dcs_range,
        uint16_t dcs_single_num,
        uint8_t *dcs_single,
        uint16_t cbm_type) {
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }

    return mipc_sms_set_cbm_cfg(cb, cb_priv_ptr, sim_ps_id, cfg_type,
            channel_range_num, channel_range,
            channel_single_num, channel_single,
            dcs_range_num, dcs_range,
            dcs_single_num, dcs_single,
            cbm_type,
            NULL);
}


static mipc_api_result_enum mipc_sms_new_cbm_ind_decode(mipc_msg_t *msg_cnf_ptr, mipc_sms_new_cbm_ind_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sms_new_cbm_ind_struct));
    } else {
        return result;
    }
    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    do {
        result_ptr->result_code = (mipc_result_enum)mipc_msg_get_val_uint32(msg_cnf_ptr, MIPC_T_RESULT, 0xFFFFFFFF);
        if (0xFFFFFFFF == result_ptr->result_code) break;
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        //but as debug mode, we show all the infos
        //if(MIPC_RESULT_SUCCESS != result_ptr->result_code) { result = MIPC_API_RESULT_SUCCESS; break; }
        result_ptr->cbm_type = (mipc_sms_cbm_type_const_enum)mipc_msg_get_val_uint32(msg_cnf_ptr, MIPC_SMS_NEW_CBM_IND_T_CBM_TYPE, 0xFFFFFFFF);
        //if (0xFFFFFFFF == result_ptr->cbm_type) break;
        result_ptr->warning_type = mipc_msg_get_val_uint16(msg_cnf_ptr, MIPC_SMS_NEW_CBM_IND_T_WARNING_TYPE, 0xFFFF);
        //if (0xFFFF == result_ptr->warning_type) break;
        result_ptr->message_id= mipc_msg_get_val_uint16(msg_cnf_ptr, MIPC_SMS_NEW_CBM_IND_T_MESSAGE_ID, 0xFFFF);
        //if (0xFFFF == result_ptr->message_id) break;
        result_ptr->serial_number= mipc_msg_get_val_uint16(msg_cnf_ptr, MIPC_SMS_NEW_CBM_IND_T_SERIAL_NUMBER, 0xFFFF);
        //if (0xFFFF == result_ptr->serial_number) break;
        result_ptr->dcs= mipc_msg_get_val_uint8(msg_cnf_ptr, MIPC_SMS_NEW_CBM_IND_T_DCS, 0xFF);
        //if (0xFF == result_ptr->dcs) break;
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SMS_NEW_CBM_IND_T_DATA, NULL);
        if (NULL != val_ptr)
            MEMCPY(result_ptr->data, val_ptr, 256);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SMS_NEW_CBM_IND_T_SECUR_INFO, NULL);
        if (NULL != val_ptr)
            MEMCPY(result_ptr->secur_info, val_ptr, 256);

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_sms_new_cbm_ind_cb(mipc_msg_t *msg_ptr, MIPC_API_CB cb, void *cb_priv_ptr)
{
    uint32_t size = sizeof(mipc_sms_new_cbm_ind_struct);
    mipc_sim_ps_id_enum sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;
    mipc_sms_new_cbm_ind_struct* result_ptr = (mipc_sms_new_cbm_ind_struct*)ALLOC(size);
    MEMSET(result_ptr, 0, size);
    if (mipc_sms_new_cbm_ind_decode(msg_ptr, result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb(sim_ps_id, result_ptr, cb_priv_ptr);
    }
    FREE(result_ptr);
}

mipc_api_result_enum mipc_sms_new_cbm_ind_register(mipc_sim_ps_id_enum sim_ps_id, MIPC_SMS_NEW_CBM_IND_CB cb, void *cb_priv_ptr)
{
    void *callback;
    if (cb) {
        callback = (void *)mipc_sms_new_cbm_ind_cb;
    } else {
        callback = NULL;
    }

    if (mipc_msg_register_ind_api((mipc_msg_sim_ps_id_enum)sim_ps_id, MIPC_SMS_NEW_CBM_IND, callback, (MIPC_API_CB)cb, cb_priv_ptr) == 0) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        return MIPC_API_RESULT_FAIL;
    }
}

