//SPDX-License-Identifier: MediaTekProprietary
/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  Copyright (c) [2020], MediaTek Inc. All rights reserved.
*  This software/firmware and related documentation ("MediaTek Software") are
*  protected under relevant copyright laws.
*
*  The information contained herein is confidential and proprietary to
*  MediaTek Inc. and/or its licensors. Except as otherwise provided in the
*  applicable licensing terms with MediaTek Inc. and/or its licensors, any
*  reproduction, modification, use or disclosure of MediaTek Software, and
*  information contained herein, in whole or in part, shall be strictly
*  prohibited.
*****************************************************************************/

#include "mipc_msg.h"
#include "mipc_msg_host.h"
#include "mipc_sys_api.h"
#include "mipc_nw_api.h"

#include "mtk_log.h"
#define LOG_TAG "MIPC_SYS_API"

/*lei add for reset modem 2022/9/28*/
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
/*lei add for reset modem 2022/9/28*/

mipc_api_result_enum mipc_sys_init(const char *client_name_ptr)
{
    if (mipc_init(client_name_ptr) == 0) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        return MIPC_API_RESULT_FAIL;
    }
}

mipc_api_result_enum mipc_sys_deinit()
{
    mipc_deinit();
    return MIPC_API_RESULT_SUCCESS;
}


//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_at_cnf(mipc_msg_t *msg_ptr, mipc_sys_at_struct *result_ptr)
{
    uint32_t *t_result_ptr;
    char *t_atcmd_ptr;
    uint16_t t_atcmd_len;
    uint8_t api_error = 1;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            result_ptr->result_code = MIPC_RESULT_SUCCESS;
            if ((t_atcmd_ptr = (char *)mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_AT_CNF_T_ATCMD, &t_atcmd_len)) == NULL) break;
            memcpy(result_ptr->data, t_atcmd_ptr, (t_atcmd_len > sizeof(result_ptr->data)) ? sizeof(result_ptr->data) : t_atcmd_len);
        } else {
            result_ptr->result_code = MIPC_RESULT_FAILURE;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_at_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_AT_CB cb, void *cb_priv_ptr)
{
    mipc_sys_at_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_sys_at_struct));
    mipc_sys_at_cnf(msg_ptr, &result_ptr);

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
}

/*lei add for reset modem 2022/9/29*/
static void response_to_ril_service(int res)
{
    int rt_value=access("/data/tp",F_OK);
    if(rt_value==0)
    {
        mtkLogD(LOG_TAG,"File:%s   exist   rt_value=%d\n","/data/tp",rt_value);
    }
    else
    {
        mtkLogD(LOG_TAG,"File:%s not exist  rt_value=%d \n","/data/tp",rt_value);
        int ret = mkfifo("/data/tp",0644);
        mtkLogD(LOG_TAG,"result ret = %d \n", ret);
    }
    int outfd = open("/data/tp", O_WRONLY);
    
    if(outfd == -1){
        mtkLogD(LOG_TAG,"open");
        return 2;
    }
    char buf[1024] = {0};
    sprintf(buf,"%d",res);
    write(outfd,buf,sizeof(buf));
    usleep(1);
    close(outfd);
}

/*lei add for reset modem 2022/9/29*/

static mipc_api_result_enum mipc_sys_at_req(MIPC_SYS_AT_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_at_struct *result_ptr, const char *atcmd_ptr)
{
    /*lei add for reset modem 2022/9/28*/
    if(!strcmp(atcmd_ptr,"AT+LRSTMD"))
    {

        int res = mipc_reset();
        /*send response to Host/AP*/
        mtkLogD(LOG_TAG, "mipc_reset res is %d\n", res);
        response_to_ril_service(res);
        return MIPC_API_RESULT_SUCCESS;
    }
    /*lei add for reset modem 2022/9/28*/

    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    char *atcmd_final_ptr;
    uint16_t atcmd_final_len = strlen(atcmd_ptr);
    int char_sub = 0x1a;
    int char_esc = 0x1b;
    int is_need_add_CR = 1;
    char *pLine = atcmd_ptr;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_AT_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);

    //SETP2: add paramters (in this case, there is only one TLV parameter)
    mtkLogD(LOG_TAG, "%s Original AT cmd: len=%d, cmd=\"%s\"\n", __FUNCTION__, strlen(atcmd_ptr), atcmd_ptr);

    while(*pLine != '\0') {
        int currChar = (int)*pLine;
        if(char_sub == currChar || char_esc == currChar) {
            is_need_add_CR = 0;
        }
        pLine++;
    }

    if (atcmd_ptr[atcmd_final_len-1] == '\r') {
        is_need_add_CR = 0;
    }

    // add '\r' for all cmd
    // In AT spec, the string need including '\r' but not is the case that is the last sms message finished by Ctrl+Z / ESC
    // In MIPC spec said that the size passing need including '\0'
    if (is_need_add_CR == 1) {
        atcmd_final_len = strlen(atcmd_ptr);
        atcmd_final_ptr = (char *)malloc(atcmd_final_len + 2);  // 1 for '\r', 1 for '\0'
        strncpy(atcmd_final_ptr, atcmd_ptr, atcmd_final_len);
        atcmd_final_ptr[atcmd_final_len] = '\r';
        atcmd_final_ptr[atcmd_final_len + 1] = '\0';
        atcmd_final_len +=2;

        mtkLogD(LOG_TAG, "%s Final AT cmd (with \\r\\0): len=%d, cmd=\"%s\"\n",
            __FUNCTION__, atcmd_final_len, atcmd_final_ptr);

    } else {
        atcmd_final_len = strlen(atcmd_ptr);
        atcmd_final_ptr = (char *)malloc(atcmd_final_len + 1);  // 1 for '\0'
        strncpy(atcmd_final_ptr, atcmd_ptr, atcmd_final_len);
        atcmd_final_ptr[atcmd_final_len] = '\0';
        atcmd_final_len +=1;

        mtkLogD(LOG_TAG, "%s Final AT cmd (with \\0): len=%d, cmd=\"%s\"\n",
            __FUNCTION__, atcmd_final_len, atcmd_final_ptr);
    }
    mipc_msg_add_tlv(msg_req_ptr, MIPC_SYS_AT_REQ_T_ATCMD, atcmd_final_len, atcmd_final_ptr);

    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_at_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);
    free(atcmd_final_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_sys_at_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_at_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_at_struct *result_ptr, const char *atcmd_ptr)
{
    //SETP0: check input
    if (result_ptr == NULL || atcmd_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_at_req(NULL, NULL, sim_ps_id, result_ptr, atcmd_ptr);
}

mipc_api_result_enum mipc_sys_at_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_AT_CB cb, void *cb_priv_ptr, const char *atcmd_ptr)
{
    //SETP0: check input
    if (cb == NULL || atcmd_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_at_req(cb, cb_priv_ptr, sim_ps_id, NULL, atcmd_ptr);
}


//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_at_ind(mipc_msg_t *msg_ptr, mipc_sys_at_struct *result_ptr)
{
    char *t_atcmd_ptr;
    uint16_t t_atcmd_len;
    uint8_t api_error = 1;

    do {
        result_ptr->result_code = MIPC_RESULT_SUCCESS;
        if ((t_atcmd_ptr = (char *)mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_AT_IND_T_ATCMD, &t_atcmd_len)) == NULL) break;
        memcpy(result_ptr->data, t_atcmd_ptr, (t_atcmd_len > sizeof(result_ptr->data)) ? sizeof(result_ptr->data) : t_atcmd_len);
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_at_ind_cb(mipc_msg_t *msg_ptr, MIPC_SYS_AT_IND_CB cb, void *cb_priv_ptr)
{
    mipc_sys_at_struct result_ptr ;

    MEMSET(&result_ptr, 0, sizeof(mipc_sys_at_struct));
    if (mipc_sys_at_ind(msg_ptr, &result_ptr) == MIPC_API_RESULT_SUCCESS) {
        cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
    }
}

mipc_api_result_enum mipc_sys_at_register(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_AT_IND_CB cb, void *cb_priv_ptr)
{
    void *callback;
    if (cb) {
        callback = (void *)mipc_sys_at_ind_cb;
    } else {
        callback = NULL;
    }

    if (mipc_msg_register_ind_api((mipc_msg_sim_ps_id_enum)sim_ps_id, MIPC_SYS_AT_IND, callback, (MIPC_API_CB)cb, cb_priv_ptr) == 0) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        return MIPC_API_RESULT_FAIL;
    }
}
///////////////////////////////////////////////////////////////////////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_reboot_cnf(mipc_msg_t *msg_ptr, mipc_result_enum *result_ptr)
{
    uint32_t *t_result_ptr;
    uint8_t api_error = 1;

    if (msg_ptr == NULL) { //timeout
        if (result_ptr) {
            *result_ptr = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            *result_ptr = MIPC_RESULT_SUCCESS;
        } else {
            *result_ptr = MIPC_RESULT_FAILURE;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        *result_ptr = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_reboot_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_REBOOT_CB cb, void *cb_priv_ptr)
{
    mipc_result_enum result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_result_enum));
    mipc_sys_reboot_cnf(msg_ptr, &result_ptr);

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
}

static mipc_api_result_enum mipc_sys_reboot_req(MIPC_SYS_REBOOT_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_result_enum *result_ptr, mipc_sys_reboot_mode_enum reboot_mode)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_REBOOT_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (in this case, there is only one TLV parameter)
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SYS_REBOOT_REQ_T_MODE, reboot_mode);

    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_reboot_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_sys_reboot_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_reboot_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_result_enum *result_ptr, mipc_sys_reboot_mode_enum reboot_mode)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_reboot_req(NULL, NULL, sim_ps_id, result_ptr, reboot_mode);
}

mipc_api_result_enum mipc_sys_reboot_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_REBOOT_CB cb, void *cb_priv_ptr, mipc_sys_reboot_mode_enum reboot_mode)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_reboot_req(cb, cb_priv_ptr, sim_ps_id, NULL, reboot_mode);
}


static mipc_api_result_enum mipc_sys_mapping_set_cnf(mipc_msg_t *msg_ptr, mipc_sys_mapping_struct *result_ptr)
{
    void* t_result_ptr;
    uint8_t api_error = MIPC_API_RESULT_FAIL;

    if (msg_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) {
            mtkLogD(LOG_TAG, "cur ptr null\n");
            break;
        }
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)t_result_ptr));
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            api_error = MIPC_API_RESULT_SUCCESS;
            break;
        }
        t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_SET_MAPPING_CNF_T_MAPPING_COUNT, NULL);
        if (NULL == t_result_ptr) {
           mtkLogD(LOG_TAG, "mapping_list_count ptr null\n");
            break;
        }
        result_ptr->mapping_list_count = (uint8_t)(*((uint32_t*)t_result_ptr));
        if (result_ptr->mapping_list_count) {
            uint16_t list_len = 0;
            t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_SET_MAPPING_CNF_T_MAPPING_LIST, &list_len);
            if (NULL == t_result_ptr) {
                mtkLogD(LOG_TAG, "mapping_list null\n");
                break;
            }
            MEMCPY(result_ptr->mapping_list, t_result_ptr, list_len);
        }
        api_error = MIPC_API_RESULT_SUCCESS;
    } while (0);

    if (api_error) {
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_mapping_set_config_cb(mipc_msg_t *msg_ptr, MIPC_SYS_MAPPING_SET_CB cb, void *cb_priv_ptr)
{
    mipc_sys_mapping_struct *result_ptr = (mipc_sys_mapping_struct *)ALLOC(sizeof(mipc_sys_mapping_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_mapping_struct));
        mipc_sys_mapping_set_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_mapping_set_req(MIPC_SYS_MAPPING_SET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_mapping_struct *result_ptr, uint8_t mapping_list_count, mipc_sys_mapping_struct4 *mapping_list_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SYS_SET_MAPPING_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SYS_SET_MAPPING_REQ_T_MAPPING_COUNT, mapping_list_count);

    if (mapping_list_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SYS_SET_MAPPING_REQ_T_MAPPING_LIST, mapping_list_count * sizeof(mipc_sys_mapping_struct4), mapping_list_ptr);
    }

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_mapping_set_config_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sys_mapping_set_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_mapping_set_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_mapping_struct *result_ptr, uint8_t mapping_list_count, mipc_sys_mapping_struct4 *mapping_list_ptr)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_mapping_set_req(NULL, NULL, sim_ps_id, result_ptr, mapping_list_count, mapping_list_ptr);
}

mipc_api_result_enum mipc_sys_mapping_set_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_MAPPING_SET_CB cb, void *cb_priv_ptr, uint8_t mapping_list_count, mipc_sys_mapping_struct4 *mapping_list_ptr)
{
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_mapping_set_req(cb, cb_priv_ptr, sim_ps_id, NULL, mapping_list_count, mapping_list_ptr);
}

static mipc_api_result_enum mipc_sys_mapping_get_cnf(mipc_msg_t *msg_ptr, mipc_sys_mapping_struct *result_ptr)
{
    void* t_result_ptr;
    uint8_t api_error = MIPC_API_RESULT_FAIL;

    if (msg_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) {
            mtkLogD(LOG_TAG, "cur ptr null\n");
            break;
        }
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)t_result_ptr));
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            api_error = MIPC_API_RESULT_SUCCESS;
            break;
        }
        t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_MAPPING_CNF_T_MAPPING_COUNT, NULL);
        if (NULL == t_result_ptr) {
            mtkLogD(LOG_TAG, "count null\n");
            break;
        }
        result_ptr->mapping_list_count = (uint8_t)(*((uint32_t*)t_result_ptr));
        mtkLogD(LOG_TAG, "t_result_ptr = %d \n", *((uint32_t*)t_result_ptr));
        mtkLogD(LOG_TAG, "mapping_list_count = %d \n", result_ptr->mapping_list_count);
        if (result_ptr->mapping_list_count) {
            uint16_t list_len = 0;
            t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_MAPPING_CNF_T_MAPPING_LIST, &list_len);
            if (NULL == t_result_ptr) {
                mtkLogD(LOG_TAG, "list ptr null\n");
                break;
            }
            MEMCPY(result_ptr->mapping_list, t_result_ptr, list_len);
        }
        api_error = MIPC_API_RESULT_SUCCESS;
    } while (0);

    if (api_error) {
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_mapping_get_config_cb(mipc_msg_t *msg_ptr, MIPC_SYS_MAPPING_GET_CB cb, void *cb_priv_ptr)
{
    mipc_sys_mapping_struct *result_ptr = (mipc_sys_mapping_struct *)ALLOC(sizeof(mipc_sys_mapping_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_mapping_struct));
        mipc_sys_mapping_get_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_mapping_get_req(MIPC_SYS_MAPPING_SET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_mapping_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SYS_GET_MAPPING_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SYS_GET_MAPPING_REQ_T_MSG, sim_ps_id);

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_mapping_get_config_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sys_mapping_get_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_mapping_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_mapping_struct *result_ptr)
{
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_mapping_get_req(NULL, NULL, sim_ps_id, result_ptr);
}

mipc_api_result_enum mipc_sys_mapping_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_MAPPING_GET_CB cb, void *cb_priv_ptr)
{
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_mapping_get_req(cb, cb_priv_ptr, sim_ps_id, NULL);
}

static mipc_api_result_enum mipc_sys_info_get_cnf(mipc_msg_t *msg_ptr, mipc_sys_info_struct *result_ptr)
{
    void* t_result_ptr;
    uint8_t api_error = MIPC_API_RESULT_FAIL;
    uint16_t t_systmp_len = 0;
    mtkLogD(LOG_TAG, "mipc_sys_info_get_cnf \n");

    if (msg_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        mtkLogD(LOG_TAG, "msg_ptr return null\n");
        return MIPC_API_RESULT_TIMEOUT;
    }

    MEMSET(result_ptr, 0, sizeof(*result_ptr));
    //STEP5: fill the result
    do {
        mtkLogD(LOG_TAG, "do while\n");
        if ((t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) {
            mtkLogD(LOG_TAG, "mipc_sys_info_get_cnf return null\n");
            break;
        }
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)t_result_ptr));
        mtkLogD(LOG_TAG, "result_code = %d \n", result_ptr->result_code);

        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            api_error = MIPC_API_RESULT_SUCCESS;
            break;
        }

        t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_INFO_CNF_T_SYS_CELLULAR_CLASS, NULL);
        if (NULL == t_result_ptr) {
            mtkLogD(LOG_TAG, "cellular_class null\n");
            break;
        }
        result_ptr->cellular_class = *((uint32_t*)t_result_ptr);
        mtkLogD(LOG_TAG, "t_result_ptr = %d \n", *((uint32_t*)t_result_ptr));
        mtkLogD(LOG_TAG, "cellular_class = %d \n", result_ptr->cellular_class);

        t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_INFO_CNF_T_VOICE_CLASS, NULL);
        if (NULL == t_result_ptr) {
            mtkLogD(LOG_TAG, "voice_class null\n");
            break;
        }
        result_ptr->voice_class = (mipc_sys_voice_class_enum)(*((uint8_t*)t_result_ptr));
        mtkLogD(LOG_TAG, "t_result_ptr = %d \n", *((uint32_t*)t_result_ptr));
        mtkLogD(LOG_TAG, "voice_class = %d \n", result_ptr->voice_class);

        t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_INFO_CNF_T_SIM_CLASS, NULL);
        if (NULL == t_result_ptr) {
            mtkLogD(LOG_TAG, "sim class null\n");
            break;
        }
        result_ptr->sim_class = (mipc_sys_sim_class_enum)(*((uint8_t*)t_result_ptr));
        mtkLogD(LOG_TAG, "t_result_ptr = %d \n", *((uint32_t*)t_result_ptr));
        mtkLogD(LOG_TAG, "sim_class = %d \n", result_ptr->sim_class);

        t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_INFO_CNF_T_DATA_CLASS, NULL);
        if (NULL == t_result_ptr) {
            mtkLogD(LOG_TAG, "data_class null\n");
            break;
        }
        result_ptr->data_class = *((uint32_t*)t_result_ptr);
        mtkLogD(LOG_TAG, "t_result_ptr = %d \n", *((uint32_t*)t_result_ptr));
        mtkLogD(LOG_TAG, "data_class = %d \n", result_ptr->data_class);

        t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_INFO_CNF_T_GSM_BAND_CLASS, NULL);
        if (NULL == t_result_ptr) {
            mtkLogD(LOG_TAG, "gsm_band_class null\n");
            break;
        }
        result_ptr->gsm_band_class = *((uint32_t*)t_result_ptr);
        mtkLogD(LOG_TAG, "t_result_ptr = %d \n", *((uint32_t*)t_result_ptr));
        mtkLogD(LOG_TAG, "gsm_band_class = %d \n", result_ptr->gsm_band_class);

        t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_INFO_CNF_T_UMTS_BAND_CLASS, NULL);
        if (NULL == t_result_ptr) {
            mtkLogD(LOG_TAG, "umts_band_class null\n");
            break;
        }
        result_ptr->umts_band_class = *((uint32_t*)t_result_ptr);
        mtkLogD(LOG_TAG, "t_result_ptr = %d \n", *((uint32_t*)t_result_ptr));
        mtkLogD(LOG_TAG, "umts_band_class = %d \n", result_ptr->umts_band_class);


        t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_INFO_CNF_T_TDS_BAND_CLASS, NULL);
        if (NULL == t_result_ptr) {
            mtkLogD(LOG_TAG, "tds_band_class null\n");
            break;
        }
        result_ptr->tds_band_class = *((uint32_t*)t_result_ptr);
        mtkLogD(LOG_TAG, "t_result_ptr = %d \n", *((uint32_t*)t_result_ptr));
        mtkLogD(LOG_TAG, "tds_band_class = %d \n", result_ptr->tds_band_class);

        t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_INFO_CNF_T_C2K_BAND_CLASS, NULL);
        if (NULL == t_result_ptr) {
            mtkLogD(LOG_TAG, "cdma_band_class null\n");
            break;
        }
        result_ptr->cdma_band_class = *((uint32_t*)t_result_ptr);
        mtkLogD(LOG_TAG, "t_result_ptr = %d \n", *((uint32_t*)t_result_ptr));
        mtkLogD(LOG_TAG, "cdma_band_class = %d \n", result_ptr->cdma_band_class);

        t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_INFO_CNF_T_LTE_BAND_CLASS, &t_systmp_len);
        if (NULL == t_result_ptr) {
            mtkLogD(LOG_TAG, "lte_band_class null\n");
            break;
        }
        MEMCPY(&result_ptr->lte_band_class, t_result_ptr, (t_systmp_len > sizeof(result_ptr->lte_band_class)) ? sizeof(result_ptr->lte_band_class) : t_systmp_len);
        mtkLogD(LOG_TAG, "t_result_ptr = %d \n", *((uint32_t*)t_result_ptr));
        mtkLogD(LOG_TAG, "lte_band_class0 = %d \n", result_ptr->lte_band_class.lte_band_class[0]);

        t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_INFO_CNF_T_NR_BAND_CLASS, &t_systmp_len);
        if (NULL == t_result_ptr) {
            mtkLogD(LOG_TAG, "nr_band_class null\n");
            break;
        }
        MEMCPY(&result_ptr->nr_band_class, t_result_ptr, (t_systmp_len > sizeof(result_ptr->nr_band_class)) ? sizeof(result_ptr->nr_band_class) : t_systmp_len);
        mtkLogD(LOG_TAG, "t_result_ptr = %d \n", *((uint32_t*)t_result_ptr));
        mtkLogD(LOG_TAG, "nr_band_class0 = %d \n", result_ptr->nr_band_class.nr_band_class[0]);


        t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_INFO_CNF_T_SMS_CAPS, NULL);
        if (NULL == t_result_ptr) {
            mtkLogD(LOG_TAG, "cur ptr null\n");
            break;
        }
        result_ptr->sms_caps = *((uint32_t*)t_result_ptr);
        mtkLogD(LOG_TAG, "t_result_ptr = %d \n", *((uint32_t*)t_result_ptr));
        mtkLogD(LOG_TAG, "sms_caps = %d \n", result_ptr->sms_caps);

        t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_INFO_CNF_T_CTRL_CAPS, NULL);
        if (NULL == t_result_ptr) {
            mtkLogD(LOG_TAG, "cur ptr null\n");
            break;
        }
        result_ptr->control_caps = *((uint32_t*)t_result_ptr);
        mtkLogD(LOG_TAG, "t_result_ptr = %d \n", *((uint32_t*)t_result_ptr));
        mtkLogD(LOG_TAG, "control_caps = %d \n", result_ptr->control_caps);

        t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_INFO_CNF_T_AUTH_ALGO_CAPS, NULL);
        if (NULL == t_result_ptr) {
            mtkLogD(LOG_TAG, "cur ptr null\n");
            break;
        }
        result_ptr->auth_algo_caps = *((uint32_t*)t_result_ptr);
        mtkLogD(LOG_TAG, "t_result_ptr = %d \n", *((uint32_t*)t_result_ptr));
        mtkLogD(LOG_TAG, "auth_algo_caps = %d \n", result_ptr->auth_algo_caps);

        t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_INFO_CNF_T_SERVICE_CAPS, NULL);
        if (NULL == t_result_ptr) {
            mtkLogD(LOG_TAG, "cur ptr null\n");
            break;
        }
        result_ptr->service_caps = *((uint32_t*)t_result_ptr);
        mtkLogD(LOG_TAG, "t_result_ptr = %d \n", *((uint32_t*)t_result_ptr));
        mtkLogD(LOG_TAG, "service_caps = %d \n", result_ptr->service_caps);

        t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_INFO_CNF_T_MULTI_MD, &t_systmp_len);
        if (NULL == t_result_ptr) {
            mtkLogD(LOG_TAG, "cur ptr null\n");
            break;
        }
        MEMCPY(&result_ptr->multi_modem_info, t_result_ptr, (t_systmp_len > sizeof(result_ptr->multi_modem_info)) ? sizeof(result_ptr->multi_modem_info) : t_systmp_len);
        mtkLogD(LOG_TAG, "t_result_ptr = %d \n", *((uint32_t*)t_result_ptr));
        mtkLogD(LOG_TAG, "multi_modem_info.modem_id[0] = %lx \n", result_ptr->multi_modem_info.modem_id);

        t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_INFO_CNF_T_DEVICE_ID, &t_systmp_len);
        if (NULL == t_result_ptr) {
            mtkLogD(LOG_TAG, "device_id - cur ptr null\n");
        } else {
            MEMCPY(result_ptr->device_id, t_result_ptr, (t_systmp_len > 15) ? 15 : t_systmp_len);
            mtkLogD(LOG_TAG, "t_result_ptr = %d \n", *((uint32_t*)t_result_ptr));
            mtkLogD(LOG_TAG, "device_id = %d \n", result_ptr->device_id[0]);
        }

        t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_INFO_CNF_T_MANUFCTR, &t_systmp_len);
        if (NULL == t_result_ptr) {
            mtkLogD(LOG_TAG, "manufacturer - cur ptr null\n");
            break;
        }
        MEMCPY(result_ptr->manufacturer, t_result_ptr, (t_systmp_len > 32) ? 32 : t_systmp_len);

        t_result_ptr = mipc_msg_get_val_str(msg_ptr, MIPC_SYS_GET_INFO_CNF_T_FIRMWARE, &t_systmp_len);
        if (NULL == t_result_ptr) {
            mtkLogD(LOG_TAG, "firmware_info - cur ptr null\n");
            break;
        }
        mtkLogD(LOG_TAG, "MIPC_SYS_GET_INFO_CNF_T_FIRMWARE: %s\n", t_result_ptr);
        MEMCPY(result_ptr->firmware_info, t_result_ptr, (t_systmp_len > MIPC_FIRMWARE_LEN) ? MIPC_FIRMWARE_LEN : t_systmp_len);

        t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_INFO_CNF_T_HARDWARE, &t_systmp_len);
        if (NULL == t_result_ptr) {
            mtkLogD(LOG_TAG, "cur ptr null\n");
            break;
        }
        MEMCPY(result_ptr->hardware_info, t_result_ptr, (t_systmp_len > 30) ? 30 : t_systmp_len);
        t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_INFO_CNF_T_MAX_ACTIVE_CTXT, NULL);
        if (NULL == t_result_ptr) {
            mtkLogD(LOG_TAG, "cur ptr null\n");
            break;
        }
        result_ptr->max_activated_contexts = (uint16_t)(*((uint32_t*)t_result_ptr));
        t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_INFO_CNF_T_EXECUTOR_IDX, NULL);
        if (NULL == t_result_ptr) {
            mtkLogD(LOG_TAG, "cur ptr null\n");
            break;
        }
        result_ptr->executor_index = (uint16_t)(*((uint32_t*)t_result_ptr));

        t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_INFO_CNF_T_IMEISV, &t_systmp_len);
        if (NULL == t_result_ptr) {
            mtkLogD(LOG_TAG, "cur ptr null\n");
            break;
        }
        MEMCPY(result_ptr->imeisv, t_result_ptr, (t_systmp_len > MIPC_IMEISV_LEN) ? MIPC_IMEISV_LEN : t_systmp_len);

        t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_INFO_CNF_T_CUSTOM_CLASS_NAME, &t_systmp_len);
        if (NULL == t_result_ptr) {
            mtkLogD(LOG_TAG, "cur ptr null\n");
            break;
        }

        MEMCPY(result_ptr->custom_class_name, t_result_ptr, (t_systmp_len > 16) ? 16 : t_systmp_len);
        t_result_ptr = mipc_msg_get_val_str(msg_ptr, MIPC_SYS_GET_INFO_CNF_T_FIRMWARE_CUSTOM, &t_systmp_len);
        if (NULL == t_result_ptr) {
            mtkLogD(LOG_TAG, "cur ptr null\n");
            break;
        }
        MEMCPY(result_ptr->firmware_custom_info, t_result_ptr, (t_systmp_len > 30) ? 30 : t_systmp_len);
        api_error = MIPC_API_RESULT_SUCCESS;
    } while (0);

    if (api_error) {
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_info_get_config_cb(mipc_msg_t *msg_ptr, MIPC_SYS_INFO_GET_CB cb, void *cb_priv_ptr)
{
    mipc_sys_info_struct *result_ptr = (mipc_sys_info_struct *)ALLOC(sizeof(mipc_sys_info_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_info_struct));
        mipc_sys_info_get_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_info_get_req(MIPC_SYS_INFO_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_info_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SYS_GET_INFO_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SYS_GET_INFO_REQ_T_MSG, sim_ps_id);

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_info_get_config_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_sys_info_get_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_info_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_info_struct *result_ptr)
{
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_info_get_req(NULL, NULL, sim_ps_id, result_ptr);
}

mipc_api_result_enum mipc_sys_info_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_INFO_GET_CB cb, void *cb_priv_ptr)
{
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_info_get_req(cb, cb_priv_ptr, sim_ps_id, NULL);
}


////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_shutdown_cnf(mipc_msg_t *msg_ptr, mipc_result_enum *result_ptr)
{
    uint32_t *t_result_ptr;
    uint8_t api_error = 1;
    char *t_nwtmp_ptr;
    uint16_t t_nwtmp_len;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            *result_ptr = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            *result_ptr = MIPC_RESULT_SUCCESS;
        } else {
            *result_ptr = MIPC_RESULT_FAILURE;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        *result_ptr = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}
static void mipc_sys_shutdown_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_SHUTDOWN_CB cb, void *cb_priv_ptr)
{
    mipc_result_enum *result_ptr = (mipc_result_enum *)ALLOC(sizeof(mipc_result_enum));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_result_enum));
        mipc_sys_shutdown_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_shutdown_req(MIPC_SYS_SHUTDOWN_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_result_enum *result_ptr)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_NW_SET_RADIO_STATE_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (in this case, there is only one TLV parameter)
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_NW_SET_RADIO_STATE_REQ_T_SW_STATE, 0);
    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_shutdown_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_sys_shutdown_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}
mipc_api_result_enum mipc_sys_shutdown_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_result_enum *result_ptr)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_shutdown_req(NULL, NULL, sim_ps_id, result_ptr);
}
mipc_api_result_enum mipc_sys_shutdown_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_SHUTDOWN_CB cb, void *cb_priv_ptr)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_shutdown_req(cb, cb_priv_ptr, sim_ps_id, NULL);
}

//////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_fcc_lock_release_cnf(mipc_msg_t *msg_ptr, mipc_sys_fcc_lock_release_struct *result_ptr)
{
    uint32_t *t_result_ptr;
    uint8_t api_error = 1;
    char *t_nwtmp_ptr;
    uint16_t t_nwtmp_len;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            result_ptr->result_code = MIPC_RESULT_SUCCESS;
            if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_RELEASE_FCC_LOCK_CNF_T_CHALLENGE, NULL))) {
                memcpy(result_ptr->challenge, t_result_ptr, 4);
                result_ptr->challenge_present = 1;
            }
        } else {
            result_ptr->result_code = MIPC_RESULT_SUCCESS;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}
static void mipc_sys_fcc_lock_release_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_FCC_LOCK_RELEASE_CB cb, void *cb_priv_ptr)
{
    mipc_sys_fcc_lock_release_struct *result_ptr = (mipc_sys_fcc_lock_release_struct *)ALLOC(sizeof(mipc_sys_fcc_lock_release_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_result_enum));
        mipc_sys_fcc_lock_release_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

#if 0 // req not define in mipc_msg_tlv_const.h 
static mipc_api_result_enum mipc_sys_fcc_lock_release_req(MIPC_SYS_FCC_LOCK_RELEASE_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_fcc_lock_release_struct *result_ptr, uint32_t response_present, uint8_t response[4])
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_RELEASE_FCC_LOCK_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters
    if (response_present) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SYS_RELEASE_FCC_LOCK_REQ_T_RESPONSE, 4, response);
    }
    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_fcc_lock_release_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_sys_fcc_lock_release_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_fcc_lock_release_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_fcc_lock_release_struct *result_ptr, uint32_t response_present, uint8_t response[4])
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_fcc_lock_release_req(NULL, NULL, sim_ps_id, result_ptr, response_present, response);
}

mipc_api_result_enum mipc_sys_fcc_lock_release_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_FCC_LOCK_RELEASE_CB cb, void *cb_priv_ptr, uint32_t response_present, uint8_t response[4])
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_fcc_lock_release_req(cb, cb_priv_ptr, sim_ps_id, NULL, response_present, response);
}
//////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_fcc_lock_get_cnf(mipc_msg_t *msg_ptr, mipc_sys_fcc_lock_get_struct *result_ptr)
{
    uint32_t *t_result_ptr;
    uint8_t api_error = 1;
    char *t_nwtmp_ptr;
    uint16_t t_nwtmp_len;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            result_ptr->result_code = MIPC_RESULT_SUCCESS;
            if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_FCC_LOCK_CNF_T_MODE, NULL)) == NULL) break;
            result_ptr->mode = (mipc_sys_fcc_lock_mode_enum) * (uint8_t *)t_result_ptr;
            if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_FCC_LOCK_CNF_T_STATE, NULL)) == NULL) break;
            result_ptr->state = (mipc_sys_fcc_lock_state_enum) * (uint8_t *)t_result_ptr;
        } else {
            result_ptr->result_code = MIPC_RESULT_SUCCESS;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}
static void mipc_sys_fcc_lock_get_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_FCC_LOCK_GET_CB cb, void *cb_priv_ptr)
{
    mipc_sys_fcc_lock_get_struct *result_ptr = (mipc_sys_fcc_lock_get_struct *)ALLOC(sizeof(mipc_sys_fcc_lock_get_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_result_enum));
        mipc_sys_fcc_lock_get_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}
static mipc_api_result_enum mipc_sys_fcc_lock_get_req(MIPC_SYS_FCC_LOCK_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_fcc_lock_get_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_GET_FCC_LOCK_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (no parameter)
    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_fcc_lock_get_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_sys_fcc_lock_get_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_fcc_lock_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_fcc_lock_get_struct *result_ptr)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_fcc_lock_get_req(NULL, NULL, sim_ps_id, result_ptr);
}

mipc_api_result_enum mipc_sys_fcc_lock_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_FCC_LOCK_GET_CB cb, void *cb_priv_ptr)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_fcc_lock_get_req(cb, cb_priv_ptr, sim_ps_id, NULL);
}

#endif
//////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_fcc_lock_config_cnf(mipc_msg_t *msg_ptr, mipc_sys_fcc_lock_config_struct *result_ptr)
{
    uint32_t *t_result_ptr;
    uint8_t api_error = 1;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        result_ptr->result_code = (mipc_result_enum) * t_result_ptr;
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}
static void mipc_sys_fcc_lock_config_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_FCC_LOCK_CONFIG_CB cb, void *cb_priv_ptr)
{
    mipc_sys_fcc_lock_config_struct *result_ptr = (mipc_sys_fcc_lock_config_struct *)ALLOC(sizeof(mipc_sys_fcc_lock_config_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_result_enum));
        mipc_sys_fcc_lock_config_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_fcc_lock_config_req(MIPC_SYS_FCC_LOCK_CONFIG_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_fcc_lock_config_struct *result_ptr, mipc_sys_fcc_lock_mode_enum mode)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_SET_FCC_LOCK_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SYS_SET_FCC_LOCK_REQ_T_MODE, mode);

    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_fcc_lock_config_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_sys_fcc_lock_config_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_fcc_lock_config_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_fcc_lock_config_struct *result_ptr, mipc_sys_fcc_lock_mode_enum mode)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_fcc_lock_config_req(NULL, NULL, sim_ps_id, result_ptr, mode);
}

mipc_api_result_enum mipc_sys_fcc_lock_config_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_FCC_LOCK_CONFIG_CB cb, void *cb_priv_ptr, mipc_sys_fcc_lock_mode_enum mode)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_fcc_lock_config_req(cb, cb_priv_ptr, sim_ps_id, NULL, mode);
}
/////////////////////////////////////////////////////////////////////////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_thermal_sensor_num_get_cnf(mipc_msg_t *msg_ptr, mipc_sys_thermal_sensor_num_struct *result_ptr)
{
    uint32_t *t_result_ptr;
    void *t_val_ptr;
    uint8_t api_error = 1;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_THERMAL_SENSOR_NUM_CNF_T_NUM, NULL)) == NULL) break;
            result_ptr->num = *(uint32_t *)t_val_ptr;

            result_ptr->result_code = MIPC_RESULT_SUCCESS;
        } else {
            result_ptr->result_code = (mipc_result_enum) * t_result_ptr;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_thermal_sensor_num_get_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_THERMAL_SENSOR_NUM_GET_CB cb, void *cb_priv_ptr)
{
    mipc_sys_thermal_sensor_num_struct *result_ptr = (mipc_sys_thermal_sensor_num_struct *)ALLOC(sizeof(mipc_sys_thermal_sensor_num_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_thermal_sensor_num_struct));
        mipc_sys_thermal_sensor_num_get_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_thermal_sensor_num_get_req(MIPC_SYS_THERMAL_SENSOR_NUM_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_thermal_sensor_num_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_GET_THERMAL_SENSOR_NUM_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (in this case, there is no TLV parameter)

    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_thermal_sensor_num_get_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_thermal_sensor_num_struct));
        ret = mipc_sys_thermal_sensor_num_get_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_thermal_sensor_num_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_thermal_sensor_num_struct *result_ptr)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_thermal_sensor_num_get_req(NULL, NULL, sim_ps_id, result_ptr);
}

mipc_api_result_enum mipc_sys_thermal_sensor_num_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_THERMAL_SENSOR_NUM_GET_CB cb, void *cb_priv_ptr)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_thermal_sensor_num_get_req(cb, cb_priv_ptr, sim_ps_id, NULL);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_thermal_sensor_info_get_cnf(mipc_msg_t *msg_ptr, mipc_sys_thermal_sensor_info_struct *result_ptr)
{
    uint32_t *t_result_ptr;
    void *t_val_ptr;
    uint16_t t_val_len;
    uint8_t api_error = 1;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_THERMAL_SENSOR_INFO_CNF_T_ID, NULL)) == NULL) break;
            result_ptr->sensor_id = *(uint32_t *)t_val_ptr;
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_THERMAL_SENSOR_INFO_CNF_T_NAME, &t_val_len)) == NULL) break;
            memcpy(result_ptr->sensor_name, (char *)t_val_ptr, (t_val_len > sizeof(result_ptr->sensor_name)) ? sizeof(result_ptr->sensor_name) : t_val_len);
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_THERMAL_SENSOR_INFO_CNF_T_TYPE, NULL)) == NULL) break;
            result_ptr->sensor_type = (mipc_sys_thermal_sensor_type_enum) * (uint8_t *)t_val_ptr;
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_THERMAL_SENSOR_INFO_CNF_T_MEAS_TYPE, NULL)) == NULL) break;
            result_ptr->sensor_meas_type = (mipc_sys_thermal_sensor_meas_type_enum) * (uint8_t *)t_val_ptr;
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_THERMAL_SENSOR_INFO_CNF_T_MIN_TEMPATURE, NULL)) == NULL) break;
            result_ptr->min_tempature = *(int32_t *)t_val_ptr;
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_THERMAL_SENSOR_INFO_CNF_T_MAX_TEMPATURE, NULL)) == NULL) break;
            result_ptr->max_tempature = *(int32_t *)t_val_ptr;
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_THERMAL_SENSOR_INFO_CNF_T_ACCURACY, NULL)) == NULL) break;
            result_ptr->accuracy = *(uint32_t *)t_val_ptr;
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_THERMAL_SENSOR_INFO_CNF_T_RESOLUTION, NULL)) == NULL) break;
            result_ptr->resolution = *(uint32_t *)t_val_ptr;
            result_ptr->result_code = MIPC_RESULT_SUCCESS;
        } else {
            result_ptr->result_code = (mipc_result_enum) * t_result_ptr;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_thermal_sensor_info_get_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_THERMAL_SENSOR_INFO_GET_CB cb, void *cb_priv_ptr)
{
    mipc_sys_thermal_sensor_info_struct *result_ptr = (mipc_sys_thermal_sensor_info_struct *)ALLOC(sizeof(mipc_sys_thermal_sensor_info_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_thermal_sensor_info_struct));
        mipc_sys_thermal_sensor_info_get_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_thermal_sensor_info_get_req(MIPC_SYS_THERMAL_SENSOR_INFO_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_thermal_sensor_info_struct *result_ptr, uint32_t thermal_sensor_id)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_GET_THERMAL_SENSOR_INFO_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (in this case, there is no TLV parameter)
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_SYS_GET_THERMAL_SENSOR_INFO_REQ_T_ID, thermal_sensor_id);

    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_thermal_sensor_info_get_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_thermal_sensor_info_struct));
        ret = mipc_sys_thermal_sensor_info_get_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_thermal_sensor_info_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_thermal_sensor_info_struct *result_ptr, uint32_t thermal_sensor_id)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_thermal_sensor_info_get_req(NULL, NULL, sim_ps_id, result_ptr, thermal_sensor_id);
}

mipc_api_result_enum mipc_sys_thermal_sensor_info_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_THERMAL_SENSOR_INFO_GET_CB cb, void *cb_priv_ptr, uint32_t thermal_sensor_id)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_thermal_sensor_info_get_req(cb, cb_priv_ptr, sim_ps_id, NULL, thermal_sensor_id);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_thermal_alarm_set_cnf(mipc_msg_t *msg_ptr, mipc_sys_thermal_sensor_configs_struct *result_ptr)
{
    uint32_t *t_result_ptr;
    void *t_val_ptr;

    uint8_t api_error = 1;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_SET_THERMAL_SENSOR_CNF_T_CONFIG_COUNT, NULL)) == NULL) break;
            //*(uint8_t *)t_val_ptr shold be 4
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_SET_THERMAL_SENSOR_CNF_T_CONFIG_LIST, NULL)) == NULL) break;
            memcpy(&result_ptr->configs[0], t_val_ptr, sizeof(mipc_sys_thermal_sensor_config_struct4) * 4);
            result_ptr->result_code = MIPC_RESULT_SUCCESS;
        } else {
            result_ptr->result_code = (mipc_result_enum) * t_result_ptr;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_thermal_alarm_set_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_THERMAL_ALARM_SET_CB cb, void *cb_priv_ptr)
{
    mipc_sys_thermal_sensor_configs_struct *result_ptr = (mipc_sys_thermal_sensor_configs_struct *)ALLOC(sizeof(mipc_sys_thermal_sensor_configs_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_thermal_sensor_configs_struct));
        mipc_sys_thermal_alarm_set_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_thermal_alarm_set_req(MIPC_SYS_THERMAL_ALARM_SET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_thermal_sensor_configs_struct *result_ptr,  uint32_t config0_enable, uint32_t config0_sensor_id, uint32_t config0_alarm_id, int32_t config0_threshold, uint32_t config0_hysteresis, uint32_t config0_interval, uint32_t config0_alarm_type, uint32_t config1_enable, uint32_t config1_sensor_id, uint32_t config1_alarm_id, int32_t config1_threshold, uint32_t config1_hysteresis, uint32_t config1_interval, uint32_t config1_alarm_type, uint32_t config2_enable, uint32_t config2_sensor_id, uint32_t config2_alarm_id, int32_t config2_threshold, uint32_t config2_hysteresis, uint32_t config2_interval, uint32_t config2_alarm_type, uint32_t config3_enable, uint32_t config3_sensor_id, uint32_t config3_alarm_id, int32_t config3_threshold, uint32_t config3_hysteresis, uint32_t config3_interval, uint32_t config3_alarm_type)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;
    mipc_sys_thermal_sensor_config_struct4 *list_ptr = (mipc_sys_thermal_sensor_config_struct4 *)ALLOC(sizeof(mipc_sys_thermal_sensor_config_struct4) * 4);

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_SET_THERMAL_SENSOR_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (in this case, there is no TLV parameter)
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SYS_SET_THERMAL_SENSOR_REQ_T_CONFIG_COUNT, 4);
    list_ptr[0].enable = config0_enable;
    list_ptr[0].sensor_id = config0_sensor_id;
    list_ptr[0].alarm_id = config0_alarm_id;
    list_ptr[0].threshold = config0_threshold;
    list_ptr[0].hysteresis = config0_hysteresis;
    list_ptr[0].interval = config0_interval;
    list_ptr[0].alarm_type = config0_alarm_type;
    list_ptr[1].enable = config1_enable;
    list_ptr[1].sensor_id = config1_sensor_id;
    list_ptr[1].alarm_id = config1_alarm_id;
    list_ptr[1].threshold = config1_threshold;
    list_ptr[1].hysteresis = config1_hysteresis;
    list_ptr[1].interval = config1_interval;
    list_ptr[1].alarm_type = config1_alarm_type;
    list_ptr[2].enable = config2_enable;
    list_ptr[2].sensor_id = config2_sensor_id;
    list_ptr[2].alarm_id = config2_alarm_id;
    list_ptr[2].threshold = config2_threshold;
    list_ptr[2].hysteresis = config2_hysteresis;
    list_ptr[2].interval = config2_interval;
    list_ptr[2].alarm_type = config2_alarm_type;
    list_ptr[3].enable = config3_enable;
    list_ptr[3].sensor_id = config3_sensor_id;
    list_ptr[3].alarm_id = config3_alarm_id;
    list_ptr[3].threshold = config3_threshold;
    list_ptr[3].hysteresis = config3_hysteresis;
    list_ptr[3].interval = config3_interval;
    list_ptr[3].alarm_type = config3_alarm_type;
    mipc_msg_add_tlv(msg_req_ptr, MIPC_SYS_SET_THERMAL_SENSOR_REQ_T_CONFIG_LIST, sizeof(mipc_sys_thermal_sensor_config_struct4) * 4, list_ptr);

    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_thermal_alarm_set_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (list_ptr) {
        FREE(list_ptr);
    }

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_thermal_sensor_configs_struct));
        ret = mipc_sys_thermal_alarm_set_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_thermal_alarm_set_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_thermal_sensor_configs_struct *result_ptr, uint32_t config0_enable, uint32_t config0_sensor_id, uint32_t config0_alarm_id, int32_t config0_threshold, uint32_t config0_hysteresis, uint32_t config0_interval, uint32_t config0_alarm_type, uint32_t config1_enable, uint32_t config1_sensor_id, uint32_t config1_alarm_id, int32_t config1_threshold, uint32_t config1_hysteresis, uint32_t config1_interval, uint32_t config1_alarm_type, uint32_t config2_enable, uint32_t config2_sensor_id, uint32_t config2_alarm_id, int32_t config2_threshold, uint32_t config2_hysteresis, uint32_t config2_interval, uint32_t config2_alarm_type, uint32_t config3_enable, uint32_t config3_sensor_id, uint32_t config3_alarm_id, int32_t config3_threshold, uint32_t config3_hysteresis, uint32_t config3_interval, uint32_t config3_alarm_type)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_thermal_alarm_set_req(NULL, NULL, sim_ps_id, result_ptr, config0_enable, config0_sensor_id, config0_alarm_id, config0_threshold, config0_hysteresis, config0_interval, config0_alarm_type, config1_enable, config1_sensor_id, config1_alarm_id, config1_threshold, config1_hysteresis, config1_interval, config1_alarm_type, config2_enable, config2_sensor_id, config2_alarm_id, config2_threshold, config2_hysteresis, config2_interval, config2_alarm_type, config3_enable, config3_sensor_id, config3_alarm_id, config3_threshold, config3_hysteresis, config3_interval, config3_alarm_type);
}

mipc_api_result_enum mipc_sys_thermal_alarm_set_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_THERMAL_ALARM_SET_CB cb, void *cb_priv_ptr, uint32_t config0_enable, uint32_t config0_sensor_id, uint32_t config0_alarm_id, int32_t config0_threshold, uint32_t config0_hysteresis, uint32_t config0_interval, uint32_t config0_alarm_type, uint32_t config1_enable, uint32_t config1_sensor_id, uint32_t config1_alarm_id, int32_t config1_threshold, uint32_t config1_hysteresis, uint32_t config1_interval, uint32_t config1_alarm_type, uint32_t config2_enable, uint32_t config2_sensor_id, uint32_t config2_alarm_id, int32_t config2_threshold, uint32_t config2_hysteresis, uint32_t config2_interval, uint32_t config2_alarm_type, uint32_t config3_enable, uint32_t config3_sensor_id, uint32_t config3_alarm_id, int32_t config3_threshold, uint32_t config3_hysteresis, uint32_t config3_interval, uint32_t config3_alarm_type)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_thermal_alarm_set_req(cb, cb_priv_ptr, sim_ps_id, NULL, config0_enable, config0_sensor_id, config0_alarm_id, config0_threshold, config0_hysteresis, config0_interval, config0_alarm_type, config1_enable, config1_sensor_id, config1_alarm_id, config1_threshold, config1_hysteresis, config1_interval, config1_alarm_type, config2_enable, config2_sensor_id, config2_alarm_id, config2_threshold, config2_hysteresis, config2_interval, config2_alarm_type, config3_enable, config3_sensor_id, config3_alarm_id, config3_threshold, config3_hysteresis, config3_interval, config3_alarm_type);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_thermal_sensor_get_cnf(mipc_msg_t *msg_ptr, mipc_sys_thermal_sensor_struct *result_ptr)
{
    uint32_t *t_result_ptr;
    void *t_val_ptr;
    uint8_t api_error = 1;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_THERMAL_SENSOR_CNF_T_TEMPERATURE, NULL)) == NULL) break;
            result_ptr->current_temperature = *(int32_t *)t_val_ptr;
            result_ptr->result_code = MIPC_RESULT_SUCCESS;
        } else {
            result_ptr->result_code = (mipc_result_enum) * t_result_ptr;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_thermal_sensor_get_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_THERMAL_SENSOR_GET_CB cb, void *cb_priv_ptr)
{
    mipc_sys_thermal_sensor_struct *result_ptr = (mipc_sys_thermal_sensor_struct *)ALLOC(sizeof(mipc_sys_thermal_sensor_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_thermal_sensor_struct));
        mipc_sys_thermal_sensor_get_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_thermal_sensor_get_req(MIPC_SYS_THERMAL_SENSOR_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_thermal_sensor_struct *result_ptr, uint32_t thermal_sensor_id)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_GET_THERMAL_SENSOR_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (in this case, there is no TLV parameter)
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_SYS_GET_THERMAL_SENSOR_REQ_T_ID, thermal_sensor_id);

    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_thermal_sensor_get_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_thermal_sensor_struct));
        ret = mipc_sys_thermal_sensor_get_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_thermal_sensor_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_thermal_sensor_struct *result_ptr, uint32_t thermal_sensor_id)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_thermal_sensor_get_req(NULL, NULL, sim_ps_id, result_ptr, thermal_sensor_id);
}

mipc_api_result_enum mipc_sys_thermal_sensor_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_THERMAL_SENSOR_GET_CB cb, void *cb_priv_ptr, uint32_t thermal_sensor_id)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_thermal_sensor_get_req(cb, cb_priv_ptr, sim_ps_id, NULL, thermal_sensor_id);
}

//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_thermal_sensor_ind(mipc_msg_t *msg_ptr, mipc_sys_thermal_sensor_state_struct *result_ptr)
{
    uint32_t *t_result_ptr;
    void *t_val_ptr;
    uint8_t api_error = 1;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        uint16_t len;
        if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_THERMAL_SENSOR_IND_T_TEMPERATURE, NULL)) == NULL) break;
        result_ptr->current_temperature = *(int32_t *)t_val_ptr;
        if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_THERMAL_SENSOR_IND_T_THRESHOLD, NULL)) == NULL) break;
        memcpy(&result_ptr->threshold, t_val_ptr, sizeof(result_ptr->threshold));
        if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_THERMAL_SENSOR_IND_T_INFO_COUNT, NULL)) == NULL) break;
        result_ptr->info_count = *(uint8_t *)t_val_ptr;
        if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_THERMAL_SENSOR_IND_T_INFO, &len)) == NULL) break;
        memcpy(&result_ptr->infos, t_val_ptr, len);
        result_ptr->result_code = MIPC_RESULT_SUCCESS;
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_thermal_sensor_ind_cb(mipc_msg_t *msg_ptr, MIPC_SYS_THERMAL_SENSOR_IND_CB cb, void *cb_priv_ptr)
{
    mipc_sys_thermal_sensor_state_struct *result_ptr = (mipc_sys_thermal_sensor_state_struct *)ALLOC(sizeof(mipc_sys_thermal_sensor_state_struct) + sizeof(mipc_sys_thermal_sensor_info_struct4) * 10);

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_thermal_sensor_state_struct) + sizeof(mipc_sys_thermal_sensor_info_struct4) * 10);
        result_ptr->info_count = 10;
        if (mipc_sys_thermal_sensor_ind(msg_ptr, result_ptr) == MIPC_API_RESULT_SUCCESS) {
            cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);
        }
        FREE(result_ptr);
    }
}

mipc_api_result_enum mipc_sys_thermal_sensor_state_register(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_THERMAL_SENSOR_IND_CB cb, void *cb_priv_ptr)
{
    void *callback;
    if (cb) {
        callback = (void *)mipc_sys_thermal_sensor_ind_cb;
    } else {
        callback = NULL;
    }

    if (mipc_msg_register_ind_api((mipc_msg_sim_ps_id_enum)sim_ps_id, MIPC_SYS_THERMAL_SENSOR_IND, callback, (MIPC_API_CB)cb, cb_priv_ptr) == 0) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        return MIPC_API_RESULT_FAIL;
    }
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_thermal_actuator_num_get_cnf(mipc_msg_t *msg_ptr, mipc_sys_thermal_actuator_num_struct *result_ptr)
{
    uint32_t *t_result_ptr;
    void *t_val_ptr;
    uint8_t api_error = 1;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            result_ptr->result_code = MIPC_RESULT_SUCCESS;
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_THERMAL_ACTUATOR_NUM_CNF_T_NUM, NULL)) == NULL) break;
            result_ptr->num = *(uint32_t *)t_val_ptr;
        } else {
            result_ptr->result_code = MIPC_RESULT_FAILURE;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_thermal_actuator_num_get_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_THERMAL_ACTUATOR_NUM_GET_CB cb, void *cb_priv_ptr)
{
    mipc_sys_thermal_actuator_num_struct *result_ptr = (mipc_sys_thermal_actuator_num_struct *)ALLOC(sizeof(mipc_sys_thermal_actuator_num_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_thermal_actuator_num_struct));
        mipc_sys_thermal_actuator_num_get_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_thermal_actuator_num_get_req(MIPC_SYS_THERMAL_ACTUATOR_NUM_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_thermal_actuator_num_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_GET_THERMAL_ACTUATOR_NUM_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (in this case, there is no TLV parameter)

    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_thermal_actuator_num_get_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_sys_thermal_actuator_num_get_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_thermal_actuator_num_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_thermal_actuator_num_struct *result_ptr)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_thermal_actuator_num_get_req(NULL, NULL, sim_ps_id, result_ptr);
}

mipc_api_result_enum mipc_sys_thermal_actuator_num_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_THERMAL_ACTUATOR_NUM_GET_CB cb, void *cb_priv_ptr)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_thermal_actuator_num_get_req(cb, cb_priv_ptr, sim_ps_id, NULL);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_thermal_actuator_set_cnf(mipc_msg_t *msg_ptr, mipc_result_enum *result_ptr)
{
    uint32_t *t_result_ptr;
    uint8_t api_error = 1;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            *result_ptr = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            *result_ptr = MIPC_RESULT_SUCCESS;
        } else {
            *result_ptr = MIPC_RESULT_FAILURE;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        *result_ptr = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_thermal_actuator_set_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_THERMAL_ACTUATOR_SET_CB cb, void *cb_priv_ptr)
{
    mipc_result_enum *result_ptr = (mipc_result_enum *)ALLOC(sizeof(mipc_result_enum));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_result_enum));
        mipc_sys_thermal_actuator_set_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_thermal_actuator_set_req(MIPC_SYS_THERMAL_ACTUATOR_SET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_result_enum *result_ptr, uint32_t actuator_id, uint32_t level)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_SET_THERMAL_ACTUATOR_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (in this case, there is no TLV parameter)
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_SYS_SET_THERMAL_ACTUATOR_REQ_T_ID, actuator_id);
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_SYS_SET_THERMAL_ACTUATOR_REQ_T_LEVEL, level);

    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_thermal_actuator_set_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_sys_thermal_actuator_set_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_thermal_actuator_set_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_result_enum *result_ptr, uint32_t actuator_id, uint32_t level)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_thermal_actuator_set_req(NULL, NULL, sim_ps_id, result_ptr, actuator_id, level);
}

mipc_api_result_enum mipc_sys_thermal_actuator_set_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_THERMAL_ACTUATOR_SET_CB cb, void *cb_priv_ptr, uint32_t actuator_id, uint32_t level)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_thermal_actuator_set_req(cb, cb_priv_ptr, sim_ps_id, NULL, actuator_id, level);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_thermal_actuator_info_get_cnf(mipc_msg_t *msg_ptr, mipc_sys_thermal_actuator_info_struct *result_ptr)
{
    uint32_t *t_result_ptr;
    void *t_val_ptr;
    uint16_t t_val_len;
    uint8_t api_error = 1;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            result_ptr->result_code = MIPC_RESULT_SUCCESS;
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_THERMAL_ACTUATOR_INFO_CNF_T_ID, NULL)) == NULL) break;
            result_ptr->actuator_id = *(uint32_t *)t_val_ptr;
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_THERMAL_ACTUATOR_INFO_CNF_T_NAME, &t_val_len)) == NULL) break;
            memcpy(&result_ptr->actuator_name[0], t_val_ptr, (t_val_len > sizeof(result_ptr->actuator_name)) ? sizeof(result_ptr->actuator_name) : t_val_len);
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_THERMAL_ACTUATOR_INFO_CNF_T_TOTAL_LEVEL, NULL)) == NULL) break;
            result_ptr->total_throttling_level = *(uint32_t *)t_val_ptr;
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_THERMAL_ACTUATOR_INFO_CNF_T_CURRENT_LEVEL, NULL)) == NULL) break;
            result_ptr->current_throttling_level = *(uint32_t *)t_val_ptr;
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_THERMAL_ACTUATOR_INFO_CNF_T_USER_IMPACT, NULL)) == NULL) break;
            result_ptr->user_impact = *(uint32_t *)t_val_ptr;
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_THERMAL_ACTUATOR_INFO_CNF_T_EFFICIENCY, NULL)) == NULL) break;
            result_ptr->efficiency = *(uint32_t *)t_val_ptr;
        } else {
            result_ptr->result_code = MIPC_RESULT_FAILURE;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_thermal_actuator_info_get_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_THERMAL_ACTUATOR_INFO_GET_CB cb, void *cb_priv_ptr)
{
    mipc_sys_thermal_actuator_info_struct *result_ptr = (mipc_sys_thermal_actuator_info_struct *)ALLOC(sizeof(mipc_sys_thermal_actuator_info_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_thermal_actuator_info_struct));
        mipc_sys_thermal_actuator_info_get_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_thermal_actuator_info_get_req(MIPC_SYS_THERMAL_ACTUATOR_INFO_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_thermal_actuator_info_struct *result_ptr, uint32_t actuator_id)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_GET_THERMAL_ACTUATOR_INFO_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (in this case, there is no TLV parameter)
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_SYS_GET_THERMAL_ACTUATOR_INFO_REQ_T_ID, actuator_id);

    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_thermal_actuator_info_get_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_sys_thermal_actuator_info_get_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_thermal_actuator_info_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_thermal_actuator_info_struct *result_ptr, uint32_t actuator_id)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_thermal_actuator_info_get_req(NULL, NULL, sim_ps_id, result_ptr, actuator_id);
}

mipc_api_result_enum mipc_sys_thermal_actuator_info_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_THERMAL_ACTUATOR_INFO_GET_CB cb, void *cb_priv_ptr, uint32_t actuator_id)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_thermal_actuator_info_get_req(cb, cb_priv_ptr, sim_ps_id, NULL, actuator_id);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_adpclk_set_cnf(mipc_msg_t *msg_ptr, mipc_sys_adpclk_set_struct *result_ptr)
{
    uint32_t *t_result_ptr;
    uint8_t api_error = 1;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            result_ptr->result_code = MIPC_RESULT_SUCCESS;
        } else {
            result_ptr->result_code = MIPC_RESULT_FAILURE;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_apdclk_set_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_ADPCLK_SET_CB cb, void *cb_priv_ptr)
{
    mipc_sys_adpclk_set_struct *result_ptr = (mipc_sys_adpclk_set_struct *)ALLOC(sizeof(mipc_sys_adpclk_set_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_adpclk_set_struct));
        mipc_sys_adpclk_set_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_adpclk_set_req(MIPC_SYS_ADPCLK_SET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_adpclk_set_struct *result_ptr, mipc_sys_adpclk_state_enum state)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_SET_ADPCLK_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SYS_SET_ADPCLK_REQ_T_STATE, state);

    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_apdclk_set_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_sys_adpclk_set_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_adpclk_set_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_adpclk_set_struct *result_ptr, mipc_sys_adpclk_state_enum state)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_adpclk_set_req(NULL, NULL, sim_ps_id, result_ptr, state);
}

mipc_api_result_enum mipc_sys_adpclk_set_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_ADPCLK_SET_CB cb, void *cb_priv_ptr, mipc_sys_adpclk_state_enum state)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_adpclk_set_req(cb, cb_priv_ptr, sim_ps_id, NULL, state);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_adpclk_get_cnf(mipc_msg_t *msg_ptr, mipc_sys_adpclk_struct *result_ptr)
{
    void* t_result_ptr;
    uint8_t api_error = MIPC_API_RESULT_FAIL;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) {
            break;
        }
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)t_result_ptr));
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            api_error = MIPC_API_RESULT_SUCCESS;
            break;
        }
        t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_ADPCLK_CNF_T_FREQ_INFO_COUNT, NULL);
        if (NULL == t_result_ptr) {
            break;
        }
        result_ptr->freq_info_count = (uint8_t)(*((uint32_t*)t_result_ptr));
        if (result_ptr->freq_info_count) {
            uint16_t list_len = 0;
            t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_ADPCLK_CNF_T_FREQ_INFO_LIST, &list_len);
            if (NULL == t_result_ptr) {
                mtkLogD(LOG_TAG, "mapping_list null\n");
                break;
            }
            MEMCPY(result_ptr->freq_info, t_result_ptr, list_len);
        }
        api_error = MIPC_API_RESULT_SUCCESS;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_apdclk_get_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_ADPCLK_GET_CB cb, void *cb_priv_ptr)
{
    mipc_sys_adpclk_struct *result_ptr = (mipc_sys_adpclk_struct *)ALLOC(sizeof(mipc_sys_adpclk_struct) + sizeof(mipc_sys_adpclk_freq_info_struct8) * 16);

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_adpclk_struct) + sizeof(mipc_sys_adpclk_freq_info_struct8) * 16);
        result_ptr->freq_info_count = 16;
        mipc_sys_adpclk_get_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_adpclk_get_req(MIPC_SYS_ADPCLK_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_adpclk_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_GET_ADPCLK_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters

    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_apdclk_get_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_sys_adpclk_get_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_adpclk_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_adpclk_struct *result_ptr)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_adpclk_get_req(NULL, NULL, sim_ps_id, result_ptr);
}

mipc_api_result_enum mipc_sys_adpclk_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_ADPCLK_GET_CB cb, void *cb_priv_ptr)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_adpclk_get_req(cb, cb_priv_ptr, sim_ps_id, NULL);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_adpclk_ind(mipc_msg_t *msg_ptr, mipc_sys_adpclk_struct *result_ptr)
{
    void* t_result_ptr;
    uint8_t api_error = MIPC_API_RESULT_FAIL;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        result_ptr->result_code = MIPC_RESULT_SUCCESS;
        t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_ADPCLK_IND_T_FREQ_INFO_COUNT, NULL);
        if (NULL == t_result_ptr) {
            break;
        }
        result_ptr->freq_info_count = (uint8_t)(*((uint32_t*)t_result_ptr));
        if (result_ptr->freq_info_count) {
            uint16_t list_len = 0;
            t_result_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_ADPCLK_IND_T_FREQ_INFO_LIST, &list_len);
            if (NULL == t_result_ptr) {
                mtkLogD(LOG_TAG, "mapping_list null\n");
                break;
            }
            MEMCPY(result_ptr->freq_info, t_result_ptr, list_len);
        }
        api_error = MIPC_API_RESULT_SUCCESS;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_adpclk_ind_cb(mipc_msg_t *msg_ptr, MIPC_SYS_ADPCLK_IND_CB cb, void *cb_priv_ptr)
{
    mipc_sys_adpclk_struct *result_ptr = (mipc_sys_adpclk_struct *)ALLOC(sizeof(mipc_sys_adpclk_struct) + sizeof(mipc_sys_adpclk_freq_info_struct8) * 16);

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_adpclk_struct) + sizeof(mipc_sys_adpclk_freq_info_struct8) * 16);
        result_ptr->freq_info_count = 16;
        if (mipc_sys_adpclk_ind(msg_ptr, result_ptr) == MIPC_API_RESULT_SUCCESS) {
            cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);
        }
        FREE(result_ptr);
    }
}

mipc_api_result_enum mipc_sys_adpclk_register(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_ADPCLK_IND_CB cb, void *cb_priv_ptr)
{
    void *callback;
    if (cb) {
        callback = (void *)mipc_sys_adpclk_ind_cb;
    } else {
        callback = NULL;
    }

    if (mipc_msg_register_ind_api((mipc_msg_sim_ps_id_enum)sim_ps_id, MIPC_SYS_ADPCLK_IND, callback, (MIPC_API_CB)cb, cb_priv_ptr) == 0) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        return MIPC_API_RESULT_FAIL;
    }
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_md_log_mode_get_cnf(mipc_msg_t *msg_ptr, mipc_sys_md_log_mode_get_struct *result_ptr)
{
    uint32_t *t_result_ptr;
    void *t_val_ptr;
    uint8_t api_error = 1;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            result_ptr->result_code = MIPC_RESULT_SUCCESS;
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_MD_LOG_MODE_CNF_T_MODE, NULL)) == NULL) break;
            result_ptr->mode = *(uint32_t *)t_val_ptr;
        } else {
            result_ptr->result_code = MIPC_RESULT_FAILURE;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_md_log_mode_get_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_MD_LOG_MODE_GET_CB cb, void *cb_priv_ptr)
{
    mipc_sys_md_log_mode_get_struct *result_ptr = (mipc_sys_md_log_mode_get_struct *)ALLOC(sizeof(mipc_sys_md_log_mode_get_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_md_log_mode_get_struct));
        mipc_sys_md_log_mode_get_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_md_log_mode_get_req(MIPC_SYS_MD_LOG_MODE_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_md_log_mode_get_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_GET_MD_LOG_MODE_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (in this case, there is no TLV parameter)

    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_md_log_mode_get_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_sys_md_log_mode_get_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_md_log_mode_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_md_log_mode_get_struct *result_ptr)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_md_log_mode_get_req(NULL, NULL, sim_ps_id, result_ptr);
}

mipc_api_result_enum mipc_sys_md_log_mode_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_MD_LOG_MODE_GET_CB cb, void *cb_priv_ptr)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_md_log_mode_get_req(cb, cb_priv_ptr, sim_ps_id, NULL);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_md_log_mode_set_cnf(mipc_msg_t *msg_ptr, mipc_sys_md_log_mode_set_struct *result_ptr)
{
    uint32_t *t_result_ptr;
    uint8_t api_error = 1;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            result_ptr->result_code = MIPC_RESULT_SUCCESS;
        } else {
            result_ptr->result_code = MIPC_RESULT_FAILURE;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_md_log_mode_set_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_MD_LOG_MODE_SET_CB cb, void *cb_priv_ptr)
{
    mipc_sys_md_log_mode_set_struct *result_ptr = (mipc_sys_md_log_mode_set_struct *)ALLOC(sizeof(mipc_sys_md_log_mode_set_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_result_enum));
        mipc_sys_md_log_mode_set_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_md_log_mode_set_req(MIPC_SYS_MD_LOG_MODE_SET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_md_log_mode_set_struct *result_ptr, uint32_t mode)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_SET_MD_LOG_MODE_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (in this case, there is no TLV parameter)
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_SYS_SET_MD_LOG_MODE_REQ_T_MODE, mode);

    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_md_log_mode_set_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_sys_md_log_mode_set_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_md_log_mode_set_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_md_log_mode_set_struct *result_ptr, uint32_t mode)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_md_log_mode_set_req(NULL, NULL, sim_ps_id, result_ptr, mode);
}

mipc_api_result_enum mipc_sys_md_log_mode_set_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_MD_LOG_MODE_SET_CB cb, void *cb_priv_ptr, uint32_t mode)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_md_log_mode_set_req(cb, cb_priv_ptr, sim_ps_id, NULL, mode);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_md_log_level_get_cnf(mipc_msg_t *msg_ptr, mipc_sys_md_log_level_get_struct *result_ptr)
{
    uint32_t *t_result_ptr;
    void *t_val_ptr;
    uint8_t api_error = 1;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            result_ptr->result_code = MIPC_RESULT_SUCCESS;
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_MD_LOG_LEVEL_CNF_T_LEVEL, NULL)) == NULL) break;
            result_ptr->level = *(uint32_t *)t_val_ptr;
        } else {
            result_ptr->result_code = MIPC_RESULT_FAILURE;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_md_log_level_get_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_MD_LOG_LEVEL_GET_CB cb, void *cb_priv_ptr)
{
    mipc_sys_md_log_level_get_struct *result_ptr = (mipc_sys_md_log_level_get_struct *)ALLOC(sizeof(mipc_sys_md_log_level_get_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_md_log_level_get_struct));
        mipc_sys_md_log_level_get_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_md_log_level_get_req(MIPC_SYS_MD_LOG_LEVEL_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_md_log_level_get_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_GET_MD_LOG_LEVEL_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (in this case, there is no TLV parameter)

    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_md_log_level_get_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_sys_md_log_level_get_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_md_log_level_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_md_log_level_get_struct *result_ptr)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_md_log_level_get_req(NULL, NULL, sim_ps_id, result_ptr);
}

mipc_api_result_enum mipc_sys_md_log_level_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_MD_LOG_LEVEL_GET_CB cb, void *cb_priv_ptr)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_md_log_level_get_req(cb, cb_priv_ptr, sim_ps_id, NULL);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_md_log_level_set_cnf(mipc_msg_t *msg_ptr, mipc_sys_md_log_level_set_struct *result_ptr)
{
    uint32_t *t_result_ptr;
    uint8_t api_error = 1;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            result_ptr->result_code = MIPC_RESULT_SUCCESS;
        } else {
            result_ptr->result_code = MIPC_RESULT_FAILURE;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_md_log_level_set_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_MD_LOG_LEVEL_SET_CB cb, void *cb_priv_ptr)
{
    mipc_sys_md_log_level_set_struct *result_ptr = (mipc_sys_md_log_level_set_struct *)ALLOC(sizeof(mipc_sys_md_log_level_set_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_result_enum));
        mipc_sys_md_log_level_set_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_md_log_level_set_req(MIPC_SYS_MD_LOG_LEVEL_SET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_md_log_level_set_struct *result_ptr, uint32_t level)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_SET_MD_LOG_LEVEL_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (in this case, there is no TLV parameter)
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_SYS_SET_MD_LOG_LEVEL_REQ_T_LEVEL, level);

    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_md_log_level_set_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_sys_md_log_level_set_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_md_log_level_set_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_md_log_level_set_struct *result_ptr, uint32_t level)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_md_log_level_set_req(NULL, NULL, sim_ps_id, result_ptr, level);
}

mipc_api_result_enum mipc_sys_md_log_level_set_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_MD_LOG_LEVEL_SET_CB cb, void *cb_priv_ptr, uint32_t level)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_md_log_level_set_req(cb, cb_priv_ptr, sim_ps_id, NULL, level);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_md_log_location_get_cnf(mipc_msg_t *msg_ptr, mipc_sys_md_log_location_get_struct *result_ptr)
{
    uint32_t *t_result_ptr;
    void *t_val_ptr;
    uint8_t api_error = 1;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            result_ptr->result_code = MIPC_RESULT_SUCCESS;
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_MD_LOG_LOCATION_CNF_T_ENABLE, NULL)) == NULL) break;
            result_ptr->enable = *(uint32_t *)t_val_ptr;
        } else {
            result_ptr->result_code = MIPC_RESULT_FAILURE;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_md_log_location_get_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_MD_LOG_LOCATION_GET_CB cb, void *cb_priv_ptr)
{
    mipc_sys_md_log_location_get_struct *result_ptr = (mipc_sys_md_log_location_get_struct *)ALLOC(sizeof(mipc_sys_md_log_location_get_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_md_log_location_get_struct));
        mipc_sys_md_log_location_get_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_md_log_location_get_req(MIPC_SYS_MD_LOG_LOCATION_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_md_log_location_get_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_GET_MD_LOG_LOCATION_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (in this case, there is no TLV parameter)

    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_md_log_location_get_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_sys_md_log_location_get_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_md_log_location_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_md_log_location_get_struct *result_ptr)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_md_log_location_get_req(NULL, NULL, sim_ps_id, result_ptr);
}

mipc_api_result_enum mipc_sys_md_log_location_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_MD_LOG_LOCATION_GET_CB cb, void *cb_priv_ptr)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_md_log_location_get_req(cb, cb_priv_ptr, sim_ps_id, NULL);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_md_log_location_set_cnf(mipc_msg_t *msg_ptr, mipc_sys_md_log_location_set_struct *result_ptr)
{
    uint32_t *t_result_ptr;
    uint8_t api_error = 1;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            result_ptr->result_code = MIPC_RESULT_SUCCESS;
        } else {
            result_ptr->result_code = MIPC_RESULT_FAILURE;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_md_log_location_set_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_MD_LOG_LOCATION_SET_CB cb, void *cb_priv_ptr)
{
    mipc_sys_md_log_location_set_struct *result_ptr = (mipc_sys_md_log_location_set_struct *)ALLOC(sizeof(mipc_sys_md_log_location_set_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_result_enum));
        mipc_sys_md_log_location_set_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_md_log_location_set_req(MIPC_SYS_MD_LOG_LOCATION_SET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_md_log_location_set_struct *result_ptr, uint32_t enable)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_SET_MD_LOG_LOCATION_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (in this case, there is no TLV parameter)
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_SYS_SET_MD_LOG_LOCATION_REQ_T_ENABLE, enable);

    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_md_log_location_set_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_sys_md_log_location_set_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_md_log_location_set_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_md_log_location_set_struct *result_ptr, uint32_t enable)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_md_log_location_set_req(NULL, NULL, sim_ps_id, result_ptr, enable);
}

mipc_api_result_enum mipc_sys_md_log_location_set_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_MD_LOG_LOCATION_SET_CB cb, void *cb_priv_ptr, uint32_t enable)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_md_log_location_set_req(cb, cb_priv_ptr, sim_ps_id, NULL, enable);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
typedef struct {
    void *cb_priv_ptr;
    uint16_t data_len;
} nvram_read_priv_t;

//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_nvram_read_cnf(mipc_msg_t *msg_ptr, mipc_sys_nvram_read_struct *result_ptr, uint16_t data_len)
{
    uint32_t *t_result_ptr;
    uint8_t *t_data_ptr;
    uint16_t t_data_len;
    uint8_t api_error = 1;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            result_ptr->result_code = MIPC_RESULT_SUCCESS;
            if ((t_data_ptr = (uint8_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_READ_NVRAM_CNF_T_DATA, &t_data_len)) == NULL) break;
            result_ptr->data_len = (t_data_len > data_len) ? data_len : t_data_len;
            memcpy(result_ptr->data, t_data_ptr, result_ptr->data_len);
        } else {
            result_ptr->result_code = MIPC_RESULT_FAILURE;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_nvram_read_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_NVRAM_READ_CB cb, void *cb_priv_ptr)
{
    nvram_read_priv_t *priv = (nvram_read_priv_t *)cb_priv_ptr;
    mipc_sys_nvram_read_struct *result_ptr = (mipc_sys_nvram_read_struct *)ALLOC(sizeof(mipc_sys_nvram_read_struct) + priv->data_len);

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_nvram_read_struct) + priv->data_len);
        mipc_sys_nvram_read_cnf(msg_ptr, result_ptr, priv->data_len);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, priv->cb_priv_ptr);

    FREE(cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_nvram_read_req(MIPC_SYS_NVRAM_READ_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_nvram_read_struct *result_ptr, uint32_t file_idx, uint32_t record_idx, uint16_t data_len)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_READ_NVRAM_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (in this case, there is no TLV parameter)
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_SYS_READ_NVRAM_REQ_T_FILE_IDX, file_idx);
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_SYS_READ_NVRAM_REQ_T_RECORD_IDX, record_idx);

    //SETP3: send to MD
    if (cb) {//async.
        nvram_read_priv_t *priv = (nvram_read_priv_t *)ALLOC(sizeof(nvram_read_priv_t));
        priv->cb_priv_ptr = cb_priv_ptr;
        priv->data_len = data_len;

        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_nvram_read_cnf_cb, (MIPC_API_CB)cb, priv);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_sys_nvram_read_cnf(msg_cnf_ptr, result_ptr, data_len);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_nvram_read_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_nvram_read_struct *result_ptr, uint32_t file_idx, uint32_t record_idx, uint16_t data_len)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_nvram_read_req(NULL, NULL, sim_ps_id, result_ptr, file_idx, record_idx, data_len);
}

mipc_api_result_enum mipc_sys_nvram_read_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_NVRAM_READ_CB cb, void *cb_priv_ptr, uint32_t file_idx, uint32_t record_idx, uint16_t data_len)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_nvram_read_req(cb, cb_priv_ptr, sim_ps_id, NULL, file_idx, record_idx, data_len);
}

/////////////////////////////////////////////////////////////////////////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_nvram_write_cnf(mipc_msg_t *msg_ptr, mipc_sys_nvram_write_struct *result_ptr)
{
    uint32_t *t_result_ptr;
    uint32_t *t_data_len_ptr;
    uint8_t api_error = 1;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            if ((t_data_len_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_WRITE_NVRAM_CNF_T_DATA_LEN, NULL)) == NULL) break;
            result_ptr->data_len = *t_data_len_ptr;
        } else {
        }
        result_ptr->result_code = (mipc_result_enum) * t_result_ptr;
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_nvram_write_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_NVRAM_WRITE_CB cb, void *cb_priv_ptr)
{
    mipc_sys_nvram_write_struct *result_ptr = (mipc_sys_nvram_write_struct *)ALLOC(sizeof(mipc_sys_nvram_write_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_nvram_write_struct));
        mipc_sys_nvram_write_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_nvram_write_req(MIPC_SYS_NVRAM_WRITE_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_nvram_write_struct *result_ptr, uint32_t file_idx, uint32_t record_idx, uint16_t data_len, uint8_t data_ptr[60000])
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_WRITE_NVRAM_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (in this case, there is no TLV parameter)
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_SYS_WRITE_NVRAM_REQ_T_FILE_IDX, file_idx);
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_SYS_WRITE_NVRAM_REQ_T_RECORD_IDX, record_idx);
    mipc_msg_add_tlv(msg_req_ptr, MIPC_SYS_WRITE_NVRAM_REQ_T_DATA, data_len, data_ptr);

    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_nvram_write_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_sys_nvram_write_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_nvram_write_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_nvram_write_struct *result_ptr, uint32_t file_idx, uint32_t record_idx, uint16_t data_len, uint8_t data_ptr[60000])
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_nvram_write_req(NULL, NULL, sim_ps_id, result_ptr, file_idx, record_idx, data_len, data_ptr);
}

mipc_api_result_enum mipc_sys_nvram_write_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_NVRAM_WRITE_CB cb, void *cb_priv_ptr, uint32_t file_idx, uint32_t record_idx, uint16_t data_len, uint8_t data_ptr[60000])
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_nvram_write_req(cb, cb_priv_ptr, sim_ps_id, NULL, file_idx, record_idx, data_len, data_ptr);
}
/////////////////////////////////////////////////////////////////////////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_auth_cnf(mipc_msg_t *msg_ptr, mipc_sys_auth_struct *result_ptr)
{
    uint32_t *t_result_ptr;
    uint8_t *t_data_ptr;
    uint8_t api_error = 1;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            result_ptr->result_code = MIPC_RESULT_SUCCESS;
            if ((t_data_ptr = (uint8_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_AUTH_CNF_T_RAND, NULL))) {
                memcpy(result_ptr->rand, t_data_ptr, 16);
            }
        } else {
            result_ptr->result_code = MIPC_RESULT_FAILURE;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_auth_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_AUTH_CB cb, void *cb_priv_ptr)
{
    mipc_sys_auth_struct *result_ptr = (mipc_sys_auth_struct *)ALLOC(sizeof(mipc_sys_auth_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_auth_struct));
        mipc_sys_auth_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_auth_req(MIPC_SYS_AUTH_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_auth_struct *result_ptr, mipc_sys_auth_op_enum op, uint8_t data_ptr[256])
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_AUTH_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (in this case, there is no TLV parameter)
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_SYS_AUTH_REQ_T_OP, op);
    if (op == MIPC_SYS_ENUM_AUTH_OP_VERIFY) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_SYS_AUTH_REQ_T_ENCDATA, 256, data_ptr);
    }

    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_auth_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_sys_auth_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_auth_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_auth_struct *result_ptr, mipc_sys_auth_op_enum op, uint8_t data_ptr[256])
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_auth_req(NULL, NULL, sim_ps_id, result_ptr, op, data_ptr);
}

mipc_api_result_enum mipc_sys_auth_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_AUTH_CB cb, void *cb_priv_ptr, mipc_sys_auth_op_enum op, uint8_t data_ptr[256])
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_auth_req(cb, cb_priv_ptr, sim_ps_id, NULL, op, data_ptr);
}
/////////////////////////////////////////////////////////////////////////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_dat_set_cnf(mipc_msg_t *msg_ptr, mipc_sys_dat_set_struct *result_ptr)
{
    uint32_t *t_result_ptr;
    uint8_t *t_data_ptr;
    uint8_t api_error = 1;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            result_ptr->result_code = MIPC_RESULT_SUCCESS;
        } else {
            result_ptr->result_code = MIPC_RESULT_FAILURE;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_dat_set_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_DAT_SET_CB cb, void *cb_priv_ptr)
{
    mipc_sys_dat_set_struct *result_ptr = (mipc_sys_dat_set_struct *)ALLOC(sizeof(mipc_sys_dat_set_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_dat_set_struct));
        mipc_sys_dat_set_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_dat_set_req(MIPC_SYS_DAT_SET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_dat_set_struct *result_ptr, uint32_t index)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_SET_DAT_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (in this case, there is no TLV parameter)
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_SYS_SET_DAT_REQ_T_INDEX, index );

    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_dat_set_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_sys_dat_set_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_dat_set_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_dat_set_struct *result_ptr, uint32_t index)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_dat_set_req(NULL, NULL, sim_ps_id, result_ptr, index);
}

mipc_api_result_enum mipc_sys_dat_set_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_DAT_SET_CB cb, void *cb_priv_ptr, uint32_t index)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_dat_set_req(cb, cb_priv_ptr, sim_ps_id, NULL, index);
}
/////////////////////////////////////////////////////////////////////////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_time_set_cnf(mipc_msg_t *msg_ptr, mipc_sys_time_set_struct *result_ptr)
{
    uint32_t *t_result_ptr;
    uint8_t *t_data_ptr;
    uint8_t api_error = 1;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            result_ptr->result_code = MIPC_RESULT_SUCCESS;
        } else {
            result_ptr->result_code = MIPC_RESULT_FAILURE;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_time_set_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_TIME_SET_CB cb, void *cb_priv_ptr)
{
    mipc_sys_time_set_struct *result_ptr = (mipc_sys_time_set_struct *)ALLOC(sizeof(mipc_sys_time_set_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_time_set_struct));
        mipc_sys_time_set_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_time_set_req(MIPC_SYS_TIME_SET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_time_set_struct *result_ptr, uint32_t year, uint32_t month, uint32_t day, uint32_t hour, uint32_t minute, uint32_t second)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_SET_TIME_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (in this case, there is no TLV parameter)
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_SYS_SET_TIME_REQ_T_YEAR, year);
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_SYS_SET_TIME_REQ_T_MONTH, month);
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_SYS_SET_TIME_REQ_T_DAY, day);
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_SYS_SET_TIME_REQ_T_HOUR, hour);
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_SYS_SET_TIME_REQ_T_MINUTE, minute);
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_SYS_SET_TIME_REQ_T_SECOND, second);

    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_time_set_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_sys_time_set_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_time_set_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_time_set_struct *result_ptr, uint32_t year, uint32_t month, uint32_t day, uint32_t hour, uint32_t minute, uint32_t second)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_time_set_req(NULL, NULL, sim_ps_id, result_ptr, year, month, day, hour, minute, second);
}

mipc_api_result_enum mipc_sys_time_set_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_TIME_SET_CB cb, void *cb_priv_ptr, uint32_t year, uint32_t month, uint32_t day, uint32_t hour, uint32_t minute, uint32_t second)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_time_set_req(cb, cb_priv_ptr, sim_ps_id, NULL, year, month, day, hour, minute, second);
}
/////////////////////////////////////////////////////////////////////////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_time_get_cnf(mipc_msg_t *msg_ptr, mipc_sys_time_get_struct *result_ptr)
{
    uint32_t *t_result_ptr;
    void *t_val_ptr;
    uint8_t api_error = 1;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_TIME_CNF_T_YEAR, NULL)) == NULL) break;
            result_ptr->year = *(uint32_t *)t_val_ptr;
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_TIME_CNF_T_MONTH, NULL)) == NULL) break;
            result_ptr->month = *(uint32_t *)t_val_ptr;
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_TIME_CNF_T_DAY, NULL)) == NULL) break;
            result_ptr->day = *(uint32_t *)t_val_ptr;
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_TIME_CNF_T_HOUR, NULL)) == NULL) break;
            result_ptr->hour = *(uint32_t *)t_val_ptr;
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_TIME_CNF_T_MINUTE, NULL)) == NULL) break;
            result_ptr->minute = *(uint32_t *)t_val_ptr;
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_TIME_CNF_T_SECOND, NULL)) == NULL) break;
            result_ptr->second = *(uint32_t *)t_val_ptr;
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_TIME_CNF_T_TIMESTAMP, NULL)) == NULL) break;
            result_ptr->timestamp = *(uint32_t *)t_val_ptr;
            //
            result_ptr->result_code = MIPC_RESULT_SUCCESS;
        } else {
            result_ptr->result_code = MIPC_RESULT_FAILURE;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_time_get_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_TIME_GET_CB cb, void *cb_priv_ptr)
{
    mipc_sys_time_get_struct *result_ptr = (mipc_sys_time_get_struct *)ALLOC(sizeof(mipc_sys_time_get_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_time_get_struct));
        mipc_sys_time_get_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_time_get_req(MIPC_SYS_TIME_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_time_get_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_GET_TIME_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (in this case, there is no TLV parameter)

    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_time_get_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_sys_time_get_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_time_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_time_get_struct *result_ptr)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_time_get_req(NULL, NULL, sim_ps_id, result_ptr);
}

mipc_api_result_enum mipc_sys_time_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_TIME_GET_CB cb, void *cb_priv_ptr)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_time_get_req(cb, cb_priv_ptr, sim_ps_id, NULL);
}
/////////////////////////////////////////////////////////////////////////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_sar_set_cnf(mipc_msg_t *msg_ptr, mipc_sys_sar_set_struct *result_ptr)
{
    uint32_t *t_result_ptr;
    void *t_val_ptr;
    uint8_t api_error = 1;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_SET_SAR_CNF_T_MODE, NULL)) == NULL) break;
            result_ptr->mode = (mipc_sys_sar_mode_const_enum) * (uint8_t *)t_val_ptr;
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_SET_SAR_CNF_T_INDEX, NULL)) == NULL) break;
            result_ptr->index = *(uint32_t *)t_val_ptr;

            result_ptr->result_code = MIPC_RESULT_SUCCESS;
        } else {
            result_ptr->result_code = MIPC_RESULT_FAILURE;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_sar_set_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_SAR_SET_CB cb, void *cb_priv_ptr)
{
    mipc_sys_sar_set_struct *result_ptr = (mipc_sys_sar_set_struct *)ALLOC(sizeof(mipc_sys_sar_set_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_sar_set_struct));
        mipc_sys_sar_set_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_sar_set_req(MIPC_SYS_SAR_SET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_sar_set_struct *result_ptr, mipc_sys_sar_mode_const_enum mode, uint32_t index)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_SET_SAR_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (in this case, there is no TLV parameter)
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_SYS_SET_SAR_REQ_T_MODE, mode);
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_SYS_SET_SAR_REQ_T_INDEX, index);

    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_sar_set_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_sys_sar_set_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_sar_set_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_sar_set_struct *result_ptr, mipc_sys_sar_mode_const_enum mode, uint32_t index)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_sar_set_req(NULL, NULL, sim_ps_id, result_ptr, mode, index);
}

mipc_api_result_enum mipc_sys_sar_set_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_SAR_SET_CB cb, void *cb_priv_ptr, mipc_sys_sar_mode_const_enum mode, uint32_t index)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_sar_set_req(cb, cb_priv_ptr, sim_ps_id, NULL, mode, index);
}
/////////////////////////////////////////////////////////////////////////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_sar_get_cnf(mipc_msg_t *msg_ptr, mipc_sys_sar_get_struct *result_ptr)
{
    uint32_t *t_result_ptr;
    void *t_val_ptr;
    uint8_t api_error = 1;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_SAR_CNF_T_MODE, NULL)) == NULL) break;
            result_ptr->mode = (mipc_sys_sar_mode_const_enum) * (uint8_t *)t_val_ptr;
            if ((t_val_ptr = mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_SAR_CNF_T_INDEX, NULL)) == NULL) break;
            result_ptr->index = *(uint32_t *)t_val_ptr;

            result_ptr->result_code = MIPC_RESULT_SUCCESS;
        } else {
            result_ptr->result_code = MIPC_RESULT_FAILURE;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_sar_get_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_SAR_GET_CB cb, void *cb_priv_ptr)
{
    mipc_sys_sar_get_struct *result_ptr = (mipc_sys_sar_get_struct *)ALLOC(sizeof(mipc_sys_sar_get_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_sar_get_struct));
        mipc_sys_sar_get_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_sar_get_req(MIPC_SYS_SAR_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_sar_get_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_GET_SAR_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (in this case, there is no TLV parameter)

    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_sar_get_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_sys_sar_get_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_sar_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_sar_get_struct *result_ptr)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_sar_get_req(NULL, NULL, sim_ps_id, result_ptr);
}

mipc_api_result_enum mipc_sys_sar_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_SAR_GET_CB cb, void *cb_priv_ptr)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_sar_get_req(cb, cb_priv_ptr, sim_ps_id, NULL);
}
/////////////////////////////////////////////////////////////////////////////////////////////////////
typedef struct {
    void *cb_priv_ptr;
    uint16_t data_len;
} config_get_priv_t;

//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_config_get_cnf(mipc_msg_t *msg_ptr, mipc_sys_config_get_struct *result_ptr, uint16_t data_len)
{
    uint32_t *t_result_ptr;
    uint8_t *t_data_ptr;
    uint16_t t_data_len;
    uint8_t api_error = 1;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            result_ptr->result_code = MIPC_RESULT_SUCCESS;
            if ((t_data_ptr = (uint8_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_SYS_GET_CONFIG_CNF_T_DATA, &t_data_len)) == NULL) break;
            result_ptr->data_len = (t_data_len > data_len) ? data_len : t_data_len;
            memcpy(result_ptr->data, t_data_ptr, result_ptr->data_len);
        } else {
            result_ptr->result_code = MIPC_RESULT_FAILURE;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_config_get_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_CONFIG_GET_CB cb, void *cb_priv_ptr)
{
    config_get_priv_t *priv = (config_get_priv_t *)cb_priv_ptr;
    mipc_sys_config_get_struct *result_ptr = (mipc_sys_config_get_struct *)ALLOC(sizeof(mipc_sys_config_get_struct) + priv->data_len);

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_config_get_struct) + priv->data_len);
        mipc_sys_config_get_cnf(msg_ptr, result_ptr, priv->data_len);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, priv->cb_priv_ptr);

    FREE(cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_config_get_req(MIPC_SYS_CONFIG_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_config_get_struct *result_ptr, mipc_sys_config_class_enum config_class, char config_type_ptr[32], uint16_t data_len)
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_GET_CONFIG_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (in this case, there is no TLV parameter)
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_SYS_GET_CONFIG_REQ_T_CLASS, config_class);
    mipc_msg_add_tlv(msg_req_ptr, MIPC_SYS_GET_CONFIG_REQ_T_TYPE, strlen(config_type_ptr) + 1, config_type_ptr);

    //SETP3: send to MD
    if (cb) {//async.
        config_get_priv_t *priv = (config_get_priv_t *)ALLOC(sizeof(config_get_priv_t));
        priv->cb_priv_ptr = cb_priv_ptr;
        priv->data_len = data_len;

        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_config_get_cnf_cb, (MIPC_API_CB)cb, priv);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_sys_config_get_cnf(msg_cnf_ptr, result_ptr, data_len);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_config_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_config_get_struct *result_ptr, mipc_sys_config_class_enum config_class, char config_type_ptr[32], uint16_t data_len)
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_config_get_req(NULL, NULL, sim_ps_id, result_ptr, config_class, config_type_ptr, data_len);
}

mipc_api_result_enum mipc_sys_config_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_CONFIG_GET_CB cb, void *cb_priv_ptr, mipc_sys_config_class_enum config_class, char config_type_ptr[32], uint16_t data_len)
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_config_get_req(cb, cb_priv_ptr, sim_ps_id, NULL, config_class, config_type_ptr, data_len);
}


/////////////////////////////////////////////////////////////////////////////////////////////////////
//fill result_ptr according to msg_ptr
static mipc_api_result_enum mipc_sys_config_set_cnf(mipc_msg_t *msg_ptr, mipc_sys_config_set_struct *result_ptr)
{
    uint32_t *t_result_ptr;
    uint8_t api_error = 1;

    if (msg_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
        if (*t_result_ptr == 0) { // SUCCESS
            result_ptr->result_code = MIPC_RESULT_SUCCESS;
        } else {
            result_ptr->result_code = MIPC_RESULT_FAILURE;
        }
        api_error = 0;
    } while (0);

    if (api_error) {
        result_ptr->result_code = MIPC_RESULT_FAILURE;
        return MIPC_API_RESULT_FAIL;
    } else {
        return MIPC_API_RESULT_SUCCESS;
    }
}

static void mipc_sys_config_set_cnf_cb(mipc_msg_t *msg_ptr, MIPC_SYS_CONFIG_SET_CB cb, void *cb_priv_ptr)
{
    mipc_sys_config_set_struct *result_ptr = (mipc_sys_config_set_struct *)ALLOC(sizeof(mipc_sys_config_set_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_sys_config_set_struct));
        mipc_sys_config_set_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    FREE(cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_sys_config_set_req(MIPC_SYS_CONFIG_SET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_sys_config_set_struct *result_ptr, mipc_sys_config_class_enum config_class, char config_type_ptr[32], uint16_t data_len, uint8_t data_ptr[60000])
{
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_SET_CONFIG_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    //SETP2: add paramters (in this case, there is no TLV parameter)
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_SYS_SET_CONFIG_REQ_T_CLASS, config_class);
    mipc_msg_add_tlv(msg_req_ptr, MIPC_SYS_SET_CONFIG_REQ_T_TYPE, strlen(config_type_ptr) + 1, config_type_ptr);
    mipc_msg_add_tlv(msg_req_ptr, MIPC_SYS_SET_CONFIG_REQ_T_DATA, data_len, data_ptr);

    //SETP3: send to MD
    if (cb) {//async.
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_sys_config_set_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
    } else {//sync.
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    }

    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    if (cb) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        ret = mipc_sys_config_set_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_sys_config_set_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_sys_config_set_struct *result_ptr, mipc_sys_config_class_enum config_class, char config_type_ptr[32], uint16_t data_len, uint8_t data_ptr[60000])
{
    //SETP0: check input
    if (result_ptr == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_config_set_req(NULL, NULL, sim_ps_id, result_ptr, config_class, config_type_ptr, data_len, data_ptr);
}

mipc_api_result_enum mipc_sys_config_set_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_SYS_CONFIG_SET_CB cb, void *cb_priv_ptr, mipc_sys_config_class_enum config_class, char config_type_ptr[32], uint16_t data_len, uint8_t data_ptr[60000])
{
    //SETP0: check input
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_sys_config_set_req(cb, cb_priv_ptr, sim_ps_id, NULL, config_class, config_type_ptr, data_len, data_ptr);
}
