/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
 /*
  * RfxParcelTranfer.cpp
  *
  *  Created on: 2018/08/21
  *  Author: MTK06564
  *
  */
#include "RfxParcelTransfer.h"
#include "RfxParcelTransferUtils.h"
#if defined(__ANDROID__)
#include <cutils/properties.h>
#else
#include <sncfg/local_system_properties.h>
#endif
#include "ril.h"  //Note, This Ril.h is privide by libvendor-ril
#define LOG_TAG "RfxParcelTransfer"
#define RIL_UNSOL_NOT_SUPPORT -1


static ReqParcelTransferInfo s_parcel_transfer_request[] = {
    #include "parcel_transfer_ril_commands.h"
};
static ReqParcelTransferInfo s_parcel_transfer_mtk_request[] = {
    #include "parcel_transfer_mtk_ril_commands.h"
};
static ReqParcelTransferInfo s_parcel_transfer_mtk_ivt_request[] = {
    #include "parcel_transfer_mtk_ivt_ril_commands.h"
};
static UnsolParcelTransferInfo s_parcel_transfer_urc[] = {
    #include "parcel_transfer_unsol_commands.h"
};
static UnsolParcelTransferInfo s_parcel_transfer_mtk_urc[] = {
    #include "parcel_transfer_mtk_unsol_commands.h"
};
static UnsolParcelTransferInfo s_parcel_transfer_mtk_ivt_urc[] = {
    #include "parcel_transfer_mtk_ivt_unsol_commands.h"
};

#ifdef HAVE_AEE_FEATURE
void triggerNE(char *pErrMsg) {
    if (pErrMsg != NULL) {
        aee_system_exception("ril-proxy", NULL, DB_OPT_DEFAULT, pErrMsg);
        exit(0);
    } else {
        assert(0);
    }
}
#endif


int RfxParcelTransfer::requsetIdTransfer(int requset){
    switch (requset) {
    case RIL_REQUEST_MODEM_POWERON :
        return (RIL_REQUEST_VENDOR_BASE + 3); //align with telephonyware ril.h
    //-->todo
    case  RIL_REQUEST_GET_COLP:
    	return (RIL_REQUEST_VENDOR_BASE + 104);
    case  RIL_REQUEST_SET_COLP:
    	return (RIL_REQUEST_VENDOR_BASE + 113);
    case  RIL_REQUEST_GET_COLR:
    	return (RIL_REQUEST_VENDOR_BASE + 105);
    case  RIL_REQUEST_HANGUP_ALL:
    	return (RIL_REQUEST_VENDOR_BASE + 19);
    case  RIL_REQUEST_FORCE_RELEASE_CALL:
    	return (RIL_REQUEST_VENDOR_BASE + 34);
    case  RIL_REQUEST_EMERGENCY_DIAL:
    	return (RIL_REQUEST_VENDOR_BASE + 17);
    case  RIL_REQUEST_SET_ECC_SERVICE_CATEGORY:
    	return (RIL_REQUEST_VENDOR_BASE + 18);
    case  RIL_REQUEST_SET_ECC_LIST:
    	return (RIL_REQUEST_VENDOR_BASE + 30);
    case  RIL_REQUEST_SET_CLIP:
    	return (RIL_REQUEST_VENDOR_BASE + 103);
    case  RIL_REQUEST_ADD_IMS_CONFERENCE_CALL_MEMBER:
    	return (RIL_REQUEST_VENDOR_BASE + 90);
    case  RIL_REQUEST_REMOVE_IMS_CONFERENCE_CALL_MEMBER:
    	return (RIL_REQUEST_VENDOR_BASE + 91);
    case  RIL_REQUEST_DIAL_WITH_SIP_URI:
    	return (RIL_REQUEST_VENDOR_BASE + 86);
    case  RIL_REQUEST_RESUME_CALL:
    	return (RIL_REQUEST_VENDOR_BASE + 85);
    case  RIL_REQUEST_SET_CALL_INDICATION:
    	return (RIL_REQUEST_VENDOR_BASE + 16);
    case  RIL_REQUEST_CONFERENCE_DIAL:
    	return (RIL_REQUEST_VENDOR_BASE + 89);
    case  RIL_REQUEST_HOLD_CALL:
    	return (RIL_REQUEST_VENDOR_BASE + 84);
    case  RIL_REQUEST_SET_IMS_ENABLE:
    	return (RIL_REQUEST_VENDOR_BASE + 69);
    case RIL_REQUEST_START_KEEPALIVE_PRO:
        return (RIL_REQUEST_VENDOR_BASE + 173);
    case RIL_REQUEST_STOP_KEEPALIVE_PRO:
        return (RIL_REQUEST_VENDOR_BASE + 174);
    case RIL_REQUEST_QUERY_ICCID:
        return (RIL_REQUEST_VENDOR_BASE + 142);
    case RIL_REQUEST_SYNC_DATA_SETTINGS_TO_MD:
        return (RIL_REQUEST_VENDOR_BASE + 62);
    case RIL_REQUEST_SEND_USSI:
	return (RIL_REQUEST_VENDOR_BASE + 93);
    case RIL_REQUEST_CANCEL_USSI:
	return (RIL_REQUEST_VENDOR_BASE + 94);
    case RIL_REQUEST_SET_IMSCFG:
        return (RIL_REQUEST_VENDOR_BASE + 77);
    case RIL_REQUEST_REPORT_AIRPLANE_MODE:
        return (RIL_REQUEST_VENDOR_BASE + 154);
    case RIL_REQUEST_GET_SMS_SIM_MEM_STATUS:
        return (RIL_REQUEST_VENDOR_BASE + 11);
    case RIL_REQUEST_SET_ECC_NUM:
        return (RIL_REQUEST_VENDOR_BASE + 148);
    case RIL_REQUEST_GET_ECC_NUM:
        return (RIL_REQUEST_VENDOR_BASE + 149);
    case RIL_REQUEST_GSM_GET_BROADCAST_LANGUAGE:
        return (RIL_REQUEST_VENDOR_BASE + 10);
    case RIL_REQUEST_GSM_SET_BROADCAST_LANGUAGE:
        return (RIL_REQUEST_VENDOR_BASE +9);
    case RIL_REQUEST_QUERY_AVAILABLE_NETWORKS_WITH_ACT:
        return (RIL_REQUEST_VENDOR_BASE + 6);
    case RIL_REQUEST_QUERY_EID:
        return (RIL_REQUEST_VENDOR_BASE + 176);
    case RIL_REQUEST_QUERY_SIM_RETRY_COUNT:
        return (RIL_REQUEST_VENDOR_BASE + 177);
    default:
        return requset;
    }
}

int RfxParcelTransfer::unsolIdTransfer(int unsol){
    switch (unsol) {
	case  (RIL_UNSOL_VENDOR_BASE + 0):
		return RIL_UNSOL_RESPONSE_PLMN_CHANGED;
	case  (RIL_UNSOL_VENDOR_BASE + 1):
		return RIL_UNSOL_RESPONSE_REGISTRATION_SUSPENDED;
	case  (RIL_UNSOL_VENDOR_BASE + 2):
		return RIL_UNSOL_RESPONSE_PS_NETWORK_STATE_CHANGED;
	case  (RIL_UNSOL_VENDOR_BASE + 3):
		return RIL_UNSOL_GMSS_RAT_CHANGED;
	case  (RIL_UNSOL_VENDOR_BASE + 4):
		return RIL_UNSOL_CDMA_PLMN_CHANGED;
	case  (RIL_UNSOL_VENDOR_BASE + 5):
		return RIL_UNSOL_VIRTUAL_SIM_ON;
	case  (RIL_UNSOL_VENDOR_BASE + 6):
		return RIL_UNSOL_VIRTUAL_SIM_OFF;
	case  (RIL_UNSOL_VENDOR_BASE + 7):
		return RIL_UNSOL_IMEI_LOCK;
	case  (RIL_UNSOL_VENDOR_BASE + 8):
		return RIL_UNSOL_IMSI_REFRESH_DONE;
	case  (RIL_UNSOL_VENDOR_BASE + 9):
		return RIL_UNSOL_ATCI_RESPONSE;
	case  (RIL_UNSOL_VENDOR_BASE + 10):
		return RIL_UNSOL_RESPONSE_ETWS_NOTIFICATION;
	case  (RIL_UNSOL_VENDOR_BASE + 11):
		return RIL_UNSOL_ME_SMS_STORAGE_FULL;
	case  (RIL_UNSOL_VENDOR_BASE + 12):
		return RIL_UNSOL_SMS_READY_NOTIFICATION;
	case  (RIL_UNSOL_VENDOR_BASE + 14):
		return RIL_UNSOL_DATA_ALLOWED;
	case  (RIL_UNSOL_VENDOR_BASE + 15):
		return RIL_UNSOL_INCOMING_CALL_INDICATION;
	case  (RIL_UNSOL_VENDOR_BASE + 16):
		return RIL_UNSOL_INVALID_SIM;
	case  (RIL_UNSOL_VENDOR_BASE + 18):
		return RIL_UNSOL_NETWORK_EVENT;
	case  (RIL_UNSOL_VENDOR_BASE + 19):
		return RIL_UNSOL_MODULATION_INFO;
	case  (RIL_UNSOL_VENDOR_BASE + 21):
		return RIL_UNSOL_DATA_ATTACH_APN_CHANGED;
	case  (RIL_UNSOL_VENDOR_BASE + 22):
		return RIL_UNSOL_WORLD_MODE_CHANGED;
	case  (RIL_UNSOL_VENDOR_BASE + 24):
		return RIL_UNSOL_CIPHER_INDICATION;
	case  (RIL_UNSOL_VENDOR_BASE + 25):
		return RIL_UNSOL_CRSS_NOTIFICATION;
	case  (RIL_UNSOL_VENDOR_BASE + 26):
		return RIL_UNSOL_VT_STATUS_INFO;
	case  (RIL_UNSOL_VENDOR_BASE + 27):
		return RIL_UNSOL_SPEECH_CODEC_INFO;
	case  (RIL_UNSOL_VENDOR_BASE + 28):
		return RIL_UNSOL_PHB_READY_NOTIFICATION;
	case  (RIL_UNSOL_VENDOR_BASE + 29):
		return RIL_UNSOL_FEMTOCELL_INFO;
	case  (RIL_UNSOL_VENDOR_BASE + 30):
		return RIL_UNSOL_NETWORK_INFO;
	case  (RIL_UNSOL_VENDOR_BASE + 31):
		return RIL_UNSOL_CALL_INFO_INDICATION;
	case  (RIL_UNSOL_VENDOR_BASE + 32):
		return RIL_UNSOL_ECONF_RESULT_INDICATION;
	case  (RIL_UNSOL_VENDOR_BASE + 33):
		return RIL_UNSOL_SIP_CALL_PROGRESS_INDICATOR;
	case  (RIL_UNSOL_VENDOR_BASE + 34):
		return RIL_UNSOL_CALLMOD_CHANGE_INDICATOR;
	case  (RIL_UNSOL_VENDOR_BASE + 35):
		return RIL_UNSOL_VIDEO_CAPABILITY_INDICATOR;
	case  (RIL_UNSOL_VENDOR_BASE + 36):
		return RIL_UNSOL_ON_USSI;
	case  (RIL_UNSOL_VENDOR_BASE + 41):
		return RIL_UNSOL_IMS_REGISTRATION_INFO;
	case  (RIL_UNSOL_VENDOR_BASE + 42):
		return RIL_UNSOL_IMS_ENABLE_DONE;
	case  (RIL_UNSOL_VENDOR_BASE + 43):
		return RIL_UNSOL_IMS_DISABLE_DONE;
	case  (RIL_UNSOL_VENDOR_BASE + 44):
		return RIL_UNSOL_IMS_ENABLE_START;
	case  (RIL_UNSOL_VENDOR_BASE + 45):
		return RIL_UNSOL_IMS_DISABLE_START;
	case  (RIL_UNSOL_VENDOR_BASE + 52):
		return RIL_UNSOL_IMS_DEREG_DONE;
	case  (RIL_UNSOL_VENDOR_BASE + 56):
		return RIL_UNSOL_MELOCK_NOTIFICATION;
	case  (RIL_UNSOL_VENDOR_BASE + 57):
		return RIL_UNSOL_STK_BIP_PROACTIVE_COMMAND;
	case  (RIL_UNSOL_VENDOR_BASE + 58):
		return RIL_UNSOL_TRIGGER_OTASP;
	case  (RIL_UNSOL_VENDOR_BASE + 60):
		return RIL_UNSOL_REMOVE_RESTRICT_EUTRAN;
	case  (RIL_UNSOL_VENDOR_BASE + 61):
		return RIL_UNSOL_PCO_STATUS;
	case  (RIL_UNSOL_VENDOR_BASE + 62):
		return RIL_UNSOL_LTE_ACCESS_STRATUM_STATE_CHANGE;
	case  (RIL_UNSOL_VENDOR_BASE + 63):
		return RIL_UNSOL_SIM_PLUG_IN;
	case  (RIL_UNSOL_VENDOR_BASE + 64):
		return RIL_UNSOL_SIM_PLUG_OUT;
	case  (RIL_UNSOL_VENDOR_BASE + 65):
		return RIL_UNSOL_SIM_MISSING;
	case  (RIL_UNSOL_VENDOR_BASE + 66):
		return RIL_UNSOL_SIM_RECOVERY;
	case  (RIL_UNSOL_VENDOR_BASE + 67):
		return RIL_UNSOL_TRAY_PLUG_IN;
	case  (RIL_UNSOL_VENDOR_BASE + 68):
		return RIL_UNSOL_SIM_COMMON_SLOT_NO_CHANGED;
	case  (RIL_UNSOL_VENDOR_BASE + 69):
		return RIL_UNSOL_CDMA_CALL_ACCEPTED;
	case  (RIL_UNSOL_VENDOR_BASE + 70):
		return RIL_UNSOL_CALL_FORWARDING;
	case  (RIL_UNSOL_VENDOR_BASE + 71):
		return RIL_UNSOL_STK_SETUP_MENU_RESET;
	case  (RIL_UNSOL_VENDOR_BASE + 72):
		return RIL_UNSOL_ECONF_SRVCC_INDICATION;
	case  (RIL_UNSOL_VENDOR_BASE + 74):
		return RIL_UNSOL_VSIM_OPERATION_INDICATION;
	case  (RIL_UNSOL_VENDOR_BASE + 75):
		return RIL_UNSOL_DEDICATE_BEARER_ACTIVATED;
	case  (RIL_UNSOL_VENDOR_BASE + 76):
		return RIL_UNSOL_DEDICATE_BEARER_MODIFIED;
	case  (RIL_UNSOL_VENDOR_BASE + 77):
		return RIL_UNSOL_DEDICATE_BEARER_DEACTIVATED;
	case  (RIL_UNSOL_VENDOR_BASE + 108):
		return RIL_UNSOL_EMERGENCY_BEARER_SUPPORT_NOTIFY;
	case  (RIL_LOCAL_GSM_UNSOL_VENDOR_BASE + 10):
		return RIL_LOCAL_GSM_UNSOL_MAL_DATA_CALL_LIST_CHANGED;
	case  (RIL_LOCAL_GSM_UNSOL_VENDOR_BASE + 11):
		return RIL_LOCAL_GSM_UNSOL_EMBMS_START_SESSION_RESPONSE;
        case (RIL_UNSOL_VENDOR_BASE + 90):
                return RIL_UNSOL_TX_POWER;
        case (RIL_UNSOL_VENDOR_BASE + 112):
                return RIL_UNSOL_KEEPALIVE_STATUS_PRO;
    case  (RIL_UNSOL_VENDOR_BASE + 101):
        return RIL_UNSOL_ECC_NUM;
	case  (RIL_UNSOL_VENDOR_BASE + 17):
	case  (RIL_UNSOL_VENDOR_BASE + 20):
	case  (RIL_UNSOL_VENDOR_BASE + 23):
	case  (RIL_UNSOL_VENDOR_BASE + 37):
	case  (RIL_UNSOL_VENDOR_BASE + 38):
	case  (RIL_UNSOL_VENDOR_BASE + 39):
	case  (RIL_UNSOL_VENDOR_BASE + 40):
	case  (RIL_UNSOL_VENDOR_BASE + 46):
	case  (RIL_UNSOL_VENDOR_BASE + 47):
	case  (RIL_UNSOL_VENDOR_BASE + 49):
	case  (RIL_UNSOL_VENDOR_BASE + 50):
	case  (RIL_UNSOL_VENDOR_BASE + 51):
	case  (RIL_UNSOL_VENDOR_BASE + 53):
	case  (RIL_UNSOL_VENDOR_BASE + 54):
	case  (RIL_UNSOL_VENDOR_BASE + 55):
	case  (RIL_UNSOL_VENDOR_BASE + 59):
	case  (RIL_UNSOL_VENDOR_BASE + 73):
	case  (RIL_UNSOL_VENDOR_BASE + 81):
	case  (RIL_UNSOL_VENDOR_BASE + 82):
	case  (RIL_UNSOL_VENDOR_BASE + 83):
	case  (RIL_UNSOL_VENDOR_BASE + 84):
	case  (RIL_UNSOL_VENDOR_BASE + 85):
	case  (RIL_UNSOL_VENDOR_BASE + 86):
	case  (RIL_UNSOL_VENDOR_BASE + 87):
	case  (RIL_UNSOL_VENDOR_BASE + 88):
	case  (RIL_UNSOL_VENDOR_BASE + 89):
	//case  (RIL_UNSOL_VENDOR_BASE + 90):
	case  (RIL_UNSOL_VENDOR_BASE + 91):
	case  (RIL_UNSOL_VENDOR_BASE + 92):
        case  (RIL_UNSOL_VENDOR_BASE + 93):
	case  (RIL_UNSOL_VENDOR_BASE + 94):
	case  (RIL_UNSOL_VENDOR_BASE + 95):
	case  (RIL_UNSOL_VENDOR_BASE + 96):
	case  (RIL_UNSOL_VENDOR_BASE + 97):
	case  (RIL_UNSOL_VENDOR_BASE + 98):
	case  (RIL_UNSOL_VENDOR_BASE + 99):
	case  (RIL_UNSOL_VENDOR_BASE + 100):
	//case  (RIL_UNSOL_VENDOR_BASE + 101):
	case  (RIL_UNSOL_VENDOR_BASE + 102):
	case  (RIL_UNSOL_VENDOR_BASE + 103):
	case  (RIL_UNSOL_VENDOR_BASE + 104):
	case  (RIL_UNSOL_VENDOR_BASE + 105):
	case  (RIL_UNSOL_VENDOR_BASE + 106):
	case  (RIL_UNSOL_VENDOR_BASE + 107):
	case  (RIL_UNSOL_VENDOR_BASE + 109):
	case  (RIL_UNSOL_VENDOR_BASE + 110):
	case  (RIL_UNSOL_VENDOR_BASE + 111):
	case  (RIL_LOCAL_GSM_UNSOL_VENDOR_BASE + 2):
	case  (RIL_LOCAL_GSM_UNSOL_VENDOR_BASE + 3):
	case  (RIL_LOCAL_GSM_UNSOL_VENDOR_BASE + 4):
	case  (RIL_LOCAL_GSM_UNSOL_VENDOR_BASE + 5):
	case  (RIL_LOCAL_GSM_UNSOL_VENDOR_BASE + 6):
	case  (RIL_LOCAL_GSM_UNSOL_VENDOR_BASE + 7):
	case  (RIL_LOCAL_GSM_UNSOL_VENDOR_BASE + 8):
	case  (RIL_LOCAL_GSM_UNSOL_VENDOR_BASE + 9):
	case  (RIL_LOCAL_GSM_UNSOL_VENDOR_BASE + 12):
	case  (RIL_LOCAL_GSM_UNSOL_VENDOR_BASE + 13):
	case  (RIL_LOCAL_GSM_UNSOL_VENDOR_BASE + 14):
	case  (RIL_LOCAL_GSM_UNSOL_VENDOR_BASE + 15):
	case  (RIL_LOCAL_GSM_UNSOL_VENDOR_BASE + 16):
	case  (RIL_LOCAL_GSM_UNSOL_VENDOR_BASE + 17):
	case  (RIL_LOCAL_GSM_UNSOL_VENDOR_BASE + 18):
	case  (RIL_LOCAL_GSM_UNSOL_VENDOR_BASE + 19):
	case  (RIL_LOCAL_GSM_UNSOL_VENDOR_BASE + 20):
	case  (RIL_LOCAL_C2K_UNSOL_VENDOR_BASE + 1):
	case  (RIL_LOCAL_C2K_UNSOL_VENDOR_BASE + 2):
	case  (RIL_LOCAL_C2K_UNSOL_VENDOR_BASE + 3):
	case  (RIL_LOCAL_C2K_UNSOL_VENDOR_BASE + 4):
	case  (RIL_LOCAL_C2K_UNSOL_VENDOR_BASE + 5):
	case  (RIL_LOCAL_C2K_UNSOL_VENDOR_BASE + 6):
	case  1046:
	case  1047:
	case  1048:
	case  1049:
	case  1050:
	case  1051:
		return RIL_UNSOL_NOT_SUPPORT;
    default:
        return unsol;
    }
}

Parcel* RfxParcelTransfer::ReqParcelTransfer(int request,  Parcel* p){
    ReqParcelTransferInfo *ReqInfo;
    RFX_LOG_D(LOG_TAG, "RfxParcelTransfer::ReqParcelTransfer request = %d", request);
    if(request >= 1 && request < (int32_t)NUM_ELEMS(s_parcel_transfer_request)){
        RFX_LOG_D(LOG_TAG, "RfxParcelTransfer::ReqParcelTransfer request = %d, parcel_transfer_ril_commands.h", request);
        ReqInfo = &(s_parcel_transfer_request[request]);
    } else if(request >= RIL_REQUEST_VENDOR_BASE && (request < RIL_REQUEST_VENDOR_BASE +
            (int32_t)NUM_ELEMS(s_parcel_transfer_mtk_request))){
        RFX_LOG_D(LOG_TAG, "RfxParcelTransfer::ReqParcelTransfer request = %d, parcel_transfer_mtk_ril_commands.h", request);
        ReqInfo = &(s_parcel_transfer_mtk_request[request-RIL_REQUEST_VENDOR_BASE]);
    } else if(request >= RIL_REQUEST_VENDOR_IVT_BASE && (request < RIL_REQUEST_VENDOR_IVT_BASE +
            (int32_t) NUM_ELEMS(s_parcel_transfer_mtk_ivt_request))){
        RFX_LOG_D(LOG_TAG, "RfxParcelTransfer::ReqParcelTransfer request = %d, parcel_transfer_mtk_ivt_ril_commands.h", request);
        ReqInfo = &(s_parcel_transfer_mtk_ivt_request[request-RIL_REQUEST_VENDOR_IVT_BASE]);
    } else {
        RFX_LOG_D(LOG_TAG, "[RfxParcelTransfer][ReqParcelTransfer] Should not be here");
        return NULL;
    }
    RFX_LOG_D(LOG_TAG, "RfxParcelTransfer::ReqParcelTransfer request = %d", request);
    return ReqInfo->ReqParcelFunction(RIL_VERSION, requsetIdTransfer(request),p);
}

Parcel* RfxParcelTransfer::RespParcelTransfer(int response,  Parcel* p, int* err){
    ReqParcelTransferInfo *RespInfo;
    RFX_LOG_D(LOG_TAG, "RfxParcelTransfer::RespParcelTransfe response = %d, err = %d", response, *err);
    if(response >= 1 && response < (int32_t)NUM_ELEMS(s_parcel_transfer_request)){
        RFX_LOG_V(LOG_TAG, "[RfxParcelTransfer][RespParcelTransfer] use s_parcel_transfer_request");
        RespInfo = &(s_parcel_transfer_request[response]);
    } else if(response >= RIL_REQUEST_VENDOR_BASE && (response < RIL_REQUEST_VENDOR_BASE +
            (int32_t)NUM_ELEMS(s_parcel_transfer_mtk_request))){
        RFX_LOG_V(LOG_TAG, "[RfxParcelTransfer][RespParcelTransfer] use s_parcel_transfer_mtk_request");
        RespInfo = &(s_parcel_transfer_mtk_request[response-RIL_REQUEST_VENDOR_BASE]);
    } else if(response >= RIL_REQUEST_VENDOR_IVT_BASE && (response < RIL_REQUEST_VENDOR_IVT_BASE +
            (int32_t) NUM_ELEMS(s_parcel_transfer_mtk_ivt_request))){
        RFX_LOG_V(LOG_TAG, "[RfxParcelTransfer][RespParcelTransfer] use s_parcel_transfer_mtk_ivt_request");
        RespInfo = &(s_parcel_transfer_mtk_ivt_request[response-RIL_REQUEST_VENDOR_IVT_BASE]);
    } else {
        RFX_LOG_D(LOG_TAG, "[RfxParcelTransfer][RespParcelTransfer] Should not be here");
        return NULL;
    }
    return RespInfo->RespParcelFunction(RIL_VERSION, response, p, err);
}

Parcel* RfxParcelTransfer::UnsolParcelTransfer(int *unsolid,  Parcel* p) {
    UnsolParcelTransferInfo *UnsolInfo;
    int unsol = unsolIdTransfer(*unsolid);
    if(unsol >= RIL_UNSOL_RESPONSE_BASE && (unsol < RIL_UNSOL_RESPONSE_BASE +
            (int32_t)NUM_ELEMS(s_parcel_transfer_urc))){
        RFX_LOG_V(LOG_TAG, "[RfxParcelTransfer][UnsolParcelTransfer] use s_parcel_transfer_request");
        UnsolInfo = &(s_parcel_transfer_urc[unsol-RIL_UNSOL_RESPONSE_BASE]);
    } else if(unsol >= RIL_UNSOL_VENDOR_BASE && (unsol < RIL_UNSOL_VENDOR_BASE +
            (int32_t)NUM_ELEMS(s_parcel_transfer_mtk_urc))){
        RFX_LOG_V(LOG_TAG, "[RfxParcelTransfer][UnsolParcelTransfer] use s_parcel_transfer_mtk_request");
        UnsolInfo = &(s_parcel_transfer_mtk_urc[unsol-RIL_UNSOL_VENDOR_BASE]);
    } else if(unsol >= RIL_UNSOL_VENDOR_IVT_BASE && (unsol < RIL_UNSOL_VENDOR_IVT_BASE +
            (int32_t)NUM_ELEMS(s_parcel_transfer_mtk_ivt_urc))){
        RFX_LOG_V(LOG_TAG, "[RfxParcelTransfer][UnsolParcelTransfer] use s_parcel_transfer_mtk_ivt_request");
        UnsolInfo = &(s_parcel_transfer_mtk_ivt_urc[unsol-RIL_UNSOL_VENDOR_IVT_BASE]);
    } else {
        RFX_LOG_D(LOG_TAG, "[RfxParcelTransfer][UnsolParcelTransfer] Should not be here");
        return NULL;
    }
    *unsolid = unsol;
    RFX_LOG_D(LOG_TAG, "RfxParcelTransfer::UnsolParcelTransfer unsol = %d", *unsolid);
    return UnsolInfo->UnsolParcelFunction(RIL_VERSION, unsol, p);
}

void RfxParcelTransfer::checkTableIndex() {
    // -->Todo, similar with RfxTransfrUtils::checkTableIndex
    for (int i = 0; i < (int)NUM_ELEMS(s_parcel_transfer_request); i++) {
        if (i != s_parcel_transfer_request[i].request) {
	    RLOGE("s_parcel_transfer_request table error. index : %d, requestNumber = %d",
                    i, s_parcel_transfer_request[i].request);
	    #ifdef HAVE_AEE_FEATURE
	    char *msg = NULL;
            asprintf(&msg, "s_parcel_transfer_request table error. index : %d, requestNumber = %d",
                    i, s_parcel_transfer_request[i].request);
            triggerNE(msg);
            free(msg);
            #else
            RFX_ASSERT(0);
            #endif
        }
    }

    for (int i = 0; i < (int)NUM_ELEMS(s_parcel_transfer_mtk_request); i++) {
        if (i + RIL_REQUEST_VENDOR_BASE != s_parcel_transfer_mtk_request[i].request) {
            RLOGE("s_parcel_transfer_mtk_request table error. index : %d, requestNumber = %d",
                    i, s_parcel_transfer_mtk_request[i].request);
            #ifdef HAVE_AEE_FEATURE
            char *msg = NULL;
            asprintf(&msg, "s_parcel_transfer_mtk_request table error. index : %d, requestNumber \
                    = %d", i, s_parcel_transfer_mtk_request[i].request);
            triggerNE(msg);
            free(msg);
            #else
            RFX_ASSERT(0);
            #endif
        }
    }

    for (int i = 0; i < (int)NUM_ELEMS(s_parcel_transfer_urc); i++) {
        if (i + RIL_UNSOL_RESPONSE_BASE != s_parcel_transfer_urc[i].unsol) {
            RLOGE("s_parcel_transfer_urc table error. index : %d, requestNumber = %d",
                    i, s_parcel_transfer_urc[i].unsol);
            #ifdef HAVE_AEE_FEATURE
            char *msg = NULL;
            asprintf(&msg, "s_parcel_transfer_urc table error. index : %d, requestNumber \
                    = %d", i, s_parcel_transfer_urc[i].unsol);
            triggerNE(msg);
            free(msg);
            #else
            RFX_ASSERT(0);
            #endif
        }
    }

    for (int i = 0; i < (int)NUM_ELEMS(s_parcel_transfer_mtk_urc); i++) {
        if (i + RIL_UNSOL_VENDOR_BASE != s_parcel_transfer_mtk_urc[i].unsol) {
            RLOGE("s_parcel_transfer_mtk_urc table error. index : %d, requestNumber = %d",
                    i, s_parcel_transfer_mtk_urc[i].unsol);
            #ifdef HAVE_AEE_FEATURE
            char *msg = NULL;
            asprintf(&msg, "s_parcel_transfer_mtk_urc table error. index : %d, \
                    requestNumber = %d", i, s_parcel_transfer_mtk_urc[i].unsol);
            triggerNE(msg);
            free(msg);
            #else
            RFX_ASSERT(0);
            #endif
        }
    }

    ///MT2635: check ivt table
    for (int i = 0; i < (int)NUM_ELEMS(s_parcel_transfer_mtk_ivt_request); i++) {
        if (i + RIL_REQUEST_VENDOR_IVT_BASE != s_parcel_transfer_mtk_ivt_request[i].request) {
            RLOGE("s_parcel_transfer_mtk_ivt_request table error. index : %d, requestNumber = %d",
                    i, s_parcel_transfer_mtk_ivt_request[i].request);
            #ifdef HAVE_AEE_FEATURE
            char *msg = NULL;
            asprintf(&msg, "s_parcel_transfer_mtk_ivt_request table error. index : %d, requestNumber \
                    = %d", i, s_parcel_transfer_mtk_ivt_request[i].request);
            triggerNE(msg);
            free(msg);
            #else
            RFX_ASSERT(0);
            #endif
        }
    }

     for (int i = 0; i < (int)NUM_ELEMS(s_parcel_transfer_mtk_ivt_urc); i++) {
        if (i + RIL_UNSOL_VENDOR_IVT_BASE != s_parcel_transfer_mtk_ivt_urc[i].unsol) {
            RLOGE("s_parcel_transfer_mtk_ivt_urc table error. index : %d, requestNumber = %d",
                    i, s_parcel_transfer_mtk_ivt_urc[i].unsol);
            #ifdef HAVE_AEE_FEATURE
            char *msg = NULL;
            asprintf(&msg, "s_parcel_transfer_mtk_ivt_urc table error. index : %d, requestNumber \
                    = %d", i, s_parcel_transfer_mtk_ivt_urc[i].unsol);
            triggerNE(msg);
            free(msg);
            #else
            RFX_ASSERT(0);
            #endif
        }
     }

}

