// This source code is generated by UdpGeneratorTool, not recommend to modify it directly
#include <errno.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/socket.h>

#include "Agps2FrameworkInterface.h"
#include "mtk_socket_data_coder.h"

// Sender
bool Agps2FrameworkInterface_isExist(mtk_socket_fd* client_fd) {
    if(!mtk_socket_client_connect(client_fd)) {
        SOCK_LOGE("Agps2FrameworkInterface_isExist() mtk_socket_client_connect() failed");
        return false;
    }
    int _ret;
    char _buff[AGPS2FRAMEWORK_INTERFACE_BUFF_SIZE] = {0};
    int _offset = 0;
    mtk_socket_put_int(_buff, &_offset, AGPS2FRAMEWORK_INTERFACE_PROTOCOL_TYPE);
    mtk_socket_put_int(_buff, &_offset, AGPS2FRAMEWORK_INTERFACE_IS_EXIST);
    _ret = mtk_socket_write(client_fd->fd, _buff, _offset);
    if(_ret == -1) {
        SOCK_LOGE("Agps2FrameworkInterface_isExist() mtk_socket_write() failed, fd=%d err=[%s]%d", 
            client_fd, strerror(errno), errno);
        mtk_socket_client_close(client_fd);
        return false;
    }
    mtk_socket_client_close(client_fd);
    return true;
}

bool Agps2FrameworkInterface_acquireWakeLock(mtk_socket_fd* client_fd) {
    if(!mtk_socket_client_connect(client_fd)) {
        SOCK_LOGE("Agps2FrameworkInterface_acquireWakeLock() mtk_socket_client_connect() failed");
        return false;
    }
    int _ret;
    char _buff[AGPS2FRAMEWORK_INTERFACE_BUFF_SIZE] = {0};
    int _offset = 0;
    mtk_socket_put_int(_buff, &_offset, AGPS2FRAMEWORK_INTERFACE_PROTOCOL_TYPE);
    mtk_socket_put_int(_buff, &_offset, AGPS2FRAMEWORK_INTERFACE_ACQUIRE_WAKE_LOCK);
    _ret = mtk_socket_write(client_fd->fd, _buff, _offset);
    if(_ret == -1) {
        SOCK_LOGE("Agps2FrameworkInterface_acquireWakeLock() mtk_socket_write() failed, fd=%d err=[%s]%d", 
            client_fd, strerror(errno), errno);
        mtk_socket_client_close(client_fd);
        return false;
    }
    mtk_socket_client_close(client_fd);
    return true;
}

bool Agps2FrameworkInterface_releaseWakeLock(mtk_socket_fd* client_fd) {
    if(!mtk_socket_client_connect(client_fd)) {
        SOCK_LOGE("Agps2FrameworkInterface_releaseWakeLock() mtk_socket_client_connect() failed");
        return false;
    }
    int _ret;
    char _buff[AGPS2FRAMEWORK_INTERFACE_BUFF_SIZE] = {0};
    int _offset = 0;
    mtk_socket_put_int(_buff, &_offset, AGPS2FRAMEWORK_INTERFACE_PROTOCOL_TYPE);
    mtk_socket_put_int(_buff, &_offset, AGPS2FRAMEWORK_INTERFACE_RELEASE_WAKE_LOCK);
    _ret = mtk_socket_write(client_fd->fd, _buff, _offset);
    if(_ret == -1) {
        SOCK_LOGE("Agps2FrameworkInterface_releaseWakeLock() mtk_socket_write() failed, fd=%d err=[%s]%d", 
            client_fd, strerror(errno), errno);
        mtk_socket_client_close(client_fd);
        return false;
    }
    mtk_socket_client_close(client_fd);
    return true;
}

bool Agps2FrameworkInterface_requestDedicatedApnAndDnsQuery(mtk_socket_fd* client_fd, char* fqdn, bool isEmergencySupl, bool isApnEnabled) {
    if(!mtk_socket_client_connect(client_fd)) {
        SOCK_LOGE("Agps2FrameworkInterface_requestDedicatedApnAndDnsQuery() mtk_socket_client_connect() failed");
        return false;
    }
    int _ret;
    char _buff[AGPS2FRAMEWORK_INTERFACE_BUFF_SIZE] = {0};
    int _offset = 0;
    mtk_socket_put_int(_buff, &_offset, AGPS2FRAMEWORK_INTERFACE_PROTOCOL_TYPE);
    mtk_socket_put_int(_buff, &_offset, AGPS2FRAMEWORK_INTERFACE_REQUEST_DEDICATED_APN_AND_DNS_QUERY);
    if(strlen(fqdn) > 256) {
        SOCK_LOGE("Agps2FrameworkInterface_requestDedicatedApnAndDnsQuery() strlen of fqdn=[%d] is over 256", strlen(fqdn));
        return false;
    }
    mtk_socket_put_string(_buff, &_offset, fqdn);
    mtk_socket_put_bool(_buff, &_offset, isEmergencySupl);
    mtk_socket_put_bool(_buff, &_offset, isApnEnabled);
    _ret = mtk_socket_write(client_fd->fd, _buff, _offset);
    if(_ret == -1) {
        SOCK_LOGE("Agps2FrameworkInterface_requestDedicatedApnAndDnsQuery() mtk_socket_write() failed, fd=%d err=[%s]%d", 
            client_fd, strerror(errno), errno);
        mtk_socket_client_close(client_fd);
        return false;
    }
    mtk_socket_client_close(client_fd);
    return true;
}

bool Agps2FrameworkInterface_releaseDedicatedApn(mtk_socket_fd* client_fd) {
    if(!mtk_socket_client_connect(client_fd)) {
        SOCK_LOGE("Agps2FrameworkInterface_releaseDedicatedApn() mtk_socket_client_connect() failed");
        return false;
    }
    int _ret;
    char _buff[AGPS2FRAMEWORK_INTERFACE_BUFF_SIZE] = {0};
    int _offset = 0;
    mtk_socket_put_int(_buff, &_offset, AGPS2FRAMEWORK_INTERFACE_PROTOCOL_TYPE);
    mtk_socket_put_int(_buff, &_offset, AGPS2FRAMEWORK_INTERFACE_RELEASE_DEDICATED_APN);
    _ret = mtk_socket_write(client_fd->fd, _buff, _offset);
    if(_ret == -1) {
        SOCK_LOGE("Agps2FrameworkInterface_releaseDedicatedApn() mtk_socket_write() failed, fd=%d err=[%s]%d", 
            client_fd, strerror(errno), errno);
        mtk_socket_client_close(client_fd);
        return false;
    }
    mtk_socket_client_close(client_fd);
    return true;
}

/**
 * when emergency call is dialed and location is requested from network
 * AGPSD will decide to send this message to framework to show
 * the GPS icon to meet the operator requirement
 */
bool Agps2FrameworkInterface_requestGpsIcon(mtk_socket_fd* client_fd) {
    if(!mtk_socket_client_connect(client_fd)) {
        SOCK_LOGE("Agps2FrameworkInterface_requestGpsIcon() mtk_socket_client_connect() failed");
        return false;
    }
    int _ret;
    char _buff[AGPS2FRAMEWORK_INTERFACE_BUFF_SIZE] = {0};
    int _offset = 0;
    mtk_socket_put_int(_buff, &_offset, AGPS2FRAMEWORK_INTERFACE_PROTOCOL_TYPE);
    mtk_socket_put_int(_buff, &_offset, AGPS2FRAMEWORK_INTERFACE_REQUEST_GPS_ICON);
    _ret = mtk_socket_write(client_fd->fd, _buff, _offset);
    if(_ret == -1) {
        SOCK_LOGE("Agps2FrameworkInterface_requestGpsIcon() mtk_socket_write() failed, fd=%d err=[%s]%d", 
            client_fd, strerror(errno), errno);
        mtk_socket_client_close(client_fd);
        return false;
    }
    mtk_socket_client_close(client_fd);
    return true;
}

/**
 * if requestGpsIcon() was sent before, in the end of this AGPS session
 * AGPSD will send this message to framework to remove the GPS icon
 */
bool Agps2FrameworkInterface_removeGpsIcon(mtk_socket_fd* client_fd) {
    if(!mtk_socket_client_connect(client_fd)) {
        SOCK_LOGE("Agps2FrameworkInterface_removeGpsIcon() mtk_socket_client_connect() failed");
        return false;
    }
    int _ret;
    char _buff[AGPS2FRAMEWORK_INTERFACE_BUFF_SIZE] = {0};
    int _offset = 0;
    mtk_socket_put_int(_buff, &_offset, AGPS2FRAMEWORK_INTERFACE_PROTOCOL_TYPE);
    mtk_socket_put_int(_buff, &_offset, AGPS2FRAMEWORK_INTERFACE_REMOVE_GPS_ICON);
    _ret = mtk_socket_write(client_fd->fd, _buff, _offset);
    if(_ret == -1) {
        SOCK_LOGE("Agps2FrameworkInterface_removeGpsIcon() mtk_socket_write() failed, fd=%d err=[%s]%d", 
            client_fd, strerror(errno), errno);
        mtk_socket_client_close(client_fd);
        return false;
    }
    mtk_socket_client_close(client_fd);
    return true;
}

// Receiver
bool Agps2FrameworkInterface_receiver_decode(char* _buff, Agps2FrameworkInterface_callbacks* callbacks) {
    int _ret = 0;
    int _offset = 0;
    _ret = mtk_socket_get_int(_buff, &_offset);
    if(_ret != AGPS2FRAMEWORK_INTERFACE_PROTOCOL_TYPE) {
        SOCK_LOGE("Agps2FrameworkInterface_receiver_decode() protocol_type=[%d] is not equals to [%d]",
            _ret, AGPS2FRAMEWORK_INTERFACE_PROTOCOL_TYPE);
        return false;
    }
    _ret = mtk_socket_get_int(_buff, &_offset);
    switch(_ret) {
    case AGPS2FRAMEWORK_INTERFACE_IS_EXIST: {
        if(callbacks->Agps2FrameworkInterface_isExist_handler == NULL) {
            SOCK_LOGE("Agps2FrameworkInterface_receiver_decode() Agps2FrameworkInterface_isExist_handler() is NULL");
            return false;
        }
        callbacks->Agps2FrameworkInterface_isExist_handler();
        break;
    }
    case AGPS2FRAMEWORK_INTERFACE_ACQUIRE_WAKE_LOCK: {
        if(callbacks->Agps2FrameworkInterface_acquireWakeLock_handler == NULL) {
            SOCK_LOGE("Agps2FrameworkInterface_receiver_decode() Agps2FrameworkInterface_acquireWakeLock_handler() is NULL");
            return false;
        }
        callbacks->Agps2FrameworkInterface_acquireWakeLock_handler();
        break;
    }
    case AGPS2FRAMEWORK_INTERFACE_RELEASE_WAKE_LOCK: {
        if(callbacks->Agps2FrameworkInterface_releaseWakeLock_handler == NULL) {
            SOCK_LOGE("Agps2FrameworkInterface_receiver_decode() Agps2FrameworkInterface_releaseWakeLock_handler() is NULL");
            return false;
        }
        callbacks->Agps2FrameworkInterface_releaseWakeLock_handler();
        break;
    }
    case AGPS2FRAMEWORK_INTERFACE_REQUEST_DEDICATED_APN_AND_DNS_QUERY: {
        if(callbacks->Agps2FrameworkInterface_requestDedicatedApnAndDnsQuery_handler == NULL) {
            SOCK_LOGE("Agps2FrameworkInterface_receiver_decode() Agps2FrameworkInterface_requestDedicatedApnAndDnsQuery_handler() is NULL");
            return false;
        }
        char fqdn[256];
        mtk_socket_get_string(_buff, &_offset, fqdn, 256);
        bool isEmergencySupl = mtk_socket_get_bool(_buff, &_offset);
        bool isApnEnabled = mtk_socket_get_bool(_buff, &_offset);
        callbacks->Agps2FrameworkInterface_requestDedicatedApnAndDnsQuery_handler(fqdn, isEmergencySupl, isApnEnabled);
        break;
    }
    case AGPS2FRAMEWORK_INTERFACE_RELEASE_DEDICATED_APN: {
        if(callbacks->Agps2FrameworkInterface_releaseDedicatedApn_handler == NULL) {
            SOCK_LOGE("Agps2FrameworkInterface_receiver_decode() Agps2FrameworkInterface_releaseDedicatedApn_handler() is NULL");
            return false;
        }
        callbacks->Agps2FrameworkInterface_releaseDedicatedApn_handler();
        break;
    }
    case AGPS2FRAMEWORK_INTERFACE_REQUEST_GPS_ICON: {
        if(callbacks->Agps2FrameworkInterface_requestGpsIcon_handler == NULL) {
            SOCK_LOGE("Agps2FrameworkInterface_receiver_decode() Agps2FrameworkInterface_requestGpsIcon_handler() is NULL");
            return false;
        }
        callbacks->Agps2FrameworkInterface_requestGpsIcon_handler();
        break;
    }
    case AGPS2FRAMEWORK_INTERFACE_REMOVE_GPS_ICON: {
        if(callbacks->Agps2FrameworkInterface_removeGpsIcon_handler == NULL) {
            SOCK_LOGE("Agps2FrameworkInterface_receiver_decode() Agps2FrameworkInterface_removeGpsIcon_handler() is NULL");
            return false;
        }
        callbacks->Agps2FrameworkInterface_removeGpsIcon_handler();
        break;
    }
    case AGPS2FRAMEWORK_INTERFACE_REQUEST_C2K_APN: {
        if(callbacks->Agps2FrameworkInterface_requestC2kApn_handler == NULL) {
            SOCK_LOGE("Agps2FrameworkInterface_receiver_decode() Agps2FrameworkInterface_removeGpsIcon_handler() is NULL");
            return false;
        }
        callbacks->Agps2FrameworkInterface_requestC2kApn_handler();
        break;
    }
    case AGPS2FRAMEWORK_INTERFACE_RELEASE_C2K_APN: {
        if(callbacks->Agps2FrameworkInterface_releaseC2kApn_handler == NULL) {
            SOCK_LOGE("Agps2FrameworkInterface_releaseC2kApn() Agps2FrameworkInterface_removeGpsIcon_handler() is NULL");
            return false;
        }
        callbacks->Agps2FrameworkInterface_releaseC2kApn_handler();
        break;
    }
    case AGPS2FRAMEWORK_INTERFACE_AGPS_NI_NOTIFY: {
        if(callbacks->Agps2FrameworkInterface_AgpsNiNotify_handler == NULL) {
            SOCK_LOGE("Agps2FrameworkInterface_AgpsNiNotify() Agps2FrameworkInterface_removeGpsIcon_handler() is NULL");
            return false;
        }
        callbacks->Agps2FrameworkInterface_AgpsNiNotify_handler();
        break;
    }
    default: {
        SOCK_LOGE("Agps2FrameworkInterface_receiver_decode() unknown msgId=[%d]", _ret);
        return false;
    }
    }
    return true;
}
bool Agps2FrameworkInterface_receiver_read_and_decode(int server_fd, Agps2FrameworkInterface_callbacks* callbacks) {
    int _ret;
    char _buff[AGPS2FRAMEWORK_INTERFACE_BUFF_SIZE] = {0};

    _ret = mtk_socket_read(server_fd, _buff, sizeof(_buff));
    if(_ret == -1) {
        SOCK_LOGE("Agps2FrameworkInterface_receiver_read_and_decode() mtk_socket_read() failed, fd=%d err=[%s]%d", 
            server_fd, strerror(errno), errno);
        return false;
    }
    return Agps2FrameworkInterface_receiver_decode(_buff, callbacks);
}

