// This source code is generated by UdpGeneratorTool, not recommend to modify it directly
#ifndef __Agps2FrameworkInterface_H__
#define __Agps2FrameworkInterface_H__

#include "mtk_socket_utils.h"

#ifdef __cplusplus
extern "C" {
#endif

#define AGPS2FRAMEWORK_INTERFACE_PROTOCOL_TYPE 301
#define AGPS2FRAMEWORK_INTERFACE_BUFF_SIZE 271

/**
 * The interface from AGPS  to Framework
 */
typedef enum {
    AGPS2FRAMEWORK_INTERFACE_IS_EXIST = 0,
    AGPS2FRAMEWORK_INTERFACE_ACQUIRE_WAKE_LOCK = 1,
    AGPS2FRAMEWORK_INTERFACE_RELEASE_WAKE_LOCK = 2,
    AGPS2FRAMEWORK_INTERFACE_REQUEST_DEDICATED_APN_AND_DNS_QUERY = 3,
    AGPS2FRAMEWORK_INTERFACE_RELEASE_DEDICATED_APN = 4,
    /**
     * when emergency call is dialed and location is requested from network
     * AGPSD will decide to send this message to framework to show
     * the GPS icon to meet the operator requirement
     */
    AGPS2FRAMEWORK_INTERFACE_REQUEST_GPS_ICON = 5,
    /**
     * if requestGpsIcon() was sent before, in the end of this AGPS session
     * AGPSD will send this message to framework to remove the GPS icon
     */
    AGPS2FRAMEWORK_INTERFACE_REMOVE_GPS_ICON = 6,
    AGPS2FRAMEWORK_INTERFACE_REQUEST_C2K_APN = 7,
    AGPS2FRAMEWORK_INTERFACE_RELEASE_C2K_APN = 8,
    AGPS2FRAMEWORK_INTERFACE_AGPS_NI_NOTIFY = 9,
} Agps2FrameworkInterface_message_id;



// Sender
bool Agps2FrameworkInterface_isExist(mtk_socket_fd* client_fd);

bool Agps2FrameworkInterface_acquireWakeLock(mtk_socket_fd* client_fd);

bool Agps2FrameworkInterface_releaseWakeLock(mtk_socket_fd* client_fd);

bool Agps2FrameworkInterface_requestDedicatedApnAndDnsQuery(mtk_socket_fd* client_fd, char* fqdn, bool isEmergencySupl, bool isApnEnabled);

bool Agps2FrameworkInterface_releaseDedicatedApn(mtk_socket_fd* client_fd);

/**
 * when emergency call is dialed and location is requested from network
 * AGPSD will decide to send this message to framework to show
 * the GPS icon to meet the operator requirement
 */
bool Agps2FrameworkInterface_requestGpsIcon(mtk_socket_fd* client_fd);

/**
 * if requestGpsIcon() was sent before, in the end of this AGPS session
 * AGPSD will send this message to framework to remove the GPS icon
 */
bool Agps2FrameworkInterface_removeGpsIcon(mtk_socket_fd* client_fd);

// Receiver
typedef struct {
    void (*Agps2FrameworkInterface_isExist_handler) ();
    void (*Agps2FrameworkInterface_acquireWakeLock_handler) ();
    void (*Agps2FrameworkInterface_releaseWakeLock_handler) ();
    void (*Agps2FrameworkInterface_requestDedicatedApnAndDnsQuery_handler) (char* fqdn, bool isEmergencySupl, bool isApnEnabled);
    void (*Agps2FrameworkInterface_releaseDedicatedApn_handler) ();
    /**
     * when emergency call is dialed and location is requested from network
     * AGPSD will decide to send this message to framework to show
     * the GPS icon to meet the operator requirement
     */
    void (*Agps2FrameworkInterface_requestGpsIcon_handler) ();
    /**
     * if requestGpsIcon() was sent before, in the end of this AGPS session
     * AGPSD will send this message to framework to remove the GPS icon
     */
    void (*Agps2FrameworkInterface_removeGpsIcon_handler) ();
    void (*Agps2FrameworkInterface_requestC2kApn_handler) ();
    void (*Agps2FrameworkInterface_releaseC2kApn_handler) ();
    void (*Agps2FrameworkInterface_AgpsNiNotify_handler) ();
} Agps2FrameworkInterface_callbacks;

bool Agps2FrameworkInterface_receiver_decode(char* _buff, Agps2FrameworkInterface_callbacks* callbacks);
bool Agps2FrameworkInterface_receiver_read_and_decode(int server_fd, Agps2FrameworkInterface_callbacks* callbacks);

#ifdef __cplusplus
}
#endif

#endif

