// SPDX-License-Identifier: MediaTekProprietary
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2015. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef __RP_APN_CONTROLLER_H__
#define __RP_APN_CONTROLLER_H__

/*****************************************************************************
 * Include
 *****************************************************************************/
#include <utils/Vector.h>
#include "RfxController.h"
#include "RfxTimer.h"
#include <utils/Thread.h>
#include "Parcel.h"

extern "C"
{
#include "apn_interface.h"
}

/*****************************************************************************
 * Class RpDataController
 *****************************************************************************/


typedef struct Apnsetting{
    string carrier;
    string apn;
    string proxy;
    string port;
    string mmsc;
    string mms_proxy;
    string mms_port;
    string user;
    string password;
    int auth_type;
    string types;
    int id;
    string numberic;
    string protocol;
    string roaming_protocol;
    int mtu;
    bool carrier_enabled;
    int bear;
    int bear_bitmask;
    int profile_id;
    bool modem_cognitive;
    int max_conns;
    int wait_time;
    int max_conns_time;
    string mvno_type;
    string mvno_match_data;
}ApnsettingT;

typedef struct {
    const char* pattern;
    const char* replace_char;
} special_char_pattern_t;

typedef enum {
    CHAR_ID_QUOTE,
    CHAR_ID_TOTAL
} prop_char_id_enum;

#define CHAR_QUOTE "'"
#define CHAR_REP_QUOTE "''"

extern "C"
void apncallback(int ret, void* data);

using ::android::Thread;
using ::android::sp;
using ::android::Parcel;

class RpApnController : public RfxController {
    RFX_DECLARE_CLASS(RpApnController);  // Required: declare this class

public:
    RpApnController();
    virtual ~RpApnController();
    void SyncDefaultDataSimToModem();
    int setInitialAttachApn();
    int setDataProfilesAsNeeded();
    int SetDataAttached();
    Vector<ApnsettingT*>* getApnInformation(string apntype);
    void freeApnList(Vector<ApnsettingT*>* list);
    void generateApnDB();
    void GetApnDBBymccmnc();
    class ApnInitThread: public Thread {
    public:
        ApnInitThread(RpApnController* controller);
        virtual ~ApnInitThread();
    protected:
        RpApnController* apnController;
        virtual bool threadLoop();
    };

    sp<ApnInitThread> apnInitThread;
// Override
protected:
    virtual void onInit();
    virtual void onDeinit();
    virtual bool onHandleResponse(const sp<RfxMessage>& message);
    virtual bool onHandleRequest(const sp<RfxMessage>& message);
private:
    void onRadioStateChanged(RfxStatusKeyEnum key, RfxVariant old_value,
        RfxVariant value);
    void onOperatorNumberChanged(RfxStatusKeyEnum key, RfxVariant old_value,
        RfxVariant value);
    void handleSetDataProfileResponse(const sp<RfxMessage>& response);
	void handleSetInitialAttachApnResponse(const sp<RfxMessage>& response);
	void handleSetInitialAttachApnRequest(const sp<RfxMessage>& request);
    int getApnProp(apn_record_t* apn, int columnIdx, char ** value);
    int getApntypeBitmask(char *type);
    bool isApnContains(apn_record_t* apn, int columnIdx, const char *values);
    bool  apnCanHandleType(apn_record_t* apn , const char * type);
    int initDataProfile(apn_record_t* apn, RIL_DataProfileInfo *dp, int isRoaming);
    int parseApnRecord(ApnsettingT* apnInfo,apn_record_t* record);
    void handleModifyApn(const sp<RfxMessage>& message);
    void DeleteApnRecord(const sp<RfxMessage>& message);
    void InsertApnRecord(const sp<RfxMessage>& message);
    void QueryApnRecord(const sp<RfxMessage>& message);
    void UpdateApnRecord(const sp<RfxMessage>& message);
    void handleResetApnDB(const sp<RfxMessage>& message);
    bool parseRecord(const char *record, apn_record_t * apn_record);
    void reloadApnDB();
    char * getPropValue(const char *string);
    bool checkIfEmptyValue(char* value);
    bool checkPropEmpty(apn_record_t* record, int index);
    bool checkPropExist(apn_record_t* record, int index);
    string constructQueryResult(const apn_list_t * apn_list);
    bool handleSpecialChar(std::string& source, const std::string& pattern, const std::string& replce);

public:
    RfxSignal0 apn_ready_singal;
    apn_list_t* g_apnlist;
    String8 mcc;
    String8 mnc;
private:
    apn_record_t *mPreferredApn;
    apn_record_t *mdefaultApnRecord;
    apn_record_t *mfirstApnRecord;
    bool mApnInit;
    String8 emptyStr;
    int mDataprofileid;
};

#endif /* __RP_APN_CONTROLLER_H__ */

