/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2015. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

/*****************************************************************************
 * Include
 *****************************************************************************/

#include "RpDataUtils.h"

#include <pal/pal_nm.h>
#include <cutils/jstring.h>

#include <linux/rtnetlink.h>


/*****************************************************************************
 * Class RpDataUtils
 *****************************************************************************/
#define RP_DC_UTIL_LOG_TAG  "RpDataUtils"
int RpDataUtils::mNetId(6000);
RpDataUtils::RpDataUtils() {
}

RpDataUtils::~RpDataUtils() {
}

const char* RpDataUtils::requestOrUrcToString(int reqId) {
    switch (reqId) {
    case RIL_REQUEST_SETUP_DATA_CALL:
        return "SETUP_DATA_CALL";
    case RIL_REQUEST_DEACTIVATE_DATA_CALL:
        return "DEACTIVATE_DATA_CALL";
    case RIL_REQUEST_ALLOW_DATA:
        return "ALLOW_DATA";
    case RIL_UNSOL_DATA_CALL_LIST_CHANGED:
        return "DATA_CALL_LIST_CHANGED";
    case RIL_UNSOL_DATA_ALLOWED:
        return "DATA_ALLOWED";
    case RIL_UNSOL_TEAR_DOWN_PDN_STATE_CHANGED:
        return "RIL_UNSOL_TEAR_DOWN_PDN_STATE_CHANGED";
    case RIL_UNSOL_SETUP_PDN_STATE_CHANGED:
        return "RIL_UNSOL_SETUP_PDN_STATE_CHANGED";
    case RIL_REQUEST_LAST_DATA_CALL_FAIL_CAUSE:
        return "RIL_REQUEST_LAST_DATA_CALL_FAIL_CAUSE";
    case RIL_UNSOL_LOCAL_UPDATE_PDN_INFO_CHANGED:
        return "RIL_UNSOL_LOCAL_UPDATE_PDN_INFO_CHANGED";
    default:
        return "UNKNOWN_REQUEST";
    }
}

vector<DataCallResponse> RpDataUtils::parseDataConnectionInfo(Parcel* parcel) {
    int ver = parcel->readInt32();
    int num = parcel->readInt32();
    RFX_LOG_D(RP_DC_UTIL_LOG_TAG , "RpDataUtils::RpDataConnectionInfo ver: %d, num: %d", ver, num);

    vector<DataCallResponse> list;
    for (int i = 0; i < num; i++) {
        DataCallResponse dataCallResponse;

        dataCallResponse.status  = parcel->readInt32();  // status
        RFX_LOG_D(RP_DC_UTIL_LOG_TAG , "RpDataUtils::parseDataConnectionInfo:dataCallResponse.status %d",dataCallResponse.status);
        dataCallResponse.suggestedRetryTime = parcel->readInt32();  // suggestedRetryTime
        RFX_LOG_D(RP_DC_UTIL_LOG_TAG , "RpDataUtils::parseDataConnectionInfo:dataCallResponse.suggestedRetryTime %d",dataCallResponse.suggestedRetryTime);
        dataCallResponse.cid = parcel->readInt32();  // cid(interfaceId in rilj)
        RFX_LOG_D(RP_DC_UTIL_LOG_TAG , "RpDataUtils::parseDataConnectionInfo:dataCallResponse.cid %d",dataCallResponse.cid);
        dataCallResponse.active = parcel->readInt32();  // active
        RFX_LOG_D(RP_DC_UTIL_LOG_TAG , "RpDataUtils::parseDataConnectionInfo:dataCallResponse.active %d",dataCallResponse.active);
        string protocolType; // protocolType
        char * cp_protocolType = RpDataUtils::strdupReadString(parcel);
        if (cp_protocolType != NULL) {
            protocolType = std::string(cp_protocolType);
        }
        RpDataUtils::freeMemory(cp_protocolType);
        dataCallResponse.type = protocolType;
        RFX_LOG_D(RP_DC_UTIL_LOG_TAG , "RpDataUtils::parseDataConnectionInfo:protocolType %s",protocolType.c_str());
        string ifname; // ifname
        char * cp_ifname = RpDataUtils::strdupReadString(parcel);
        if (cp_ifname != NULL) {
            ifname = std::string(cp_ifname);
        }
        RpDataUtils::freeMemory(cp_ifname);
        dataCallResponse.ifname = ifname;
        RFX_LOG_D(RP_DC_UTIL_LOG_TAG , "RpDataUtils::parseDataConnectionInfo:ifname %s",ifname.c_str());
        string addresses; // addresses
        char * cp_addresses = RpDataUtils::strdupReadString(parcel);
        if (cp_addresses != NULL) {
            addresses = std::string(cp_addresses);
        }
        RpDataUtils::freeMemory(cp_addresses);
        dataCallResponse.addresses = addresses;
        RFX_LOG_D(RP_DC_UTIL_LOG_TAG , "RpDataUtils::parseDataConnectionInfo:addresses %s",addresses.c_str());
        string dnses; // dnses
        char * cp_dnses = RpDataUtils::strdupReadString(parcel);
        if (cp_dnses != NULL) {
            dnses = std::string(cp_dnses);
        }
        RpDataUtils::freeMemory(cp_dnses);
        dataCallResponse.dnses = dnses;
        RFX_LOG_D(RP_DC_UTIL_LOG_TAG , "RpDataUtils::parseDataConnectionInfo:dnses %s",dnses.c_str());
        string gateways; // gateways
        char * cp_gateways = RpDataUtils::strdupReadString(parcel);
        if (cp_gateways != NULL) {
            gateways = std::string(cp_gateways);
        }
        RpDataUtils::freeMemory(cp_gateways);
        dataCallResponse.gateways = gateways;
        dataCallResponse.initAddress();
        RFX_LOG_D(RP_DC_UTIL_LOG_TAG , "RpDataUtils::parseDataConnectionInfo:gateways %s",gateways.c_str());
        string pcscf; // pcscf
        char * cp_pcscf = RpDataUtils::strdupReadString(parcel);
        if (cp_pcscf != NULL) {
            pcscf = std::string(cp_pcscf);
        }
        RpDataUtils::freeMemory(cp_pcscf);
        dataCallResponse.pcscf = pcscf;
        RFX_LOG_D(RP_DC_UTIL_LOG_TAG , "RpDataUtils::parseDataConnectionInfo:pcscf %s",pcscf.c_str());
        dataCallResponse.mtu = parcel->readInt32();  // mtu
        RFX_LOG_D(RP_DC_UTIL_LOG_TAG , "RpDataUtils::parseDataConnectionInfo:mtu %d",dataCallResponse.mtu);
        RFX_LOG_D(RP_DC_UTIL_LOG_TAG , "RpDataUtils::parseDataConnectionInfo dataCallResponse: %s", dataCallResponse.logInfo().c_str());
        list.push_back(dataCallResponse);
    }
    return list;
}

void RpDataUtils::writeStringToParcel(Parcel *p, const char *s) {
    char16_t *s16;
    size_t s16_len;
    s16 = strdup8to16(s, &s16_len);
    p->writeString16(s16, s16_len);
    free(s16);
}

void RpDataUtils::fillDataCallResponse(Parcel* parcel, MTK_Data_Call_Response_v1 dataCallResponse) {

    RFX_LOG_D(RP_DC_UTIL_LOG_TAG, "RpDataUtils::fillDataCallResponse: netId: %d, pdnState: %s, "
            "status: %d, cId: %d, apnType: %s, protocolType: %s, ifaceName: %s, address: %s, dns: %s, "
            "gateway: %s, pcscf: %s, mtu: %d, apnName:%s",
            dataCallResponse.netId, RpDataUtils::apnState2string(RIL_Data_Call_PdnState(dataCallResponse.pdnState)),
            dataCallResponse.status, dataCallResponse.cId, dataCallResponse.apnType, dataCallResponse.type,
            dataCallResponse.ifname, dataCallResponse.addresses, dataCallResponse.dnses, dataCallResponse.gateways,
            dataCallResponse.pcscf,
            dataCallResponse.mtu,dataCallResponse.apnName);

    parcel->writeInt32(dataCallResponse.netId); // netId
    parcel->writeInt32(dataCallResponse.pdnState); // pdn state
    parcel->writeInt32(dataCallResponse.status); // status
    parcel->writeInt32(dataCallResponse.cId); // cid
    writeStringToParcel(parcel, dataCallResponse.apnType); // apn type
    writeStringToParcel(parcel, dataCallResponse.type);  // protocol type
    writeStringToParcel(parcel, dataCallResponse.ifname);  // ifname
    writeStringToParcel(parcel, dataCallResponse.addresses);  // address
    writeStringToParcel(parcel, dataCallResponse.dnses); // dns
    writeStringToParcel(parcel, dataCallResponse.gateways); // gateway
    writeStringToParcel(parcel, dataCallResponse.pcscf); // pcscf
    parcel->writeInt32(dataCallResponse.mtu); // mtu
    writeStringToParcel(parcel, dataCallResponse.apnName); // apn name
}

void RpDataUtils::parseDataCallResponse(MTK_Data_Call_Response_v1 *dataCallResponse, Parcel* parcel) {
    dataCallResponse->netId = parcel->readInt32(); // netId
    dataCallResponse->pdnState = parcel->readInt32(); // pdn state
    dataCallResponse->status = parcel->readInt32(); // status
    dataCallResponse->cId = parcel->readInt32(); // cid
    dataCallResponse->apnType = strdupReadString(parcel); // apn type
    dataCallResponse->type = strdupReadString(parcel); // protocol type
    dataCallResponse->ifname = strdupReadString(parcel); // ifname
    dataCallResponse->addresses = strdupReadString(parcel); // address
    dataCallResponse->dnses = strdupReadString(parcel); // dns
    dataCallResponse->gateways = strdupReadString(parcel); // gateway
    dataCallResponse->pcscf = strdupReadString(parcel); // pcscf
    dataCallResponse->mtu = parcel->readInt32(); // mtu
    dataCallResponse->apnName = strdupReadString(parcel); // apn name

    RFX_LOG_D(RP_DC_UTIL_LOG_TAG, "RpDataUtils::parseDataCallResponse: netId: %d, pdnState: %s, status: %d, cId: %d, apnType: %s,"
            " protocolType: %s, ifaceName: %s, address: %s, dns: %s, gateway: %s, pcscf: %s, mtu: %d, apnName: %s",
            dataCallResponse->netId, RpDataUtils::apnState2string(RIL_Data_Call_PdnState(dataCallResponse->pdnState)),
            dataCallResponse->status, dataCallResponse->cId, dataCallResponse->apnType, dataCallResponse->type,
            dataCallResponse->ifname, dataCallResponse->addresses, dataCallResponse->dnses,
            dataCallResponse->gateways, dataCallResponse->pcscf, dataCallResponse->mtu,dataCallResponse->apnName);
}

void RpDataUtils::configNetwork(int netId, string interfaceName, string gateWay,
        string dns) {

    int ret;

    vector<string> vGateWay;
    string gateWay_V4;
    string gateWay_V6;
    RpDataUtils::split(gateWay, ' ', vGateWay);
    vector<string>::iterator itorGate = vGateWay.begin();
    while (itorGate != vGateWay.end()) {
        if (itorGate->find('.') != string::npos) {
            gateWay_V4 = *itorGate;
        } else if (itorGate->find(':') != string::npos) {
            gateWay_V6 = *itorGate;
        }
        itorGate++;
    }

    vector<string> vSDns;
    vector<const char*> vCDns;
    RpDataUtils::split(dns, ' ', vSDns);
    vector<string>::iterator itorDns = vSDns.begin();
    while (itorDns != vSDns.end()) {
        vCDns.push_back(itorDns->c_str());
        itorDns++;
    }

    RFX_LOG_D(RP_DC_UTIL_LOG_TAG, "configNetwork() with netId: %d, interfaceName %s,"
            "gateWay_V4.c_str()=%s, gateWay_V6.c_str()=%s",
            netId, interfaceName.c_str(),
            gateWay_V4.c_str(), gateWay_V6.c_str());

    if (nm_network_create(netId, NULL) != 0) {
        RFX_LOG_D(RP_DC_UTIL_LOG_TAG,"RpDataUtils::configNetwork: nm_network_create() fail,because the netid create"
            "before, clear the old interface configure!!");
        nm_network_interface_remove(netId, interfaceName.c_str());
        RFX_LOG_D(RP_DC_UTIL_LOG_TAG,"RpDataUtils::configNetwork: nm_network_create() fail!!");
    }


    nm_network_policy_route_init();

    ret = nm_network_ipv4_policy_rule_modify(RTM_DELRULE,16000,netId,netId&0xFFFF,0xFFFF,NULL,NULL);
       RFX_LOG_D(RP_DC_UTIL_LOG_TAG, "nm_network_ipv4_policy_rule_modify() DEL ret = %d", ret);

    ret = nm_network_ipv4_policy_route_modify(RTM_DELROUTE,netId,interfaceName.c_str());
    RFX_LOG_D(RP_DC_UTIL_LOG_TAG, "nm_network_ipv4_policy_route_modify() DEL ret = %d", ret);

    ret = nm_network_ipv6_policy_rule_modify(RTM_DELRULE,16000,netId,netId&0xFFFF,0xFFFF,NULL,NULL);
      RFX_LOG_D(RP_DC_UTIL_LOG_TAG, "nm_network_ipv6_policy_rule_modify() DEL ret = %d", ret);

    ret = nm_network_ipv6_policy_route_modify(RTM_DELROUTE,netId,interfaceName.c_str());
    RFX_LOG_D(RP_DC_UTIL_LOG_TAG, "nm_network_ipv6_policy_route_modify() DEL ret = %d", ret);

    ret = nm_network_ipv4_policy_route_modify(RTM_NEWROUTE,netId,interfaceName.c_str());
    RFX_LOG_D(RP_DC_UTIL_LOG_TAG, "nm_network_ipv4_policy_route_modify() NEW ret = %d", ret);

    ret = nm_network_ipv4_policy_rule_modify(RTM_NEWRULE,16000,netId,netId&0xFFFF,0xFFFF,NULL,NULL);
    RFX_LOG_D(RP_DC_UTIL_LOG_TAG, "nm_network_ipv4_policy_rule_modify() NEW ret = %d", ret);

    ret = nm_network_ipv6_policy_route_modify(RTM_NEWROUTE,netId,interfaceName.c_str());
    RFX_LOG_D(RP_DC_UTIL_LOG_TAG, "nm_network_ipv6_policy_route_modify() NEW ret = %d", ret);

    ret = nm_network_ipv6_policy_rule_modify(RTM_NEWRULE,16000,netId,netId&0xFFFF,0xFFFF,NULL,NULL);
    RFX_LOG_D(RP_DC_UTIL_LOG_TAG, "nm_network_ipv6_policy_rule_modify() NEW ret = %d", ret);

    ret = nm_resolver_dns_cache_flush(netId);
    RFX_LOG_D(RP_DC_UTIL_LOG_TAG, "nm_resolver_dns_cache_flush() NEW ret = %d", ret);


    RFX_LOG_D(RP_DC_UTIL_LOG_TAG, "nm_resolver_dns_set() with netId: %d, interface_name: %s, dns nubmer: %d",
            netId, interfaceName.c_str(), vCDns.size());
    if(vCDns.size() > 0 && nm_resolver_dns_set(netId, interfaceName.c_str(), &vCDns[0], vCDns.size(), NM_NETWORK_TYPE_INTERNET) !=0) {
        RFX_LOG_D(RP_DC_UTIL_LOG_TAG,"RpDataUtils::configNetwork: nm_resolver_dns_set() fail!!");
        return;
    }
}

void RpDataUtils::tearDownNetwork(int netId, string interfaceName) {
    int ret;

    nm_network_policy_route_init();
    ret = nm_network_ipv4_policy_rule_modify(RTM_DELRULE,16000,netId,netId&0xFFFF,0xFFFF,NULL,NULL);
       RFX_LOG_D(RP_DC_UTIL_LOG_TAG, "nm_network_ipv4_policy_rule_modify() DEL ret = %d", ret);

    ret = nm_network_ipv4_policy_route_modify(RTM_DELROUTE,netId,interfaceName.c_str());
    RFX_LOG_D(RP_DC_UTIL_LOG_TAG, "nm_network_ipv4_policy_route_modify() DEL ret = %d", ret);

    ret = nm_network_ipv6_policy_rule_modify(RTM_DELRULE,16000,netId,netId&0xFFFF,0xFFFF,NULL,NULL);
      RFX_LOG_D(RP_DC_UTIL_LOG_TAG, "nm_network_ipv6_policy_rule_modify() DEL ret = %d", ret);

    ret = nm_network_ipv6_policy_route_modify(RTM_DELROUTE,netId,interfaceName.c_str());
    RFX_LOG_D(RP_DC_UTIL_LOG_TAG, "nm_network_ipv6_policy_route_modify() DEL ret = %d", ret);


    RFX_LOG_D(RP_DC_UTIL_LOG_TAG, "nm_resolver_dns_clear start.");
    if(nm_resolver_dns_clear(netId) != 0) {
        RFX_LOG_D(RP_DC_UTIL_LOG_TAG, "nm_resolver_dns_clear fail.");
    }

    RFX_LOG_D(RP_DC_UTIL_LOG_TAG, "nm_network_interface_remove start.");
    if(nm_network_interface_remove(netId, interfaceName.c_str()) != 0) {
        RFX_LOG_D(RP_DC_UTIL_LOG_TAG, "nm_network_interface_remove fail.");
    }

    RFX_LOG_D(RP_DC_UTIL_LOG_TAG, "nm_network_destroy start.");
    if(nm_network_destroy(netId) != 0) {
        RFX_LOG_D(RP_DC_UTIL_LOG_TAG, "nm_network_destroy fail.");
    }
}

char* RpDataUtils::strdupReadString(Parcel *p) {
    size_t stringlen;
    const char16_t *s16;
    s16 = p->readString16Inplace(&stringlen);
    return strndup16to8(s16, stringlen);
}

void RpDataUtils::freeMemory(char *s) {
    free(s);
    s = NULL;
}

const char* RpDataUtils::apnState2string(RIL_Data_Call_PdnState apnState) {
    switch (apnState) {
    case RIL_Data_Call_PdnState::PDN_CONNECTED:
        return "PDN_CONNECTED";
    case RIL_Data_Call_PdnState::PDN_CONNECTING:
        return "PDN_CONNECTING";
    case RIL_Data_Call_PdnState::PDN_DISCONNECTED:
        return "PDN_DISCONNECTED";
    case RIL_Data_Call_PdnState::PDN_DISCONNECTING:
        return "PDN_DISCONNECTING";
    case RIL_Data_Call_PdnState::PDN_FAILED:
        return "PDN_FAILED";
    case RIL_Data_Call_PdnState::PDN_IDLE:
        return "PDN_IDLE";
    case RIL_Data_Call_PdnState::PDN_RETRYING:
        return "PDN_RETRYING";
    case RIL_Data_Call_PdnState::PDN_SCANNING:
        return "PDN_SCANNING";
    case RIL_Data_Call_PdnState::PDN_TIMEOUT_CANCEL:
        return "PDN_TIMEOUT_CANCEL";
    }
}

const char* RpDataUtils::pdnState2string(int pdnState) {
    switch (pdnState) {
    case 0:
        return "inactive";
    case 1:
        return "active (physical link down)";
    case 2:
        return "active (physical link up)";
    default:
        return "inactive";
    }
}

int RpDataUtils::generateNetId() {
    if(mNetId +1 >= 7000 ) {
        mNetId =  6000;
    } else {
        mNetId++;
    }
    return mNetId;
}
