/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

/*****************************************************************************
 * Include
 *****************************************************************************/
#include "RpNwStateController.h"
#include "RpNwPhoneTypeUpdater.h"
#include "RpNwDefs.h"
#include "power/RadioConstants.h"
#include <cutils/jstring.h>
#include "RfxMainThread.h"
#include "sim/RpSimControllerBase.h"

#if defined(TELE_FWK)
extern int rfx_get_data_allowed_slotid(void);

/*****************************************************************************
 * Class RfxController
 *****************************************************************************/
#if defined(MODE_DSSS)
extern int rfx_get_disabled_sim(void);
#endif
#endif

RFX_IMPLEMENT_CLASS("RpNwStateController", RpNwStateController, RfxController);

RpNwStateController::RpNwStateController() {
    logD(RP_NW_STATE_TAG, " Constructor RpNwStateController");
    mVoiceRegState = 0;
    mDataRegState = 0;
    mVoiceRadioTech = 0;
    mDataRadioTech = 0;
}

RpNwStateController::~RpNwStateController() {
}

void RpNwStateController::onInit() {
    RfxController::onInit(); // Required: invoke super class implementation

    logD(RP_NW_STATE_TAG, " onInit() SIM%d", m_slot_id);

    const int request_id_list[] = {
        RIL_REQUEST_VOICE_REGISTRATION_STATE,
        RIL_REQUEST_DATA_REGISTRATION_STATE,
#if  defined(TELE_FWK)
        RIL_REQUEST_GET_RADIO_CAPABILITY,
        RIL_REQUEST_SET_RADIO_CAPABILITY,
#endif
        /*
        RIL_REQUEST_SIGNAL_STRENGTH,
        RIL_REQUEST_OPERATOR,
        RIL_REQUEST_GET_CELL_INFO_LIST*/
    };

    const int urc_id_list[] = {
        /*RIL_UNSOL_SIGNAL_STRENGTH,*/
        RIL_UNSOL_RESPONSE_PS_NETWORK_STATE_CHANGED,
        RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED,
        /*RIL_UNSOL_CDMA_OTA_PROVISION_STATUS,*/
        RIL_UNSOL_RESTRICTED_STATE_CHANGED,
#if (defined(MODE_DSSS)&& defined(TELE_FWK) )
        RIL_UNSOL_RIL_CONNECTED,
#endif
    };

    // register request & URC id list
    registerToHandleRequest(request_id_list, (sizeof(request_id_list)/sizeof(int)));
    registerToHandleUrc(urc_id_list, (sizeof(urc_id_list)/sizeof(int)));

    resetVoiceRegStateCache(&gsm_voice_reg_state_cache);
    resetVoiceRegStateCache(&cdma_voice_reg_state_cache);
    resetDataRegStateCache(&gsm_data_reg_state_cache);
    resetDataRegStateCache(&cdma_data_reg_state_cache);
    gsm_voice_reg_state_cache.cacheType = RADIO_TECH_GROUP_GSM;
    cdma_voice_reg_state_cache.cacheType = RADIO_TECH_GROUP_C2K;
    gsm_data_reg_state_cache.cacheType = RADIO_TECH_GROUP_GSM;
    cdma_data_reg_state_cache.cacheType = RADIO_TECH_GROUP_C2K;
    resetSignalStrengthCache(&signal_strength_cache);
    resetOperatorCache(&gsm_operator_cache);
    resetOperatorCache(&cdma_operator_cache);

    mVoiceRegState = 0;
    mDataRegState = 0;
    mVoiceRadioTech = 0;
    mDataRadioTech = 0;
    mVoiceRadioSys = -1;
    mDataRadioSys = -1;

    getStatusManager()->setServiceStateValue(RFX_STATUS_KEY_SERVICE_STATE,
            RfxNwServiceState(mVoiceRegState, mDataRegState, mVoiceRadioTech, mDataRadioTech));
#if (!defined(MODE_DSSS)&& defined(TELE_FWK) )
    getStatusManager()->registerStatusChanged(RFX_STATUS_KEY_GSM_OPERATOR_NUMERIC,
        RfxStatusChangeCallback(this, &RpNwStateController::onSimCardInsertStatusUpdate));


#endif

    RpNwPhoneTypeUpdater *phoneTypeUpdater;

    RFX_OBJ_CREATE(phoneTypeUpdater, RpNwPhoneTypeUpdater, this);
}

bool RpNwStateController::onHandleRequest(const sp<RfxMessage>& riljReq) {
    int reqId = riljReq->getId();
    int slotId = riljReq->getSlotId();

    logD(RP_NW_STATE_TAG, " onHandleRequest() SIM%d REQ=%s", slotId, requestToString(reqId));
    requestToRild(riljReq);

    return true;
}

bool RpNwStateController::onHandleUrc(const sp<RfxMessage>& urc) {
    int urcId = urc->getId();
    int slotId = urc->getSlotId();
    Parcel *p;
    sp<RfxMessage> urcToRilj = urc;
    bool isNeedResponseUrc = true;
    sp<RfxMessage> gsmReq;

#if defined(__ANDROID__)
    if (getNonSlotScopeStatusManager()->getIntValue(RFX_STATUS_KEY_CDMA_SOCKET_SLOT, 0)
            == m_slot_id) {
        logD(RP_NW_STATE_TAG, " onHandleUrc() SIM%d URC=%s", slotId, urcToString(urcId));
        if (urc->getError() == RIL_E_SUCCESS) {
            switch (urcId) {
                case RIL_UNSOL_SIGNAL_STRENGTH:
                    updateSignalStrengthCache(urc);
                    urcToRilj = RfxMessage::obtainUrc(urc->getSlotId(), RIL_UNSOL_SIGNAL_STRENGTH);
                    combineSignalStrength(urcToRilj);
                    break;
                case RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED:
                   if (getChipTestMode() == 0) {
                        if (getDeviceMode() == NWS_MODE_CDMALTE
                                && urcId == RIL_UNSOL_RESPONSE_PS_NETWORK_STATE_CHANGED) {
                            logD(RP_NW_STATE_TAG, " PS state change in CdmaLte mode");
                            urcToRilj = RfxMessage::obtainUrc(urc->getSlotId(),
                                    RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED);
                        }
                    } else {
                        sp<RfxMessage> Req
                                = RfxMessage::obtainRequest(m_slot_id,
                                        RADIO_TECH_GROUP_GSM, RIL_REQUEST_VOICE_REGISTRATION_STATE);
                        logD(RP_NW_STATE_TAG,
                                " CS/PS state change. request RIL_REQUEST_VOICE_REGISTRATION_STATE RpNwSC pollState: pToken(%d, %d)",
                                Req->getPToken());
                        RfxMainThread::enqueueMessage(Req);

                    }
                    break;
                case RIL_UNSOL_RESPONSE_PS_NETWORK_STATE_CHANGED:
                    if (getChipTestMode() == 0) {
                        if (getDeviceMode() == NWS_MODE_CDMALTE
                                && urcId == RIL_UNSOL_RESPONSE_PS_NETWORK_STATE_CHANGED) {
                            logD(RP_NW_STATE_TAG, " PS state change in CdmaLte mode");
                            urcToRilj = RfxMessage::obtainUrc(urc->getSlotId(),
                                    RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED);
                        }
                    } else {
                        sp<RfxMessage> Req
                                = RfxMessage::obtainRequest(m_slot_id,
                                        RADIO_TECH_GROUP_GSM, RIL_REQUEST_DATA_REGISTRATION_STATE);
                        logD(RP_NW_STATE_TAG,
                                " CS/PS state change. request RIL_REQUEST_DATA_REGISTRATION_STATE RpNwSC pollState: pToken(%d, %d)",
                                Req->getPToken());
                        RfxMainThread::enqueueMessage(Req);
                    }
                    break;

                case RIL_UNSOL_CDMA_OTA_PROVISION_STATUS:
                    int count;
                    int otaState;
                    int convertState;

                    p = urc->getParcel();
                    p->readInt32(&count);
                    p->readInt32(&otaState);

                    getStatusManager()->setIntValue(RFX_STATUS_KEY_OTA_STATUS, otaState);
                    convertState = convertOtaProvisionStatus(otaState);

                    if (convertState >= 0) {
                        urcToRilj = RfxMessage::obtainUrc(urc->getSlotId(),
                                RIL_UNSOL_CDMA_OTA_PROVISION_STATUS);
                        p = urcToRilj->getParcel();
                        p->writeInt32(count);
                        p->writeInt32(convertState);
                    } else {
                        isNeedResponseUrc = false;
                    }

                    break;
                default:
                    break;
            }
        } else {
            // urc contains error
            logD(RP_NW_STATE_TAG, " URC error");
        }
    }
#else
    //MT2635:gsm case only support GSM Only
    logD(RP_NW_STATE_TAG, " onHandleUrc() GSM SIM%d URC=%s", slotId,
            urcToString(urcId));
    if (urc->getError() == RIL_E_SUCCESS) {
        switch (urcId) {

#if (defined(MODE_DSSS)&& defined(TELE_FWK))
        case RIL_UNSOL_RIL_CONNECTED:
            logD(RP_NW_STATE_TAG,"check major SIM  RIL_UNSOL_RIL_CONNECTED received,slotId=%d, disabled_sim=%d  ",slotId,rfx_get_disabled_sim());
            if(slotId+1 != rfx_get_disabled_sim())//actually enabled slot should set as the major sim.
            {
                 sp<RfxMessage> Req = RfxMessage::obtainRequest(m_slot_id,
                                RADIO_TECH_GROUP_GSM, RIL_REQUEST_GET_RADIO_CAPABILITY);
                logD(RP_NW_STATE_TAG,
                            "major SIM  RIL_UNSOL_RIL_CONNECTED, if it is DSSS status, get the capabilty",
                            Req->getPToken());
                RfxMainThread::enqueueMessage(Req);
            }
            break;
#endif
        case RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED:
            gsmReq = RfxMessage::obtainRequest(m_slot_id,
                    RADIO_TECH_GROUP_GSM,
                    RIL_REQUEST_VOICE_REGISTRATION_STATE);
            RfxMainThread::enqueueMessage(gsmReq);
            break;
        case RIL_UNSOL_RESPONSE_PS_NETWORK_STATE_CHANGED:
            gsmReq = RfxMessage::obtainRequest(m_slot_id,
                    RADIO_TECH_GROUP_GSM,
                    RIL_REQUEST_DATA_REGISTRATION_STATE);
            RfxMainThread::enqueueMessage(gsmReq);
            break;
        case RIL_UNSOL_RESTRICTED_STATE_CHANGED:
            {
                int numInts = 0;
                int response = 0;
                p = urc->getParcel();
                p->readInt32(&numInts);
                if (numInts < 1) {
                    logD(RP_NW_STATE_TAG, " URC error, no restricted data");
                    break;
                }
                p->readInt32(&response);
                bool restricted = (response & RIL_RESTRICTED_STATE_PS_ALL) != 0;
                if (restricted
                        != getStatusManager()->getBoolValue(
                                RFX_STATUS_KEY_PS_RESTRICT_STATE, false)) {
                    getStatusManager()->setBoolValue(
                            RFX_STATUS_KEY_PS_RESTRICT_STATE, restricted, true);
                }
                break;
            }
        default:
            break;
        }
    }
#endif

    if (isNeedResponseUrc) {
        responseToRilj(urcToRilj);
    }
    return true;
}

void RpNwStateController::onSimCardInsertStatusUpdate(RfxStatusKeyEnum key, RfxVariant old_value,
        RfxVariant value)
{
    char uiccType[10] = {0};
    int other_sim_slot = 0; //value is 0,1
    int new_data_sim_slot=rfx_get_data_allowed_slotid(); //value is 0,1

    /*
    *  Caculate the New Data sim on which slot
    *  The last boot-up data sim inserted: keep on old
    *  The last boot-up data sim not inserted & the other sim is not inserted: keep on old
    *  The last boot-up data sim not inserted & the other sim is inserted: move to other sim
    */
    property_get(PROPERTY_RIL_UICC_TYPE[new_data_sim_slot], uiccType, "");
    logD(RP_NW_STATE_TAG, "data sim %d SimCapabilitySwitch,%s= %s",
            new_data_sim_slot, PROPERTY_RIL_UICC_TYPE[new_data_sim_slot],uiccType);
    if (strlen(uiccType) == 0)
    {

        other_sim_slot = (new_data_sim_slot==RFX_SLOT_ID_0)?RFX_SLOT_ID_1: RFX_SLOT_ID_0;
        logD(RP_NW_STATE_TAG, "SimCapabilitySwitch, Current Data SIM is not insert, check other sim");
        property_get(PROPERTY_RIL_UICC_TYPE[other_sim_slot], uiccType, "");
        logD(RP_NW_STATE_TAG, "other sim %d SimCapabilitySwitch,%s= %s",
            other_sim_slot, PROPERTY_RIL_UICC_TYPE[other_sim_slot],uiccType);
        if (strlen(uiccType) != 0) //other sim was inserted
        {
            new_data_sim_slot = other_sim_slot;
            property_set("persist.vendor.radio.data.sim", ((0==new_data_sim_slot)?"1":"2"));
            {
#define SKIP_VALUE (-2)
#define TOTAL_PARAM (5)

                int data_sim = rfx_get_data_allowed_slotid();

                logD(RP_NW_STATE_TAG, "Data SIM change send RIL_REQUEST_SYNC_DATA_SETTINGS_TO_MD data_sim=%d", data_sim);

                sp<RfxMessage> newMsg = RfxMessage::obtainRequest(0,RADIO_TECH_GROUP_GSM, RIL_REQUEST_SYNC_DATA_SETTINGS_TO_MD);
                Parcel* newParcel = newMsg->getParcel();
                size_t pos = newParcel->dataPosition();
                newParcel->writeInt32(TOTAL_PARAM);
                newParcel->writeInt32(SKIP_VALUE);
                newParcel->writeInt32(SKIP_VALUE);
                newParcel->writeInt32(data_sim);
                newParcel->writeInt32(SKIP_VALUE);
                newParcel->writeInt32(SKIP_VALUE);
                requestToRild(newMsg);

            }

        }
    }
    /*Get the current sim capability*/
    sp<RfxMessage> Req = RfxMessage::obtainRequest(m_slot_id,
                    RADIO_TECH_GROUP_GSM, RIL_REQUEST_GET_RADIO_CAPABILITY);
    logD(RP_NW_STATE_TAG, "SimCapabilitySwitch, get the radio capabilty");
    RfxMainThread::enqueueMessage(Req);
    logD(RP_NW_STATE_TAG,"SimCapabilitySwitch Current slot_id=%d, Old data SIM is %d, New Data SIM is %d, ",
        m_slot_id,rfx_get_data_allowed_slotid(), new_data_sim_slot);



}

void RpNwStateController::updateVoiceRegStateCache(const sp<RfxMessage>& msg) {
    int skip;
    int source = msg->getSource();
    int32_t stgCount = -1;
    char **pStrings = NULL;
    Parcel *p = msg->getParcel();

    p->readInt32(&stgCount);
    logD(RP_NW_STATE_TAG, " updateVoiceRegStateCache(): src=%s, stgCount=%d",
            sourceToString(source), stgCount);

    if (stgCount > 0) {
        pStrings = (char **) alloca(sizeof(char *) * stgCount);
        for (int i = 0; i < stgCount; i++) {
            pStrings[i] = strdupReadString(p);
            logD(RP_NW_STATE_TAG, " updateVoiceRegStateCache data[%d]=%s", i, pStrings[i]);
        }
        if (source == RADIO_TECH_GROUP_GSM) {
            gsm_voice_reg_state_cache.register_state   = strtol(pStrings[0], NULL, 10);

            if (!RfxNwServiceState::isInService(gsm_voice_reg_state_cache.register_state))
            {
                gsm_voice_reg_state_cache.lac              = -1;
                gsm_voice_reg_state_cache.cid              = -1;
                gsm_voice_reg_state_cache.radio_technology = 0;
            }
            else
            {
                gsm_voice_reg_state_cache.lac              = strtol(pStrings[1], NULL, 16);
                gsm_voice_reg_state_cache.cid              = strtol(pStrings[2], NULL, 16);
                gsm_voice_reg_state_cache.radio_technology = strtol(pStrings[3], NULL, 10);
                gsm_voice_reg_state_cache.deny_reason      = strtol(pStrings[13], NULL, 10);
            }
            printVoiceCache(gsm_voice_reg_state_cache);
        }
        else if (source == RADIO_TECH_GROUP_C2K) //not support in telematics
        {
            cdma_voice_reg_state_cache.register_state         = strtol(pStrings[0], NULL, 10);
            cdma_voice_reg_state_cache.radio_technology       = strtol(pStrings[3], NULL, 10);
            cdma_voice_reg_state_cache.base_station_id        = strtol(pStrings[4], NULL, 10);
            cdma_voice_reg_state_cache.base_station_latitude  = strtol(pStrings[5], NULL, 10);
            cdma_voice_reg_state_cache.base_station_longitude = strtol(pStrings[6], NULL, 10);
            cdma_voice_reg_state_cache.css                    = strtol(pStrings[7], NULL, 10);
            cdma_voice_reg_state_cache.system_id              = strtol(pStrings[8], NULL, 10);
            cdma_voice_reg_state_cache.network_id             = strtol(pStrings[9], NULL, 10);
            cdma_voice_reg_state_cache.roaming_ind            = strtol(pStrings[10], NULL, 10);
            cdma_voice_reg_state_cache.prl                    = strtol(pStrings[11], NULL, 10);
            cdma_voice_reg_state_cache.prl_roaming_ind        = strtol(pStrings[12], NULL, 10);
            cdma_voice_reg_state_cache.network_exsit          = strtol(pStrings[15], NULL, 10);
            printVoiceCache(cdma_voice_reg_state_cache);
        }
        else {
            // source type invalid!!!
            logD(RP_NW_STATE_TAG, " updateVoiceRegStateCache(): source type invalid!!!");
        }
    }
    if (pStrings != NULL) {
        for (int i = 0; i < stgCount; i++) {
            free(pStrings[i]);
        }
    }
}

int RpNwStateController::calculateCssValue() {
    char prop[255] = {0};
    int ret = 0;

    property_get("ro.mtk_svlte_support", prop, "0");
    if (atoi(prop) == 1 && getDeviceMode() == NWS_MODE_CDMALTE
            && gsm_data_reg_state_cache.radio_technology == RADIO_TECH_LTE) {
        ret = 1;
    }

    return ret;
}

void RpNwStateController::updateDataRegStateCache(const sp<RfxMessage>& msg) {
    int skip;
    int source = msg->getSource();
    int32_t stgCount = -1;
    char **pStrings = NULL;
    Parcel *p = msg->getParcel();

    p->readInt32(&stgCount);
    logD(RP_NW_STATE_TAG, " updateDataRegStateCache(): src=%s, stgCount=%d",
            sourceToString(source), stgCount);

    if (stgCount > 0) {
        pStrings = (char **) alloca(sizeof(char *) * stgCount);
        for (int i = 0; i < stgCount; i++) {
            pStrings[i] = strdupReadString(p);
            logD(RP_NW_STATE_TAG, " updateDataRegStateCache dataCtn[%d]=%s", i, pStrings[i]);
        }
        if (source == RADIO_TECH_GROUP_GSM) {
            gsm_data_reg_state_cache.register_state   = strtol(pStrings[0], NULL, 10);

            if (RfxNwServiceState::isInService(gsm_data_reg_state_cache.register_state))
            {
                gsm_data_reg_state_cache.lac              = strtol(pStrings[1], NULL, 16);
                gsm_data_reg_state_cache.cid              = strtol(pStrings[2], NULL, 16);
                gsm_data_reg_state_cache.radio_technology = strtol(pStrings[3], NULL, 10);
                gsm_data_reg_state_cache.deny_reason      = strtol(pStrings[4], NULL, 10);
                gsm_data_reg_state_cache.max_data_call    = strtol(pStrings[5], NULL, 10);
            }
            else
            {
                gsm_data_reg_state_cache.lac              = -1;
                gsm_data_reg_state_cache.cid              = -1;
                gsm_data_reg_state_cache.radio_technology = 0;
            }
            printDataCache(gsm_data_reg_state_cache);
        } else if (source == RADIO_TECH_GROUP_C2K) {//not support in telematics
            cdma_data_reg_state_cache.register_state   = strtol(pStrings[0], NULL, 10);
            cdma_data_reg_state_cache.radio_technology = strtol(pStrings[3], NULL, 10);
            printDataCache(cdma_data_reg_state_cache);
        } else {
            // source type invalid!!!
            logD(RP_NW_STATE_TAG, " updateDataRegStateCache(): source type invalid!!!");
        }
    }
    if (pStrings != NULL) {
        for (int i = 0; i < stgCount; i++) {
            free(pStrings[i]);
        }
    }
}

void RpNwStateController::updateSignalStrengthCache(const sp<RfxMessage>& msg) {
    int skip;
    int source = msg->getSource();
    Parcel *p = msg->getParcel();

    logD(RP_NW_STATE_TAG, " updateSignalStrengthCache(): src=%s", sourceToString(source));
    if (source == RADIO_TECH_GROUP_GSM) {
        p->readInt32(&signal_strength_cache.gsm_sig1);
        p->readInt32(&signal_strength_cache.gsm_sig2);
        for (int i = 0; i < 5; i++) {
            // skip C2K part
            p->readInt32(&skip);
        }
        p->readInt32(&signal_strength_cache.lte_sig);
        p->readInt32(&signal_strength_cache.lte_rsrp);
        p->readInt32(&signal_strength_cache.lte_rsrq);
        p->readInt32(&signal_strength_cache.lte_rssnr);
        p->readInt32(&signal_strength_cache.lte_cqi);
        p->readInt32(&signal_strength_cache.rssi_qdbm);
        p->readInt32(&signal_strength_cache.rscp_qdbm);
        p->readInt32(&signal_strength_cache.ecn0_qdbm);
    } else if (source == RADIO_TECH_GROUP_C2K) {
        for (int i = 0; i < 2; i++) {
            // skip GSM part
            p->readInt32(&skip);
        }
        p->readInt32(&signal_strength_cache.cdma_dbm);
        p->readInt32(&signal_strength_cache.cdma_ecio);
        p->readInt32(&signal_strength_cache.ecdo_dbm);
        p->readInt32(&signal_strength_cache.evdo_ecio);
        p->readInt32(&signal_strength_cache.evdo_snr);
    } else {
        // source type invalid!!!
    }
}

void RpNwStateController::updateOperatorCache(const sp<RfxMessage>& msg) {
    int source = msg->getSource();
    int32_t stgCount = -1;
    char **pStrings = NULL;
    Parcel *p = msg->getParcel();

    p->readInt32(&stgCount);
    logD(RP_NW_STATE_TAG, " updateOperatorCache(): src=%s, stgCount=%d",
            sourceToString(source), stgCount);

    if (stgCount > 0) {
        pStrings = (char **) alloca(sizeof(char *) * stgCount);
        for (int i = 0; i < stgCount; i++) {
            pStrings[i] = strdupReadString(p);
            //logD(RP_NW_STATE_TAG, " updateOperatorCache(): data=%s", pStrings[i]);
        }
        if (source == RADIO_TECH_GROUP_GSM) {
            gsm_operator_cache.count = stgCount;
            if (stgCount == 3) {
                if (pStrings[0] != NULL) {
                    strncpy(gsm_operator_cache.optrAlphaLong, pStrings[0], MAX_OPER_NAME_LENGTH);
                } else {
                    gsm_operator_cache.optrAlphaLong[0] = '\0';
                    logD(RP_NW_STATE_TAG, " updateOperatorCache(): pStrings[0]=null!!");
                }
                if (pStrings[1] != NULL) {
                    strncpy(gsm_operator_cache.optrAlphaShort, pStrings[1], MAX_OPER_NAME_LENGTH);
                } else {
                    gsm_operator_cache.optrAlphaShort[0] = '\0';
                    logD(RP_NW_STATE_TAG, " updateOperatorCache(): pStrings[1]=null!!");
                }
                if (pStrings[2] != NULL) {
                    strncpy(gsm_operator_cache.optrNumeric, pStrings[2], MAX_OPER_NUM_LENGTH);
                } else {
                    gsm_operator_cache.optrNumeric[0] = '\0';
                    logD(RP_NW_STATE_TAG, " updateOperatorCache(): pStrings[2]=null!!");
                }
                gsm_operator_cache.optrAlphaLong[MAX_OPER_NAME_LENGTH - 1] = '\0';
                gsm_operator_cache.optrAlphaShort[MAX_OPER_NAME_LENGTH - 1] = '\0';
                gsm_operator_cache.optrNumeric[MAX_OPER_NUM_LENGTH - 1] = '\0';
            } else if (stgCount == 1) {
                strncpy(gsm_operator_cache.optrAlphaLong, pStrings[0], MAX_OPER_NAME_LENGTH);
                gsm_operator_cache.optrAlphaLong[MAX_OPER_NAME_LENGTH - 1] = '\0';
                memset(gsm_operator_cache.optrAlphaShort, '\0',
                        MAX_OPER_NAME_LENGTH * sizeof(char));
                memset(gsm_operator_cache.optrNumeric, '\0',
                        MAX_OPER_NUM_LENGTH * sizeof(char));
            } else {
                resetOperatorCache(&gsm_operator_cache);
            }
            printOperatorCache(gsm_operator_cache);
        } else if (source == RADIO_TECH_GROUP_C2K) {
            cdma_operator_cache.count = stgCount;
            if (stgCount == 3) {
                strncpy(cdma_operator_cache.optrAlphaLong, pStrings[0], MAX_OPER_NAME_LENGTH);
                strncpy(cdma_operator_cache.optrAlphaShort, pStrings[1], MAX_OPER_NAME_LENGTH);
                strncpy(cdma_operator_cache.optrNumeric, pStrings[2], MAX_OPER_NUM_LENGTH);
                cdma_operator_cache.optrAlphaLong[MAX_OPER_NAME_LENGTH - 1] = '\0';
                cdma_operator_cache.optrAlphaShort[MAX_OPER_NAME_LENGTH - 1] = '\0';
                cdma_operator_cache.optrNumeric[MAX_OPER_NUM_LENGTH - 1] = '\0';
            } else {
                resetOperatorCache(&cdma_operator_cache);
            }
            printOperatorCache(cdma_operator_cache);
        } else {
            // source type invalid!!!
            logD(RP_NW_STATE_TAG, " updateOperatorCache(): source type invalid!!!");
        }
    }
    if (pStrings != NULL) {
        for (int i = 0; i < stgCount; i++) {
            free(pStrings[i]);
        }
    }
}

void RpNwStateController::combineVoiceRegState(const sp<RfxMessage>& msg) {
//    int stgCount = 16;
//    char *stgBuf = (char *) malloc(50);
    // decide common info
    if (RfxNwServiceState::isInService(gsm_voice_reg_state_cache.register_state)) {
        mVoiceRadioSys = RADIO_TECH_GROUP_GSM;
        mVoiceRegState = gsm_voice_reg_state_cache.register_state;
        mVoiceRadioTech = gsm_voice_reg_state_cache.radio_technology;
        if (RfxNwServiceState::isInService(cdma_voice_reg_state_cache.register_state)
                && getDeviceMode() == NWS_MODE_CDMALTE
                && mVoiceRadioTech == RADIO_TECH_LTE) {
            logD(RP_NW_STATE_TAG, " SRLTE mode 1x & LTE both connected!! Select 1x");
            mVoiceRadioSys = RADIO_TECH_GROUP_C2K;
            mVoiceRegState = cdma_voice_reg_state_cache.register_state;
            mVoiceRadioTech = cdma_voice_reg_state_cache.radio_technology;
        }
    } else if (RfxNwServiceState::isInService(cdma_voice_reg_state_cache.register_state)) {
        mVoiceRadioSys = RADIO_TECH_GROUP_C2K;
        mVoiceRegState = cdma_voice_reg_state_cache.register_state;
        mVoiceRadioTech = cdma_voice_reg_state_cache.radio_technology;
    } else {
        if (getDeviceMode() == NWS_MODE_CDMALTE) {
            mVoiceRegState = cdma_voice_reg_state_cache.register_state;
            mVoiceRadioTech = cdma_voice_reg_state_cache.radio_technology;
        } else {
            mVoiceRegState = gsm_voice_reg_state_cache.register_state;
            mVoiceRadioTech = gsm_voice_reg_state_cache.radio_technology;
        }
    }

    /** MT2635: only for GSM
    // set combine result to parcel
    Parcel *p = msg->getParcel();
    p->writeInt32(stgCount);

    sprintf(stgBuf, "%d", mVoiceRegState);
    writeStringToParcel(p, stgBuf);

    sprintf(stgBuf, "%x", gsm_voice_reg_state_cache.lac);
    writeStringToParcel(p, stgBuf);

    sprintf(stgBuf, "%x", gsm_voice_reg_state_cache.cid);
    writeStringToParcel(p, stgBuf);

    sprintf(stgBuf, "%d", mVoiceRadioTech);
    writeStringToParcel(p, stgBuf);

    sprintf(stgBuf, "%d", cdma_voice_reg_state_cache.base_station_id);
    writeStringToParcel(p, stgBuf);

    sprintf(stgBuf, "%d", cdma_voice_reg_state_cache.base_station_latitude);
    writeStringToParcel(p, stgBuf);

    sprintf(stgBuf, "%d", cdma_voice_reg_state_cache.base_station_longitude);
    writeStringToParcel(p, stgBuf);

    sprintf(stgBuf, "%d", cdma_voice_reg_state_cache.css);
    writeStringToParcel(p, stgBuf);

    sprintf(stgBuf, "%d", cdma_voice_reg_state_cache.system_id);
    writeStringToParcel(p, stgBuf);

    sprintf(stgBuf, "%d", cdma_voice_reg_state_cache.network_id);
    writeStringToParcel(p, stgBuf);

    sprintf(stgBuf, "%d", cdma_voice_reg_state_cache.roaming_ind);
    writeStringToParcel(p, stgBuf);

    sprintf(stgBuf, "%d", cdma_voice_reg_state_cache.prl);
    writeStringToParcel(p, stgBuf);

    sprintf(stgBuf, "%d", cdma_voice_reg_state_cache.prl_roaming_ind);
    writeStringToParcel(p, stgBuf);

    sprintf(stgBuf, "%d", gsm_voice_reg_state_cache.deny_reason);
    writeStringToParcel(p, stgBuf);

    writeStringToParcel(p, "-1");  // Default value for psc, so far, nobody parse it

    sprintf(stgBuf, "%d", cdma_voice_reg_state_cache.network_exsit);
    writeStringToParcel(p, stgBuf);
    */

    logD(RP_NW_STATE_TAG, " combineVoiceRegState(): reg=%d, rat=%d",
            mVoiceRegState, mVoiceRadioTech);
    getStatusManager()->setServiceStateValue(RFX_STATUS_KEY_SERVICE_STATE,
            RfxNwServiceState(mVoiceRegState, mDataRegState, mVoiceRadioTech, mDataRadioTech));
//    free(stgBuf);
}

void RpNwStateController::combineDataRegState(const sp<RfxMessage>& msg) {
//    int stgCount = 6;
//    char *stgBuf = (char *) malloc(50);
    // decide common info
    if (RfxNwServiceState::isInService(gsm_data_reg_state_cache.register_state)) {
        mDataRadioSys = RADIO_TECH_GROUP_GSM;
        mDataRegState = gsm_data_reg_state_cache.register_state;
        mDataRadioTech = gsm_data_reg_state_cache.radio_technology;
    } else if (RfxNwServiceState::isInService(cdma_data_reg_state_cache.register_state)) {
        mDataRadioSys = RADIO_TECH_GROUP_C2K;
        mDataRegState = cdma_data_reg_state_cache.register_state;
        mDataRadioTech = cdma_data_reg_state_cache.radio_technology;
    } else {
        mDataRegState = gsm_data_reg_state_cache.register_state;
        mDataRadioTech = gsm_data_reg_state_cache.radio_technology;
        if (getDeviceMode() == NWS_MODE_CDMALTE) {
            int radioCapability = getStatusManager()->getIntValue(
                    RFX_STATUS_KEY_RADIO_CAPABILITY, RIL_CAPABILITY_NONE);
            if (radioCapability == RIL_CAPABILITY_CDMA_ONLY) {
                mDataRegState = cdma_data_reg_state_cache.register_state;
                mDataRadioTech = cdma_data_reg_state_cache.radio_technology;
            } else {
                if (mDataRadioSys == RADIO_TECH_GROUP_C2K) {
                    mDataRegState = cdma_data_reg_state_cache.register_state;
                    mDataRadioTech = cdma_data_reg_state_cache.radio_technology;
                }
            }
        }
    }

    // set combine result to parcel

    /** MT2635: only for GSM
    Parcel *p = msg->getParcel();
    p->writeInt32(stgCount);

    sprintf(stgBuf, "%d", mDataRegState);
    writeStringToParcel(p, stgBuf);

    if (gsm_data_reg_state_cache.lac != -1) {
        sprintf(stgBuf, "%x", gsm_data_reg_state_cache.lac);
    } else {
        sprintf(stgBuf, "%d", gsm_data_reg_state_cache.lac);
    }
    writeStringToParcel(p, stgBuf);

    if (gsm_data_reg_state_cache.cid != -1) {
        sprintf(stgBuf, "%x", gsm_data_reg_state_cache.cid);
    } else {
        sprintf(stgBuf, "%d", gsm_data_reg_state_cache.cid);
    }
    writeStringToParcel(p, stgBuf);

    sprintf(stgBuf, "%d", mDataRadioTech);
    writeStringToParcel(p, stgBuf);

    sprintf(stgBuf, "%d", gsm_data_reg_state_cache.deny_reason);
    writeStringToParcel(p, stgBuf);

    sprintf(stgBuf, "%d", gsm_data_reg_state_cache.max_data_call);
    writeStringToParcel(p, stgBuf);
    */

    logD(RP_NW_STATE_TAG, " combineDataRegState(): reg=%d, rat=%d",
            mDataRegState, mDataRadioTech);
    getStatusManager()->setServiceStateValue(RFX_STATUS_KEY_SERVICE_STATE,
            RfxNwServiceState(mVoiceRegState, mDataRegState, mVoiceRadioTech, mDataRadioTech));
//    free(stgBuf);
}

void RpNwStateController::combineSignalStrength(const sp<RfxMessage>& msg) {
    Parcel *p = msg->getParcel();

    p->writeInt32(signal_strength_cache.gsm_sig1);
    p->writeInt32(signal_strength_cache.gsm_sig2);
    p->writeInt32(signal_strength_cache.cdma_dbm);
    p->writeInt32(signal_strength_cache.cdma_ecio);
    p->writeInt32(signal_strength_cache.ecdo_dbm);
    p->writeInt32(signal_strength_cache.evdo_ecio);
    p->writeInt32(signal_strength_cache.evdo_snr);
    p->writeInt32(signal_strength_cache.lte_sig);
    p->writeInt32(signal_strength_cache.lte_rsrp);
    p->writeInt32(signal_strength_cache.lte_rsrq);
    p->writeInt32(signal_strength_cache.lte_rssnr);
    p->writeInt32(signal_strength_cache.lte_cqi);
    p->writeInt32(signal_strength_cache.rssi_qdbm);
    p->writeInt32(signal_strength_cache.rscp_qdbm);
    p->writeInt32(signal_strength_cache.ecn0_qdbm);
    printSignalStrengthCache(signal_strength_cache);
}

void RpNwStateController::combineOperatorState(const sp<RfxMessage>& msg) {
    Parcel *p = msg->getParcel();
    RIL_OPERATOR_CACHE optrCache = gsm_operator_cache;

    if (getDeviceMode() == NWS_MODE_CDMALTE) {
        if (RfxNwServiceState::isInService(cdma_data_reg_state_cache.register_state)) {
            logD(RP_NW_STATE_TAG, " combineOperatorState(): C2K ps in service");
            optrCache = cdma_operator_cache;
        } else if (RfxNwServiceState::isInService(cdma_voice_reg_state_cache.register_state)
                && !RfxNwServiceState::isInService(gsm_data_reg_state_cache.register_state)) {
            logD(RP_NW_STATE_TAG, " combineOperatorState(): C2K cs in service");
            optrCache = cdma_operator_cache;
        } else if (mDataRadioSys == RADIO_TECH_GROUP_C2K) {
            logD(RP_NW_STATE_TAG, " combineOperatorState(): C2K = mDataRadioSys");
            optrCache = cdma_operator_cache;
        } else if (strncmp("000000", gsm_operator_cache.optrNumeric, 6) == 0) {
            logD(RP_NW_STATE_TAG, " combineOperatorState(): GSM numeric invalid");
            optrCache = cdma_operator_cache;
        }
    }
    logD(RP_NW_STATE_TAG, " combineOperatorState(): count=%d", optrCache.count);
    p->writeInt32(optrCache.count);
    if (optrCache.count == 3) {
        writeStringToParcel(p, optrCache.optrAlphaLong);
        writeStringToParcel(p, optrCache.optrAlphaShort);
        writeStringToParcel(p, optrCache.optrNumeric);
    } else if (optrCache.count == 1) {
        writeStringToParcel(p, optrCache.optrAlphaLong);
    }
}

bool RpNwStateController::onHandleResponse(const sp<RfxMessage>& response) {
    int reqId = response->getId();
    int slotId = response->getSlotId();
    int source = response->getSource();
    sp<RfxMessage> responseInQueue;
    sp<RfxMessage> responseMd1;
    sp<RfxMessage> responseMd3;
    ResponseStatus responseStatus;

    // MT2635: gsm case handle resposne
    logD(RP_NW_STATE_TAG, " onHandleResponse() only GSM SIM%d req=%s src=%s", slotId,
            requestToString(reqId), sourceToString(source));
    responseMd1 = response;
    responseMd3 = sp<RfxMessage>(NULL);
    switch (reqId) {
    case RIL_REQUEST_VOICE_REGISTRATION_STATE:
        onReceiveVoiceRegStateResponse(responseMd1, responseMd3);
        break;
    case RIL_REQUEST_DATA_REGISTRATION_STATE:
        onReceiveDataRegStateResponse(responseMd1, responseMd3);
        break;

#if defined(TELE_FWK)
    case RIL_REQUEST_GET_RADIO_CAPABILITY:
        {
        logD(RP_NW_STATE_TAG, "SimCapabilitySwitch GET RADIO CAPABILITY response");


#if defined(MODE_DSSS)
        logD(RP_NW_STATE_TAG," not major SIM, change to major,slotId=%d, disabled_sim=%d  ",slotId,rfx_get_disabled_sim());
        if(slotId+1 != rfx_get_disabled_sim())//actually enabled slot should set as the major sim.
#else
        if(slotId == rfx_get_data_allowed_slotid())//actually enabled slot should set as the major sim.
#endif
        {

            Parcel *p = response->getParcel();
            RIL_RadioCapability p_cur;
            char *logicalModemUuid;
            p->readInt32(&p_cur.version);
            p->readInt32(&p_cur.session);
            p->readInt32(&p_cur.phase);
            p->readInt32(&p_cur.rat);
            logicalModemUuid =strdupReadString(p);
            p->readInt32(&p_cur.status);
            logD(RP_NW_STATE_TAG,"SimCapabilitySwitch current SIM logicalModemUuid =%s",logicalModemUuid );
            if(NULL==strstr(logicalModemUuid, "ps0")) //not major sim
            {
                logD(RP_NW_STATE_TAG,"SimCapabilitySwitch not major SIM, change to major, obtainRequest RIL_REQUEST_SET_RADIO_CAPABILITY");
                sp<RfxMessage> Req = RfxMessage::obtainRequest(m_slot_id,RADIO_TECH_GROUP_GSM, RIL_REQUEST_SET_RADIO_CAPABILITY);
                Parcel *p_set = Req->getParcel();
                p_set->writeInt32(p_cur.version);
                p_set->writeInt32(p_cur.session);
                p_set->writeInt32(2);
                p_set->writeInt32(p_cur.rat);
                writeStringToParcel(p_set, "modem_sys1_ps0");
                p_set->writeInt32(p_cur.status);
                logD(RP_NW_STATE_TAG,"SimCapabilitySwitch not major SIM, change to major, rat %d ",p_cur.rat);
                RfxMainThread::enqueueMessage(Req);

            }
            else
            {
               //Set SIM enable because not data sim capability
#if  defined(ANDROID_MULTI_SIM)
                sp<RfxMessage> newMsg = RfxMessage::obtainRequest(getSlotId(),RADIO_TECH_GROUP_GSM, RIL_REQUEST_ALLOW_DATA);
                Parcel* newParcel = newMsg->getParcel();
                size_t pos = newParcel->dataPosition();
                newParcel->writeInt32(1); //num of ints
                newParcel->writeInt32(1);
                logD(RP_NW_STATE_TAG,"SimCapabilitySwitch clear all sim data capability SetDataAttached = 0");
                requestToRild(newMsg);
#endif
            }
        }
        else
        {
            //Clear SIM enable because not data sim capability
#if  defined(ANDROID_MULTI_SIM)

            sp<RfxMessage> newMsg = RfxMessage::obtainRequest(getSlotId(),RADIO_TECH_GROUP_GSM, RIL_REQUEST_ALLOW_DATA);
            Parcel* newParcel = newMsg->getParcel();
            size_t pos = newParcel->dataPosition();
            newParcel->writeInt32(1); //num of ints
            newParcel->writeInt32(0);
            logD(RP_NW_STATE_TAG,"SimCapabilitySwitch clear all sim data capability SetDataAttached = 0");
            requestToRild(newMsg);
#endif
        }
        {// send RIL_REQUEST_VOICE_REGISTRATION_STATE to update the radio status

            sp<RfxMessage> Req = RfxMessage::obtainRequest(m_slot_id,
                                            RADIO_TECH_GROUP_GSM, RIL_REQUEST_VOICE_REGISTRATION_STATE);
            logD(RP_NW_STATE_TAG,"send RIL_REQUEST_VOICE_REGISTRATION_STATE to update the radio status");
            RfxMainThread::enqueueMessage(Req);
        }
        {// send RIL_REQUEST_DATA_REGISTRATION_STATE to update the radio status
            sp<RfxMessage> Req = RfxMessage::obtainRequest(m_slot_id,
                                            RADIO_TECH_GROUP_GSM, RIL_REQUEST_DATA_REGISTRATION_STATE);
            logD(RP_NW_STATE_TAG,"send RIL_REQUEST_DATA_REGISTRATION_STATE to update the radio status");
            RfxMainThread::enqueueMessage(Req);
        }

        responseToRilj(response);  //no need ro report to rilj
        }
        break;
    case RIL_REQUEST_SET_RADIO_CAPABILITY:
        {
        logD(RP_NW_STATE_TAG, "SimCapabilitySwitch SET RADIO CAPABILITY response");

//set the SIM EDALLOWED
#if  defined(ANDROID_MULTI_SIM)
        sp<RfxMessage> newMsg;
        Parcel* newParcel;
        int main_slot = -1;
        size_t pos;
        main_slot = rfx_get_data_allowed_slotid();
        if(rfx_check_if_DSSS_IC()){     //If it is DSSS IC, radio power on should be sent to main protocol slot by tele_fwk
            if(getSlotId() == main_slot){     
                if(RIL_E_SUCCESS == response->getError()){
                    newMsg = RfxMessage::obtainRequest(getSlotId(),RADIO_TECH_GROUP_GSM, RIL_REQUEST_RADIO_POWER); 
                    newParcel = newMsg->getParcel();
                    newParcel->writeInt32(1);
                    newParcel->writeInt32(1);
                    requestToRild(newMsg);
                }else{
                    logD(RP_NW_STATE_TAG, "set radio capability error!");
                }
            }            
        }
        newMsg = RfxMessage::obtainRequest(getSlotId(),RADIO_TECH_GROUP_GSM, RIL_REQUEST_ALLOW_DATA);
        newParcel = newMsg->getParcel();
        pos = newParcel->dataPosition();
        logD(RP_NW_STATE_TAG,"SimCapabilitySwitch set the actually enable data capability");
        newParcel->writeInt32(1); //num of ints
#if  defined(MODE_DSSS)//dsss
        if(getSlotId() == rfx_get_data_allowed_slotid())
        {
            newParcel->writeInt32(1); //default set the allow data enabled.
            logD(RP_NW_STATE_TAG,"SimCapabilitySwitch dsss SetDataAttached = 1");
        }
        else
        {
            newParcel->writeInt32(0); //default set the allow data enabled.
            logD(RP_NW_STATE_TAG,"SimCapabilitySwitch dsss SetDataAttached = 0");
        }
#else //dsds
        if(getSlotId() == rfx_get_data_allowed_slotid())
        {
            newParcel->writeInt32(1); //default set the allow data enabled.
            logD(RP_NW_STATE_TAG,"SimCapabilitySwitch dsds SetDataAttached = 1");
        }
        else
        {
            newParcel->writeInt32(0); //default set the allow data enabled.
            logD(RP_NW_STATE_TAG,"SimCapabilitySwitch dsds SetDataAttached = 0");
        }

#endif
        requestToRild(newMsg);

#endif
        responseToRilj(response);  //no need ro report to rilj
        }
        break;
#endif

    default:
        responseToRilj(response);
        break;
    }

    return true;
}

void RpNwStateController::onReceiveVoiceRegStateResponse(
        const sp<RfxMessage>& responseMd1, const sp<RfxMessage>& responseMd3) {
    int errInd = 0;
    sp<RfxMessage> resToRilj;

    if (responseMd1 != NULL && responseMd1->getError() == RIL_E_SUCCESS) {
        updateVoiceRegStateCache(responseMd1);
        logD(RP_NW_STATE_TAG, " GSM voice response ok");
    } else {
        // response contains error
        errInd |= 1;
        resetVoiceRegStateCache(&gsm_voice_reg_state_cache);
        logD(RP_NW_STATE_TAG, " GSM voice response error");
    }
    if (responseMd3 != NULL && responseMd3->getError() == RIL_E_SUCCESS) {
        updateVoiceRegStateCache(responseMd3);
        logD(RP_NW_STATE_TAG, " C2K voice response ok");
    } else {
        // response contains error
        errInd |= 2;
        resetVoiceRegStateCache(&cdma_voice_reg_state_cache);
        logD(RP_NW_STATE_TAG, " C2K voice response error");
    }
    /** MT2635: only for GSM
    resToRilj = genResponseForRilj(errInd, responseMd1, responseMd3);
    **/
    resToRilj = responseMd1;
    if (errInd < 3) {
        combineVoiceRegState(resToRilj);
    }

    responseToRilj(resToRilj);
}

void RpNwStateController::onReceiveDataRegStateResponse(
        const sp<RfxMessage>& responseMd1, const sp<RfxMessage>& responseMd3) {
    int errInd = 0;
    sp<RfxMessage> resToRilj;

    if (responseMd1 != NULL && responseMd1->getError() == RIL_E_SUCCESS) {
        updateDataRegStateCache(responseMd1);
        logD(RP_NW_STATE_TAG, " GSM data response ok");
    } else {
        // response contains error
        errInd |= 1;
        resetDataRegStateCache(&gsm_data_reg_state_cache);
        logD(RP_NW_STATE_TAG, " GSM data response error");
    }
    if (responseMd3 != NULL && responseMd3->getError() == RIL_E_SUCCESS) {
        updateDataRegStateCache(responseMd3);
        logD(RP_NW_STATE_TAG, " C2K data response ok");
    } else {
        // response contains error
        errInd |= 2;
        resetDataRegStateCache(&cdma_data_reg_state_cache);
        logD(RP_NW_STATE_TAG, " C2K data response error");
    }
    /** MT2635: only for GSM
    resToRilj = genResponseForRilj(errInd, responseMd1, responseMd3);
    **/
    resToRilj = responseMd1;
    if (errInd < 3) {
        combineDataRegState(resToRilj);
    }

    responseToRilj(resToRilj);
}

void RpNwStateController::onReceiveSignalStrengthResponse(
        const sp<RfxMessage>& responseMd1, const sp<RfxMessage>& responseMd3) {
    int errInd = 0;
    sp<RfxMessage> resToRilj;

    if (responseMd1->getError() == RIL_E_SUCCESS) {
        updateSignalStrengthCache(responseMd1);
        logD(RP_NW_STATE_TAG, " GSM sig response ok");
    } else {
        // response contains error
        errInd |= 1;
        logD(RP_NW_STATE_TAG, " GSM sig response error");
    }
    if (responseMd3->getError() == RIL_E_SUCCESS) {
        updateSignalStrengthCache(responseMd3);
        logD(RP_NW_STATE_TAG, " C2K sig response ok");
    } else {
        // response contains error
        errInd |= 2;
        logD(RP_NW_STATE_TAG, " C2K sig response error");
    }
    resToRilj = genResponseForRilj(errInd, responseMd1, responseMd3);
    if (errInd < 3) {
        combineSignalStrength(resToRilj);
    }

    responseToRilj(resToRilj);
}

void RpNwStateController::onReceiveOperatorResponse(
        const sp<RfxMessage>& responseMd1, const sp<RfxMessage>& responseMd3) {
    int errInd = 0;
    sp<RfxMessage> resToRilj;

    if (responseMd1->getError() == RIL_E_SUCCESS) {
        updateOperatorCache(responseMd1);
        logD(RP_NW_STATE_TAG, " GSM optr response ok");
    } else {
        // response contains error
        errInd |= 1;
        resetOperatorCache(&gsm_operator_cache);
        logD(RP_NW_STATE_TAG, " GSM optr response error");
    }

    if (responseMd3->getError() == RIL_E_SUCCESS) {
        updateOperatorCache(responseMd3);
        logD(RP_NW_STATE_TAG, " C2K optr response ok");
    } else {
        // response contains error
        errInd |= 2;
        resetOperatorCache(&cdma_operator_cache);
        logD(RP_NW_STATE_TAG, " C2K optr response error");
    }

    resToRilj = genResponseForRilj(errInd, responseMd1, responseMd3);
    if (errInd < 3) {
        combineOperatorState(resToRilj);
    }

    responseToRilj(resToRilj);
}

void RpNwStateController::updateCellInfoCache(const sp<RfxMessage>& msg) {
    int source = msg->getSource();
    int32_t infoCount = 0;
    Parcel *p = msg->getParcel();

    p->readInt32(&infoCount);
    logD(RP_NW_STATE_TAG, " updateCellInfoCache(): src=%s, infoCount=%d",
            sourceToString(source), infoCount);

    for (int i = 0; i < infoCount; i++) {
        int infoType = 0;
        int stampType = 0;
        int64_t timeStamp = 0;
        RIL_CellInfo cellInfo;
        p->readInt32(&infoType);
        p->readInt32(&cellInfo.registered);
        p->readInt32(&stampType);
        p->readInt64(&timeStamp);
        cellInfo.timeStamp = (uint64_t) timeStamp;
        logD(RP_NW_STATE_TAG, " updateCellInfoCache(): info%d , type:%d",
                i, infoType);
        switch(stampType) {
            case RIL_TIMESTAMP_TYPE_UNKNOWN: {
                cellInfo.timeStampType = RIL_TIMESTAMP_TYPE_UNKNOWN;
                break;
            }
            case RIL_TIMESTAMP_TYPE_ANTENNA: {
                cellInfo.timeStampType = RIL_TIMESTAMP_TYPE_ANTENNA;
                break;
            }
            case RIL_TIMESTAMP_TYPE_MODEM: {
                cellInfo.timeStampType = RIL_TIMESTAMP_TYPE_MODEM;
                break;
            }
            case RIL_TIMESTAMP_TYPE_OEM_RIL: {
                cellInfo.timeStampType = RIL_TIMESTAMP_TYPE_OEM_RIL;
                break;
            }
            case RIL_TIMESTAMP_TYPE_JAVA_RIL: {
                cellInfo.timeStampType = RIL_TIMESTAMP_TYPE_JAVA_RIL;
                break;
            }
            default:
                cellInfo.timeStampType = RIL_TIMESTAMP_TYPE_UNKNOWN;
        }
        switch(infoType) {
            case RIL_CELL_INFO_TYPE_GSM: {
                cellInfo.cellInfoType = RIL_CELL_INFO_TYPE_GSM;
                p->readInt32(&cellInfo.CellInfo.gsm.cellIdentityGsm.mcc);
                p->readInt32(&cellInfo.CellInfo.gsm.cellIdentityGsm.mnc);
                p->readInt32(&cellInfo.CellInfo.gsm.cellIdentityGsm.lac);
                p->readInt32(&cellInfo.CellInfo.gsm.cellIdentityGsm.cid);
                p->readInt32(&cellInfo.CellInfo.gsm.signalStrengthGsm.signalStrength);
                p->readInt32(&cellInfo.CellInfo.gsm.signalStrengthGsm.bitErrorRate);
                break;
            }
            case RIL_CELL_INFO_TYPE_WCDMA: {
                cellInfo.cellInfoType = RIL_CELL_INFO_TYPE_WCDMA;
                p->readInt32(&cellInfo.CellInfo.wcdma.cellIdentityWcdma.mcc);
                p->readInt32(&cellInfo.CellInfo.wcdma.cellIdentityWcdma.mnc);
                p->readInt32(&cellInfo.CellInfo.wcdma.cellIdentityWcdma.lac);
                p->readInt32(&cellInfo.CellInfo.wcdma.cellIdentityWcdma.cid);
                p->readInt32(&cellInfo.CellInfo.wcdma.cellIdentityWcdma.psc);
                p->readInt32(&cellInfo.CellInfo.wcdma.signalStrengthWcdma.signalStrength);
                p->readInt32(&cellInfo.CellInfo.wcdma.signalStrengthWcdma.bitErrorRate);
                break;
            }
            case RIL_CELL_INFO_TYPE_CDMA: {
                cellInfo.cellInfoType = RIL_CELL_INFO_TYPE_CDMA;
                p->readInt32(&cellInfo.CellInfo.cdma.cellIdentityCdma.networkId);
                p->readInt32(&cellInfo.CellInfo.cdma.cellIdentityCdma.systemId);
                p->readInt32(&cellInfo.CellInfo.cdma.cellIdentityCdma.basestationId);
                p->readInt32(&cellInfo.CellInfo.cdma.cellIdentityCdma.longitude);
                p->readInt32(&cellInfo.CellInfo.cdma.cellIdentityCdma.latitude);

                p->readInt32(&cellInfo.CellInfo.cdma.signalStrengthCdma.dbm);
                p->readInt32(&cellInfo.CellInfo.cdma.signalStrengthCdma.ecio);
                p->readInt32(&cellInfo.CellInfo.cdma.signalStrengthEvdo.dbm);
                p->readInt32(&cellInfo.CellInfo.cdma.signalStrengthEvdo.ecio);
                p->readInt32(&cellInfo.CellInfo.cdma.signalStrengthEvdo.signalNoiseRatio);
                break;
            }
            case RIL_CELL_INFO_TYPE_LTE: {
                cellInfo.cellInfoType = RIL_CELL_INFO_TYPE_LTE;
                p->readInt32(&cellInfo.CellInfo.lte.cellIdentityLte.mcc);
                p->readInt32(&cellInfo.CellInfo.lte.cellIdentityLte.mnc);
                p->readInt32(&cellInfo.CellInfo.lte.cellIdentityLte.ci);
                p->readInt32(&cellInfo.CellInfo.lte.cellIdentityLte.pci);
                p->readInt32(&cellInfo.CellInfo.lte.cellIdentityLte.tac);
                /*Typethree add for T800 earfcn 2022/05/30 start*/
                p->readInt32(&cellInfo.CellInfo.lte.cellIdentityLte.earfcn);
                /*Typethree add for T800 earfcn 2022/05/30 end*/
                p->readInt32(&cellInfo.CellInfo.lte.signalStrengthLte.signalStrength);
                p->readInt32(&cellInfo.CellInfo.lte.signalStrengthLte.rsrp);
                p->readInt32(&cellInfo.CellInfo.lte.signalStrengthLte.rsrq);
                p->readInt32(&cellInfo.CellInfo.lte.signalStrengthLte.rssnr);
                p->readInt32(&cellInfo.CellInfo.lte.signalStrengthLte.cqi);
                p->readInt32(&cellInfo.CellInfo.lte.signalStrengthLte.timingAdvance);
                break;
            }
            case RIL_CELL_INFO_TYPE_TD_SCDMA: {
                cellInfo.cellInfoType = RIL_CELL_INFO_TYPE_TD_SCDMA;
                p->readInt32(&cellInfo.CellInfo.tdscdma.cellIdentityTdscdma.mcc);
                p->readInt32(&cellInfo.CellInfo.tdscdma.cellIdentityTdscdma.mnc);
                p->readInt32(&cellInfo.CellInfo.tdscdma.cellIdentityTdscdma.lac);
                p->readInt32(&cellInfo.CellInfo.tdscdma.cellIdentityTdscdma.cid);
                p->readInt32(&cellInfo.CellInfo.tdscdma.cellIdentityTdscdma.cpid);
                p->readInt32(&cellInfo.CellInfo.tdscdma.signalStrengthTdscdma.rscp);
                break;
            }
        }
        cell_info_cache.add(cellInfo);
    }
}

void RpNwStateController::onReceiveCellInfoList(
            const sp<RfxMessage>& responseMd1, const sp<RfxMessage>& responseMd3) {
    int errInd = 0;
    sp<RfxMessage> resToRilj;

    if (responseMd1->getError() == RIL_E_SUCCESS) {
        updateCellInfoCache(responseMd1);
        logD(RP_NW_STATE_TAG, " GSM optr response ok");
    } else {
        // response contains error
        errInd |= 1;
        logD(RP_NW_STATE_TAG, " GSM optr response error");
    }
    if (responseMd3->getError() == RIL_E_SUCCESS) {
        updateCellInfoCache(responseMd3);
        logD(RP_NW_STATE_TAG, " C2K optr response ok");
    } else {
        // response contains error
        errInd |= 2;
        logD(RP_NW_STATE_TAG, " C2K optr response error");
    }
    resToRilj = genResponseForRilj(errInd, responseMd1, responseMd3);
    if (errInd < 3) {
        combineOperatorState(resToRilj);
    }

    responseToRilj(resToRilj);
}

sp<RfxMessage> RpNwStateController::genResponseForRilj(int errInd,
        const sp<RfxMessage>& responseMd1, const sp<RfxMessage>& responseMd3) {
    sp<RfxMessage> rlt;

    if (errInd == 0 || errInd == 2) {
        rlt = RfxMessage::obtainResponse(RIL_E_SUCCESS, responseMd1);
    } else if (errInd == 1) {
        rlt = RfxMessage::obtainResponse(RIL_E_SUCCESS, responseMd3);
    } else {
        rlt = responseMd1;
    }

    return rlt;
}

void RpNwStateController::onResponseTimeOut(const sp<RfxMessage>& response) {
    int reqId = response->getId();
    int slotId = response->getSlotId();
    logD(RP_NW_STATE_TAG, " onResponseTimeOut() SIM%d REQ=%s src=%s token=%d",
            slotId, requestToString(reqId), sourceToString(response->getSource()),
            response->getPToken());
    responseToRilj(response);
}

int RpNwStateController::getDeviceMode() {
    int mode = getStatusManager()->getIntValue(RFX_STATUS_KEY_NWS_MODE, NWS_MODE_CSFB);
    logD(RP_NW_STATE_TAG, " [getDeviceMode] mode=%d", mode);
    return mode;
}

int RpNwStateController::getChipTestMode() {
    int mode = 0;
    char chipsetMode[PROPERTY_VALUE_MAX] = { 0 };
    property_get("persist.chiptest.enable", chipsetMode, "0");
    mode = atoi(chipsetMode);
    logD(LOG_TAG,"getChipTestMode():%d", mode);
    return mode;
}

int RpNwStateController::convertOtaProvisionStatus(int rawState){
    int state;
    switch(rawState) {
        case 2: {  // service programming lock unlocked
            state = CDMA_OTA_PROVISION_STATUS_SPL_UNLOCKED;
            break;
        }
        case 3: {  // NAM parameters downloaded successfully
            state = CDMA_OTA_PROVISION_STATUS_NAM_DOWNLOADED;
            break;
        }
        case 4: {  // MDN downloaded successfully
            state = CDMA_OTA_PROVISION_STATUS_MDN_DOWNLOADED;
            break;
        }
        case 5: {  // IMSI downloaded successfully
            state = CDMA_OTA_PROVISION_STATUS_IMSI_DOWNLOADED;
            break;
        }
        case 6: {  // PRL downloaded successfully
            state = CDMA_OTA_PROVISION_STATUS_PRL_DOWNLOADED;
            break;
        }
        case 7: {  // commit successfully
            state = CDMA_OTA_PROVISION_STATUS_COMMITTED;
            break;
        }
        case 10: {  // verify SPC failed
            state = CDMA_OTA_PROVISION_STATUS_SPC_RETRIES_EXCEEDED;
            break;
        }
        case 11: {  // A key Exchanged
            state = CDMA_OTA_PROVISION_STATUS_A_KEY_EXCHANGED;
            break;
        }
        case 12: {  // SSD updated
            state = CDMA_OTA_PROVISION_STATUS_SSD_UPDATED;
            break;
        }
        case 13: {  // OTAPA strated
            state = CDMA_OTA_PROVISION_STATUS_OTAPA_STARTED;
            break;
        }
        case 14: {  // OTAPA stopped
            state = CDMA_OTA_PROVISION_STATUS_OTAPA_STOPPED;
            break;
        }
        default:
            state = -1;
    }

    return state;
}


char *RpNwStateController::strdupReadString(Parcel *p) {
    size_t stringlen;
    const char16_t *s16;

    s16 = p->readString16Inplace(&stringlen);

    return strndup16to8(s16, stringlen);
}

void RpNwStateController::writeStringToParcel(Parcel *p, const char *s) {
    char16_t *s16;
    size_t s16_len;
    s16 = strdup8to16(s, &s16_len);
    p->writeString16(s16, s16_len);
    free(s16);
}

void RpNwStateController::resetVoiceRegStateCache(RIL_VOICE_REG_STATE_CACHE *voiceCache) {
    (*voiceCache).register_state = 0;
    (*voiceCache).lac = 0xffffffff;
    (*voiceCache).cid = 0x0fffffff;
    (*voiceCache).radio_technology = 0;
    (*voiceCache).base_station_id = 0;
    (*voiceCache).base_station_latitude = 0;
    (*voiceCache).base_station_longitude = 0;
    (*voiceCache).css = 0;
    (*voiceCache).system_id = 0;
    (*voiceCache).network_id = 0;
    (*voiceCache).roaming_ind = 1;  // home
    (*voiceCache).prl = 0;
    (*voiceCache).prl_roaming_ind = 0;
    (*voiceCache).deny_reason = 0;
    (*voiceCache).psc = -1;
}

void RpNwStateController::resetDataRegStateCache(RIL_DATA_REG_STATE_CACHE *dataCache) {
    (*dataCache).register_state = 0;
    (*dataCache).lac = 0xffffffff;
    (*dataCache).cid = 0x0fffffff;
    (*dataCache).radio_technology = 0;
    (*dataCache).deny_reason = 0;
    (*dataCache).max_data_call = 1;
    (*dataCache).tac = 0;
    (*dataCache).physical_cid = 0;
    (*dataCache).eci = 0;
    (*dataCache).csgid = 0;
    (*dataCache).tadv = 0;
}

void RpNwStateController::resetSignalStrengthCache(RIL_SIGNAL_STRENGTH_CACHE *sigCache) {
    (*sigCache).gsm_sig1 = 99;
    (*sigCache).gsm_sig2 = -1;
    (*sigCache).cdma_dbm = -1;
    (*sigCache).cdma_ecio = -1;
    (*sigCache).ecdo_dbm = -1;
    (*sigCache).evdo_ecio = -1;
    (*sigCache).evdo_snr = -1;
    (*sigCache).lte_sig = -99;
    (*sigCache).lte_rsrp = 0x7FFFFFFF;
    (*sigCache).lte_rsrq = 0x7FFFFFFF;
    (*sigCache).lte_rssnr = 0x7FFFFFFF;
    (*sigCache).lte_cqi = 0x7FFFFFFF;
    (*sigCache).rssi_qdbm = 0;
    (*sigCache).rscp_qdbm = 0;
    (*sigCache).ecn0_qdbm = 0;
}

void RpNwStateController::resetOperatorCache(RIL_OPERATOR_CACHE *optrCache) {
    (*optrCache).count = 0;
    memset((*optrCache).optrAlphaLong, '\0', MAX_OPER_NAME_LENGTH * sizeof(char));
    memset((*optrCache).optrAlphaShort, '\0', MAX_OPER_NAME_LENGTH * sizeof(char));
    memset((*optrCache).optrNumeric, '\0', MAX_OPER_NUM_LENGTH * sizeof(char));
}

char *RpNwStateController::requestToString(int reqId) {
    switch (reqId) {
        case RIL_REQUEST_VOICE_REGISTRATION_STATE:
            return "REQ_VOICE_REG_STATE";
        case RIL_REQUEST_DATA_REGISTRATION_STATE:
            return "REQ_DATA_REG_STATE";
        case RIL_REQUEST_SIGNAL_STRENGTH:
            return "REQ_SIGNAL_STRENGTH";
        case RIL_REQUEST_OPERATOR:
            return "REQ_OPERATOR";
        case RIL_REQUEST_GET_CELL_INFO_LIST:
            return "REQ_GET_CELL_INFO_LIST";
        case RIL_REQUEST_GET_RADIO_CAPABILITY:
            return "REQUEST_GET_RADIO_CAPABILITY";
        case RIL_REQUEST_SET_RADIO_CAPABILITY:
            return "REQUEST_SET_RADIO_CAPABILITY";
        default:
            return "INVALID REQUEST";
    }
}

char *RpNwStateController::urcToString(int urcId) {
    switch (urcId) {
        case RIL_UNSOL_SIGNAL_STRENGTH:
            return "UNSOL_SIGNAL_STRENGTH";
        case RIL_UNSOL_RESPONSE_PS_NETWORK_STATE_CHANGED:
            return "UNSOL_PS_NW_STATE_CHANGED";
        case RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED:
            return "UNSOL_CS_NW_STATE_CHANGED";
        case RIL_UNSOL_CDMA_OTA_PROVISION_STATUS:
            return "RIL_UNSOL_CDMA_OTA_PROVISION_STATUS";
        case RIL_UNSOL_RIL_CONNECTED:
            return "RIL_UNSOL_RIL_CONNECTED";
        default:
            return "INVALID URC";
    }
}

char *RpNwStateController::sourceToString(int srcId) {
    switch (srcId) {
        case RADIO_TECH_GROUP_GSM:
            return "GSM";
        case RADIO_TECH_GROUP_C2K:
            return "C2K";
        default:
            return "INVALID SRC";
    }
}

void RpNwStateController::printVoiceCache(RIL_VOICE_REG_STATE_CACHE cache) {
    if (cache.cacheType == RADIO_TECH_GROUP_GSM) {
        logD(RP_NW_STATE_TAG, " VoiceCache[GSM]: reg=%d lac=%x cid=%x rat=%d css=%d \
sid=%d nid=%d roam=%d css=%d",
                cache.register_state, cache.lac, cache.cid, cache.radio_technology,
                cache.css, cache.system_id, cache.network_id, cache.roaming_ind, cache.css);
    } else if (cache.cacheType == RADIO_TECH_GROUP_C2K) {
        logD(RP_NW_STATE_TAG, " VoiceCache[C2K]: reg=%d lac=%x cid=%x rat=%d css=%d \
sid = %d nid = %d roam = %d css = %d exsit = %d",
                cache.register_state, cache.lac, cache.cid, cache.radio_technology,
                cache.css, cache.system_id, cache.network_id, cache.roaming_ind, cache.css,
                cache.network_exsit);
    }
}

void RpNwStateController::printDataCache(RIL_DATA_REG_STATE_CACHE cache) {
    if (cache.cacheType == RADIO_TECH_GROUP_GSM) {
        logD(RP_NW_STATE_TAG, " DataCache[GSM]: reg=%d lac=%x cid=%x rat=%d den=%d mdc=%d",
                cache.register_state, cache.lac, cache.cid, cache.radio_technology,
                cache.deny_reason, cache.max_data_call);
    } else if (cache.cacheType == RADIO_TECH_GROUP_C2K) {
        logD(RP_NW_STATE_TAG, " DataCache[C2K]: reg=%d lac=%x cid=%x rat=%d den=%d mdc=%d",
                cache.register_state, cache.lac, cache.cid, cache.radio_technology,
                cache.deny_reason, cache.max_data_call);
    }
}

void RpNwStateController::printSignalStrengthCache(RIL_SIGNAL_STRENGTH_CACHE cache) {
    logD(RP_NW_STATE_TAG,
            " Sig: gsm[%d %d] c2k[%d %d %d %d %d] lte[%d %d %d %d %d] umts[%d %d %d]",
            cache.gsm_sig1, cache.gsm_sig2,
            cache.cdma_dbm, cache.cdma_ecio, cache.ecdo_dbm, cache.evdo_ecio, cache.evdo_snr,
            cache.lte_sig, cache.lte_rsrp, cache.lte_rsrq, cache.lte_rssnr, cache.lte_cqi,
            cache.rssi_qdbm, cache.rscp_qdbm, cache.ecn0_qdbm);
}

void RpNwStateController::printOperatorCache(RIL_OPERATOR_CACHE cache) {
    logD(RP_NW_STATE_TAG, " OptrCache: %s,%s,%s",
            cache.optrAlphaLong, cache.optrAlphaShort, cache.optrNumeric);
}
