/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#include "Wrapper.h"
#include "../client/RpRilClientController.h"
#include "client/RilClient.h"
#include "RilSdkClient.h"
#include "ril.h"
#include "Parcel.h"
#include "data/RpDataUtils.h"

#define LOG_TAG "Wrapper.h"

void sendRequestString(int request, int slotId, int token, const char* data)
{
    RilClient* client = RpRilClientController::findClientWithId(CLIENT_ID_SDK);
    Parcel p;
    p.writeInt32(request);
    p.writeInt32(token);
    RpDataUtils::writeStringToParcel(&p, data);
    client->sendRequest(p, slotId);
}

void parseDataCallResponse(MTK_Data_Call_Response_v1 *dataCallResponse, void *parcelData,
        size_t datalen) {
    Parcel p;
    p.write(parcelData, datalen);
    p.setDataPosition(0);
    RpDataUtils::parseDataCallResponse(dataCallResponse, &p);
}
void parseApnResponse(char **reason, void *parcelData, size_t datalen) {
    Parcel p;
    p.write(parcelData, datalen);
    p.setDataPosition(0);
    *reason = RpDataUtils::strdupReadString(&p);
}

void sendModifyApnRequest(int token, const int cmd, const char *record) {
    Parcel p;
    RilClient* client = RpRilClientController::findClientWithId(CLIENT_ID_SDK);
    p.writeInt32(RIL_REQUEST_MODIFY_APN);
    p.writeInt32(token);
    p.writeInt32(cmd);
    RpDataUtils::writeStringToParcel(&p, record);
    client->sendRequest(p, 0);
}

void sendResetApnRequest(int token) {
    Parcel p;
    RilClient* client = RpRilClientController::findClientWithId(CLIENT_ID_SDK);
    p.writeInt32(RIL_REQUEST_RESET_APN);
    p.writeInt32(token);
    client->sendRequest(p, 0);
}
