/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2016. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef __SMS_MESSAGE_H__
#define __SMS_MESSAGE_H__

/*****************************************************************************
 * Include
 *****************************************************************************/
//#include "RfxObject.h"
//#include "RfxMessage.h"
//#include "Parcel.h"
//#include "utils/String8.h"
#include "SmsParserUtils.h"

class PduParser;
class SmsHeader;
class SmsAddress;
class GsmSmsAddress;
/*****************************************************************************
 * Class SmsMessage
 *****************************************************************************/
class SmsMessage /*: public RfxObject*/ {
    // Required: declare this class
    //RFX_DECLARE_CLASS(SmsMessage);

public:
    SmsMessage();
    virtual ~SmsMessage();
    static SmsMessage* createFromPdu(BYTE *pdu, int length);
    bool isReplace();
    bool isWapush();
    bool isSmsForSUPL();
    bool isConcentratedSms();
    BYTE* getUserData();
    int getUserDataLength();
    int getRefNumber();
    int getSeqNumber();
    int getTotalSegnumber();

// Override
protected:
    //virtual void onInit();
    //virtual void onDeinit();

private:
    void parsePdu(BYTE *pdu, int length);
    void parseSmsDeliver(PduParser *parser, int firstByte);
    void parseUserData(PduParser *parser, bool hasUserDataHeader);
    void parseWappushUserData();
    void parseMessageBody();
    void extractEmailAddressFromMessageBody();

private:
    BYTE *mPdu;
    string mScAddress;
    int mMti;
    bool mReplyPathPresent;
    int mProtocolIdentifier;
    GsmSmsAddress* mOriginatingAddress;
    long mScTimeMillis;
    int mDataCodingScheme;
    bool mIsMwi;
    bool mMwiSense;
    bool mMwiDontStore;
    int mVoiceMailCount;
    BYTE *mUserData;
    int mUserDataLength;
    SmsHeader *mUserDataHeader;
    MessageClass mMessageClass;
    string mEmailFrom;
    string mEmailBody;
    string mMessageBody;
    bool mIsEmail;
    int mCur;
    int mEncodingType;
};

class WappushMessage /*: public RfxObject*/ {
    // Required: declare this class
    //RFX_DECLARE_CLASS(SmsMessage);
public:
    WappushMessage(BYTE *pdu, int length);
    virtual ~WappushMessage();
    void parsePdu();
    bool isWapushForSUPL();
    BYTE* getUserData();
    int getUserDataLength();

// Override
protected:
    //virtual void onInit();

private:
    BYTE *mPdu;
    int mTransactionId;
    int mPduType;
    int mPduLength;
    string mWapAppId;
    string mContentType;
    BYTE *mUserData;
    int mUserDataLength;
    static const string MIME_TYPE_SUPL;
    static const string XWAP_APP_ID_SUPL;
    static const string MIME_TYPE_SUPL_HEX;
    static const string XWAP_APP_ID_SUPL_HEX;
};
#endif /* __SMS_MESSAGE_H__ */
