/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein is
 * confidential and proprietary to MediaTek Inc. and/or its licensors. Without
 * the prior written permission of MediaTek inc. and/or its licensors, any
 * reproduction, modification, use or disclosure of MediaTek Software, and
 * information contained herein, in whole or in part, shall be strictly
 * prohibited.
 *
 * MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER
 * ON AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL
 * WARRANTIES, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR
 * NONINFRINGEMENT. NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH
 * RESPECT TO THE SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY,
 * INCORPORATED IN, OR SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES
 * TO LOOK ONLY TO SUCH THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO.
 * RECEIVER EXPRESSLY ACKNOWLEDGES THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO
 * OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES CONTAINED IN MEDIATEK
 * SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE
 * RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S
 * ENTIRE AND CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE
 * RELEASED HEREUNDER WILL BE, AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE
 * MEDIATEK SOFTWARE AT ISSUE, OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE
 * CHARGE PAID BY RECEIVER TO MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek
 * Software") have been modified by MediaTek Inc. All revisions are subject to
 * any receiver's applicable license agreements with MediaTek Inc.
 */

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include <stdlib.h>
#include <fcntl.h>
#include <errno.h>
#include <unistd.h>
#include <string.h>
#include <pthread.h>
#include <time.h>
#include "libnvram.h"
#include "libnvram_log.h"
extern int iFilePRODUCT_INFOLID;


/* Just tell NVRAM to create Product info default record */
void* NVRAM_PRODUCTINFO(void* arg) {
	F_ID pin_fid = {0};
	int rec_size = 0;
	int rec_num = 0;
	unsigned char proinfo_buf[1024];
	unsigned char proinfo_wir[1024] = {0x01, 0x02, 0x03, 0x04, 0x05};

	NVRAM_LOG("[NVRAM Daemon]product info lid %d ++\n", iFilePRODUCT_INFOLID);
	pin_fid = NVM_GetFileDesc(iFilePRODUCT_INFOLID, &rec_size, &rec_num, ISWRITE);
	NVRAM_LOG("[NVRAM Daemon] product info FID %d rec_size %d rec_num %d\n",
	          pin_fid.iFileDesc, rec_size, rec_num);

	if (read(pin_fid.iFileDesc, &proinfo_buf, rec_num * rec_size) < 0) {
		NVRAM_LOG("Read NVRAM fails %d\n", errno);
		NVM_CloseFileDesc(pin_fid);
		return NULL;
	}

	lseek(pin_fid.iFileDesc, 0, 0);

	if (write(pin_fid.iFileDesc, &proinfo_wir, rec_num * rec_size) < 0) {
		NVRAM_LOG("Initialize NVRAM fails %d\n", errno);
	}

	if (!NVM_CloseFileDesc(pin_fid))
		NVRAM_LOG("[NVRAM Daemon] close product info error");

	pthread_exit(NULL);
	return NULL;
}
