#ifndef _NETCTRL_LOG_H

#define _NETCTRL_LOG_H

#include <stdio.h>
#include <stdlib.h>

#ifdef __ANDROID__
#include <log/mtk_log.h>
#else
#include <syslog.h>
#endif

enum {
    LOG_LEVEL_DEBUG,
    LOG_LEVEL_INFO,
    LOG_LEVEL_WARN,
    LOG_LEVEL_ERROR
};

#define DEBUGLEVEL LOG_LEVEL_ERROR
#define DEBUG 1

#ifdef DEBUG

//#define PRINTF(format, ...) fprintf(stdout, "NetCtrl %s(%d): " format, __func__, __LINE__, ## __VA_ARGS__)
#define PRINTF(fmt, ...) syslog(LOG_DEBUG, "%s:" fmt, __func__, ## __VA_ARGS__)

#define LOGD(fmt, ...) \
do { \
    if (LOG_LEVEL_DEBUG <= DEBUGLEVEL) \
        PRINTF(fmt, ##__VA_ARGS__); \
} while(0)

#define LOGI(fmt, ...) \
do { \
    if (LOG_LEVEL_INFO <= DEBUGLEVEL) \
        PRINTF(fmt, ##__VA_ARGS__); \
} while(0)

#define LOGW(fmt, ...) \
do { \
    if (LOG_LEVEL_WARN <= DEBUGLEVEL) \
        PRINTF(fmt, ##__VA_ARGS__); \
} while(0)

#define LOGE(fmt, ...) \
do { \
    if (LOG_LEVEL_ERROR <= DEBUGLEVEL) \
        PRINTF(fmt, ##__VA_ARGS__); \
} while(0)

#else

#define PRINTF(format, ...) no_debug(0, format, ## __VA_ARGS__)
#define LOGD(format, ...) no_debug(LOG_DEBUG, format, ## __VA_ARGS__)
#define LOGI(format, ...) no_debug(LOG_INFO, format, ## __VA_ARGS__)
#define LOGW(format, ...) no_debug(LOG_WARN, format, ## __VA_ARGS__)
#define LOGE(format, ...) no_debug(LOG_ERROR, format, ## __VA_ARGS__)

#endif

static inline void no_debug(int level, const char *fmt, ...)
{
}

#endif

