#ifndef __MD_EVENT_HANDLER_H__
#define __MD_EVENT_HANDLER_H__

/*****************************************************************************
 * Include
 *****************************************************************************/
#include "ioutils/netagent_io.h"

//#include "platform.h"
#include "mipc_msg_host.h"
#include "mipc_msg.h"
#include "mipc_msg_tlv_const.h"
#include "mipc_internal.h"

#ifdef __ANDROID__
#include <log/mtk_log.h>
#else
#include <syslog.h>
#endif

#include <uci.h>

#ifdef __ANDROID__
    #ifndef MEH_LOG_V
    #define MEH_LOG_V(...) \
        ((void)mtkLogV(MEH_LOG_TAG, __VA_ARGS__))
    #endif

    #ifndef MEH_LOG_D
    #define MEH_LOG_D(...) \
        ((void)mtkLogD(MEH_LOG_TAG, __VA_ARGS__))
    #endif

    #ifndef MEH_LOG_I
    #define MEH_LOG_I(...) \
        ((void)mtkLogI(MEH_LOG_TAG, __VA_ARGS__))
    #endif

    #ifndef MEH_LOG_W
    #define MEH_LOG_W(...) \
        ((void)mtkLogW(MEH_LOG_TAG, __VA_ARGS__))
    #endif

    #ifndef MEH_LOG_E
    #define MEH_LOG_E(...) \
        ((void)mtkLogE(MEH_LOG_TAG, __VA_ARGS__))
    #endif
#else
    #define MEH_LOG_V(fmt, ...) syslog(LOG_DEBUG, fmt, ##__VA_ARGS__)
    #define MEH_LOG_D(fmt, ...) syslog(LOG_DEBUG, fmt, ##__VA_ARGS__)
    #define MEH_LOG_I(fmt, ...) syslog(LOG_INFO, fmt, ##__VA_ARGS__)
    #define MEH_LOG_W(fmt, ...) syslog(LOG_WARNING, fmt, ##__VA_ARGS__)
    #define MEH_LOG_E(fmt, ...) syslog(LOG_ERR, fmt, ##__VA_ARGS__)
#endif

#define MAX_IPV4_ADDR_LENGTH 17
//xxx.xxx.xxx.xxx
#define MAX_IPV6_ADDR_LENGTH 65
//xxxx:xxxx:xxxx:xxxx:xxxx:xxxx:xxxx:xxxx
//xxx.xxx.xxx.xxx.xxx.xxx.xxx.xxx.xxx.xxx.xxx.xxx.xxx.xxx.xxx.xxx

#define INVALID_TRANS_ID -1
#define UCI_CONFIG_FILE "/etc/config/radio_property"

void onEifIndCallback(mipc_msg_t *msg_ptr, void *priv_ptr);
void onEIpPortCallback(mipc_msg_t *msg_ptr, void *priv_ptr);
void onEIpSpiCallback(mipc_msg_t *msg_ptr, void *priv_ptr);

void registerMdEvent();

unsigned int getIpAddrTypeFromMdMsg(uint8_t v4FullAddrCount, uint8_t v6FullAddrCount);
int copyIpAddressToReqInfo(netagent_io_cmd_obj_t *cmd_obj, mipc_v4_full_addr_struct4 *ipV4list, mipc_v6_full_addr_struct4 *ipV6list);


int confirmInterfaceUpToMd(unsigned int transId, int sim_ps_id);
int confirmInterfaceDownToMd(unsigned int transId, int sim_ps_id);
int confirmIpUpdateToMd(unsigned int transId, netagent_io_addr_type_e addrType, unsigned int* addr, int ipv6PrefixLength, int sim_ps_id);
int confirmNoRaToMd(unsigned int transId, netagent_io_ra_e flag, int sim_ps_id);
int confirmIpAddOrDelToMd(unsigned int transId, netagent_io_cmd_e cmd, int result, netagent_io_addr_type_e addrType, unsigned int* addr, int ipv6PrefixLength, int sim_ps_id);
int confirmTcpUdpRsvnToMd(unsigned int transId, netagent_io_cmd_e cmd, uint8_t rsvnAction, unsigned int response);
// Sensitive log control
int getCfgValue(char *name);

// link list utility for EIPPORT/ESPI
//REQ_HDR_NODE *createReqHdrNode(void);
//void freeReqHdrNode(REQ_HDR_NODE* ptr);
//void printReqHdrNodeList(REQ_HDR_NODE* pHead);
//unsigned int getCountReqHdrNodeList(REQ_HDR_NODE* ptr);
//REQ_HDR_NODE* findReqHdrNode(REQ_HDR_NODE* ptr, unsigned int key);
//REQ_HDR_NODE* pushReqHdrNodeToList(REQ_HDR_NODE* pHead, unsigned int key, mipc_msg_hdr_t *data);
//REQ_HDR_NODE* deleteReqHdrNode(REQ_HDR_NODE* pHead, REQ_HDR_NODE* ptr);

#endif /* end of __MD_EVENT_HANDLER_H__ */
