#ifndef _CCCILIB_H_
#define _CCCILIB_H_

#include <stdio.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/time.h>
#include <fcntl.h>
#include <unistd.h>
#include <time.h>
#include <errno.h>
#include <syslog.h>

#define CCCI_IOC_MAGIC 'C'
#define CCCI_IOC_MD_RESET _IO(CCCI_IOC_MAGIC, 0)

enum md_bc_event {
    MD_STA_EV_INVALID = 0,
    MD_STA_EV_RESET_REQUEST,
    MD_STA_EV_F_ASSERT_REQUEST,
    MD_STA_EV_STOP_REQUEST,
    MD_STA_EV_START_REQUEST,
    MD_STA_EV_ENTER_FLIGHT_REQUEST,
    MD_STA_EV_LEAVE_FLIGHT_REQUEST,
    MD_STA_EV_ENTER_FLIGHT_E_REQUEST,
    MD_STA_EV_LEAVE_FLIGHT_E_REQUEST,
    MD_STA_EV_HS1,
    MD_STA_EV_READY,
    MD_STA_EV_EXCEPTION,
    MD_STA_EV_STOP,
};
  
struct md_status_event {
    struct timeval time_stamp;
    int md_id;
    int event_type;
    char reason[32];
};

typedef void (*CCCILIB_EXCEPTION_CB)(void *priv_ptr);

#define CCCI_LOG_V(fmt, ...) syslog(LOG_DEBUG, fmt, ##__VA_ARGS__)
#define CCCI_LOG_D(fmt, ...) syslog(LOG_DEBUG, fmt, ##__VA_ARGS__)
#define CCCI_LOG_I(fmt, ...) syslog(LOG_INFO, fmt, ##__VA_ARGS__)
#define CCCI_LOG_W(fmt, ...) syslog(LOG_WARNING, fmt, ##__VA_ARGS__)
#define CCCI_LOG_E(fmt, ...) syslog(LOG_ERR, fmt, ##__VA_ARGS__)

int cccilib_reset(int ccci_fd);
void cccilib_exception_register(CCCILIB_EXCEPTION_CB cb, void *cb_priv_ptr);

#endif
