/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  Copyright (c) [2020], MediaTek Inc. All rights reserved.
*  This software/firmware and related documentation ("MediaTek Software") are
*  protected under relevant copyright laws.
*
*  The information contained herein is confidential and proprietary to
*  MediaTek Inc. and/or its licensors. Except as otherwise provided in the
*  applicable licensing terms with MediaTek Inc. and/or its licensors, any
*  reproduction, modification, use or disclosure of MediaTek Software, and
*  information contained herein, in whole or in part, shall be strictly
*  prohibited.
*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "mipc_msg_tlv_api.h"
#include "mipc_msg_host.h"
#include "mipc_msg_tlv_api.h"

#include <libubox/blobmsg_json.h>
#include <libubus.h>

static struct blob_buf b;

static void receive_call_result_data(struct ubus_request *req, int type, struct blob_attr *msg)
{
    char *str;

    if (!msg)
        return;
}

void run_at_cmd(char* cmd)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_SYS_AT_REQ, MIPC_PS0);
    mipc_msg_t *msg_cnf_ptr;
    mipc_result_enum result;
    char *atcmd_res_ptr;
    uint16_t atcmd_res_len;

    printf("AT command execution:%s\n", cmd);

    mipc_msg_add_tlv(msg_req_ptr, MIPC_SYS_AT_REQ_T_ATCMD, strlen(cmd), cmd);
    msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    mipc_msg_deinit(msg_req_ptr);

    result = mipc_get_result(msg_cnf_ptr);
    if (result == MIPC_RESULT_SUCCESS)
    {
        atcmd_res_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_SYS_AT_CNF_T_ATCMD, &atcmd_res_len);
        printf("AT response:%s\n", atcmd_res_ptr);
    }
    else
        printf("Failed to execute:%d\n", result);

    mipc_msg_deinit(msg_cnf_ptr);
}

void add_non_default_route(struct ubus_context *ctx, mipc_data_v4_addr_struct4* v4, uint32_t interface_id, mipc_apn_pdp_type_const_enum pdp_type)
{
    char v4_addr[32];
    uint32_t id, ret;

    sprintf(v4_addr, "%d.%d.%d.%d", v4->addr[0], v4->addr[1], v4->addr[2], v4->addr[3]);
    printf("ubus call modem_pdn add_route '{\"ifid\":\"%d\":,\"ip_type\":\"%d\",\"v4_addr\":\"%s\"}'\n",
           interface_id, pdp_type, v4_addr);

    blob_buf_init(&b, 0);
    blobmsg_add_u32(&b, "ifid", interface_id);
    blobmsg_add_u32(&b, "ip_type", pdp_type);
    blobmsg_add_string(&b, "v4_addr", v4_addr);

    ret = ubus_lookup_id(ctx, "modem_pdn", &id);
    if (!ret)
        ubus_invoke(ctx, id, "add_route", b.head, receive_call_result_data, NULL, 3000);
}

int main(int argc, char *argv[])
{
    char apn[64] = "internet";
    int apn_type = MIPC_APN_TYPE_DEFAULT;
    int pdp_type = MIPC_APN_PDP_TYPE_IPV4V6;
    int roam_pdp_type = MIPC_APN_PDP_TYPE_IPV4V6;
    struct ubus_context *ctx;

    ctx = ubus_connect(NULL);
    if (!ctx)
    {
        printf("Failed to connect to ubus\n");
    }

    printf("argc:%d\n", argc);

    if (argc >= 2)
        snprintf(apn, sizeof(apn), "%s", argv[1]);
    if (argc >= 3)
        apn_type = atoi(argv[2]);
    if (argc >= 4)
        pdp_type = atoi(argv[3]);
    if (argc >= 5)
        roam_pdp_type = atoi(argv[4]);
    else
        roam_pdp_type = pdp_type;

    printf("APN:%s apn_type:%d pdp_type:%d roam_pdp_type:%d\n",
            apn, apn_type, pdp_type, roam_pdp_type);

    mipc_init("wwan");
    do
    {
        mipc_msg_t *msg_req_ptr;
        mipc_msg_t *msg_cnf_ptr;
        mipc_result_enum result = MIPC_RESULT_FAILURE;

        msg_req_ptr = mipc_msg_init(MIPC_DATA_ACT_CALL_REQ, MIPC_PS0);
        mipc_data_act_call_req_add_apn(msg_req_ptr, MIPC_MAX_APN_LEN, apn);
        mipc_data_act_call_req_add_apn_type(msg_req_ptr, apn_type);
        mipc_data_act_call_req_add_pdp_type(msg_req_ptr, pdp_type);
        mipc_data_act_call_req_add_roaming_type(msg_req_ptr, roam_pdp_type);

        mipc_data_act_call_req_add_auth_type(msg_req_ptr, MIPC_APN_AUTH_TYPE_NONE);
        mipc_data_act_call_req_add_userid(msg_req_ptr, MIPC_MAX_USERID_LEN, "");
        mipc_data_act_call_req_add_password(msg_req_ptr, MIPC_MAX_PASSWORD_LEN, "");

        mipc_data_act_call_req_add_ipv4v6_fallback(msg_req_ptr, MIPC_DATA_FALLBACK_TYPE_IPV4_FIRST);
        mipc_data_act_call_req_add_bearer_bitmask(msg_req_ptr, 0xffffffff);

        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        result = mipc_get_result(msg_cnf_ptr);
        if (result == MIPC_RESULT_SUCCESS)
        {
            char* apn = mipc_data_act_call_cnf_get_apn(msg_cnf_ptr, NULL);
            uint8_t tid = mipc_data_act_call_cnf_get_id(msg_cnf_ptr, 0);
            mipc_apn_pdp_type_const_enum pdp_type = mipc_data_act_call_cnf_get_pdp_type(msg_cnf_ptr, MIPC_APN_PDP_TYPE_DEFAULT);
            uint32_t v4_mtu = mipc_data_act_call_cnf_get_mtu_v4(msg_cnf_ptr, 0);
            uint32_t v6_mtu = mipc_data_act_call_cnf_get_mtu_v6(msg_cnf_ptr, 0);
            uint8_t v4_addr_count = mipc_data_act_call_cnf_get_v4_count(msg_cnf_ptr, 0);
            uint8_t v6_addr_count = mipc_data_act_call_cnf_get_v6_count(msg_cnf_ptr, 0);
            uint8_t v4_dns_count = mipc_data_act_call_cnf_get_dns_v4_count(msg_cnf_ptr, 0);
            uint8_t v6_dns_count = mipc_data_act_call_cnf_get_dns_v6_count(msg_cnf_ptr, 0);
            uint32_t interface_id = mipc_data_act_call_cnf_get_interface_id(msg_cnf_ptr, 0xff);

            printf("---------[get data call sync] apn: %s\n", apn);
            printf("---------[get data call sync] interface_id: %d\n", interface_id);
            printf("---------[get data call sync] apn_type: %d pdp_type:%d \n", apn_type, pdp_type);
            printf("---------[get data call sync] v4 mtu: %d v6 mtu: %d\n", v4_mtu, v6_mtu);
            printf("---------[get data call sync] v4/v6 addr count: %d:%d\n", v4_addr_count, v6_addr_count);
            if (v4_addr_count > 0)
            {
                mipc_data_v4_addr_struct4* v4 = mipc_data_act_call_cnf_get_v4_0(msg_cnf_ptr, NULL);
                printf("---------[get data call sync] v4 addr:%u.%u.%u.%u\n", v4->addr[0], v4->addr[1], v4->addr[2], v4->addr[3]);
                if (apn_type != MIPC_APN_TYPE_DEFAULT)
                    add_non_default_route(ctx, v4, interface_id, pdp_type);
            }
            if (v6_addr_count > 0 )
            {
                mipc_data_v6_addr_struct4* v6 = mipc_data_act_call_cnf_get_v6_0(msg_cnf_ptr, NULL);
                printf("---------[get data call sync] v6 addr:%2x%2x:%2x%2x:%2x%2x:%2x%2x:%2x%2x:%2x%2x:%2x%2x:%2x%2x\n",
                       v6->addr[0], v6->addr[1], v6->addr[2], v6->addr[3],
                       v6->addr[4], v6->addr[5], v6->addr[6], v6->addr[7],
                       v6->addr[8], v6->addr[9], v6->addr[10], v6->addr[11],
                       v6->addr[12], v6->addr[13], v6->addr[14], v6->addr[15]);
            }
            printf("---------[get data call sync] pdp_type:%d\n", pdp_type);
            printf("---------[get data call sync] dns v4/v6 num :%d:%d\n", v4_dns_count, v6_dns_count);

            if (v4_dns_count > 0 )
            {
                mipc_data_v4_addr_struct4* dns = mipc_data_act_call_cnf_get_dns_v4_0(msg_cnf_ptr, NULL);
                printf("---------[get data call sync] dns v4 addr:%u.%u.%u.%u\n", dns->addr[0], dns->addr[1], dns->addr[2], dns->addr[3]);
            }
            if (v6_dns_count > 0 )
            {
                mipc_data_v6_addr_struct4* dns = mipc_data_act_call_cnf_get_dns_v6_0(msg_cnf_ptr, NULL);
                printf("---------[get data call sync] dns v6 addr:%2x%2x:%2x%2x:%2x%2x:%2x%2x:%2x%2x:%2x%2x:%2x%2x:%2x%2x\n",
                       dns->addr[0], dns->addr[1], dns->addr[2], dns->addr[3],
                       dns->addr[4], dns->addr[5], dns->addr[6], dns->addr[7],
                       dns->addr[8], dns->addr[9], dns->addr[10], dns->addr[11],
                       dns->addr[12], dns->addr[13], dns->addr[14], dns->addr[15]);
            }
            printf("data call activation successfully, please try to ping 8.8.8.8\n");
        }
        else
        {
            printf("[FINAL] FAIL:%d\n", result);
        }
        mipc_msg_deinit(msg_cnf_ptr);
    }
    while (0);

    ubus_free(ctx);
    mipc_deinit();

    exit(0);
}
