/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  Copyright (c) [2020], MediaTek Inc. All rights reserved.
*  This software/firmware and related documentation ("MediaTek Software") are
*  protected under relevant copyright laws.
*
*  The information contained herein is confidential and proprietary to
*  MediaTek Inc. and/or its licensors. Except as otherwise provided in the
*  applicable licensing terms with MediaTek Inc. and/or its licensors, any
*  reproduction, modification, use or disclosure of MediaTek Software, and
*  information contained herein, in whole or in part, shall be strictly
*  prohibited.
*****************************************************************************/
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "mipc_msg_tlv_api.h"
#include "mipc_msg_host.h"
#include "mipc_msg_tlv_api.h"

#include <libubox/blobmsg_json.h>
#include <libubus.h>

static struct blob_buf b;

static void receive_call_result_data(struct ubus_request *req, int type, struct blob_attr *msg)
{
    char *str;

    if (!msg)
        return;
}

int main(int argc, char *argv[])
{
    struct ubus_context *ctx;
    uint32_t id, ret2;
    uint32_t interface_id = 0xFF;
    int cid = 0;
    int apn_type = 0;
    mipc_apn_pdp_type_const_enum pdp_type = 0;

    ctx = ubus_connect(NULL);
    if (!ctx)
    {
        printf("Failed to connect to ubus\n");
    }

    mipc_init("wwan");

    if (argc == 2)
        cid = atoi(argv[1]);

    do
    {
        mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_DATA_GET_CALL_REQ, MIPC_PS0);
        mipc_msg_t *msg_cnf_ptr;
        mipc_result_enum result = MIPC_RESULT_FAILURE;

        printf("check cid:%d\n", cid);
        mipc_data_get_call_req_add_id(msg_req_ptr, cid);
        msg_cnf_ptr = mipc_msg_sync(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);

        result = mipc_get_result(msg_cnf_ptr);
        if (result == MIPC_RESULT_SUCCESS)
        {
            interface_id = mipc_data_get_call_cnf_get_interface_id(msg_cnf_ptr, 0);
            pdp_type = mipc_data_get_call_cnf_get_pdp_type(msg_cnf_ptr, mipc_apn_pdp_type_const_NONE);
            printf("interface_id:%d apn_type:%d pdp_type:%d\n", interface_id, apn_type, pdp_type);
            mipc_msg_deinit(msg_cnf_ptr);
            continue;
        }
        else
        {
            mipc_msg_deinit(msg_cnf_ptr);
            cid++;
            printf("Check next CID:%d:%d\n", cid, result);
        }
    }
    while (interface_id == 0xFF && cid < 10);

    if (interface_id != 0xFF)
    {
        mipc_msg_t *msg_req_ptr;
        mipc_msg_t *msg_cnf_ptr;
        mipc_result_enum result = MIPC_RESULT_FAILURE;

        msg_req_ptr = mipc_msg_init(MIPC_DATA_DEACT_CALL_REQ, MIPC_PS0);
        mipc_data_deact_call_req_add_id(msg_req_ptr, cid);

        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);

        result = mipc_get_result(msg_cnf_ptr);
        printf("data call deactivation result:%d\n", result);
        if (result == MIPC_RESULT_SUCCESS && apn_type != MIPC_APN_TYPE_DEFAULT)
        {
            printf("ubus call modem_pdn del_route '{\"ifid\":\"%d\":,\"ip_type\":\"%d\"}'\n",
                   interface_id, pdp_type);

            blob_buf_init(&b, 0);
            blobmsg_add_u32(&b, "ifid", interface_id);
            blobmsg_add_u32(&b, "ip_type", pdp_type);

            ret2 = ubus_lookup_id(ctx, "modem_pdn", &id);
            if (!ret2)
                ubus_invoke(ctx, id, "del_route", b.head, receive_call_result_data, NULL, 3000);
        }
    };

    ubus_free(ctx);
    mipc_deinit();

    exit(0);
}
