#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "platform.h"
#include "mipc_msg_host.h"
#include "mipc_msg_tlv_api.h"

void send_atcmd(char *atcmd) {
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;

    printf("Send [%s]\n", atcmd);
    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_AT_REQ, MIPC_MSG_PS0);

    //SETP2: add paramters
    mipc_sys_at_req_add_atcmd(msg_req_ptr, strlen(atcmd) + 1 , atcmd);
    //SETP3: send to MD
    msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    //SETP5: process the cnf msg
    if (msg_cnf_ptr == NULL) {
        printf("TIMEOUT\n");
        return;
    }
    if (mipc_get_result(msg_cnf_ptr) == MIPC_RESULT_SUCCESS) {
        printf("%s", mipc_sys_at_cnf_get_atcmd(msg_cnf_ptr, NULL));
    } else {
        printf("ERROR\n");
    }

    //SETE6: free the cnf msg
    mipc_msg_deinit(msg_cnf_ptr);
}

int main(int argc, char *argv[])
{
    if (argc == 2) {
        printf("SETCOM: %s\n", argv[1]);
        SETCOM(argv[1]);
    } else {
        printf("%s <COM>\n", argv[0]);
        exit(0);
    }

    mipc_init("wwan");

    printf("=======================================================>> act data call\n");
    do {
        mipc_msg_t *msg_req_ptr;
        mipc_msg_t *msg_cnf_ptr;

        //SETP1: build MIPC message
        msg_req_ptr = mipc_msg_init(MIPC_DATA_ACT_CALL_REQ, MIPC_MSG_PS0);
        //SETP2: add paramters
        mipc_data_act_call_req_add_apn(msg_req_ptr, sizeof("apn03.mtk"), "apn03.mtk");
        mipc_data_act_call_req_add_apn_type(msg_req_ptr, MIPC_APN_TYPE_DEFAULT);
        mipc_data_act_call_req_add_pdp_type(msg_req_ptr, MIPC_APN_PDP_TYPE_IPV4V6);
        mipc_data_act_call_req_add_roaming_type(msg_req_ptr, MIPC_APN_PDP_TYPE_IPV4V6);
        mipc_data_act_call_req_add_auth_type(msg_req_ptr, MIPC_APN_AUTH_TYPE_NONE);
        mipc_data_act_call_req_add_userid(msg_req_ptr, sizeof(""), "");
        mipc_data_act_call_req_add_password(msg_req_ptr, sizeof(""), "");
        mipc_data_act_call_req_add_ipv4v6_fallback(msg_req_ptr, MIPC_DATA_FALLBACK_TYPE_DISABLE);
        mipc_data_act_call_req_add_bearer_bitmask(msg_req_ptr, 0xffffffff);
        //SETP3: send to MD
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        //SETE4: free the req msg
        mipc_msg_deinit(msg_req_ptr);

        //SETP5: process the cnf msg
        if (msg_cnf_ptr == NULL) {
            printf("TIMEOUT\n");
            break;
        }
        if (mipc_get_result(msg_cnf_ptr) == MIPC_RESULT_SUCCESS) {
            char cmd[256];
            mipc_data_v4_addr_struct4 *v4_ptr;
            mipc_data_v6_addr_struct4 *v6_ptr;
            printf("cid=%d\n", mipc_data_act_call_cnf_get_id(msg_cnf_ptr, 0xff));
            printf("apn=%s\n", mipc_data_act_call_cnf_get_apn(msg_cnf_ptr, NULL));
            printf("pdp type=%d\n", mipc_data_act_call_cnf_get_pdp_type(msg_cnf_ptr, 0));
            printf("v4 count=%d\n", mipc_data_act_call_cnf_get_v4_count(msg_cnf_ptr, 0));
            printf("v6 count=%d\n", mipc_data_act_call_cnf_get_v6_count(msg_cnf_ptr, 0));
            printf("dns v4 count=%d\n", mipc_data_act_call_cnf_get_dns_v4_count(msg_cnf_ptr, 0));
            printf("dns v6 count=%d\n", mipc_data_act_call_cnf_get_dns_v6_count(msg_cnf_ptr, 0));
            v4_ptr = mipc_data_act_call_cnf_get_v4_0(msg_cnf_ptr, NULL);
            if (v4_ptr) {
                printf("v4 addr[0]=%d.%d.%d.%d\n", v4_ptr->addr[0], v4_ptr->addr[1], v4_ptr->addr[2], v4_ptr->addr[3]);
            }
            v6_ptr = mipc_data_act_call_cnf_get_v6_0(msg_cnf_ptr, NULL);
            if (v6_ptr) {
                printf("v6 addr[0]=%x.%x.%x.%x.%x.%x.%x.%x.%x.%x.%x.%x.%x.%x.%x.%x\n", v6_ptr->addr[0], v6_ptr->addr[1], v6_ptr->addr[2], v6_ptr->addr[3], v6_ptr->addr[4], v6_ptr->addr[5], v6_ptr->addr[6], v6_ptr->addr[7], v6_ptr->addr[8], v6_ptr->addr[9], v6_ptr->addr[10], v6_ptr->addr[11], v6_ptr->addr[12], v6_ptr->addr[13], v6_ptr->addr[14], v6_ptr->addr[15]);
            }
#ifdef _LINUX
            //set interface
            int ifid = mipc_data_act_call_cnf_get_interface_id(msg_cnf_ptr, 0);
            snprintf(cmd, sizeof(cmd), "ifconfig ccmni%d %d.%d.%d.%d", ifid, v4_ptr->addr[0], v4_ptr->addr[1], v4_ptr->addr[2], v4_ptr->addr[3]);

            system(cmd);
            snprintf(cmd, sizeof(cmd), "route add default dev ccmni%d", ifid);
            system(cmd);
#endif
        } else {
            printf("data call act fail\n");
        }

        //SETE6: free the cnf msg
        mipc_msg_deinit(msg_cnf_ptr);
    } while (0);

    mipc_deinit();
}
