#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "platform.h"
#include "mipc_msg_host.h"
#include "mipc_msg_tlv_api.h"

int main(int argc, char *argv[])
{
    if (argc == 2) {
        printf("SETCOM: %s\n", argv[1]);
        SETCOM(argv[1]);
    } else {
        printf("%s <COM>\n", argv[0]);
        exit(0);
    }

    mipc_init("wwan");

    printf("=======================================================>> hw radio off\n");
    do {
        mipc_msg_t *msg_req_ptr;
        mipc_msg_t *msg_cnf_ptr;

        //SETP0: build MIPC message
        msg_req_ptr = mipc_msg_init(MIPC_NW_SET_RADIO_STATE_REQ, MIPC_MSG_PS0);
        //SETP2: add paramters
        mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_NW_SET_RADIO_STATE_REQ_T_HW_STATE, 0);
        //SETP3: send to MD
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        //SETE4: free the req msg
        mipc_msg_deinit(msg_req_ptr);

        //SETP5: process the cnf msg
        if (msg_cnf_ptr == NULL) {
            printf("TIMEOUT\n");
            break;
        }

        do {
            uint32_t *t_result_ptr;
            if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
            if (*t_result_ptr == 0) { // SUCCESS
                uint8_t *t_sw_radio_state_ptr;
                uint8_t *t_hw_radio_state_ptr;
                if ((t_sw_radio_state_ptr = (uint8_t *)mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_NW_SET_RADIO_STATE_CNF_T_SW_STATE, NULL)) == NULL) break;
                if ((t_hw_radio_state_ptr = (uint8_t *)mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_NW_SET_RADIO_STATE_CNF_T_HW_STATE, NULL)) == NULL) break;
                printf("SUCCESS SW_RADIO_STATE=%d HW_RADIO_STATE=%d\n", *t_sw_radio_state_ptr, *t_hw_radio_state_ptr);
                break;
            }

            printf("ERROR\n");
            break;
        } while (0);

        //SETE6: free the cnf msg
        mipc_msg_deinit(msg_cnf_ptr);
    } while (0);

    mipc_deinit();
}
