#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#include "platform.h"
#include "mipc_msg_host.h"
#include "mipc_msg_tlv_api.h"

void send_atcmd(char *atcmd) {
    mipc_msg_t *msg_req_ptr;
    mipc_msg_t *msg_cnf_ptr;

    printf("Send [%s]\n", atcmd);
    //SETP1: build MIPC message
    msg_req_ptr = mipc_msg_init(MIPC_SYS_AT_REQ, MIPC_MSG_PS0);

    //SETP2: add paramters
    mipc_sys_at_req_add_atcmd(msg_req_ptr, strlen(atcmd) + 1 , atcmd);
    //SETP3: send to MD
    msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
    //SETE4: free the req msg
    mipc_msg_deinit(msg_req_ptr);

    //SETP5: process the cnf msg
    if (msg_cnf_ptr == NULL) {
        printf("TIMEOUT\n");
        return;
    }
    if (mipc_get_result(msg_cnf_ptr) == MIPC_RESULT_SUCCESS) {
        printf("%s", mipc_sys_at_cnf_get_atcmd(msg_cnf_ptr, NULL));
    } else {
        printf("ERROR\n");
    }

    //SETE6: free the cnf msg
    mipc_msg_deinit(msg_cnf_ptr);
}

int main(int argc, char *argv[])
{
    if (argc == 2) {
        printf("SETCOM: %s\n", argv[1]);
        SETCOM(argv[1]);
    } else {
        printf("%s <COM>\n", argv[0]);
        exit(0);
    }

    mipc_init("wwan");

    send_atcmd("AT+CFUN=0");
    send_atcmd("AT+EMMCHLCK=0");
    printf("=======================================================>> radio off\n");

    SLEEP(3);

    do {
        mipc_msg_t *msg_req_ptr;
        mipc_msg_t *msg_cnf_ptr;

        //SETP0: build MIPC message
        msg_req_ptr = mipc_msg_init(MIPC_NW_SET_RADIO_STATE_REQ, MIPC_MSG_PS0);
        //SETP2: add paramters
        mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_NW_SET_RADIO_STATE_REQ_T_SW_STATE, 0);
        //SETP3: send to MD
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        //SETE4: free the req msg
        mipc_msg_deinit(msg_req_ptr);

        //SETP5: process the cnf msg
        if (msg_cnf_ptr == NULL) {
            printf("TIMEOUT\n");
            break;
        }

        do {
            uint32_t *t_result_ptr;
            if ((t_result_ptr = (uint32_t *)mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL)) == NULL) break;
            if (*t_result_ptr == 0) { // SUCCESS
                uint8_t *t_sw_radio_state_ptr;
                uint8_t *t_hw_radio_state_ptr;
                if ((t_sw_radio_state_ptr = (uint8_t *)mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_NW_SET_RADIO_STATE_CNF_T_SW_STATE, NULL)) == NULL) break;
                if ((t_hw_radio_state_ptr = (uint8_t *)mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_NW_SET_RADIO_STATE_CNF_T_HW_STATE, NULL)) == NULL) break;
                printf("SUCCESS SW_RADIO_STATE=%d HW_RADIO_STATE=%d\n", *t_sw_radio_state_ptr, *t_hw_radio_state_ptr);
                break;
            }

            printf("ERROR\n");
            break;
        } while (0);

        //SETE6: free the cnf msg
        mipc_msg_deinit(msg_cnf_ptr);
    } while (0);

    mipc_deinit();
}
