/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  This software is protected by Copyright and the information contained
*  herein is confidential. The software may not be copied and the information
*  contained herein may not be used or disclosed except with the written
*  permission of MediaTek Inc. (C) 2008
*
*  BY OPENING THIS FILE, BUYER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
*  THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
*  RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO BUYER ON
*  AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
*  EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
*  MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
*  NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
*  SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
*  SUPPLIED WITH THE MEDIATEK SOFTWARE, AND BUYER AGREES TO LOOK ONLY TO SUCH
*  THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. MEDIATEK SHALL ALSO
*  NOT BE RESPONSIBLE FOR ANY MEDIATEK SOFTWARE RELEASES MADE TO BUYER'S
*  SPECIFICATION OR TO CONFORM TO A PARTICULAR STANDARD OR OPEN FORUM.
*
*  BUYER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND CUMULATIVE
*  LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
*  AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
*  OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY BUYER TO
*  MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
*
*  THE TRANSACTION CONTEMPLATED HEREUNDER SHALL BE CONSTRUED IN ACCORDANCE
*  WITH THE LAWS OF THE STATE OF CALIFORNIA, USA, EXCLUDING ITS CONFLICT OF
*  LAWS PRINCIPLES.  ANY DISPUTES, CONTROVERSIES OR CLAIMS ARISING THEREOF AND
*  RELATED THERETO SHALL BE SETTLED BY ARBITRATION IN SAN FRANCISCO, CA, UNDER
*  THE RULES OF THE INTERNATIONAL CHAMBER OF COMMERCE (ICC).
*
*****************************************************************************/
/*****************************************************************************
 *
 * Filename:
 * ---------
 *   time_clib_srv.c
 *
 * Project:
 * --------
 *  
 *
 * Description:
 * ------------
 *   
 *
 * Author:
 * -------
 *   
 *
 ****************************************************************************/

#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#ifdef NEED_CTRL_AS_SP
#include <cutils/properties.h>
#include <android/log.h>
#endif
#include <sys/ioctl.h>
#include <errno.h>
#include <stdlib.h>
#include <pthread.h>
#include <dirent.h>
#include <sys/mman.h>
#include <time.h>
#include <sys/time.h>
#include "platform/ccci_intf.h"
#include "ccci_mdinit_cfg.h"

//extern int time_monitor_thd_quit;
static pthread_mutex_t mtx = PTHREAD_MUTEX_INITIALIZER;
static int ipc_fd;

static int save_timezone(int tz)
{
	int fd;
	int ret;
  LOGD("save_timezone++\n");
	fd = open(CCCI_TIMEZONE_FILE, O_CREAT | O_RDWR | O_TRUNC, 0600);
	if(fd<0) {
		LOGE("Open time zone setting fail:%d(%d)", fd, errno);
		return -1;
	}

	//Update timezone info to file
	ret = write(fd, &tz, sizeof(int));
	if(ret != sizeof(int)) {
		LOGE("Write time zone setting fail:%d(%d)", ret, errno);
		close(fd);
		return -2;
	}

	close(fd);
	return 0;
}

int load_timezone(int *tz)
{
	int fd;
	int ret;
  LOGD("load_timezone++\n");
	fd = open(CCCI_TIMEZONE_FILE, O_RDONLY, 0600);
	if(fd<0) {
		LOGE("Open time zone setting fail(R):%d(%d)", fd, errno);
		return -1;
	}

	//Update timezone info to file
	ret = read(fd, tz, sizeof(int));
	if(ret != sizeof(int)) {
		LOGE("Read time zone setting fail(R):%d(%d)", ret, errno);
		close(fd);
		return -2;
	}

	close(fd);
	return 0;
}

int time_srv_init(void)
{
	struct timezone tz;
	int    curr_tz;
	LOGD("time_srv_init++\n");
	ipc_fd = open(CCCI_TIME_UPDATE_PORT, O_RDWR);
	if(ipc_fd<0) {
		LOGE("Open ipc port %d fail", errno);
		return -1;
	}

	if(load_timezone(&curr_tz) < 0) {
		gettimeofday(NULL, &tz);
		curr_tz = tz.tz_minuteswest;
	}
		
	if(ioctl(ipc_fd, CCCI_IPC_UPDATE_TIMEZONE, curr_tz)<0) {
		LOGE("Set default tz by ipc port fail(%d)", errno);
		return -2;
	}
	return 0;
}

void* monitor_time_update_thread(void)
{
	struct timezone tz;
	int    curr_tz;
	LOGD("monitor_time_update_thread++\n");
	if(load_timezone(&curr_tz) < 0) {
		gettimeofday(NULL, &tz);
		curr_tz = tz.tz_minuteswest;
	}

	LOGD("Umonitor_time_update_thread begin to run");

	while(1) {
		pthread_mutex_lock(&mtx);

		if(ioctl(ipc_fd, CCCI_IPC_WAIT_TIME_UPDATE, 0)==0) {
			gettimeofday(NULL, &tz);
			if(curr_tz != tz.tz_minuteswest) {
				curr_tz = tz.tz_minuteswest;
				save_timezone(curr_tz);
			}

			if(ioctl(ipc_fd, CCCI_IPC_UPDATE_TIME, curr_tz)<0)
				LOGE("Update time to md by ipc port fail(%d)", errno);
		}
		
		pthread_mutex_unlock(&mtx);
	}

	close(ipc_fd);
	return NULL;
}

