// SPDX-License-Identifier: MediaTekProprietary
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2015. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

/*****************************************************************************
 * Include
 *****************************************************************************/

#include "RpDataController.h"

#include <sys/un.h>
#include <errno.h>
#include <unistd.h>
#include <cutils/jstring.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <vector>
#include <algorithm>

#include "RilParcelUtils.h"
#include "MipcUtils.h"
#include "RpUtils.h"
#include "RfxDispatchThread.h"
#include "Rfx.h"
#include "RfxDefs.h"

#include <netagent/NetAgentService.h>



#ifdef __cplusplus
extern "C" {
#endif
#include "mipc_data_api.h"
#ifdef __cplusplus
}
#endif

#define DEBUG 1

int RpDataController::s_dataSetting[MAX_SIM_COUNT][DATA_SETTING_NUMBERS] = {{0}};
int RpDataController::s_dataSetting_resend[MAX_SIM_COUNT][DATA_SETTING_NUMBERS];
RpDataController* RpDataController::sInstance[4] = {NULL};
Mutex m_mutex[MAX_SIM_COUNT];

#include <string>
using namespace std;
using ::android::status_t;

#define RFX_LOG_TAG "RpDataController"

/*****************************************************************************
 * Class RfxDataController
 * The class is created if the slot is single mode, LWG or C,
 *****************************************************************************/


static void dumpDataCallAct(const mipc_data_call_act_struct * dataCall){

    char address[65] = {0};
    int i = 0;

    if (dataCall == NULL){
        RFX_LOG_E(RFX_LOG_TAG, "[%s] NULL Parameter", __FUNCTION__);
        return;
    }

#if 1
    RFX_LOG_D(RFX_LOG_TAG, "%s dump DataCall Act begin", __FUNCTION__);

    RFX_LOG_D(RFX_LOG_TAG, "%s result_code[%d] id[%d] apn[%s] pdp_type[%d] interface_id[%d]", __FUNCTION__, \
        dataCall->result_code, dataCall->id, dataCall->apn, dataCall->pdp_type, dataCall->interface_id);

    for (i = 0; i < dataCall->v4_addr_count; i++){
        memset(address, 0, sizeof(address));
        inet_ntop(AF_INET, (void *)dataCall->v4_addrs[i].addr, address, 16);
        RFX_LOG_D(RFX_LOG_TAG, "%s ipv4 addr[%s]", __FUNCTION__, address);
    }

    for (i = 0; i < dataCall->dns_v4_addr_count; i++){
        memset(address, 0, sizeof(address));
        inet_ntop(AF_INET, (void *)dataCall->dns_v4_addrs[i].addr, address, 16);
        RFX_LOG_D(RFX_LOG_TAG, "%s ipv4 dns index[%d][%s]", __FUNCTION__, i, address);
    }

    memset(address, 0, sizeof(address));
    inet_ntop(AF_INET, (void *)dataCall->gw_v4_addr.addr, address, 16);
    RFX_LOG_D(RFX_LOG_TAG, "%s ipv4 gateway[%s]", __FUNCTION__, address);

    if (dataCall->v6_addr_count > 0){
        memset(address, 0, sizeof(address));
        inet_ntop(AF_INET6, (void *)dataCall->v6_addrs[0].addr, address, 64);
        snprintf((address+strlen(address)), 65-strlen(address),"%s%d", "/",dataCall->v6_addrs[0].prefix);
        RFX_LOG_D(RFX_LOG_TAG, "%s ipv6 address [%s]", __FUNCTION__, address);
    }

    //ipv6 dns
    for (i = 0; i < dataCall->dns_v6_addr_count; i++){
        memset(address, 0, sizeof(address));
        inet_ntop(AF_INET6, (void *)dataCall->dns_v6_addrs[i].addr, address, 64);
        RFX_LOG_D(RFX_LOG_TAG, "%s ipv6 dns index[%d][%s]", __FUNCTION__, i,address);
    }

    memset(address, 0, sizeof(address));
    inet_ntop(AF_INET6, (void *)dataCall->gw_v6_addr.addr, address, 64);
    RFX_LOG_D(RFX_LOG_TAG, "%s ipv6 gateway[%s]", __FUNCTION__, address);
    RFX_LOG_D(RFX_LOG_TAG, "%s dump DataCall Act end", __FUNCTION__);
#else

#endif

}


RFX_IMPLEMENT_CLASS("RpDataController", RpDataController, RfxController);

RpDataController::RpDataController() {
    int i = 0;
    m_pPdnManager = NULL;
    m_nGprsFailureCause = PDP_FAIL_NONE;

    for (i = 0; i < 2; i++) {
        m_mipcIndType[i] = NULL;
    }

    isIpv6AddressUpdateCbReg = false;
}

RpDataController::~RpDataController() {
}

RpDataController* RpDataController::getInstance(int soltId){
    RFX_LOG_D(RFX_LOG_TAG, "%s:%d  sInstance[%d] = %p", __FUNCTION__ ,  __LINE__, \
                soltId, sInstance[soltId]);
    return sInstance[soltId];
}


extern "C" {


void mipc_data_call_deact_cb(mipc_sim_ps_id_enum sim_ps_id,
    mipc_data_call_deact_struct *result_ptr, void *cb_priv_ptr) {
    int ret = 0;

    RFX_LOG_D(RFX_LOG_TAG,"%s %d sim_ps_id[%d] result_ptr[%p] cb_priv_ptr[%p]",__FUNCTION__, __LINE__, sim_ps_id, \
        result_ptr, cb_priv_ptr);

    if ((result_ptr == NULL) || (cb_priv_ptr == NULL || (sim_ps_id < 1))){
        RFX_LOG_E(RFX_LOG_TAG, "[%s][%d] sim_ps_id[%d] NULL result_ptr", __FUNCTION__, __LINE__ ,sim_ps_id);
        ret = 0x01;
    }
    if (result_ptr->result_code != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_E(RFX_LOG_TAG, "%s %d data call deact fail", __FUNCTION__, __LINE__);
        ret = 0x01;
    }

    RpDataController * dataController = RpDataController::getInstance(sim_ps_id - 1);

    if (dataController == NULL){
        RFX_LOG_E(RFX_LOG_TAG, "[%s][%d] sim_ps_id[%d] NULL dataController", __FUNCTION__, __LINE__ ,sim_ps_id);
        ret |= 0x02;
    }
    RmcDcPdnManager* pPdnManager = dataController->m_pPdnManager;

    if (pPdnManager == NULL){
        RFX_LOG_E(RFX_LOG_TAG, "[%s][%d] sim_ps_id[%d] NULL m_pPdnManager", __FUNCTION__, __LINE__ ,sim_ps_id);
        ret |= 0x04;
    }
    RFX_LOG_D(RFX_LOG_TAG, "%s:%d id: %d, ret: %d", __FUNCTION__ ,  __LINE__, result_ptr->id, ret);
    // Reset pdn info with current aid.
    if (ret == 0) {
        pPdnManager->clearPdnInfo(result_ptr->id);
    }
    if ((ret & 0x01) == 0) {
        RFX_LOG_D(RFX_LOG_TAG, "%s:%d notify success", __FUNCTION__ ,  __LINE__);
        rfx_enqueue_response_message(NULL, cb_priv_ptr, mipc_sim_id_to_slot_id(sim_ps_id), RIL_E_SUCCESS);
    } else {
        RFX_LOG_D(RFX_LOG_TAG, "%s:%d notify fail", __FUNCTION__ ,  __LINE__);
        rfx_enqueue_response_message(NULL, cb_priv_ptr, mipc_sim_id_to_slot_id(sim_ps_id), RIL_E_GENERIC_FAILURE);
    }
}

void mipc_data_get_retry_timer_cb(mipc_sim_ps_id_enum sim_ps_id,
    mipc_data_get_retry_timer_struct_v *result_ptr, void *cb_priv_ptr) {
    Get_Retry_timer_call_back_priv* cb_priv = (Get_Retry_timer_call_back_priv*)cb_priv_ptr;
    Parcel * parcel = NULL;
    int ret = 0;

    RpDataController * dataController = RpDataController::getInstance(sim_ps_id - 1);

    if (dataController == NULL){
        RFX_LOG_E(RFX_LOG_TAG, "[%s][%d] sim_ps_id[%d] NULL dataController", __FUNCTION__, __LINE__ ,sim_ps_id);
        goto error;
    }
    if (cb_priv == NULL || cb_priv->response == NULL) {
        RFX_LOG_E(RFX_LOG_TAG, "[%s][%d] sim_ps_id[%d] NULL cb_priv && response", __FUNCTION__, __LINE__ ,sim_ps_id);
        goto error;
    }

    parcel = new Parcel();
    if (parcel == NULL){
        RFX_LOG_E(RFX_LOG_TAG, "[%s][%d] sim_ps_id[%d] NULL dataController", __FUNCTION__, __LINE__ ,sim_ps_id);
        goto error;
    }
    if (result_ptr != NULL) {
        cb_priv->response->suggestedRetryTime = result_ptr->retry_timer;
    } else {
        cb_priv->response->suggestedRetryTime = -1;
    }

    ret = responseDataCallListV11(*parcel, cb_priv->response, sizeof(MTK_RIL_Data_Call_Response_v11));
    if (ret != 0){
        RFX_LOG_E(RFX_LOG_TAG, "[%s][%d] sim_ps_id[%d] NULL dataController", __FUNCTION__, __LINE__ ,sim_ps_id);
        goto error;
    }

    goto finish;

error:
    if (parcel != NULL){
        delete(parcel);
        parcel = NULL;
    }
    RFX_LOG_E(RFX_LOG_TAG, "%s:%d notify failure", __FUNCTION__ ,  __LINE__);
finish:
    RFX_LOG_D(RFX_LOG_TAG, "%s:%d notify response", __FUNCTION__ ,  __LINE__);
    if (parcel == NULL)
        rfx_enqueue_response_message(NULL, cb_priv->token, mipc_sim_id_to_slot_id(sim_ps_id), RIL_E_GENERIC_FAILURE);
    else
        rfx_enqueue_response_message(parcel, cb_priv->token, mipc_sim_id_to_slot_id(sim_ps_id), RIL_E_SUCCESS);

    if (cb_priv->response != NULL) {
        dataController->freeDataResponse(cb_priv->response);
        FREEIF(cb_priv->response);
        FREEIF(cb_priv);
    }
    RFX_LOG_D(RFX_LOG_TAG, "[%s] finish", __FUNCTION__);

}

void mipc_data_call_act_cb(mipc_sim_ps_id_enum sim_ps_id,
    mipc_data_call_act_struct *result_ptr, void *cb_priv_ptr) {

    MTK_RIL_Data_Call_Response_v11* response = NULL;
    Parcel * parcel = NULL;
    int ret = 0;
    mipc_api_result_enum result = MIPC_API_RESULT_SUCCESS;
    char *apn = NULL;
    Act_Data_call_back_priv* data_cb_priv = (Act_Data_call_back_priv*)cb_priv_ptr;
    Get_Retry_timer_call_back_priv* retry_timer_cb_priv = NULL;
    RIL_DataCallFailCause dataCallFailCause = PDP_FAIL_NONE;

    RFX_LOG_D(RFX_LOG_TAG,"%s %d sim_ps_id[%d] result_ptr[%p] cb_priv_ptr[%p]",__FUNCTION__, __LINE__, sim_ps_id, \
        result_ptr, cb_priv_ptr);

    if ((result_ptr == NULL) || (cb_priv_ptr == NULL || (sim_ps_id < 1))){
        return;
    }

    RpDataController * dataController = RpDataController::getInstance(sim_ps_id - 1);

    if (dataController == NULL){
        RFX_LOG_E(RFX_LOG_TAG, "[%s][%d] sim_ps_id[%d] NULL dataController", __FUNCTION__, __LINE__ ,sim_ps_id);
        return;
    }
    RmcDcPdnManager* pPdnManager = dataController->m_pPdnManager;

    if (pPdnManager == NULL){
            RFX_LOG_E(RFX_LOG_TAG, "[%s][%d] sim_ps_id[%d] NULL m_pPdnManager", __FUNCTION__, __LINE__ ,sim_ps_id);
            return;
    }

    // Initialize data call response.
    response = (MTK_RIL_Data_Call_Response_v11*)calloc(1, sizeof(MTK_RIL_Data_Call_Response_v11));
    RFX_ASSERT(response != NULL);
    dataController->initDataCallResponse(response, 1);

    dumpDataCallAct((const mipc_data_call_act_struct *)result_ptr);

   if (result_ptr->result_code != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_E(RFX_LOG_TAG, "[%s][%d] sim_ps_id[%d] MIPC_API_RESULT_FAIL", __FUNCTION__, __LINE__ ,sim_ps_id);
        if (result_ptr->apn == NULL || strlen((char*)result_ptr->apn) <= 0) {
            if (data_cb_priv != NULL) {
                RFX_LOG_E(RFX_LOG_TAG, "[%s][%d] sim_ps_id[%d] cb apn %s", __FUNCTION__, __LINE__ , sim_ps_id, data_cb_priv->apn);
                asprintf(&apn, "%s", data_cb_priv->apn);
            }
        } else {
            apn = (char*)result_ptr->apn;
        }
        pPdnManager->clearPdnInfo(result_ptr->id);
    } else {
        pPdnManager->fillPdnInfoByMipcDataCallAct(result_ptr);
    }

    dataController->createDataResponse(dataController->calculateTransIntfId(result_ptr->id, result_ptr->interface_id), IPV4V6, response);


    if (result_ptr->result_code != MIPC_API_RESULT_SUCCESS) {
        dataCallFailCause = dataController->convertFailCauseToRilStandard((int)result_ptr->result_code);
        if (dataCallFailCause == PDP_FAIL_NONE) {
            RFX_LOG_E(RFX_LOG_TAG, "[%d][%s] NO CAUSE(0) but mipc_data_call_act_req failed",
                    sim_ps_id, __FUNCTION__);
            dataCallFailCause = PDP_FAIL_ERROR_UNSPECIFIED;
        } else {
            RFX_LOG_E(RFX_LOG_TAG, "[%d][%s] FAIL CAUSE: %X",
                    sim_ps_id, __FUNCTION__, dataCallFailCause);
        }
        response->status = dataCallFailCause;
        dataController->setGprsFailureCause((int)dataCallFailCause);
        retry_timer_cb_priv = (Get_Retry_timer_call_back_priv*)calloc(1, sizeof(Get_Retry_timer_call_back_priv));
        if (retry_timer_cb_priv != NULL) {
            retry_timer_cb_priv->token = data_cb_priv->token;
            retry_timer_cb_priv->response = response;
            RFX_LOG_E(RFX_LOG_TAG, "[%s][%d] sim_ps_id[%d] MIPC_API_RESULT_FAIL [%s]", __FUNCTION__, __LINE__ ,sim_ps_id,(char*)result_ptr->apn);
            result = mipc_data_get_retry_timer_async(sim_ps_id, mipc_data_get_retry_timer_cb, (void*)retry_timer_cb_priv, apn);
            if (result != MIPC_API_RESULT_SUCCESS) {
                RFX_LOG_E(RFX_LOG_TAG, "[%s][%d] sim_ps_id[%d] mipc_data_get_retry_timer_sync fail", __FUNCTION__, __LINE__ ,sim_ps_id);
            }
            FREEIF(apn);
            FREEIF(data_cb_priv);
            return;
        } else {
            RFX_LOG_E(RFX_LOG_TAG, "[%s][%d] sim_ps_id[%d] null calloc",__FUNCTION__,__LINE__, sim_ps_id);
        }
        FREEIF(apn);
    }
    parcel = new Parcel();
    if (parcel == NULL){
        RFX_LOG_E(RFX_LOG_TAG, "[%s][%d] sim_ps_id[%d] NULL dataController", __FUNCTION__, __LINE__ ,sim_ps_id);
        goto error;
    }
    ret = responseDataCallListV11(*parcel, response, sizeof(MTK_RIL_Data_Call_Response_v11));
    if (ret != 0){
        RFX_LOG_E(RFX_LOG_TAG, "[%s][%d] sim_ps_id[%d] NULL dataController", __FUNCTION__, __LINE__ ,sim_ps_id);
        goto error;
    }

    goto finish;

error:
    if (parcel != NULL){
        delete(parcel);
        parcel = NULL;
    }
    RFX_LOG_E(RFX_LOG_TAG, "%s:%d notify failure", __FUNCTION__ ,  __LINE__);
finish:
    RFX_LOG_D(RFX_LOG_TAG, "%s:%d notify response", __FUNCTION__ ,  __LINE__);
    if (parcel == NULL)
        rfx_enqueue_response_message(NULL, data_cb_priv->token, mipc_sim_id_to_slot_id(sim_ps_id), RIL_E_GENERIC_FAILURE);
    else
        rfx_enqueue_response_message(parcel, data_cb_priv->token, mipc_sim_id_to_slot_id(sim_ps_id), RIL_E_SUCCESS);

    if (response != NULL) {
        dataController->freeDataResponse(response);
        FREEIF(response);
    }
    FREEIF(data_cb_priv);
    RFX_LOG_D(RFX_LOG_TAG, "[%s] finish", __FUNCTION__);
}


void mipc_data_call_act_ind_cb(mipc_sim_ps_id_enum sim_ps_id,
    mipc_data_call_act_struct *result_ptr, void *cb_priv_ptr) {
    MIPC_MSG_enum * mipc_msg = (MIPC_MSG_enum *)cb_priv_ptr;

    int ret = 0;

    RFX_LOG_D(RFX_LOG_TAG,"%s %d sim_ps_id[%d] result_ptr[%p] cb_priv_ptr[%p]",__FUNCTION__, __LINE__, sim_ps_id, \
        result_ptr, cb_priv_ptr);

    if ((result_ptr == NULL) || (cb_priv_ptr == NULL || (sim_ps_id < 1))){
        return;
    }

    RpDataController * dataController = RpDataController::getInstance(sim_ps_id - 1);

    if (dataController == NULL){
        RFX_LOG_E(RFX_LOG_TAG, "[%s][%d] sim_ps_id[%d] NULL dataController", __FUNCTION__, __LINE__ ,sim_ps_id);
        return;
    }
    RmcDcPdnManager* pPdnManager = dataController->m_pPdnManager;

    if (pPdnManager == NULL){
            RFX_LOG_E(RFX_LOG_TAG, "[%s][%d] sim_ps_id[%d] NULL dataController", __FUNCTION__, __LINE__ ,sim_ps_id);
            return;
    }

    if (result_ptr == NULL){
            RFX_LOG_E(RFX_LOG_TAG, "[%s][%d] sim_ps_id[%d] NULL dataController", __FUNCTION__, __LINE__ ,sim_ps_id);
            return;
    }

    const int nPdnInfoSize = pPdnManager->getPdnTableSize();
    dumpDataCallAct((const mipc_data_call_act_struct *)result_ptr);


    RFX_LOG_D(RFX_LOG_TAG, "[%s][%d] sim_ps_id[%d] mipc_msg[%p]", __FUNCTION__, __LINE__, sim_ps_id, mipc_msg);
       
    if (mipc_msg == NULL)
        return;
    else if ((*mipc_msg = MIPC_DATA_ACT_CALL_IND) || (*mipc_msg = MIPC_DATA_MOD_CALL_IND)){
        RFX_LOG_D(RFX_LOG_TAG, "[%s][%d] mipc_msg[%d]", __FUNCTION__, __LINE__, *mipc_msg);
        RmcDcPdnManager* pPdnManager = dataController->m_pPdnManager;
        pPdnManager->fillPdnInfoByMipcDataCallAct((const mipc_data_call_act_struct *)result_ptr);
        dataController->sendDataCallListResponse(INVALID_AID);
    } else {
        RFX_LOG_E(RFX_LOG_TAG,"%s %d: error indication mipc_msg[%d]",__FUNCTION__, __LINE__, *mipc_msg);
    }
}

void mipc_data_call_deact_ind_cb(mipc_sim_ps_id_enum sim_ps_id,
    mipc_data_call_deact_struct *result_ptr, void *cb_priv_ptr) {
    PdnInfo pdn_info;

    RFX_LOG_D(RFX_LOG_TAG,"%s %d  sim_ps_id[%d] result_ptr[%p]",__FUNCTION__, __LINE__, sim_ps_id, result_ptr);

    if (result_ptr == NULL){
        return;
    }

    RpDataController * dataController = RpDataController::getInstance(sim_ps_id - 1);

    if (dataController == NULL){
        RFX_LOG_E(RFX_LOG_TAG, "[%s][%d] sim_ps_id[%d] NULL dataController", __FUNCTION__, __LINE__ ,sim_ps_id);
        return;
    }

    m_mutex[sim_ps_id - 1].lock();
    RmcDcPdnManager* pPdnManager = dataController->m_pPdnManager;

    if (pPdnManager == NULL){
        RFX_LOG_E(RFX_LOG_TAG, "[%s][%d] sim_ps_id[%d] NULL m_pPdnManager", __FUNCTION__, __LINE__ ,sim_ps_id);
        return;
    }

    pdn_info = pPdnManager->getPdnInfo(result_ptr->id);
    pdn_info.deactReason = dataController->convertFailCauseToRilStandard(result_ptr->network_error);
    pPdnManager->setPdnInfo(result_ptr->id, &pdn_info);
    RFX_LOG_D(RFX_LOG_TAG,"%s %d:sim_ps_id %d result_code %d, deactReason %d",__FUNCTION__, __LINE__,
        sim_ps_id,result_ptr->result_code, pdn_info.deactReason);

    if (dataController->notifyDeactReasonIfNeeded(result_ptr->id)) {
        dataController->sendDataCallListResponse(result_ptr->id);
        pPdnManager->clearPdnInfo(result_ptr->id);
    }
    m_mutex[sim_ps_id - 1].unlock();
}


void mipc_data_set_data_allow_cb(mipc_sim_ps_id_enum sim_ps_id,
    mipc_data_set_data_allow_struct_v *result_ptr,
    void *cb_priv_ptr) {

    RFX_LOG_D(RFX_LOG_TAG,"%s %d  sim_ps_id[%d] result_ptr[%p]",__FUNCTION__, __LINE__, sim_ps_id, result_ptr);

    if (result_ptr == NULL){
        return;
    }

    RFX_LOG_D(RFX_LOG_TAG,"%s %d:sim_ps_id %d result_code %d",__FUNCTION__, __LINE__,
        sim_ps_id,result_ptr->result_code);

    if(result_ptr->result_code != MIPC_RESULT_SUCCESS)
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_GENERIC_FAILURE);
    else
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
}

}

void onKernelAddressUpdated(void *data, int slotId){
    NetlinkIpv6Info *netInfo = (NetlinkIpv6Info*)data;
    RFX_LOG_D(RFX_LOG_TAG, "%s slotId=%d interfaceId=%d, address=%s, prefixLength=%d",
            __FUNCTION__, slotId,netInfo->interfaceId, netInfo->address, netInfo->prefixLength);

    RpDataController * dataController = RpDataController::getInstance(slotId);

    if (dataController == NULL){
        RFX_LOG_E(RFX_LOG_TAG, "[%s][%d] sim_ps_id[%d] NULL dataController", __FUNCTION__, __LINE__ ,slotId);
        return;
    }

    //update ipv6 global ip
    if (dataController->updataIpv6Address(netInfo) != 0){
       RFX_LOG_E(RFX_LOG_TAG, "[%s][%d] sim_ps_id[%d] no active pdn for this IPV6 address", __FUNCTION__, __LINE__ ,slotId);
       return;
    }

    //RIL_UNSOL_DATA_CALL_LIST_CHANGED
    dataController->sendDataCallListResponse(INVALID_AID);

    return;
}


void RpDataController::onInit() {
    int i = 0;
    RfxController::onInit();  // Required: invoke super class implementation

    RFX_LOG_D(RFX_LOG_TAG, "RpDataController onInit");

    for (i = 0; i < 2; i++) {
        if (m_mipcIndType[i]){
            FREE(m_mipcIndType[i]);
            m_mipcIndType[i] = NULL;
        }
    }

    for (i = 0; i < 2; i++) {
        m_mipcIndType[i] = ( MIPC_MSG_enum *)calloc(1, sizeof(MIPC_MSG_enum));
        RFX_ASSERT(m_mipcIndType[i] != NULL);

    }

    *m_mipcIndType[0] = MIPC_DATA_ACT_CALL_IND;
    mipc_data_call_act_register(slot_id_to_mipc_sim_id(getSlotId()),mipc_data_call_act_ind_cb, m_mipcIndType[0]);

    mipc_data_call_deact_register(slot_id_to_mipc_sim_id(getSlotId()),mipc_data_call_deact_ind_cb, NULL);

    *m_mipcIndType[1] = MIPC_DATA_MOD_CALL_IND;
    mipc_data_call_mod_register(slot_id_to_mipc_sim_id(getSlotId()),mipc_data_call_act_ind_cb, m_mipcIndType[1]);

    const int request_id_list[] = {
            RIL_REQUEST_SETUP_DATA_CALL,  // 27
            RIL_REQUEST_DEACTIVATE_DATA_CALL,  // 41
            RIL_REQUEST_LAST_DATA_CALL_FAIL_CAUSE, // 56
            RIL_REQUEST_DATA_CALL_LIST,  // 57
            RIL_REQUEST_SET_INITIAL_ATTACH_APN, //111
            RIL_REQUEST_ALLOW_DATA,  // 123
            RIL_REQUEST_SET_DATA_PROFILE, //128
            RIL_REQUEST_SYNC_DATA_SETTINGS_TO_MD, //2062
    };

    const int urc_id_list[] = {
            RIL_UNSOL_DATA_CALL_LIST_CHANGED,
    };

    sInstance[getSlotId()] = this;
    RFX_LOG_D(RFX_LOG_TAG, "%s:%d  sInstance[%d] = %p", __FUNCTION__ ,  __LINE__, \
                getSlotId(), sInstance[getSlotId()]);

    m_pPdnManager = getPdnManager();

    //register callback for ipv6 address update
    if (isIpv6AddressUpdateCbReg == false){
        NetAgentService *pNetAgentService = NetAgentService::getInstance();
        if (pNetAgentService){
            pNetAgentService->registerCbKernelAddressUpdated(onKernelAddressUpdated, m_slot_id);
            isIpv6AddressUpdateCbReg = true;
        }
        RFX_LOG_D(RFX_LOG_TAG, "%s:%d  pNetAgentService[%d] = %p", __FUNCTION__ ,  __LINE__, \
                        getSlotId(), pNetAgentService);
    }

    // register request id list
    registerToHandleRequest(request_id_list,
            sizeof(request_id_list) / sizeof(int));

    registerToHandleUrc(urc_id_list, (sizeof(urc_id_list)/sizeof(int)));

    RFX_LOG_D(RFX_LOG_TAG, "RpDataController onInit done");
}

void RpDataController::onDeinit() {
    int i = 0;
    RFX_LOG_D(RFX_LOG_TAG, "onDeinit");

    for (i = 0; i < 2; i++) {
        if (m_mipcIndType[i]){
            FREE(m_mipcIndType[i]);
            m_mipcIndType[i] = NULL;
        }
    }

    mipc_data_call_act_register(slot_id_to_mipc_sim_id(getSlotId()),NULL,NULL);
    mipc_data_call_deact_register(slot_id_to_mipc_sim_id(getSlotId()),NULL,NULL);
    mipc_data_call_mod_register(slot_id_to_mipc_sim_id(getSlotId()),NULL,NULL);


    if (m_pPdnManager != NULL){
        delete(m_pPdnManager);
        m_pPdnManager = NULL;
    }

    sInstance[getSlotId()] = NULL;


    RfxController::onDeinit();
}

bool RpDataController::onHandleRequest(const sp<RfxMessage>& message) {
    RFX_LOG_D(RFX_LOG_TAG, "Handle request %d", message->getId());

    RfxDispatchThread::addMessageToPendingQueue(message);

    switch (message->getId()) {
    case RIL_REQUEST_SETUP_DATA_CALL:
        handleSetupDataRequest(message);
        break;
    case RIL_REQUEST_DEACTIVATE_DATA_CALL:
        handleDeactivateDataRequest(message);
        break;
    case RIL_REQUEST_LAST_DATA_CALL_FAIL_CAUSE:
        handleGetLastFailCauseRequest(message);
        break;
    case RIL_REQUEST_DATA_CALL_LIST:
        handleDataCallListRequest(message);
        break;
    case RIL_REQUEST_SET_INITIAL_ATTACH_APN:
        handleSetInitialAttachApnRequest(message);
    break;
    case RIL_REQUEST_ALLOW_DATA:
        handleSetDataAllowRequest(message);
        break;
    case RIL_REQUEST_SET_DATA_PROFILE:
        handleSyncApnTableRequest(message);
        break;
    case RIL_REQUEST_SYNC_DATA_SETTINGS_TO_MD:
        handleSyncDataSettingsToMdRequest(message);
        break;

    default:
        RFX_LOG_D(RFX_LOG_TAG, "unknown request, ignore!");
        break;
    }
    return true;
}

RmcDcPdnManager * RpDataController::getPdnManager (){
    if (m_pPdnManager  == NULL){
        m_pPdnManager  = new RmcDcPdnManager(this->getSlotId());
        if (m_pPdnManager  == NULL){
            RFX_LOG_E(RFX_LOG_TAG, "%s %d new fail", __FUNCTION__, __LINE__);
            RFX_ASSERT(m_pPdnManager != NULL);
        }
    }
    // RFX_LOG_D(RFX_LOG_TAG, "%s %d m_pPdnManager[%p]", __FUNCTION__, __LINE__, m_pPdnManager);
    return  m_pPdnManager ;
}

int RpDataController::updataIpv6Address (NetlinkIpv6Info * netInfo){
    PdnInfo pdn_info;
    memset(&pdn_info, 0, sizeof(pdn_info));
    int interfaceId = -1;


    
    int addressV6Length = 0;
    const int nPdnInfoSize = getPdnManager()->getPdnTableSize();

    if (netInfo == NULL){
        RFX_LOG_E(RFX_LOG_TAG, "%s %d", __FUNCTION__, __LINE__);
        return -1;
    }

    for (int i = 0; i < nPdnInfoSize; i++) {
        pdn_info = getPdnManager()->getPdnInfo(i);
        interfaceId = getInterfaceId(pdn_info.transIntfId);

        if ((netInfo->interfaceId == interfaceId) &&
                !pdn_info.isDedicateBearer &&
                (pdn_info.active == DATA_STATE_ACTIVE)) {
            RFX_LOG_D(RFX_LOG_TAG, "[%d][%s] copy pdn_info[%d] to data response for interfaceId=%d",
                    getSlotId(), __FUNCTION__, i, interfaceId);

            if (strncmp(netInfo->address, "fe80", 4) == 0){
                RFX_LOG_D(RFX_LOG_TAG, "[%d][%s] ignor ipv6 linklocal address", m_slot_id, __FUNCTION__);
                break;
            }

            memset(pdn_info.addressV6, 0, 65);
            snprintf(pdn_info.addressV6, 65,"%s%s%d", netInfo->address, "/",netInfo->prefixLength);
            RFX_LOG_D(RFX_LOG_TAG, "[%s] addressV6[%s] transIntfId[%d]", __FUNCTION__, pdn_info.addressV6, pdn_info.transIntfId);
            getPdnManager()->setPdnInfo(pdn_info.aid, &pdn_info);
            return 0;
        }
    }

    return -1;
}


bool RpDataController::isDataAllowed(const char* pReqApn){
    //need to enhance
    return true;
}

void RpDataController::freeDataResponse(MTK_RIL_Data_Call_Response_v11* response) {
    if (response->ifname != NULL) {
        RFX_LOG_D(RFX_LOG_TAG, "[%d][%s] type=%s, ifname=%s, addresses=%s, dnses=%s, gateways=%s, pcscf=%s",
                m_slot_id,
                __FUNCTION__,
                response->type,
                response->ifname,
                response->addresses,
                response->dnses,
                response->gateways,
                response->pcscf);
    }

    FREEIF(response->type);
    FREEIF(response->ifname);
    FREEIF(response->addresses);
    FREEIF(response->gateways);
    FREEIF(response->dnses);
    FREEIF(response->pcscf);
}



void RpDataController::initDataCallResponse(MTK_RIL_Data_Call_Response_v11* responses, int length) {
    for (int i = 0; i < length; i++) {
        memset(&responses[i], 0, sizeof(MTK_RIL_Data_Call_Response_v11));
        responses[i].status = PDP_FAIL_ERROR_UNSPECIFIED;
        responses[i].active = DATA_STATE_INACTIVE;
        responses[i].cid = INVALID_AID;
        responses[i].suggestedRetryTime = -1;
        responses[i].rat = 1; // 1: cellular
    }
}

bool RpDataController::validateAid(int aid){
    RFX_ASSERT(m_pPdnManager != NULL);
    return m_pPdnManager->validateAid(aid);
}


int RpDataController::deactivateDataCall(const int aid, const sp<RfxMessage>& request) {
    mipc_api_result_enum result = MIPC_API_RESULT_SUCCESS;
    mipc_data_call_deact_struct datacall;

    // Check if AID is out of bound.
    if (!validateAid(aid)) {
        RFX_LOG_E(RFX_LOG_TAG, "[%d][%s] aid=%d is out of bound",
                getSlotId(), __FUNCTION__, aid);
        return -1;
    }

    memset(&datacall, 0, sizeof(datacall));

    result = mipc_data_call_deact_async(slot_id_to_mipc_sim_id(getSlotId()), mipc_data_call_deact_cb, (void *)request->getRilToken(), aid);
    return result;
}




void RpDataController::handleSyncDataSettingsToMdRequest(const sp<RfxMessage>& request){
    int rid = m_slot_id;
    int countInts = 0;
    status_t status = 0;
    int allowed = -1;
    int *pReqData = NULL;
    int imsTestMode = -1;
    mipc_api_result_enum result = MIPC_API_RESULT_SUCCESS;
    char value[MTK_PROPERTY_VALUE_MAX] = {0};
    int isOp20Support = -1;
    int setDefaultSim = -1;
    mipc_data_set_data_config_struct_v dataConfigResult;

    RFX_LOG_D(RFX_LOG_TAG, "%s getSlotId: %d, clientId: %d, with token: %d", __FUNCTION__,
            request->getSlotId(), request->getClientId(), request->getToken());

    Parcel *p = request->getParcel();
    if(p == NULL) {
        RFX_LOG_D(RFX_LOG_TAG, "%s getSlotId: %d, clientId: %d, with token: %d", __FUNCTION__,
            request->getSlotId(), request->getClientId(), request->getToken());
        goto error;
    }

    status = p->readInt32(&countInts);

    if (countInts == 0) {
        RFX_LOG_D(RFX_LOG_TAG, "%s %d getSlotId: %d, clientId: %d, with token: %d:error parameter", __FUNCTION__, __LINE__,
            request->getSlotId(), request->getClientId(), request->getToken());
        goto error;
    }
    else {
        pReqData = (int *)calloc(countInts, sizeof(int));
        if (pReqData == NULL) {
            RFX_LOG_E(RFX_LOG_TAG, "%s:%d  slotid[%d] clientid[%d] token[%d]Memory allocation failed", __FUNCTION__ ,  __LINE__, \
                request->getSlotId(), request->getClientId(), request->getToken());
            goto error;
        }

        for (int i = 0 ; i < countInts ; i++) {
            status = p->readInt32(&pReqData[i]);
        }
    }

    // s_dataSetting[m_slot_id][0 (MOBILE_DATA)]:      data setting on/off.
    // s_dataSetting[m_slot_id][1 (ROAMING_DATA)]:     data roaming setting on/off.
    // s_dataSetting[m_slot_id][2 (DEFAULT_DATA_SIM)]: default data SIM setting.
    for (int i = 0; i < countInts; i++) {
        s_dataSetting[m_slot_id][i] = pReqData[i];
        if (pReqData[i] != SKIP_DATA_SETTINGS) {
            s_dataSetting_resend[m_slot_id][i] = pReqData[i];
        }
    }

    // 0: clear
    // 1: slot 0
    // 2: slot 1
    // Modem only receive the slot ID which start from 1.
    // And 0 is treated as "UNSET" to reset.
    setDefaultSim = s_dataSetting[m_slot_id][DEFAULT_DATA_SIM] + 1;

    RFX_LOG_I(RFX_LOG_TAG,
            "[%d][%s] Start, dataOn:%d, dataRoaming:%d, defaultDataSim: %d (original: %d),"
            "domestic roaming: %d, international raoming: %d",
            rid,
            __FUNCTION__,
            s_dataSetting[m_slot_id][MOBILE_DATA],
            s_dataSetting[m_slot_id][ROAMING_DATA],
            setDefaultSim,
            s_dataSetting[m_slot_id][DEFAULT_DATA_SIM],
            s_dataSetting[m_slot_id][DOMESTIC_ROAMING_DATA],
            s_dataSetting[m_slot_id][INTERNATIONAL_ROAMING_DATA]);

    if (s_dataSetting[m_slot_id][DEFAULT_DATA_SIM] != SKIP_DATA_SETTINGS
        && (s_dataSetting[m_slot_id][DEFAULT_DATA_SIM] <= MAX_RFX_SLOT_ID
            || s_dataSetting[m_slot_id][DEFAULT_DATA_SIM] >= RFX_SLOT_ID_0)) {


        //need to do EDALLOW=2,<slot_id>
        // update ICCID property when default data SIM is changed
        //updateDefaultDataProperty(s_dataSetting[m_slot_id][DEFAULT_DATA_SIM]);
    }

    //**WWOP requirement**
    isOp20Support = RmcDcUtility::isOp20Support();

    // s_dataSetting[m_slot_id][0 (MOBILE_DATA)]:      data setting on/off.
    // s_dataSetting[m_slot_id][1 (ROAMING_DATA)]:     data roaming setting on/off.
    // s_dataSetting[m_slot_id][2 (DEFAULT_DATA_SIM)]: default data SIM setting.
    // s_dataSetting[m_slot_id][3 (DOMESTIC_ROAMING_DATA)]: domestic roaming setting.
    // s_dataSetting[m_slot_id][4 (INTERNATIONAL_ROAMING_DATA)]: international roaming setting.
    // If no need to set mobile data and domestic roaming data or international roaming data
    // then return the result for default data SIM to MD.
    if (isOp20Support == 1) {
        if (s_dataSetting[m_slot_id][MOBILE_DATA] == SKIP_DATA_SETTINGS &&
            s_dataSetting[m_slot_id][DOMESTIC_ROAMING_DATA] == SKIP_DATA_SETTINGS &&
            s_dataSetting[m_slot_id][INTERNATIONAL_ROAMING_DATA] == SKIP_DATA_SETTINGS ) {
            RFX_LOG_I(RFX_LOG_TAG, "[%d][%s] No need to sync to MD for mobile data and roaming type.",
                    rid, __FUNCTION__);
            goto finish;
        }
    //**WWOP requirement**
    } else {

    // If no need to set mobile data and roaming data,
    // then return the result for default data SIM to MD.
        if (s_dataSetting[m_slot_id][MOBILE_DATA] == SKIP_DATA_SETTINGS &&
            s_dataSetting[m_slot_id][ROAMING_DATA] == SKIP_DATA_SETTINGS) {
            goto finish;
        }
    }
    /**
     * To get IMS test mode setting and sync to modem for OP12
     *    Enable : Set Attach PDN to VZWINTERNET
     *    Disable: Set Attach PDN to VZWIMS (Default)
     */
    rfx_property_get("persist.vendor.radio.imstestmode", value, "0");
    imsTestMode = atoi(value);


    //**WWOP requirement**//
    if (isOp20Support == 1) {
    //    RFX_LOG_I(RFX_LOG_TAG, "Enter ECNCFG ");
    // AT+ECNCFG=<mobile_data>,<data_roaming>,[<volte>,<ims_test_mode>],
    //           [<domestic_data_roaming>,<international_data_roaming>]
        if (s_dataSetting[m_slot_id][MOBILE_DATA] != SKIP_DATA_SETTINGS &&
            s_dataSetting[m_slot_id][DOMESTIC_ROAMING_DATA] == SKIP_DATA_SETTINGS &&
            s_dataSetting[m_slot_id][INTERNATIONAL_ROAMING_DATA] == SKIP_DATA_SETTINGS) {
            result = mipc_data_set_config_sync(mipc_sim_ps_id_enum(request->getSlotId()), &dataConfigResult, (mipc_data_config_type_const_enum)s_dataSetting[m_slot_id][MOBILE_DATA], \
                MIPC_DATA_CONFIG_TYPE_NO_CHANGE, MIPC_DATA_CONFIG_TYPE_NO_CHANGE, \
                (mipc_data_config_type_const_enum)imsTestMode, MIPC_DATA_CONFIG_TYPE_NO_CHANGE, MIPC_DATA_CONFIG_TYPE_NO_CHANGE);
        } else if (s_dataSetting[m_slot_id][MOBILE_DATA] == SKIP_DATA_SETTINGS &&
            s_dataSetting[m_slot_id][DOMESTIC_ROAMING_DATA] != SKIP_DATA_SETTINGS &&
            s_dataSetting[m_slot_id][INTERNATIONAL_ROAMING_DATA] == SKIP_DATA_SETTINGS) {
            result = mipc_data_set_config_sync(mipc_sim_ps_id_enum(request->getSlotId()), &dataConfigResult, MIPC_DATA_CONFIG_TYPE_NO_CHANGE, \
                MIPC_DATA_CONFIG_TYPE_NO_CHANGE, MIPC_DATA_CONFIG_TYPE_NO_CHANGE, \
                MIPC_DATA_CONFIG_TYPE_NO_CHANGE, (mipc_data_config_type_const_enum)s_dataSetting[m_slot_id][DOMESTIC_ROAMING_DATA], MIPC_DATA_CONFIG_TYPE_NO_CHANGE);
        } else if (s_dataSetting[m_slot_id][MOBILE_DATA] == SKIP_DATA_SETTINGS &&
            s_dataSetting[m_slot_id][DOMESTIC_ROAMING_DATA] == SKIP_DATA_SETTINGS &&
            s_dataSetting[m_slot_id][INTERNATIONAL_ROAMING_DATA] != SKIP_DATA_SETTINGS) {
            result = mipc_data_set_config_sync(mipc_sim_ps_id_enum(request->getSlotId()), &dataConfigResult, MIPC_DATA_CONFIG_TYPE_NO_CHANGE, \
                MIPC_DATA_CONFIG_TYPE_NO_CHANGE, MIPC_DATA_CONFIG_TYPE_NO_CHANGE, \
                (mipc_data_config_type_const_enum)imsTestMode, MIPC_DATA_CONFIG_TYPE_NO_CHANGE, (mipc_data_config_type_const_enum)s_dataSetting[m_slot_id][INTERNATIONAL_ROAMING_DATA]);
        //    RFX_LOG_I(RFX_LOG_TAG, "Enter ECNCFG, only international on/off");
            //p_response = atSendCommand(String8::format("AT+ECNCFG=,,,%d,,%d",
            //    imsTestMode, s_dataSetting[m_slot_id][INTERNATIONAL_ROAMING_DATA]));
        } else if (s_dataSetting[m_slot_id][MOBILE_DATA] == SKIP_DATA_SETTINGS &&
            s_dataSetting_resend[m_slot_id][DOMESTIC_ROAMING_DATA] != SKIP_DATA_SETTINGS &&
            s_dataSetting_resend[m_slot_id][INTERNATIONAL_ROAMING_DATA] != SKIP_DATA_SETTINGS) {
            result = mipc_data_set_config_sync(mipc_sim_ps_id_enum(request->getSlotId()), &dataConfigResult, MIPC_DATA_CONFIG_TYPE_NO_CHANGE, \
                MIPC_DATA_CONFIG_TYPE_NO_CHANGE, MIPC_DATA_CONFIG_TYPE_NO_CHANGE, \
                (mipc_data_config_type_const_enum)imsTestMode, (mipc_data_config_type_const_enum)s_dataSetting[m_slot_id][DOMESTIC_ROAMING_DATA], \
                (mipc_data_config_type_const_enum)s_dataSetting[m_slot_id][INTERNATIONAL_ROAMING_DATA]);
        //    RFX_LOG_I(RFX_LOG_TAG, "Enter ECNCFG, domestic and international on/off");
            //p_response = atSendCommand(String8::format("AT+ECNCFG=,,,%d,%d,%d",
            //    imsTestMode, s_dataSetting_resend[m_slot_id][DOMESTIC_ROAMING_DATA],
            //    s_dataSetting_resend[m_slot_id][INTERNATIONAL_ROAMING_DATA]));
        } else {
            result = mipc_data_set_config_sync(mipc_sim_ps_id_enum(request->getSlotId()), &dataConfigResult, (mipc_data_config_type_const_enum)s_dataSetting[m_slot_id][MOBILE_DATA], \
                MIPC_DATA_CONFIG_TYPE_NO_CHANGE, MIPC_DATA_CONFIG_TYPE_NO_CHANGE, \
                (mipc_data_config_type_const_enum)imsTestMode, (mipc_data_config_type_const_enum)s_dataSetting[m_slot_id][DOMESTIC_ROAMING_DATA], \
                (mipc_data_config_type_const_enum)s_dataSetting[m_slot_id][INTERNATIONAL_ROAMING_DATA]);
        //    RFX_LOG_I(RFX_LOG_TAG, "Enter ECNCFG,else ");
            //p_response = atSendCommand(String8::format("AT+ECNCFG=%d,,,%d,%d,%d",
            //    s_dataSetting[m_slot_id][MOBILE_DATA],imsTestMode,
            //    s_dataSetting[m_slot_id][DOMESTIC_ROAMING_DATA],
            //    s_dataSetting[m_slot_id][INTERNATIONAL_ROAMING_DATA]));
        }
    } else {
    //**WWOP requirement**//

    // AT+ECNCFG=<mobile_data>,<data_roaming>,[<volte>,<ims_test_mode>]
        if (s_dataSetting[m_slot_id][MOBILE_DATA] != SKIP_DATA_SETTINGS &&
            s_dataSetting[m_slot_id][ROAMING_DATA] == SKIP_DATA_SETTINGS) {
            result = mipc_data_set_config_sync(mipc_sim_ps_id_enum(request->getSlotId()), &dataConfigResult, (mipc_data_config_type_const_enum)s_dataSetting[m_slot_id][MOBILE_DATA], \
                MIPC_DATA_CONFIG_TYPE_NO_CHANGE, MIPC_DATA_CONFIG_TYPE_NO_CHANGE, \
                (mipc_data_config_type_const_enum)imsTestMode, MIPC_DATA_CONFIG_TYPE_NO_CHANGE, MIPC_DATA_CONFIG_TYPE_NO_CHANGE);
            //p_response = atSendCommand(String8::format("AT+ECNCFG=%d,,,%d,,",
             //   s_dataSetting[m_slot_id][MOBILE_DATA],imsTestMode));
        } else if (s_dataSetting[m_slot_id][MOBILE_DATA] == SKIP_DATA_SETTINGS &&
            s_dataSetting[m_slot_id][ROAMING_DATA] != SKIP_DATA_SETTINGS) {
            result = mipc_data_set_config_sync(mipc_sim_ps_id_enum(request->getSlotId()), &dataConfigResult, MIPC_DATA_CONFIG_TYPE_NO_CHANGE, \
                (mipc_data_config_type_const_enum)s_dataSetting[m_slot_id][ROAMING_DATA], MIPC_DATA_CONFIG_TYPE_NO_CHANGE, \
                (mipc_data_config_type_const_enum)imsTestMode, MIPC_DATA_CONFIG_TYPE_NO_CHANGE, MIPC_DATA_CONFIG_TYPE_NO_CHANGE);
            //p_response = atSendCommand(String8::format("AT+ECNCFG=,%d,,%d,,",
             //       s_dataSetting[m_slot_id][ROAMING_DATA], imsTestMode));
        } else {
            result = mipc_data_set_config_sync(mipc_sim_ps_id_enum(request->getSlotId()), &dataConfigResult, (mipc_data_config_type_const_enum)s_dataSetting[m_slot_id][MOBILE_DATA], \
                (mipc_data_config_type_const_enum)s_dataSetting[m_slot_id][ROAMING_DATA], MIPC_DATA_CONFIG_TYPE_NO_CHANGE, \
                (mipc_data_config_type_const_enum)imsTestMode, MIPC_DATA_CONFIG_TYPE_NO_CHANGE, MIPC_DATA_CONFIG_TYPE_NO_CHANGE);
           // p_response = atSendCommand(String8::format("AT+ECNCFG=%d,%d,,%d,,",
            //    s_dataSetting[m_slot_id][MOBILE_DATA], s_dataSetting[m_slot_id][ROAMING_DATA],
           //     imsTestMode));
        }
    }

   RFX_LOG_D(RFX_LOG_TAG, "[%d][%s] End result: %d", rid, __FUNCTION__, result);

finish:
    RFX_LOG_D(RFX_LOG_TAG, "%s:%d notify response", __FUNCTION__ ,  __LINE__);
    rfx_enqueue_response_message(NULL, request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(), RIL_E_SUCCESS);
    FREEIF(pReqData);
    return;
error:
    RFX_LOG_E(RFX_LOG_TAG, "%s:%d notify failure", __FUNCTION__ ,  __LINE__);
    rfx_enqueue_response_message(NULL, request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(), RIL_E_GENERIC_FAILURE);
    return;
}



void RpDataController::handleSyncApnTableRequest(const sp<RfxMessage>& request) {
    int32_t t;
    status_t status = 0;
    int32_t num = 0;
    int ret =0;
    mipc_apn_profiles_struct_v apnProfiles;
    mipc_api_result_enum result = MIPC_API_RESULT_SUCCESS;
    RIL_MtkDataProfileInfo *dataProfiles = NULL;
    RIL_MtkDataProfileInfo **dataProfilePtrs = NULL;
    mipc_apn_pdp_type_enum apnPdpType = MIPC_APN_ENUM_PDP_TYPE_DEFAULT;
    mipc_apn_pdp_type_enum roamingype = MIPC_APN_ENUM_PDP_TYPE_DEFAULT;
    int i = 0;

    memset(&apnProfiles, 0, sizeof(apnProfiles));

    RFX_LOG_D(RFX_LOG_TAG, "%s:%d getSlotId: %d, clientId: %d, with token: %d", __FUNCTION__, __LINE__,
            request->getSlotId(), request->getClientId(), request->getToken());

    Parcel *p = request->getParcel();
    if(p == NULL) {
        RFX_LOG_E(RFX_LOG_TAG, "%s:%d getSlotId: %d, clientId: %d, with token: %d", __FUNCTION__, __LINE__,
            request->getSlotId(), request->getClientId(), request->getToken());
        goto error;
    }


    status = p->readInt32(&num);
    RFX_LOG_D(RFX_LOG_TAG, "%s:%d num:%d getSlotId: %d, clientId: %d, with token: %d", __FUNCTION__, __LINE__, num,
            request->getSlotId(), request->getClientId(), request->getToken());
    if (status != 0 || num <= 0) {
        RFX_LOG_E(RFX_LOG_TAG, "%s:%d getSlotId: %d, clientId: %d, with token: %d status:%d", __FUNCTION__, __LINE__,
            request->getSlotId(), request->getClientId(), request->getToken(), status);
        goto error;
    }

    {
        dataProfiles = (RIL_MtkDataProfileInfo *)calloc(num, sizeof(RIL_MtkDataProfileInfo));
        if (dataProfiles == NULL) {
            RFX_LOG_E(RFX_LOG_TAG, "%s:%d getSlotId: %d, clientId: %d, with token: %d Memory allocation failed", __FUNCTION__, __LINE__,
                request->getSlotId(), request->getClientId(), request->getToken());
            goto error;
        }
        dataProfilePtrs = (RIL_MtkDataProfileInfo **)calloc(num, sizeof(RIL_MtkDataProfileInfo *));
        if (dataProfilePtrs == NULL) {
            RFX_LOG_E(RFX_LOG_TAG, "%s:%d getSlotId: %d, clientId: %d, with token: %d dataProfilePtrs Memory allocation failed", __FUNCTION__, __LINE__,
                request->getSlotId(), request->getClientId(), request->getToken());
            free(dataProfiles);
            dataProfiles = NULL;
            goto error;
        }

        for (i = 0 ; i < num ; i++ ) {
            dataProfilePtrs[i] = &dataProfiles[i];

            status = p->readInt32(&t);
            dataProfiles[i].profileId = (int) t;
            RFX_LOG_D(RFX_LOG_TAG,"%s %d profileId[%d]", __FUNCTION__, __LINE__, dataProfiles[i].profileId);

            dataProfiles[i].apn = strdupReadString(p);
            RFX_LOG_D(RFX_LOG_TAG,"%s %d apn[%s]", __FUNCTION__, __LINE__, dataProfiles[i].apn);
            dataProfiles[i].protocol = strdupReadString(p);
            RFX_LOG_D(RFX_LOG_TAG,"%s %d protocol[%s]", __FUNCTION__, __LINE__, dataProfiles[i].protocol);
            status = p->readInt32(&t);
            dataProfiles[i].authType = (int) t;
            RFX_LOG_D(RFX_LOG_TAG,"%s %d authType[%d]", __FUNCTION__, __LINE__, dataProfiles[i].authType);

            dataProfiles[i].user = strdupReadString(p);
            RFX_LOG_D(RFX_LOG_TAG,"%s %d user[%s]", __FUNCTION__, __LINE__, dataProfiles[i].user);
            dataProfiles[i].password = strdupReadString(p);
            RFX_LOG_D(RFX_LOG_TAG,"%s %d password[%s]", __FUNCTION__, __LINE__, dataProfiles[i].password);

            status = p->readInt32(&t);
            dataProfiles[i].type = (int) t;
            RFX_LOG_D(RFX_LOG_TAG,"%s %d type[%d]", __FUNCTION__, __LINE__, dataProfiles[i].type);

            status = p->readInt32(&t);
            dataProfiles[i].maxConnsTime = (int) t;
            RFX_LOG_D(RFX_LOG_TAG,"%s %d maxConnsTime[%d]", __FUNCTION__, __LINE__, dataProfiles[i].maxConnsTime);
            status = p->readInt32(&t);
            dataProfiles[i].maxConns = (int) t;
            RFX_LOG_D(RFX_LOG_TAG,"%s %d maxConns[%d]", __FUNCTION__, __LINE__, dataProfiles[i].maxConns);
            status = p->readInt32(&t);
            dataProfiles[i].waitTime = (int) t;
            RFX_LOG_D(RFX_LOG_TAG,"%s %d waitTime[%d]", __FUNCTION__, __LINE__, dataProfiles[i].waitTime);

            status = p->readInt32(&t);
            dataProfiles[i].enabled = (int) t;
            RFX_LOG_D(RFX_LOG_TAG,"%s %d enabled[%d]", __FUNCTION__, __LINE__, dataProfiles[i].enabled);

            status = p->readInt32(&t);
            dataProfiles[i].supportedTypesBitmask = (int) t;
            RFX_LOG_D(RFX_LOG_TAG,"%s %d supportedTypesBitmask[%d]", __FUNCTION__, __LINE__, dataProfiles[i].supportedTypesBitmask);

            dataProfiles[i].roamingProtocol = strdupReadString(p);
            RFX_LOG_D(RFX_LOG_TAG,"%s %d roamingProtocol[%s]", __FUNCTION__, __LINE__, dataProfiles[i].roamingProtocol);

            status = p->readInt32(&t);
            dataProfiles[i].bearerBitmask = (int) t;
            RFX_LOG_D(RFX_LOG_TAG,"%s %d bearerBitmask[%d]", __FUNCTION__, __LINE__, dataProfiles[i].bearerBitmask);

            status = p->readInt32(&t);
            dataProfiles[i].mtu = (int) t;
            RFX_LOG_D(RFX_LOG_TAG,"%s %d mtu[%d]", __FUNCTION__, __LINE__, dataProfiles[i].mtu);

            dataProfiles[i].mvnoType = strdupReadString(p);
            RFX_LOG_D(RFX_LOG_TAG,"%s %d mvnoType[%s]", __FUNCTION__, __LINE__, dataProfiles[i].mvnoType);

            dataProfiles[i].mvnoMatchData = strdupReadString(p);
            RFX_LOG_D(RFX_LOG_TAG,"%s %d mvnoMatchData[%s]", __FUNCTION__, __LINE__, dataProfiles[i].mvnoMatchData);

            // read modemCognitive
            status = p->readInt32(&t);
        }


#if 1
        if (dataProfilePtrs == NULL){
            RFX_LOG_D(RFX_LOG_TAG,"NULL dataProfilePtrs ");
            return;
        }

        RFX_LOG_D(RFX_LOG_TAG,"%s %d dump APN info begin num[%d]", __FUNCTION__, __LINE__, num);
        for(int i = 0; i < num; i++){
            RFX_LOG_D(RFX_LOG_TAG,"dump APN info[%d] begin", i);
            if ( dataProfilePtrs[i] == NULL){
                RFX_LOG_D(RFX_LOG_TAG,"NULL dataProfilePtrs[%d]", i);
                continue;
            }

            RFX_LOG_D(RFX_LOG_TAG,"profileId[%d]", dataProfilePtrs[i]->profileId);

            if (dataProfilePtrs[i]->apn)
                RFX_LOG_D(RFX_LOG_TAG,"apn[%s]", dataProfilePtrs[i]->apn);

            if (dataProfilePtrs[i]->protocol)
                RFX_LOG_D(RFX_LOG_TAG,"protocol[%s]", dataProfilePtrs[i]->protocol);

            if (dataProfilePtrs[i]->roamingProtocol)
                RFX_LOG_D(RFX_LOG_TAG,"roamingProtocol[%s]", dataProfilePtrs[i]->roamingProtocol);

            RFX_LOG_D(RFX_LOG_TAG,"authType[%d]", dataProfilePtrs[i]->authType);

            if (dataProfilePtrs[i]->user)
                RFX_LOG_D(RFX_LOG_TAG,"user[%s]", dataProfilePtrs[i]->user);

            if (dataProfilePtrs[i]->password)
                RFX_LOG_D(RFX_LOG_TAG,"password[%s]", dataProfilePtrs[i]->password);

            RFX_LOG_D(RFX_LOG_TAG,"type[%d]", dataProfilePtrs[i]->type);

            RFX_LOG_D(RFX_LOG_TAG,"dump APN info[%d] end", i);
        }
        RFX_LOG_D(RFX_LOG_TAG,"dump APN info end");
#endif


        //get set apn lists
        result = mipc_apn_profile_get_sync(slot_id_to_mipc_sim_id(request->getSlotId()), &apnProfiles);
        if (result != MIPC_API_RESULT_SUCCESS) {
            RFX_LOG_E(RFX_LOG_TAG, "%s:%d getSlotId: %d, clientId: %d, with token: %d get set apn lists fail", __FUNCTION__, __LINE__,
                request->getSlotId(), request->getClientId(), request->getToken());
            goto error;
        }

        RFX_LOG_D(RFX_LOG_TAG, "%s:%d getSlotId: %d, clientId: %d, with token: %d apn_list_count: %d", __FUNCTION__, __LINE__,
            request->getSlotId(), request->getClientId(), request->getToken(), apnProfiles.apn_list_count);

        int apnCount = apnProfiles.apn_list_count;
        //delete setted apn list
        for(i = 0; i++; i < apnCount){
            memset(&apnProfiles, 0, sizeof(apnProfiles));
            result = mipc_apn_profile_del_sync(slot_id_to_mipc_sim_id(request->getSlotId()), &apnProfiles, i+1);
            if (result != MIPC_API_RESULT_SUCCESS) {
                RFX_LOG_E(RFX_LOG_TAG, "%s:%d getSlotId: %d, clientId: %d, with token: %d delete setted apn list fail:", __FUNCTION__, __LINE__,
                    request->getSlotId(), request->getClientId(), request->getToken(), i+1);
                goto error;
            }
        }

        string mccMncKey("");
        char mccmnc[RFX_PROPERTY_VALUE_MAX] = {0};
        mccMncKey.append("vendor.ril.data.gsm_mcc_mnc");
        mccMncKey.append(to_string(request->getSlotId()));
        rfx_property_get(mccMncKey.c_str(), mccmnc, "");
        RFX_LOG_D(RFX_LOG_TAG,"%s %d mccMncKey[%s] mccmnc[%s]", __FUNCTION__, __LINE__, mccMncKey.c_str(), mccmnc);

        //set apn lists to modem
        for (int i = 0 ; i < num ; i++ ) {
            memset(&apnProfiles, 0, sizeof(apnProfiles));
            ret = mapPdpTypeFromStringToEnum(dataProfiles[i].protocol, &apnPdpType);
            RFX_LOG_D(RFX_LOG_TAG,"%s %d apnPdpType[%d]", __FUNCTION__, __LINE__, apnPdpType);
            if (ret != 0){
                RFX_LOG_E(RFX_LOG_TAG, "%s:%d getSlotId: %d, clientId: %d, with token: %d get pdn type error", __FUNCTION__, __LINE__,
                request->getSlotId(), request->getClientId(), request->getToken());
                goto error;
            }
            result = mipc_apn_profile_update_sync(slot_id_to_mipc_sim_id(request->getSlotId()), &apnProfiles, i+1, mccmnc, \
                dataProfiles[i].apn, (uint32_t)dataProfiles[i].supportedTypesBitmask, apnPdpType, MIPC_APN_ENUM_PDP_TYPE_IPV4V6, (mipc_apn_auth_type_enum)dataProfiles[i].authType, \
                dataProfiles[i].user, dataProfiles[i].password, 0xffffffff, MIPC_APN_ENUM_COMPRESSION_ENABLE);
            RFX_LOG_D(RFX_LOG_TAG,"%s %d2 apn[%s] result[%d] apnProfiles.result_code[%d], apnProfiles.apn_list_count[%d]", __FUNCTION__, __LINE__, dataProfiles[i].apn, result, apnProfiles.result_code, apnProfiles.apn_list_count);
            if (result != MIPC_API_RESULT_SUCCESS) {
                RFX_LOG_E(RFX_LOG_TAG, "%s:%d getSlotId: %d, clientId: %d, with token: %d delete setted apn list fail:", __FUNCTION__, __LINE__,
                    request->getSlotId(), request->getClientId(), request->getToken(), i+1);
                goto error;
            }

        }

        //memory free
        freeSetDataProfileData(num, dataProfiles, dataProfilePtrs, 7,
                &RIL_MtkDataProfileInfo::apn, &RIL_MtkDataProfileInfo::protocol,
                &RIL_MtkDataProfileInfo::roamingProtocol, &RIL_MtkDataProfileInfo::user,
                &RIL_MtkDataProfileInfo::password, &RIL_MtkDataProfileInfo::mvnoType,
                &RIL_MtkDataProfileInfo::mvnoMatchData);
    }

    rfx_enqueue_response_message(NULL, request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(), RIL_E_SUCCESS);
    return;


error:
    rfx_enqueue_response_message(NULL, request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(), RIL_E_GENERIC_FAILURE);
    freeSetDataProfileData(num, dataProfiles, dataProfilePtrs, 7,
        &RIL_MtkDataProfileInfo::apn, &RIL_MtkDataProfileInfo::protocol,
        &RIL_MtkDataProfileInfo::roamingProtocol, &RIL_MtkDataProfileInfo::user,
        &RIL_MtkDataProfileInfo::password, &RIL_MtkDataProfileInfo::mvnoType,
        &RIL_MtkDataProfileInfo::mvnoMatchData);
    return;
}

void RpDataController::sendDataCallListResponse(int Aid){
    int rid = m_slot_id;
    MTK_RIL_Data_Call_Response_v11* responsesOfActive = NULL;
    Vector<int> vTransIntfIdList;
    Vector<int>::iterator it;
    Parcel * parcel = NULL;
    int ret = 0;

    const int nPdnInfoSize = getPdnManager()->getPdnTableSize();

    RFX_LOG_V(RFX_LOG_TAG, "[%d][%s] PdnTableSize=%d", rid, __FUNCTION__, nPdnInfoSize);

    // Reserve size of TransIntfId list.
    vTransIntfIdList.reserve(nPdnInfoSize);

    for (int i = 0; i < nPdnInfoSize; i++) {
        if ((getPdnManager()->getPdnActiveStatus(i) == DATA_STATE_ACTIVE) &&
                (getPdnManager()->getTransIntfId(i) != INVALID_TRANS_INTF_ID) &&
                (std::find(vTransIntfIdList.begin(), vTransIntfIdList.end(),
                getPdnManager()->getTransIntfId(i)) == vTransIntfIdList.end())) {
                vTransIntfIdList.push_back(getPdnManager()->getTransIntfId(i));
        }
    }

    RFX_LOG_D(RFX_LOG_TAG, "[%d][%s] active trans-interface number is %zu",
            rid, __FUNCTION__, vTransIntfIdList.size());

    if (vTransIntfIdList.size() > 0) {


        responsesOfActive = (MTK_RIL_Data_Call_Response_v11*)
                calloc(1, vTransIntfIdList.size() * sizeof(MTK_RIL_Data_Call_Response_v11));

        if (responsesOfActive == NULL) {
            RFX_LOG_E(RFX_LOG_TAG, "[%d][%s] fail to allocate responsesOfActive!",
                    rid, __FUNCTION__);
            RFX_ASSERT(false);
        }

        initDataCallResponse(responsesOfActive, vTransIntfIdList.size());
        int index = 0;
        for (it = vTransIntfIdList.begin(); it != vTransIntfIdList.end(); it++) {
            int transIntfId = *it;
            createDataResponse(transIntfId, IPV4V6, &responsesOfActive[index]);

            if (Aid != INVALID_AID &&
                    transIntfId == getPdnManager()->getTransIntfId(Aid)) {
                responsesOfActive[index].active = DATA_STATE_INACTIVE;
                responsesOfActive[index].status = getPdnManager()->getDeactReason(Aid);
            }

            ++index;
        }
        RFX_LOG_D(RFX_LOG_TAG, "[%d][%s] %s", rid, __FUNCTION__,
                responsesToString(responsesOfActive, vTransIntfIdList.size()).string());


        parcel = new Parcel();
        if (parcel == NULL){
            RFX_LOG_E(RFX_LOG_TAG, "%s:%d  slotid[%d] new parcel fail", __FUNCTION__ ,  __LINE__, \
                    getSlotId());
            goto error;
        }
        ret = responseDataCallListV11(*parcel, responsesOfActive, sizeof(MTK_RIL_Data_Call_Response_v11)*vTransIntfIdList.size());
        if (ret != 0){
            RFX_LOG_E(RFX_LOG_TAG, "%s:%d  slotid[%d] ret[%d]", __FUNCTION__ ,  __LINE__, \
                    getSlotId(), ret);
            goto error;
        }


}

    goto finish;

error:

if (parcel != NULL){
    delete(parcel);
    parcel = NULL;
}

RFX_LOG_E(RFX_LOG_TAG, "%s:%d notify failure", __FUNCTION__ ,  __LINE__);

finish:

RFX_LOG_D(RFX_LOG_TAG, "%s:%d notify response", __FUNCTION__ ,  __LINE__);
    if ((parcel == NULL)  || (vTransIntfIdList.size() <= 0))
        rfx_enqueue_urc_message(RIL_UNSOL_DATA_CALL_LIST_CHANGED,NULL,(RIL_SOCKET_ID)getSlotId(),RIL_E_SUCCESS);
    else if(parcel != NULL)
        rfx_enqueue_urc_message(RIL_UNSOL_DATA_CALL_LIST_CHANGED,parcel,(RIL_SOCKET_ID)getSlotId(),RIL_E_SUCCESS);
    else
        rfx_enqueue_urc_message(RIL_UNSOL_DATA_CALL_LIST_CHANGED,parcel,(RIL_SOCKET_ID)getSlotId(),RIL_E_GENERIC_FAILURE);

if (responsesOfActive != NULL) {
    int size = vTransIntfIdList.size();
    for (int i = 0; i < size; i++) {
        freeDataResponse(&responsesOfActive[i]);
    }
    FREEIF(responsesOfActive);
    RFX_LOG_D(RFX_LOG_TAG, "[%d][%s] free responsesOfActive", rid, __FUNCTION__);

}
}

void RpDataController::requestOrSendDataCallList(const sp<RfxMessage>& request){
    int rid = m_slot_id;
    Parcel * parcel = NULL;
    MTK_RIL_Data_Call_Response_v11* responsesOfActive = NULL;
    Vector<int> vTransIntfIdList;
    Vector<int>::iterator it;
    int ret = 0;
    const int nPdnInfoSize = getPdnManager()->getPdnTableSize();

    RFX_LOG_V(RFX_LOG_TAG, "[%d][%s] PdnTableSize=%d", rid, __FUNCTION__, nPdnInfoSize);

    // Reserve size of TransIntfId list.
    vTransIntfIdList.reserve(nPdnInfoSize);

    if (request == NULL){
        RFX_LOG_E(RFX_LOG_TAG, "%s:%d  slotid[%d] clientid[%d] token[%d] NULL Parameter", __FUNCTION__ ,  __LINE__, \
                request->getSlotId(), request->getClientId(), request->getToken());
        goto error;
    }

    m_mutex[rid].lock();
    for (int i = 0; i < nPdnInfoSize; i++) {
        if ((getPdnManager()->getPdnActiveStatus(i) == DATA_STATE_ACTIVE) &&
                (getPdnManager()->getTransIntfId(i) != INVALID_TRANS_INTF_ID) &&
                (std::find(vTransIntfIdList.begin(), vTransIntfIdList.end(),
                getPdnManager()->getTransIntfId(i)) == vTransIntfIdList.end())) {
                vTransIntfIdList.push_back(getPdnManager()->getTransIntfId(i));
        }
    }
    m_mutex[rid].unlock();

    if (vTransIntfIdList.size() > 0) {
        RFX_LOG_D(RFX_LOG_TAG, "[%d][%s] active trans-interface number is %zu",
                rid, __FUNCTION__, vTransIntfIdList.size());

        responsesOfActive = (MTK_RIL_Data_Call_Response_v11*)
                calloc(1, vTransIntfIdList.size() * sizeof(MTK_RIL_Data_Call_Response_v11));

        if (responsesOfActive == NULL) {
            RFX_LOG_E(RFX_LOG_TAG, "[%d][%s] fail to allocate responsesOfActive!",
                    rid, __FUNCTION__);
            RFX_ASSERT(false);
        }

        initDataCallResponse(responsesOfActive, vTransIntfIdList.size());
        int index = 0;
        for (it = vTransIntfIdList.begin(); it != vTransIntfIdList.end(); it++) {
            int transIntfId = *it;
            createDataResponse(transIntfId, IPV4V6, &responsesOfActive[index]);
            ++index;
        }
        RFX_LOG_I(RFX_LOG_TAG, "[%d][%s] %s", rid, __FUNCTION__,
                responsesToString(responsesOfActive, vTransIntfIdList.size()).string());
    }else {
        RFX_LOG_D(RFX_LOG_TAG, "[%d][%s] no active response", rid, __FUNCTION__);
        goto finish;
    }

    parcel = new Parcel();
    if (parcel == NULL){
        RFX_LOG_E(RFX_LOG_TAG, "%s:%d  slotid[%d] clientid[%d] token[%d]new parcel fail", __FUNCTION__ ,  __LINE__, \
                request->getSlotId(), request->getClientId(), request->getToken());
        goto error;
    }
    ret = responseDataCallListV11(*parcel, responsesOfActive, sizeof(MTK_RIL_Data_Call_Response_v11)*vTransIntfIdList.size());
    if (ret != 0){
        RFX_LOG_E(RFX_LOG_TAG, "%s:%d  slotid[%d] clientid[%d] token[%d]responseDataCallListV11 fail ret[%d]", __FUNCTION__ ,  __LINE__, \
                request->getSlotId(), request->getClientId(), request->getToken(), ret);
        goto error;
    }

    goto finish;

error:
    if (parcel != NULL){
        delete(parcel);
        parcel = NULL;
    }

    RFX_LOG_E(RFX_LOG_TAG, "%s:%d notify failure", __FUNCTION__ ,  __LINE__);
finish:
    RFX_LOG_D(RFX_LOG_TAG, "%s:%d notify response", __FUNCTION__ ,  __LINE__);
    if ((parcel == NULL)  && (vTransIntfIdList.size() <= 0))
        rfx_enqueue_response_message(NULL, request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(), RIL_E_SUCCESS);
    else if(parcel != NULL)
        rfx_enqueue_response_message(parcel, request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(), RIL_E_SUCCESS);
    else
        rfx_enqueue_response_message(NULL, request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(), RIL_E_GENERIC_FAILURE);

    if (responsesOfActive != NULL) {
        int size = vTransIntfIdList.size();
        for (int i = 0; i < size; i++) {
            freeDataResponse(&responsesOfActive[i]);
        }
        FREEIF(responsesOfActive);
        RFX_LOG_D(RFX_LOG_TAG, "[%d][%s] free responsesOfActive", rid, __FUNCTION__);
    }

    RFX_LOG_D(RFX_LOG_TAG, "[%s] finish", __FUNCTION__);
    return;

}


void RpDataController::handleDataCallListRequest(const sp<RfxMessage>& request) {
    requestOrSendDataCallList(request);
}


void RpDataController::handleSetInitialAttachApnRequest(const sp<RfxMessage>& request) {
    RIL_InitialAttachApn_v15 pf;
    mipc_apn_ia_struct_v apnIa;
    int32_t  t = 0;
    status_t status;
    int ret;
    mipc_api_result_enum result = MIPC_API_RESULT_SUCCESS;
    mipc_apn_pdp_type_enum apnPdpType = MIPC_APN_ENUM_PDP_TYPE_DEFAULT;
    mipc_apn_pdp_type_enum roamingype = MIPC_APN_ENUM_PDP_TYPE_DEFAULT;

    memset(&pf, 0, sizeof(pf));
    memset(&apnIa, 0, sizeof(apnIa));

    RFX_LOG_D(RFX_LOG_TAG, "%s getSlotId: %d, clientId: %d, with token: %d", __FUNCTION__,
            request->getSlotId(), request->getClientId(), request->getToken());

    Parcel *p = request->getParcel();
    if(p == NULL) {
        RFX_LOG_D(RFX_LOG_TAG, "%s getSlotId: %d, clientId: %d, with token: %d", __FUNCTION__,
            request->getSlotId(), request->getClientId(), request->getToken());
        goto error;
    }

    pf.apn = strdupReadString(p);
    pf.protocol = strdupReadString(p);

    status = p->readInt32(&t);
    pf.authtype = (int) t;

    pf.username = strdupReadString(p);
    pf.password = strdupReadString(p);
    RFX_LOG_D(RFX_LOG_TAG, "%s getSlotId: %d apn=%s, protocol=%s, authtype=%d, username=%s, password=%s",
            __FUNCTION__, request->getSlotId(), pf.apn, pf.protocol, pf.authtype, pf.username, pf.password);
    ret = mapPdpTypeFromStringToEnum(pf.protocol, &apnPdpType);
    if (ret != 0){
        RFX_LOG_E(RFX_LOG_TAG, "%s getSlotId: %d, clientId: %d, with token: %d get pdn type error", __FUNCTION__,
            request->getSlotId(), request->getClientId(), request->getToken());
        goto error;
    }

   result = mipc_apn_ia_set_sync(slot_id_to_mipc_sim_id(request->getSlotId()), &apnIa, pf.apn, apnPdpType, \
        MIPC_APN_ENUM_PDP_TYPE_IPV4V6, (mipc_apn_auth_type_enum)pf.authtype, pf.username, pf.password, 0xffffffff, \
        MIPC_APN_ENUM_COMPRESSION_ENABLE);

   RFX_LOG_E(RFX_LOG_TAG, "%s getSlotId: %d, result_code: %d", __FUNCTION__,
       request->getSlotId(), apnIa.result_code);

   if (result == MIPC_API_RESULT_SUCCESS){
        rfx_enqueue_response_message(NULL, request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(), RIL_E_SUCCESS);
        dumpApnIaInfo(&apnIa);
    }else{
        RFX_LOG_E(RFX_LOG_TAG, "%s getSlotId: %d, clientId: %d, with token: %d set ia type error", __FUNCTION__,
            request->getSlotId(), request->getClientId(), request->getToken());
        goto error;
    }

    FREEIF(pf.apn);
    FREEIF(pf.protocol);
    FREEIF(pf.username);
    FREEIF(pf.password);

    return;

error:
    rfx_enqueue_response_message(NULL, request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(), RIL_E_GENERIC_FAILURE);
    FREEIF(pf.apn);
    FREEIF(pf.protocol);
    FREEIF(pf.username);
    FREEIF(pf.password);
    return;
}


void RpDataController::handleSetDataAllowRequest(const sp<RfxMessage>& request) {
    int countInts = 0;
    status_t status = 0;
    int allowed = -1;
    mipc_api_result_enum result = MIPC_API_RESULT_SUCCESS;

    RFX_LOG_D(RFX_LOG_TAG, "%s getSlotId: %d, clientId: %d, with token: %d", __FUNCTION__,
            request->getSlotId(), request->getClientId(), request->getToken());

    Parcel *p = request->getParcel();
    if(p == NULL) {
        RFX_LOG_D(RFX_LOG_TAG, "%s getSlotId: %d, clientId: %d, with token: %d", __FUNCTION__,
            request->getSlotId(), request->getClientId(), request->getToken());
        goto error;
    }

    status = p->readInt32(&countInts);

    if (countInts == 0) {
        RFX_LOG_D(RFX_LOG_TAG, "%s %d getSlotId: %d, clientId: %d, with token: %d:error parameter", __FUNCTION__, __LINE__,
            request->getSlotId(), request->getClientId(), request->getToken());
        goto error;
    }
    else {
        status = p->readInt32(&allowed);
    }

    RFX_LOG_D(RFX_LOG_TAG, "%s %d getSlotId: %d, clientId: %d, with token: %d allowed[%d]", __FUNCTION__, __LINE__,
            request->getSlotId(), request->getClientId(), request->getToken(), allowed);

    if (allowed == 1) {
        result = mipc_data_set_data_allow_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_data_set_data_allow_cb, (void *)request->getRilToken());
    } else {
        rfx_enqueue_response_message(NULL, request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(), RIL_E_SUCCESS);
    }
    RFX_LOG_D(RFX_LOG_TAG, "%s %d result %d", __FUNCTION__, __LINE__, result);
    return;
    //MIPC message need to implement

error:
    RFX_LOG_E(RFX_LOG_TAG, "%s:%d notify failure", __FUNCTION__ ,  __LINE__);
    rfx_enqueue_response_message(NULL, request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(), RIL_E_GENERIC_FAILURE);
}

RIL_DataCallFailCause RpDataController::convertFailCauseToRilStandard(int cause) {
    int rid = m_slot_id;

    if (cause > MIPC_RESULT_PDN_EXT_NETWORK_ERROR_BEGIN /*0x140000*/ &&
            cause < MIPC_RESULT_PDN_EXT_NETWORK_ERROR_END) {
        cause -= MIPC_RESULT_PDN_EXT_NETWORK_ERROR_BEGIN;
        if (cause > SM_CAUSE_BASE && cause < SM_CAUSE_END) {
            cause -= SM_CAUSE_BASE;
        } else if (cause > ESM_CAUSE_BASE && cause < ESM_CAUSE_END) {
            RFX_LOG_E(RFX_LOG_TAG, "[%d][%s] ESM CAUSE: %X",
                    rid, __FUNCTION__, cause);
            cause -= ESM_CAUSE_BASE;
        } else if (cause > PAM_CAUSE_BASE && cause < PAM_CAUSE_END) {
            RFX_LOG_E(RFX_LOG_TAG, "[%d][%s] PAM CAUSE: %X",
                    rid, __FUNCTION__, cause);
            cause -= PAM_CAUSE_BASE;
        } else if (cause > FIVESMGSM_CAUSE_BASE && cause < FIVESMGSM_CAUSE_END) {
            RFX_LOG_E(RFX_LOG_TAG, "[%d][%s] 5GSM CAUSE: %X",
                    rid, __FUNCTION__, cause);
            cause -= FIVESMGSM_CAUSE_BASE;
        } else if (cause > CME_CAUSE_BASE_V14 && cause < CME_CAUSE_END_V14) {
            RFX_LOG_E(RFX_LOG_TAG, "[%d][%s] CME CAUSE: %X",
                    rid, __FUNCTION__, cause);
            if (cause == 149) {//CME_PDP_AUTHENTICATION_FAILED = 149
                return PDP_FAIL_USER_AUTHENTICATION;
            } else {
                cause -= CME_CAUSE_BASE_V14;
            }
        }

        switch (cause) {
            case 0: return PDP_FAIL_NONE;
            case 0x08: return PDP_FAIL_OPERATOR_BARRED;
            case 0x0E: return PDP_FAIL_NAS_SIGNALLING;
            case 0x18: return PDP_FAIL_MBMS_CAPABILITIES_INSUFFICIENT;
            case 0x19: return PDP_FAIL_LLC_SNDCP;
            case 0x1A: return PDP_FAIL_INSUFFICIENT_RESOURCES;
            case 0x1B: return PDP_FAIL_MISSING_UKNOWN_APN;
            case 0x1C: return PDP_FAIL_UNKNOWN_PDP_ADDRESS_TYPE;
            case 0x1D: return PDP_FAIL_USER_AUTHENTICATION;
            case 0x1E: return PDP_FAIL_ACTIVATION_REJECT_GGSN;
            case 0x1F: return PDP_FAIL_ACTIVATION_REJECT_UNSPECIFIED;
            case 0x20: return PDP_FAIL_SERVICE_OPTION_NOT_SUPPORTED;
            case 0x21: return PDP_FAIL_SERVICE_OPTION_NOT_SUBSCRIBED;
            case 0x22: return PDP_FAIL_SERVICE_OPTION_OUT_OF_ORDER;
            case 0x23: return PDP_FAIL_NSAPI_IN_USE;
            case 0x24: return PDP_FAIL_REGULAR_DEACTIVATION;
            case 0x25: return PDP_FAIL_QOS_NOT_ACCEPTED;
            case 0x26: return PDP_FAIL_NETWORK_FAILURE;
            case 0x27: return PDP_FAIL_UMTS_REACTIVATION_REQ;
            case 0x28: return PDP_FAIL_FEATURE_NOT_SUPP;
            case 0x29: return PDP_FAIL_TFT_SEMANTIC_ERROR;
            case 0x2A: return PDP_FAIL_TFT_SYTAX_ERROR;
            case 0x2B: return PDP_FAIL_UNKNOWN_PDP_CONTEXT;
            case 0x2C: return PDP_FAIL_FILTER_SEMANTIC_ERROR;
            case 0x2D: return PDP_FAIL_FILTER_SYTAX_ERROR;
            case 0x2E: return PDP_FAIL_PDP_WITHOUT_ACTIVE_TFT;
            case 0x2F: return PDP_FAIL_MULTICAST_GROUP_MEMBERSHIP_TIMEOUT;
            case 0x30: return PDP_FAIL_BCM_VIOLATION;
            case 0x31: return PDP_FAIL_LAST_PDN_DISC_NOT_ALLOWED;
            case 0x32: return PDP_FAIL_ONLY_IPV4_ALLOWED;
            case 0x33: return PDP_FAIL_ONLY_IPV6_ALLOWED;
            case 0x34: return PDP_FAIL_ONLY_SINGLE_BEARER_ALLOWED;
            case 0x35: return PDP_FAIL_ESM_INFO_NOT_RECEIVED;
            case 0x36: return PDP_FAIL_PDN_CONN_DOES_NOT_EXIST;
            case 0x37: return PDP_FAIL_MULTI_CONN_TO_SAME_PDN_NOT_ALLOWED;
            case 0x38: return PDP_FAIL_COLLISION_WITH_NW_INITIATED_REQUEST;
            case 0x3B: return PDP_FAIL_ESM_UNSUPPORTED_QCI_VALUE;
            case 0x3C: return PDP_FAIL_BEARER_HANDLING_NOT_SUPPORT;
            case 0x41: return PDP_FAIL_MAX_ACTIVE_PDP_CONTEXT_REACHED;
            case 0x42: return PDP_FAIL_UNSUPPORTED_APN_IN_CURRENT_PLMN;
            case 0x51: return PDP_FAIL_INVALID_TRANSACTION_ID;
            case 0x5F: return PDP_FAIL_MESSAGE_INCORRECT_SEMANTIC;
            case 0x60: return PDP_FAIL_INVALID_MANDATORY_INFO;
            case 0x61: return PDP_FAIL_MESSAGE_TYPE_UNSUPPORTED;
            case 0x62: return PDP_FAIL_MSG_TYPE_NONCOMPATIBLE_STATE;
            case 0x63: return PDP_FAIL_UNKNOWN_INFO_ELEMENT;
            case 0x64: return PDP_FAIL_CONDITIONAL_IE_ERROR;
            case 0x65: return PDP_FAIL_MSG_AND_PROTOCOL_STATE_UNCOMPATIBLE;
            case 0x6F: return PDP_FAIL_PROTOCOL_ERRORS;
            case 0x70: return PDP_FAIL_APN_TYPE_CONFLICT;
            case 0x71: return PDP_FAIL_INVALID_PCSCF_ADDR;
            case 0x72: return PDP_FAIL_INTERNAL_CALL_PREEMPT_BY_HIGH_PRIO_APN;
            case 0x73: return PDP_FAIL_EMM_ACCESS_BARRED;
            case 0x74: return PDP_FAIL_EMERGENCY_IFACE_ONLY;
            case 0x75: return PDP_FAIL_IFACE_MISMATCH;
            case 0x76: return PDP_FAIL_COMPANION_IFACE_IN_USE;
            case 0x77: return PDP_FAIL_IP_ADDRESS_MISMATCH;
            case 0x78: return PDP_FAIL_IFACE_AND_POL_FAMILY_MISMATCH;
            case 0x79: return PDP_FAIL_EMM_ACCESS_BARRED_INFINITE_RETRY;
            case 0x7A: return PDP_FAIL_AUTH_FAILURE_ON_EMERGENCY_CALL;
            case 0x0E0F: return PDP_FAIL_LOCAL_REJECT_ACT_REQ_DUE_TO_REACH_RETRY_COUNTER;
            case 0x0F47: return PDP_FAIL_TCM_ESM_TIMER_TIMEOUT;
            case 0x1402: return PDP_FAIL_PAM_ATT_PDN_ACCESS_REJECT_IMS_PDN_BLOCK_TEMP;
            case 0x1671: return PDP_FAIL_DATA_NOT_ALLOW;
            case -1: return PDP_FAIL_VOICE_REGISTRATION_FAIL;
            case -2: return PDP_FAIL_DATA_REGISTRATION_FAIL;
            case -3: return PDP_FAIL_SIGNAL_LOST;
            case -4: return PDP_FAIL_PREF_RADIO_TECH_CHANGED;
            case -5: return PDP_FAIL_RADIO_POWER_OFF;
            case -6: return PDP_FAIL_TETHERED_CALL_ACTIVE;
            default: return PDP_FAIL_ERROR_UNSPECIFIED;
        }
    } else {
        return PDP_FAIL_ERROR_UNSPECIFIED;
    }
}

void RpDataController::handleGetLastFailCauseRequest(const sp<RfxMessage>& request) {

    Parcel * parcel = NULL;
    int lastFailCause = 0;
    RFX_LOG_D(RFX_LOG_TAG, "[%d][%s][%d] m_nGprsFailureCause[%d]", m_slot_id, __FUNCTION__, __LINE__, m_nGprsFailureCause);

    parcel = new Parcel();

    if (parcel == NULL){
        RFX_LOG_E(RFX_LOG_TAG, "%s:%d  slotid[%d] clientid[%d] token[%d]new parcel fail", __FUNCTION__ ,  __LINE__, \
                request->getSlotId(), request->getClientId(), request->getToken());
        goto error;
    }
    lastFailCause = getGprsFailureCause();
    parcel->writeInt32(1);
    parcel->writeInt32(lastFailCause);
    RFX_LOG_D(RFX_LOG_TAG, "[%d][%s][%d] lastFailCause[%d]", m_slot_id, __FUNCTION__, __LINE__, lastFailCause);
    rfx_enqueue_response_message(parcel, request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(), RIL_E_SUCCESS);
    return;
error:
    if (parcel != NULL){
        delete(parcel);
        parcel = NULL;
    }
    RFX_LOG_E(RFX_LOG_TAG, "%s:%d notify failure", __FUNCTION__ ,  __LINE__);
    rfx_enqueue_response_message(NULL, request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(), RIL_E_GENERIC_FAILURE);
}



String8 RpDataController::responsesToString(MTK_RIL_Data_Call_Response_v11* responses, int num) {
    int rid = m_slot_id;
    String8 cmd("");

    if (num == 0 || responses == NULL) {
        RFX_LOG_E(RFX_LOG_TAG, "[%d][%s] the number of data call responses is %d "
                "(if number is not 0, that means data call responses is null)",
                rid, __FUNCTION__, num);
        return String8::format("");
    }

    cmd.append(String8::format("DataCallResponse <-"));

    for (int i = 0; i < num; i++) {
        cmd.append(String8::format(" {status=%d, suggestedRetryTime=%d, transIntfId=%d, active=%d,"
                " type=%s, ifname=%s, addresses=%s, dnses=%s, gateways=%s, pcscf=%s, mtu=%d, rat=%d}",
                (&responses[i])->status,
                (&responses[i])->suggestedRetryTime,
                (&responses[i])->cid,
                (&responses[i])->active,
                (&responses[i])->type,
                (&responses[i])->ifname,
                (&responses[i])->addresses,
                (&responses[i])->dnses,
                (&responses[i])->gateways,
                (&responses[i])->pcscf,
                (&responses[i])->mtu,
                (&responses[i])->rat));
    }
    return cmd;
}

int RpDataController::calculateTransIntfId(int aid, int interfaceId) {
    if (0 <= aid) {
        return aid*100 + interfaceId;
    }
    return INVALID_INTERFACE_ID;
}

int RpDataController::getInterfaceId(int transIntfId) {
    if (0 <= transIntfId) {
        return transIntfId % TRANSACTION_ID_OFFSET;
    }
    return INVALID_INTERFACE_ID;
}

void RpDataController::createDataResponse(int transIntfId, int protocol,
        MTK_RIL_Data_Call_Response_v11* response) {
    int rid = m_slot_id;
    char addressV4[MAX_IPV4_ADDRESS_LENGTH] = {0};
    char addressV6[MAX_IPV6_ADDRESS_LENGTH] = {0};
    char dnsV4[MAX_NUM_DNS_ADDRESS_NUMBER][MAX_IPV4_ADDRESS_LENGTH] = {{0}};
    char dnsV6[MAX_NUM_DNS_ADDRESS_NUMBER][MAX_IPV6_ADDRESS_LENGTH] = {{0}};
    char pcscf[MAX_PCSCF_NUMBER][MAX_IPV6_ADDRESS_LENGTH] = {{0}};
    int v4DnsLength = 0;
    int v6DnsLength = 0;
    int nDnsesLen = 0;
    int pcscfLength = 0;
    PdnInfo *pdnInfo = NULL;
    PdnInfo pdn_info;
    memset(&pdn_info, 0, sizeof(pdn_info));
    RmcDcPdnManager * pdnManager = NULL;


    const int nPdnInfoSize = getPdnManager()->getPdnTableSize();

    RFX_LOG_D(RFX_LOG_TAG, "[%d][%s][%d]", m_slot_id, __FUNCTION__, __LINE__);

    if (response == NULL) {
        RFX_LOG_E(RFX_LOG_TAG, "[%d][%s] response is null, return!",
                rid, __FUNCTION__);
        return;
    }

    for (int i = 0; i < nPdnInfoSize; i++) {
        pdn_info = getPdnManager() ->getPdnInfo(i);
        int interfaceId = getInterfaceId(transIntfId);
        if ((interfaceId != INVALID_INTERFACE_ID) &&
                (pdn_info.transIntfId == transIntfId) &&
                !pdn_info.isDedicateBearer &&
                (pdn_info.active == DATA_STATE_ACTIVE)) {
            RFX_LOG_D(RFX_LOG_TAG, "[%d][%s] copy pdn_info[%d] to data response for transIntfId=%d",
                    rid, __FUNCTION__, i, transIntfId);

            pdnInfo = &pdn_info;
            // There is aid bind to the interface of the response, so set to active
            response->active = pdnInfo->active;
            //asprintf(&response->ifname, "%s%d",
            //        NetAgentService::getCcmniInterfaceName(rid), interfaceId);

            asprintf(&response->ifname, "%s%d",
                    "ccmni", interfaceId);

            if (strlen(pdnInfo->addressV4) > 0 && (protocol == IPV4 || protocol == IPV4V6))
                strncpy(addressV4, pdnInfo->addressV4, MAX_IPV4_ADDRESS_LENGTH - 1);
            if (strlen(pdnInfo->addressV6) > 0 && (protocol == IPV6 || protocol == IPV4V6))
                strncpy(addressV6, pdnInfo->addressV6, MAX_IPV6_ADDRESS_LENGTH - 1);

            RFX_LOG_D(RFX_LOG_TAG, "[%d][%s][%d] protocol[%d] addressV4[%s] addressV6[%s]", m_slot_id, \
                    __FUNCTION__, __LINE__, protocol, addressV4, addressV6);


            for (int j = 0; j < MAX_NUM_DNS_ADDRESS_NUMBER; j++) {
                // If there is no IP address but with corresponding
                // DNS server, it may result in TCP/IP break down due
                // to DNS server algorithm from N, so need check if
                // have IP address when report DNS
                if ((strlen(pdnInfo->dnsV4[j]) > 0) && (strlen(addressV4) > 0)) {
                    strncpy(dnsV4[j], pdnInfo->dnsV4[j], MAX_IPV4_ADDRESS_LENGTH - 1);
                    v4DnsLength += strlen(pdnInfo->dnsV4[j]);
                    if (j != 0 || v6DnsLength != 0)
                        ++v4DnsLength;  // add one space
                }
                if ((strlen(pdnInfo->dnsV6[j]) > 0) && (strlen(addressV6) > 0)) {
                    strncpy(dnsV6[j], pdnInfo->dnsV6[j], MAX_IPV6_ADDRESS_LENGTH - 1);
                    v6DnsLength += strlen(pdnInfo->dnsV6[j]);
                    if (j != 0 || v4DnsLength != 0)
                        ++v6DnsLength;  // add one space
                }
            }

            for (int j = 0; j < MAX_PCSCF_NUMBER; j++) {
                if (strlen(pdnInfo->pcscf[j]) > 0) {
                    strncpy(pcscf[j], pdnInfo->pcscf[j], MAX_IPV6_ADDRESS_LENGTH - 1);
                    pcscfLength += strlen(pdnInfo->pcscf[j]);
                    if (j != 0)
                        ++pcscfLength;  // add one space
                }
            }

            response->mtu = pdnInfo->mtu;
            response->rat = pdnInfo->rat;
        } else if (pdn_info.transIntfId == transIntfId) {
            RFX_LOG_E(RFX_LOG_TAG, "[%d][%s] not need to create pdn_info[%d] for transIntfId=%d"
                    " because pdn_info{isDedicateBearer=%d, active=%d} is not satisfied",
                    rid, __FUNCTION__, i, transIntfId, pdn_info.isDedicateBearer,
                    pdn_info.active);
        }
    }

    response->status = PDP_FAIL_NONE;
    response->cid = transIntfId;

    int addressV4Length = strlen(addressV4);
    int addressV6Length = strlen(addressV6);

    if (addressV4Length > 0 && addressV6Length > 0) {
        asprintf(&response->type, SETUP_DATA_PROTOCOL_IPV4V6);
        asprintf(&response->addresses, "%s %s", addressV4, addressV6);
        if (isIpv6Global(addressV6)) {
            asprintf(&response->gateways, "%s %s", addressV4, UNSPECIFIED_IPV6_GATEWAY);
        } else {
            asprintf(&response->gateways, "%s", response->addresses);
        }
        RFX_LOG_D(RFX_LOG_TAG, "[%d][%s][%d] response->addresses[%s] response->gateways[%s]", m_slot_id, \
                __FUNCTION__, __LINE__,response->addresses, response->gateways);

    } else if (addressV6Length > 0) {
        asprintf(&response->type, SETUP_DATA_PROTOCOL_IPV6);
        asprintf(&response->addresses, "%s", addressV6);
        if (isIpv6Global(addressV6)) {
            asprintf(&response->gateways, "%s", UNSPECIFIED_IPV6_GATEWAY);
        } else {
            asprintf(&response->gateways, "%s", response->addresses);
        }
    } else {
        asprintf(&response->type, SETUP_DATA_PROTOCOL_IP);
        asprintf(&response->addresses, "%s", addressV4);
        asprintf(&response->gateways, "%s", response->addresses);
    }

    nDnsesLen = v4DnsLength + v6DnsLength;
    response->dnses = (char*)calloc(1, (nDnsesLen * sizeof(char)) + 1);
    RFX_ASSERT(response->dnses != NULL);
    memset(response->dnses, 0, (nDnsesLen * sizeof(char)) + 1);

    if (RmcDcUtility::isPreferDnsV6First(rid)) {
        for (int i = 0; i < MAX_NUM_DNS_ADDRESS_NUMBER; i++) {
            if (v6DnsLength > 0 && strlen(dnsV6[i]) > 0) {
                int currentLength = strlen(response->dnses);
                if (currentLength > 0) {
                    strncat(response->dnses + currentLength, " ", nDnsesLen - currentLength);
                }
                strncat(response->dnses + strlen(response->dnses), dnsV6[i],
                        nDnsesLen - strlen(response->dnses));
            }
        }
        for (int i = 0; i < MAX_NUM_DNS_ADDRESS_NUMBER; i++) {
            if (v4DnsLength > 0 && strlen(dnsV4[i]) > 0) {
                int currentLength = strlen(response->dnses);
                if (currentLength > 0) {
                    strncat(response->dnses + currentLength, " ", nDnsesLen - currentLength);
                }
                strncat(response->dnses + strlen(response->dnses), dnsV4[i],
                        nDnsesLen - strlen(response->dnses));
            }
        }
    } else {
        for (int i = 0; i < MAX_NUM_DNS_ADDRESS_NUMBER; i++) {
            if (v4DnsLength > 0 && strlen(dnsV4[i]) > 0) {
                int currentLength = strlen(response->dnses);
                if (currentLength > 0) {
                    strncat(response->dnses + currentLength, " ", nDnsesLen - currentLength);
                }
                strncat(response->dnses + strlen(response->dnses), dnsV4[i],
                        nDnsesLen - strlen(response->dnses));
            }
        }
        for (int i = 0; i < MAX_NUM_DNS_ADDRESS_NUMBER; i++) {
            if (v6DnsLength > 0 && strlen(dnsV6[i]) > 0) {
                int currentLength = strlen(response->dnses);
                if (currentLength > 0) {
                    strncat(response->dnses + currentLength, " ", nDnsesLen - currentLength);
                }
                strncat(response->dnses + strlen(response->dnses), dnsV6[i],
                        nDnsesLen - strlen(response->dnses));
            }
        }
    }

    response->pcscf= (char*)calloc(1, pcscfLength * sizeof(char) + 1);
    RFX_ASSERT(response->pcscf != NULL);
    memset(response->pcscf, 0, pcscfLength * sizeof(char) + 1);
    for (int i = 0; i < MAX_PCSCF_NUMBER; i++) {
        if (pcscfLength > 0 && strlen(pcscf[i]) > 0) {
            int currentLength = strlen(response->pcscf);
            if (currentLength > 0) {
                strncat(response->pcscf + currentLength, " ", pcscfLength - currentLength);
                currentLength = strlen(response->pcscf);
            }
            strncat(response->pcscf + currentLength, pcscf[i], pcscfLength - currentLength);
        }
    }
}



void RpDataController::handleSetupDataRequest(const sp<RfxMessage>& request) {
    RFX_LOG_D(RFX_LOG_TAG, "%s:%d  slotid[%d] clientid[%d] token[%d]", __FUNCTION__ ,  __LINE__, \
                request->getSlotId(), request->getClientId(), request->getToken());
    char *apn_ptr = NULL;
    char *protocol = NULL;
    int32_t  countStrings = 0;
    status_t status = 0;
    MTK_RIL_Data_Call_Response_v11* response = NULL;
    int num = 1;
    int ret = 0;
    mipc_apn_type_enum apnType = MIPC_APN_ENUM_TYPE_DEFAULT;
    mipc_apn_pdp_type_enum pdpType = MIPC_APN_ENUM_PDP_TYPE_DEFAULT;
    mipc_apn_pdp_type_enum roamingType = MIPC_APN_ENUM_PDP_TYPE_DEFAULT;
    mipc_apn_auth_type_enum authType = MIPC_APN_ENUM_AUTH_TYPE_NONE;
    char *userid_ptr = NULL;
    char *password_ptr = NULL;
    mipc_data_fallback_type_enum ipv4v6_fallback = MIPC_DATA_ENUM_FALLBACK_TYPE_DISABLE;
    uint32_t bearer_bitmask = 0;
    char **pStrings = NULL;
    mipc_data_call_act_struct dataCallAct;
    mipc_api_result_enum result = MIPC_API_RESULT_SUCCESS;
    Parcel * parcel = NULL;
    Parcel *p = NULL;
    Act_Data_call_back_priv* data_call_cb = NULL;


    memset(&dataCallAct, 0, sizeof(dataCallAct));

    if (request == NULL){
        RFX_LOG_E(RFX_LOG_TAG, "%s:%d  slotid[%d] clientid[%d] token[%d] NULL Parameter", __FUNCTION__ ,  __LINE__, \
                request->getSlotId(), request->getClientId(), request->getToken());
        goto error;
    }

    //register callback for ipv6 address update
    if (isIpv6AddressUpdateCbReg == false){
        NetAgentService *pNetAgentService = NetAgentService::getInstance();
        if (pNetAgentService){
            pNetAgentService->registerCbKernelAddressUpdated(onKernelAddressUpdated, m_slot_id);
            isIpv6AddressUpdateCbReg = true;
        }
        RFX_LOG_D(RFX_LOG_TAG, "%s:%d  pNetAgentService[%d] = %p", __FUNCTION__ ,  __LINE__, \
                        getSlotId(), pNetAgentService);
    }




    // Initialize data call response.
    response = (MTK_RIL_Data_Call_Response_v11*)calloc(1, sizeof(MTK_RIL_Data_Call_Response_v11));
    RFX_ASSERT(response != NULL);
    initDataCallResponse(response, num);


    p = request->getParcel();
    if (p == NULL){
        RFX_LOG_E(RFX_LOG_TAG, "%s:%d  slotid[%d] clientid[%d] token[%d] NULL parcel", __FUNCTION__ ,  __LINE__, \
                request->getSlotId(), request->getClientId(), request->getToken());
        goto error;
    }

    status = p->readInt32(&countStrings);
    if (countStrings <= 0) {
        RFX_LOG_E(RFX_LOG_TAG, "%s:%d  slotid[%d] clientid[%d] token[%d] Parameters error", __FUNCTION__ ,  __LINE__, \
                request->getSlotId(), request->getClientId(), request->getToken());
        goto error;
    }

    if (countStrings == 0) {
        // just some non-null pointer
        pStrings = (char **)calloc(1, sizeof(char *));
        if (pStrings == NULL) {
            RFX_LOG_E(RFX_LOG_TAG, "%s:%d  slotid[%d] clientid[%d] token[%d]Memory allocation failed", __FUNCTION__ ,  __LINE__, \
                request->getSlotId(), request->getClientId(), request->getToken());
            goto error;
        }
    } else if (countStrings < 0) {
        pStrings = NULL;
        goto error;
    } else {
        pStrings = (char **)calloc(countStrings, sizeof(char *));
        if (pStrings == NULL) {
            RFX_LOG_E(RFX_LOG_TAG, "%s:%d  slotid[%d] clientid[%d] token[%d]Memory allocation failed", __FUNCTION__ ,  __LINE__, \
                request->getSlotId(), request->getClientId(), request->getToken());
            goto error;
        }

        for (int i = 0 ; i < countStrings ; i++) {
            pStrings[i] = strdupReadString(p);
        }
        dumpSetupDataRequestPrameters(pStrings, countStrings);
    }

    //apn type
    if (pStrings[1] == NULL){
        RFX_LOG_E(RFX_LOG_TAG, "%s:%d  slotid[%d] clientid[%d] token[%d]null apn type", __FUNCTION__ ,  __LINE__, \
                request->getSlotId(), request->getClientId(), request->getToken());
        goto error;
    }

    apnType = (mipc_apn_type_enum)atoi(pStrings[1]);

    //apn name
    if (pStrings[2] == NULL){
        RFX_LOG_E(RFX_LOG_TAG, "%s:%d  slotid[%d] clientid[%d] token[%d]null apn name", __FUNCTION__ ,  __LINE__, \
                request->getSlotId(), request->getClientId(), request->getToken());
        goto error;
    }

    if (!isDataAllowed(pStrings[2])) {
        RFX_LOG_E(RFX_LOG_TAG, "%s:%d  slotid[%d] clientid[%d] token[%d]isDataAllowed() return false!", __FUNCTION__ ,  __LINE__, \
                request->getSlotId(), request->getClientId(), request->getToken());
        response->status = m_nGprsFailureCause = PDP_FAIL_DATA_NOT_ALLOW;
        goto error;
    }


    authType = (mipc_apn_auth_type_enum)atoi(pStrings[5]);

    mapPdpTypeFromStringToEnum(pStrings[6], &pdpType);

    data_call_cb = (Act_Data_call_back_priv*)calloc(1, sizeof(Act_Data_call_back_priv));
    if (data_call_cb == NULL) {
        RFX_LOG_E(RFX_LOG_TAG, "%s:%d  slotid[%d] clientid[%d] token[%d] NULL calloc", __FUNCTION__ ,  __LINE__, \
                request->getSlotId(), request->getClientId(), request->getToken());
        goto error;
    }
    data_call_cb->token = request->getRilToken();
    memset(data_call_cb->apn, 0, MAX_APN_NAME_LENGTH);
    strncpy(data_call_cb->apn, pStrings[2], strlen(pStrings[2]));

    result = mipc_data_call_act_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_data_call_act_cb, (void *)data_call_cb, pStrings[2], \
        apnType, pdpType, pdpType, authType, pStrings[3], pStrings[4], \
        MIPC_DATA_ENUM_FALLBACK_TYPE_IPV4_FIRST, 0xffffffff);
error:
    if (response != NULL) {
        freeDataResponse(response);
        FREEIF(response);
    }

    for (int i = 0 ; i < countStrings ; i++) {
       FREEIF(pStrings[i]);
    }
    FREEIF(pStrings);

    return;
}

void RpDataController::handleDeactivateDataRequest(const sp<RfxMessage>& request) {

    status_t status = 0;
    int32_t  countStrings = 0;
    char * pStrings[2] = {0};
    int cid = -1;
    int reason = -1;
    int ret = 0;
    Parcel *p = NULL;
    const int nPdnInfoSize = m_pPdnManager->getPdnTableSize();
    

    if (request == NULL){
        RFX_LOG_E(RFX_LOG_TAG, "%s:%d NULL Parameter", __FUNCTION__ ,  __LINE__);
        goto error;
    }

    p = request->getParcel();
    if (p == NULL){
        RFX_LOG_E(RFX_LOG_TAG, "%s:%d  slotid[%d] clientid[%d] token[%d] NULL parcel", __FUNCTION__ ,  __LINE__, \
                request->getSlotId(), request->getClientId(), request->getToken());
        goto error;
    }

    status = p->readInt32(&countStrings);
    if (countStrings != 2) {
        RFX_LOG_E(RFX_LOG_TAG, "%s:%d  slotid[%d] clientid[%d] token[%d] Parametes error", __FUNCTION__ ,  __LINE__, \
                request->getSlotId(), request->getClientId(), request->getToken());
        goto error;
    }

    pStrings[0] = strdupReadString(p);
    pStrings[1] = strdupReadString(p);

    if ((pStrings[0] == NULL) || (pStrings[1] == NULL)){
        RFX_LOG_E(RFX_LOG_TAG, "%s:%d  slotid[%d] clientid[%d] token[%d] Parametes error", __FUNCTION__ ,  __LINE__, \
                        request->getSlotId(), request->getClientId(), request->getToken());
                goto error;
    }

    cid = atoi(pStrings[0]);
    reason = atoi(pStrings[1]);
    for (int i = 0; i < nPdnInfoSize; i++) {
        if ((m_pPdnManager->getTransIntfId(i) == cid) && !m_pPdnManager->isDedicateBearer(i)) {
            // Error handling if needed.
            RFX_LOG_E(RFX_LOG_TAG, "%s:%d  slotid[%d] clientid[%d] token[%d] deactivateDataCall cid[%d] reason[%d]", __FUNCTION__ ,  __LINE__, \
                request->getSlotId(), request->getClientId(), request->getToken(), cid, reason);
            ret = deactivateDataCall(m_pPdnManager->getAid(i), request);
            if (ret != 0){
                RFX_LOG_E(RFX_LOG_TAG, "%s:%d  slotid[%d] clientid[%d] token[%d] deactivateDataCall cid[%d] fail[%d]", __FUNCTION__ ,  __LINE__, \
                                request->getSlotId(), request->getClientId(), request->getToken(), cid, ret);
            }
        }
    }

    goto finish;

error:
    RFX_LOG_E(RFX_LOG_TAG, "%s:%d failure", __FUNCTION__ ,  __LINE__);

finish:
    RFX_LOG_E(RFX_LOG_TAG, "%s:%d always success", __FUNCTION__ ,  __LINE__);
    FREEIF(pStrings[0]);
    FREEIF(pStrings[1]);
    return;
}

void RpDataController::setGprsFailureCause(int gprsFailureCause){
    m_nGprsFailureCause = gprsFailureCause;
}

int RpDataController::getGprsFailureCause(){
    return m_nGprsFailureCause;
}

bool RpDataController::notifyDeactReasonIfNeeded(const int deactivatedAid) {
    int rid = m_slot_id;

    // Check if AID is out of bound.
    if (!validateAid(deactivatedAid)) {
        RFX_LOG_E(RFX_LOG_TAG, "[%d][%s] deactivatedAid=%d is out of bound",
                rid, __FUNCTION__, deactivatedAid);
        return false;
    }

    // Update the reason of why pdn was deactivated to FWK for checking if needs to do pdn retrying
    // except that there has no existed reason or another of fallback pdn of the same apn is still alive.
    if (getPdnManager()->getDeactReason(deactivatedAid) != NO_REASON && !isFallbackPdn(deactivatedAid)) {
        RFX_LOG_D(RFX_LOG_TAG, "[%d][%s] notify deact reason %d for {deactAid=%d, transIntfId=%d}",
                rid, __FUNCTION__, getPdnManager()->getDeactReason(deactivatedAid), deactivatedAid,
                getPdnManager()->getTransIntfId(deactivatedAid));
        return true;
    }
    return false;
}

bool RpDataController::isFallbackPdn(const int aid) {
    int rid = m_slot_id;
    int pdnsOfActive = 0;
    PdnInfo pdn_info;
    memset(&pdn_info, 0, sizeof(pdn_info));
    const int nPdnInfoSize = getPdnManager()->getPdnTableSize();
    String8 cmd("");

    // Check if AID is out of bound.
    if (!validateAid(aid)) {
        RFX_LOG_E(RFX_LOG_TAG, "[%d][%s] aid=%d is out of bound",
                rid, __FUNCTION__, aid);
        return false;
    }

    if (getPdnManager()->getPdnActiveStatus(aid) != DATA_STATE_ACTIVE) {
        RFX_LOG_E(RFX_LOG_TAG, "[%d][%s] no need to check non-active aid %d",
                rid, __FUNCTION__, aid);
        return false;
    }

    for (int i = 0; i < nPdnInfoSize; i++) {
        pdn_info = getPdnManager()->getPdnInfo(i);
        if ((pdn_info.active == DATA_STATE_ACTIVE) &&
                (getPdnManager()->getTransIntfId(pdn_info.aid) == getPdnManager()->getTransIntfId(aid))) {
            if (0 == pdnsOfActive) {
                cmd.append(String8::format("%d", pdn_info.aid));
            } else {
                cmd.append(String8::format(",%d", pdn_info.aid));
            }
            pdnsOfActive++;
        }
    }

    RFX_LOG_D(RFX_LOG_TAG, "[%d][%s] %s for aid=%d (all Of active aid <%s> for transIntfId=%d)",
            rid, __FUNCTION__, BTOS(pdnsOfActive > 1), aid, cmd.string(), getPdnManager()->getTransIntfId(aid));
    return (pdnsOfActive > 1) ? true : false;
}
