// SPDX-License-Identifier: MediaTekProprietary
/*****************************************************************************
 *  Copyright Statement:
 *  --------------------
 *  Copyright (c) [2020], MediaTek Inc. All rights reserved.
 *  This software/firmware and related documentation ("MediaTek Software") are
 *  protected under relevant copyright laws.
 *
 *  The information contained herein is confidential and proprietary to
 *  MediaTek Inc. and/or its licensors. Except as otherwise provided in the
 *  applicable licensing terms with MediaTek Inc. and/or its licensors, any
 *  reproduction, modification, use or disclosure of MediaTek Software, and
 *  information contained herein, in whole or in part, shall be strictly
 *  prohibited.
 *****************************************************************************/

#ifndef SIM_RPSIMCONTROLLER_H_
#define SIM_RPSIMCONTROLLER_H_

#include <string>
#include "RfxController.h"
#include "RpUtils.h"
#include "RilParcelUtils.h"
#include <telephony/mtk_ril_request_info.h>

#ifdef __cplusplus
extern "C" {
#endif
#include "mipc_sim_api.h"
#include "mipc_msg_tlv_const.h"
#ifdef __cplusplus
}
#endif

class RpSimController : public RfxController {
    RFX_DECLARE_CLASS(RpSimController);  // Required: declare this class

protected:
    virtual void onInit();
    virtual bool onHandleRequest(const android::sp<RfxMessage> &message);
    virtual void onDeinit();

public:
    RpSimController();
    virtual ~RpSimController();
private:
    std::string mLog_tag;
private:
    mipc_sim_app_type_const_enum queryAppTypeId(std::string aid);
    void registerInd(mipc_sim_ps_id_enum sim_ps_id, void *cb_priv_ptr);
    std::string IdToString(int request);
    void handleGetSimStatus(const android::sp<RfxMessage> &message);
    void handleEnterSimPinX(const android::sp<RfxMessage> &message);
    void handleEnterSimPin2(const android::sp<RfxMessage> &message);
    void handleEnterSimPUKX(const android::sp<RfxMessage> &message);
    void handleEnterSimPUK2(const android::sp<RfxMessage> &message);
    void handleChangeSimPinX(const android::sp<RfxMessage> &message);
    void handleChangeSimPin2(const android::sp<RfxMessage> &message);
    void handleEnterNetworkDePeronal(const android::sp<RfxMessage> &message);
    void handleGetImsi(const android::sp<RfxMessage> &message);
    void handleSimIo(const android::sp<RfxMessage> &message);
    void handleQueryFacilityLock(const android::sp<RfxMessage> &message);
    void handleSetFacilityLock(const android::sp<RfxMessage> &message);
    void handleSimAuth(const android::sp<RfxMessage> &message);
    void handleIsimAuth(const android::sp<RfxMessage> &message);
    void handleSimTranApduBasic(const android::sp<RfxMessage> &message);
    void handleSimTranApduChann(const android::sp<RfxMessage> &message);
    void handleSimOpenChannel(const android::sp<RfxMessage> &message);
    void handleSimCloseChannel(const android::sp<RfxMessage> &message);
    void handleSimGetIccid(const android::sp<RfxMessage> &message);
    int setChannelToClassByte(int cla, int channelNumber);
    void handleQueryEid(const android::sp<RfxMessage> &message);
    void handleQuerySimRetryCount(const android::sp<RfxMessage> &message);
    int hexStringToByteArrayEx(unsigned char* hexString,
        int hexStringLen, unsigned char ** byte);
    int toByte(char c);

};

#endif /* SIM_RPSIMCONTROLLER_H_ */
