/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2015. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

#ifndef __RP_SMS_CONTROLLER_H__
#define __RP_SMS_CONTROLLER_H__

/*****************************************************************************
 * Include
 *****************************************************************************/
#include "RfxController.h"
#include "RfxTimer.h"

#include <utils/Vector.h>

#define CB_CFG_MAX_SINGLE_NUM    60
#define CB_CFG_MAX_LANG_CHARR     4 // Max value is 8bit

/*****************************************************************************
 * Class RpDataController
 *****************************************************************************/
class RpSmsController : public RfxController {
    RFX_DECLARE_CLASS(RpSmsController);  // Required: declare this class

public:
    RpSmsController();

    virtual ~RpSmsController();

// Override
protected:

    virtual void onInit();
    virtual void onDeinit();
    virtual bool onHandleRequest(const sp<RfxMessage>& message);
    virtual bool onHandleUrc(const sp<RfxMessage>& message);

    virtual void handleSMSRequest(const sp<RfxMessage>& request);
    virtual void handleDeleteSMSOnSIMRequest(const sp<RfxMessage>& request);
    virtual void handleGetSmscAddressRequest(const sp<RfxMessage>& request);
    virtual void handleSetSmscAddressRequest(const sp<RfxMessage>& request);
    virtual void handleWriteSmsToSimRequest(const sp<RfxMessage>& request);
    virtual void handleAcknowledgeRequest(const sp<RfxMessage>& request);
    virtual void handleGsmCbSmsActivation(const sp<RfxMessage>& request);
    virtual void handleGsmGetCbSmsCfg(const sp<RfxMessage>& request);
    virtual void handleGsmSetCbSmsCfg(const sp<RfxMessage>& request);
    virtual void handleReportSmsMemStatus(const sp<RfxMessage>& request);
    virtual void handleGetSmsSimMemStatus(const sp<RfxMessage>& request);
    virtual void handleGsmGetCbSmsLanguage(const sp<RfxMessage>& request);
    virtual void splitCbLanguageString(char *src, const char *sep, char dest[][CB_CFG_MAX_LANG_CHARR], int* num);
    virtual void handleGsmSetCbSmsLanguage(const sp<RfxMessage>& request);


private:

};

#define TPDU_MTI_BITS           (0x03)
#define TPDU_MTI_SUBMIT         (0x01)

#define TPDU_MTI_RESERVED       (0x03)

#define TPDU_VPF_BITS           (0x18)
#define TPDU_VPF_NOT_PRESENT    (0x00)

#define TPDU_VPF_RELATIVE       (0x02)

#define TPDU_PID_CHECK             (0xC0)

#define TPDU_PID_RESERVED          (0x80)
/*------------------------------------
 * Data Coding Scheme (DCS) Checking
 *------------------------------------*/
#define TPDU_DCS_DEFAULT         (0x00)
#define TPDU_DCS_CODING1         (0xc0)
#define TPDU_DCS_CODING2         (0xf0)
#define TPDU_DCS_RESERVE_BIT     (0x08)
#define TPDU_DCS_ALPHABET_CHECK  (0x0c)
#define TPDU_DCS_COMPRESS_CHECK  (0x20)

#define TPDU_MAX_TPDU_SIZE      (175)
#define TPDU_MAX_ADDR_LEN       (11)
#define TPDU_ONE_MSG_OCTET      (140)


typedef enum {
    TPDU_NO_ERROR           = 0x00,

    /* TP-DA Error */
    TPDU_DA_LENGTH_ERROR    = 0x01,

    /* TP-VPF Error */
    TPDU_VPF_NO_SUPPORT     = 0x02,

    /* TP-MTI Error */
    TPDU_MTI_SUBMIT_ERROR   = 0x03,
    TPDU_MTI_DELIVER_ERROR  = 0x04,

    /* TP-OA Error */
    TPDU_OA_LENGTH_ERROR    = 0x05,

    /* Length Error */
    TPDU_MSG_LEN_EXCEEDED   = 0x06,

    /* TP-PID Error */
    TELEMATIC_INT_WRK_NOT_SUPPORT = 0x80, /* telematic interworking not support */
    SMS_TYPE0_NOT_SUPPORT         = 0x81, /* short message type 0 not support */
    CANNOT_REPLACE_MSG            = 0x82,
    UNSPECIFIED_PID_ERROR         = 0x8F,

    /* DCS error */
    ALPHABET_NOT_SUPPORT          = 0x90, /* data coding scheme (alphabet) not support */
    MSG_CLASS_NOT_SUPPORT         = 0x91, /* message class not support */
    UNSPECIFIED_TP_DCS            = 0x9f,
}TPDU_ERROR_CAUSE_ENUM;


typedef enum {
    TPDU_PID_DEFAULT_PID = 0x00,   /* Text SMS */
    TPDU_PID_TELEX_PID   = 0x21,   /* Telex */
    TPDU_PID_G3_FAX_PID  = 0x22,   /* Group 3 telefax */
    TPDU_PID_G4_FAX_PID  = 0x23,   /* Group 4 telefax */
    TPDU_PID_VOICE_PID   = 0x24,   /* Voice Telephone */
    TPDU_PID_ERMES_PID   = 0x25,   /* ERMES (European Radio Messaging System) */
    TPDU_PID_PAGING_PID  = 0x26,   /* National Paging system */
    TPDU_PID_X400_PID    = 0x31,   /* Any public X.400-based message system */
    TPDU_PID_EMAIL_PID   = 0x32    /* E-mail SMS */
}TPDU_PID_ENUM;

typedef enum {
    SMS_ENCODING_7BIT,
    SMS_ENCODING_8BIT,
    SMS_ENCODING_16BIT,
    SMS_ENCODING_UNKNOWN
}SMS_ENCODING_ENUM;

typedef enum {
    SMS_MESSAGE_CLASS_0,
    SMS_MESSAGE_CLASS_1,
    SMS_MESSAGE_CLASS_2,
    SMS_MESSAGE_CLASS_3,
    SMS_MESSAGE_CLASS_UNSPECIFIED
}SMS_MESSAGE_CLASS_ENUM;

typedef struct RIL_SMS_GSM_CB_CHANNEL_NODE {
    int start;
    int end;
    struct RIL_SMS_GSM_CB_CHANNEL_NODE *pNext;
} RIL_SMS_GSM_CB_CHANNEL_LIST;

#endif /* __RP_SMS_CONTROLLER_H__ */

