#ifndef _MTK_POWER_H
#define _MTK_POWER_H

#include <stdint.h>

#if __cplusplus
extern "C" {
#endif

// while you have a lock held, the device will stay on at least at the
// level you request.

/**
 * acquire wake lock. While you have a lock held, the device cpu will stay on.
 * @id wake lock id defined by caller
 * @return return the wake lock id length if success, otherwise return -errno.
 */
int mtk_acquire_wake_lock(const char* id);

/**
 * release wake lock
 * @id wake lock id defined by caller
 * @return return the wake lock id length if success, otherwise return -errno.
 */
int mtk_release_wake_lock(const char* id);


#if __cplusplus
} // extern "C"
#endif

#endif // _MTK_POWER_H
