/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  Copyright (c) [2020], MediaTek Inc. All rights reserved.
*  This software/firmware and related documentation ("MediaTek Software") are
*  protected under relevant copyright laws.
*
*  The information contained herein is confidential and proprietary to
*  MediaTek Inc. and/or its licensors. Except as otherwise provided in the
*  applicable licensing terms with MediaTek Inc. and/or its licensors, any
*  reproduction, modification, use or disclosure of MediaTek Software, and
*  information contained herein, in whole or in part, shall be strictly
*  prohibited.
*****************************************************************************/

#ifndef _MIPC_SS_API_H_
#define _MIPC_SS_API_H_

/*!
    \defgroup SS
    @{
*/

#include "mipc_api.h"


/** @brief ussd response */
typedef enum {
    MIPC_SS_ENUM_USSD_NO_ACTION_REQUIRED = MIPC_SS_USSD_NO_ACTION_REQUIRED,/*!< no action is needed.*/
    MIPC_SS_ENUM_USSD_ACTION_REQUIRED = MIPC_SS_USSD_ACTION_REQUIRED,/*!< next action is needed.*/
    MIPC_SS_ENUM_USSD_TERMINATED_BY_NW = MIPC_SS_USSD_TERMINATED_BY_NW,/*!< operation is terminated by network .*/
    MIPC_SS_ENUM_USSD_OTHER_LOCAL_CLIENT = MIPC_SS_USSD_OTHER_LOCAL_CLIENT,/*!< other local client .*/
    MIPC_SS_ENUM_USSD_OPERATION_NOT_SUPPORTED = MIPC_SS_USSD_OPERATION_NOT_SUPPORTED,/*!< the operation is not supported.*/
    MIPC_SS_ENUM_USSD_NW_TIME_OUT = MIPC_SS_USSD_NW_TIME_OUT /*!< network time out.*/
} mipc_ss_ussd_response_enum;

typedef enum {
    MIPC_SS_ENUM_NEW_SESSION = MIPC_SS_SESSION_NEW,
    MIPC_SS_ENUM_EXISTING_SESSION = MIPC_SS_SESSION_EXISTING
} mipc_ss_ussd_session_state_enum;

/** @brief USSD operation info */
typedef struct {
    /** @brief result code*/
    mipc_result_enum result_code;
    /** @brief ussd response*/
    mipc_ss_ussd_response_enum ussd_response;
    /** @brief session state*/
    mipc_ss_ussd_session_state_enum ussd_session_state;
    /** @brief data coding scheme as defined in 3GPP TS 23.038, but only supprot UCS2 now*/
    uint32_t data_coding_scheme;//but only supprot UCS2 now
    /** @brief ussd payload length*/
    uint8_t ussd_payload_len;
    /** @brief array of ussd payload*/
    uint8_t ussd_payload[MIPC_MAX_USSD_LEN];
} mipc_ss_ussd_send_struct;

typedef mipc_ss_ussd_send_struct mipc_ss_ussd_cancel_struct;
typedef mipc_ss_ussd_send_struct mipc_ss_ussd_ind_struct;

/**
  *@brief callback function prototype for async. ussd send operation
  *@param[in] sim_ps_id indicate which sim or ps completed the operation (the value is decided by what is used when doing aysnc. operation)
  *@param[in] result_ptr point to the execution result
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
*/
typedef void (*MIPC_SS_USSD_SEND_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ss_ussd_send_struct *result_ptr,
    void *cb_priv_ptr
);

/**
  *@brief function for sync. send ussd operation
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in, out] result_ptr point to the execution result
  *@param[in] dcs data coding sheme as per 23.038
  *@param[in] ussd_payload_len length of ussd paylaod
  *@param[in] ussd_payload_ptr point to ussd paylaod
*/
mipc_api_result_enum mipc_ss_ussd_send_sync(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ss_ussd_send_struct *result_ptr,
    uint32_t dcs,
    uint8_t ussd_payload_len,
    uint8_t ussd_payload_ptr[160]
);

/**
  *@brief function for async. send ussd operation
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in] cb which callback function will be invoked after the operation completion
  *@param[in] cb_priv_ptr point to the callback private data
  *@param[in] dcs data coding sheme as per 23.038
  *@param[in] ussd_payload_len length of ussd paylaod
  *@param[in] ussd_payload_ptr point to ussd paylaod
*/
mipc_api_result_enum mipc_ss_ussd_send_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_SS_USSD_SEND_CB cb,
    void *cb_priv_ptr,
    uint32_t dcs,
    uint8_t ussd_payload_len,
    uint8_t ussd_payload_ptr[160]
);


/**
  *@brief function for sync. cancel ussd operation
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in, out] result_ptr point to the execution result
*/
mipc_api_result_enum mipc_ss_ussd_cancel_sync(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ss_ussd_cancel_struct *result_ptr
);


/**
  *@brief callback function prototype for async. ussd send operation
  *@param[in] sim_ps_id indicate which sim or ps completed the operation (the value is decided by what is used when doing aysnc. operation)
  *@param[in] result_ptr point to the execution result
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
*/
typedef void (*MIPC_SS_USSD_CANCEL_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ss_ussd_cancel_struct *result_ptr,
    void *cb_priv_ptr
);

/**
  *@brief function for async. send ussd operation
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in] cb which callback function will be invoked after the operation completion
  *@param[in] cb_priv_ptr point to the callback private data
*/
mipc_api_result_enum mipc_ss_ussd_cancel_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_SS_USSD_CANCEL_CB cb,
    void *cb_priv_ptr
);

/**
  *@brief callback function prototype for USSD notification operation
  *@param[in] sim_ps_id indicate which sim or ps received the event (the value is decided by what is used when doing register operation)
  *@param[in] result_ptr point to the execution result
  *@param[in] cb_priv_ptr point to the private data assigned when doing async. operation
*/
typedef void (*MIPC_SS_USSD_IND_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ss_ussd_ind_struct *result_ptr,
    void *cb_priv_ptr
);

/**
  *@brief function to register callback function for ussd notificaton
  *@param[in] sim_ps_id indicate which sim or ps is assigned to do the operation
  *@param[in] cb which callback function will be invoked after the operation completion
  *@param[in] cb_priv_ptr point to the callback private data
*/
mipc_api_result_enum mipc_ss_ussd_ind_register(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_SS_USSD_IND_CB cb,
    void *cb_priv_ptr
);

/** Set CLIR */
typedef struct {
    mipc_result_enum result_code;
} mipc_ss_set_clir_struct;

typedef void (*MIPC_SS_SET_CLIR_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ss_set_clir_struct *result_ptr,
    void *cb_priv_ptr
);

mipc_api_result_enum mipc_ss_set_clir_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_SS_SET_CLIR_CB cb,
    void *cb_priv_ptr,
    uint8_t n_value
);

/** Get CLIR */
typedef struct {
    mipc_result_enum result_code;
    uint8_t clir_n;
    uint8_t clir_m;
} mipc_ss_get_clir_struct;

typedef void (*MIPC_SS_GET_CLIR_CB) (
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ss_get_clir_struct *result_ptr,
    void *cb_priv_ptr
);

mipc_api_result_enum mipc_ss_get_clir_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_SS_GET_CLIR_CB cb,
    void *cb_priv_ptr
);

/** Set Call Waiting */
typedef struct {
    mipc_result_enum result_code;
} mipc_ss_set_call_waiting_struct;

typedef void (*MIPC_SS_SET_CALL_WAITING_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ss_set_call_waiting_struct *result_ptr,
    void *cb_priv_ptr
);

mipc_api_result_enum mipc_ss_set_call_waiting_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_SS_SET_CALL_WAITING_CB cb,
    void *cb_priv_ptr,
    mipc_ss_call_waiting_const_enum cw_enable_disable,
    mipc_ss_service_class_const_enum service_class
);

/** Query Call Waiting */
typedef struct {
    mipc_result_enum result_code;
    uint8_t call_waiting_status;
    mipc_ss_service_class_const_enum service_class;
} mipc_ss_query_call_waiting_struct;

typedef void (*MIPC_SS_QUERY_CALL_WAITING_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ss_query_call_waiting_struct *result_ptr,
    void *cb_priv_ptr
);

mipc_api_result_enum mipc_ss_query_call_waiting_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_SS_QUERY_CALL_WAITING_CB cb,
    void *cb_priv_ptr,
    mipc_ss_service_class_const_enum service_class
);

/** Set Call Forward */
typedef struct {
    mipc_result_enum result_code;
} mipc_ss_set_call_forward_struct;

typedef void (*MIPC_SS_SET_CALL_FORWARD_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ss_set_call_forward_struct *result_ptr,
    void *cb_priv_ptr
);

mipc_api_result_enum mipc_ss_set_call_forward_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_SS_SET_CALL_FORWARD_CB cb,
    void *cb_priv_ptr,
    mipc_ss_set_call_forward_operation_code_const_enum ss_operation,
    mipc_ss_call_forward_reason_const_enum call_forward_reason,
    char *dial_number,
    mipc_ss_service_class_const_enum service_class,
    uint16_t toa,
    uint8_t timer_seconds
);

/** Query Call Forward Status */
typedef struct {
    mipc_result_enum result_code;
    uint8_t call_forward_count;
    mipc_ss_call_forward_struct4 call_forward_infos[16];
} mipc_ss_query_call_forward_status_struct;

typedef void (*MIPC_SS_QUERY_CALL_FORWARD_STATUS_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ss_query_call_forward_status_struct *result_ptr,
    void *cb_priv_ptr
);

mipc_api_result_enum mipc_ss_query_call_forward_status_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_SS_QUERY_CALL_FORWARD_STATUS_CB cb,
    void *cb_priv_ptr,
    mipc_ss_service_class_const_enum service_class,
    mipc_ss_call_forward_reason_const_enum call_forward_reason
);

/** Set Call Barring */
typedef struct {
    mipc_result_enum result_code;
} mipc_ss_set_call_barring_struct;

typedef void (*MIPC_SS_SET_CALL_BARRING_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ss_set_call_barring_struct *result_ptr,
    void *cb_priv_ptr
);

mipc_api_result_enum mipc_ss_set_call_barring_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_SS_SET_CALL_BARRING_CB cb,
    void *cb_priv_ptr,
    mipc_ss_call_barring_lock_const_enum lock,
    mipc_ss_call_barring_fac_const_enum facility,
    char * password,
    mipc_ss_service_class_const_enum service_class
);

/** Query Call Barring */
typedef struct {
    mipc_result_enum result_code;
    uint16_t status;
} mipc_ss_query_call_barring_struct;

typedef void (*MIPC_SS_QUERY_CALL_BARRING_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ss_query_call_barring_struct *result_ptr,
    void *cb_priv_ptr
);

mipc_api_result_enum mipc_ss_query_call_barring_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_SS_QUERY_CALL_BARRING_CB cb,
    void *cb_priv_ptr,
    mipc_ss_call_barring_fac_const_enum facility,
    mipc_ss_service_class_const_enum service_class
);


/** Change Barring Password */
typedef struct {
    mipc_result_enum result_code;
} mipc_ss_change_barring_password_struct;

typedef void (*MIPC_SS_CHANGE_BARRING_PASSWORD_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ss_change_barring_password_struct *result_ptr,
    void *cb_priv_ptr
);

mipc_api_result_enum mipc_ss_change_barring_password_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_SS_CHANGE_BARRING_PASSWORD_CB cb,
    void *cb_priv_ptr,
    mipc_ss_call_barring_fac_const_enum facility,
    char *old_pwd,
    char *new_pwd,
    char *new_pwd_confirm
);

/** Set supplementary service notification */
typedef struct {
    mipc_result_enum result_code;
} mipc_ss_set_supp_svc_notification_struct;

typedef void (*MIPC_SS_SET_SUPP_SVC_NOTIFICATION_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ss_set_supp_svc_notification_struct *result_ptr,
    void *cb_priv_ptr
);

mipc_api_result_enum mipc_ss_set_supp_svc_notification_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_SS_SET_SUPP_SVC_NOTIFICATION_CB cb,
    void *cb_priv_ptr,
    uint8_t status_i,
    uint8_t status_u
);

/** Query CLIP */
typedef struct {
    mipc_result_enum result_code;
    uint8_t code_staus;
    uint8_t nw_status;
} mipc_ss_query_clip_struct;

typedef void (*MIPC_SS_QUERY_CLIP_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ss_query_clip_struct *result_ptr,
    void *cb_priv_ptr
);

mipc_api_result_enum mipc_ss_query_clip_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_SS_QUERY_CLIP_CB cb,
    void *cb_priv_ptr
);

/** Set CLIP */
typedef struct {
    mipc_result_enum result_code;
} mipc_ss_set_clip_struct;

typedef void (*MIPC_SS_SET_CLIP_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ss_set_clip_struct *result_ptr,
    void *cb_priv_ptr
);

mipc_api_result_enum mipc_ss_set_clip_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_SS_SET_CLIP_CB cb,
    void *cb_priv_ptr,
    uint8_t status
);

/** Get COLP */
typedef struct {
    mipc_result_enum result_code;
    uint8_t colp_n;
    uint8_t colp_m;
} mipc_ss_get_colp_struct;

typedef void (*MIPC_SS_GET_COLP_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ss_get_colp_struct *result_ptr,
    void *cb_priv_ptr
);

mipc_api_result_enum mipc_ss_get_colp_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_SS_GET_COLP_CB cb,
    void *cb_priv_ptr
);

/** Set COLP */
typedef struct {
    mipc_result_enum result_code;
} mipc_ss_set_colp_struct;

typedef void (*MIPC_SS_SET_COLP_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ss_set_colp_struct *result_ptr,
    void *cb_priv_ptr
);

mipc_api_result_enum mipc_ss_set_colp_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_SS_SET_COLP_CB cb,
    void *cb_priv_ptr,
    uint8_t n_value
);

/** Get COLR */
typedef struct {
    mipc_result_enum result_code;
    uint8_t status;
} mipc_ss_get_colr_struct;

typedef void (*MIPC_SS_GET_COLR_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ss_get_colr_struct *result_ptr,
    void *cb_priv_ptr
);

mipc_api_result_enum mipc_ss_get_colr_async(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_SS_GET_COLR_CB cb,
    void *cb_priv_ptr
);

/** SS Notification from +ECMCCSS*/
typedef struct {
    mipc_result_enum result_code;
    uint32_t call_id;
    uint32_t service;
    char *raw_string;
} mipc_ss_ecmccss_ind_struct;


typedef void (*MIPC_SS_ECMCCSS_IND_CB)(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_ss_ecmccss_ind_struct *result_ptr,
    void *cb_priv_ptr
);

mipc_api_result_enum mipc_ss_ecmccss_ind_register(
    mipc_sim_ps_id_enum sim_ps_id,
    MIPC_SS_ECMCCSS_IND_CB cb,
    void *cb_priv_ptr
);

/*!
    @}
*/
#endif
