/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  Copyright (c) [2020], MediaTek Inc. All rights reserved.
*  This software/firmware and related documentation ("MediaTek Software") are
*  protected under relevant copyright laws.
*
*  The information contained herein is confidential and proprietary to
*  MediaTek Inc. and/or its licensors. Except as otherwise provided in the
*  applicable licensing terms with MediaTek Inc. and/or its licensors, any
*  reproduction, modification, use or disclosure of MediaTek Software, and
*  information contained herein, in whole or in part, shall be strictly
*  prohibited.
*****************************************************************************/

#include "mipc_msg_tlv_const.h"
#include "mipc_msg.h"
#include "mipc_msg_host.h"
#include "mipc_apn_api.h"

#define DEFALT_APN_LIST_COUNT 10
static mipc_api_result_enum mipc_apn_ia_set_config_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_apn_ia_struct_v *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;
    uint8_t apn_count;
    uint16_t list_len = 0;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_APN_SET_IA_CNF_T_IA_COUNT, NULL);
        if (NULL == val_ptr) break;
        apn_count = (uint8_t)(*((uint32_t*)val_ptr));
        if (apn_count) {
            val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_APN_SET_IA_CNF_T_IA_LIST, &list_len);
            if (NULL == val_ptr) break;
            if (result_ptr->ia_list_count >= apn_count) {
                MEMCPY(result_ptr->ia_list, val_ptr, list_len);
                result_ptr->ia_list_count = apn_count;
            } else {
                MEMCPY(result_ptr->ia_list, val_ptr, (result_ptr->ia_list_count)*sizeof(mipc_apn_ia_struct4));
            }
        } else {
            result_ptr->ia_list_count = 0;
        }

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    //reset  apn_list_count
    if ((result == MIPC_API_RESULT_FAIL) || (MIPC_RESULT_SUCCESS != result_ptr->result_code)) result_ptr->ia_list_count = 0;
    return result;
}

static void mipc_apn_ia_set_config_cb(mipc_msg_t *msg_ptr, MIPC_APN_IA_SET_CB cb, void *cb_priv_ptr)
{
    mipc_apn_ia_struct_v *result_ptr = (mipc_apn_ia_struct_v *)ALLOC(sizeof(mipc_apn_ia_struct_v) + DEFALT_APN_LIST_COUNT * sizeof(mipc_apn_ia_struct4));
    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_apn_ia_struct_v) + DEFALT_APN_LIST_COUNT * sizeof(mipc_apn_ia_struct4));
        result_ptr->ia_list_count = DEFALT_APN_LIST_COUNT;
        mipc_apn_ia_set_config_cnf_decode(msg_ptr, result_ptr);
    }
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);
    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_apn_ia_set(MIPC_APN_IA_SET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_apn_ia_struct_v *result_ptr, char *apn_ptr, mipc_apn_pdp_type_enum pdp_type, mipc_apn_pdp_type_enum roaming_type, mipc_apn_auth_type_enum auth_type, char *userid_ptr, char *password_ptr, uint32_t bearer_bitmask, mipc_apn_compression_enum compression)
{
    //SETP1: build MIPC message
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_APN_SET_IA_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP2: add paramters
    if (apn_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_APN_SET_IA_REQ_T_APN, 100, apn_ptr);
    }
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_APN_SET_IA_REQ_T_PDP_TYPE, pdp_type);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_APN_SET_IA_REQ_T_ROAMING_TYPE, roaming_type);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_APN_SET_IA_REQ_T_AUTH_TYPE, auth_type);
    if (userid_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_APN_SET_IA_REQ_T_USERID, MIPC_MAX_USERID_LEN, userid_ptr);
    }
    if (password_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_APN_SET_IA_REQ_T_PASSWORD, MIPC_MAX_PASSWORD_LEN, password_ptr);
    }
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_APN_SET_IA_REQ_T_BEARER_BITMASK, bearer_bitmask);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_APN_SET_IA_REQ_T_COMPRESSION, compression);

    if (cb) {
        //SETP3: send to MD
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_apn_ia_set_config_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        //SETE4: free the req msg
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_apn_ia_set_config_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

static mipc_api_result_enum mipc_apn_ia_get_config_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_apn_ia_struct_v *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;
    uint8_t apn_count;
    uint16_t list_len = 0;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_APN_GET_IA_CNF_T_IA_COUNT, NULL);
        if (NULL == val_ptr) break;
        apn_count = (uint8_t)(*((uint32_t*)val_ptr));
        if (apn_count) {
            val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_APN_GET_IA_CNF_T_IA_LIST, &list_len);
            if (NULL == val_ptr) break;
            if (result_ptr->ia_list_count >= apn_count) {
                MEMCPY(result_ptr->ia_list, val_ptr, list_len);
                result_ptr->ia_list_count = apn_count;
            } else {
                MEMCPY(result_ptr->ia_list, val_ptr, (result_ptr->ia_list_count)*sizeof(mipc_apn_ia_struct4));
            }
        } else {
            result_ptr->ia_list_count = 0;
        }
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    //reset  apn_list_count
    if ((result == MIPC_API_RESULT_FAIL) || (MIPC_RESULT_SUCCESS != result_ptr->result_code)) result_ptr->ia_list_count = 0;

    return result;
}

static void mipc_apn_ia_get_config_cb(mipc_msg_t *msg_ptr, MIPC_APN_IA_GET_CB cb, void *cb_priv_ptr)
{
    mipc_apn_ia_struct_v *result_ptr = (mipc_apn_ia_struct_v *)ALLOC(sizeof(mipc_apn_ia_struct_v) + DEFALT_APN_LIST_COUNT * sizeof(mipc_apn_ia_struct4));
    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_apn_ia_struct_v) + DEFALT_APN_LIST_COUNT * sizeof(mipc_apn_ia_struct4));
        result_ptr->ia_list_count = DEFALT_APN_LIST_COUNT;
        mipc_apn_ia_get_config_cnf_decode(msg_ptr, result_ptr);
    }
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);
    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_apn_ia_get(MIPC_APN_IA_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_apn_ia_struct_v *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_APN_GET_IA_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_apn_ia_get_config_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_apn_ia_get_config_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

static mipc_api_result_enum mipc_apn_profile_update_config_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_apn_profiles_struct_v *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;
    uint8_t apn_count;
    uint16_t list_len = 0;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_APN_ADD_PROFILE_CNF_T_APN_COUNT, NULL);
        if (NULL == val_ptr) {
            result_ptr->apn_list_count = 0;
            break;
        }
        apn_count = (uint8_t)(*((uint32_t*)val_ptr));
        if (apn_count != 0) {
            if (result_ptr->apn_list_count >= apn_count) {
                val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_APN_ADD_PROFILE_CNF_T_APN_LIST, &list_len);
                if (NULL == val_ptr) {
                    result_ptr->apn_list_count = 0;
                    break;
                }
                MEMCPY(result_ptr->apn_list, val_ptr, list_len);
                result_ptr->apn_list_count = apn_count;
            } else {
                val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_APN_ADD_PROFILE_CNF_T_APN_LIST, &list_len);
                if (NULL == val_ptr) break;
                MEMCPY(result_ptr->apn_list, val_ptr, (result_ptr->apn_list_count)*sizeof(mipc_apn_profile_struct4));
            }
        } else {
            result_ptr->apn_list_count = 0;
        }

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_apn_profile_update_config_cb(mipc_msg_t *msg_ptr, MIPC_APN_PROFILE_UPDATE_CB cb, void *cb_priv_ptr)
{
    mipc_apn_profiles_struct_v *result_ptr = (mipc_apn_profiles_struct_v *)ALLOC(sizeof(mipc_apn_profiles_struct_v) + DEFALT_APN_LIST_COUNT * sizeof(mipc_apn_profile_struct4));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_apn_profiles_struct_v) + DEFALT_APN_LIST_COUNT * sizeof(mipc_apn_profile_struct4));
        result_ptr->apn_list_count = DEFALT_APN_LIST_COUNT;
        mipc_apn_profile_update_config_cnf_decode(msg_ptr, result_ptr);
    }
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);
    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_apn_profile_update(MIPC_APN_PROFILE_UPDATE_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_apn_profiles_struct_v *result_ptr, uint32_t id, char *plmnid_ptr, char *apn_ptr, uint32_t apn_type, mipc_apn_pdp_type_enum pdp_type, mipc_apn_pdp_type_enum roaming_type, mipc_apn_auth_type_enum auth_type, char *userid_ptr, char *password_ptr, uint32_t bearer_bitmask, mipc_apn_compression_enum compression)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_APN_ADD_PROFILE_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_APN_ADD_PROFILE_REQ_T_ID, id);
    if (plmnid_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_APN_ADD_PROFILE_REQ_T_PLMN_ID, 7, plmnid_ptr);
    }
    if (apn_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_APN_ADD_PROFILE_REQ_T_APN, 100, apn_ptr);
    }
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_APN_ADD_PROFILE_REQ_T_APN_TYPE, apn_type);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_APN_ADD_PROFILE_REQ_T_PDP_TYPE, pdp_type);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_APN_ADD_PROFILE_REQ_T_ROAMING_TYPE, roaming_type);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_APN_ADD_PROFILE_REQ_T_AUTH_TYPE, auth_type);
    if (userid_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_APN_ADD_PROFILE_REQ_T_USERID, MIPC_MAX_USERID_LEN, userid_ptr);
    }
    if (password_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_APN_ADD_PROFILE_REQ_T_PASSWORD, MIPC_MAX_PASSWORD_LEN, password_ptr);
    }
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_APN_ADD_PROFILE_REQ_T_BEARER_BITMASK, bearer_bitmask);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_APN_ADD_PROFILE_REQ_T_COMPRESSION, compression);

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_apn_profile_update_config_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_apn_profile_update_config_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

static mipc_api_result_enum mipc_apn_profile_get_config_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_apn_profiles_struct_v *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;
    uint8_t apn_count;
    uint16_t list_len = 0;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_APN_LIST_PROFILE_CNF_T_APN_COUNT, NULL);
        if (NULL == val_ptr) break;
        apn_count = (uint8_t)(*((uint32_t*)val_ptr));
        if (apn_count) {
            val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_APN_LIST_PROFILE_CNF_T_APN_LIST, &list_len);
            if (NULL == val_ptr) break;
            if (result_ptr->apn_list_count >= apn_count) {
                MEMCPY(result_ptr->apn_list, val_ptr, list_len);
                result_ptr->apn_list_count = apn_count;
            } else {
                MEMCPY(result_ptr->apn_list, val_ptr, (result_ptr->apn_list_count)*sizeof(mipc_apn_profile_struct4));
            }
        } else {
            result_ptr->apn_list_count = 0;
        }

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    if ((result == MIPC_API_RESULT_FAIL) || (MIPC_RESULT_SUCCESS != result_ptr->result_code)) result_ptr->apn_list_count = 0;

    return result;
}

static void mipc_apn_profile_get_config_cb(mipc_msg_t *msg_ptr, MIPC_APN_PROFILE_GET_CB cb, void *cb_priv_ptr)
{
    mipc_apn_profiles_struct_v *result_ptr = (mipc_apn_profiles_struct_v *)ALLOC(sizeof(mipc_apn_profiles_struct_v) + DEFALT_APN_LIST_COUNT * sizeof(mipc_apn_profile_struct4));
    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_apn_profiles_struct_v) + DEFALT_APN_LIST_COUNT * sizeof(mipc_apn_profile_struct4));
        result_ptr->apn_list_count = DEFALT_APN_LIST_COUNT;
        mipc_apn_profile_get_config_cnf_decode(msg_ptr, result_ptr);
    }
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);
    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_apn_profile_get(MIPC_APN_PROFILE_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_apn_profiles_struct_v *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_APN_LIST_PROFILE_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_apn_profile_get_config_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_apn_profile_get_config_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

static mipc_api_result_enum mipc_apn_profile_del_config_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_apn_profiles_struct_v *result_ptr)
{
    void* val_ptr;
    uint32_t *t_result_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;
    uint8_t apn_count;
    uint16_t list_len = 0;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_APN_DEL_PROFILE_CNF_T_APN_COUNT, NULL);
        if (NULL == val_ptr) break;
        apn_count = (uint8_t)(*((uint32_t*)val_ptr));
        if (apn_count) {
            val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_APN_DEL_PROFILE_CNF_T_APN_LIST, &list_len);
            if (NULL == val_ptr) break;
            if (result_ptr->apn_list_count >= apn_count) {
                MEMCPY(result_ptr->apn_list, val_ptr, list_len);
                result_ptr->apn_list_count = apn_count;
            } else {
                MEMCPY(result_ptr->apn_list, val_ptr, (result_ptr->apn_list_count)*sizeof(mipc_apn_profile_struct4));
            }
        } else {
            result_ptr->apn_list_count = 0;
        }
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    //reset  apn_list_count
    if ((result == MIPC_API_RESULT_FAIL) || (MIPC_RESULT_SUCCESS != result_ptr->result_code)) result_ptr->apn_list_count = 0;

    return result;
}

static void mipc_apn_profile_del_config_cb(mipc_msg_t *msg_ptr, MIPC_APN_PROFILE_DEL_CB cb, void *cb_priv_ptr)
{
    mipc_apn_profiles_struct_v *result_ptr = (mipc_apn_profiles_struct_v *)ALLOC(sizeof(mipc_apn_profiles_struct_v) + DEFALT_APN_LIST_COUNT * sizeof(mipc_apn_profile_struct4));
    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_apn_profiles_struct_v) + DEFALT_APN_LIST_COUNT * sizeof(mipc_apn_profile_struct4));
        result_ptr->apn_list_count = DEFALT_APN_LIST_COUNT;
        mipc_apn_profile_del_config_cnf_decode(msg_ptr, result_ptr);
    }
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);
    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_apn_profile_del(MIPC_APN_PROFILE_DEL_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_apn_profiles_struct_v *result_ptr, uint32_t id)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_APN_DEL_PROFILE_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_APN_DEL_PROFILE_REQ_T_ID, id);

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_apn_profile_del_config_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_apn_profile_del_config_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_apn_ia_set_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_apn_ia_struct_v *result_ptr, char *apn_ptr, mipc_apn_pdp_type_enum pdp_type, mipc_apn_pdp_type_enum roaming_type, mipc_apn_auth_type_enum auth_type, char *userid_ptr, char *password_ptr, uint32_t bearer_bitmask, mipc_apn_compression_enum compression)
{
    //SETP0: check input
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_apn_ia_set(NULL, NULL, sim_ps_id, result_ptr, apn_ptr, pdp_type, roaming_type, auth_type, userid_ptr, password_ptr, bearer_bitmask, compression);
}

mipc_api_result_enum mipc_apn_ia_set_async( mipc_sim_ps_id_enum sim_ps_id, MIPC_APN_IA_SET_CB cb, void *cb_priv_ptr, char *apn_ptr, mipc_apn_pdp_type_enum pdp_type, mipc_apn_pdp_type_enum roaming_type, mipc_apn_auth_type_enum auth_type, char *userid_ptr, char *password_ptr, uint32_t bearer_bitmask, mipc_apn_compression_enum compression)
{
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_apn_ia_set(cb, cb_priv_ptr, sim_ps_id, NULL, apn_ptr, pdp_type, roaming_type, auth_type, userid_ptr, password_ptr, bearer_bitmask, compression);
}

mipc_api_result_enum mipc_apn_ia_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_apn_ia_struct_v *result_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_apn_ia_get(NULL, NULL, sim_ps_id, result_ptr);
}

mipc_api_result_enum mipc_apn_ia_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_APN_IA_GET_CB cb, void *cb_priv_ptr)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_apn_ia_get(cb, cb_priv_ptr, sim_ps_id, NULL);
}

mipc_api_result_enum mipc_apn_ia_register(mipc_sim_ps_id_enum sim_ps_id,  MIPC_APN_IA_IND_CB cb, void *cb_priv_ptr)
{
    void *callback;
    if (cb) {
        callback = (void *)mipc_apn_ia_get_config_cb;
    } else {
        callback = NULL;
    }

    if (mipc_msg_register_ind_api((mipc_msg_sim_ps_id_enum)sim_ps_id, MIPC_APN_IA_CFG_IND, callback, (MIPC_API_CB)cb, cb_priv_ptr) == 0) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        return MIPC_API_RESULT_FAIL;
    }
}

mipc_api_result_enum mipc_apn_profile_update_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_apn_profiles_struct_v *result_ptr, uint32_t id, char *plmnid_ptr, char *apn_ptr, uint32_t apn_type, mipc_apn_pdp_type_enum pdp_type, mipc_apn_pdp_type_enum roaming_type, mipc_apn_auth_type_enum auth_type, char *userid_ptr, char *password_ptr, uint32_t bearer_bitmask, mipc_apn_compression_enum compression)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_apn_profile_update(NULL, NULL, sim_ps_id, result_ptr, id, plmnid_ptr, apn_ptr, apn_type, pdp_type, roaming_type, auth_type, userid_ptr, password_ptr, bearer_bitmask, compression);
}

mipc_api_result_enum mipc_apn_profile_update_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_APN_PROFILE_UPDATE_CB cb, void *cb_priv_ptr, uint32_t id, char *plmnid_ptr, char *apn_ptr, uint32_t apn_type, mipc_apn_pdp_type_enum pdp_type, mipc_apn_pdp_type_enum roaming_type, mipc_apn_auth_type_enum auth_type, char *userid_ptr, char *password_ptr, uint32_t bearer_bitmask, mipc_apn_compression_enum compression)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_apn_profile_update(cb, cb_priv_ptr, sim_ps_id, NULL , id, plmnid_ptr, apn_ptr, apn_type, pdp_type, roaming_type, auth_type, userid_ptr, password_ptr, bearer_bitmask, compression);
}

mipc_api_result_enum mipc_apn_profile_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_apn_profiles_struct_v *result_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_apn_profile_get(NULL, NULL, sim_ps_id, result_ptr);
}

mipc_api_result_enum mipc_apn_profile_get_async( mipc_sim_ps_id_enum sim_ps_id, MIPC_APN_PROFILE_GET_CB cb, void *cb_priv_ptr)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_apn_profile_get(cb, cb_priv_ptr, sim_ps_id, NULL);
}

mipc_api_result_enum mipc_apn_profile_del_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_apn_profiles_struct_v *result_ptr, uint32_t id)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_apn_profile_del(NULL, NULL, sim_ps_id, result_ptr, id);
}

mipc_api_result_enum mipc_apn_profile_del_async( mipc_sim_ps_id_enum sim_ps_id, MIPC_APN_PROFILE_DEL_CB cb, void *cb_priv_ptr, uint32_t id)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_apn_profile_del(cb, cb_priv_ptr, sim_ps_id, NULL, id);
}

mipc_api_result_enum mipc_apn_profile_register(mipc_sim_ps_id_enum sim_ps_id, MIPC_APN_PROFILE_IND_CB cb, void *cb_priv_ptr)
{
    void *callback;
    if (cb) {
        callback = (void *)mipc_apn_profile_get_config_cb;
    } else {
        callback = NULL;
    }

    if (mipc_msg_register_ind_api((mipc_msg_sim_ps_id_enum)sim_ps_id, MIPC_APN_PROFILE_CFG_IND, callback, (MIPC_API_CB)cb, cb_priv_ptr) == 0) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        return MIPC_API_RESULT_FAIL;
    }
}

