// SPDX-License-Identifier: MediaTekProprietary
/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  Copyright (c) [2020], MediaTek Inc. All rights reserved.
*  This software/firmware and related documentation ("MediaTek Software") are
*  protected under relevant copyright laws.
*
*  The information contained herein is confidential and proprietary to
*  MediaTek Inc. and/or its licensors. Except as otherwise provided in the
*  applicable licensing terms with MediaTek Inc. and/or its licensors, any
*  reproduction, modification, use or disclosure of MediaTek Software, and
*  information contained herein, in whole or in part, shall be strictly
*  prohibited.
*****************************************************************************/

#include "mipc_msg.h"
#include "mipc_msg_host.h"
#include "mipc_data_api.h"
#include "mipc_msg_tlv_api.h"
#include "mtk_log.h"

#define LOG_TAG "MIPC_DATA_API"

#define mipc_msg_address_decode(addr_len, count, type, addrs)\
do{val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, type, NULL);\
        if(NULL == val_ptr) break;\
        count = *((uint8_t*)val_ptr);\
        printf("count = %d \n", count);\
        if(count > 0){val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, type + 1, NULL);\
            if(NULL == val_ptr) break;\
            MEMCPY(addrs[0].addr, val_ptr, addr_len);\
            printf("val_ptr1 = %d \n", *(uint8_t*)val_ptr);}\
        if(count > 1 ){val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, type + 2, NULL);\
            if(NULL == val_ptr) break;\
            MEMCPY(addrs[1].addr, val_ptr, addr_len);\
            printf("val_ptr2 = %d \n", *(uint8_t*)val_ptr);}\
        if(count > 2){val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, type + 3, NULL);\
            if(NULL == val_ptr) break;\
            MEMCPY(addrs[2].addr, val_ptr, addr_len);\
            printf("val_ptr3 = %d \n", *(uint8_t*)val_ptr);}\
        if(count == 4){val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, type + 4, NULL);\
            if(NULL == val_ptr) break;\
            MEMCPY(addrs[3].addr, val_ptr, addr_len);\
            printf("val_ptr = %d \n", *(uint8_t*)val_ptr);}\
}while(0);
static mipc_api_result_enum mipc_data_call_act_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_data_call_act_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_ACT_CALL_CNF_T_ID, NULL);
        if (NULL == val_ptr) break;
        result_ptr->id = *((uint8_t*)val_ptr);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_ACT_CALL_CNF_T_APN, NULL);
        if (NULL == val_ptr) break;
        MEMCPY(result_ptr->apn, val_ptr, MIPC_MAX_APN_LEN);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_ACT_CALL_CNF_T_PDP_TYPE, NULL);
        if (NULL == val_ptr) break;
        result_ptr->pdp_type = (mipc_apn_pdp_type_enum)(*((uint8_t*)val_ptr));
        //optional ie
        mipc_msg_address_decode(4, result_ptr->v4_addr_count, MIPC_DATA_ACT_CALL_CNF_T_V4_COUNT, result_ptr->v4_addrs);
        mipc_msg_address_decode(16, result_ptr->v6_addr_count, MIPC_DATA_ACT_CALL_CNF_T_V6_COUNT, result_ptr->v6_addrs);
        mipc_msg_address_decode(4, result_ptr->dns_v4_addr_count, MIPC_DATA_ACT_CALL_CNF_T_DNS_V4_COUNT, result_ptr->dns_v4_addrs);
        mipc_msg_address_decode(16, result_ptr->dns_v6_addr_count, MIPC_DATA_ACT_CALL_CNF_T_DNS_V6_COUNT, result_ptr->dns_v6_addrs);
        mipc_msg_address_decode(4, result_ptr->pcscf_v4_addr_count, MIPC_DATA_ACT_CALL_CNF_T_PCSCF_V4_COUNT, result_ptr->pcscf_v4_addrs);
        mipc_msg_address_decode(16, result_ptr->pcscf_v6_addr_count, MIPC_DATA_ACT_CALL_CNF_T_PCSCF_V6_COUNT, result_ptr->pcscf_v6_addrs);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_ACT_CALL_CNF_T_GW_V4, NULL);
        if (val_ptr)MEMCPY(result_ptr->gw_v4_addr.addr, val_ptr, 4);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_ACT_CALL_CNF_T_GW_V6, NULL);
        if (val_ptr)MEMCPY(result_ptr->gw_v6_addr.addr, val_ptr, 16);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_ACT_CALL_CNF_T_MTU_V4, NULL);
        if (val_ptr)result_ptr->v4_mtu = *((uint32_t*)val_ptr);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_ACT_CALL_CNF_T_MTU_V6, NULL);
        if (val_ptr)result_ptr->v6_mtu = *((uint32_t*)val_ptr);

        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_ACT_CALL_CNF_T_INTERFACE_ID, NULL);
        if (NULL == val_ptr) break;
        result_ptr->interface_id = *((uint32_t*)val_ptr);
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    printf("decode result = %d \n", result);
    return result;
}

static void mipc_data_call_act_cb(mipc_msg_t *msg_ptr, MIPC_API_CB cb, void *cb_priv_ptr)
{
    mipc_data_call_act_struct *result_ptr = (mipc_data_call_act_struct *)ALLOC(sizeof(mipc_data_call_act_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_data_call_act_struct));
        mipc_data_call_act_cnf_decode(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_data_call_act(MIPC_DATA_CALL_ACT_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_data_call_act_struct *result_ptr, char *apn_ptr, mipc_apn_type_enum apn_type, mipc_apn_pdp_type_enum pdp_type, mipc_apn_pdp_type_enum roaming_type, mipc_apn_auth_type_enum auth_type, char *userid_ptr, char *password_ptr, mipc_data_fallback_type_enum ipv4v6_fallback, uint32_t bearer_bitmask)
{
    //SETP1: build MIPC message
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_DATA_ACT_CALL_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP2: add paramters (in this case, there is only one TLV parameter)
    if (apn_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_DATA_ACT_CALL_REQ_T_APN, MIPC_MAX_APN_LEN, apn_ptr);
    }
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_DATA_ACT_CALL_REQ_T_APN_TYPE, apn_type);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_DATA_ACT_CALL_REQ_T_PDP_TYPE, pdp_type);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_DATA_ACT_CALL_REQ_T_ROAMING_TYPE, roaming_type);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_DATA_ACT_CALL_REQ_T_AUTH_TYPE, auth_type);
    if (userid_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_DATA_ACT_CALL_REQ_T_USERID, MIPC_MAX_USERID_LEN, userid_ptr);
    }
    if (password_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_DATA_ACT_CALL_REQ_T_PASSWORD, MIPC_MAX_PASSWORD_LEN, password_ptr);
    }
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_DATA_ACT_CALL_REQ_T_IPV4V6_FALLBACK, ipv4v6_fallback);
    if (bearer_bitmask) {
        mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_DATA_ACT_CALL_REQ_T_BEARER_BITMASK, bearer_bitmask);
    }
    //SETP3: send to MD
    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_data_call_act_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_data_call_act_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_data_call_act_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_data_call_act_struct *result_ptr, char *apn_ptr, mipc_apn_type_enum apn_type, mipc_apn_pdp_type_enum pdp_type, mipc_apn_pdp_type_enum roaming_type, mipc_apn_auth_type_enum auth_type, char *userid_ptr, char *password_ptr, mipc_data_fallback_type_enum ipv4v6_fallback, uint32_t bearer_bitmask)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_data_call_act(NULL, NULL, sim_ps_id, result_ptr, apn_ptr, apn_type, pdp_type, roaming_type, auth_type, userid_ptr, password_ptr, ipv4v6_fallback, bearer_bitmask);
}

mipc_api_result_enum mipc_data_call_act_async( mipc_sim_ps_id_enum sim_ps_id, MIPC_DATA_CALL_ACT_CB cb, void *cb_priv_ptr, char *apn_ptr, mipc_apn_type_enum apn_type, mipc_apn_pdp_type_enum pdp_type, mipc_apn_pdp_type_enum roaming_type, mipc_apn_auth_type_enum auth_type, char *userid_ptr, char *password_ptr, mipc_data_fallback_type_enum ipv4v6_fallback, uint32_t bearer_bitmask)
{
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_data_call_act(cb, cb_priv_ptr, sim_ps_id, NULL, apn_ptr, apn_type, pdp_type, roaming_type, auth_type, userid_ptr, password_ptr, ipv4v6_fallback, bearer_bitmask);
}

mipc_api_result_enum mipc_data_call_act_register(mipc_sim_ps_id_enum sim_ps_id, MIPC_DATA_CALL_ACT_IND_CB cb, void *cb_priv_ptr)
{
    void *callback;
    if (cb) {
        callback = (void *)mipc_data_call_act_cb;
    } else {
        callback = NULL;
    }

    if (mipc_msg_register_ind_api((mipc_msg_sim_ps_id_enum)sim_ps_id, MIPC_DATA_ACT_CALL_IND, callback, (MIPC_API_CB)cb, cb_priv_ptr) == 0) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        return MIPC_API_RESULT_FAIL;
    }
};

static mipc_api_result_enum mipc_data_call_deact_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_data_call_deact_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_DEACT_CALL_CNF_T_ID, NULL);
        if (NULL == val_ptr) break;
        result_ptr->id = *((uint8_t*)val_ptr);
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static mipc_api_result_enum mipc_data_call_deact_ind_decode(mipc_msg_t *msg_cnf_ptr, mipc_data_call_deact_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        result_ptr->result_code = MIPC_RESULT_SUCCESS;

        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_DEACT_CALL_IND_T_ID, NULL);
        if (NULL == val_ptr) break;
        result_ptr->id = *((uint8_t*)val_ptr);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_DEACT_CALL_IND_T_NEW_RES, NULL);
        if (NULL == val_ptr) break;
        result_ptr->network_error = (*((uint32_t*)val_ptr));
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_data_call_deact_ind_cb(mipc_msg_t *msg_ptr, MIPC_API_CB cb, void *cb_priv_ptr)
{
    mipc_data_call_deact_struct *result_ptr = (mipc_data_call_deact_struct *)ALLOC(sizeof(mipc_data_call_deact_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_data_call_deact_struct));
        mipc_data_call_deact_ind_decode(msg_ptr, result_ptr);
    }
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);
    if (result_ptr) {
        FREE(result_ptr);
    }
}

static void mipc_data_call_deact_cnf_cb(mipc_msg_t *msg_ptr, MIPC_API_CB cb, void *cb_priv_ptr)
{
    mipc_data_call_deact_struct *result_ptr = (mipc_data_call_deact_struct *)ALLOC(sizeof(mipc_data_call_deact_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_data_call_deact_struct));
        mipc_data_call_deact_cnf_decode(msg_ptr, result_ptr);
    }
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);
    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_data_call_deact(MIPC_DATA_CALL_DEACT_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_data_call_deact_struct *result_ptr, uint8_t id)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_DATA_DEACT_CALL_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_DATA_DEACT_CALL_REQ_T_ID, id);

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_data_call_deact_cnf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_data_call_deact_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_data_call_deact_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_data_call_deact_struct *result_ptr, uint8_t id)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_data_call_deact(NULL, NULL, sim_ps_id, result_ptr, id);
}

mipc_api_result_enum mipc_data_call_deact_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_DATA_CALL_DEACT_CB cb, void *cb_priv_ptr, uint8_t id)
{
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_data_call_deact(cb, cb_priv_ptr, sim_ps_id, NULL, id);
}

mipc_api_result_enum mipc_data_call_deact_register(mipc_sim_ps_id_enum sim_ps_id, MIPC_DATA_CALL_DEACT_IND_CB cb, void *cb_priv_ptr)
{
    void *callback;
    if (cb) {
        callback = (void *)mipc_data_call_deact_ind_cb;
    } else {
        callback = NULL;
    }

    if (mipc_msg_register_ind_api((mipc_msg_sim_ps_id_enum)sim_ps_id, MIPC_DATA_DEACT_CALL_IND, callback, (MIPC_API_CB)cb, cb_priv_ptr) == 0) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        return MIPC_API_RESULT_FAIL;
    }
}

static mipc_api_result_enum mipc_data_call_get_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_data_call_get_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_GET_CALL_CNF_T_ID, NULL);
        if (NULL == val_ptr) break;
        result_ptr->id = *((uint8_t*)val_ptr);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_GET_CALL_CNF_T_APN, NULL);
        if (NULL == val_ptr) break;
        MEMCPY(result_ptr->apn, val_ptr, MIPC_MAX_APN_LEN);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_GET_CALL_CNF_T_PDP_TYPE, NULL);
        if (NULL == val_ptr) break;
        result_ptr->pdp_type = (mipc_apn_pdp_type_enum)(*((uint8_t*)val_ptr));
        //optinal ie
        mipc_msg_address_decode(4, result_ptr->v4_addr_count, MIPC_DATA_GET_CALL_CNF_T_V4_COUNT, result_ptr->v4_addrs);
        mipc_msg_address_decode(16, result_ptr->v6_addr_count, MIPC_DATA_GET_CALL_CNF_T_V6_COUNT, result_ptr->v6_addrs);
        mipc_msg_address_decode(4, result_ptr->dns_v4_addr_count, MIPC_DATA_GET_CALL_CNF_T_DNS_V4_COUNT, result_ptr->dns_v4_addrs);
        mipc_msg_address_decode(16, result_ptr->dns_v6_addr_count, MIPC_DATA_GET_CALL_CNF_T_DNS_V6_COUNT, result_ptr->dns_v6_addrs);
        mipc_msg_address_decode(4, result_ptr->pcscf_v4_addr_count, MIPC_DATA_GET_CALL_CNF_T_PCSCF_V4_COUNT, result_ptr->pcscf_v4_addrs);
        mipc_msg_address_decode(16, result_ptr->pcscf_v6_addr_count, MIPC_DATA_GET_CALL_CNF_T_PCSCF_V6_COUNT, result_ptr->pcscf_v6_addrs);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_GET_CALL_CNF_T_GW_V4, NULL);
        if (val_ptr) MEMCPY(result_ptr->gw_v4_addr.addr, val_ptr, 4);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_GET_CALL_CNF_T_GW_V6, NULL);
        if (val_ptr) MEMCPY(result_ptr->gw_v6_addr.addr, val_ptr, 16);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_GET_CALL_CNF_T_MTU_V4, NULL);
        if (val_ptr) result_ptr->v4_mtu = *((uint32_t*)val_ptr);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_GET_CALL_CNF_T_MTU_V6, NULL);
        if (val_ptr) result_ptr->v6_mtu = *((uint32_t*)val_ptr);

        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_GET_CALL_CNF_T_INTERFACE_ID, NULL);
        if (NULL == val_ptr) break;
        result_ptr->interface_id = *((uint32_t*)val_ptr);
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    printf("decode result = %d \n", result);
    return result;

}

static void mipc_data_call_get_cb(mipc_msg_t *msg_ptr, MIPC_API_CB cb, void *cb_priv_ptr)
{
    mipc_data_call_get_struct *result_ptr = (mipc_data_call_get_struct *)ALLOC(sizeof(mipc_data_call_get_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_data_call_get_struct));
        mipc_data_call_get_cnf_decode(msg_ptr, result_ptr);
    }
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);
    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_data_call_get(MIPC_DATA_CALL_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_data_call_get_struct *result_ptr, uint8_t id)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_DATA_GET_CALL_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_int8(msg_req_ptr, MIPC_DATA_GET_CALL_REQ_T_ID, id);

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_data_call_get_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_data_call_get_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_data_call_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_data_call_get_struct *result_ptr, uint8_t id)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_data_call_get(NULL, NULL, sim_ps_id, result_ptr, id);
}

mipc_api_result_enum mipc_data_call_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_DATA_CALL_GET_CB cb, void *cb_priv_ptr, uint8_t id)
{
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_data_call_get(cb, cb_priv_ptr, sim_ps_id, NULL, id);
}

static mipc_api_result_enum mipc_data_mod_call_ind_decode(mipc_msg_t *msg_cnf_ptr, mipc_data_call_act_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        result_ptr->result_code = MIPC_RESULT_SUCCESS;
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_MOD_CALL_IND_T_ID, NULL);
        if (NULL == val_ptr) break;
        result_ptr->id = *((uint8_t*)val_ptr);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_MOD_CALL_IND_T_APN, NULL);
        if (NULL == val_ptr) break;
        MEMCPY(result_ptr->apn, val_ptr, MIPC_MAX_APN_LEN);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_MOD_CALL_IND_T_PDP_TYPE, NULL);
        if (NULL == val_ptr) break;
        result_ptr->pdp_type = (mipc_apn_pdp_type_enum)(*((uint8_t*)val_ptr));
        //optional ie
        mipc_msg_address_decode(4, result_ptr->v4_addr_count, MIPC_DATA_MOD_CALL_IND_T_V4_COUNT, result_ptr->v4_addrs);
        mipc_msg_address_decode(16, result_ptr->v6_addr_count, MIPC_DATA_MOD_CALL_IND_T_V6_COUNT, result_ptr->v6_addrs);
        mipc_msg_address_decode(4, result_ptr->dns_v4_addr_count, MIPC_DATA_MOD_CALL_IND_T_DNS_V4_COUNT, result_ptr->dns_v4_addrs);
        mipc_msg_address_decode(16, result_ptr->dns_v6_addr_count, MIPC_DATA_MOD_CALL_IND_T_DNS_V6_COUNT, result_ptr->dns_v6_addrs);
        mipc_msg_address_decode(4, result_ptr->pcscf_v4_addr_count, MIPC_DATA_MOD_CALL_IND_T_PCSCF_V4_COUNT, result_ptr->pcscf_v4_addrs);
        mipc_msg_address_decode(16, result_ptr->pcscf_v6_addr_count, MIPC_DATA_MOD_CALL_IND_T_PCSCF_V6_COUNT, result_ptr->pcscf_v6_addrs);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_MOD_CALL_IND_T_GW_V4, NULL);
        if (val_ptr) MEMCPY(result_ptr->gw_v4_addr.addr, val_ptr, 4);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_MOD_CALL_IND_T_GW_V6, NULL);
        if (val_ptr) MEMCPY(result_ptr->gw_v6_addr.addr, val_ptr, 16);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_MOD_CALL_IND_T_MTU_V4, NULL);
        if (val_ptr) result_ptr->v4_mtu = *((uint32_t*)val_ptr);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_MOD_CALL_IND_T_MTU_V6, NULL);
        if (val_ptr) result_ptr->v6_mtu = *((uint32_t*)val_ptr);

        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_MOD_CALL_IND_T_INTERFACE_ID, NULL);
        if (NULL == val_ptr) break;
        result_ptr->interface_id = *((uint32_t*)val_ptr);
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    printf("decode result = %d \n", result);
    return result;
}

static void mipc_data_mod_call_ind_cb(mipc_msg_t *msg_ptr, MIPC_API_CB cb, void *cb_priv_ptr)
{
    mipc_data_call_act_struct *result_ptr = (mipc_data_call_act_struct *)ALLOC(sizeof(mipc_data_call_act_struct));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_data_call_act_struct));
        mipc_data_mod_call_ind_decode(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_data_pdp_cid_get_cnf(mipc_msg_t *msg_cnf_ptr, mipc_data_pdp_cid_struct_v *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;
    uint8_t min_cid = 0;
    uint8_t max_cid = 0;

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_GET_PDP_CID_CNF_T_MIN_CID, NULL);
        if (NULL == val_ptr) break;
        result_ptr->min = *((uint8_t*)val_ptr);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_GET_PDP_CID_CNF_T_MAX_CID, NULL); // The valuse of PS_MAX_CID in L5
        if (NULL == val_ptr) break;
        result_ptr->max = *((uint8_t*)val_ptr);

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    printf("mipc_data_pdp_cid_get_cnf result = %d \n", result);
    return result;

}

static void mipc_data_pdp_cid_get_cb(mipc_msg_t *msg_ptr, MIPC_API_CB cb, void *cb_priv_ptr)
{
    mipc_data_pdp_cid_struct_v *result_ptr = (mipc_data_pdp_cid_struct_v *)ALLOC(sizeof(mipc_data_pdp_cid_struct_v));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_data_pdp_cid_struct_v));
        mipc_data_pdp_cid_get_cnf(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_data_pdp_cid_get(MIPC_DATA_PDP_CID_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_data_pdp_cid_struct_v *result_ptr)
{
    //SETP1: build MIPC message
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_DATA_GET_PDP_CID_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_data_pdp_cid_get_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_data_pdp_cid_get_cnf(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_data_pdp_cid_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_data_pdp_cid_struct_v *result_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_data_pdp_cid_get(NULL, NULL, sim_ps_id, result_ptr);
}

mipc_api_result_enum mipc_data_pdp_cid_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_DATA_PDP_CID_GET_CB cb, void *cb_priv_ptr)
{
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_data_pdp_cid_get(cb, cb_priv_ptr, sim_ps_id, NULL);
}

mipc_api_result_enum mipc_data_call_mod_register(mipc_sim_ps_id_enum sim_ps_id, MIPC_DATA_CALL_ACT_IND_CB cb, void *cb_priv_ptr)
{
    void *callback;
    if (cb) {
        callback = (void *)mipc_data_call_act_cb;
    } else {
        callback = NULL;
    }

    if (mipc_msg_register_ind_api((mipc_msg_sim_ps_id_enum)sim_ps_id, MIPC_DATA_MOD_CALL_IND, callback, (MIPC_API_CB)cb, cb_priv_ptr) == 0) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        return MIPC_API_RESULT_FAIL;
    }
}

static mipc_api_result_enum mipc_data_pco_get_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_data_pco_info_struct_v *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;
    uint8_t count = 0;
    uint16_t list_len = 0;

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_GET_PCO_CNF_T_ID, NULL);
        if (NULL == val_ptr) break;
        result_ptr->id = *((uint8_t*)val_ptr);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_GET_PCO_CNF_T_PCO_COUNT, NULL);
        if (NULL == val_ptr) break;
        count = *((uint8_t*)val_ptr);
        if (result_ptr->pco_info_count > count) {
            result_ptr->pco_info_count = count;
        }
        if ((result_ptr->pco_info_count != 0) && ((val_ptr = (char *)mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_GET_PCO_CNF_T_PCO_LIST, &list_len)) == NULL)) break;
        MEMCPY(result_ptr->pco_info, val_ptr, result_ptr->pco_info_count * sizeof(mipc_data_pco_ie_struct4));

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    //reset  apn_list_count
    if ((result == MIPC_API_RESULT_FAIL) || (MIPC_RESULT_SUCCESS != result_ptr->result_code)) result_ptr->pco_info_count = 0;

    printf("decode result = %d \n", result);
    return result;
}

static void mipc_data_pco_get_cb(mipc_msg_t *msg_ptr, MIPC_API_CB cb, void *cb_priv_ptr)
{
    mipc_data_pco_info_struct_v *result_ptr = (mipc_data_pco_info_struct_v *)ALLOC(sizeof(mipc_data_pco_info_struct_v) + 10 * sizeof(mipc_data_pco_ie_struct4));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_data_pco_info_struct_v) + 10 * sizeof(mipc_data_pco_ie_struct4));
        result_ptr->pco_info_count = 10;
        mipc_data_pco_get_cnf_decode(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}


static mipc_api_result_enum mipc_data_pco_get(MIPC_DATA_PCO_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_data_pco_info_struct_v *result_ptr, uint8_t id)
{
    //SETP1: build MIPC message
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_DATA_GET_PCO_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP2: add paramters (in this case, there is only one TLV parameter)
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_DATA_GET_PCO_REQ_T_ID, id);
    //SETP3: send to MD
    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_data_pco_get_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_data_pco_get_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}


mipc_api_result_enum mipc_data_pco_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_data_pco_info_struct_v *result_ptr, uint8_t id)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_data_pco_get(NULL, NULL, sim_ps_id, result_ptr, id);
}

mipc_api_result_enum mipc_data_pco_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_DATA_PCO_GET_CB cb, void *cb_priv_ptr, uint8_t id)
{
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_data_pco_get(cb, cb_priv_ptr, sim_ps_id, NULL, id);
}

static mipc_api_result_enum mipc_data_pco_ind_decode(mipc_msg_t *msg_cnf_ptr, mipc_data_pco_info_struct_v *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;
    uint8_t count = 0;
    uint16_t list_len = 0;

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        result_ptr->result_code = MIPC_RESULT_SUCCESS;
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_MOD_PCO_IND_T_ID, NULL);
        if (NULL == val_ptr) break;
        result_ptr->id = *((uint8_t*)val_ptr);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_MOD_PCO_IND_T_PCO_COUNT, NULL);
        if (NULL == val_ptr) break;
        count = *((uint8_t*)val_ptr);
        if (result_ptr->pco_info_count > count) {
            result_ptr->pco_info_count = count;
        }
        if ((result_ptr->pco_info_count != 0) && ((val_ptr = (char *)mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_MOD_PCO_IND_T_PCO_LIST, &list_len)) == NULL)) break;
        MEMCPY(result_ptr->pco_info, val_ptr, result_ptr->pco_info_count * sizeof(mipc_data_pco_ie_struct4));

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    //reset  apn_list_count
    if ((result == MIPC_API_RESULT_FAIL) || (MIPC_RESULT_SUCCESS != result_ptr->result_code)) result_ptr->pco_info_count = 0;

    printf("decode result = %d \n", result);
    return result;

}

static void mipc_data_pco_ind_cb(mipc_msg_t *msg_ptr, MIPC_API_CB cb, void *cb_priv_ptr)
{
    mipc_data_pco_info_struct_v *result_ptr = (mipc_data_pco_info_struct_v *)ALLOC(sizeof(mipc_data_pco_info_struct_v) + 10 * sizeof(mipc_data_pco_ie_struct4));


    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_data_pco_info_struct_v) + 10 * sizeof(mipc_data_pco_ie_struct4));

        result_ptr->pco_info_count = 10;
        mipc_data_pco_ind_decode(msg_ptr, result_ptr);
    }
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);
    if (result_ptr) {
        FREE(result_ptr);
    }
}

mipc_api_result_enum mipc_data_pco_ind_register(mipc_sim_ps_id_enum sim_ps_id, MIPC_DATA_PCO_IND_CB cb, void *cb_priv_ptr)
{
    void *callback;
    if (cb) {
        callback = (void *)mipc_data_pco_ind_cb;
    } else {
        callback = NULL;
    }

    if (mipc_msg_register_ind_api((mipc_msg_sim_ps_id_enum)sim_ps_id, MIPC_DATA_MOD_PCO_IND, callback, (MIPC_API_CB)cb, cb_priv_ptr) == 0) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        return MIPC_API_RESULT_FAIL;
    }
}

static mipc_api_result_enum mipc_data_packet_filter_set_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_data_packet_filter_struct_v *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;
    uint8_t count = 0;
    uint16_t list_len = 0;

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_SET_PACKET_FILTER_CNF_T_ID, NULL);
        if (NULL == val_ptr) break;
        result_ptr->id = *((uint8_t*)val_ptr);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_SET_PACKET_FILTER_CNF_T_FILTER_COUNT, NULL);
        if (NULL == val_ptr) break;
        count = *((uint8_t*)val_ptr);
        if (result_ptr->filter_list_count > count) {
            result_ptr->filter_list_count = count;
        }
        if ((result_ptr->filter_list_count != 0) && ((val_ptr = (char *)mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_SET_PACKET_FILTER_CNF_T_FILTER_LIST, &list_len)) == NULL)) break;
        MEMCPY(result_ptr->filter_list, val_ptr, result_ptr->filter_list_count * sizeof(mipc_data_packet_filter_struct4));

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    //reset  apn_list_count
    if ((result == MIPC_API_RESULT_FAIL) || (MIPC_RESULT_SUCCESS != result_ptr->result_code)) result_ptr->filter_list_count = 0;

    printf("decode result = %d \n", result);
    return result;
}

static void mipc_data_packet_filter_set_cb(mipc_msg_t *msg_ptr, MIPC_API_CB cb, void *cb_priv_ptr)
{
    mipc_data_packet_filter_struct_v *result_ptr = (mipc_data_packet_filter_struct_v *)ALLOC(sizeof(mipc_data_packet_filter_struct_v) + 16 * sizeof(mipc_data_packet_filter_struct4));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_data_packet_filter_struct_v) + 16 * sizeof(mipc_data_packet_filter_struct4));
        result_ptr->filter_list_count = 16;
        mipc_data_packet_filter_set_cnf_decode(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_data_packet_filter_set(MIPC_DATA_PACKET_FILTER_SET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_data_packet_filter_struct_v *result_ptr, uint8_t id, uint8_t filter_list_count, mipc_data_packet_filter_struct4 *filter_list_ptr)
{
    //SETP1: build MIPC message
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_DATA_SET_PACKET_FILTER_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP2: add paramters (in this case, there is only one TLV parameter)
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_DATA_SET_PACKET_FILTER_REQ_T_ID, id);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_DATA_SET_PACKET_FILTER_REQ_T_FILTER_COUNT, filter_list_count);
    if (filter_list_ptr) {
        mipc_msg_add_tlv(msg_req_ptr, MIPC_DATA_SET_PACKET_FILTER_REQ_T_FILTER_LIST, filter_list_count * sizeof(mipc_data_packet_filter_struct4), filter_list_ptr);
    }

    //SETP3: send to MD
    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_data_packet_filter_set_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_data_packet_filter_set_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_data_packet_filter_set_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_data_packet_filter_struct_v *result_ptr, uint8_t id, uint8_t filter_list_count, mipc_data_packet_filter_struct4 *filter_list_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_data_packet_filter_set(NULL, NULL, sim_ps_id, result_ptr, id, filter_list_count, filter_list_ptr);
}

mipc_api_result_enum mipc_data_packet_filter_set_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_DATA_PACKET_FILTER_SET_CB cb, void *cb_priv_ptr, uint8_t id, uint8_t filter_list_count, mipc_data_packet_filter_struct4 *filter_list_ptr)
{
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_data_packet_filter_set(cb, cb_priv_ptr, sim_ps_id, NULL, id, filter_list_count, filter_list_ptr);
}

static mipc_api_result_enum mipc_data_packet_filter_get_cnf_decode(mipc_msg_t *msg_cnf_ptr, mipc_data_packet_filter_struct_v *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;
    uint8_t count = 0;
    uint16_t list_len = 0;

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    //STEP5: fill the result
    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_GET_PACKET_FILTER_CNF_T_ID, NULL);
        if (NULL == val_ptr) break;
        result_ptr->id = *((uint8_t*)val_ptr);
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_GET_PACKET_FILTER_CNF_T_FILTER_COUNT, NULL);
        if (NULL == val_ptr) break;
        count = *((uint8_t*)val_ptr);
        if (result_ptr->filter_list_count > count) {
            result_ptr->filter_list_count = count;
        }
        if ((result_ptr->filter_list_count != 0) && ((val_ptr = (char *)mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_DATA_GET_PACKET_FILTER_CNF_T_FILTER_LIST, &list_len)) == NULL)) break;
        MEMCPY(result_ptr->filter_list, val_ptr, result_ptr->filter_list_count * sizeof(mipc_data_packet_filter_struct4));

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    //reset  apn_list_count
    if ((result == MIPC_API_RESULT_FAIL) || (MIPC_RESULT_SUCCESS != result_ptr->result_code)) result_ptr->filter_list_count = 0;

    printf("decode result = %d \n", result);
    return result;
}

static void mipc_data_packet_filter_get_cb(mipc_msg_t *msg_ptr, MIPC_API_CB cb, void *cb_priv_ptr)
{
    mipc_data_packet_filter_struct_v *result_ptr = (mipc_data_packet_filter_struct_v *)ALLOC(sizeof(mipc_data_packet_filter_struct_v) + 16 * sizeof(mipc_data_packet_filter_struct4));

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_data_packet_filter_struct_v) + 16 * sizeof(mipc_data_packet_filter_struct4));
        result_ptr->filter_list_count = 16;
        mipc_data_packet_filter_get_cnf_decode(msg_ptr, result_ptr);
    }

    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);

    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_data_packet_filter_get(MIPC_DATA_PACKET_FILTER_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_data_packet_filter_struct_v *result_ptr, uint8_t id)
{
    //SETP1: build MIPC message
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_DATA_GET_PACKET_FILTER_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    //SETP2: add paramters (in this case, there is only one TLV parameter)
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_DATA_GET_PACKET_FILTER_REQ_T_ID, id);
    //SETP3: send to MD
    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_data_packet_filter_get_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_data_packet_filter_set_cnf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_data_packet_filter_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_data_packet_filter_struct_v *result_ptr, uint8_t id)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_data_packet_filter_get(NULL, NULL, sim_ps_id, result_ptr, id);
}

mipc_api_result_enum mipc_data_packet_filter_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_DATA_PACKET_FILTER_GET_CB cb, void *cb_priv_ptr, uint8_t id)
{
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_data_packet_filter_get(cb, cb_priv_ptr, sim_ps_id, NULL, id);
}

//decode fuction
static mipc_api_result_enum mipc_data_set_allow_decode(mipc_msg_t *msg_cnf_ptr, mipc_data_set_data_allow_struct_v *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_data_set_data_allow_struct_v));
    } else {
        return result;
    }

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    do {
        result_ptr->result_code = (mipc_result_enum)mipc_msg_get_val_uint32(msg_cnf_ptr, MIPC_T_RESULT, 0xFFFFFFFF);
        if (0xFFFFFFFF == result_ptr->result_code) break;
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}


static void mipc_data_set_allow_cb(mipc_msg_t *msg_ptr, MIPC_API_CB cb, void *cb_priv_ptr)
{
    mipc_data_set_data_allow_struct_v result;
    mipc_sim_ps_id_enum sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;
    MEMSET(&result, 0, sizeof(mipc_data_set_data_allow_struct_v));
    mipc_data_set_allow_decode(msg_ptr, &result);
    cb(sim_ps_id, &result, cb_priv_ptr);
}

static mipc_api_result_enum mipc_data_set_data_allow(MIPC_DATA_SET_DATA_ALLOW_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_data_set_data_allow_struct_v *result_ptr)
{
    //SETP1: build MIPC message
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_DATA_SET_DATA_ALLOW_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr = NULL;
    mipc_api_result_enum ret;

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_data_set_allow_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_data_set_allow_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_data_set_data_allow_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_data_set_data_allow_struct_v *result_ptr)
{
    return mipc_data_set_data_allow(NULL, NULL, sim_ps_id, result_ptr);
}


mipc_api_result_enum mipc_data_set_data_allow_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_DATA_SET_DATA_ALLOW_CB cb, void *cb_priv_ptr)
{
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_data_set_data_allow(cb, cb_priv_ptr, sim_ps_id, NULL);
}

//decode fuction
static mipc_api_result_enum mipc_data_set_data_config_decode(mipc_msg_t *msg_cnf_ptr, mipc_data_set_data_config_struct_v *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_data_set_data_allow_struct_v));
    } else {
        return result;
    }

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    do {
        result_ptr->result_code = (mipc_result_enum)mipc_msg_get_val_uint32(msg_cnf_ptr, MIPC_T_RESULT, 0xFFFFFFFF);
        if (0xFFFFFFFF == result_ptr->result_code) break;
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_data_set_data_config_cb(mipc_msg_t *msg_ptr, MIPC_API_CB cb, void *cb_priv_ptr)
{
    mipc_data_set_data_config_struct_v result;
    mipc_sim_ps_id_enum sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;
    MEMSET(&result, 0, sizeof(mipc_data_set_data_allow_struct_v));
    mipc_data_set_data_config_decode(msg_ptr, &result);
    cb(sim_ps_id, &result, cb_priv_ptr);
}


static mipc_api_result_enum mipc_data_set_config(mipc_sim_ps_id_enum sim_ps_id, MIPC_DATA_SET_DATA_CONFIG_CB cb, void *cb_priv_ptr, mipc_data_set_data_config_struct_v *result_ptr, enum mipc_data_config_type_const_enum mobile_data, mipc_data_config_type_const_enum data_roaming, mipc_data_config_type_const_enum volte, mipc_data_config_type_const_enum ims_test_mode, mipc_data_config_type_const_enum data_domestic_roaming, mipc_data_config_type_const_enum data_international_roaming)
{
    //SETP1: build MIPC message
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_DATA_SET_CONFIG_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr = NULL;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_DATA_SET_CONFIG_REQ_T_MOBILE_DATA, mobile_data);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_DATA_SET_CONFIG_REQ_T_DATA_ROAMING, data_roaming);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_DATA_SET_CONFIG_REQ_T_VOLTE, volte);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_DATA_SET_CONFIG_REQ_T_IMS_TEST_MODE, ims_test_mode);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_DATA_SET_CONFIG_REQ_T_DATA_DOMESTIC_ROAMING, data_domestic_roaming);
    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_DATA_SET_CONFIG_REQ_T_DATA_INTERNATIONAL_ROAMING, data_international_roaming);

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_data_set_data_config_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_data_set_data_config_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
    return ret;
    }
}


mipc_api_result_enum mipc_data_set_config_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_data_set_data_config_struct_v *result_ptr, mipc_data_config_type_const_enum mobile_data, mipc_data_config_type_const_enum data_roaming, mipc_data_config_type_const_enum volte, mipc_data_config_type_const_enum ims_test_mode, mipc_data_config_type_const_enum data_domestic_roaming, mipc_data_config_type_const_enum data_international_roaming)
{
    return mipc_data_set_config(sim_ps_id, NULL, NULL, result_ptr, mobile_data, data_roaming, volte, ims_test_mode, data_domestic_roaming, data_international_roaming);
}


mipc_api_result_enum mipc_data_set_config_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_DATA_SET_DATA_CONFIG_CB cb, void *cb_priv_ptr, mipc_data_config_type_const_enum mobile_data, mipc_data_config_type_const_enum data_roaming, mipc_data_config_type_const_enum volte, mipc_data_config_type_const_enum ims_test_mode, mipc_data_config_type_const_enum data_domestic_roaming, mipc_data_config_type_const_enum data_international_roaming)
{
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_data_set_config(sim_ps_id, cb, cb_priv_ptr, NULL, mobile_data, data_roaming, volte, ims_test_mode, data_domestic_roaming, data_international_roaming);
}

static mipc_api_result_enum mipc_data_get_retry_timer_decode(mipc_msg_t *msg_cnf_ptr, mipc_data_get_retry_timer_struct_v *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;
    mipc_data_retry_type_const_enum retry_type = mipc_data_retry_type_const_NONE;

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_data_get_retry_timer_struct_v));
    } else {
        return result;
    }

    if (msg_cnf_ptr == NULL) {
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    mtkLogD(LOG_TAG, "[%s] result_code=%d", __FUNCTION__, result_ptr->result_code);
    do {
        result_ptr->result_code = (mipc_result_enum)mipc_msg_get_val_uint32(msg_cnf_ptr, MIPC_T_RESULT, 0xFFFFFFFF);
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            break;
        }
        retry_type = mipc_data_retry_timer_cnf_get_retry_type(msg_cnf_ptr, 0);

        if (retry_type == MIPC_DATA_RETRY_TYPE_RETRY_TYPE_NO_SUGGEST) {
            mtkLogD(LOG_TAG, "[%s] no suggest", __FUNCTION__);
            result_ptr->retry_timer = -1;
        } else if (retry_type == MIPC_DATA_RETRY_TYPE_RETRY_TYPE_NO_RETRY) {
            mtkLogD(LOG_TAG, "[%s] no retry", __FUNCTION__);
            result_ptr->retry_timer = 0x7fffffff;
        } else if (retry_type == MIPC_DATA_RETRY_TYPE_RETRY_TYPE_WITH_SUGGEST) {
            result_ptr->retry_timer = mipc_data_retry_timer_cnf_get_retry_time(msg_cnf_ptr, 0);
            mtkLogD(LOG_TAG, "[%s] suggest=%d", __FUNCTION__, result_ptr->retry_timer);
            result_ptr->retry_timer = result_ptr->retry_timer * 1000;
        }

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_data_get_retry_timer_cb(mipc_msg_t *msg_ptr, MIPC_API_CB cb, void *cb_priv_ptr)
{
    mipc_data_get_retry_timer_struct_v result;
    mipc_sim_ps_id_enum sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;
    MEMSET(&result, 0, sizeof(mipc_data_get_retry_timer_struct_v));
    mipc_data_get_retry_timer_decode(msg_ptr, &result);
    cb(sim_ps_id, &result, cb_priv_ptr);
}

static mipc_api_result_enum mipc_data_get_retry_timer(mipc_sim_ps_id_enum sim_ps_id, MIPC_DATA_RETRY_TIMER_CB cb, void *cb_priv_ptr, mipc_data_get_retry_timer_struct_v *result_ptr, char* apnName)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_DATA_RETRY_TIMER_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr = NULL;
    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;

    if (apnName == NULL) {
        mipc_msg_deinit(msg_req_ptr);
        return ret;
    }
    mipc_data_retry_timer_req_add_mode(msg_req_ptr, MIPC_DATA_RETRY_MODE_QUERY_TIMER);
    mipc_data_retry_timer_req_add_apn_name(msg_req_ptr, strlen(apnName) + 1, apnName);
    mtkLogD(LOG_TAG, "[%s] mode=%d, apn=%s", __FUNCTION__, MIPC_DATA_RETRY_MODE_QUERY_TIMER, apnName);
    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_data_get_retry_timer_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_data_get_retry_timer_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_data_get_retry_timer_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_data_get_retry_timer_struct_v *result_ptr, char* apnName)
{
    return mipc_data_get_retry_timer(sim_ps_id, NULL, NULL, result_ptr, apnName);
}

mipc_api_result_enum mipc_data_get_retry_timer_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_DATA_RETRY_TIMER_CB cb, void *cb_priv_ptr, char* apnName)
{
    if (cb == NULL) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_data_get_retry_timer(sim_ps_id, cb, cb_priv_ptr, NULL, apnName);
}

