/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  Copyright (c) [2020], MediaTek Inc. All rights reserved.
*  This software/firmware and related documentation ("MediaTek Software") are
*  protected under relevant copyright laws.
*
*  The information contained herein is confidential and proprietary to
*  MediaTek Inc. and/or its licensors. Except as otherwise provided in the
*  applicable licensing terms with MediaTek Inc. and/or its licensors, any
*  reproduction, modification, use or disclosure of MediaTek Software, and
*  information contained herein, in whole or in part, shall be strictly
*  prohibited.
*****************************************************************************/

#include "mipc_msg.h"
#include "mipc_msg_host.h"
#include "mipc_stk_api.h"
#include "mipc_msg_tlv_const.h"


#define STK_TERMINAL_RESPONCE_LEN 261
#define STK_ENVELOPE_RESPONCE_LEN 261
#define STK_PAC_LEN 256

static mipc_api_result_enum mipc_stk_pac_set_decode(mipc_msg_t *msg_cnf_ptr, mipc_stk_pac_set_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;
    uint16_t pac_profile_len = 0;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_STK_SET_PAC_CNF_T_PAC_PROFILE, &pac_profile_len);

        printf("pac_profile_len:%d\n", pac_profile_len);

        if (NULL == val_ptr) break;

        for ( uint16_t i = 0; i < 256 && i < pac_profile_len; i++) {
            result_ptr->pac_profile[i] = (mipc_stk_pac_profile_enum)(*(uint8_t*)((uint8_t*)val_ptr + i));
        }

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_stk_pac_set_cb(mipc_msg_t *msg_ptr, MIPC_STK_PAC_SET_CB cb, void *cb_priv_ptr)
{
    mipc_stk_pac_set_struct *result_ptr = (mipc_stk_pac_set_struct *)ALLOC(sizeof(mipc_stk_pac_set_struct));

    MEMSET(result_ptr, 0, sizeof(mipc_stk_pac_set_struct));
    if (result_ptr) {
        mipc_stk_pac_set_decode(msg_ptr, result_ptr);
    }
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);
    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_stk_pac_set(MIPC_STK_PAC_SET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_stk_pac_set_struct *result_ptr, uint8_t *pac_bitmask_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_STK_SET_PAC_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv(msg_req_ptr, MIPC_STK_SET_PAC_REQ_T_PAC_BITMASK_PTR, 32, pac_bitmask_ptr);
    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_stk_pac_set_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_stk_pac_set_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_stk_pac_set_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_stk_pac_set_struct *result_ptr, uint8_t *pac_bitmask_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_stk_pac_set(NULL, NULL, sim_ps_id, result_ptr, pac_bitmask_ptr);
}

mipc_api_result_enum mipc_stk_pac_set_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_STK_PAC_SET_CB cb, void *cb_priv_ptr, uint8_t *pac_bitmask_ptr)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_stk_pac_set(cb, cb_priv_ptr, sim_ps_id, NULL, pac_bitmask_ptr);
}

static mipc_api_result_enum mipc_stk_pac_get_decode(mipc_msg_t *msg_cnf_ptr, mipc_stk_pac_get_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;
    uint16_t pac_profile_len = 0;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_STK_GET_PAC_CNF_T_PAC_PROFILE, &pac_profile_len);
        if (NULL == val_ptr) break;

        printf("pac_profile_len:%d\n", pac_profile_len);

        if (NULL == val_ptr) break;

        for ( uint16_t i = 0; i < 256 && i < pac_profile_len; i++) {
            result_ptr->pac_profile[i] = (mipc_stk_pac_profile_enum)(*(uint8_t*)((uint8_t*)val_ptr + i));
        }


        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_stk_pac_get_cb(mipc_msg_t *msg_ptr, MIPC_STK_PAC_GET_CB cb, void *cb_priv_ptr)
{
    mipc_stk_pac_get_struct *result_ptr = (mipc_stk_pac_get_struct *)ALLOC(sizeof(mipc_stk_pac_get_struct));

    MEMSET(result_ptr, 0, sizeof(mipc_stk_pac_get_struct));
    if (result_ptr) {
        mipc_stk_pac_get_decode(msg_ptr, result_ptr);
    }
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);
    if (result_ptr) {
        FREE(result_ptr);
    }
}

mipc_api_result_enum mipc_stk_pac_get(MIPC_STK_PAC_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_stk_pac_get_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_STK_GET_PAC_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_stk_pac_get_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_stk_pac_get_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_stk_pac_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_stk_pac_get_struct *result_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_stk_pac_get(NULL, NULL, sim_ps_id, result_ptr);
}

mipc_api_result_enum mipc_stk_pac_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_STK_PAC_GET_CB cb, void *cb_priv_ptr)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_stk_pac_get(cb, cb_priv_ptr, sim_ps_id, NULL);
}

static mipc_api_result_enum mipc_stk_terminal_decode(mipc_msg_t *msg_cnf_ptr, mipc_stk_terminal_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_STK_SEND_TERMINAL_RESPONSE_CNF_T_STATUS_WORDS, NULL);
        if (NULL == val_ptr) break;
        result_ptr->status_words = (uint16_t)(*((uint32_t*)val_ptr));
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_STK_SEND_TERMINAL_RESPONSE_CNF_T_TR_LEN, NULL);
        if (NULL == val_ptr) break;
        result_ptr->tr_apdu_len = *(uint32_t*)val_ptr;
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_STK_SEND_TERMINAL_RESPONSE_CNF_T_TR_PTR, NULL);
        if (NULL == val_ptr) break;
        MEMCPY(result_ptr->tr_ptr, val_ptr, result_ptr->tr_apdu_len);
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_stk_terminal_cb(mipc_msg_t *msg_ptr, MIPC_STK_TERMINAL_CB cb, void *cb_priv_ptr)
{
    mipc_stk_terminal_struct *result_ptr = (mipc_stk_terminal_struct *)ALLOC(sizeof(mipc_stk_terminal_struct));

    MEMSET(result_ptr, 0, sizeof(mipc_stk_terminal_struct));

    if (result_ptr) {
        mipc_stk_terminal_decode(msg_ptr, result_ptr);
    }
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);
    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_stk_terminal(MIPC_STK_TERMINAL_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_stk_terminal_struct *result_ptr, uint32_t tr_len, uint8_t *tr_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_STK_SEND_TERMINAL_RESPONSE_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_STK_SEND_TERMINAL_RESPONSE_REQ_T_TR_LEN, tr_len);
    mipc_msg_add_tlv(msg_req_ptr, MIPC_STK_SEND_TERMINAL_RESPONSE_REQ_T_TR_PTR, tr_len, tr_ptr);
    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_stk_terminal_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_stk_terminal_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_stk_terminal_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_stk_terminal_struct *result_ptr, uint32_t tr_len, uint8_t *tr_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_stk_terminal(NULL, NULL, sim_ps_id, result_ptr, tr_len, tr_ptr);
}

mipc_api_result_enum mipc_stk_terminal_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_STK_TERMINAL_CB cb, void *cb_priv_ptr, uint32_t tr_len, uint8_t *tr_ptr)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_stk_terminal(cb, cb_priv_ptr, sim_ps_id, NULL, tr_len, tr_ptr);
}

static mipc_api_result_enum mipc_stk_envelope_decode(mipc_msg_t *msg_cnf_ptr, mipc_stk_envelope_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_STK_SEND_ENVELOPE_CNF_T_STATUS_WORDS, NULL);
        if (NULL == val_ptr) break;
        result_ptr->status_words = (uint16_t)(*((uint32_t*)val_ptr));
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_stk_envelope_cb(mipc_msg_t *msg_ptr, MIPC_STK_ENVELOPE_CB cb, void *cb_priv_ptr)
{
    mipc_stk_envelope_struct *result_ptr = (mipc_stk_envelope_struct *)ALLOC(sizeof(mipc_stk_envelope_struct));

    MEMSET(result_ptr, 0, sizeof(mipc_stk_envelope_struct));

    if (result_ptr) {
        mipc_stk_envelope_decode(msg_ptr, result_ptr);
    }
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);
    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_stk_envelope(MIPC_STK_ENVELOPE_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_stk_envelope_struct *result_ptr, uint32_t envelope_len, uint8_t *envelope_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_STK_SEND_ENVELOPE_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_STK_SEND_ENVELOPE_REQ_T_ENVELOPE_LEN, envelope_len);
    mipc_msg_add_tlv(msg_req_ptr, MIPC_STK_SEND_ENVELOPE_REQ_T_ENVELOPE_PTR, (uint16_t)envelope_len, envelope_ptr);
    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_stk_envelope_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        printf("SEND ENVELOP ASYNC\n");
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        printf("SEND ENVELOP SYNC\n");
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_stk_envelope_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_stk_envelope_sync( mipc_sim_ps_id_enum sim_ps_id, mipc_stk_envelope_struct *result_ptr, uint32_t envelope_len, uint8_t *envelope_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_stk_envelope(NULL, NULL, sim_ps_id, result_ptr, envelope_len, envelope_ptr);
}

mipc_api_result_enum mipc_stk_envelope_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_STK_ENVELOPE_CB cb, void *cb_priv_ptr, uint32_t envelope_len, uint8_t *envelope_ptr)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_stk_envelope(cb, cb_priv_ptr, sim_ps_id, NULL, envelope_len, envelope_ptr);
}

static mipc_api_result_enum mipc_stk_envelope_info_get_decode(mipc_msg_t *msg_cnf_ptr, mipc_stk_envelope_info_struct *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;
    uint16_t bitmask_len = 0;
    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }
    do {
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        if (NULL == val_ptr) break;
        result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));
        //acording to MBIM spec, non-succ result should have no information buffer(9.4.5)
        if (MIPC_RESULT_SUCCESS != result_ptr->result_code) {
            result = MIPC_API_RESULT_SUCCESS;
            break;
        }
        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_STK_GET_ENVELOPE_INFO_CNF_T_ENVELOPE_BITMASK, &bitmask_len);
        if (NULL == val_ptr) break;
        if (32 >= bitmask_len) {
            MEMCPY(result_ptr->envelope_bitmask, val_ptr, bitmask_len);
        } else {
            MEMCPY(result_ptr->envelope_bitmask, val_ptr, 32);
        }
        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_stk_envelope_info_get_cb(mipc_msg_t *msg_ptr, MIPC_STK_ENVELOPE_INFO_GET_CB cb, void *cb_priv_ptr)
{
    mipc_stk_envelope_info_struct *result_ptr = (mipc_stk_envelope_info_struct *)ALLOC(sizeof(mipc_stk_envelope_info_struct));

    MEMSET(result_ptr, 0, sizeof(mipc_stk_envelope_info_struct));
    if (result_ptr) {
        mipc_stk_envelope_info_get_decode(msg_ptr, result_ptr);
    }
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);
    if (result_ptr) {
        FREE(result_ptr);
    }
}

static mipc_api_result_enum mipc_stk_envelope_info_get(MIPC_STK_ENVELOPE_INFO_GET_CB cb, void *cb_priv_ptr, mipc_sim_ps_id_enum sim_ps_id, mipc_stk_envelope_info_struct *result_ptr)
{
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_STK_GET_ENVELOPE_INFO_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;
    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_stk_envelope_info_get_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_stk_envelope_info_get_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_stk_envelope_info_get_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_stk_envelope_info_struct *result_ptr)
{
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_stk_envelope_info_get(NULL, NULL, sim_ps_id, result_ptr);
}

mipc_api_result_enum mipc_stk_envelope_info_get_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_STK_ENVELOPE_INFO_GET_CB cb, void *cb_priv_ptr)
{
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_stk_envelope_info_get(cb, cb_priv_ptr, sim_ps_id, NULL);
}

static mipc_api_result_enum mipc_stk_handle_call_setup_requested_from_sim_decode(mipc_msg_t *msg_cnf_ptr, mipc_stk_handle_call_setup_requested_from_sim_struct *result_ptr) {
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        result_ptr->result_code = (mipc_result_enum)mipc_msg_get_val_uint32(msg_cnf_ptr, MIPC_T_RESULT, 0xFFFFFFFF);
        if (0xFFFFFFFF == result_ptr->result_code) break;

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_stk_handle_call_setup_requested_from_sim_cb(mipc_msg_t *msg_ptr, MIPC_STK_HANDLE_CALL_SETUP_REQUESTED_FROM_SIM_CB cb, void *cb_priv_ptr) {
    mipc_stk_handle_call_setup_requested_from_sim_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_stk_handle_call_setup_requested_from_sim_struct));
    mipc_stk_handle_call_setup_requested_from_sim_decode(msg_ptr, &result_ptr);
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
}

static mipc_api_result_enum mipc_stk_handle_call_setup_requested_from_sim(MIPC_STK_HANDLE_CALL_SETUP_REQUESTED_FROM_SIM_CB cb,
        void *cb_priv_ptr,
        mipc_sim_ps_id_enum sim_ps_id,
        uint8_t data,
        mipc_stk_handle_call_setup_requested_from_sim_struct *result_ptr) {
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_STK_HANDLE_CALL_SETUP_FROM_SIM_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint8(msg_req_ptr, MIPC_STK_HANDLE_CALL_SETUP_FROM_SIM_REQ_T_DATA, data);

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_stk_handle_call_setup_requested_from_sim_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_stk_handle_call_setup_requested_from_sim_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_stk_handle_call_setup_requested_from_sim_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_stk_handle_call_setup_requested_from_sim_struct *result_ptr,
                 uint8_t data) {
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_stk_handle_call_setup_requested_from_sim( NULL, NULL, sim_ps_id, data, result_ptr);
}

mipc_api_result_enum mipc_stk_handle_call_setup_requested_from_sim_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_STK_HANDLE_CALL_SETUP_REQUESTED_FROM_SIM_CB cb, void *cb_priv_ptr,
        uint8_t data) {
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_stk_handle_call_setup_requested_from_sim(cb, cb_priv_ptr, sim_ps_id, data, NULL);
}

static mipc_api_result_enum mipc_stk_send_bipconf_decode(mipc_msg_t *msg_cnf_ptr, mipc_stk_send_bipconf_struct *result_ptr) {
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (msg_cnf_ptr == NULL) { //timeout
        if (result_ptr) {
            result_ptr->result_code = MIPC_RESULT_TIMEOUT;
        }
        return MIPC_API_RESULT_TIMEOUT;
    }

    do {
        result_ptr->result_code = (mipc_result_enum)mipc_msg_get_val_uint32(msg_cnf_ptr, MIPC_T_RESULT, 0xFFFFFFFF);
        if (0xFFFFFFFF == result_ptr->result_code) break;

        result = MIPC_API_RESULT_SUCCESS;
    } while (0);

    return result;
}

static void mipc_stk_send_bipconf_cb(mipc_msg_t *msg_ptr, MIPC_STK_SEND_BIPCONF_CB cb, void *cb_priv_ptr) {
    mipc_stk_send_bipconf_struct result_ptr;

    MEMSET(&result_ptr, 0, sizeof(mipc_stk_send_bipconf_struct));
    mipc_stk_send_bipconf_decode(msg_ptr, &result_ptr);
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, &result_ptr, cb_priv_ptr);
}

static mipc_api_result_enum mipc_stk_send_bipconf(MIPC_STK_SEND_BIPCONF_CB cb,
        void *cb_priv_ptr,
        mipc_sim_ps_id_enum sim_ps_id,
        uint32_t cmdNum,
        uint32_t data,
        mipc_stk_send_bipconf_struct *result_ptr) {
    mipc_msg_t *msg_req_ptr = mipc_msg_init(MIPC_STK_SEND_BIPCONF_REQ, (mipc_msg_sim_ps_id_enum)sim_ps_id);
    mipc_msg_t *msg_cnf_ptr;
    mipc_api_result_enum ret;

    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_STK_SEND_BIPCONF_REQ_T_CMD_NUM, cmdNum);
    mipc_msg_add_tlv_uint32(msg_req_ptr, MIPC_STK_SEND_BIPCONF_REQ_T_RESULT, data);

    if (cb) {
        mipc_msg_async_api(msg_req_ptr, (void *)mipc_stk_send_bipconf_cb, (MIPC_API_CB)cb, cb_priv_ptr);
        mipc_msg_deinit(msg_req_ptr);
        return MIPC_API_RESULT_SUCCESS;
    } else {
        msg_cnf_ptr = mipc_msg_sync_timeout(msg_req_ptr);
        mipc_msg_deinit(msg_req_ptr);
        ret = mipc_stk_send_bipconf_decode(msg_cnf_ptr, result_ptr);
        mipc_msg_deinit(msg_cnf_ptr);
        return ret;
    }
}

mipc_api_result_enum mipc_stk_send_bipconf_sync(mipc_sim_ps_id_enum sim_ps_id, mipc_stk_send_bipconf_struct *result_ptr,
        uint32_t cmdNum, uint32_t data) {
    if (NULL == result_ptr) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_stk_send_bipconf( NULL, NULL, sim_ps_id, cmdNum, data, result_ptr);
}

mipc_api_result_enum mipc_stk_send_bipconf_async(mipc_sim_ps_id_enum sim_ps_id, MIPC_STK_SEND_BIPCONF_CB cb, void *cb_priv_ptr,
        uint32_t cmdNum, uint32_t data) {
    if (NULL == cb) {
        return MIPC_API_RESULT_FAIL;
    }
    return mipc_stk_send_bipconf(cb, cb_priv_ptr, sim_ps_id, cmdNum, data, NULL);
}

static mipc_api_result_enum mipc_stk_pco_ind_decode(mipc_msg_t *msg_cnf_ptr, mipc_stk_pac_ind_struct_v *result_ptr)
{
    void* val_ptr;
    mipc_api_result_enum result = MIPC_API_RESULT_FAIL;

    if (result_ptr) {
        MEMSET(result_ptr, 0, sizeof(mipc_stk_pac_ind_struct_v));
    }
    /*
        if (msg_cnf_ptr == NULL) {
            if (result_ptr) {
                result_ptr->result_code = MIPC_RESULT_TIMEOUT;
            }
            return MIPC_API_RESULT_TIMEOUT;
        }*/
    do {
        if (NULL == result_ptr) break;
        //val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_T_RESULT, NULL);
        //if (NULL == val_ptr) break;
        //result_ptr->result_code = (mipc_result_enum)(*((uint32_t*)val_ptr));

        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_STK_PAC_IND_T_PAC_TYPE, NULL);
        if (NULL == val_ptr) break;
        result_ptr->pac_type = (mipc_stk_pac_type_enum)(*((uint8_t*)val_ptr));

        val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_STK_PAC_IND_T_PAC_LEN, NULL);
        if (NULL == val_ptr) break;
        result_ptr->pac_len = *((uint16_t*)val_ptr);

        if ( result_ptr->pac_len <= 0) {
            result = MIPC_API_RESULT_SUCCESS;

        } else {
            val_ptr = mipc_msg_get_val_ptr(msg_cnf_ptr, MIPC_STK_PAC_IND_T_PAC, NULL);
            if (NULL == val_ptr) break;

            MEMCPY(result_ptr->pac, val_ptr, result_ptr->pac_len >= STK_PAC_LEN ? STK_PAC_LEN : result_ptr->pac_len);
            result = MIPC_API_RESULT_SUCCESS;
        }

    } while (0);
    return result;

}

static void mipc_stk_pac_ind_cb(mipc_msg_t *msg_ptr, MIPC_API_CB cb, void *cb_priv_ptr)
{
    mipc_stk_pac_ind_struct_v *result_ptr = (mipc_stk_pac_ind_struct_v *)ALLOC(sizeof(mipc_stk_pac_ind_struct_v));
    if (result_ptr) {
        mipc_stk_pco_ind_decode(msg_ptr, result_ptr);
    }
    cb((mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id, result_ptr, cb_priv_ptr);
    if (result_ptr) {
        FREE(result_ptr);
    }
}

mipc_api_result_enum mipc_stk_pac_ind_register(mipc_sim_ps_id_enum sim_ps_id, MIPC_STK_PAC_IND_CB cb, void *cb_priv_ptr)
{
    void *callback;
    if (cb) {
        callback = (void *)mipc_stk_pac_ind_cb;
    } else {
        callback = NULL;
    }

    if (mipc_msg_register_ind_api((mipc_msg_sim_ps_id_enum)sim_ps_id, MIPC_STK_PAC_IND, callback, (MIPC_API_CB)cb, cb_priv_ptr) == 0) {
        return MIPC_API_RESULT_SUCCESS;
    } else {
        return MIPC_API_RESULT_FAIL;
    }
}
