#ifndef TElEMATICS_LOG_H
#define TElEMATICS_LOG_H

#include <stdint.h>
#include <stddef.h>
#include <stdarg.h>

#ifdef __cplusplus
extern "C" {
#endif

/**
 * Represents the logging level.
 */
enum {
    kLogPriorityUnknown = 0,
    kLogPriorityDefault,
    kLogPriorityVerbose,
    kLogPriorityDebug,
    kLogPriorityInfo,
    kLogPriorityWarn,
    kLogPriorityError,
    kLogPriorityFatal,
    kLogPrioritySilent
};

enum {
    kLogIdMin = 0,

    kLogIdMain = 0,
    kLogIdRadio = 1,
    kLogIdEvents = 2,
    kLogIdSystem = 3,
    kLogIdCrash = 4,

    kLogIdMax
};

int __android_log_buf_print(int id, int prio, const char *tag, const char *text, ...);

void __android_log_assert(const char *cond, const char *tag, const char *fmt, ...);

#ifdef __cplusplus
}
#endif

#endif /* TElEMATICS_LOG_H */
