#ifndef RP_NW_ADAPTER
#define RP_NW_ADAPTER

#include <utils/Looper.h>
#include <utils/Thread.h>
#include <utils/RefBase.h>

#ifdef __cplusplus
extern "C" {
#endif
#include "mipc_nw_api.h"
#ifdef __cplusplus
}
#endif

using namespace std;
using ::android::Looper;
using ::android::Thread;
using ::android::MessageHandler;
using ::android::Message;
using ::android::sp;
using ::android::Condition;
using ::android::Mutex;

using ::android::RefBase;
struct ResponseResult {
    bool isSuccess;
    int netId;
};

class RpNwAdapter : public RefBase {
public:
    static RpNwAdapter* sInstance;
    static RpNwAdapter *getInstance();
    static void closeInstance();
    void test(MIPC_NW_SIGNAL_STATE_GET_CB cb,void *privateData);

    class ResponseHandleThread: public Thread {
    public:
        ResponseHandleThread(RpNwAdapter* NwAdapter);
        virtual ~ResponseHandleThread();
        sp<Looper> getLooper();

    protected:
        RpNwAdapter* mAdapter;
        virtual bool threadLoop();
    private:
        sp<Looper> m_looper;
    };
    class ResponseMessage: public RefBase {
    public:
        ResponseMessage();
        virtual ~ResponseMessage() {if(mResponseResult != NULL) {
            delete mResponseResult;
            mResponseResult = NULL;
        }};

    public:
        int mToken;
        int mMsgType;
        void* mPrivateData;
        MIPC_NW_SIGNAL_STATE_GET_CB mCb;
        ResponseResult* mResponseResult;
    };

    class ResponseHandler: public MessageHandler {
    public:
        ResponseHandler(RpNwAdapter* NwAdapter);
        virtual ~ResponseHandler() {};

    public:
        void handleMessage(const Message& message);
        // Response message reference
        sp<ResponseMessage> mMsg;
        // dummy message that makes handler happy
        Message m_dummyMsg;
    private:
        RpNwAdapter* mAdapter;
    };

    sp<ResponseHandler> sendMessage(sp<ResponseMessage> msg, int delayms);

    void responseConditionWait();
    void responseConditionSignal();

    sp<ResponseHandleThread> mResponseHandleThread;
    sp<ResponseHandler> mResponseHandler;

private:
    RpNwAdapter();
    virtual ~RpNwAdapter();

    void init();
    void deInit();


    Mutex m_RespMutex;
    Condition m_RespCondition;

};
#endif  // RP_NW_ADAPTER
