/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2010. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */
/*
 * File name:  rfx.cpp
 * Author: Jun Liu (MTK80064)
 * Description:
 * Implement interfaces to initialize RIL Proxy framework and enqueue messages from
 * external modules
 */


/*****************************************************************************
 * Include
 *****************************************************************************/

#include "Rfx.h"
#include "RfxMainThread.h"
#include "RfxDispatchThread.h"
#include "RfxLog.h"

#include <rfx_properties.h>
#include <telephony/mtk_ril_request_info.h>


/*****************************************************************************
 * Implementation
 *****************************************************************************/
RfxDispatchThread *dispatchThread;

#define LOG_TAG "RFX"
void rfx_init(void) {
    RfxMainThread::init();
    dispatchThread = RfxDispatchThread::init();
}

void rfx_enqueue_request_message(int request, Parcel *parcel, RIL_Token t,
        RIL_SOCKET_ID socket_id) {
    dispatchThread->enqueueRequestMessage(request, parcel, t, socket_id);
}

void rfx_enqueue_response_message(Parcel *parcel, RIL_Token t,
        RIL_SOCKET_ID socket_id, int error) {
    android::RequestInfo *requestInfo = (android::RequestInfo *)t;
    dispatchThread->enqueueResponseMessage(parcel, requestInfo->subtoken, socket_id, error);
}

void rfx_enqueue_urc_message(int32_t urcId, Parcel *parcel,
        RIL_SOCKET_ID socket_id, int error) {
    dispatchThread->enqueueUrcMessage(urcId, parcel, socket_id, error);
}

#if defined(MODE_DSSS)
int rfx_get_disabled_sim(void) 
{
    char property_value[20] = {0};
    int value;
    rfx_property_get("persist.radio.dsss.sim.disable", property_value, "2");
    value = atoi(property_value);
    RLOGD("[rfx_get_disabled_sim]property:%s = %d", "persist.radio.dsss.sim.disable", value);
    return value;
}
#endif

int rfx_check_if_DSSS_IC(void) {
    char property_value[20] = {0};
    rfx_property_get("modem.segment.code", property_value, "");
    RLOGD("[rfx_check_if_DSSS_IC]modem.segment.code = %s", property_value);
    if(strstr(property_value, "dsss")) {
        return 1;
    }
    return 0;
}

int rfx_get_data_allowed_slotid(void) {
    int allowed_data_slotid = 0;
    char property_value[20] = {0};
#if !defined(ANDROID_MULTI_SIM) //Single SIM
    allowed_data_slotid = 0;
#else//Multi-SIM
#if defined(MODE_DSSS) //DSSS
    allowed_data_slotid = (2==rfx_get_disabled_sim())? 0:1;
#else //DSDS
    rfx_property_get("persist.vendor.radio.data.sim", property_value, "1");
    allowed_data_slotid = atoi(property_value)-1;
#endif
    RLOGD("[rfx_get_data_allowed_slotid]data allowed SIM is %d,", allowed_data_slotid);
    return allowed_data_slotid;
#endif
}
