//SPDX-License-Identifier: MediaTekProprietary
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2015. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

/*****************************************************************************
 * Include
 *****************************************************************************/

#include "RpNwController.h"
#include "../ims/RpImsController.h"
#include <sys/un.h>
#include <errno.h>
#include <unistd.h>
#include <cutils/jstring.h>
#include <string>

#ifdef __cplusplus
extern "C" {
#endif
#include "mipc_nw_api.h"
#include "mipc_radio_api.h"
#ifdef __cplusplus
}
#endif

#include "RfxDispatchThread.h"
#include "Rfx.h"
#include "libmtkrilutils.h"
#include "RpUtils.h"
#include "RfxRootController.h"
#include "RilParcelUtils.h"
#include "rfx_properties.h"
#include "mipc_adapter.h"

using namespace std;

#define RFX_LOG_TAG "RpNwController"

typedef struct {
    int registration_state;
    unsigned int lac;
    unsigned long long cid;
    int radio_technology;
    int base_station_id;
    int base_station_latitude;
    int base_station_longitude;
    int css;
    int system_id;
    int network_id;
    int roaming_indicator;
    int is_in_prl;
    int default_roaming_indicator;
    int denied_reason;
    int psc;
    int network_exist;
} RIL_VOICE_REG_STATE_CACHE;

typedef struct {
    int registration_state;
    unsigned int lac;
    unsigned long long cid;
    int radio_technology;
    int denied_reason;
    int max_simultaneous_data_call;
    int tac;
    int physical_cid;
    int eci;
    int csgid;
    int tadv;
    // NR none-standalone
    int dcnr_restricted;
    int endc_sib;
    int endc_available;
} RIL_DATA_REG_STATE_CACHE;

typedef struct {
    int cell_data_speed;
    int max_data_bearer;
} RIL_PS_BEARER_CACHE;

#define PROPERTY_AIRPLANE_MODE "persist.vendor.radio.airplane.mode.on"
#define CARD_TYPE_NONE (0)

bool mIsNeedNotifyState[RIL_SOCKET_NUM];
RIL_VOICE_REG_STATE_CACHE urc_voice_reg_state_cache[RIL_SOCKET_NUM];
RIL_DATA_REG_STATE_CACHE urc_data_reg_state_cache[RIL_SOCKET_NUM];
RIL_PS_BEARER_CACHE ril_ps_bearer_cache;
int prefNwType[RIL_SOCKET_NUM];
int mCurPreferedNetWorkType[RIL_SOCKET_NUM];
int mPhoneMode[RIL_SOCKET_NUM];
bool mHasSetRat[RIL_SOCKET_NUM];

static const char PROPERTY_VOLTE_ENABLE[4][30] = {
    "persist.mtk.volte.enable1",
    "persist.mtk.volte.enable2",
    "persist.mtk.volte.enable3",
    "persist.mtk.volte.enable4"
};

/*****************************************************************************
 * Class RfxNwController
 * The class is created if the slot is single mode, LWG or C,
 *****************************************************************************/

RFX_IMPLEMENT_CLASS("RpNwController", RpNwController, RfxController);

RpNwController::RpNwController() {
}

RpNwController::~RpNwController() {
}

extern "C" {
unsigned int MIPC_TO_RIL_RadioTechnology(uint16_t rat)
{
    RIL_RadioTechnology uiRet = RADIO_TECH_UNKNOWN;

    /* mapping */
    switch(rat)
    {
        case 0x0001:     // GPRS
        case 0x0002:     // EDGE
            uiRet = RADIO_TECH_GSM;        // GSM
            break;
        case 0x0004:     // UMTS
        case 0x0008:     // HSDPA
        case 0x0010:     // HSUPA
        case 0x0018:     // HSDPA_UPA
        case 0x0020:     // HSDPAP
        case 0x0030:     // HSDPAP_UPA
        case 0x0040:     // HSUPAP
        case 0x0048:     // HSUPAP_DPA
        case 0x0060:     // HSPAP
        case 0x0088:     // DC_DPA
        case 0x0098:     // DC_DPA_UPA
        case 0x00a0:     // DC_HSDPAP
        case 0x00b0:     // DC_HSDPAP_UPA
        case 0x00c8:     // DC_HSUPAP_DPA
        case 0x00e0:     // DC_HSPAP
            uiRet = RADIO_TECH_UMTS;        // UMTS
            break;
        // for C2K
        case 0x0100:     // 1xRTT
            uiRet = RADIO_TECH_1xRTT;        // 1xRTT
            break;
        case 0x0200:     // HRPD
            uiRet = RADIO_TECH_EVDO_A;        // EVDO_A
            break;
        case 0x0400:     // EHRPD
            uiRet = RADIO_TECH_EHRPD;         // EHRPD
            break;
        //for LTE
        case 0x1000:     // LTE
        case 0x2000:     // LTE_CA
        case 0x4000:
            uiRet = RADIO_TECH_LTE;       // LTE
            break;
        case 0x8000:
            uiRet = RADIO_TECH_NR;
            break;
        default:
            uiRet = RADIO_TECH_UNKNOWN;        // UNKNOWN
            break;
    }

    return (unsigned int)uiRet;
}

bool isGsmOnlySim(RIL_SOCKET_ID id) {
    bool ret = false;
    int nCardType = RFX_OBJ_GET_INSTANCE(RfxRootController)->getStatusManager(id)->getIntValue(RFX_STATUS_KEY_CARD_TYPE);

    if ((nCardType == RFX_CARD_TYPE_SIM
            || nCardType == RFX_CARD_TYPE_USIM
            || nCardType == (RFX_CARD_TYPE_SIM | RFX_CARD_TYPE_ISIM)
            || nCardType == (RFX_CARD_TYPE_USIM | RFX_CARD_TYPE_ISIM)))
            //2735 don't support cdma
            //&& (!isCdmaDualModeSimCard()))
            {
        ret = true;
    }
    return ret;
}

void isNeedNotifyStateChanged(RIL_SOCKET_ID id) {
    RFX_LOG_D(RFX_LOG_TAG, "isNeedNotifyStateChanged: %d", mIsNeedNotifyState[id]);
    if (mIsNeedNotifyState[id] == true) {
        mIsNeedNotifyState[id] = false;
        rfx_enqueue_urc_message(RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED,NULL,id,RIL_E_SUCCESS);
    }
}

void updatePhoneMode(RIL_SOCKET_ID id) {
    int tech = RADIO_TECH_UNKNOWN;

    switch (mCurPreferedNetWorkType[id]) {
        case PREF_NET_TYPE_GSM_ONLY:
        case PREF_NET_TYPE_GSM_WCDMA:
        case PREF_NET_TYPE_GSM_WCDMA_AUTO:
        case PREF_NET_TYPE_LTE_GSM_WCDMA:
        case PREF_NET_TYPE_LTE_WCDMA:
        case PREF_NET_TYPE_LTE_GSM:
        case PREF_NET_TYPE_TD_SCDMA_GSM_LTE:
        case PREF_NET_TYPE_TD_SCDMA_GSM_WCDMA_LTE:
        case PREF_NET_TYPE_TD_SCDMA_GSM:
        case PREF_NET_TYPE_TD_SCDMA_GSM_WCDMA:
        case PREF_NET_TYPE_TD_SCDMA_LTE:
        case PREF_NET_TYPE_TD_SCDMA_WCDMA_LTE:
            tech = RADIO_TECH_GPRS;
            break;

        case PREF_NET_TYPE_WCDMA:
        case PREF_NET_TYPE_TD_SCDMA_ONLY:
        case PREF_NET_TYPE_TD_SCDMA_WCDMA:
            tech = RADIO_TECH_UMTS;
            break;

        //  LTE, don't change in C2K card.
        case PREF_NET_TYPE_LTE_ONLY:
        case PREF_NET_TYPE_NR_ONLY:
        case PREF_NET_TYPE_NR_LTE:
            tech = RADIO_TECH_GPRS;
            break;

        case PREF_NET_TYPE_CDMA_ONLY:
        case PREF_NET_TYPE_CDMA_EVDO_AUTO:
        case PREF_NET_TYPE_EVDO_ONLY:
            tech = RADIO_TECH_1xRTT;
            break;


        case PREF_NET_TYPE_NR_LTE_GSM_WCDMA:
        case PREF_NET_TYPE_NR_LTE_WCDMA:
        case PREF_NET_TYPE_NR_LTE_TDSCDMA:
        case PREF_NET_TYPE_NR_LTE_TDSCDMA_GSM:
        case PREF_NET_TYPE_NR_LTE_TDSCDMA_GSM_WCDMA:
        case PREF_NET_TYPE_NR_LTE_TDSCDMA_WCDMA:
            tech = RADIO_TECH_GPRS;
            break;

        case PREF_NET_TYPE_NR_LTE_CDMA_EVDO:
        case PREF_NET_TYPE_NR_LTE_CDMA_EVDO_GSM_WCDMA:
        case PREF_NET_TYPE_NR_LTE_TDSCDMA_CDMA_EVDO_GSM_WCDMA:
            tech = RADIO_TECH_GPRS;
            break;

        case PREF_NET_TYPE_TD_SCDMA_LTE_CDMA_EVDO_GSM_WCDMA:
        case PREF_NET_TYPE_TD_SCDMA_GSM_WCDMA_CDMA_EVDO_AUTO:
        case PREF_NET_TYPE_GSM_WCDMA_CDMA_EVDO_AUTO:
        case PREF_NET_TYPE_LTE_CMDA_EVDO_GSM_WCDMA:
        case PREF_NET_TYPE_CDMA_GSM:
        case PREF_NET_TYPE_CDMA_EVDO_GSM:
        case PREF_NET_TYPE_LTE_CDMA_EVDO_GSM:
        case PREF_NET_TYPE_LTE_CDMA_EVDO:
            tech = RADIO_TECH_GPRS;
            break;

        default:
            RFX_LOG_D(RFX_LOG_TAG, "[updatePhoneType] unknown Nw type: %d", mCurPreferedNetWorkType[id]);
            break;
    }

    if (tech != RADIO_TECH_UNKNOWN && mPhoneMode[id] != tech) {
        mPhoneMode[id] = tech;
        Parcel *p = new Parcel();
        if(p != NULL) {
            p->writeInt32(1);
            p->writeInt32(tech);
            rfx_enqueue_urc_message(RIL_UNSOL_VOICE_RADIO_TECH_CHANGED, p, id, RIL_E_SUCCESS);
        }
    }
}

int boundarycheck (int variable, int upperbound, int lowerbound)
{
    if (variable >= upperbound) {
        return upperbound;
    }
    else if (variable <= lowerbound) {
        return lowerbound;
    }
    return variable;
}

void mipc_unsol_nitz_time_recv_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_nw_nitz_info_struct4 *result_ptr,
    void *cb_priv_ptr
)
{
    RFX_LOG_D(RFX_LOG_TAG,"mipc_unsol_nitz_time_recv_cb\n");
    Parcel * p = NULL;
    p = new Parcel();
    RIL_Errno err = RIL_E_SUCCESS;
    char nitz_string[30] = {0};
    char tz[4] = {0};
    sprintf(tz,"%s%02d",((result_ptr->time_zone_offset_minutes > 0)?"+":"-"),result_ptr->time_zone_offset_minutes*4/60);
    sprintf(nitz_string, "%02d/%02d/%02d,%02d:%02d:%02d%s,%d",  // "yy/mm/dd,hh:mm:ss(+/-)tz[,dst]"
        (result_ptr->year)%100,
        result_ptr->month,
        result_ptr->day,
        result_ptr->hour,
        result_ptr->minute,
        result_ptr->second,
        tz,
        result_ptr->daylight_saving_offset_minutes);

    RFX_LOG_D(RFX_LOG_TAG,"tz:%d, NITZ:%s\n",result_ptr->time_zone_offset_minutes,nitz_string);
    writeStringToParcel(p, nitz_string);
    rfx_enqueue_urc_message(RIL_UNSOL_NITZ_TIME_RECEIVED, p, mipc_sim_id_to_slot_id(sim_ps_id), err);
}

static void mipc_signal_strength_ind_to_parcel(mipc_msg_t *result_ptr, Parcel * p)
{
    RIL_SignalStrength_v14 p_cur;
    memset(&p_cur, 0, sizeof(p_cur));
    mipc_nw_signal_type_const_enum type = mipc_nw_signal_ind_get_signal_type(result_ptr,mipc_nw_signal_type_const_NONE);

    RFX_LOG_D(RFX_LOG_TAG,"mipc_signal_strength_ind_to_parcel type =%d\n", type);

    switch (type) {
        case MIPC_NW_SIGNAL_TYPE_GSM: {
            mipc_nw_gsm_signal_strength_struct4 *gsm_signal = mipc_nw_signal_ind_get_gsm_signal(result_ptr, NULL);
            if(gsm_signal) {
                p_cur.GW_SignalStrength.signalStrength = gsm_signal->signal_strength;
                p_cur.GW_SignalStrength.bitErrorRate = gsm_signal->bit_error_rate;
                p_cur.GW_SignalStrength.timingAdvance = gsm_signal->timing_advance;
                RFX_LOG_D(RFX_LOG_TAG,"SIGNAL_TYPE_GSM signalStrength=%d,bitErrorRate=%d,timingAdvance=%d\n",
                    gsm_signal->signal_strength,gsm_signal->bit_error_rate,gsm_signal->timing_advance);
            }
            break;
        }
        case MIPC_NW_SIGNAL_TYPE_UMTS: {
            mipc_nw_umts_signal_strength_struct4 *utms_signal = mipc_nw_signal_ind_get_umts_signal(result_ptr, NULL);
            if(utms_signal) {
                p_cur.WCDMA_SignalStrength.signalStrength = utms_signal->signal_strength;
                p_cur.WCDMA_SignalStrength.bitErrorRate = utms_signal->bit_error_rate;
                p_cur.WCDMA_SignalStrength.rscp = utms_signal->rscp;
                p_cur.WCDMA_SignalStrength.ecno = utms_signal->ecno;
                RFX_LOG_D(RFX_LOG_TAG,"SIGNAL_TYPE_UMTS signalStrength=%d,bitErrorRate=%d,rscp=%d,ecno=%d\n",
                    utms_signal->signal_strength,utms_signal->bit_error_rate,
                    utms_signal->rscp,utms_signal->ecno);
            }
            break;
        }
        case MIPC_NW_SIGNAL_TYPE_LTE: {
            mipc_nw_lte_signal_strength_struct4 *lte_signal = mipc_nw_signal_ind_get_lte_signal(result_ptr, NULL);
            if(lte_signal) {
                p_cur.LTE_SignalStrength.signalStrength = lte_signal->signal_strength;
                p_cur.LTE_SignalStrength.rsrp = lte_signal->rsrp;
                p_cur.LTE_SignalStrength.rsrq = lte_signal->rsrq;
                p_cur.LTE_SignalStrength.rssnr = lte_signal->rssnr;
                p_cur.LTE_SignalStrength.cqi = lte_signal->cqi;
                p_cur.LTE_SignalStrength.timingAdvance = lte_signal->timing_advance;
                RFX_LOG_D(RFX_LOG_TAG,"SIGNAL_TYPE_LTE signalStrength=%d,rsrp=%d,rsrq=%d,rssnr=%d,cqi=%d,timing_advance=%d\n",
                    lte_signal->signal_strength,lte_signal->rsrp,lte_signal->rsrq,
                    lte_signal->rssnr,lte_signal->cqi,lte_signal->timing_advance);
            }
            break;
        }
        case MIPC_NW_SIGNAL_TYPE_NR: {
            mipc_nw_nr_signal_strength_struct4 *nr_signal = mipc_nw_signal_ind_get_nr_signal(result_ptr, NULL);
            if(nr_signal) {
                p_cur.NR_SignalStrength.ssRsrp = nr_signal->ss_rsrp;
                p_cur.NR_SignalStrength.ssRsrq = nr_signal->ss_rsrq;
                p_cur.NR_SignalStrength.ssSinr = nr_signal->ss_sinr;
                p_cur.NR_SignalStrength.csiRsrp = nr_signal->csi_rsrp;
                p_cur.NR_SignalStrength.csiRsrq = nr_signal->csi_rsrq;
                p_cur.NR_SignalStrength.csiSinr = nr_signal->csi_sinr;
                RFX_LOG_D(RFX_LOG_TAG,"SIGNAL_TYPE_NR ssRsrp=%d,ssRsrq=%d,ssSinr=%d,csiRsrp=%d,csiRsrq=%d,csiSinr=%d\n",
                    nr_signal->ss_rsrp,nr_signal->ss_rsrq,nr_signal->ss_sinr,
                    nr_signal->csi_rsrp,nr_signal->csi_rsrq,nr_signal->csi_sinr);
            }
            break;
        }
        case MIPC_NW_SIGNAL_TYPE_NR_NSA: {
            mipc_nw_lte_signal_strength_struct4 *lte_signal = mipc_nw_signal_ind_get_lte_signal(result_ptr, NULL);
            if(lte_signal) {
                p_cur.LTE_SignalStrength.signalStrength = lte_signal->signal_strength;
                p_cur.LTE_SignalStrength.rsrp = lte_signal->rsrp;
                p_cur.LTE_SignalStrength.rsrq = lte_signal->rsrq;
                p_cur.LTE_SignalStrength.rssnr = lte_signal->rssnr;
                p_cur.LTE_SignalStrength.cqi = lte_signal->cqi;
                p_cur.LTE_SignalStrength.timingAdvance = lte_signal->timing_advance;
                RFX_LOG_D(RFX_LOG_TAG,"SIGNAL_TYPE_NR_NSA signalStrength=%d,rsrp=%d,rsrq=%d,rssnr=%d,cqi=%d,timing_advance=%d\n",
                    lte_signal->signal_strength,lte_signal->rsrp,lte_signal->rsrq,
                    lte_signal->rssnr,lte_signal->cqi,lte_signal->timing_advance);
            } else {
                mipc_nw_nr_signal_strength_struct4 *nr_signal = mipc_nw_signal_ind_get_nr_signal(result_ptr, NULL);
                if(nr_signal) {
                    p_cur.NR_SignalStrength.ssRsrp = nr_signal->ss_rsrp;
                    p_cur.NR_SignalStrength.ssRsrq = nr_signal->ss_rsrq;
                    p_cur.NR_SignalStrength.ssSinr = nr_signal->ss_sinr;
                    p_cur.NR_SignalStrength.csiRsrp = nr_signal->csi_rsrp;
                    p_cur.NR_SignalStrength.csiRsrq = nr_signal->csi_rsrq;
                    p_cur.NR_SignalStrength.csiSinr = nr_signal->csi_sinr;
                    RFX_LOG_D(RFX_LOG_TAG,"SIGNAL_TYPE_NR_NSA ssRsrp=%d,ssRsrq=%d,ssSinr=%d,csiRsrp=%d,csiRsrq=%d,csiSinr=%d\n",
                        nr_signal->ss_rsrp,nr_signal->ss_rsrq,nr_signal->ss_sinr,
                        nr_signal->csi_rsrp,nr_signal->csi_rsrq,nr_signal->csi_sinr);
                }
            }
            break;
        }
    }

    p_cur.CDMA_SignalStrength.dbm = -1;
    p_cur.CDMA_SignalStrength.ecio = -1;
    p_cur.EVDO_SignalStrength.dbm = -1;
    p_cur.EVDO_SignalStrength.ecio = -1;
    p_cur.EVDO_SignalStrength.signalNoiseRatio = -1;
    p_cur.TD_SCDMA_SignalStrength.signalStrength = -1;
    p_cur.TD_SCDMA_SignalStrength.bitErrorRate = -1;
    p_cur.TD_SCDMA_SignalStrength.rscp = -1;

    int32_t len =  sizeof(p_cur);
    int32_t numInts = len / sizeof(int);
    p->writeInt32(numInts);
    p->writeInt32(p_cur.GW_SignalStrength.signalStrength);
    p->writeInt32(p_cur.GW_SignalStrength.bitErrorRate);
    p->writeInt32(p_cur.GW_SignalStrength.timingAdvance);
    p->writeInt32(p_cur.CDMA_SignalStrength.dbm);
    p->writeInt32(p_cur.CDMA_SignalStrength.ecio);
    p->writeInt32(p_cur.EVDO_SignalStrength.dbm);
    p->writeInt32(p_cur.EVDO_SignalStrength.ecio);
    p->writeInt32(p_cur.EVDO_SignalStrength.signalNoiseRatio);
    p->writeInt32(p_cur.LTE_SignalStrength.signalStrength);
    p->writeInt32(p_cur.LTE_SignalStrength.rsrp);
    p->writeInt32(p_cur.LTE_SignalStrength.rsrq);
    p->writeInt32(p_cur.LTE_SignalStrength.rssnr);
    p->writeInt32(p_cur.LTE_SignalStrength.cqi);
    p->writeInt32(p_cur.LTE_SignalStrength.timingAdvance);
    p->writeInt32(p_cur.TD_SCDMA_SignalStrength.signalStrength);
    p->writeInt32(p_cur.TD_SCDMA_SignalStrength.bitErrorRate);
    p->writeInt32(p_cur.TD_SCDMA_SignalStrength.rscp);
    p->writeInt32(p_cur.WCDMA_SignalStrength.signalStrength);
    p->writeInt32(p_cur.WCDMA_SignalStrength.bitErrorRate);
    p->writeInt32(p_cur.WCDMA_SignalStrength.rscp);
    p->writeInt32(p_cur.WCDMA_SignalStrength.ecno);
    p->writeInt32(p_cur.NR_SignalStrength.ssRsrp);
    p->writeInt32(p_cur.NR_SignalStrength.ssRsrq);
    p->writeInt32(p_cur.NR_SignalStrength.ssSinr);
    p->writeInt32(p_cur.NR_SignalStrength.csiRsrp);
    p->writeInt32(p_cur.NR_SignalStrength.csiRsrq);
    p->writeInt32(p_cur.NR_SignalStrength.csiSinr);
    RFX_LOG_D(RFX_LOG_TAG, "=========avail:%d,datasize:%d, numInts:%d\n", p->dataAvail(), p->dataSize(), numInts);
}

static void mipc_signal_strength_cnf_to_parcel(mipc_msg_t *result_ptr, Parcel * p)
{
    RIL_SignalStrength_v14 p_cur;
    memset(&p_cur, 0, sizeof(p_cur));
    mipc_nw_signal_type_const_enum type = mipc_nw_set_signal_cnf_get_signal_type(result_ptr,mipc_nw_signal_type_const_NONE);

    RFX_LOG_D(RFX_LOG_TAG,"mipc_signal_strength_cnf_to_parcel type =%d\n", type);

    switch (type) {
        case MIPC_NW_SIGNAL_TYPE_GSM: {
            mipc_nw_gsm_signal_strength_struct4 *gsm_signal = mipc_nw_set_signal_cnf_get_gsm_signal(result_ptr, NULL);
            if(gsm_signal) {
                p_cur.GW_SignalStrength.signalStrength = gsm_signal->signal_strength;
                p_cur.GW_SignalStrength.bitErrorRate = gsm_signal->bit_error_rate;
                p_cur.GW_SignalStrength.timingAdvance = gsm_signal->timing_advance;
            }
            break;
        }
        case MIPC_NW_SIGNAL_TYPE_UMTS: {
            mipc_nw_umts_signal_strength_struct4 *utms_signal = mipc_nw_set_signal_cnf_get_umts_signal(result_ptr, NULL);
            if(utms_signal) {
                p_cur.WCDMA_SignalStrength.signalStrength = utms_signal->signal_strength;
                p_cur.WCDMA_SignalStrength.bitErrorRate = utms_signal->bit_error_rate;
                p_cur.WCDMA_SignalStrength.rscp = utms_signal->rscp;
                p_cur.WCDMA_SignalStrength.ecno = utms_signal->ecno;
            }
            break;
        }
        case MIPC_NW_SIGNAL_TYPE_LTE: {
            mipc_nw_lte_signal_strength_struct4 *lte_signal = mipc_nw_set_signal_cnf_get_lte_signal(result_ptr, NULL);
            if(lte_signal) {
                p_cur.LTE_SignalStrength.signalStrength = lte_signal->signal_strength;
                p_cur.LTE_SignalStrength.rsrp = lte_signal->rsrp;
                p_cur.LTE_SignalStrength.rsrq = lte_signal->rsrq;
                p_cur.LTE_SignalStrength.rssnr = lte_signal->rssnr;
                p_cur.LTE_SignalStrength.cqi = lte_signal->cqi;
                p_cur.LTE_SignalStrength.timingAdvance = lte_signal->timing_advance;
            }
            break;
        }
        case MIPC_NW_SIGNAL_TYPE_NR: {
            mipc_nw_nr_signal_strength_struct4 *nr_signal = mipc_nw_set_signal_cnf_get_nr_signal(result_ptr, NULL);
            if(nr_signal) {
                p_cur.NR_SignalStrength.ssRsrp = nr_signal->ss_rsrp;
                p_cur.NR_SignalStrength.ssRsrq = nr_signal->ss_rsrq;
                p_cur.NR_SignalStrength.ssSinr = nr_signal->ss_sinr;
                p_cur.NR_SignalStrength.csiRsrp = nr_signal->csi_rsrp;
                p_cur.NR_SignalStrength.csiRsrq = nr_signal->csi_rsrq;
                p_cur.NR_SignalStrength.csiSinr = nr_signal->csi_sinr;
            }
            break;
        }
        case MIPC_NW_SIGNAL_TYPE_NR_NSA: {
            mipc_nw_lte_signal_strength_struct4 *lte_signal = mipc_nw_signal_ind_get_lte_signal(result_ptr, NULL);
            if(lte_signal) {
                p_cur.LTE_SignalStrength.signalStrength = lte_signal->signal_strength;
                p_cur.LTE_SignalStrength.rsrp = lte_signal->rsrp;
                p_cur.LTE_SignalStrength.rsrq = lte_signal->rsrq;
                p_cur.LTE_SignalStrength.rssnr = lte_signal->rssnr;
                p_cur.LTE_SignalStrength.cqi = lte_signal->cqi;
                p_cur.LTE_SignalStrength.timingAdvance = lte_signal->timing_advance;
            } else {
                mipc_nw_nr_signal_strength_struct4 *nr_signal = mipc_nw_signal_ind_get_nr_signal(result_ptr, NULL);
                if(nr_signal) {
                    p_cur.NR_SignalStrength.ssRsrp = nr_signal->ss_rsrp;
                    p_cur.NR_SignalStrength.ssRsrq = nr_signal->ss_rsrq;
                    p_cur.NR_SignalStrength.ssSinr = nr_signal->ss_sinr;
                    p_cur.NR_SignalStrength.csiRsrp = nr_signal->csi_rsrp;
                    p_cur.NR_SignalStrength.csiRsrq = nr_signal->csi_rsrq;
                    p_cur.NR_SignalStrength.csiSinr = nr_signal->csi_sinr;
                }
            }
            break;
        }
    }

    p_cur.CDMA_SignalStrength.dbm = -1;
    p_cur.CDMA_SignalStrength.ecio = -1;
    p_cur.EVDO_SignalStrength.dbm = -1;
    p_cur.EVDO_SignalStrength.ecio = -1;
    p_cur.EVDO_SignalStrength.signalNoiseRatio = -1;
    p_cur.TD_SCDMA_SignalStrength.signalStrength = -1;
    p_cur.TD_SCDMA_SignalStrength.bitErrorRate = -1;
    p_cur.TD_SCDMA_SignalStrength.rscp = -1;

    int32_t len =  sizeof(p_cur);
    int32_t numInts = len / sizeof(int);
    p->writeInt32(numInts);
    p->writeInt32(p_cur.GW_SignalStrength.signalStrength);
    p->writeInt32(p_cur.GW_SignalStrength.bitErrorRate);
    p->writeInt32(p_cur.GW_SignalStrength.timingAdvance);
    p->writeInt32(p_cur.CDMA_SignalStrength.dbm);
    p->writeInt32(p_cur.CDMA_SignalStrength.ecio);
    p->writeInt32(p_cur.EVDO_SignalStrength.dbm);
    p->writeInt32(p_cur.EVDO_SignalStrength.ecio);
    p->writeInt32(p_cur.EVDO_SignalStrength.signalNoiseRatio);
    p->writeInt32(p_cur.LTE_SignalStrength.signalStrength);
    p->writeInt32(p_cur.LTE_SignalStrength.rsrp);
    p->writeInt32(p_cur.LTE_SignalStrength.rsrq);
    p->writeInt32(p_cur.LTE_SignalStrength.rssnr);
    p->writeInt32(p_cur.LTE_SignalStrength.cqi);
    p->writeInt32(p_cur.LTE_SignalStrength.timingAdvance);
    p->writeInt32(p_cur.TD_SCDMA_SignalStrength.signalStrength);
    p->writeInt32(p_cur.TD_SCDMA_SignalStrength.bitErrorRate);
    p->writeInt32(p_cur.TD_SCDMA_SignalStrength.rscp);
    p->writeInt32(p_cur.WCDMA_SignalStrength.signalStrength);
    p->writeInt32(p_cur.WCDMA_SignalStrength.bitErrorRate);
    p->writeInt32(p_cur.WCDMA_SignalStrength.rscp);
    p->writeInt32(p_cur.WCDMA_SignalStrength.ecno);
    p->writeInt32(p_cur.NR_SignalStrength.ssRsrp);
    p->writeInt32(p_cur.NR_SignalStrength.ssRsrq);
    p->writeInt32(p_cur.NR_SignalStrength.ssSinr);
    p->writeInt32(p_cur.NR_SignalStrength.csiRsrp);
    p->writeInt32(p_cur.NR_SignalStrength.csiRsrq);
    p->writeInt32(p_cur.NR_SignalStrength.csiSinr);
    RFX_LOG_D(RFX_LOG_TAG, "=========avail:%d,datasize:%d, numInts:%d\n", p->dataAvail(), p->dataSize(), numInts);
}

void mipc_unsol_signal_strength_cb(mipc_msg_t *msg_ptr, void *cb_priv_ptr) {
    mipc_sim_ps_id_enum sim_ps_id;
    Parcel * p = NULL;

    sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;

    p = new Parcel();
    if(p == NULL) {
        RFX_LOG_E(RFX_LOG_TAG,"mipc_unsol_signal_strength_cb new parcel error!");
        return;
    }
    mipc_signal_strength_ind_to_parcel(msg_ptr, p);
    rfx_enqueue_urc_message(RIL_UNSOL_SIGNAL_STRENGTH,p,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
}

void mipc_unsol_nw_ps_ind_cb(mipc_msg_t *msg_ptr, void *cb_priv_ptr) {
    mipc_sim_ps_id_enum sim_ps_id;
    static uint8_t old_attach_state = MIPC_NW_PS_DETACH;
    uint8_t attach_state;
    mipc_nw_ps_reg_info_struct4 *reg_info;

    RFX_LOG_D(RFX_LOG_TAG,"mipc_unsol_nw_ps_ind_cb\n");
    sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;
    attach_state = mipc_nw_ps_ind_get_tach(msg_ptr, MIPC_NW_PS_DETACH);
    reg_info = mipc_nw_ps_ind_get_reg_info(msg_ptr, NULL);
    if(reg_info) {
        // response[0] = state, response[1] = mccmnc, response[2] = rat.
        Parcel *p = new Parcel();
        if(p == NULL) {
            RFX_LOG_E(RFX_LOG_TAG,"mipc_unsol_nw_ps_ind_cb new parcel error!");
        }
        string mccMncKey("");
        mccMncKey.append("vendor.ril.data.gsm_mcc_mnc");
        mccMncKey.append(to_string(mipc_sim_id_to_slot_id(sim_ps_id)));
        char value[RFX_PROPERTY_VALUE_MAX] = {0};
        int ret = 0;
        rfx_property_get(mccMncKey.c_str(), value, "");
        p->writeInt32(3);
        p->writeInt32(attach_state);
        p->writeInt32(atoi(value));
        p->writeInt32(reg_info->rat);
        RFX_LOG_D(RFX_LOG_TAG,"mipc_unsol_nw_ps_ind_cb attach_state[%d], old_attach_state[%d],mccmnc[%d-%s],rat[%d]\n",
            attach_state,old_attach_state,atoi(value),value,reg_info->rat);
        rfx_enqueue_urc_message(RIL_UNSOL_RESPONSE_PS_NETWORK_STATE_CHANGED,p,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
        isNeedNotifyStateChanged(mipc_sim_id_to_slot_id(sim_ps_id));

        if ((attach_state == MIPC_NW_PS_ATTACH) && (old_attach_state != attach_state))
        {
            RFX_LOG_D(RFX_LOG_TAG,"%s try to SET_IMS_ENABLE\n", __FUNCTION__);
            char prop_value[MTK_PROPERTY_VALUE_MAX] = { 0 };
            mtk_property_get(PROPERTY_VOLTE_ENABLE[mipc_sim_id_to_slot_id(sim_ps_id)], prop_value, "0");
            int volte_enable = atoi(prop_value);
            RIL_SOCKET_ID rid = mipc_sim_id_to_slot_id(sim_ps_id);
            Parcel *parcel = new Parcel();
            parcel->writeInt32(RIL_REQUEST_SET_IMS_ENABLE);
            parcel->writeInt32(0xffffffff);
            parcel->writeInt32(1);//count
            parcel->writeInt32(volte_enable); //1:VoLTE only, 2:VoNR only, 3: VoLTE+VoNR
            Rfx_issueLocalRequest(RIL_REQUEST_SET_IMS_ENABLE,parcel, rid);
        }
        old_attach_state = attach_state;
    }
}

void mipc_unsol_nw_cs_ind_cb(mipc_msg_t *msg_ptr, void *cb_priv_ptr) {
    mipc_sim_ps_id_enum sim_ps_id;
    RFX_LOG_D(RFX_LOG_TAG,"mipc_unsol_nw_cs_ind_cb \n");

    mipc_nw_reg_change_info_struct4 *info = NULL;
    sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;
    info = mipc_nw_cs_ind_get_info(msg_ptr,NULL);
    if(info) {
        Parcel *p = new Parcel();
        if(p == NULL) {
            RFX_LOG_E(RFX_LOG_TAG,"mipc_unsol_nw_cs_ind_cb new parcel error!");
        }
        char *responseStr[6];
        asprintf(&responseStr[0], "%d", info->stat);
        asprintf(&responseStr[1], "%d", info->lac_tac);
        asprintf(&responseStr[2], "%d", info->cell_id);
        asprintf(&responseStr[3], "%d", info->eact);
        asprintf(&responseStr[4], "%d", info->reject_cause);
        asprintf(&responseStr[5], "%d", info->nw_existence);
        p->writeInt32(6); //number of strings
        RFX_LOG_D(RFX_LOG_TAG,"mipc_unsol_nw_cs_ind_cb \
            state[%s],lac[%s],cid[%s],eact[%s],reject_cause[%s],nw_existence[%s]\n",
            responseStr[0],responseStr[1],responseStr[2],responseStr[3],responseStr[4],responseStr[5]
        );

        for (int i = 0; i < 6; i++) {
            writeStringToParcel(p,responseStr[i]);
            free(responseStr[i]);
        }
        rfx_enqueue_urc_message(RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED,p,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
        isNeedNotifyStateChanged(mipc_sim_id_to_slot_id(sim_ps_id));
    }
}


void mipc_unsol_nw_ecell_ind_cb(mipc_msg_t *msg_ptr, void *cb_priv_ptr) {
    mipc_sim_ps_id_enum sim_ps_id;
    RFX_LOG_D(RFX_LOG_TAG,"mipc_unsol_nw_ecell_ind_cb \n");
    uint32_t count = 0;
    uint32_t gsm_cell_count, utms_cell_count,lte_cell_count,nr_cell_count;

    gsm_cell_count = mipc_nw_ecell_ind_get_gsm_cell_count(msg_ptr,0);
    utms_cell_count = mipc_nw_ecell_ind_get_umts_cell_count(msg_ptr,0);
    lte_cell_count = mipc_nw_ecell_ind_get_lte_cell_count(msg_ptr,0);
    nr_cell_count = mipc_nw_ecell_ind_get_nr_cell_count(msg_ptr,0);

    count = gsm_cell_count + utms_cell_count + lte_cell_count + nr_cell_count;
    RFX_LOG_D(RFX_LOG_TAG,"mipc_unsol_nw_ecell_ind_cb count %d, \
        gsm_cell_count %d,utms_cell_count %d,lte_cell_count %d,nr_cell_count  \
        %d\n",count,gsm_cell_count,utms_cell_count,lte_cell_count,nr_cell_count);

    sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;
    if(count > 0) {
        Parcel *p = new Parcel();
        if(p == NULL) {
            RFX_LOG_E(RFX_LOG_TAG,"mipc_unsol_nw_cs_ind_cb new parcel error!");
        }
        char mcc[4] = {0};
        char mnc[4] = {0};
        p->writeInt32(count);
        if(gsm_cell_count > 0) {
             mipc_nw_gsm_cell_struct4* gsm_cell =  mipc_nw_ecell_ind_get_gsm_cell_list(msg_ptr,NULL);
             if(gsm_cell != NULL) {
                for(uint32_t i = 0; i < gsm_cell_count; i++) {
                    p->writeInt32(RIL_CELL_INFO_TYPE_GSM);
                    p->writeInt32(gsm_cell->state);
                    p->writeInt32(0);
                    p->writeInt64(0);
                    memcpy(mcc, gsm_cell->provider_id, 3);
                    memcpy(mnc, gsm_cell->provider_id + 3, 3);
                    p->writeInt32(atoi(mcc));
                    p->writeInt32(atoi(mnc));
                    p->writeInt32(gsm_cell->lac);
                    p->writeInt32(gsm_cell->cid);
                    p->writeInt32(gsm_cell->arfcn);
                    p->writeInt32(gsm_cell->base_station_id);
                    p->writeInt32(gsm_cell->rx_level);
                    p->writeInt32(gsm_cell->bitErrorRate); //bit_error_rate
                    p->writeInt32(gsm_cell->ta);
                    gsm_cell += 1;
                }
             }
        }

        if(utms_cell_count > 0) {
             mipc_nw_umts_cell_struct4* umts_cell =  mipc_nw_ecell_ind_get_umts_cell_list(msg_ptr,NULL);
             if(umts_cell != NULL) {
                for(uint32_t i = 0; i < utms_cell_count; i++) {
                    p->writeInt32(RIL_CELL_INFO_TYPE_WCDMA);
                    p->writeInt32(umts_cell->state);
                    p->writeInt32(0);
                    p->writeInt64(0);
                    memcpy(mcc, umts_cell->provider_id, 3);
                    memcpy(mnc, umts_cell->provider_id + 3, 3);

                    p->writeInt32(atoi(mcc));
                    p->writeInt32(atoi(mnc));
                    p->writeInt32(umts_cell->lac);
                    p->writeInt32(umts_cell->cid);
                    p->writeInt32(umts_cell->psc);
                    p->writeInt32(umts_cell->uarfcn);
                    p->writeInt32(umts_cell->rscp);
                    p->writeInt32(99);//bit_error_rate
                    umts_cell += 1;
                }
             }
        }

        if(lte_cell_count > 0) {
            mipc_nw_lte_cell_struct4* lte_cell = mipc_nw_ecell_ind_get_lte_cell_list(msg_ptr,NULL);
            if(lte_cell != NULL) {
                for(uint32_t i = 0; i < lte_cell_count; i++) {

                    int aosp_rsrp = 141 - lte_cell->rsrp;
                    aosp_rsrp = boundarycheck (aosp_rsrp, 140, 44);

                    int aosp_rsrq = (40 - lte_cell->rsrq) >> 1;
                    aosp_rsrq = boundarycheck (aosp_rsrq, 20, 3);

                    int aosp_cqi = lte_cell->cqi;
                    aosp_cqi = boundarycheck (aosp_cqi, 15, 0);

                    int aosp_ta = (int)(lte_cell->ta);
                    aosp_ta = boundarycheck (aosp_ta, 0x7FFFFFFE, 0);

                    RFX_LOG_D(RFX_LOG_TAG,"lte_cell_count: aosp_rsrp:%d, aosp_rsrq:%d, aosp_cqi:%d, aosp_ta:%d",
                            aosp_rsrp, aosp_rsrq, aosp_cqi, aosp_ta);
                    RFX_LOG_D(RFX_LOG_TAG,"lte_cell_count: rsrp:%d, rsrq:%d, rsrp_in_qdbm:%d, rsrq_in_qdbm:%d, rssnr:%d, cqi:%d, ta:%d",
                            lte_cell->rsrp, lte_cell->rsrq, lte_cell->rsrp_in_qdbm, lte_cell->rsrq_in_qdbm, lte_cell->rssnr, lte_cell->cqi, lte_cell->ta);

                    p->writeInt32(RIL_CELL_INFO_TYPE_LTE);
                    p->writeInt32(lte_cell->state);
                    p->writeInt32(0);
                    p->writeInt64(0);
                    memcpy(mcc, lte_cell->provider_id, 3);
                    memcpy(mnc, lte_cell->provider_id + 3, 3);
                    p->writeInt32(atoi(mcc));
                    p->writeInt32(atoi(mnc));
                    p->writeInt32(lte_cell->cid);
                    p->writeInt32(lte_cell->physical_cell_id);
                    p->writeInt32(lte_cell->tac);
                    p->writeInt32(lte_cell->earfcn);

                    /* For LTE, the ext1((rssnr)) in +ECELL is rssi, and format follows 27.007 +CSQ. alps05878992  */
                    p->writeInt32(lte_cell->rssnr); //signalStrength
                    p->writeInt32(aosp_rsrp);
                    p->writeInt32(aosp_rsrq);
                    /*For LTE, rssnr is not reported. alps05878992 */
                    p->writeInt32(0); //rssnr
                    p->writeInt32(aosp_cqi); //cqi
                    p->writeInt32(aosp_ta);
                }
            }
        }

        if(nr_cell_count > 0) {
            mipc_nw_nr_cell_struct4* nr_cell = mipc_nw_ecell_ind_get_nr_cell_list(msg_ptr,NULL);
            if(nr_cell != NULL) {
                for(uint32_t i = 0; i < nr_cell_count; i++) {

                    int aosp_nr_ssrsrp = 157 - nr_cell->rsrp;
                    aosp_nr_ssrsrp = boundarycheck (aosp_nr_ssrsrp, 140, 44);

                    int aosp_nr_ssrsrq = (87 - nr_cell->rsrq) >> 1;
                    aosp_nr_ssrsrq = boundarycheck (aosp_nr_ssrsrq, 20, 3);

                    int aosp_nr_sssinr = (nr_cell->sinr - 47) >> 1;
                    aosp_nr_sssinr = boundarycheck (aosp_nr_sssinr, 40, -23);

                    int aosp_nr_csirsrp = 157 - nr_cell->csirsrp;
                    aosp_nr_csirsrp = boundarycheck (aosp_nr_csirsrp, 140, 44);

                    int aosp_nr_csirsrq = (87 - nr_cell->csirsrq) >> 1;
                    aosp_nr_csirsrq = boundarycheck (aosp_nr_csirsrq, 20, 3);

                    int aosp_nr_csisinr = (nr_cell->csisinr - 47) >> 1;
                    aosp_nr_csisinr = boundarycheck (aosp_nr_csisinr, 40, -23);

                    RFX_LOG_D(RFX_LOG_TAG,"nr_cell_count: aosp_nr_ssrsrp:%d, aosp_nr_ssrsrq:%d, aosp_nr_sssinr:%d, \
                                    aosp_nr_csirsrp:%d, aosp_nr_csirsrq:%d, aosp_nr_csisinr:%d",
                                    aosp_nr_ssrsrp, aosp_nr_ssrsrq, aosp_nr_sssinr, aosp_nr_csirsrp, aosp_nr_csirsrq, aosp_nr_csisinr);

                    RFX_LOG_D(RFX_LOG_TAG,"nr_cell_count: nr_cell->rsrp:%d, nr_cell->rsrq:%d, nr_cell->sinr:%d, nr_cell->csirsrp:%d, nr_cell->csirsrq:%d, nr_cell->csisinr:%d",
                        nr_cell->rsrp, nr_cell->rsrq, nr_cell->sinr, nr_cell->csirsrp, nr_cell->csirsrq, nr_cell->csisinr);


                    p->writeInt32(RIL_CELL_INFO_TYPE_NR);
                    p->writeInt32(nr_cell->state);
                    p->writeInt32(0);
                    p->writeInt64(0);
                    memcpy(mcc, nr_cell->provider_id, 3);
                    memcpy(mnc, nr_cell->provider_id + 3, 3);

                    p->writeInt32(atoi(mcc));
                    p->writeInt32(atoi(mnc));
                    p->writeInt32(nr_cell->cid);
                    p->writeInt32(nr_cell->physical_cell_id);
                    p->writeInt32(nr_cell->tac);
                    p->writeInt32(nr_cell->nr_arfcn);
                    p->writeInt32(aosp_nr_ssrsrp);
                    p->writeInt32(aosp_nr_ssrsrq);
                    p->writeInt32(aosp_nr_sssinr);
                    p->writeInt32(aosp_nr_csirsrp); //csirsrp
                    p->writeInt32(aosp_nr_csirsrq); //csirsrq
                    p->writeInt32(aosp_nr_csisinr); //csisinr
                }
            }
        }

        rfx_enqueue_urc_message(RIL_UNSOL_CELL_INFO_LIST,p,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}

void mipc_unsol_nw_eons_ind_cb(mipc_msg_t *msg_ptr, void *cb_priv_ptr) {
    mipc_sim_ps_id_enum sim_ps_id;
    RFX_LOG_D(RFX_LOG_TAG,"mipc_unsol_nw_eons_ind_cb \n");
    uint32_t pnn = 0;
    uint32_t opl = 0;

    sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;
    pnn = mipc_nw_eons_ind_get_pnn(msg_ptr,0);
    opl = mipc_nw_eons_ind_get_opl(msg_ptr,0);
    RFX_LOG_D(RFX_LOG_TAG,"mipc_unsol_nw_eons_ind_cb pnn=%d, opl=%d\n");

    if (pnn == 1 && opl == 1) {
        rfx_enqueue_urc_message(RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED,NULL,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}

void mipc_unsol_nw_ciev_ind_cb(mipc_msg_t *msg_ptr, void *cb_priv_ptr) {
    mipc_sim_ps_id_enum sim_ps_id;
    uint32_t ciev_type = 0;
    RFX_LOG_D(RFX_LOG_TAG,"mipc_unsol_nw_ciev_ind_cb \n");

    sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;
    ciev_type = mipc_nw_ciev_ind_get_ciev_type(msg_ptr,0);
    if(ciev_type == 10) //CIEV 10
    {
        isNeedNotifyStateChanged(mipc_sim_id_to_slot_id(sim_ps_id));
    }
}

void mipc_unsol_nw_psbearer_ind_cb(mipc_msg_t *msg_ptr, void *cb_priv_ptr) {
    mipc_sim_ps_id_enum sim_ps_id;
    uint32_t cell_data_speed = 0;
    uint32_t max_data_bearer = 0;
    bool ret = false;

    RFX_LOG_D(RFX_LOG_TAG,"mipc_unsol_nw_psbearer_ind_cb \n");

    sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;

    cell_data_speed = mipc_nw_psbearer_ind_get_cell_data_speed_support(msg_ptr,0);
    max_data_bearer = mipc_nw_psbearer_ind_get_max_data_bearer_capability(msg_ptr,0);

    if (urc_data_reg_state_cache[mipc_sim_id_to_slot_id(sim_ps_id)].registration_state == 1 ||
            urc_data_reg_state_cache[mipc_sim_id_to_slot_id(sim_ps_id)].registration_state == 5) {
        if (cell_data_speed < 0x1000) { // 3G case
            if (max_data_bearer != ril_ps_bearer_cache.max_data_bearer &&
                    ((max_data_bearer > 3 && max_data_bearer < 18) ||
                    (ril_ps_bearer_cache.max_data_bearer > 3 &&
                    ril_ps_bearer_cache.max_data_bearer < 18))) {
                ret = true;
            }
        } else { // 4G case
            if (cell_data_speed != ril_ps_bearer_cache.cell_data_speed &&
                    (cell_data_speed > 0x1000 ||
                    ril_ps_bearer_cache.cell_data_speed > 0x1000)) {
                ret = true;
            }
        }
    }
    ril_ps_bearer_cache.max_data_bearer = max_data_bearer;
    ril_ps_bearer_cache.cell_data_speed = cell_data_speed;
    RFX_LOG_D(RFX_LOG_TAG,"mipc_unsol_nw_psbearer_ind_cb ret = %d\n", ret);

    if (ret == true) {
        isNeedNotifyStateChanged(mipc_sim_id_to_slot_id(sim_ps_id));
    }
}

void mipc_unsol_nw_egmss_ind_cb(mipc_msg_t *msg_ptr, void *cb_priv_ptr) {
    mipc_sim_ps_id_enum sim_ps_id;
    RFX_LOG_D(RFX_LOG_TAG,"mipc_unsol_nw_egmss_ind_cb \n");

    sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;
    updatePhoneMode(mipc_sim_id_to_slot_id(sim_ps_id));
}

void mipc_unsol_nw_etxpwr_ind_cb(mipc_msg_t *msg_ptr, void *cb_priv_ptr) {
    mipc_sim_ps_id_enum sim_ps_id;
    uint32_t act = 0;
    int32_t tx_power = 0;

    sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;
    act = mipc_nw_etxpwr_ind_get_act(msg_ptr,0);
    tx_power = mipc_nw_etxpwr_ind_get_tx_power(msg_ptr,0);
    RFX_LOG_D(RFX_LOG_TAG,"mipc_unsol_nw_etxpwr_ind_cb act=%d, tx_power=%d\n", act, tx_power);

    Parcel *p = new Parcel();
    if(p != NULL) {
        p->writeInt32(2);
        p->writeUint32(act);
        p->writeInt32(tx_power);
        rfx_enqueue_urc_message(RIL_UNSOL_TX_POWER, p, mipc_sim_id_to_slot_id(sim_ps_id), RIL_E_SUCCESS);

    } else {
        RFX_LOG_E(RFX_LOG_TAG,"mipc_unsol_nw_cs_ind_cb new parcel error!");
    }
}

}

void RpNwController::onInit() {
    RfxController::onInit();  // Required: invoke super class implementation

    RFX_LOG_D(RFX_LOG_TAG, "onInit");

    mIsNeedNotifyState[getSlotId()] = true;
    mCurPreferedNetWorkType[getSlotId()] = -1;
    prefNwType[getSlotId()] = -1;
    mPhoneMode[getSlotId()] = RADIO_TECH_UNKNOWN;
    mHasSetRat[getSlotId()] = false;

    const int request_id_list[] = {
            RIL_REQUEST_SIGNAL_STRENGTH,  // 19
            RIL_REQUEST_DATA_REGISTRATION_STATE, //21
            RIL_REQUEST_VOICE_REGISTRATION_STATE,
            RIL_REQUEST_QUERY_AVAILABLE_BAND_MODE,
            RIL_REQUEST_QUERY_AVAILABLE_NETWORKS,
            RIL_REQUEST_QUERY_AVAILABLE_NETWORKS_WITH_ACT,
            RIL_REQUEST_QUERY_NETWORK_SELECTION_MODE,
            RIL_REQUEST_SET_NETWORK_SELECTION_AUTOMATIC,
            RIL_REQUEST_SET_NETWORK_SELECTION_MANUAL,
            RIL_REQUEST_SET_PREFERRED_NETWORK_TYPE,
            RIL_REQUEST_GET_PREFERRED_NETWORK_TYPE,
            RIL_REQUEST_GET_NEIGHBORING_CELL_IDS,
            RIL_REQUEST_OPERATOR,
            RIL_REQUEST_SET_BAND_MODE,
            RIL_REQUEST_VOICE_RADIO_TECH,
            RIL_REQUEST_GET_CELL_INFO_LIST,
            RIL_REQUEST_SCREEN_STATE,
            RIL_REQUEST_SET_UNSOL_CELL_INFO_LIST_RATE,
            RIL_REQUEST_REPORT_AIRPLANE_MODE,
            //RIL_UNSOL_RESPONSE_VOICE_NETWORK_STATE_CHANGED,
            //RIL_UNSOL_VOICE_RADIO_TECH_CHANGED,
            //RIL_UNSOL_CELL_INFO_LIST,
     };
    mipc_nw_nitz_register(slot_id_to_mipc_sim_id(getSlotId()),mipc_unsol_nitz_time_recv_cb,NULL);
    mipc_nw_signal_state_register(slot_id_to_mipc_sim_id(getSlotId()),mipc_unsol_signal_strength_cb,NULL);
    mipc_nw_ps_register(slot_id_to_mipc_sim_id(getSlotId()),mipc_unsol_nw_ps_ind_cb,NULL);
    mipc_nw_cs_register(slot_id_to_mipc_sim_id(getSlotId()),mipc_unsol_nw_cs_ind_cb,NULL);
    mipc_nw_ecell_ind_register(slot_id_to_mipc_sim_id(getSlotId()),mipc_unsol_nw_ecell_ind_cb,NULL);
    mipc_nw_eons_ind_register(slot_id_to_mipc_sim_id(getSlotId()),mipc_unsol_nw_eons_ind_cb,NULL);
    mipc_nw_ciev_ind_register(slot_id_to_mipc_sim_id(getSlotId()),mipc_unsol_nw_ciev_ind_cb,NULL);
    mipc_nw_egmss_ind_register(slot_id_to_mipc_sim_id(getSlotId()),mipc_unsol_nw_egmss_ind_cb,NULL);
    mipc_nw_psbearer_ind_register(slot_id_to_mipc_sim_id(getSlotId()),mipc_unsol_nw_psbearer_ind_cb,NULL);
    mipc_nw_etxpwr_ind_register(slot_id_to_mipc_sim_id(getSlotId()),mipc_unsol_nw_etxpwr_ind_cb,NULL);

    // register request id list
    registerToHandleRequest(request_id_list,
            sizeof(request_id_list) / sizeof(int));

    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s register RFX_STATUS_KEY_MODEM_SIM_TASK_READY", getSlotId(), __FUNCTION__);

    getStatusManager(getSlotId())->registerStatusChangedEx(RFX_STATUS_KEY_MODEM_SIM_TASK_READY,
            RfxStatusChangeCallbackEx(this, &RpNwController::onSimTaskReady));
}

void RpNwController::onDeinit() {
    RFX_LOG_D(RFX_LOG_TAG, "onDeinit");

    RFX_LOG_D(RFX_LOG_TAG, "[%d]%s unregister RFX_STATUS_KEY_MODEM_SIM_TASK_READY", getSlotId(), __FUNCTION__);

    getStatusManager(getSlotId())->unRegisterStatusChangedEx(RFX_STATUS_KEY_MODEM_SIM_TASK_READY,
            RfxStatusChangeCallbackEx(this, &RpNwController::onSimTaskReady));

    RfxController::onDeinit();
}

bool RpNwController::onHandleRequest(const sp<RfxMessage>& message) {
    RFX_LOG_D(RFX_LOG_TAG, "Handle request %d", message->getId());
    RfxDispatchThread::addMessageToPendingQueue(message);

    switch (message->getId()) {
    case RIL_REQUEST_SIGNAL_STRENGTH:
        handleSignalStrengthRequest(message);
        break;
    case RIL_REQUEST_DATA_REGISTRATION_STATE:
        handleDataRegistrationRequest(message);
        break;
    case RIL_REQUEST_VOICE_REGISTRATION_STATE:
        handleVoiceRegistrationRequest(message);
        break;
    case RIL_REQUEST_QUERY_AVAILABLE_BAND_MODE:
        handleGetNwBandModeRequest(message);
        break;
    case RIL_REQUEST_QUERY_AVAILABLE_NETWORKS:
    case RIL_REQUEST_QUERY_AVAILABLE_NETWORKS_WITH_ACT:
        handleGetAvailableNWRequest(message);
        break;
    case RIL_REQUEST_QUERY_NETWORK_SELECTION_MODE:
        handleQueryNwSelectRequest(message);
        break;
    case RIL_REQUEST_SET_NETWORK_SELECTION_AUTOMATIC:
        handleSetNwAutoSelectRequest(message);
        break;
    case RIL_REQUEST_SET_NETWORK_SELECTION_MANUAL:
        handleSetNwManualSelectRequest(message);
        break;
    case RIL_REQUEST_SET_PREFERRED_NETWORK_TYPE:
        handleSetNwPreferNwTypeRequest(message);
        break;
    case RIL_REQUEST_GET_PREFERRED_NETWORK_TYPE:
        handleGetNwPreferNwTypeRequest(message);
        break;
    case RIL_REQUEST_GET_NEIGHBORING_CELL_IDS:
        handleGetNeighborCellInfoRequest(message);
        break;
    case RIL_REQUEST_OPERATOR:
        handleGetOperator(message);
        break;
    case RIL_REQUEST_SCREEN_STATE:
        handleScreenStateRequest(message);
        break;
    case RIL_REQUEST_SET_BAND_MODE:
        handleSetNwBandModeRequest(message);
        break;
    case RIL_REQUEST_SET_LOCATION_UPDATES:
         break;
    case RIL_REQUEST_VOICE_RADIO_TECH:
        handleGetVoiceRadioTechRequest(message);
        break;
    case RIL_REQUEST_GET_CELL_INFO_LIST:
        handleGetCellInfoRequest(message);
        break;
    case RIL_REQUEST_SET_UNSOL_CELL_INFO_LIST_RATE:
        handleSetUnsolCellInfoListRate(message);
        break;
    case RIL_REQUEST_REPORT_AIRPLANE_MODE:
        handleReportAirplaneMode(message);
        break;
    default:
        RFX_LOG_D(RFX_LOG_TAG, "unknown request, ignore!");
        break;
    }
    return true;
}

extern "C" {

void mipc_unsol_cell_info_list_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_nw_location_info_struct4 *result_ptr,
    void *cb_priv_ptr
)
{
    Parcel * p = NULL;
    p = new Parcel();
    rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
}

int get_network_cell_type(mipc_sim_ps_id_enum sim_ps_id)
{
    int cell_type;
    mipc_nw_cells_struct_v nw_cells;
    memset(&nw_cells, 0, sizeof(nw_cells));
    mipc_nw_cell_info_get_sync(sim_ps_id, &nw_cells);

    cell_type = nw_cells.cell_list[0].cell_type;
    return cell_type;
}

void mipc_signal_strength_act_cb(mipc_msg_t *msg_ptr, void *cb_priv_ptr)
{
    mipc_sim_ps_id_enum sim_ps_id;
    Parcel * p = NULL;
    mipc_result_enum result;

    sim_ps_id = (mipc_sim_ps_id_enum)msg_ptr->hdr.msg_sim_ps_id;
    result = mipc_get_result(msg_ptr);
    if (result != MIPC_RESULT_SUCCESS) {
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_GENERIC_FAILURE);
    } else {
        p = new Parcel();
        if(p == NULL) {
            RFX_LOG_E(RFX_LOG_TAG,"mipc_signal_strength_act_cb new parcel error!");
            return;
        }
        mipc_signal_strength_cnf_to_parcel(msg_ptr, p);
        rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}

static void fillCellIdentityResponse(Parcel *p,mipc_nw_cs_ps_cell_info *cell_list) {
    int cell_type = cell_list->cell_type;
    p->writeInt32(cell_type);  // jw.ren [Feature]API-190 MTK patch CR-ID AUTO00173061 -- on Jun 2 2022
    RFX_LOG_D(RFX_LOG_TAG,"write cell_type %d\n",cell_type);  // jw.ren [Feature]API-190 MTK patch CR-ID AUTO00173061 -- on Jun 2 2022
    if(MIPC_NW_CELL_TYPE_GSM == cell_type)
    {
        char mcc[4] = {0};
        char mnc[4] = {0};
        int mnclen = 2;
        memcpy(mcc, cell_list->gsm_cell.provider_id, 3);
        memcpy(mnc, cell_list->gsm_cell.provider_id + 3, 3);
        mnclen = strlen(mnc);
        p->writeInt32(atoi(mcc));
        p->writeInt32(atoi(mnc));
        p->writeInt32(mnclen);
        p->writeInt32(cell_list->gsm_cell.lac);
        p->writeInt32(cell_list->gsm_cell.cid);
        p->writeInt32(cell_list->gsm_cell.arfcn);
        p->writeInt32(cell_list->gsm_cell.base_station_id);
    } else if(MIPC_NW_CELL_TYPE_LTE == cell_type) {
        char mcc[4] = {0};
        char mnc[4] = {0};
        int mnclen = 2;
        memcpy(mcc, cell_list->lte_cell.provider_id, 3);
        memcpy(mnc, cell_list->lte_cell.provider_id + 3, 3);
        mnclen = strlen(mnc);
        p->writeInt32(atoi(mcc));
        p->writeInt32(atoi(mnc));
        p->writeInt32(mnclen);
        p->writeInt32(cell_list->lte_cell.cid);
        p->writeInt32(cell_list->lte_cell.physical_cell_id);
        p->writeInt32(cell_list->lte_cell.tac);
        p->writeInt32(cell_list->lte_cell.earfcn);
    } else if(MIPC_NW_CELL_TYPE_TD_SCDMA == cell_type) {
        p->writeInt32(cell_list->tdscdma_cell.TBD);
        p->writeInt32(cell_list->tdscdma_cell.TBD);
        p->writeInt32(cell_list->tdscdma_cell.TBD);
        p->writeInt32(cell_list->tdscdma_cell.TBD);
        p->writeInt32(cell_list->tdscdma_cell.TBD);
        p->writeInt32(cell_list->tdscdma_cell.TBD);
    } else if(MIPC_NW_CELL_TYPE_NR == cell_type) {
        char mcc[4] = {0};
        char mnc[4] = {0};
        int mnclen = 2;
        memcpy(mcc, cell_list->nr_cell.provider_id, 3);
        memcpy(mnc, cell_list->nr_cell.provider_id + 3, 3);
        mnclen = strlen(mnc);
        p->writeInt32(atoi(mcc));
        p->writeInt32(atoi(mnc));
        p->writeInt32(mnclen);
        p->writeUint64(cell_list->nr_cell.cid);  // jw.ren [Feature]API-190 MTK patch CR-ID AUTO00173061 -- on Jun 2 2022
        p->writeInt32(cell_list->nr_cell.physical_cell_id);
        p->writeInt32(cell_list->nr_cell.tac);
        p->writeInt32(cell_list->nr_cell.nr_arfcn);

        RFX_LOG_D(RFX_LOG_TAG,"MIPC_NW_CELL_TYPE_NR cid=%llu, physical_cell_id=%d, tac=%d\n",
        cell_list->nr_cell.cid, cell_list->nr_cell.physical_cell_id, cell_list->nr_cell.tac);  // jw.ren [Feature]API-190 MTK patch CR-ID AUTO00173061 -- on Jun 2 2022
    }
    else if(MIPC_NW_CELL_TYPE_UMTS == cell_type)
    {
        char mcc[4] = {0};
        char mnc[4] = {0};
        int mnclen = 2;
        memcpy(mcc, cell_list->umts_cell.provider_id, 3);
        memcpy(mnc, cell_list->umts_cell.provider_id + 3, 3);
        mnclen = strlen(mnc);
        p->writeInt32(atoi(mcc));
        p->writeInt32(atoi(mnc));
        p->writeInt32(mnclen);
        p->writeInt32(cell_list->umts_cell.lac);
        p->writeInt32(cell_list->umts_cell.cid);
        p->writeInt32(cell_list->umts_cell.psc);
        p->writeInt32(cell_list->umts_cell.uarfcn);
    }
}

void mipc_voice_registration_act_cb(mipc_sim_ps_id_enum sim_ps_id,
    mipc_nw_cs_struct *result_ptr, void *cb_priv_ptr)
{
    RFX_LOG_D(RFX_LOG_TAG,"mipc_voice_registration_act_cb result_code %d\n",result_ptr->result_code);

    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),result_ptr->result_code);
    }else {
        Parcel * p = NULL;
        p = new Parcel();
        RIL_VoiceRegistrationStateResponse p_cur;
        memset(&p_cur, 0, sizeof(p_cur));
        p_cur.regState = (RIL_RegState)result_ptr->cs_reg.stat;
        p_cur.rat = (RIL_RadioTechnology)MIPC_TO_RIL_RadioTechnology(result_ptr->cs_reg.rat);

        p_cur.cssSupported = result_ptr->cs_reg.css;
        p_cur.roamingIndicator = result_ptr->cs_reg.roaming_ind;
        p_cur.systemIsInPrl = result_ptr->cs_reg.is_in_prl;
        p_cur.defaultRoamingIndicator = result_ptr->cs_reg.def_roaming_ind;
        p_cur.reasonForDenial = result_ptr->cs_reg.reason_for_denial;
        p->writeInt32((int)p_cur.regState);
        p->writeInt32((int)p_cur.rat);
        p->writeInt32(p_cur.cssSupported);
        p->writeInt32(p_cur.roamingIndicator);
        p->writeInt32(p_cur.systemIsInPrl);
        p->writeInt32(p_cur.defaultRoamingIndicator);
        p->writeInt32(p_cur.reasonForDenial);

        fillCellIdentityResponse(p,&(result_ptr->cell_list));

        rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}


void mipc_data_registration_act_cb(mipc_sim_ps_id_enum sim_ps_id,
    mipc_nw_ps_struct *result_ptr, void *cb_priv_ptr)
{
    RFX_LOG_D(RFX_LOG_TAG,"mipc_data_registration_act_cb result_code %d\n",result_ptr->result_code);

    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),(RIL_Errno)result_ptr->result_code);
    }else {
        Parcel * p = NULL;
        p = new Parcel();
        RIL_DataRegistrationStateResponse p_cur;
        memset(&p_cur, 0, sizeof(p_cur));
        p_cur.regState = (RIL_RegState)result_ptr->ps_reg.stat;
        p_cur.rat = (RIL_RadioTechnology)MIPC_TO_RIL_RadioTechnology(result_ptr->ps_reg.rat);
        p_cur.reasonDataDenied = result_ptr->ps_reg.reason_for_denial;
        p_cur.maxDataCalls = result_ptr->ps_reg.max_data_calls;

        p->writeInt32((int)p_cur.regState);
        p->writeInt32((int)p_cur.rat);
        p->writeInt32(p_cur.reasonDataDenied);
        p->writeInt32(p_cur.maxDataCalls);
        fillCellIdentityResponse(p,&(result_ptr->cell_list));

        RFX_LOG_D(RFX_LOG_TAG,"%s regState=%d\n", __FUNCTION__, (int)p_cur.regState);

        rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}

void mipc_network_get_select_mode_cb(mipc_sim_ps_id_enum sim_ps_id,
    mipc_nw_reg_state_struct *result_ptr, void *cb_priv_ptr)
{
    RFX_LOG_D(RFX_LOG_TAG,"mipc_network_select_mode_cb result_code %d\n",result_ptr->result_code);
    //printf("result_code:%d,network_error:%d\n", result_ptr->result_code, result_ptr->network_error);

    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_RADIO_NOT_AVAILABLE);
    }else {
        Parcel * p = NULL;
        p = new Parcel();
        int mode = (int)result_ptr->reg_mode;
        p->writeInt32(1);
        p->writeInt32(mode);
        RFX_LOG_D(RFX_LOG_TAG,"mipc_network_select_mode_cb mode %d\n",mode);
        rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}

void mipc_network_set_select_mode_cb(mipc_sim_ps_id_enum sim_ps_id,
        mipc_nw_reg_state_struct *result_ptr, void *cb_priv_ptr)
{
    RFX_LOG_D(RFX_LOG_TAG,"mipc_network_select_mode_cb result_code %d\n",result_ptr->result_code);

    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_RADIO_NOT_AVAILABLE);
    }else {
        Parcel *p = NULL;
        p = new Parcel();
        rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}

void mipc_get_cell_info_cb(mipc_sim_ps_id_enum sim_ps_id,
    mipc_nw_cells_struct_v *result_ptr, void *cb_priv_ptr)
{
    RFX_LOG_D(RFX_LOG_TAG,"mipc_get_cell_info_cb result_code %d\n",result_ptr->result_code);
    RFX_LOG_D(RFX_LOG_TAG,"result_code:%d,cell_list_count:%d\n", result_ptr->result_code, result_ptr->cell_list_count);

    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),result_ptr->result_code);
    }else {
        Parcel * p = NULL;
        p = new Parcel();
        int num = result_ptr->cell_list_count;
        char mcc[4] = {0};
        char mnc[4] = {0};
        p->writeInt32(num);
        for (int i = 0 ; i < num; i++) {
            int cell_type=result_ptr->cell_list[i].cell_type;
            p->writeInt32(cell_type);
            switch(cell_type) {
                case MIPC_NW_CELL_TYPE_GSM: {
                    p->writeInt32(result_ptr->cell_list[i].u.gsm_cell.state);
                    p->writeInt32(0);
                    p->writeInt64(0);
                    memcpy(mcc, result_ptr->cell_list[i].u.gsm_cell.provider_id, 3);
                    memcpy(mnc, result_ptr->cell_list[i].u.gsm_cell.provider_id + 3, 3);
                    p->writeInt32(atoi(mcc));
                    p->writeInt32(atoi(mnc));
                    p->writeInt32(result_ptr->cell_list[i].u.gsm_cell.lac);
                    p->writeInt32(result_ptr->cell_list[i].u.gsm_cell.cid);
                    p->writeInt32(result_ptr->cell_list[i].u.gsm_cell.arfcn);
                    p->writeInt32(result_ptr->cell_list[i].u.gsm_cell.base_station_id);
                    p->writeInt32(result_ptr->cell_list[i].u.gsm_cell.rx_level);
                    p->writeInt32(result_ptr->cell_list[i].u.gsm_cell.bitErrorRate); //bit_error_rate
                    p->writeInt32(result_ptr->cell_list[i].u.gsm_cell.ta);
                    break;
                }
                case RIL_CELL_INFO_TYPE_WCDMA: {
                    p->writeInt32(result_ptr->cell_list[i].u.umts_cell.state);
                    p->writeInt32(0);
                    p->writeInt64(0);
                    memcpy(mcc, result_ptr->cell_list[i].u.umts_cell.provider_id, 3);
                    memcpy(mnc, result_ptr->cell_list[i].u.umts_cell.provider_id + 3, 3);

                    p->writeInt32(atoi(mcc));
                    p->writeInt32(atoi(mnc));
                    p->writeInt32(result_ptr->cell_list[i].u.umts_cell.lac);
                    p->writeInt32(result_ptr->cell_list[i].u.umts_cell.cid);
                    p->writeInt32(result_ptr->cell_list[i].u.umts_cell.psc);
                    p->writeInt32(result_ptr->cell_list[i].u.umts_cell.uarfcn);
                    p->writeInt32(result_ptr->cell_list[i].u.umts_cell.rscp);
                    p->writeInt32(99);//bit_error_rate
                    break;
                }
                case RIL_CELL_INFO_TYPE_LTE: {

                    int aosp_rsrp = 141 - result_ptr->cell_list[i].u.lte_cell.rsrp;
                    aosp_rsrp = boundarycheck (aosp_rsrp, 140, 44);

                    int aosp_rsrq = (40 - result_ptr->cell_list[i].u.lte_cell.rsrq) >> 1;
                    aosp_rsrq = boundarycheck (aosp_rsrq, 20, 3);

                    int aosp_cqi = result_ptr->cell_list[i].u.lte_cell.cqi;
                    aosp_cqi = boundarycheck (aosp_cqi, 15, 0);

                    int aosp_ta = (int)(result_ptr->cell_list[i].u.lte_cell.ta);
                    aosp_ta = boundarycheck (aosp_ta, 0x7FFFFFFE, 0);

                    RFX_LOG_D(RFX_LOG_TAG,"RIL_CELL_INFO_TYPE_LTE: aosp_rsrp:%d, aosp_rsrq:%d, aosp_cqi:%d, aosp_ta:%d",
                            aosp_rsrp, aosp_rsrq, aosp_cqi, aosp_ta);
                    RFX_LOG_D(RFX_LOG_TAG,"RIL_CELL_INFO_TYPE_LTE: rsrp:%d, rsrq:%d, rsrp_in_qdbm:%d, rsrq_in_qdbm:%d, rssnr:%d, cqi:%d, ta:%d",
                            result_ptr->cell_list[i].u.lte_cell.rsrp,
                            result_ptr->cell_list[i].u.lte_cell.rsrq,
                            result_ptr->cell_list[i].u.lte_cell.rsrp_in_qdbm,
                            result_ptr->cell_list[i].u.lte_cell.rsrq_in_qdbm,
                            result_ptr->cell_list[i].u.lte_cell.rssnr,
                            result_ptr->cell_list[i].u.lte_cell.cqi,
                            result_ptr->cell_list[i].u.lte_cell.ta);

                    p->writeInt32(result_ptr->cell_list[i].u.lte_cell.state);
                    p->writeInt32(0);
                    p->writeInt64(0);
                    memcpy(mcc, result_ptr->cell_list[i].u.lte_cell.provider_id, 3);
                    memcpy(mnc, result_ptr->cell_list[i].u.lte_cell.provider_id + 3, 3);

                    p->writeInt32(atoi(mcc));
                    p->writeInt32(atoi(mnc));
                    p->writeInt32(result_ptr->cell_list[i].u.lte_cell.cid);
                    p->writeInt32(result_ptr->cell_list[i].u.lte_cell.physical_cell_id);
                    p->writeInt32(result_ptr->cell_list[i].u.lte_cell.tac);
                    p->writeInt32(result_ptr->cell_list[i].u.lte_cell.earfcn);

                    /* For LTE, the ext1((rssnr)) in +ECELL is rssi, and format follows 27.007 +CSQ. alps05878992  */
                    p->writeInt32(result_ptr->cell_list[i].u.lte_cell.rssnr); //signalStrength
                    p->writeInt32(aosp_rsrp);
                    p->writeInt32(aosp_rsrq);
                    /*For LTE, rssnr is not reported. alps05878992 */
                    p->writeInt32(0); //rssnr
                    p->writeInt32(aosp_cqi); //cqi
                    p->writeInt32(aosp_ta);
                    break;
                }
                case RIL_CELL_INFO_TYPE_NR: {

                    int aosp_nr_ssrsrp = 157 - result_ptr->cell_list[i].u.nr_cell.rsrp;
                    aosp_nr_ssrsrp = boundarycheck (aosp_nr_ssrsrp, 140, 44);

                    int aosp_nr_ssrsrq = (87 - result_ptr->cell_list[i].u.nr_cell.rsrq) >> 1;
                    aosp_nr_ssrsrq = boundarycheck (aosp_nr_ssrsrq, 20, 3);

                    int aosp_nr_sssinr = (result_ptr->cell_list[i].u.nr_cell.sinr - 47) >> 1;
                    aosp_nr_sssinr = boundarycheck (aosp_nr_sssinr, 40, -23);

                    int aosp_nr_csirsrp = 157 - result_ptr->cell_list[i].u.nr_cell.csirsrp;
                    aosp_nr_csirsrp = boundarycheck (aosp_nr_csirsrp, 140, 44);

                    int aosp_nr_csirsrq = (87 - result_ptr->cell_list[i].u.nr_cell.csirsrq) >> 1;
                    aosp_nr_csirsrq = boundarycheck (aosp_nr_csirsrq, 20, 3);

                    int aosp_nr_csisinr = (result_ptr->cell_list[i].u.nr_cell.csisinr - 47) >> 1;
                    aosp_nr_csisinr = boundarycheck (aosp_nr_csisinr, 40, -23);

                    RFX_LOG_D(RFX_LOG_TAG,"RIL_CELL_INFO_TYPE_NR: aosp_nr_ssrsrp:%d, aosp_nr_ssrsrq:%d, aosp_nr_sssinr:%d, \
                                    aosp_nr_csirsrp:%d, aosp_nr_csirsrq:%d, aosp_nr_csisinr:%d",
                                    aosp_nr_ssrsrp, aosp_nr_ssrsrq, aosp_nr_sssinr, aosp_nr_csirsrp, aosp_nr_csirsrq, aosp_nr_csisinr);

                    RFX_LOG_D(RFX_LOG_TAG,"RIL_CELL_INFO_TYPE_NR: rsrp:%d, rsrq:%d, sinr:%d, csirsrp:%d, csirsrq:%d, csisinr:%d",
                        result_ptr->cell_list[i].u.nr_cell.rsrp, result_ptr->cell_list[i].u.nr_cell.rsrq, result_ptr->cell_list[i].u.nr_cell.sinr,
                        result_ptr->cell_list[i].u.nr_cell.csirsrp, result_ptr->cell_list[i].u.nr_cell.csirsrq, result_ptr->cell_list[i].u.nr_cell.csisinr);

                    p->writeInt32(result_ptr->cell_list[i].u.nr_cell.state);
                    p->writeInt32(0);
                    p->writeInt64(0);
                    memcpy(mcc, result_ptr->cell_list[i].u.nr_cell.provider_id, 3);
                    memcpy(mnc, result_ptr->cell_list[i].u.nr_cell.provider_id + 3, 3);

                    p->writeInt32(atoi(mcc));
                    p->writeInt32(atoi(mnc));
                    p->writeUint64(result_ptr->cell_list[i].u.nr_cell.cid);
                    p->writeUint32(result_ptr->cell_list[i].u.nr_cell.physical_cell_id);
                    p->writeInt32(result_ptr->cell_list[i].u.nr_cell.tac);
                    p->writeInt32(result_ptr->cell_list[i].u.nr_cell.nr_arfcn);
                    p->writeInt32(aosp_nr_ssrsrp);
                    p->writeInt32(aosp_nr_ssrsrq);
                    p->writeInt32(aosp_nr_sssinr);
                    p->writeInt32(aosp_nr_csirsrp); //csirsrp
                    p->writeInt32(aosp_nr_csirsrq); //csirsrq
                    p->writeInt32(aosp_nr_csisinr); //csisinr

                    break;
                }
                default: {
                    RFX_LOG_E(RFX_LOG_TAG,"not support CELL TYPE:%d\n",cell_type);
                    if(p != NULL) {
                        delete(p);
                        p = NULL;
                    }
                    rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_GENERIC_FAILURE);
                    return;;
                }
            }
        }

        rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}

void mipc_get_Neighbor_cell_info_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_nw_cells_struct_v *result_ptr,
    void *cb_priv_ptr
)
{
    RFX_LOG_D(RFX_LOG_TAG,"mipc_get_Neighbor_cell_info_cb result_code %d\n",result_ptr->result_code);
    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),result_ptr->result_code);
    }else {
        Parcel * p = NULL;
        char cid[16] = {0};
        int num = result_ptr->cell_list_count;
        RFX_LOG_D(RFX_LOG_TAG,"mipc_get_Neighbor_cell_info_cb cell_list_count %d\n",num);
        if(num < 2) {
            goto error;
        }
        p = new Parcel();
        p->writeInt32(num-1);
        for (int i = 1 ; i < num; i++) {
            int cell_type=result_ptr->cell_list[i].cell_type;
            switch(cell_type) {
                case MIPC_NW_CELL_TYPE_GSM: {
                    p->writeInt32(result_ptr->cell_list[i].u.gsm_cell.rx_level);
                    sprintf(cid, "%04X%04X",
                        result_ptr->cell_list[i].u.gsm_cell.lac,
                        result_ptr->cell_list[i].u.gsm_cell.cid);
                    writeStringToParcel(p,cid);
                    RFX_LOG_D(RFX_LOG_TAG,"gsm cid:%s,rssi:%d\n", cid, result_ptr->cell_list[i].u.gsm_cell.rx_level);

                    break;
                }
                case RIL_CELL_INFO_TYPE_WCDMA: {
                    p->writeInt32(result_ptr->cell_list[i].u.umts_cell.rscp);
                    sprintf(cid, "%08X",
                        result_ptr->cell_list[i].u.umts_cell.psc);
                    RFX_LOG_D(RFX_LOG_TAG,"wcdma cid:%s,rssi:%d\n", cid, result_ptr->cell_list[i].u.umts_cell.rscp);
                    writeStringToParcel(p,cid);
                    break;
                }
                default: {
                    RFX_LOG_E(RFX_LOG_TAG,"not support CELL TYPE:%d\n",cell_type);
                    goto error;
                }
            }
        }

        rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
        return;
error:
        if(p != NULL) {
            delete(p);
            p = NULL;
        }
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_GENERIC_FAILURE);
    }

}

void mipc_get_Operator_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_nw_provider_name_get_struct *result_ptr,
    void *cb_priv_ptr
)
{
    RFX_LOG_D(RFX_LOG_TAG,"mipc_get_Operator result_code %d\n",result_ptr->result_code);

    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),result_ptr->result_code);
    }else {

        Parcel * p = new Parcel();
        if(p == NULL) {
            rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_GENERIC_FAILURE);
            return;
        }
        p->writeInt32(3); //number of strings
        writeStringToParcel(p,result_ptr->network_name_long);
        writeStringToParcel(p,result_ptr->network_name);
        writeStringToParcel(p,result_ptr->plmn_id);
        RFX_LOG_D(RFX_LOG_TAG,"mipc_get_Operator_cb plmn_id[%s],shortname[%s]",
            result_ptr->plmn_id,result_ptr->network_name);
        rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}


void mipc_get_prefer_network_cb(mipc_sim_ps_id_enum sim_ps_id,
    mipc_nw_get_rat_struct *result_ptr, void *cb_priv_ptr)
{
    RFX_LOG_D(RFX_LOG_TAG,"mipc_get_prefer_network_cb result_code %d\n",result_ptr->result_code);

    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_RADIO_NOT_AVAILABLE);
    }else {
        int count = 1;
        int nt_type,prefer_type,return_type = PREF_NET_TYPE_GSM_ONLY;
        nt_type = result_ptr->rat;
        prefer_type = result_ptr->prefer_rat;
        RFX_LOG_D(RFX_LOG_TAG,"mipc_get_prefer_network_cb rat %d,prefer_type %d\n",nt_type,prefer_type);

        if (nt_type == 0) {
            return_type = PREF_NET_TYPE_GSM_ONLY;
        } else if (nt_type == 1) {
            return_type = PREF_NET_TYPE_WCDMA;
        } else if (nt_type == 2 && prefer_type == 0) {
            return_type = PREF_NET_TYPE_GSM_WCDMA_AUTO;
        } else if (nt_type == 2 && prefer_type == 1) {
            RFX_LOG_E(LOG_TAG, "Dual mode but GSM prefer, mount to AUTO mode");
            return_type = PREF_NET_TYPE_GSM_WCDMA_AUTO;
        } else if (nt_type == 2 && prefer_type == 2) {
            return_type = PREF_NET_TYPE_GSM_WCDMA;
        //for LTE -- START
        } else if (nt_type == 6 && prefer_type == 4) {
            //4G Preferred (4G, 3G/2G) item
            //Bause we are not defind LTE preferred,
            //so return by NT_LTE_GSM_WCDMA_TYPE temporary
            return_type = PREF_NET_TYPE_LTE_GSM_WCDMA;
        } else if (nt_type == 6 && prefer_type == 0) {
            //4G/3G/2G(Auto) item
            return_type = PREF_NET_TYPE_LTE_GSM_WCDMA;
        } else if (nt_type == 6 && prefer_type == 128) {
            //4G/3G/2G(Auto) item
            return_type = PREF_NET_TYPE_LTE_GSM_WCDMA;
        } else if (nt_type == 14) {
            // LTE CDMA EVDO GSM/WCDMA mode
            return_type = PREF_NET_TYPE_LTE_CMDA_EVDO_GSM_WCDMA;
        } else if (nt_type == 12) {
            // LTE CDMA EVDO GSM mode
            return_type = PREF_NET_TYPE_LTE_CDMA_EVDO_GSM;
        } else if (nt_type == 3 && prefer_type == 0) {
            //4G only
            return_type = PREF_NET_TYPE_LTE_ONLY;
        } else if (nt_type == 3 && prefer_type == 4) {
            //4G only
            return_type = PREF_NET_TYPE_LTE_ONLY;
        } else if (nt_type == 5 && prefer_type == 0) {
            // 4G/3G
            return_type = PREF_NET_TYPE_LTE_WCDMA;
        } else if (nt_type == 10) {
            // 2G/3G/C2K
            return_type = PREF_NET_TYPE_GSM_WCDMA_CDMA_EVDO_AUTO;
        } else if (nt_type == 8 && prefer_type == 0) {
            // 2G/C2K 1x/evdo
            return_type = PREF_NET_TYPE_CDMA_EVDO_GSM;
        } else if (nt_type == 8 && prefer_type == 32) {
            // 2G/C2K 1x
            return_type = PREF_NET_TYPE_CDMA_GSM;
        } else if(nt_type == 11) {
            // LC mode
            return_type = PREF_NET_TYPE_LTE_CDMA_EVDO;
        } else if (nt_type == 7 && prefer_type == 0) {
            // C2K 1x/evdo
            return_type = PREF_NET_TYPE_CDMA_EVDO_AUTO;
        } else if (nt_type == 7 && prefer_type == 32) {
            // C2K 1x only
            return_type = PREF_NET_TYPE_CDMA_ONLY;
        } else if (nt_type == 7 && prefer_type == 64) {
            // C2K evdo only
            return_type = PREF_NET_TYPE_EVDO_ONLY;
        } else if (nt_type == 4) {
            // 4G/2G
            return_type = PREF_NET_TYPE_LTE_GSM;
        } else if (nt_type == 15) {
            // 5G only
            return_type = PREF_NET_TYPE_NR_ONLY;
        } else if (nt_type == 19) {
            // 5G/4G
            return_type = PREF_NET_TYPE_NR_LTE;
        } else if (nt_type == 27) {
            // 5G/4G/C2K
            return_type = PREF_NET_TYPE_NR_LTE_CDMA_EVDO;
        } else if (nt_type == 22) {
            // 5G/4G/3G/2G
            return_type = PREF_NET_TYPE_NR_LTE_TDSCDMA_GSM_WCDMA; //NETWORK_MODE_NR_LTE_GSM_WCDMA; NETWORK_MODE_NR_LTE_TDSCDMA_GSM;
        } else if (nt_type == 30) {
            // 5G/4G/C2K/3G/2G
            return_type = PREF_NET_TYPE_NR_LTE_TDSCDMA_CDMA_EVDO_GSM_WCDMA; //NETWORK_MODE_NR_LTE_CDMA_EVDO_GSM_WCDMA;
        } else if (nt_type == 21) {
            // 5G/4G/3G
            return_type = PREF_NET_TYPE_NR_LTE_TDSCDMA_WCDMA; //NETWORK_MODE_NR_LTE_WCDMA; NETWORK_MODE_NR_LTE_TDSCDMA;
        } else {
            //error
            Parcel * p = NULL;
            p = new Parcel();
            p->writeInt32(count);
            p->writeInt32(return_type);
            rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_RADIO_NOT_AVAILABLE);
            return;
        }
        Parcel * p = NULL;
        p = new Parcel();
        p->writeInt32(count);
        p->writeInt32(return_type);
        rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}

void mipc_get_voice_radio_tech(mipc_sim_ps_id_enum sim_ps_id,
    mipc_nw_get_rat_struct *result_ptr, void *cb_priv_ptr)
{
    RFX_LOG_D(RFX_LOG_TAG,"mipc_get_voice_radio_tech result_code %d\n",result_ptr->result_code);

    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),result_ptr->result_code);
    }else {
        int nt_type,prefer_type,return_type = 0;
        nt_type = result_ptr->rat;
        prefer_type = result_ptr->prefer_rat;
        RFX_LOG_D(RFX_LOG_TAG,"mipc_get_voice_radio_tech nt_type %d prefer_type %d\n",nt_type,prefer_type);

        if (nt_type == 0) {
            return_type = PREF_NET_TYPE_GSM_ONLY;
        } else if (nt_type == 1) {
            return_type = PREF_NET_TYPE_WCDMA;
        } else if (nt_type == 2 && prefer_type == 0) {
            return_type = PREF_NET_TYPE_GSM_WCDMA_AUTO;
        } else if (nt_type == 2 && prefer_type == 1) {
            RFX_LOG_E(LOG_TAG, "Dual mode but GSM prefer, mount to AUTO mode");
            return_type = PREF_NET_TYPE_GSM_WCDMA_AUTO;
        } else if (nt_type == 2 && prefer_type == 2) {
            return_type = PREF_NET_TYPE_GSM_WCDMA;
        //for LTE -- START
        } else if (nt_type == 6 && prefer_type == 4) {
            //4G Preferred (4G, 3G/2G) item
            //Bause we are not defind LTE preferred,
            //so return by NT_LTE_GSM_WCDMA_TYPE temporary
            return_type = PREF_NET_TYPE_LTE_GSM_WCDMA;
        } else if (nt_type == 6 && prefer_type == 0) {
            //4G/3G/2G(Auto) item
            return_type = PREF_NET_TYPE_LTE_GSM_WCDMA;
        } else if (nt_type == 14) {
            // LTE CDMA EVDO GSM/WCDMA mode
            return_type = PREF_NET_TYPE_LTE_CMDA_EVDO_GSM_WCDMA;
        } else if (nt_type == 12) {
            // LTE CDMA EVDO GSM mode
            return_type = PREF_NET_TYPE_LTE_CDMA_EVDO_GSM;
        } else if (nt_type == 3 && prefer_type == 0) {
            //4G only
            return_type = PREF_NET_TYPE_LTE_ONLY;
        } else if (nt_type == 5 && prefer_type == 0) {
            // 4G/3G
            return_type = PREF_NET_TYPE_LTE_WCDMA;
        } else if (nt_type == 10) {
            // 2G/3G/C2K
            return_type = PREF_NET_TYPE_GSM_WCDMA_CDMA_EVDO_AUTO;
        } else if (nt_type == 8 && prefer_type == 0) {
            // 2G/C2K 1x/evdo
            return_type = PREF_NET_TYPE_CDMA_EVDO_GSM;
        } else if (nt_type == 8 && prefer_type == 32) {
            // 2G/C2K 1x
            return_type = PREF_NET_TYPE_CDMA_GSM;
        } else if(nt_type == 11) {
            // LC mode
            return_type = PREF_NET_TYPE_LTE_CDMA_EVDO;
        } else if (nt_type == 7 && prefer_type == 0) {
            // C2K 1x/evdo
            return_type = PREF_NET_TYPE_CDMA_EVDO_AUTO;
        } else if (nt_type == 7 && prefer_type == 32) {
            // C2K 1x only
            return_type = PREF_NET_TYPE_CDMA_ONLY;
        } else if (nt_type == 7 && prefer_type == 64) {
            // C2K evdo only
            return_type = PREF_NET_TYPE_EVDO_ONLY;
        } else if (nt_type == 4) {
            // 4G/2G
            return_type = PREF_NET_TYPE_LTE_GSM;
        } else if (nt_type == 15) {
            // 5G only
            return_type = PREF_NET_TYPE_NR_ONLY;
        } else if (nt_type == 19) {
            // 5G/4G
            return_type = PREF_NET_TYPE_NR_LTE;
        } else if (nt_type == 27) {
            // 5G/4G/C2K
            return_type = PREF_NET_TYPE_NR_LTE_CDMA_EVDO;
        } else if (nt_type == 22) {
            // 5G/4G/3G/2G
            return_type = PREF_NET_TYPE_NR_LTE_TDSCDMA_GSM_WCDMA; //NETWORK_MODE_NR_LTE_GSM_WCDMA; NETWORK_MODE_NR_LTE_TDSCDMA_GSM;
        } else if (nt_type == 30) {
            // 5G/4G/C2K/3G/2G
            return_type = PREF_NET_TYPE_NR_LTE_TDSCDMA_CDMA_EVDO_GSM_WCDMA; //NETWORK_MODE_NR_LTE_CDMA_EVDO_GSM_WCDMA;
        } else if (nt_type == 21) {
            // 5G/4G/3G
            return_type = PREF_NET_TYPE_NR_LTE_TDSCDMA_WCDMA; //NETWORK_MODE_NR_LTE_WCDMA; NETWORK_MODE_NR_LTE_TDSCDMA;
        } else {
            //error
            RFX_LOG_D(RFX_LOG_TAG,"mipc_get_voice_radio_tech unknown pref Nw type");
        }

        int tech = RADIO_TECH_UNKNOWN;
        switch (return_type) {
            case PREF_NET_TYPE_GSM_ONLY:
            case PREF_NET_TYPE_GSM_WCDMA:
            case PREF_NET_TYPE_GSM_WCDMA_AUTO:
            case PREF_NET_TYPE_LTE_GSM_WCDMA:
            case PREF_NET_TYPE_LTE_WCDMA:
            case PREF_NET_TYPE_LTE_GSM:
            case PREF_NET_TYPE_TD_SCDMA_GSM_LTE:
            case PREF_NET_TYPE_TD_SCDMA_GSM_WCDMA_LTE:
            case PREF_NET_TYPE_TD_SCDMA_GSM:
            case PREF_NET_TYPE_TD_SCDMA_GSM_WCDMA:
            case PREF_NET_TYPE_TD_SCDMA_LTE:
            case PREF_NET_TYPE_TD_SCDMA_WCDMA_LTE:
            case PREF_NET_TYPE_NR_LTE_TDSCDMA_GSM_WCDMA:
            case PREF_NET_TYPE_NR_LTE_TDSCDMA_WCDMA:
                tech = RADIO_TECH_GPRS;
                break;

            case PREF_NET_TYPE_WCDMA:
            case PREF_NET_TYPE_TD_SCDMA_ONLY:
            case PREF_NET_TYPE_TD_SCDMA_WCDMA:
                tech = RADIO_TECH_UMTS;
                break;

            //  LTE or NR, don't change in C2K card.
            case PREF_NET_TYPE_LTE_ONLY:
            case PREF_NET_TYPE_NR_ONLY:
            case PREF_NET_TYPE_NR_LTE:
                //don't support CDMA
             //   if (true == isGsmOnlySim(mipc_sim_id_to_slot_id(sim_ps_id))) {
                    tech = RADIO_TECH_GPRS;
             //   }
                break;

            case PREF_NET_TYPE_CDMA_ONLY:
            case PREF_NET_TYPE_CDMA_EVDO_AUTO:
            case PREF_NET_TYPE_EVDO_ONLY:
            case PREF_NET_TYPE_LTE_CDMA_EVDO:
            case PREF_NET_TYPE_NR_LTE_CDMA_EVDO:
                tech = RADIO_TECH_1xRTT;
                break;

            case PREF_NET_TYPE_TD_SCDMA_LTE_CDMA_EVDO_GSM_WCDMA:
            case PREF_NET_TYPE_TD_SCDMA_GSM_WCDMA_CDMA_EVDO_AUTO:
            case PREF_NET_TYPE_GSM_WCDMA_CDMA_EVDO_AUTO:
            case PREF_NET_TYPE_LTE_CMDA_EVDO_GSM_WCDMA:
            case PREF_NET_TYPE_CDMA_GSM:
            case PREF_NET_TYPE_CDMA_EVDO_GSM:
            case PREF_NET_TYPE_LTE_CDMA_EVDO_GSM:
            case PREF_NET_TYPE_NR_LTE_TDSCDMA_CDMA_EVDO_GSM_WCDMA:
                tech = RADIO_TECH_1xRTT;
                break;

            default:
                RFX_LOG_D(RFX_LOG_TAG,"mipc_get_voice_radio_tech unknown Nw type");
                break;
        }
        RFX_LOG_D(RFX_LOG_TAG,"mipc_get_voice_radio_tech tech %d\n",tech);
        Parcel * p = NULL;
        p = new Parcel();
        p->writeInt32(tech);
        rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}

void mipc_set_prefer_network_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_nw_set_rat_struct *result_ptr,
    void *cb_priv_ptr
)
{
    RFX_LOG_D(RFX_LOG_TAG,"mipc_set_prefer_network_cb result_code %d\n",result_ptr->result_code);
    RIL_Errno err = RIL_E_SUCCESS;
    Parcel * parcel = NULL;

    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        err = (RIL_Errno)result_ptr->result_code;// Todo
    }else {
        if (cb_priv_ptr == NULL) {
            RFX_LOG_D(RFX_LOG_TAG,"mipc_set_prefer_network_cb no need update mCurPreferedNetWorkType\n");

        } else {
            //update mCurPreferedNetWorkType
            int slotid = mipc_sim_id_to_slot_id(sim_ps_id);
            mCurPreferedNetWorkType[slotid] = prefNwType[slotid];
            updatePhoneMode(mipc_sim_id_to_slot_id(sim_ps_id));
        }

        mHasSetRat[mipc_sim_id_to_slot_id(sim_ps_id)] = true;
        RFX_LOG_D(RFX_LOG_TAG,"mipc_set_prefer_network_cb set mHasSetRat[%d]=%d\n",
                mipc_sim_id_to_slot_id(sim_ps_id),
                mHasSetRat[mipc_sim_id_to_slot_id(sim_ps_id)]);
    }

    if (cb_priv_ptr == NULL) {
        RFX_LOG_D(RFX_LOG_TAG,"mipc_set_prefer_network_cb no need response to upper layer\n");

    } else {
        rfx_enqueue_response_message(parcel, cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),err);
    }
}

void mipc_band_set_network_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_nw_band_mode_struct *result_ptr,
    void *cb_priv_ptr
)
{
    RFX_LOG_D(RFX_LOG_TAG,"mipc_band_set_network_cb result_code %d\n",result_ptr->result_code);

    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_RADIO_NOT_AVAILABLE);
    }else {
        Parcel * p = NULL;
        p = new Parcel();
        rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}

void mipc_band_get_network_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_nw_band_mode_struct *result_ptr,
    void *cb_priv_ptr
)
{
    RFX_LOG_D(RFX_LOG_TAG,"mipc_band_set_network_cb result_code %d\n",result_ptr->result_code);

    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),result_ptr->result_code);
    }else {
        Parcel * p = NULL;
        p = new Parcel();
        int gsm_band, umts_band;
        int band_mode[10], index=1;
        gsm_band=result_ptr->GSM_band_mode;
        umts_band=result_ptr->UMTS_band_mode;
        RFX_LOG_D(RFX_LOG_TAG,"gsm_band %d umts_band %d\n",gsm_band,umts_band);
        //0 for "unspecified" (selected by baseband automatically)
        band_mode[index++] = BM_AUTO_MODE;
        if (gsm_band !=0 || umts_band != 0) {
            // 1 for "EURO band" (GSM-900 / DCS-1800 / WCDMA-IMT-2000)
            if ((gsm_band == 0 || (gsm_band | MIPC_SYS_CAP_GSM_BAND_900 | MIPC_SYS_CAP_GSM_BAND_DCS_1800) == gsm_band) &&
                    (umts_band == 0 || (umts_band | MIPC_SYS_CAP_UMTS_BAND_I) == umts_band)) {
                band_mode[index++] = BM_EURO_MODE;
            }

            // 2 for "US band" (GSM-850 / PCS-1900 / WCDMA-850 / WCDMA-PCS-1900)
            if ((gsm_band == 0 || (gsm_band | MIPC_SYS_CAP_GSM_BAND_PCS_850| MIPC_SYS_CAP_GSM_BAND_PCS_1900) == gsm_band) &&
                    (umts_band == 0 || (umts_band | MIPC_SYS_CAP_UMTS_BAND_II | MIPC_SYS_CAP_UMTS_BAND_V) == umts_band)) {
                band_mode[index++] = BM_US_MODE;
            }

            // 3 for "JPN band" (WCDMA-800 / WCDMA-IMT-2000)
            if ((umts_band | MIPC_SYS_CAP_UMTS_BAND_I | MIPC_SYS_CAP_UMTS_BAND_VI) == umts_band) {
                band_mode[index++] = BM_JPN_MODE;
            }

            // 4 for "AUS band" (GSM-900 / DCS-1800 / WCDMA-850 / WCDMA-IMT-2000)
            if ((gsm_band == 0 || (gsm_band | MIPC_SYS_CAP_GSM_BAND_900 | MIPC_SYS_CAP_GSM_BAND_DCS_1800)==gsm_band) &&
                    (umts_band == 0 || (umts_band | MIPC_SYS_CAP_UMTS_BAND_I | MIPC_SYS_CAP_UMTS_BAND_V)==umts_band)) {
                band_mode[index++] = BM_AUS_MODE;
            }

            // 5 for "AUS band 2" (GSM-900 / DCS-1800 / WCDMA-850)
            if ((gsm_band == 0 || (gsm_band | MIPC_SYS_CAP_GSM_BAND_900 | MIPC_SYS_CAP_GSM_BAND_DCS_1800)==gsm_band) &&
                    (umts_band == 0 || (umts_band | MIPC_SYS_CAP_UMTS_BAND_V)==umts_band)) {
                band_mode[index++] = BM_AUS2_MODE;
            }
        }
        band_mode[0] = index - 1;
        RFX_LOG_D(RFX_LOG_TAG,"band_mode size %d\n",band_mode[0]);
        p->writeInt32Array(index,band_mode);
        rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}

void mipc_band_get_available_network_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_nw_providers_struct_v *result_ptr,
    void *cb_priv_ptr
)
{
    RFX_LOG_D(RFX_LOG_TAG,"%s result_code %d\n", __FUNCTION__, result_ptr->result_code);

    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),result_ptr->result_code);
    }else {
        int num=result_ptr->provider_list_count;
        RFX_LOG_D(RFX_LOG_TAG,"available network num %d\n",num);
        Parcel * p = NULL;
        p = new Parcel();
        p->writeInt32(num*4);
        for(int i=0;i<num;i++){
            if(strlen(result_ptr->extend_provider_list[i].oper_long_name)!=0)
                writeStringToParcel(p,result_ptr->extend_provider_list[i].oper_long_name);
            else
                writeStringToParcel(p,result_ptr->extend_provider_list[i].oper_numeric_name);

            if(strlen(result_ptr->extend_provider_list[i].oper_short_name)!=0)
                writeStringToParcel(p,result_ptr->extend_provider_list[i].oper_short_name);
            else
                writeStringToParcel(p,result_ptr->extend_provider_list[i].oper_numeric_name);

            writeStringToParcel(p,result_ptr->extend_provider_list[i].oper_numeric_name);
            RFX_LOG_D(RFX_LOG_TAG,"[line=%d] oper_long_name=%s, oper_short_name=%s, oper_numeric_name=%s, stat=%d\n",
                    __LINE__,
                    result_ptr->extend_provider_list[i].oper_long_name,
                    result_ptr->extend_provider_list[i].oper_short_name,
                    result_ptr->extend_provider_list[i].oper_numeric_name,
                    result_ptr->extend_provider_list[i].stat);

            /* 0:unknown, 1:visible, 2:registered, 3:forbidden, 4:preferred, 5: home */
            switch(result_ptr->extend_provider_list[i].stat) {
            case 0:
                writeStringToParcel(p,"unknown");
                break;
            case 1:
                writeStringToParcel(p,"visible");
                break;
            case 2:
                writeStringToParcel(p,"registered");
                break;
            case 3:
                writeStringToParcel(p,"forbidden");
                break;
            case 4:
                writeStringToParcel(p,"preferred");
                break;
            case 5:
                writeStringToParcel(p,"home");
                break;
            default:
                RFX_LOG_D(RFX_LOG_TAG, "The %d-th <stat> is an invalid value!!!  : %d", i, result_ptr->extend_provider_list[i].stat);
                break;
            }
        }
        RFX_LOG_D(RFX_LOG_TAG,"[line=%d]%s-\n",__LINE__, __FUNCTION__);
        rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}

void mipc_band_get_available_network_act_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_nw_providers_struct_v *result_ptr,
    void *cb_priv_ptr
)
{
    RFX_LOG_D(RFX_LOG_TAG,"%s result_code %d\n", __FUNCTION__, result_ptr->result_code);

    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),result_ptr->result_code);
    }else {
        int num=result_ptr->provider_list_count;
        RFX_LOG_D(RFX_LOG_TAG,"available network num %d\n",num);
        Parcel * p = NULL;
        p = new Parcel();
        p->writeInt32(num*6);

        for(int i=0;i<num;i++){
            if(strlen(result_ptr->extend_provider_list[i].oper_long_name)!=0)
                writeStringToParcel(p,result_ptr->extend_provider_list[i].oper_long_name);
            else
                writeStringToParcel(p,result_ptr->extend_provider_list[i].oper_numeric_name);

            if(strlen(result_ptr->extend_provider_list[i].oper_short_name)!=0)
                writeStringToParcel(p,result_ptr->extend_provider_list[i].oper_short_name);
            else
                writeStringToParcel(p,result_ptr->extend_provider_list[i].oper_numeric_name);

            writeStringToParcel(p,result_ptr->extend_provider_list[i].oper_numeric_name);

            RFX_LOG_D(RFX_LOG_TAG,"[line=%d] network_name=%s, network_short_name=%s, plmn_id=%s, stat=%d, lac=%s, act=%d\n",
                    __LINE__,
                    result_ptr->extend_provider_list[i].oper_long_name,
                    result_ptr->extend_provider_list[i].oper_short_name,
                    result_ptr->extend_provider_list[i].oper_numeric_name,
                    result_ptr->extend_provider_list[i].stat,
                    result_ptr->extend_provider_list[i].lac,
                    result_ptr->extend_provider_list[i].act);

            /* 0:unknown, 1:visible, 2:registered, 3:forbidden, 4:preferred, 5: home */
            switch(result_ptr->extend_provider_list[i].stat) {
            case 0:
                writeStringToParcel(p,"unknown");
                break;
            case 1:
                writeStringToParcel(p,"visible");
                break;
            case 2:
                writeStringToParcel(p,"registered");
                break;
            case 3:
                writeStringToParcel(p,"forbidden");
                break;
            case 4:
                writeStringToParcel(p,"preferred");
                break;
            case 5:
                writeStringToParcel(p,"home");
                break;
            default:
                RFX_LOG_D(RFX_LOG_TAG, "The %d-th <stat> is an invalid value!!!  : %d", i,result_ptr->extend_provider_list[i].stat);
                break;
            }
            writeStringToParcel(p,result_ptr->extend_provider_list[i].lac);
            switch(result_ptr->extend_provider_list[i].act){
                case 0:
                    writeStringToParcel(p,"2G");
                    break;
                case 2:
                    writeStringToParcel(p,"3G");
                    break;
                case 7:    //for  LTE
                    writeStringToParcel(p,"4G");
                    break;
                case 11:
                case 12:
                case 13:
                    writeStringToParcel(p,"5G");
                    break;
                default:
                    writeStringToParcel(p,"unknown");
                    break;
            }
        }
        RFX_LOG_D(RFX_LOG_TAG,"[line=%d]%s-\n",__LINE__, __FUNCTION__);
        rfx_enqueue_response_message(p,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}

}


void RpNwController::handleSignalStrengthRequest(const sp<RfxMessage>& request)
{
    int ret=0;
    RFX_LOG_D(RFX_LOG_TAG, "handleSignalStrengthRequest with clientId: %d, with token: %d",
            request->getClientId(), request->getToken());

    mipc_nw_signal_state_get_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_signal_strength_act_cb, (void *)request->getRilToken());
}
void RpNwController::handleDataRegistrationRequest(const sp<RfxMessage>& request)
{
    RFX_LOG_D(RFX_LOG_TAG, "handleDataRegistrationRequest with clientId: %d, with token: %d",
            request->getClientId(), request->getToken());

    mipc_nw_data_get_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_data_registration_act_cb, (void *)request->getRilToken());
}

void RpNwController::handleVoiceRegistrationRequest(const sp<RfxMessage>& request)
{
    RFX_LOG_D(RFX_LOG_TAG, "handleVoiceRegistrationRequest with clientId: %d, with token: %d",
            request->getClientId(), request->getToken());

    mipc_nw_cs_get_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_voice_registration_act_cb, (void *)request->getRilToken());
}

void RpNwController::handleQueryNwSelectRequest(const sp<RfxMessage>& request)
{
    RFX_LOG_D(RFX_LOG_TAG, "handleQueryNwSelectRequest with clientId: %d, with token: %d",
            request->getClientId(), request->getToken());
    //Todo. assign parameter from request data
    mipc_nw_register_state_get_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_network_get_select_mode_cb, (void *)request->getRilToken());
}

char *strdupReadString(Parcel &p) {
    size_t stringlen;
    const char16_t *s16;

    s16 = p.readString16Inplace(&stringlen);

    return strndup16to8(s16, stringlen);
}

void RpNwController::handleSetNwAutoSelectRequest(const sp<RfxMessage>& request)
{
    RFX_LOG_D(RFX_LOG_TAG, "handleSetNwAutoSelectRequest with clientId: %d, with token: %d",
            request->getClientId(), request->getToken());
    //Todo. assign parameter from request data
    mipc_nw_register_mode_enum reg_mode = MIPC_NW_ENUM_REGISTER_MODE_AUTOMATIC;
    mipc_nw_register_mode_set_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_network_set_select_mode_cb, (void *)request->getRilToken(),
                                    reg_mode, NULL);
}

void RpNwController::handleSetNwManualSelectRequest(const sp<RfxMessage>& request)
{
    RFX_LOG_D(RFX_LOG_TAG, "handleSetNwManualSelectRequest with clientId: %d, with token: %d",
            request->getClientId(), request->getToken());
    //Todo. assign parameter from request data
    char *plmn_id_ptr = NULL;
    uint32_t data_class;
    mipc_nw_reg_state_struct stateResult;
    mipc_nw_register_state_get_sync(slot_id_to_mipc_sim_id(request->getSlotId()), &stateResult);
    data_class = stateResult.available_data_class;
    mipc_nw_register_mode_enum reg_mode = MIPC_NW_ENUM_REGISTER_MODE_MANUAL;
    Parcel *p = request->getParcel();
    if(p != NULL) {
       plmn_id_ptr = strdupReadString(*p);
    }
    RFX_LOG_D(RFX_LOG_TAG, "handleSetNwManualSelectRequest plmn_id_ptr %s",plmn_id_ptr);
    mipc_nw_register_mode_set_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_network_set_select_mode_cb, (void *)request->getRilToken(),
                                    reg_mode, plmn_id_ptr);
}

void RpNwController::handleGetCellInfoRequest(const sp<RfxMessage>& request)
{
    RFX_LOG_D(RFX_LOG_TAG, "handleGetCellInfoRequest with clientId: %d, with token: %d",
            request->getClientId(), request->getToken());

    mipc_nw_cell_info_get_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_get_cell_info_cb, (void *)request->getRilToken());
}

void RpNwController::handleGetNeighborCellInfoRequest(const sp<RfxMessage>& request)
{
    RFX_LOG_D(RFX_LOG_TAG, "handleGetNeighborCellInfoRequest with clientId: %d, with token: %d",
            request->getClientId(), request->getToken());
    //Get cell info from index 1
    mipc_nw_cell_info_get_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_get_Neighbor_cell_info_cb, (void *)request->getRilToken());
}

void RpNwController::handleGetOperator(const sp<RfxMessage>& request)
{
    //get plmnid Todo need get the mccmnc from the get imsi mipc interface
    mIsNeedNotifyState[request->getSlotId()] = true;
    string mccMncKey("");
    mccMncKey.append("vendor.ril.data.gsm_mcc_mnc");
    mccMncKey.append(to_string(request->getSlotId()));
    char value[RFX_PROPERTY_VALUE_MAX] = {0};
    int ret = 0;
    rfx_property_get(mccMncKey.c_str(), value, "");
    RFX_LOG_D(RFX_LOG_TAG, "handleGetOperator plmnid[%s]",value);

    // Handle for test SIM, always return 00101
    if (strcmp(value, "00101") == 0) {
        Parcel * p = new Parcel();
        if(p == NULL) {
            rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_GENERIC_FAILURE);
            return;
        }
        p->writeInt32(3); //number of strings
        writeStringToParcel(p,value);
        writeStringToParcel(p,value);
        writeStringToParcel(p,value);
        RFX_LOG_D(RFX_LOG_TAG,"%s plmn_id[%s],shortname[%s]", __FUNCTION__, value, value);
        rfx_enqueue_response_message(p,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_SUCCESS);
        return;
    }

    //get operator name with plmnid
    mipc_nw_provider_name_get_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_get_Operator_cb,
        (void *)request->getRilToken(), value);
}

void RpNwController::handleScreenStateRequest(const sp<RfxMessage>& request)
{
    Parcel* p = request->getParcel();
    int ret; //jb.qi change for channel 228 resume on 2022.11.18
    int32_t count = 0;
    android::status_t status = android::NO_ERROR;
    int32_t screen_state = -1;

    status = p->readInt32 (&count);

    if (status != android::NO_ERROR || count <= 0) {
        RFX_LOG_E(RFX_LOG_TAG, "%s read count(%d) error", __FUNCTION__, count);
        goto invalid;
    }
    status = p->readInt32(&screen_state);
    if (status != android::NO_ERROR) {
        RFX_LOG_E(RFX_LOG_TAG, "%s read screen_state(%d) error", __FUNCTION__, screen_state);
        goto invalid;
    }
    RFX_LOG_D(RFX_LOG_TAG, "%s with token: %d, with state:%d", __FUNCTION__, request->getToken(),screen_state);

    if(screen_state == 1) {
        mipc_nw_nitz_register(slot_id_to_mipc_sim_id(getSlotId()),mipc_unsol_nitz_time_recv_cb,NULL);
        mipc_nw_signal_state_register(slot_id_to_mipc_sim_id(getSlotId()),mipc_unsol_signal_strength_cb,NULL);
        mipc_nw_ps_register(slot_id_to_mipc_sim_id(getSlotId()),mipc_unsol_nw_ps_ind_cb,NULL);
        mipc_nw_cs_register(slot_id_to_mipc_sim_id(getSlotId()),mipc_unsol_nw_cs_ind_cb,NULL);
        mipc_nw_psbearer_ind_register(slot_id_to_mipc_sim_id(getSlotId()),mipc_unsol_nw_psbearer_ind_cb,NULL);
        /*jb.qi change for channel 228 resume on 2022.11.18 start*/
        ret = mipc_msg_register_ind_api((mipc_msg_sim_ps_id_enum)slot_id_to_mipc_sim_id(getSlotId()), MIPC_IMS_STATE_IND, (void*)mipc_ims_state_ind_cb, NULL, NULL);
        /*jb.qi change for channel 228 resume on 2022.11.18 end*/
    }else {
        mipc_nw_nitz_register(slot_id_to_mipc_sim_id(getSlotId()),NULL,NULL);
        mipc_nw_signal_state_register(slot_id_to_mipc_sim_id(getSlotId()),NULL,NULL);
        mipc_nw_ps_register(slot_id_to_mipc_sim_id(getSlotId()),NULL,NULL);
        mipc_nw_cs_register(slot_id_to_mipc_sim_id(getSlotId()),NULL,NULL);
        mipc_nw_psbearer_ind_register(slot_id_to_mipc_sim_id(getSlotId()),NULL,NULL);
        /*jb.qi change for channel 228 resume on 2022.11.18 start*/
        ret = mipc_msg_register_ind_api((mipc_msg_sim_ps_id_enum)slot_id_to_mipc_sim_id(getSlotId()), MIPC_IMS_STATE_IND, NULL, NULL, NULL);
        /*jb.qi change for channel 228 resume on 2022.11.18 end*/
    }
    rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_SUCCESS);
    return;
invalid:
    rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_GENERIC_FAILURE);
}

void RpNwController::handleGetNwPreferNwTypeRequest(const sp<RfxMessage>& request)
{
    RFX_LOG_D(RFX_LOG_TAG, "handleGetNwPreferNwTypeRequest with clientId: %d, with token: %d",
            request->getClientId(), request->getToken());

    mipc_nw_get_rat_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_get_prefer_network_cb, (void *)request->getRilToken());
}

void RpNwController::handleSetNwPreferNwTypeRequest(const sp<RfxMessage>& request)
{
    RFX_LOG_D(RFX_LOG_TAG, "handleSetNwPreferNwTypeRequest with clientId: %d, with token: %d",
            request->getClientId(), request->getToken());
    int provider_list_count;
    int req_type = 0,rat,rat1 = 0;
    bool isPreferred = true;
    Parcel *p = request->getParcel();
    if(p != NULL) {
        p->readInt32(&provider_list_count);
        p->readInt32(&req_type);
        prefNwType[request->getSlotId()] = req_type;
        if (req_type > PREF_NET_TYPE_NR_ONLY &&
                req_type <= PREF_NET_TYPE_NR_LTE_TDSCDMA_CDMA_EVDO_GSM_WCDMA) {
            rat1 = 128;  // NR preferred
        }
        switch(req_type)
        {
            case PREF_NET_TYPE_GSM_WCDMA_AUTO:
                rat = 2;  // 2/3G AUTO
                break;
            case PREF_NET_TYPE_GSM_WCDMA:
            case PREF_NET_TYPE_TD_SCDMA_GSM:
            case PREF_NET_TYPE_TD_SCDMA_GSM_WCDMA:
                rat = 2;  // 2/3G AUTO
                if(isPreferred){
                    rat1 = 2;  // 3G preferred
                }
                break;
            case PREF_NET_TYPE_GSM_ONLY:
                rat = 0;  // 2G only
                break;
            case PREF_NET_TYPE_WCDMA:
            case PREF_NET_TYPE_TD_SCDMA_ONLY:
            case PREF_NET_TYPE_TD_SCDMA_WCDMA:
                rat = 1;  // 3G only
                break;
            case PREF_NET_TYPE_LTE_GSM_WCDMA:
            case PREF_NET_TYPE_TD_SCDMA_GSM_LTE:
            case PREF_NET_TYPE_TD_SCDMA_GSM_WCDMA_LTE:
                rat = 6;  // 2/3/4G AUTO
                if (isPreferred) {
                    rat1 = 4;  //4G preferred
                }
                break;
            case PREF_NET_TYPE_LTE_CMDA_EVDO_GSM_WCDMA:
            case PREF_NET_TYPE_TD_SCDMA_LTE_CDMA_EVDO_GSM_WCDMA:
                rat = 14;  // LTE CDMA EVDO GSM/WCDMA mode
                if (isPreferred) {
                    rat1 = 4;  //4G preferred
                }
                break;
            case PREF_NET_TYPE_LTE_CDMA_EVDO_GSM:
                rat = 12;  // LTE CDMA EVDO GSM mode
                break;
            case PREF_NET_TYPE_LTE_ONLY:
                rat = 3;  // LTE only for EM mode
                break;
            case PREF_NET_TYPE_LTE_WCDMA:
            case PREF_NET_TYPE_TD_SCDMA_LTE:
            case PREF_NET_TYPE_TD_SCDMA_WCDMA_LTE:
                rat = 5;  // LTE/WCDMA for EM mode
                break;
            case PREF_NET_TYPE_LTE_GSM:
                rat = 4;  // 2/4G
                break;
            case PREF_NET_TYPE_GSM_WCDMA_CDMA_EVDO_AUTO:
            case PREF_NET_TYPE_TD_SCDMA_GSM_WCDMA_CDMA_EVDO_AUTO:
                rat = 10;  // GSM/WCDMA/C2K mode
                break;
            case PREF_NET_TYPE_CDMA_EVDO_GSM:
                rat = 8;  // CDMA EVDO GSM mode
                break;
            case PREF_NET_TYPE_CDMA_GSM:
                rat = 8;  // CDMA GSM mode
                rat1 = 32;
                break;
            case PREF_NET_TYPE_LTE_CDMA_EVDO:
                rat = 11;   // LTE/C2K mode
                break;
            case PREF_NET_TYPE_CDMA_EVDO_AUTO:
                rat = 7;    // C2K 1x/Evdo
                break;
            case PREF_NET_TYPE_CDMA_ONLY:
                rat = 7;    // C2K 1x/Evdo
                rat1 = 32;  // C2K 1x only
                break;
            case PREF_NET_TYPE_EVDO_ONLY:
                rat = 7;    // C2K 1x/Evdo
                rat1 = 64;  // C2K Evdo only
                break;
            case PREF_NET_TYPE_NR_ONLY:
                rat = 15;    // NR only
                break;
            case PREF_NET_TYPE_NR_LTE:
                rat = 19;    // NR/LTE
                break;
            case PREF_NET_TYPE_NR_LTE_CDMA_EVDO:
                rat = 27;    // NR/LTE/C2K
                break;
            case PREF_NET_TYPE_NR_LTE_GSM_WCDMA:
            case PREF_NET_TYPE_NR_LTE_TDSCDMA_GSM:
            case PREF_NET_TYPE_NR_LTE_TDSCDMA_GSM_WCDMA:
                rat = 22;    // NR/LTE/GSM/WCDMA(TDS-CDMA)
                break;
            case PREF_NET_TYPE_NR_LTE_CDMA_EVDO_GSM_WCDMA:
            case PREF_NET_TYPE_NR_LTE_TDSCDMA_CDMA_EVDO_GSM_WCDMA:
                rat = 30;    // NR/LTE/C2K/GSM/WCDMA(TDS-CDMA)
                break;
            case PREF_NET_TYPE_NR_LTE_WCDMA:
            case PREF_NET_TYPE_NR_LTE_TDSCDMA:
            case PREF_NET_TYPE_NR_LTE_TDSCDMA_WCDMA:
                rat = 21;    //NR/LTE/WCDMA(TDS-CDMA)
                break;
            default:
                rat = -1;
                break;
        }
        RFX_LOG_D(RFX_LOG_TAG, "handleSetNwPreferNwTypeRequest \
            provider_list_count=%d req_type=%d,rat=%d,rat1=%d\n",provider_list_count,req_type,rat,rat1);

        if (rat >= 0) {
            mipc_nw_set_rat_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_set_prefer_network_cb, (void *)request->getRilToken(),
                (uint8_t)rat,(uint8_t)rat1);
        }
    }

}

void RpNwController::handleSetNwBandModeRequest(const sp<RfxMessage>& request)
{
    RFX_LOG_D(RFX_LOG_TAG, "handleSetNwPreferNwTypeRequest with clientId: %d, with token: %d",
            request->getClientId(), request->getToken());
    //Todo. assign parameter from request data
    int pInt[3]={0,0,0};
    int provider_list_count;
    Parcel *p = request->getParcel();
    if(p != NULL) {
        p->readInt32(&provider_list_count);
        p->readInt32(&pInt[0]);
        p->readInt32(&pInt[1]);
        p->readInt32(&pInt[2]);
    }
    int req, err;
    unsigned int gsm_band=0, umts_band=0, lte_band_1_32=0, lte_band_33_64=0;
    req = pInt[0];
    switch (req) {
        case BM_AUTO_MODE: //"unspecified" (selected by baseband automatically)
            gsm_band = 0xff;
            umts_band = 0xffff;
            break;
        case BM_EURO_MODE: //"EURO band" (GSM-900 / DCS-1800 / WCDMA-IMT-2000)
            gsm_band = MIPC_SYS_CAP_GSM_BAND_900 | MIPC_SYS_CAP_GSM_BAND_DCS_1800;
            umts_band = MIPC_SYS_CAP_UMTS_BAND_I;
            break;
        case BM_US_MODE: //"US band" (GSM-850 / PCS-1900 / WCDMA-850 / WCDMA-PCS-1900)
            gsm_band = MIPC_SYS_CAP_GSM_BAND_PCS_850| MIPC_SYS_CAP_GSM_BAND_PCS_1900;
            umts_band = MIPC_SYS_CAP_UMTS_BAND_II | MIPC_SYS_CAP_UMTS_BAND_V;
            break;
        case BM_JPN_MODE: //"JPN band" (WCDMA-800 / WCDMA-IMT-2000)
            gsm_band = 0;
            umts_band = MIPC_SYS_CAP_UMTS_BAND_I | MIPC_SYS_CAP_UMTS_BAND_VI;
            break;
        case BM_AUS_MODE: //"AUS band" (GSM-900 / DCS-1800 / WCDMA-850 / WCDMA-IMT-2000)
            gsm_band = MIPC_SYS_CAP_GSM_BAND_900 | MIPC_SYS_CAP_GSM_BAND_DCS_1800;
            umts_band = MIPC_SYS_CAP_UMTS_BAND_I | MIPC_SYS_CAP_UMTS_BAND_V;
            break;
        case BM_AUS2_MODE: //"AUS band 2" (GSM-900 / DCS-1800 / WCDMA-850)
            gsm_band = MIPC_SYS_CAP_GSM_BAND_900 | MIPC_SYS_CAP_GSM_BAND_DCS_1800;
            umts_band = MIPC_SYS_CAP_UMTS_BAND_V;
            break;
        case BM_40_BROKEN:
        case BM_CELLULAR_MODE: //"Cellular (800-MHz Band)"
        case BM_PCS_MODE: //"PCS (1900-MHz Band)"
        case BM_CLASS_3: //"Band Class 3 (JTACS Band)"
        case BM_CLASS_4: //"Band Class 4 (Korean PCS Band)"
        case BM_CLASS_5: //"Band Class 5 (450-MHz Band)"
        case BM_CLASS_6: // "Band Class 6 (2-GMHz IMT2000 Band)"
        case BM_CLASS_7: //"Band Class 7 (Upper 700-MHz Band)"
        case BM_CLASS_8: //"Band Class 8 (1800-MHz Band)"
        case BM_CLASS_9: //"Band Class 9 (900-MHz Band)"
        case BM_CLASS_10: //"Band Class 10 (Secondary 800-MHz Band)"
        case BM_CLASS_11: //"Band Class 11 (400-MHz European PAMR Band)"
        case BM_CLASS_15: //"Band Class 15 (AWS Band)"
        case BM_CLASS_16: //"Band Class 16 (US 2.5-GHz Band)"
        default:
            gsm_band = -1;
            umts_band = -1;
            break;
    }

    if (req == BM_40_BROKEN) {
        lte_band_1_32 = pInt[1];
        lte_band_33_64 = pInt[2];
    }else if (req == BM_FOR_DESENSE_RADIO_ON || req == BM_FOR_DESENSE_RADIO_OFF
            || req == BM_FOR_DESENSE_RADIO_ON_ROAMING || req == BM_FOR_DESENSE_B8_OPEN) {
        mipc_nw_band_mode_struct  cur_band;
        mipc_nw_band_mode_get_sync(slot_id_to_mipc_sim_id(request->getSlotId()), &cur_band);

        int force_switch = pInt[1];
        gsm_band = cur_band.GSM_band_mode;
        umts_band = cur_band.UMTS_band_mode;
        lte_band_1_32 = cur_band.LTE_band[0];
        lte_band_33_64 = cur_band.LTE_band[1];
        RFX_LOG_D(RFX_LOG_TAG, "BM FOR DESENCE, gsm_band:%d, umts_band : %d, lte_band_1_32 : %d, lte_band_33_64: %d, req: %d ",
                gsm_band, umts_band, lte_band_1_32, lte_band_33_64, req);
        if (req == BM_FOR_DESENSE_RADIO_ON) {
            if (umts_band & 0x00000080) {
                umts_band = umts_band & 0xffffff7f;
            }
        } else {
            if ((umts_band & 0x00000080) == 0) {
                umts_band = umts_band | 0x00000080;
            }
        }
    }
    mipc_nw_band_mode_struct BandMode;
    memset(&BandMode, 0, sizeof(BandMode));
    BandMode.GSM_band_mode=gsm_band;
    BandMode.UMTS_band_mode=umts_band;
    BandMode.LTE_band[0]=lte_band_1_32;
    BandMode.LTE_band[1]=lte_band_33_64;
    RFX_LOG_D(RFX_LOG_TAG, "GSM_band_mode:%d, UMTS_band_mode: %d, LTE_band[0]: %d, LTE_band[1]: %d, req: %d",
        BandMode.GSM_band_mode, BandMode.UMTS_band_mode, BandMode.LTE_band[0], BandMode.LTE_band[1], req);
    mipc_nw_band_mode_set_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_band_set_network_cb, (void *)request->getRilToken(),&BandMode);
}


void RpNwController::handleGetNwBandModeRequest(const sp<RfxMessage>& request)
{
    RFX_LOG_D(RFX_LOG_TAG, "handlegetNwBandModeRequest with clientId: %d, with token: %d",
            request->getClientId(), request->getToken());

    mipc_nw_band_mode_get_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_band_get_network_cb, (void *)request->getRilToken());
}

void RpNwController::handleGetAvailableNWRequest(const sp<RfxMessage>& request)
{
    RFX_LOG_D(RFX_LOG_TAG, "handleGetAvailableNWRequest with clientId: %d, with token: %d",
            request->getClientId(), request->getToken());

    if(request->getId() == RIL_REQUEST_QUERY_AVAILABLE_NETWORKS_WITH_ACT) {
        mipc_nw_visible_providers_get_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_band_get_available_network_act_cb, (void *)request->getRilToken());
    } else {
        mipc_nw_visible_providers_get_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_band_get_available_network_cb, (void *)request->getRilToken());
    }
}

void RpNwController::handleGetVoiceRadioTechRequest(const sp<RfxMessage>& request)
{
    RFX_LOG_D(RFX_LOG_TAG, "handleGetVoiceRadioTechRequest with clientId: %d, with token: %d",
            request->getClientId(), request->getToken());

    mipc_nw_get_rat_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_get_voice_radio_tech, (void *)request->getRilToken());
}

void RpNwController::handleSetUnsolCellInfoListRate(const sp<RfxMessage>& request)
{
    RFX_LOG_D(RFX_LOG_TAG, "handleSetUnsolCellInfoListRate with clientId: %d, with token: %d",
            request->getClientId(), request->getToken());

    Parcel *p = request->getParcel();
    if(p != NULL) {
        int count = 0;
        int rate = 0;
        mipc_api_result_enum result;
        p->readInt32(&count);
        p->readInt32(&rate);
        RFX_LOG_D(RFX_LOG_TAG, "handleSetUnsolCellInfoListRate rate: %d",rate);

        if(rate > 0) {
            result = mipc_nw_ecell_ind_register(slot_id_to_mipc_sim_id(getSlotId()),mipc_unsol_nw_ecell_ind_cb,NULL);
            if(result != MIPC_API_RESULT_SUCCESS) {
                RFX_LOG_D(RFX_LOG_TAG, "nw ecell ind already registered");
            }
        } else {
            mipc_nw_ecell_ind_register(slot_id_to_mipc_sim_id(getSlotId()),NULL,NULL);
        }
        rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_SUCCESS);
        return;
    }
    rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_GENERIC_FAILURE);
}

void RpNwController::onSimTaskReady(int slotId, RfxStatusKeyEnum key,
        RfxVariant old_value, RfxVariant value) {
    RFX_UNUSED(key);
    RFX_UNUSED(old_value);

    if (value.asBool() == true) {
        int newCardType = getStatusManager(slotId)->getIntValue(RFX_STATUS_KEY_CARD_TYPE, CARD_TYPE_NONE);
        //RFX_LOG_D(RFX_LOG_TAG, "[%d]%s get slotId[%d] RFX_STATUS_KEY_CARD_TYPE = %d",
        //        getSlotId(), __FUNCTION__, slotId, newCardType);

        /// M: Must set rat mode when first time boot (Never set RAT before)
        if ((newCardType == CARD_TYPE_NONE) && (mHasSetRat[getSlotId()] == false)) {
            mipc_nw_get_rat_struct cur_rat;
            mipc_nw_get_rat_sync(slot_id_to_mipc_sim_id(getSlotId()), &cur_rat);

            RFX_LOG_D(RFX_LOG_TAG, "[%d]%s send RAT mode for slotid=%d: no sim card state = %d, rat=%d, prefer_rat=%d",
                    getSlotId(), __FUNCTION__, slotId, newCardType, cur_rat.rat, cur_rat.prefer_rat);

            if (0 > cur_rat.rat || 30 < cur_rat.rat) {
                //6: GSM + UMTS + LTE, 4: LTE prefer
                cur_rat.rat = 6;
                cur_rat.prefer_rat = 4;
                RFX_LOG_D(RFX_LOG_TAG, "[%d]%s Update as rat=%d, prefer_rat=%d",
                        getSlotId(), __FUNCTION__, cur_rat.rat, cur_rat.prefer_rat);
            }

            mipc_nw_set_rat_async(slot_id_to_mipc_sim_id(getSlotId()), mipc_set_prefer_network_cb, NULL,
                (uint8_t)cur_rat.rat,(uint8_t)cur_rat.prefer_rat);
        }
    }
}

void RpNwController::handleReportAirplaneMode(const sp<RfxMessage>& request)
{
    RFX_LOG_D(RFX_LOG_TAG, "handleReportAirplaneMode with clientId: %d, with token: %d",
            request->getClientId(), request->getToken());

    Parcel *p = request->getParcel();
    if(p != NULL) {
        int count = 0;
        int airplane = 0;
        p->readInt32(&count);
        p->readInt32(&airplane);
        RFX_LOG_D(RFX_LOG_TAG, "handleReportAirplaneMode airplane: %d",airplane);
        rfx_property_set(PROPERTY_AIRPLANE_MODE, airplane ? "true" : "false");
        rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_SUCCESS);
        return;
    }
    rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_GENERIC_FAILURE);
}
