/*****************************************************************************
 *  Copyright Statement:
 *  --------------------
 *  Copyright (c) [2020], MediaTek Inc. All rights reserved.
 *  This software/firmware and related documentation ("MediaTek Software") are
 *  protected under relevant copyright laws.
 *
 *  The information contained herein is confidential and proprietary to
 *  MediaTek Inc. and/or its licensors. Except as otherwise provided in the
 *  applicable licensing terms with MediaTek Inc. and/or its licensors, any
 *  reproduction, modification, use or disclosure of MediaTek Software, and
 *  information contained herein, in whole or in part, shall be strictly
 *  prohibited.
 *****************************************************************************/

#ifndef RADIO_RPRADIOCONTROLLER_H_
#define RADIO_RPRADIOCONTROLLER_H_

#include <string>
#include <unordered_map>
#include "RfxController.h"
#include "RpUtils.h"
#include "RilParcelUtils.h"
#include <telephony/mtk_ril_request_info.h>
#ifdef __cplusplus
extern "C" {
#endif
#include "mipc_radio_api.h"
#include "mipc_msg_tlv_const.h"
#ifdef __cplusplus
}
#endif

class RpRadioController: public RfxController {
    RFX_DECLARE_CLASS(RpRadioController);  // Required: declare this class

// Override
protected:
    virtual void onInit();
    virtual bool onHandleRequest(const android::sp<RfxMessage> &message);
    virtual void onDeinit();
private:
    std::string mLog_tag;
public:
    RpRadioController();
    virtual ~RpRadioController();

private:
    void registerInd(mipc_sim_ps_id_enum sim_ps_id, void *cb_priv_ptr);
    void handleRadioPower(const android::sp<RfxMessage> &message);
    std::string IdToString(int request);
    void registerForStatusChange();
    void onSimStateChanged(RfxStatusKeyEnum key, RfxVariant old_value, RfxVariant value);
    void enableSilentReboot();
    int isNormalBootUp();
};

#endif /* RADIO_RPRADIOCONTROLLER_H_ */
