// SPDX-License-Identifier: MediaTekProprietary
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2015. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

/*****************************************************************************
 * Include
 *****************************************************************************/

#include "RpSmsController.h"

#include <utils/Errors.h>
#include <sys/un.h>
#include <errno.h>
#include <unistd.h>
#include <cutils/jstring.h>
#include <string>
#ifdef __cplusplus
extern "C" {
#endif
#include "mipc_sms_api.h"
#ifdef __cplusplus
}
#endif

#include "RfxDispatchThread.h"
#include "Rfx.h"
#include "libmtkrilutils.h"
#include "RpUtils.h"



using namespace std;
using android::status_t;
using android::NO_ERROR;

#define RFX_LOG_TAG "RpSmsController"
#define MIN(a, b) ((a) < (b) ? (a) : (b))
#define MAX_SMSC_LENGTH 11
#define MAX_TPDU_LENGTH 164


/*****************************************************************************
 * Class RfxDataController
 * The class is created if the slot is single mode, LWG or C,
 *****************************************************************************/

RFX_IMPLEMENT_CLASS("RpSmsController", RpSmsController, RfxController);


RpSmsController::RpSmsController() {
}

RpSmsController::~RpSmsController() {
}

static void writeStringToParcel(Parcel *p, const char *s) {
    char16_t *s16;
    size_t s16_len;
    s16 = strdup8to16(s, &s16_len);
    p->writeString16(s16, s16_len);
    free(s16);
}


void ucharToString (uint8_t singlepdu,char ** singless)
{
    char *ss;

    ss = (char*)malloc(3*sizeof(char));
    memset(ss,0,sizeof(ss));
    ss[0] = singlepdu / 16;
    ss[1] = singlepdu % 16;
    RFX_LOG_D(RFX_LOG_TAG,"ss[0]=%d,ss[1]=%d\n",ss[0],ss[1]);

    if(ss[0] >= 0 && ss[0] <= 9) {
        ss[0] = ss[0]+'0';
    }
    else if(ss[0] >= 10 && ss[0] <=15) {
        ss[0] = ss[0] - 10 + 'A';
    }

    if(ss[1] >= 0 && ss[1] <= 9) {
        ss[1] = ss[1]+'0';
    }
    else if(ss[1] >= 10 && ss[1] <=15) {
        ss[1] = ss[1] - 10 + 'A';
    }
    ss[2] = '\0';
    RFX_LOG_D(RFX_LOG_TAG,"ss[0]=%c,ss[1]=%c\n",ss[0],ss[1]);
    *singless = ss;
}

int ucharToStringAll (uint8_t ptuarray[],char ** pdu,int length)
{
    char ss[3];
    char *pdutmp ;
    int i;

    pdutmp= (char *)malloc(((MAX_SMSC_LENGTH+MAX_TPDU_LENGTH+1)*2+1)*sizeof(char));
    memset(pdutmp,0,sizeof(pdutmp));
    for(i = 0;i < length;i++){
        ss[0] =  ptuarray[i] / 16;
        ss[1] =  ptuarray[i] % 16;
        //RFX_LOG_D(RFX_LOG_TAG,"ss[0]=%d,ss[1]=%d\n",ss[0],ss[1]);

        if(ss[0] >= 0 && ss[0] <= 9) {
            ss[0] = ss[0]+'0';
        }
        else if(ss[0] >= 10 && ss[0] <=15) {
            ss[0] = ss[0] - 10 + 'A';
        }

        if(ss[1] >= 0 && ss[1] <= 9) {
            ss[1] = ss[1]+'0';
        }
        else if(ss[1] >= 10 && ss[1] <=15) {
            ss[1] = ss[1] - 10 + 'A';
        }
        ss[2]='\0';
        strcat(pdutmp,ss);
        //RFX_LOG_D(RFX_LOG_TAG,"pdutmp=%s\n",pdutmp);
     }
    *pdu = pdutmp;
    return 0;
}

int charToStringSca (uint8_t smsc[],char ** sca,int length)
{
    char ss[2] = {0};
    char *scatmp ;
    int i;

    scatmp= (char *)malloc(32*sizeof(char));
    memset(scatmp,0,sizeof(scatmp));
    RFX_LOG_D(RFX_LOG_TAG,"charToStringSca length=%d\n",length);
    for(i = 0;i < length-1;i++){
        if(ss[0] >= 0 && ss[0] <= 9) {
            ss[0] = ss[0]+'0';
        }
        else if(ss[0] >= 10 && ss[0] <=15) {
            ss[0] = ss[0] - 10 + 'A';
        }
        ss[1]='\0';
        strcat(scatmp,ss);
        //RFX_LOG_D(RFX_LOG_TAG,"scatmp=%s\n",scatmp);
     }
    *sca = scatmp;
    return 0;
}


void mipc_sms_cfg_req_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_sms_configuration_struct *result_ptr,
    void *cb_priv_ptr
)
{
}

void mipc_sms_cfg_req_cb_null(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_sms_configuration_struct *result_ptr,
    void *cb_priv_ptr
)
{
    RFX_LOG_D(RFX_LOG_TAG,"mipc_sms_cfg_req_cb_null\n");
    Parcel * parcel = NULL;
    RIL_Errno err = RIL_E_SUCCESS;

    err = (RIL_Errno)result_ptr->result_code;// Todo
    if(err != MIPC_RESULT_SUCCESS) {
    //result code to ril error transfer
        err = (RIL_Errno)result_ptr->result_code;// Todo
        RFX_LOG_D(RFX_LOG_TAG, "mipc_sms_cfg_req_cb_null error");
        return;

    }else {
         if ((mipc_sms_storage_state_enum)result_ptr->sms_storage_state == MIPC_SMS_STATE_INITIALIZED){
            mipc_sms_configuration_set_async(sim_ps_id, mipc_sms_cfg_req_cb,NULL, NULL, (mipc_sms_format_enum)0);
            RFX_LOG_D(RFX_LOG_TAG, "mipc_sms_cfg_req_cb_null MIPC_SMS_STATE_INITIALIZED sim_ps_id=%d",sim_ps_id);
        }
    }
}

void mipc_sms_new_sms_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_sms_read_struct *result_ptr,
    void *cb_priv_ptr
)
{
    // C2K or IMS C2K SMS will notified by this callback
    RFX_LOG_D(RFX_LOG_TAG, "mipc_sms_new_sms_cb\n");
    Parcel * parcel = NULL;
    char *pdu = NULL;
    int length = 0;
    RIL_Errno err = RIL_E_SUCCESS;
    RFX_LOG_D(RFX_LOG_TAG, "mipc_sms_new_sms_cb err=%d\n", err);

    err = (RIL_Errno)result_ptr->result_code;
    RFX_LOG_D(RFX_LOG_TAG, "mipc_sms_new_sms_cb err=%d\n", err);

    if (err != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_urc_message(RIL_UNSOL_RESPONSE_NEW_SMS, NULL, mipc_sim_id_to_slot_id(sim_ps_id), err);
    } else {
        parcel = new Parcel();
        length = result_ptr->sms_pdu_list[0].pdu[0]+1+ result_ptr->sms_pdu_list[0].pdu_len;
        RFX_LOG_D(RFX_LOG_TAG, "length=%d\n", length);
        ucharToStringAll(result_ptr->sms_pdu_list[0].pdu, &pdu,length);
        RFX_LOG_D(RFX_LOG_TAG, "entile pdu=%s\n", pdu);
        writeStringToParcel(parcel, pdu);
        rfx_enqueue_urc_message(RIL_UNSOL_RESPONSE_NEW_SMS, parcel, mipc_sim_id_to_slot_id(sim_ps_id), err);
        free(pdu);
    }
}

void mipc_sms_new_on_sim_or_storage_full_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_sms_status_struct *result_ptr,
    void *cb_priv_ptr
)
{
    RFX_LOG_D(RFX_LOG_TAG,"mipc_sms_new_on_sim_or_storage_full_cb\n");
    Parcel * parcel = NULL;
    RIL_Errno err = RIL_E_SUCCESS;

    //result code to ril error transfer
    err = (RIL_Errno)result_ptr->result_code;// Todo
    RFX_LOG_D(RFX_LOG_TAG,"mipc_sms_new_on_sim_or_storage_full_cb err=%d\n",err);

    if(err != MIPC_RESULT_SUCCESS) {
        RFX_LOG_D(RFX_LOG_TAG, "mipc_sms_new_on_sim_or_storage_full_cb error");
        return;
    }else {
        switch(result_ptr->store_flag_btmp){
            case (mipc_sms_store_flag_btmp_enum)MIPC_SMS_STORE_FLAG_NEW_MESSAGE:
                parcel = new Parcel();
                //numInts = responselen / sizeof(int);
                parcel->writeInt32 (1);
                parcel->writeInt32 (result_ptr->message_index);
                rfx_enqueue_urc_message(RIL_UNSOL_RESPONSE_NEW_SMS_ON_SIM,parcel,mipc_sim_id_to_slot_id(sim_ps_id),err);
                RFX_LOG_D(RFX_LOG_TAG, "mipc_sms_new_on_sim_or_storage_full_cb RIL_UNSOL_RESPONSE_NEW_SMS_ON_SIM");
                break;
             case (mipc_sms_store_flag_btmp_enum)MIPC_SMS_STORE_FLAG_STORE_FULL:
                parcel = new Parcel();
                rfx_enqueue_urc_message(RIL_UNSOL_SIM_SMS_STORAGE_FULL,parcel,mipc_sim_id_to_slot_id(sim_ps_id),err);
                RFX_LOG_D(RFX_LOG_TAG, "mipc_sms_new_on_sim_or_storage_full_cb MIPC_SMS_STORE_FLAG_STORE_FULL");
                break;
             default:
                RFX_LOG_D(RFX_LOG_TAG, "mipc_sms_new_on_sim_cb error");
                break;
        }
    }
}

void mipc_sms_ready_notification_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_sms_configuration_struct *result_ptr,
    void *cb_priv_ptr
)
{
    RFX_LOG_D(RFX_LOG_TAG,"mipc_sms_ready_notification_cb\n");
    Parcel * parcel = NULL;
    RIL_Errno err = RIL_E_SUCCESS;

    //result code to ril error transfer
    err = (RIL_Errno)result_ptr->result_code;// Todo

    if(err != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        RFX_LOG_D(RFX_LOG_TAG, "mipc_sms_ready_notification_cb error");
        return;
    }else {
        if ((mipc_sms_storage_state_enum)result_ptr->sms_storage_state == MIPC_SMS_STATE_INITIALIZED){
            mipc_sms_configuration_set_async(sim_ps_id, mipc_sms_cfg_req_cb,NULL, NULL, (mipc_sms_format_enum)0);
            RFX_LOG_D(RFX_LOG_TAG, "mipc_sms_ready_notification_cb MIPC_SMS_STATE_INITIALIZED sim_ps_id=%d",sim_ps_id);
          }
        parcel = new Parcel();
        rfx_enqueue_urc_message(RIL_UNSOL_SMS_READY_NOTIFICATION,parcel,mipc_sim_id_to_slot_id(sim_ps_id),err);
    }
}

void mipc_sms_new_sms_cmd_ind_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_sms_new_cmd_struct *result_ptr,
    void *cb_priv_ptr
)
{
    RequestInfo *pRI;
    RFX_LOG_D(RFX_LOG_TAG,"mipc_sms_new_sms_cmd_ind_cb\n");
    Parcel * parcel = NULL;
    char *pdu ;
    int length/*,i*/;
    // char * ss[2];
    RIL_Errno err = RIL_E_SUCCESS;

     //result code to ril error transfer
    err = (RIL_Errno)result_ptr->result_code;// Todo
    RFX_LOG_D(RFX_LOG_TAG,"mipc_sms_new_sms_cmd_ind_cb err=%d\n",err);

    if(err != MIPC_RESULT_SUCCESS) {
    //result code to ril error transfer
         rfx_enqueue_urc_message(RIL_UNSOL_RESPONSE_NEW_SMS,NULL,mipc_sim_id_to_slot_id(sim_ps_id),err);
    }else {
    parcel = new Parcel();
    #if 0
    length = sizeof(result_ptr->sms_pdu_list[0].pdu)/sizeof(uint8_t);
    for(i = 0;i < length;i++){
    ucharToString(result_ptr->sms_pdu_list[0].pdu[i],ss);
    strcat(pdu,ss);
    RFX_LOG_D(RFX_LOG_TAG,"result_ptr->sms_pdu_list[0].pdu[i]=%d,ss[0]=%d,ss[1]=%d,pdu=%s\n",result_ptr->sms_pdu_list[0].pdu[i],ss[0],ss[1],pdu);
    }
    #endif
    length = result_ptr->sms_pdu_list[0].pdu[0]+1+ result_ptr->sms_pdu_list[0].pdu_len;
    RFX_LOG_D(RFX_LOG_TAG,"length=%d\n",length);
    ucharToStringAll(result_ptr->sms_pdu_list[0].pdu,&pdu,length);
    RFX_LOG_D(RFX_LOG_TAG,"entile pdu=%s\n",pdu);
    writeStringToParcel(parcel,pdu);
    rfx_enqueue_urc_message(RIL_UNSOL_RESPONSE_NEW_SMS,parcel,mipc_sim_id_to_slot_id(sim_ps_id),err);
    free(pdu);
}
}

void mipc_sms_new_sms_status_cmd_ind_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_sms_new_status_report_struct *result_ptr,
    void *cb_priv_ptr
)
{
    RequestInfo *pRI;
    RFX_LOG_D(RFX_LOG_TAG,"mipc_sms_new_sms_status_cmd_ind_cb\n");
    Parcel * parcel = NULL;
    char *pdu ;
    RIL_Errno err = RIL_E_SUCCESS;
    int length;

     //result code to ril error transfer
    err = (RIL_Errno)result_ptr->result_code;// Todo
    if(err != MIPC_RESULT_SUCCESS) {
    //result code to ril error transfer
    rfx_enqueue_urc_message(RIL_UNSOL_RESPONSE_NEW_SMS_STATUS_REPORT,NULL,mipc_sim_id_to_slot_id(sim_ps_id),err);
    }else {
    parcel = new Parcel();
    length = result_ptr->pdu_len;
    ucharToStringAll(result_ptr->pdu,&pdu,length);
    RFX_LOG_D(RFX_LOG_TAG,"entile pdu=%s\n",pdu);
    writeStringToParcel(parcel,pdu);//need traverse
    rfx_enqueue_urc_message(RIL_UNSOL_RESPONSE_NEW_SMS_STATUS_REPORT,parcel,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    free(pdu);
    }
}

void mipc_sms_new_cbm_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_sms_new_cbm_ind_struct *result_ptr,
    void *cb_priv_ptr)
{
    RFX_LOG_D(RFX_LOG_TAG,"mipc_sms_new_cbm_cb\n");
    Parcel * parcel = NULL;
    char *pdu = NULL ;
    int length = 0, pdu_len = 0;
    RIL_Errno err = RIL_E_SUCCESS;
    RFX_LOG_D(RFX_LOG_TAG,"mipc_sms_new_cbm_cb err=%d\n",err);

    if (result_ptr == NULL) {
        RFX_LOG_D(RFX_LOG_TAG, "mipc_sms_new_cbm_sms_cb result_ptr invalid");
        return;
    }

    if(strlen((const char*)result_ptr->data) == 0 && strlen((const char*)result_ptr->secur_info) == 0) {
        RFX_LOG_D(RFX_LOG_TAG,
                "mipc_sms_new_cbm_sms_cb result_ptr->data && result_ptr->secur_info  invalid, cbm_type=%d",
                result_ptr->cbm_type);
        return;
    }

    err = (RIL_Errno)result_ptr->result_code;
    if (err  != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        RFX_LOG_D(RFX_LOG_TAG, "mipc_sms_new_cbm_sms_cb error");
        return;
    } else {
        parcel = new Parcel();

        RFX_LOG_D(RFX_LOG_TAG, "mipc_sms_new_cbm_sms_cb pdu cbm_type=%d", result_ptr->cbm_type);

        if (result_ptr->cbm_type == MIPC_SMS_CBM_TYPE_ETWS_PRIMARY) {
            parcel->writeInt32(strlen((const char*)result_ptr->secur_info));
            parcel->write((void *)result_ptr->secur_info, strlen((const char*)result_ptr->secur_info));

            ucharToStringAll(result_ptr->secur_info, &pdu, strlen((const char*)result_ptr->secur_info));

            if (pdu == NULL) {
                RFX_LOG_D(RFX_LOG_TAG, "mipc_sms_new_cbm_sms_cb pdu invalid");
                return;
            }

            RFX_LOG_D(RFX_LOG_TAG,"entile secur_info=%s, pdu=%s, len=%d",
                    result_ptr->secur_info, pdu, strlen((const char*)result_ptr->secur_info));
        } else {
            parcel->writeInt32(strlen((const char*)result_ptr->data));
            parcel->write((void *)result_ptr->data, strlen((const char*)result_ptr->data));

            ucharToStringAll(result_ptr->data, &pdu, strlen((const char*)result_ptr->data));

            if (pdu == NULL) {
                RFX_LOG_D(RFX_LOG_TAG, "mipc_sms_new_cbm_sms_cb pdu invalid");
                return;
            }

            RFX_LOG_D(RFX_LOG_TAG,"entile data=%s, pdu=%s, len=%d",
                    result_ptr->data, pdu, strlen((const char*)result_ptr->data));
        }

        rfx_enqueue_urc_message(RIL_UNSOL_RESPONSE_NEW_BROADCAST_SMS,parcel,mipc_sim_id_to_slot_id(sim_ps_id),err);
        free(pdu);
    }
}

void RpSmsController::onInit() {
    int slotid;
    RfxController::onInit();  // Required: invoke super class implementation

    RFX_LOG_D(RFX_LOG_TAG, "RpSmsController onInit");

    const int request_id_list[] = {
    RIL_REQUEST_SEND_SMS,  // 25
    RIL_REQUEST_SEND_SMS_EXPECT_MORE, //26
    RIL_REQUEST_DELETE_SMS_ON_SIM, //64
    RIL_REQUEST_GET_SMSC_ADDRESS, //100
    RIL_REQUEST_SET_SMSC_ADDRESS, //101
    RIL_REQUEST_IMS_SEND_SMS, //113
    RIL_REQUEST_WRITE_SMS_TO_SIM, //63
    RIL_REQUEST_SMS_ACKNOWLEDGE,//91
    RIL_REQUEST_GSM_GET_BROADCAST_SMS_CONFIG,//89
    RIL_REQUEST_GSM_SET_BROADCAST_SMS_CONFIG,//90
    RIL_REQUEST_GSM_SMS_BROADCAST_ACTIVATION,//91
    RIL_REQUEST_REPORT_SMS_MEMORY_STATUS, //102
    RIL_REQUEST_GET_SMS_SIM_MEM_STATUS,
    RIL_REQUEST_GSM_GET_BROADCAST_LANGUAGE,
    RIL_REQUEST_GSM_SET_BROADCAST_LANGUAGE,
    };

    const int urc_id_list[] = {
    RIL_UNSOL_RESPONSE_NEW_SMS,
    RIL_UNSOL_RESPONSE_NEW_SMS_STATUS_REPORT,
    RIL_UNSOL_RESPONSE_NEW_BROADCAST_SMS //1021
    };
    // register request id list
    registerToHandleRequest(request_id_list,
            sizeof(request_id_list) / sizeof(int));
    registerToHandleUrc(urc_id_list, (sizeof(urc_id_list)/sizeof(int)));
    slotid = getSlotId();
    mipc_sms_configuration_set_async_null(slot_id_to_mipc_sim_id(slotid), mipc_sms_cfg_req_cb_null,NULL, NULL, (mipc_sms_format_enum)0);

    mipc_sms_ind_register(slot_id_to_mipc_sim_id(slotid), mipc_sms_new_sms_cb, NULL);

    mipc_sms_store_status_register(slot_id_to_mipc_sim_id(slotid), mipc_sms_new_on_sim_or_storage_full_cb, NULL);

    mipc_sms_configuration_register(slot_id_to_mipc_sim_id(slotid), mipc_sms_ready_notification_cb, NULL);

    mipc_sms_new_sms_cmd_register(slot_id_to_mipc_sim_id(slotid), mipc_sms_new_sms_cmd_ind_cb, NULL);

    mipc_sms_new_status_report_cmd_register(slot_id_to_mipc_sim_id(slotid), mipc_sms_new_sms_status_cmd_ind_cb, NULL);

    mipc_sms_new_cbm_ind_register(slot_id_to_mipc_sim_id(slotid), mipc_sms_new_cbm_cb, NULL);
    RFX_LOG_D(RFX_LOG_TAG, "RpSmsController onInit done");
}

void RpSmsController::onDeinit() {
    RFX_LOG_D(RFX_LOG_TAG, "onDeinit");
    RfxController::onDeinit();
}

bool RpSmsController::onHandleUrc(const sp<RfxMessage>& message) {
    RFX_LOG_D(RFX_LOG_TAG, "Handle URC %d", message->getId());

    switch (message->getId()) {
    case RIL_UNSOL_RESPONSE_NEW_SMS: {
         getNonSlotScopeStatusManager()->setIntValue(RFX_STATUS_KEY_GSM_INBOUND_SMS_TYPE,SMS_INBOUND_3GPP_CMT);
        break;
    }
    case RIL_UNSOL_RESPONSE_NEW_SMS_STATUS_REPORT: {
         getNonSlotScopeStatusManager()->setIntValue(RFX_STATUS_KEY_GSM_INBOUND_SMS_TYPE,SMS_INBOUND_3GPP_CDS);
        break;
    }
    default:
        break;
    }
    return RfxController::onHandleUrc(message);
}


bool RpSmsController::onHandleRequest(const sp<RfxMessage>& message) {
    RFX_LOG_D(RFX_LOG_TAG, "Handle request %d", message->getId());

    RfxDispatchThread::addMessageToPendingQueue(message);

    switch (message->getId()) {
    case RIL_REQUEST_SEND_SMS:
    case RIL_REQUEST_SEND_SMS_EXPECT_MORE:
    case RIL_REQUEST_IMS_SEND_SMS:
        handleSMSRequest(message);
        break;
    case RIL_REQUEST_DELETE_SMS_ON_SIM:
        handleDeleteSMSOnSIMRequest(message);
        break;
    case  RIL_REQUEST_GET_SMSC_ADDRESS:
        handleGetSmscAddressRequest(message);
        break;
    case RIL_REQUEST_SET_SMSC_ADDRESS:
        handleSetSmscAddressRequest(message);
        break;
    case RIL_REQUEST_WRITE_SMS_TO_SIM:
        handleWriteSmsToSimRequest(message);
        break;
    case  RIL_REQUEST_SMS_ACKNOWLEDGE:
        handleAcknowledgeRequest(message);
        break;
    case RIL_REQUEST_GSM_GET_BROADCAST_SMS_CONFIG:
        handleGsmGetCbSmsCfg(message);
        break;
    case RIL_REQUEST_GSM_SET_BROADCAST_SMS_CONFIG:
        handleGsmSetCbSmsCfg(message);
        break;
    case RIL_REQUEST_GSM_SMS_BROADCAST_ACTIVATION:
        handleGsmCbSmsActivation(message);
    case RIL_REQUEST_REPORT_SMS_MEMORY_STATUS:
        handleReportSmsMemStatus(message);
        break;
    case RIL_REQUEST_GET_SMS_SIM_MEM_STATUS:
        handleGetSmsSimMemStatus(message);
        break;
    case RIL_REQUEST_GSM_GET_BROADCAST_LANGUAGE:
        handleGsmGetCbSmsLanguage(message);
        break;
    case RIL_REQUEST_GSM_SET_BROADCAST_LANGUAGE:
        handleGsmSetCbSmsLanguage(message);
        break;
    default:
        RFX_LOG_D(RFX_LOG_TAG, "unknown request, ignore!");
        break;
    }
    return true;
}

static char *
strdupReadString(Parcel &p) {
    size_t stringlen;
    const char16_t *s16;

    s16 = p.readString16Inplace(&stringlen);

    return strndup16to8(s16, stringlen);
}

static void
memsetString (char *s) {
    if (s != NULL) {
        memset (s, 0, strlen(s));
    }
}

void mipc_sms_send_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_sms_send_struct *result_ptr,
    void *cb_priv_ptr
) {
    RIL_Errno err = RIL_E_SUCCESS;
    RFX_LOG_D(RFX_LOG_TAG,"mipc_sms_send_cb data %d\n",result_ptr->message_reference);
    Parcel * parcel = NULL;

    err = (RIL_Errno)result_ptr->result_code;
    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),err);
    }else {
        parcel = new Parcel();
        int reference = (int)result_ptr->message_reference;
        int code = (int)result_ptr->result_code;
        parcel->writeInt32(reference);
        parcel->writeInt32(code);

        rfx_enqueue_response_message(parcel,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),err);
    }
}

int smsHexCharToDecInt(char *hex, int length) {
    int i = 0;
    int value, digit;

    for (i = 0, value = 0; i < length && hex[i] != '\0'; i++) {
        if (hex[i]>='0' && hex[i]<='9') {
            digit = hex[i] - '0';
        } else if ( hex[i]>='A' && hex[i] <= 'F') {
            digit = hex[i] - 'A' + 10;
        } else if ( hex[i]>='a' && hex[i] <= 'f') {
            digit = hex[i] - 'a' + 10;
        } else {
            return -1;
        }
        value = value*16 + digit;
    }

    return value;
}

bool smsFoCheck(int fo) {
    /* Check Message Type Identifier */
    if ((fo & TPDU_MTI_BITS) >= TPDU_MTI_RESERVED)
        return false;

    /* Check Validity Period , currently only relative format supported */
    if ((((fo & TPDU_VPF_BITS) >> 3) != TPDU_VPF_NOT_PRESENT) &&
        (((fo & TPDU_VPF_BITS) >> 3) != TPDU_VPF_RELATIVE))
        return false;

    return true;
}
bool smsPidCheck(int pid) {
    bool ret_val = true;
    RFX_LOG_D(RFX_LOG_TAG,"smsPidCheck, pid=%d", pid);

    if (pid != TPDU_PID_DEFAULT_PID) {
        /*
         * Check for reserved and SC specific use of
         * * PID value
         */
        if (((pid & TPDU_PID_CHECK) == TPDU_PID_CHECK) ||
            ((pid & TPDU_PID_CHECK) == TPDU_PID_RESERVED)) {
            ret_val = false;
        }
    }
    return ret_val;
}

bool smsDcsCheck(int dcs) {
    bool ret_val = true;
    unsigned char coding_group;
    RFX_LOG_D(RFX_LOG_TAG,"smsDcsCheck, dcs=%d", dcs);

    if (dcs == 0) /* Default DCS */
        return true;

    coding_group = dcs & 0xf0;

    /* bit7..bit4=1111: Data coding/message class */
    if ((dcs & TPDU_DCS_CODING2) == TPDU_DCS_CODING2) {
        /* Bit3 is reserved, shall equals to zero */
        if ((dcs & TPDU_DCS_RESERVE_BIT) == TPDU_DCS_RESERVE_BIT) {
            ret_val = false;
        }
    } else if ((dcs & TPDU_DCS_CODING1) == 0x00) {
        /* bit7..bit4=00xx: General Data coding indication */
        /* bit 3 and bit 2 are reserved */
        if ((dcs & TPDU_DCS_ALPHABET_CHECK) == TPDU_DCS_ALPHABET_CHECK) {
            ret_val = false;
        } else if ((dcs & TPDU_DCS_COMPRESS_CHECK) == TPDU_DCS_COMPRESS_CHECK) {
            /* Currently, not support compression */
            ret_val = false;
        }
    } else if ((coding_group & 0xc0) == 0x80) {
        ret_val = false;
    } else if ((coding_group == 0xc0) || (coding_group == 0xd0) || (coding_group == 0xe0)) {
        /* Bit2 is reserved, shall equals to zero */
        if ((dcs & 0x04) == 0x04) {
            ret_val = false;
        }
    }

    return ret_val;
}

void smsDecodeDcs(int dcs, SMS_ENCODING_ENUM *alphabet_type,
    SMS_MESSAGE_CLASS_ENUM *msg_class, bool *is_compress) {
    unsigned char coding_group;

    /* Default DCS value */
    *alphabet_type = SMS_ENCODING_7BIT;
    *msg_class = SMS_MESSAGE_CLASS_UNSPECIFIED;
    *is_compress = false;

    if (dcs == 0)
        return;

    if (dcs == 0x84) {
        *alphabet_type = SMS_ENCODING_16BIT;
        return;
    }

    coding_group = dcs >> 4;

    if (coding_group == 0x0f) {
        /* Data Coding/Message Class */
        /*
         * SCR: 2001,
         * * ensure the reserved bit is zero
         */
        if ((dcs & 0x08) == 0x08) {
            *alphabet_type = SMS_ENCODING_UNKNOWN;
        } else {
            *msg_class = (SMS_MESSAGE_CLASS_ENUM) (dcs & 0x03);
            *alphabet_type = (SMS_ENCODING_ENUM) ((dcs & 0x04) >> 2);
        }
    } else if ((coding_group | 0x07) == 0x07) { /* General Data Coding Scheme */
        if ((dcs & 0x10) == 0x10)
            *msg_class = (SMS_MESSAGE_CLASS_ENUM) (dcs & 0x03);
        else
            *msg_class = SMS_MESSAGE_CLASS_UNSPECIFIED;

        *alphabet_type = (SMS_ENCODING_ENUM) ((dcs >> 2) & 0x03);
        if (((coding_group & 0x02) >> 1) == 1)
            *is_compress = true;
    } else if ((coding_group & 0x0c) == 0x08) {
        /*
         * according GSM 23.038 clause 4:
         * "Any reserved codings shall be assumed to be the GSM 7 bit default alphabet."
         */
    } else if (((coding_group & 0x0f) == 0x0c) || /* discard */
             ((coding_group & 0x0f) == 0x0d) || /* store, gsm-7 */
             ((coding_group & 0x0f) == 0x0e))   /* store, ucs2 */ {
        /* 1110: msg wait ind (store, ucs2) */
        if ((coding_group & 0x0f) == 0x0e)
            *alphabet_type = SMS_ENCODING_16BIT;
    }

    /*
     * if the reserved bit been set or the alphabet_type uses the reserved one,
     * then according GSM 23.038 clause 4:
     * "Any reserved codings shall be assumed to be the GSM default alphabet."
     * we change it as SMSAL_GSM7_BIT
     */

    if (*alphabet_type == SMS_ENCODING_UNKNOWN) {
        *alphabet_type = SMS_ENCODING_7BIT;
    }
}

bool smsIsLenIn8bit(int dcs) {
    bool is_compress;
    SMS_ENCODING_ENUM alphabet_type;
    SMS_MESSAGE_CLASS_ENUM mclass;

    smsDecodeDcs(dcs, &alphabet_type, &mclass, &is_compress);

    if ((is_compress == true) ||
        (alphabet_type == SMS_ENCODING_8BIT) ||
        (alphabet_type == SMS_ENCODING_16BIT)) {
        return true;
    } else {
        return false;
    }

}

unsigned int smsMsgLenInOctet(int dcs, int len) {
    if (smsIsLenIn8bit(dcs)) {
        return len;
    } else {
        return (len * 7 + 7) / 8;
    }
}

bool smsSubmitPduCheck(uint16_t pdu_len, uint8_t pdu_array[],
        TPDU_ERROR_CAUSE_ENUM  *error_cause) {
    unsigned char off = 0; /* offset */
    int dcs;
    int fo;
    unsigned char udl, user_data_len;
    int i=0;
    //int pdu_array[pdu_len/2];

    *error_cause = TPDU_NO_ERROR;
    RFX_LOG_D(RFX_LOG_TAG, "smsSubmitPduCheck, pdu_len=%d", pdu_len);

    /* check length */
    if (pdu_len/2 > TPDU_MAX_TPDU_SIZE || pdu_len == 0) {
        *error_cause = TPDU_MSG_LEN_EXCEEDED;
        return false;
    }

    /* check sca */
    RFX_LOG_D(RFX_LOG_TAG, "SMSC address len =%d", pdu_array[0]);
    if (pdu_array[0] > TPDU_MAX_ADDR_LEN)
        return false;

    off += (1 + pdu_array[0]); /* move to head of TPDU (skip sca_len, sca) */

    /* check this pdu is SMS-SUBMIT or not */
    RFX_LOG_D(RFX_LOG_TAG,"First Octet =%d, off=%d", pdu_array[off], off);
    if ((pdu_array[off] & TPDU_MTI_BITS) != TPDU_MTI_SUBMIT) {
        RFX_LOG_D(RFX_LOG_TAG, "TPDU_MTI_SUBMIT fail");
        return false;
    }

    /* check fo */
    fo = pdu_array[off];
    if (smsFoCheck(pdu_array[off]) == false) {
        RFX_LOG_D(RFX_LOG_TAG, "smsFoCheck fail");
        return false;
    }

    off += 2; /* move to da, (skip fo and msg_ref) */

    /* check da */
    RFX_LOG_D(RFX_LOG_TAG,"DA length =%d, off=%d", pdu_array[off], off);
    if (pdu_array[off] > (TPDU_MAX_ADDR_LEN - 1) * 2) {
        RFX_LOG_D(RFX_LOG_TAG,"DA length check fail");
        return false;
    }

    off += 1 + 1 + ((pdu_array[off]+1)/2); /* skip addr_len, addr digits & addr type */

    /* check pid */
    RFX_LOG_D(RFX_LOG_TAG,"pid =%d, off=%d", pdu_array[off], off);
    if (smsPidCheck(pdu_array[off]) == false) {
        RFX_LOG_D(RFX_LOG_TAG, "smsPidCheck check fail");
        return false;
    }

    off++; /* move to dcs */

    /* check dcs */
    RFX_LOG_D(RFX_LOG_TAG,"dcs =%d, off=%d", pdu_array[off], off);
    dcs = pdu_array[off];
    if (smsDcsCheck(dcs) == false) {
        RFX_LOG_D(RFX_LOG_TAG, "rild_sms_dcs_check check fail");
        return false;
    }

    /* move to udl */
    if (((fo & TPDU_VPF_BITS) >> 3) == TPDU_VPF_RELATIVE)
        off += 2; /* VP is relative format (1 byte) */
    else
        off++; /* VP not present */

    /* udl */
    RFX_LOG_D(RFX_LOG_TAG,"udl=%d, off=%d", pdu_array[off], off);
    udl = pdu_array[off];

    /* move to user data */
    off++;

    user_data_len = (unsigned char) smsMsgLenInOctet(dcs, udl);
    RFX_LOG_D(RFX_LOG_TAG,"user_data_len=%d", user_data_len);

    if (user_data_len > TPDU_ONE_MSG_OCTET || (user_data_len != (pdu_len/2 - off))) {
        *error_cause = TPDU_MSG_LEN_EXCEEDED;
        return false;
    }

    return true;
}

//yue add end
void RpSmsController::handleSMSRequest(const sp<RfxMessage>& request) {
    RFX_LOG_D(RFX_LOG_TAG, "handleSMSRequest with clientId: %d, with token: %d",
            request->getClientId(), request->getToken());
    int32_t countStrings = 0;
    int32_t status = 0;
    uint16_t datalen = 0;
    uint8_t **pStrings = NULL;
    RIL_IMS_SMS_Message rism;
    char *pdu = NULL;
    uint8_t pdulen = 0;
    TPDU_ERROR_CAUSE_ENUM error_cause = TPDU_NO_ERROR;
    uint8_t *pdu_array = NULL;

    int32_t  t = 0;
    RIL_RadioTechnologyFamily format;
    uint8_t retry = 0;
    int32_t messageRef;
    RIL_Errno err = RIL_E_SUCCESS;


    Parcel *p = request->getParcel();
    if(p != NULL) {
        switch (request->getId()) {
            case RIL_REQUEST_SEND_SMS:
            case RIL_REQUEST_SEND_SMS_EXPECT_MORE:
                RFX_LOG_D(RFX_LOG_TAG,"handleSMSRequest RIL_REQUEST_SEND_SMS or RIL_REQUEST_SEND_SMS_EXPECT_MORE\n");
                status = p->readInt32(&countStrings);
                if (status != 0) {
                    RFX_LOG_D(RFX_LOG_TAG,"handleSMSRequest readerror\n");
                    return;
                }
                if (countStrings == 0) {
                    // just some non-null pointer
                    pStrings = (uint8_t **)calloc(1, sizeof(uint8_t *));
                    if (pStrings == NULL) {
                        return;
                    }
                    datalen = 0;
                } else if (countStrings < 0) {
                    pStrings = NULL;
                    datalen = 0;
                } else {
                    pStrings = (uint8_t **)calloc(countStrings, sizeof(uint8_t *));
                    if (pStrings == NULL) {
                        return;
                    }
                    pdu= (char *)malloc(((MAX_SMSC_LENGTH+MAX_TPDU_LENGTH+1)*2+1)*sizeof(char));
                    memset(pdu,0,((MAX_SMSC_LENGTH+MAX_TPDU_LENGTH+1)*2+1));

                    // Get SMSC
                    pStrings[0] = (uint8_t *)strdupReadString(*p);
                    if (pStrings[0] == NULL || strlen((const char *)pStrings[0]) == 0) {
                        RFX_LOG_D(RFX_LOG_TAG, "SMSC is NULL");
                    } else if ((strlen((const char *)pStrings[0]) % 2) != 0 ||
                            (strlen((const char *)pStrings[0])) < 2 ||
                            ((strlen((const char *)pStrings[0])) / 2 - 1) > MAX_SMSC_LENGTH) {
                        RFX_LOG_D(RFX_LOG_TAG, "invalid SMSC length: %d", strlen((const char *)pStrings[0]));
                        err = RIL_E_GENERIC_FAILURE;
                        break;
                    }

                    // Get TPDU
                    pStrings[1] = (uint8_t *)strdupReadString(*p);
                    if (pStrings[1] == NULL) {
                        RFX_LOG_D(RFX_LOG_TAG, "invalid TPDU, not allow NULL");
                        err = RIL_E_GENERIC_FAILURE;
                        break;
                    } else if ((strlen((const char *)pStrings[1]) % 2) != 0 ||
                            (strlen((const char *)pStrings[1])) < 2 ||
                            ((strlen((const char *)pStrings[1])) / 2) > MAX_TPDU_LENGTH) {
                        RFX_LOG_D(RFX_LOG_TAG, "invalid TPDU length: %d", strlen((const char *)pStrings[1]));
                        err = RIL_E_GENERIC_FAILURE;
                        break;
                    }

                    // Append SMSC and TPDU
                    if (pStrings[0] == NULL) {
                        sprintf(pdu, "00%s", pStrings[1]);
                    } else {
                        sprintf(pdu, "%s%s", pStrings[0], pStrings[1]);
                    }

                    datalen = strlen((const char*)pdu);
                    pdulen = strlen((const char*)pStrings[1])/2;
                    RFX_LOG_D(RFX_LOG_TAG,"datalen222=%d,pdu=%s\n", datalen,pdu);
                    //int pdu_array[datalen/2];
                    pdu_array = (uint8_t *)malloc(sizeof(uint8_t)*datalen/2);
                    for (int i = 0; i < datalen/2 ;i++) {
                        pdu_array[i] = smsHexCharToDecInt((pdu+2*i), 2);
                        RFX_LOG_D(RFX_LOG_TAG,"pdu_array[%d]=0x%x\n", i,pdu_array[i]);
                    }
                    if (smsSubmitPduCheck(datalen, pdu_array, &error_cause) == false) {
                        RFX_LOG_D(RFX_LOG_TAG, "smsPackPdu error, error_cause = %d", error_cause);
                        err = RIL_E_GENERIC_FAILURE;
                        break;
                    } else {
                        RFX_LOG_D(RFX_LOG_TAG,"smsPackPdu pass");
                    }
                }
                if (request->getId() == RIL_REQUEST_SEND_SMS)
                    mipc_sms_send_async(slot_id_to_mipc_sim_id(request->getSlotId()),mipc_sms_send_cb, (void *)request->getRilToken(),pdulen,pdu_array,(mipc_sms_format_enum)0, 0xFE);
                else
                    mipc_sms_send_async(slot_id_to_mipc_sim_id(request->getSlotId()),mipc_sms_send_cb, (void *)request->getRilToken(),pdulen,pdu_array,(mipc_sms_format_enum)0, 1);
                break;
            case RIL_REQUEST_IMS_SEND_SMS:
                RFX_LOG_D(RFX_LOG_TAG,"handleSMSRequest RIL_REQUEST_IMS_SEND_SMS\n");
                status = p->readInt32(&t);
                if (status != 0) {
                    return;
                }
                format = (RIL_RadioTechnologyFamily) t;
                status = p->read(&retry,sizeof(retry));
                if (status != 0) {
                    return;
                }
                status = p->read(&messageRef,sizeof(messageRef));
                if (status != 0) {
                    return;
                }
                if (RADIO_TECH_3GPP == format) {
                    status = p->readInt32 (&countStrings);
                    if (status != 0) {
                        return;
                    }
                    memset(&rism, 0, sizeof(rism));
                    rism.tech = RADIO_TECH_3GPP;
                    rism.retry = retry;
                    rism.messageRef = messageRef;
                    if (countStrings == 0) {
                    // just some non-null pointer
                        pStrings = (uint8_t **)calloc(1, sizeof(uint8_t *));
                        if (pStrings == NULL) {
                            RFX_LOG_D(RFX_LOG_TAG,"Memory allocation failed for request\n");
                            return;
                        }
                        datalen = 0;
                    } else if (countStrings < 0) {
                        pStrings = NULL;
                        datalen = 0;
                        return;
                    } else {
                        if ((size_t)countStrings > (INT_MAX/sizeof(char *))) {
                            RFX_LOG_D(RFX_LOG_TAG,"Invalid value of countStrings: \n");
                            return;
                        }
                        pStrings = (uint8_t **)calloc(countStrings, sizeof(uint8_t *));
                        if (pStrings == NULL) {
                            RFX_LOG_D(RFX_LOG_TAG,"Memory allocation failed for request");
                            return;
                        }

                        pdu = (char *)malloc(((MAX_SMSC_LENGTH+MAX_TPDU_LENGTH+1)*2+1)*sizeof(char));
                        memset(pdu,0,((MAX_SMSC_LENGTH+MAX_TPDU_LENGTH+1)*2+1));

                        // Get SMSC
                        pStrings[0] = (uint8_t *)strdupReadString(*p);
                        if (pStrings[0] != NULL || strlen((const char *)pStrings[0]) == 0) {
                            RFX_LOG_D(RFX_LOG_TAG, "SMSC is NULL");
                        } else if ((strlen((const char *)pStrings[0]) % 2) != 0 ||
                                (strlen((const char *)pStrings[0])) < 2 ||
                                ((strlen((const char *)pStrings[0])) / 2 - 1) > MAX_SMSC_LENGTH) {
                            RFX_LOG_D(RFX_LOG_TAG, "invalid SMSC length: %d", strlen((const char *)pStrings[0]));
                            err = RIL_E_GENERIC_FAILURE;
                            break;
                        }

                        // Get TPDU
                        pStrings[1] = (uint8_t *)strdupReadString(*p);
                        if (pStrings[1] == NULL) {
                            RFX_LOG_D(RFX_LOG_TAG, "invalid TPDU, not allow NULL");
                            err = RIL_E_GENERIC_FAILURE;
                            break;
                        } else if ((strlen((const char *)pStrings[1]) % 2) != 0 ||
                                (strlen((const char *)pStrings[1])) < 2 ||
                                ((strlen((const char *)pStrings[1])) / 2) > MAX_TPDU_LENGTH) {
                            RFX_LOG_D(RFX_LOG_TAG, "invalid TPDU length: %d", strlen((const char *)pStrings[1]));
                            err = RIL_E_GENERIC_FAILURE;
                            break;
                        }

                        // Append SMSC and TPDU
                        if (pStrings[0] == NULL) {
                            sprintf(pdu, "00%s", pStrings[1]);
                        } else {
                            sprintf(pdu, "%s%s", pStrings[0], pStrings[1]);
                        }

                        datalen = strlen((const char*)pdu);
                        pdulen = strlen((const char*)pStrings[1])/2;
                        RFX_LOG_D(RFX_LOG_TAG,"datalen222=%d,pdu=%s\n", datalen,pdu);
                        //int pdu_array[datalen/2];
                        pdu_array = (uint8_t *)malloc(sizeof(uint8_t)*datalen/2);
                        for (int i = 0; i < datalen/2 ;i++) {
                            pdu_array[i] = smsHexCharToDecInt((pdu+2*i), 2);
                            RFX_LOG_D(RFX_LOG_TAG,"pdu_array[%d]=0x%x\n", i,pdu_array[i]);
                        }
                        if (smsSubmitPduCheck(datalen, pdu_array, &error_cause) == false) {
                            RFX_LOG_D(RFX_LOG_TAG, "smsPackPdu error, error_cause = %d", error_cause);
                            err = RIL_E_GENERIC_FAILURE;
                            break;
                        } else {
                            RFX_LOG_D(RFX_LOG_TAG,"smsPackPdu pass");
                        }
                        mipc_sms_send_async(slot_id_to_mipc_sim_id(request->getSlotId()),mipc_sms_send_cb, (void *)request->getRilToken(),pdulen,pdu_array,(mipc_sms_format_enum)0, 0xFE);
                        }
                    }else {
                        RFX_LOG_D(RFX_LOG_TAG,"handleSMSRequest RIL_REQUEST_IMS_SEND_SMS do nothing\n");
                        return;
                    }
                    //assign parameter from request data to mipc api parameter
                break;
        }

        if (pStrings != NULL) {
            free(pStrings);
        }

        if (pdu_array != NULL) {
            free(pdu_array);
        }

        if (pdu != NULL) {
            free(pdu);
        }
    }

    if (err != RIL_E_SUCCESS) {
        rfx_enqueue_response_message(NULL, request->getRilToken(), (RIL_SOCKET_ID)request->getSlotId(), err);
    }
}

void mipc_delete_sms_on_sim_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_sms_delete_struct *result_ptr,
    void *cb_priv_ptr
    )
{
    RIL_Errno err = RIL_E_SUCCESS;

    Parcel * parcel = NULL;
    err = (RIL_Errno)result_ptr->result_code;
     RFX_LOG_D(RFX_LOG_TAG,"mipc_delete_sms_on_sim_cb err=%d\n",err);
    if(err != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),err);
    }else {
        parcel = new Parcel();
        rfx_enqueue_response_message(parcel,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),err);
    }
}

//MIPC_SMS_DELETE_CB cb
void RpSmsController::handleDeleteSMSOnSIMRequest(const sp<RfxMessage>& request) {
    RFX_LOG_D(RFX_LOG_TAG, "handleDeleteSMSOnSIMRequest with clientId: %d, with token: %d",
        request->getClientId(), request->getToken());

    int32_t count = 0;
    int32_t status = 0;
    int32_t index = 0;

    Parcel *p = request->getParcel();
    if(p != NULL) {
        status = p->readInt32 (&count);
        if (status != 0 || count <= 0) {
            RFX_LOG_D(RFX_LOG_TAG,"handleDeleteSMSOnSIMRequest readerror\n");
            return;
        }
        status = p->readInt32(&index);
        RFX_LOG_D(RFX_LOG_TAG, "handleDeleteSMSOnSIMRequest index=%d\n",index);
    }

    if (index > 0) {
        mipc_sms_delete_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_delete_sms_on_sim_cb, (void *)request->getRilToken(),
                (mipc_sms_flag_enum)MIPC_SMS_FLAG_INDEX,(uint16_t)index);
    } else {
        RFX_LOG_D(RFX_LOG_TAG, "handleDeleteSMSOnSIMRequest delete all, index=%d\n", index);
        mipc_sms_delete_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_delete_sms_on_sim_cb, (void *)request->getRilToken(),
                (mipc_sms_flag_enum)MIPC_SMS_FLAG_ALL,(uint16_t)0);
    }
}

void mipc_get_smsc_address_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_sms_configuration_struct *result_ptr,
    void *cb_priv_ptr
)
{
    RIL_Errno err = RIL_E_SUCCESS;
    char *smsc ;
    int length;
    Parcel * parcel = NULL;
    err = (RIL_Errno)result_ptr->result_code;
    RFX_LOG_D(RFX_LOG_TAG, "mipc_get_smsc_address_cb err=%d\n",err);

    if (err != MIPC_RESULT_SUCCESS) {
        rfx_enqueue_response_message(NULL, cb_priv_ptr, mipc_sim_id_to_slot_id(sim_ps_id), RIL_E_GENERIC_FAILURE);
    } else {
        length = strlen(result_ptr->sc_address);
        charToStringSca((uint8_t*)result_ptr->sc_address, &smsc, length);
        RFX_LOG_D(RFX_LOG_TAG, "entile smsc=%s\n",smsc);
        parcel = new Parcel();
        writeStringToParcel(parcel, (const char *)result_ptr->sc_address);
        rfx_enqueue_response_message(parcel, cb_priv_ptr, mipc_sim_id_to_slot_id(sim_ps_id), RIL_E_SUCCESS);
        free(smsc);
    }
}


void RpSmsController::handleGetSmscAddressRequest(const sp<RfxMessage>& request) {
    RFX_LOG_D(RFX_LOG_TAG, "handleGetSmscAddressRequest with clientId: %d, with token: %d",
        request->getClientId(), request->getToken());
    mipc_sms_configuration_get_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_get_smsc_address_cb, (void *)request->getRilToken());
}

void mipc_set_smsc_address_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_sms_configuration_struct *result_ptr,
    void *cb_priv_ptr
)
{
    RIL_Errno err = RIL_E_SUCCESS;
    Parcel *parcel = NULL;
    err = (RIL_Errno)result_ptr->result_code;

    RFX_LOG_D(RFX_LOG_TAG, "mipc_set_smsc_address_cb, result=%d\n", err);

    if (err != MIPC_RESULT_SUCCESS) {
        rfx_enqueue_response_message(NULL, cb_priv_ptr, mipc_sim_id_to_slot_id(sim_ps_id), RIL_E_GENERIC_FAILURE);
    } else {
        parcel = new Parcel();
        rfx_enqueue_response_message(parcel, cb_priv_ptr, mipc_sim_id_to_slot_id(sim_ps_id), RIL_E_SUCCESS);
    }
}

void RpSmsController::handleSetSmscAddressRequest(const sp<RfxMessage>& request) {
    RFX_LOG_D(RFX_LOG_TAG, "handleSetSmscAddressRequest with clientId: %d, with token: %d",
        request->getClientId(), request->getToken());
    char *string8 = NULL;
    char smsc[32] = {0};
    Parcel *p = request->getParcel();
    //RFX_LOG_D(RFX_LOG_TAG, "enterhandleSetSmscAddressRequest p=%p\n",p);
    if(p != NULL) {
        string8 = strdupReadString(*p);
    }
    memcpy(smsc, string8, strlen(string8) + 1);
    RFX_LOG_D(RFX_LOG_TAG, "smsc length=%d, string=%s\n",strlen(smsc), smsc);

    mipc_sms_configuration_set_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_set_smsc_address_cb,
            (void *)request->getRilToken(), smsc, (mipc_sms_format_enum)0);

    if(string8 != NULL){
        free(string8);
    }
}

void mipc_write_sms_to_sim_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_sms_write_struct *result_ptr,
    void *cb_priv_ptr
)
{
    RIL_Errno err = RIL_E_SUCCESS;
    RFX_LOG_D(RFX_LOG_TAG,"mipc_write_sms_to_sim_cb\n");
    Parcel * parcel = NULL;
    err = (RIL_Errno)result_ptr->result_code;
    if(err != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),err);
    }else {
        parcel = new Parcel();
        parcel->writeInt32 (1);
        parcel->writeInt32(result_ptr->message_index);
        rfx_enqueue_response_message(parcel,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),err);
    }
}

void RpSmsController::handleWriteSmsToSimRequest(const sp<RfxMessage>& request) {
    RFX_LOG_D(RFX_LOG_TAG, "handleWriteSmsToSimRequest with clientId: %d, with token: %d",
        request->getClientId(), request->getToken());
    char *string8 = NULL;
    int32_t status = 0;
    char *smsc = NULL;
    char *pdu = NULL;
    size_t pdulen = 0;
    uint8_t datalen = 0;
    uint8_t *pdu_array = NULL;

    Parcel *p = request->getParcel();
    RFX_LOG_D(RFX_LOG_TAG, "enterhandleSetSmscAddressRequest p=%p\n",p);
    if(p != NULL) {
        p->readInt32(&status);
        string8 = strdupReadString(*p);
        smsc = strdupReadString(*p);
        RFX_LOG_D(RFX_LOG_TAG, "smsc=%s\n",smsc);
        pdulen = strlen(string8)/2;
        pdu= (char *)malloc(((MAX_SMSC_LENGTH+MAX_TPDU_LENGTH+1)*2+1)*sizeof(char));
        memset(pdu,0,((MAX_SMSC_LENGTH+MAX_TPDU_LENGTH+1)*2+1));
        sprintf(pdu, "%s%s", smsc, string8);
        //strcat((char *)pdu,(char *)pStrings[i]);
        datalen = strlen((const char*)pdu);
        //int pdu_array[datalen/2];
        pdu_array = (uint8_t *)malloc(sizeof(uint8_t)*datalen/2);
        for (int i = 0; i < datalen/2 ;i++) {
            pdu_array[i] = smsHexCharToDecInt((pdu+2*i), 2);
            RFX_LOG_D(RFX_LOG_TAG,"pdu_array[%d]=0x%x\n", i,pdu_array[i]);
        }
        RFX_LOG_D(RFX_LOG_TAG, "datalen=%d,getSlotId=%d,getRilToken=%p,pdulen=%d,pdu=%s,status=%d\n", datalen,slot_id_to_mipc_sim_id(request->getSlotId()),(void *)request->getRilToken(),pdulen,pdu,status);
        }
        mipc_sms_write_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_write_sms_to_sim_cb, (void *)request->getRilToken(),pdulen, pdu_array, (mipc_sms_status_enum)status,(mipc_sms_format_enum)0);
        if (string8 != NULL) {
            free(string8);
        }
        if (pdu != NULL) {
            free(pdu);
        }
        if (pdu_array != NULL) {
            free(pdu_array);
        }
}

void RpSmsController::handleAcknowledgeRequest(const sp<RfxMessage>& request) {
    RFX_LOG_D(RFX_LOG_TAG, "handleAcknowledgeRequest with clientId: %d, with token: %d",
        request->getClientId(), request->getToken());
    int32_t count = 0;
    int32_t status = 0;
    int *pInts = NULL;
    uint8_t successful = MIPC_NEW_SMS_ACK_RP_ERROR;
    uint8_t cause = 0;
    int smsType = 0;
    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;

    Parcel *p = request->getParcel();

    if(p != NULL) {
        status = p->readInt32 (&count);

        if (status != 0 || count <= 0) {
            RFX_LOG_D(RFX_LOG_TAG, "handleAcknowledgeRequest status=%d, count=%d\n", status, count);
            return;
        }

        pInts = (int *)calloc(count, sizeof(int));
        if (pInts == NULL) {
            RFX_LOG_D(RFX_LOG_TAG, "Memory allocation failed for request");
            return;
        }

        for (int i = 0 ; i < count ; i++) {
            int32_t t = 0;

            status = p->readInt32(&t);
            pInts[i] = (int)t;
            RFX_LOG_D(RFX_LOG_TAG, "add dispatchInts pInts[%d]=%d\n", i,pInts[i]);
            if (status != 0) {
                free(pInts);
                return;
            }
        }
        successful = pInts[0];
        if (pInts[0] == 1) {
            successful = MIPC_NEW_SMS_ACK_RP_ACK;
        } else {
            successful = MIPC_NEW_SMS_ACK_RP_ERROR;
        }

        cause = pInts[1] & 0xFF;
    }

    smsType = getNonSlotScopeStatusManager()->getIntValue(RFX_STATUS_KEY_GSM_INBOUND_SMS_TYPE, SMS_INBOUND_NONE);

    if (smsType == SMS_INBOUND_3GPP_CMT) {
        ret = mipc_sms_acknowledge_rsp(
                slot_id_to_mipc_sim_id(request->getSlotId()),
                successful, cause);
    } else if (smsType == SMS_INBOUND_3GPP_CDS) {
        ret = mipc_sms_new_status_report_rsp(
                slot_id_to_mipc_sim_id(request->getSlotId()),
                successful, cause);
    } else {
        RFX_LOG_D(RFX_LOG_TAG,"unsupported type = %d", smsType);
    }

    if (ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_D(RFX_LOG_TAG, "%s fail", __FUNCTION__);
        rfx_enqueue_response_message( NULL, request->getRilToken(),
            (RIL_SOCKET_ID)request->getClientId(), RIL_E_GENERIC_FAILURE);
    } else {
        Parcel *parcel = new Parcel();
        rfx_enqueue_response_message(parcel, request->getRilToken(),
            (RIL_SOCKET_ID)request->getClientId(), RIL_E_SUCCESS);
    }

    RFX_LOG_D(RFX_LOG_TAG, "mipc end\n");

    if (pInts != NULL){
        free(pInts);
    }
}

static void mipc_sms_get_cbm_cfg_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sms_cbm_get_cfg_struct *result_ptr, void *cb_priv_ptr) {
    RIL_Errno err = RIL_E_SUCCESS;
    RFX_LOG_D(RFX_LOG_TAG,"mipc_sms_get_cbm_cfg_cb\n");
    Parcel * parcel = NULL;
    uint32_t start_temp, end_temp;
    uint16_t num = 0;

    err = (RIL_Errno)result_ptr->result_code;
    if (err != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL, cb_priv_ptr, mipc_sim_id_to_slot_id(sim_ps_id), err);
    } else {
        parcel = new Parcel();

        // 1. Write element number
        num = result_ptr->channel_single_num + result_ptr->channel_range_num;
        parcel->writeInt32(num);

        // 2.1 Write change list by single type
        for (int i = 0; i < result_ptr->channel_single_num; i++) {
            parcel->writeInt32((int)result_ptr->channel_single[i]);
            parcel->writeInt32((int)result_ptr->channel_single[i]);
            parcel->writeInt32(NULL);
            parcel->writeInt32(NULL);
            parcel->writeInt32(1);
        }

        // 2.2 Write change list by range type
        for (int i = 0; i < result_ptr->channel_range_num; i++) {
            start_temp = (0xFFFF0000 & result_ptr->channel_range[i]) >> 16;
            end_temp = 0x0000FFFF & result_ptr->channel_range[i];
            parcel->writeInt32((int)start_temp);
            parcel->writeInt32((int)end_temp);
            parcel->writeInt32(NULL);
            parcel->writeInt32(NULL);
            parcel->writeInt32(1);
        }

        // 3. Send AP channel configuration
        RFX_LOG_D(RFX_LOG_TAG,"mipc_sms_get_cbm_cfg_cb, get channel done, channel_single_num=%d, channel_range_num=%d\n",
                result_ptr->channel_single_num, result_ptr->channel_range_num);
        rfx_enqueue_response_message(parcel, cb_priv_ptr, mipc_sim_id_to_slot_id(sim_ps_id), err);
    }
}

void RpSmsController::handleGsmGetCbSmsCfg(const sp<RfxMessage>& request) {
    RFX_LOG_D(RFX_LOG_TAG, "handleGsmGetCbSmsCfg with clientId: %d, with token: %d",
        request->getClientId(), request->getToken());
    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;

    ret = mipc_sms_get_cbm_cfg_async(slot_id_to_mipc_sim_id(request->getSlotId()),
            mipc_sms_get_cbm_cfg_cb, (void *)request->getRilToken(), MIPC_SMS_CB_QUERY_CHANNEL);

    if(ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_D(RFX_LOG_TAG, "%s fail", __FUNCTION__);
        rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_GENERIC_FAILURE);
    }
}

static void mipc_sms_set_cbm_cfg_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_sms_cbm_set_cfg_struct *result_ptr, void *cb_priv_ptr) {
    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),result_ptr->result_code);
        RFX_LOG_D(RFX_LOG_TAG, "%s fail", __FUNCTION__);
    } else {
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id), RIL_E_SUCCESS);
        RFX_LOG_D(RFX_LOG_TAG, "%s success", __FUNCTION__);
    }
}

void RpSmsController::handleGsmSetCbSmsCfg(const sp<RfxMessage>& request) {
    RFX_LOG_D(RFX_LOG_TAG, "handleGsmSetCbSmsCfg with clientId: %d, with token: %d",
        request->getClientId(), request->getToken());
    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;
    int32_t v = 0;
    int32_t num = 0;
    RIL_GSM_BroadcastSmsConfigInfo gsmBci[90];
    uint16_t range_count = 0, single_count = 0;
    uint32_t channel_range[30] = {0};
    uint16_t channel_single[60] = {0};
    uint32_t temp_start, temp_range;
    int start = -1, end = -1;

    // RIL Interface only support allow list, MIPC interface could allow to set BAN list.
    // Now, we always expect upper layer set allow list as smart phone design.
    mipc_sms_cbm_cfg_type_const_enum cfg_type = mipc_sms_cbm_cfg_type_const_enum::MIPC_SMS_CBM_CFG_TYPE_ALLOW;

    do {
        Parcel *p = request->getParcel();
        if(p == NULL) {
            RFX_LOG_D(RFX_LOG_TAG, "handleGsmSetCbSmsCfg p has no data to transfer\n");
            break;
        }
        RFX_LOG_D(RFX_LOG_TAG, "handleGsmSetCbSmsCfg p=%p\n",p);

        p->readInt32(&v);
        num = v;
        RFX_LOG_D(RFX_LOG_TAG, "num %d, %d", v, num);

        memset(gsmBci, 0, (sizeof(RIL_GSM_BroadcastSmsConfigInfo) * 90));

        for (int i = 0 ; i < num ; i++ ) {
            // 1. Read input parameters from parcel
            p->readInt32(&v);
            gsmBci[i].fromServiceId = v;
            RFX_LOG_D(RFX_LOG_TAG, "fromServiceId %d(size:%d), %d(size:%d)",
                    v, sizeof(v), gsmBci[i].fromServiceId, sizeof(gsmBci[i].fromServiceId));

            p->readInt32(&v);
            gsmBci[i].toServiceId = v;
            RFX_LOG_D(RFX_LOG_TAG, "toServiceId %d, %d", v, gsmBci[i].toServiceId);

            p->readInt32(&v);
            gsmBci[i].fromCodeScheme = v;
            RFX_LOG_D(RFX_LOG_TAG, "fromCodeScheme %d, %d", v, gsmBci[i].fromCodeScheme);

            p->readInt32(&v);
            gsmBci[i].toCodeScheme = v;
            RFX_LOG_D(RFX_LOG_TAG, "toCodeScheme %d, %d", v, gsmBci[i].toCodeScheme);

            p->readInt32(&v);
            gsmBci[i].selected = v;
            RFX_LOG_D(RFX_LOG_TAG, "selected %d, %d", v, gsmBci[i].selected);

            // 2. Convert RIL_GSM_BroadcastSmsConfigInfo to ints array
            start = gsmBci[i].fromServiceId;
            end = gsmBci[i].toServiceId;

            RFX_LOG_D(RFX_LOG_TAG, "[index=%d] fromServiceId:%d, toServiceId:%d, start:%d, end:%d", i,
                    gsmBci[i].fromServiceId, gsmBci[i].toServiceId, start, end);

            if (start == end) {
                //channel_single_vet.push_back((uint16_t)start);
                channel_single[single_count++] = (uint16_t)start;
                RFX_LOG_D(RFX_LOG_TAG, "channel_single[index=%d] value:%d",
                        (single_count - 1), channel_single[(single_count - 1)]);
            } else {
                temp_start = (uint32_t)start << 16;
                temp_range = temp_start | (uint32_t)end;
                //channel_range_vet.push_back(temp_range);
                channel_range[range_count++] = temp_range;
                RFX_LOG_D(RFX_LOG_TAG, "channel_range[index=%d] value:%d",
                        (range_count - 1), channel_range[(range_count - 1)]);
            }
        }

        // 3. Call set CB config MIPC API
        ret = mipc_sms_set_cbm_cfg_async(
                slot_id_to_mipc_sim_id(request->getSlotId()), mipc_sms_set_cbm_cfg_cb, (void *)request->getRilToken(),
                cfg_type,
                range_count, channel_range,
                single_count, channel_single,
                0, NULL,
                0, NULL,
                0);
    } while(0);

    if(ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_D(RFX_LOG_TAG, "%s fail", __FUNCTION__);
        rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_GENERIC_FAILURE);
    }
}

void RpSmsController::handleGsmCbSmsActivation(const sp<RfxMessage>& request) {
    RFX_LOG_D(RFX_LOG_TAG, "handleGsmCbSmsActivation with clientId: %d, with token: %d",
        request->getClientId(), request->getToken());
    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;
    status_t status;
    int32_t t;
    int activation;

    do {
        Parcel *p = request->getParcel();
        if(p == NULL) {
            RFX_LOG_D(RFX_LOG_TAG, "handleGsmSetCbSmsCfg p has no data to transfer\n");
            break;
        }
        RFX_LOG_D(RFX_LOG_TAG, "handleGsmCbSmsActivation p=%p\n",p);

        status = p->readInt32(&t);  //Ints number ignore
        if (status != android::NO_ERROR) {
            break;
        }

        status = p->readInt32(&t);  //activation, 0 means on, 1 means off
        if (status != android::NO_ERROR) {
            break;
        }

        activation = (int)t;
        RFX_LOG_D(RFX_LOG_TAG, "Turn GSM CB %s(t=%d)", ((activation == 0) ? "on" : "off"), t);

        if (activation == 1) {
            ret = mipc_sms_set_cbm_cfg_async(
                    slot_id_to_mipc_sim_id(request->getSlotId()), mipc_sms_set_cbm_cfg_cb, (void *)request->getRilToken(),
                    mipc_sms_cbm_cfg_type_const_enum::mipc_sms_cbm_cfg_type_const_NONE,
                    0, NULL,
                    0, NULL,
                    0, NULL,
                    0, NULL,
                    0); // not to activate
        } else if (activation == 0) {
            ret = mipc_sms_set_cbm_cfg_async(
                    slot_id_to_mipc_sim_id(request->getSlotId()), mipc_sms_set_cbm_cfg_cb, (void *)request->getRilToken(),
                    mipc_sms_cbm_cfg_type_const_enum::mipc_sms_cbm_cfg_type_const_NONE,
                    0, NULL,
                    0, NULL,
                    0, NULL,
                    0, NULL,
                    (MIPC_SMS_CBM_TYPE_CMAS | MIPC_SMS_CBM_TYPE_ETWS_PRIMARY |
                    MIPC_SMS_CBM_TYPE_ETWS_SECONDARY | MIPC_SMS_CBM_TYPE_OTHERS)); // activation
        } else {
            break;
        }
    }while(0);

    if (ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_D(RFX_LOG_TAG, "%s fail", __FUNCTION__);
        rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_GENERIC_FAILURE);
    } else {
        RFX_LOG_D(RFX_LOG_TAG, "%s success, ret=%d", __FUNCTION__, ret);
        rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_SUCCESS);
    }
}

static void mipc_set_host_mem_avaiable_cb(mipc_sim_ps_id_enum sim_ps_id, mipc_set_host_mem_avaiable_struct *result_ptr, void *cb_priv_ptr) {
    //RFX_LOG_D(getTag(sim_ps_id).c_str(),"%s, %s", __FUNCTION__, dump_call_dial(result_ptr,cb_priv_ptr).c_str());

    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),result_ptr->result_code);
    }else {
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}

void RpSmsController::handleReportSmsMemStatus(const sp<RfxMessage>& request) {
    RFX_LOG_D(RFX_LOG_TAG, "[%s] with clientId: %d, with token: %d", __FUNCTION__,
        request->getClientId(), request->getToken());
    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;
    status_t status;
    int32_t t;
    int avaiable;

    do {
        if (getStatusManager()->getIntValue(RFX_STATUS_KEY_CARD_TYPE) == 0) {
            RFX_LOG_D(RFX_LOG_TAG, "SIM card was removed!");
            break;
        }
        Parcel *p = request->getParcel();
        if(p == NULL) {
            RFX_LOG_D(RFX_LOG_TAG, "[%s] p has no data to transfer\n", __FUNCTION__);
            break;
        }
        RFX_LOG_D(RFX_LOG_TAG, "[%s] p=%p\n", __FUNCTION__, p);

        // Read ints count
        status = p->readInt32(&t);
        if (status != android::NO_ERROR) {
            break;
        }

        // Read available status
        status = p->readInt32(&t);
        if (status != android::NO_ERROR) {
            break;
        }
        avaiable = (int)t;

        RFX_LOG_D(RFX_LOG_TAG, "[%s]Turn report SMS memory status %s", __FUNCTION__, ((avaiable == 1)? "on" : "off"));

        if (avaiable == 1 || avaiable == 0) {
            ret = mipc_set_host_mem_avaiable_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_set_host_mem_avaiable_cb, (void *)request->getRilToken(), avaiable);
        }
    }while(0);

    if(ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_D(RFX_LOG_TAG, "%s fail", __FUNCTION__);
        rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_GENERIC_FAILURE);
    }
    else {
        RFX_LOG_D(RFX_LOG_TAG, "%s success", __FUNCTION__);
        rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_SUCCESS);
    }
}

static void mipc_sms_store_status_get_cb(
        mipc_sim_ps_id_enum sim_ps_id, mipc_sms_status_struct *result_ptr, void *cb_priv_ptr) {

    RFX_LOG_D(RFX_LOG_TAG, "%s\n", __FUNCTION__);
    Parcel *parcel = NULL;

    if (result_ptr != NULL && result_ptr->result_code == MIPC_RESULT_SUCCESS) {
        parcel = new Parcel();
        parcel->writeInt32(result_ptr->used);
        parcel->writeInt32(result_ptr->total);
        rfx_enqueue_response_message(parcel, cb_priv_ptr, mipc_sim_id_to_slot_id(sim_ps_id), RIL_E_SUCCESS);
        RFX_LOG_D(RFX_LOG_TAG, "%s success", __FUNCTION__);
    } else {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL, cb_priv_ptr, mipc_sim_id_to_slot_id(sim_ps_id), RIL_E_GENERIC_FAILURE);
        RFX_LOG_D(RFX_LOG_TAG, "%s fail", __FUNCTION__);
    }
}

void RpSmsController::handleGetSmsSimMemStatus(const sp<RfxMessage>& request) {
    RFX_LOG_D(RFX_LOG_TAG, "%s with clientId %d, with token: %d", __FUNCTION__, request->getClientId(), request->getToken());

    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;

    ret = mipc_sms_store_status_get_async(
            slot_id_to_mipc_sim_id(request->getSlotId()), mipc_sms_store_status_get_cb, (void *)request->getRilToken());

    // Check response data format
    if (ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_D(RFX_LOG_TAG, "%s fail", __FUNCTION__);
        rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_GENERIC_FAILURE);
    }
}

static void mipc_sms_get_cbm_cfg_language_cb(
        mipc_sim_ps_id_enum sim_ps_id, mipc_sms_cbm_get_cfg_struct *result_ptr, void *cb_priv_ptr) {
    RIL_Errno err = RIL_E_SUCCESS;
    Parcel * parcel = NULL;
    uint32_t start_temp, end_temp;
    uint16_t num = 0;
    String8 settings("");
    char *lang_str = NULL;

    RFX_LOG_D(RFX_LOG_TAG, "%s\n", __FUNCTION__);

    err = (RIL_Errno)result_ptr->result_code;
    if (err != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL, cb_priv_ptr, mipc_sim_id_to_slot_id(sim_ps_id), err);
    } else {
        parcel = new Parcel();

        // 1. Write element number
        //num = result_ptr->dcs_single_num;
        //parcel->writeInt32(num);

        // 2 Write language list by single type
        for (int i = 0; i < result_ptr->dcs_single_num ; i++) {
            if (i != 0) {
                settings.append(",");
            }
            settings.append(String8::format("%d", result_ptr->dcs_single[i]));
        }
        RFX_LOG_D(RFX_LOG_TAG, "get language : %s", settings.string());

        lang_str = (char *)malloc(strlen(settings.string()) + 1);
        memset(lang_str, 0, strlen(settings.string()) + 1);
        sprintf(lang_str, "%s", settings.string());

        RFX_LOG_D(RFX_LOG_TAG, "lang_str : %s", lang_str);

        writeStringToParcel(parcel, settings.string());

        // 3. Send AP channel configuration
        RFX_LOG_D(RFX_LOG_TAG, "%s, get lanaguage done, dcs_single_num=%d, dcs_range_num=%d\n, lang_str=%s",
                __FUNCTION__, result_ptr->dcs_single_num, result_ptr->dcs_range_num, lang_str);
        rfx_enqueue_response_message(parcel, cb_priv_ptr, mipc_sim_id_to_slot_id(sim_ps_id), err);

        free(lang_str);
    }
}

void RpSmsController::handleGsmGetCbSmsLanguage(const sp<RfxMessage>& request) {
    RFX_LOG_D(RFX_LOG_TAG, "%s with clientId: %d, with token: %d", __FUNCTION__, request->getClientId(), request->getToken());

    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;

    ret = mipc_sms_get_cbm_cfg_async(slot_id_to_mipc_sim_id(request->getSlotId()),
            mipc_sms_get_cbm_cfg_language_cb, (void *)request->getRilToken(), MIPC_SMS_CB_QUERY_LANGUAGE);

    if (ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_D(RFX_LOG_TAG, "%s fail", __FUNCTION__);
        rfx_enqueue_response_message(NULL, request->getRilToken(), (RIL_SOCKET_ID)request->getSlotId(), RIL_E_GENERIC_FAILURE);
    }
}

void RpSmsController::splitCbLanguageString(char *src, const char *sep, char dest[][CB_CFG_MAX_LANG_CHARR], int* num) {
    char *next;
    int count = 0;
    if (src == NULL || strlen(src) == 0) {
        return;
    }

    if (sep == NULL || strlen(sep) == 0) {
        return;
    }
    next = strtok(src, sep);
    while (next != NULL) {
        strncpy(*dest++, next, CB_CFG_MAX_LANG_CHARR - 1);
        count++;
        next = strtok(NULL, sep);
    }
    *num =count;
}

void RpSmsController::handleGsmSetCbSmsLanguage(const sp<RfxMessage>& request) {
    RFX_LOG_D(RFX_LOG_TAG, "%s with clientId: %d, with token: %d", __FUNCTION__, request->getClientId(), request->getToken());

    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;

    char *langStr = NULL;
    char langs[CB_CFG_MAX_SINGLE_NUM][CB_CFG_MAX_LANG_CHARR];
    int num = 0;
    uint8_t singleLan[CB_CFG_MAX_SINGLE_NUM];

    do {
        Parcel *p = request->getParcel();
        if(p == NULL) {
            RFX_LOG_D(RFX_LOG_TAG, "%s p has no data to transfer\n", __FUNCTION__);
            break;
        }

        langStr = (char*)strdupReadString(*p);

        RFX_LOG_D(RFX_LOG_TAG, "%s langs %s, str len: %d", __FUNCTION__, langStr, strlen(langStr));

        if (langStr != NULL) {
            RpSmsController::splitCbLanguageString(langStr, ",", langs, &num);
            RFX_LOG_D(RFX_LOG_TAG, "%s Set CB langs %s, len: %d", __FUNCTION__, langStr, num);
        }

        if (num > 0) {
            for (int i = 0; i < num ; i++) {
                singleLan[i] = (uint8_t)atoi(langs[i]);
            }

            ret = mipc_sms_set_cbm_cfg_async(
                    slot_id_to_mipc_sim_id(request->getSlotId()), mipc_sms_set_cbm_cfg_cb, (void *)request->getRilToken(),
                    mipc_sms_cbm_cfg_type_const_enum::MIPC_SMS_CBM_CFG_TYPE_ALLOW,
                    0, NULL,
                    0, NULL,
                    0, NULL,
                    num, singleLan,
                    0);
        }

        if(langStr != NULL){
            free(langStr);
        }
    } while(0);

    if (ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_D(RFX_LOG_TAG, "%s fail", __FUNCTION__);
        rfx_enqueue_response_message(NULL, request->getRilToken(), (RIL_SOCKET_ID)request->getClientId(), request->getToken());
    }

}
