/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  Copyright (c) [2021], MediaTek Inc. All rights reserved.
*  This software/firmware and related documentation ("MediaTek Software") are
*  protected under relevant copyright laws.
*
*  The information contained herein is confidential and proprietary to
*  MediaTek Inc. and/or its licensors. Except as otherwise provided in the
*  applicable licensing terms with MediaTek Inc. and/or its licensors, any
*  reproduction, modification, use or disclosure of MediaTek Software, and
*  information contained herein, in whole or in part, shall be strictly
*  prohibited.
*****************************************************************************/

#ifndef __RP_SS_CONTROLLER_H__
#define __RP_SS_CONTROLLER_H__

#include <string>

#include "RfxController.h"
#include "RpUtils.h"
#include "RilParcelUtils.h"
#include <telephony/mtk_ril_request_info.h>

#ifdef __cplusplus
extern "C" {
#endif
#include "mipc_ss_api.h"
#include "mipc_msg_host.h"
#include "mipc_msg_tlv_const.h"
#include "mipc_msg_tlv_api.h"
#ifdef __cplusplus
}
#endif

#define RFX_LOG_TAG "RILD_RpSsController"

extern "C"{
void mipc_ss_set_call_barring_cb(mipc_sim_ps_id_enum sim_ps_id,
        mipc_ss_set_call_barring_struct *result_ptr, void *cb_priv_ptr);
void mipc_ss_query_call_barring_cb(mipc_sim_ps_id_enum sim_ps_id,
        mipc_ss_query_call_barring_struct *result_ptr, void *cb_priv_ptr);
}


class RpSsController : public RfxController {
    RFX_DECLARE_CLASS(RpSsController);

public:
    RpSsController();
    virtual ~RpSsController();
    static int gCfReason;

protected:
    virtual void onInit();
    virtual void onDeinit();
    virtual bool onHandleRequest(const sp<RfxMessage>& message);

private:
    void registerInd(mipc_sim_ps_id_enum sim_ps_id,void *cb_priv_ptr);
    void handleSendUssd(const sp<RfxMessage>& request);
    void handleCancelUssd(const sp<RfxMessage>& request);
    void handleSetClir(const sp<RfxMessage>& request);
    void handleGetClir(const sp<RfxMessage>& request);
    void handleSetCallWaiting(const sp<RfxMessage>& request);
    void handleQueryCallWaiting(const sp<RfxMessage>& request);
    void handleSetCallForward(const sp<RfxMessage>& request);
    void handleQueryCallForwardStatus(const sp<RfxMessage>& request);
    void handleChangeBarringPassword(const sp<RfxMessage>& request);
    void handleSetSuppSvcNotification(const sp<RfxMessage>& request);
    void handleQueryClip(const sp<RfxMessage>& request);
    void handleGetClip(const sp<RfxMessage>& request);
    void handleGetColp(const sp<RfxMessage>& request);
    void handleGetColr(const sp<RfxMessage>& request);
    void handleSetClip(const sp<RfxMessage>& request);
    void handleSetColp(const sp<RfxMessage>& request);

    static std::string IdToString(int request);

private:
    std::string mLogTag;
};


#endif