/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  Copyright (c) [2021], MediaTek Inc. All rights reserved.
*  This software/firmware and related documentation ("MediaTek Software") are
*  protected under relevant copyright laws.
*
*  The information contained herein is confidential and proprietary to
*  MediaTek Inc. and/or its licensors. Except as otherwise provided in the
*  applicable licensing terms with MediaTek Inc. and/or its licensors, any
*  reproduction, modification, use or disclosure of MediaTek Software, and
*  information contained herein, in whole or in part, shall be strictly
*  prohibited.
*****************************************************************************/

#include "RpSsUtils.h"

std::unordered_map<std::string, mipc_ss_call_barring_fac_const_enum> CB_FACIILTY_MAP = {
        {"AO", MIPC_SS_CALL_BARRING_FAC_AO},
        {"OI", MIPC_SS_CALL_BARRING_FAC_OI},
        {"OX", MIPC_SS_CALL_BARRING_FAC_OX},
        {"AI", MIPC_SS_CALL_BARRING_FAC_AI},
        {"IR", MIPC_SS_CALL_BARRING_FAC_IR},
        {"AB", MIPC_SS_CALL_BARRING_FAC_AB},
        {"AG", MIPC_SS_CALL_BARRING_FAC_AG},
        {"AC", MIPC_SS_CALL_BARRING_FAC_AC}};

std::unordered_map<int, mipc_ss_set_call_forward_operation_code_const_enum> CF_OPERATION_MAP = {
        {0, MIPC_SS_SET_CALL_FORWARD_OPERATION_CODE_SS_DEACTIVATE},
        {1, MIPC_SS_SET_CALL_FORWARD_OPERATION_CODE_SS_ACTIVATE},
        {3, MIPC_SS_SET_CALL_FORWARD_OPERATION_CODE_SS_REGISTRATION},
        {4, MIPC_SS_SET_CALL_FORWARD_OPERATION_CODE_SS_ERASURE}};

std::unordered_map<int, mipc_ss_call_forward_reason_const_enum> CF_REASON_MAP = {
        {0, MIPC_SS_CALL_FORWARD_REASON_CALL_FORWARD_UNCONDITIONAL},
        {1, MIPC_SS_CALL_FORWARD_REASON_CALL_FORWARD_BUSY},
        {2, MIPC_SS_CALL_FORWARD_REASON_CALL_FORWARD_NO_REPLY},
        {3, MIPC_SS_CALL_FORWARD_REASON_CALL_FORWARD_NOT_REACHABLE},
        {4, MIPC_SS_CALL_FORWARD_REASON_CALL_FORWARD_ALL},
        {5, MIPC_SS_CALL_FORWARD_REASON_CALL_FORWARD_ALL_CONDITIONAL},
        {6, MIPC_SS_CALL_FORWARD_REASON_CALL_FORWARD_NOT_REGISTER}};

bool checkValidCfOperation(int operation)
{
    if (operation != 0 && operation != 1 && operation != 3 && operation != 4) {
        return false;
    }
    return true;
}

mipc_ss_set_call_forward_operation_code_const_enum convertCfOperationToMipcEnum(int op)
{
    return CF_OPERATION_MAP[op];
}

mipc_ss_call_forward_reason_const_enum convertCfReasonToMipcEnum(int reason)
{
    return CF_REASON_MAP[reason];
}

mipc_ss_call_barring_fac_const_enum convertfacilityToMipcEnum(char *facility)
{
    return CB_FACIILTY_MAP[std::string(facility)];
}

bool isCallBarringUsage(std::string fac)
{
    return CB_FACIILTY_MAP.count(fac);
}