// SPDX-License-Identifier: MediaTekProprietary
/* Copyright Statement:
 *
 * This software/firmware and related documentation ("MediaTek Software") are
 * protected under relevant copyright laws. The information contained herein
 * is confidential and proprietary to MediaTek Inc. and/or its licensors.
 * Without the prior written permission of MediaTek inc. and/or its licensors,
 * any reproduction, modification, use or disclosure of MediaTek Software,
 * and information contained herein, in whole or in part, shall be strictly prohibited.
 *
 * MediaTek Inc. (C) 2015. All rights reserved.
 *
 * BY OPENING THIS FILE, RECEIVER HEREBY UNEQUIVOCALLY ACKNOWLEDGES AND AGREES
 * THAT THE SOFTWARE/FIRMWARE AND ITS DOCUMENTATIONS ("MEDIATEK SOFTWARE")
 * RECEIVED FROM MEDIATEK AND/OR ITS REPRESENTATIVES ARE PROVIDED TO RECEIVER ON
 * AN "AS-IS" BASIS ONLY. MEDIATEK EXPRESSLY DISCLAIMS ANY AND ALL WARRANTIES,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE OR NONINFRINGEMENT.
 * NEITHER DOES MEDIATEK PROVIDE ANY WARRANTY WHATSOEVER WITH RESPECT TO THE
 * SOFTWARE OF ANY THIRD PARTY WHICH MAY BE USED BY, INCORPORATED IN, OR
 * SUPPLIED WITH THE MEDIATEK SOFTWARE, AND RECEIVER AGREES TO LOOK ONLY TO SUCH
 * THIRD PARTY FOR ANY WARRANTY CLAIM RELATING THERETO. RECEIVER EXPRESSLY ACKNOWLEDGES
 * THAT IT IS RECEIVER'S SOLE RESPONSIBILITY TO OBTAIN FROM ANY THIRD PARTY ALL PROPER LICENSES
 * CONTAINED IN MEDIATEK SOFTWARE. MEDIATEK SHALL ALSO NOT BE RESPONSIBLE FOR ANY MEDIATEK
 * SOFTWARE RELEASES MADE TO RECEIVER'S SPECIFICATION OR TO CONFORM TO A PARTICULAR
 * STANDARD OR OPEN FORUM. RECEIVER'S SOLE AND EXCLUSIVE REMEDY AND MEDIATEK'S ENTIRE AND
 * CUMULATIVE LIABILITY WITH RESPECT TO THE MEDIATEK SOFTWARE RELEASED HEREUNDER WILL BE,
 * AT MEDIATEK'S OPTION, TO REVISE OR REPLACE THE MEDIATEK SOFTWARE AT ISSUE,
 * OR REFUND ANY SOFTWARE LICENSE FEES OR SERVICE CHARGE PAID BY RECEIVER TO
 * MEDIATEK FOR SUCH MEDIATEK SOFTWARE AT ISSUE.
 *
 * The following software/firmware and/or related documentation ("MediaTek Software")
 * have been modified by MediaTek Inc. All revisions are subject to any receiver's
 * applicable license agreements with MediaTek Inc.
 */

/*****************************************************************************
 * Include
 *****************************************************************************/

#include "RpStkController.h"

#include <sys/un.h>
#include <errno.h>
#include <unistd.h>
#include <cutils/jstring.h>
#include <string>
#ifdef __cplusplus
extern "C" {
#endif
#include "mipc_stk_api.h"
#ifdef __cplusplus
}
#endif

#include "RfxDispatchThread.h"
#include "Rfx.h"
#include "libmtkrilutils.h"
#include "RpUtils.h"
#include <utils/Errors.h>

using namespace std;
using android::status_t;

#define RFX_LOG_TAG "RpStkController"
#define MIN(a, b) ((a) < (b) ? (a) : (b))

char *pCachedMenu = NULL;
RpStkController* RpStkController::sInstance[4] = {NULL};

/*****************************************************************************
 * Class RfxDataController
 * The class is created if the slot is single mode, LWG or C,
 *****************************************************************************/

RFX_IMPLEMENT_CLASS("RpStkController", RpStkController, RfxController);

RpStkController::RpStkController() :
    mCardType(-1) {
        isProaCmdQueued = false;
        isStkServiceRunning = false;
        isEventNotifyQueued = false;
        pProactive_cmd = NULL;
        pSimRefreshRspWithType = NULL;
        if (getSlotId() >=0 && getSlotId() < 4) {
            sInstance[getSlotId()] = this;
        }

        for (int i = 0; i< EVENT_NOTIFY_BUFFER_LEN; i++) {
            pEvent_notify[i] = NULL;
        }
}

RpStkController::~RpStkController() {
    if (NULL != pSimRefreshRspWithType) {
        if (NULL != pSimRefreshRspWithType->simRefreshRsp) {
            if (NULL!= pSimRefreshRspWithType->simRefreshRsp->aid) {
                free(pSimRefreshRspWithType->simRefreshRsp->aid);
                pSimRefreshRspWithType->simRefreshRsp->aid = NULL;
            }
            free(pSimRefreshRspWithType->simRefreshRsp);
            pSimRefreshRspWithType->simRefreshRsp = NULL;
        }
        if (NULL != pSimRefreshRspWithType->efId) {
            free(pSimRefreshRspWithType->efId);
            pSimRefreshRspWithType->efId = NULL;
        }
        free(pSimRefreshRspWithType);
        pSimRefreshRspWithType = NULL;
    }
}

RpStkController* RpStkController::getInstance(int soltId){
    return sInstance[soltId];
}

static char* strdupReadString(Parcel &p) {
    size_t stringlen;
    const char16_t *s16;

    s16 = p.readString16Inplace(&stringlen);
    return strndup16to8(s16, stringlen);
}

static void memsetString (char *s) {
    if (s != NULL) {
        memset (s, 0, strlen(s));
    }
}

static void writeStringToParcel(Parcel *p, const char *s) {
    char16_t *s16;
    size_t s16_len;
    s16 = strdup8to16(s, &s16_len);
    p->writeString16(s16, s16_len);
    free(s16);
}

static int getStkCommandType(char *cmd) {
    char temp[3] = {0};
    int cmdType = 0;

    strncpy(temp, cmd, 2);
    cmdType = strtoul(temp, NULL, 16);
    cmdType = 0xFF & cmdType;

    return cmdType;
}

static int getStkCommandNumber(char *cmd) {
    char temp[3] = {0};
    int cmdNum = 0;

    strncpy(temp, cmd, 2);
    cmdNum = strtoul(temp, NULL, 16);
    cmdNum = 0xFF & cmdNum;

    return cmdNum;
}

static int getStkResultCode(char *cmd) {
    char temp[3] = {0};
    int resCode = 0;

    strncpy(temp, cmd, 2);
    resCode = strtoul(temp, NULL, 16);
    resCode = 0xFF & resCode;

    return resCode;
}

static void parseStkResultCode(const sp<RfxMessage>& request, int* resCode) {
    int msgId = request->getId();
    int typePos = 0;
    int cmd_len = 0;
    char* cmd = NULL;
    *resCode = -1;

    // Get command from message
    Parcel *p = request->getParcel();

    if(p == NULL) {
        RFX_LOG_D(RFX_LOG_TAG, "parseStkCmdType cmd:%s fail", cmd);
        return;
    }

    cmd = strdupReadString(*p);
    if(cmd == NULL) {
        RFX_LOG_D(RFX_LOG_TAG, "parseStkCmdType cmd:%s fail", cmd);
        return;
    }

    if (cmd != NULL) {
        cmd_len = strlen(cmd);
        RFX_LOG_D(RFX_LOG_TAG, "parseStkResultCode cmd:%s ", cmd);
        // decide typePos value
        switch (msgId) {
            case RIL_REQUEST_STK_SEND_TERMINAL_RESPONSE:
                //For the TR from CatService, result code is at the 12th Bytes
                typePos = 22;
                break;
            default:
                break;
        }
        if (cmd_len < typePos) {
            RFX_LOG_D(RFX_LOG_TAG, "parseStkResultCode exception!");
            return;
        }
        // check command type
        *resCode = getStkResultCode(&cmd[typePos]);
        RFX_LOG_D(RFX_LOG_TAG,"parseStkResultCode cmdNum:%d", *resCode);
    } else {
        RFX_LOG_D(RFX_LOG_TAG, "cmd is NULL. Error!!!");
    }
}

static void parseStkCmdType(char* cmd, int* cmdType) {
    int cmd_len = strlen(cmd);
    int typePos = 0;

    if (cmd_len < 14) {
        RFX_LOG_D(RFX_LOG_TAG, "parseStkCmdType exception!");
        return;
    }

    if(cmd[2] <= '7' ) {
        typePos = 10;
    } else {
        typePos = 12;
    }

    // get command type
    *cmdType = getStkCommandType(&cmd[typePos]);
}

static void parseStkCmdType(const sp<RfxMessage>& request, int* cmdType) {
    int msgId = request->getId();
    int typePos = 0;
    char* cmd = NULL;

    // Get command from message
    Parcel *p = request->getParcel();

    if(p == NULL) {
        RFX_LOG_D(RFX_LOG_TAG, "parseStkCmdType cmd:%s fail", cmd);
        return;
    }

    cmd = strdupReadString(*p);
    if(cmd == NULL) {
        RFX_LOG_D(RFX_LOG_TAG, "parseStkCmdType cmd:%s fail", cmd);
        return;
    }

    if (cmd) {
        // decide typePos value
        switch (msgId) {
            case RIL_UNSOL_STK_PROACTIVE_COMMAND:
            case RIL_UNSOL_STK_EVENT_NOTIFY:
                if (cmd[2] <= '7') {
                    typePos = 10;
                } else {
                    typePos = 12;
                }
                break;

            case RIL_REQUEST_STK_SEND_TERMINAL_RESPONSE:
                typePos = 6;
                break;

            default:
                //logD(RFX_LOG_TAG,"Not Support msgId:%d", msgId);
                break;
        }

        // check command type
        *cmdType = getStkCommandType(&cmd[typePos]);
        //free(cmd);
    } else {
        RFX_LOG_D(RFX_LOG_TAG, "cmd is NULL. Error!!!");
    }
}


static void parseStkCmdQualifier(char* cmd, int* cmdQual) {
    int cmd_len = strlen(cmd);
    int typePos = 0;

    if (cmd_len < 14) {
        RFX_LOG_D(RFX_LOG_TAG, "parseStkCmdQualifier exception!");
        return;
    }

    if(cmd[2] <= '7' ) {
        typePos = 12;
    } else {
        typePos = 14;
    }

    // get command qualifier
    *cmdQual = getStkCommandType(&cmd[typePos]);
}

static void parseStkCmdNum(char* cmd, int* cmdNum) {
    int cmd_len = strlen(cmd);
    int typePos = 0;

    if (cmd_len < 12) {
        RFX_LOG_D(RFX_LOG_TAG, "parseStkCmdNum exception!");
        return;
    }

    if (cmd[2] <= '7') {
        typePos = 8;
    } else {
        typePos = 10;
    }

    // check command num
    *cmdNum = getStkCommandNumber(&cmd[typePos]);
    RFX_LOG_D(RFX_LOG_TAG,"parseStkCmdNum cmdNum:%d", *cmdNum);
}

static int checkStkCmdDisplay(char *cmd_str) {
    int is_alpha_id_existed = 0;
    int is_icon_existed_not_self_explanatory = 0;
    int index = 0;
    int cmd_length = 0;
    char temp_str[3] = {0};
    char *end;

    cmd_length = strlen(cmd_str);

    while (cmd_length > index) {
        if (cmd_str[index + 1] == '5' && (cmd_str[index] == '0' || cmd_str[index] == '8') ) {

            index += 2;
            if (cmd_str[index] != '0' || cmd_str[index + 1] != '0' ) {
                is_alpha_id_existed = 1;
            }
            if (cmd_str[index] <= '7') {
                memcpy(temp_str, &(cmd_str[index]), 2);
                index += (strtoul(temp_str, &end, 16) + 1) * 2;
            } else {
                memcpy(temp_str, &(cmd_str[index + 2]), 2);
                index += (strtoul(temp_str, &end, 16) + 2) * 2;
            }
        } else if((cmd_str[index + 1] == 'E' || cmd_str[index + 1] == 'e') &&
                                    (cmd_str[index] == '1' || cmd_str[index] == '9')) {
            int icon_qualifier = 0;

            index += 4;
            memset(temp_str, 0, 3);
            memcpy(temp_str, &(cmd_str[index + 1]), 1);
            icon_qualifier = strtoul(temp_str, &end, 16);

            if((icon_qualifier & 0x01) == 0x01) {
                if(is_alpha_id_existed == 0) {
                    return 1;
                }
            }
            index += 4;
        } else {
            index += 2;
            if (cmd_str[index] <= '7') {
                memcpy(temp_str, &(cmd_str[index]), 2);
                index += (strtoul(temp_str, &end, 16) + 1) * 2;
            } else {
                memcpy(temp_str, &(cmd_str[index + 2]), 2);
                index += (strtoul(temp_str, &end, 16) + 2) * 2;
            }
        }
    }
    return 0;
}

// For the special case, such as phone process is killed, need send TR to modem
static void sendResponseForSpecial(int cmdType, int cmdQual) {
    int cmdInfo[2];
    cmdInfo[0] = cmdType;
    cmdInfo[1] = cmdQual;

    //2731 would send RIL_REQUEST_STK_SEND_RESPONSE_BY_CMDTYPE, but 2735 L5 did not have it
    //sp<RfxMessage> msg = RfxMessage::obtainRequest(m_slot_id,RIL_REQUEST_STK_SEND_RESPONSE_BY_CMDTYPE, RfxIntsData(cmdInfo, 2));
    //requestToMcl(msg);
}

static int rild_sms_hexCharToDecInt(char *hex, int length) {
    int i = 0;
    int value, digit;

    for (i = 0, value = 0; i < length && hex[i] != '\0'; i++)
    {
        if (hex[i]>='0' && hex[i]<='9')
        {
            digit = hex[i] - '0';
        }
        else if ( hex[i]>='A' && hex[i] <= 'F')
        {
            digit = hex[i] - 'A' + 10;
        }
        else if ( hex[i]>='a' && hex[i] <= 'f')
        {
            digit = hex[i] - 'a' + 10;
        }
        else
        {
            return -1;
        }
        value = value*16 + digit;
    }

    return value;
}

static int decodeStkRefreshAid(char *cmd, char **paid) {
    int offset = 18; //cmd_details & device identifies
    int refresh_length = strlen(cmd) / 2;
    int files_length;
    int files_offset;
    int temp;   // For reading data

    if (offset >= refresh_length) {
        *paid = NULL;
        return 0;
    }

    temp = rild_sms_hexCharToDecInt(&cmd[offset], 2);
    offset += 2;
    if (temp == 0x12 || temp == 0x92) { //file list tag
        temp = rild_sms_hexCharToDecInt(&cmd[offset], 2);   // Length of bytes following (bytes)
        if (temp < 0x7F) {
            offset += (2 + temp * 2);
        } else {
            offset += 2;
            temp = rild_sms_hexCharToDecInt(&cmd[offset], 2);
            offset += (2 + temp * 2);
        }
        temp = rild_sms_hexCharToDecInt(&cmd[offset], 2);   // Number of files
        offset += 2;
    }

    RFX_LOG_D(RFX_LOG_TAG, "decodeStkRefreshAid temp = %02x, offset = %d", temp, offset);

    if (temp == 0x2F || temp == 0xAF) { // aid tag
        temp = rild_sms_hexCharToDecInt(&cmd[offset], 2);  // read the length of AID
        offset += 2;
        *paid = &cmd[offset];
        return temp * 2;
    }

    return -1;
}

static char* decodeStkRefreshFileChange(char *str, int **cmd, int *cmd_length) {
    int str_length = 0, file_num = 0, offset = 20, cmdoffset = 0;
    /*offset 20 including cmd_detail tlv: 10, device id tlv:8, file list tag:2*/
    char temp_str[5] = {0};
    char *end;
    str_length = strlen(str);
    char *efId_str;
    int file_idx = 0;

    if(str[offset] <= '7') { //file list length: if length < 7F it will use 2 bytes else it will use 4 bytes
        offset += 2;
    } else {
        offset += 4;
    }
    memcpy(temp_str, str + offset, 2); //copy number of files in file list to temp_str
    offset += 2;

    file_num = strtoul(temp_str, &end, 16);
    efId_str = (char*)calloc(1, (file_num * (sizeof(char) * 4)) + 1);

#ifndef MTK_WIFI_CALLING_RIL_SUPPORT
    *cmd_length = (file_num + 1) * sizeof(int);
    *cmd = (int*)calloc(1, *cmd_length);
#else
    *cmd_length = (file_num + 2) * sizeof(int);
    *cmd = (int*)calloc(1, *cmd_length);
    cmdoffset++;
#endif

    *(*cmd + cmdoffset) = SIM_FILE_UPDATE;

    cmdoffset++;
    RFX_LOG_D(RFX_LOG_TAG, "decodeStkRefreshFileChange file_num = %d", file_num);

    while( offset < str_length && file_num > file_idx) {
        if(((str[offset] == '6') || (str[offset] == '2') || (str[offset] == '4'))
           && ((str[offset + 1] == 'F') || (str[offset+1] == 'f'))) {
            memcpy(temp_str, str + offset, 4); //copy EFID to temo_str
            strncat(efId_str, temp_str, 4);
            *(*cmd + cmdoffset) = strtoul(temp_str, &end, 16);

            cmdoffset++;
            file_idx++;
        }
        offset += 4;
    }
    return efId_str;
}

static unsigned int findStkCallDuration(char* str) {
    int length = 0, offset = 0, temp = 0;
    unsigned int duration = 0;
    char temp_str[3] = {0};
    char *end;

    length = strlen(str);

    while(length > 0) {

        if(str[offset] == '8' && str[offset + 1] == '4') {
            memcpy(temp_str, &(str[offset + 6]), 2);
            if(str[offset + 5] == '0') {
                temp = strtoul(temp_str, &end, 16);
                duration = temp * 60000;
            } else if(str[offset + 5] == '1') {
                temp = strtoul(temp_str, &end, 16);
                duration = temp * 1000;
            } else if(str[offset + 5] == '2') {
                temp = strtoul(temp_str, &end, 16);
                duration = temp * 100;
            }
            break;
        } else {
            length -= 2;
            offset += 2;
            memcpy(temp_str, &(str[offset]), 2);
            temp = strtoul(temp_str, &end, 16);
            length -= (2 * temp + 2);
            offset += (2 * temp + 2);

        }
    }
    return duration;
}

static int checkEventNotifyFreeBuffer(mipc_sim_ps_id_enum sim_ps_id) {
    int i = 0;
    int freeBufferNum = 0;
    RpStkController* stkController = RpStkController::getInstance(sim_ps_id - 1);
    char** m_Event_notify = stkController->pEvent_notify;

    for (i = 0 ; i < EVENT_NOTIFY_BUFFER_LEN ; i++) {
        if (NULL == m_Event_notify[i]) {
            freeBufferNum++;
        }
    }

    RFX_LOG_D(RFX_LOG_TAG, "checkEventNotifyFreeBuffer: freeBufferNum:%d", freeBufferNum);
    return freeBufferNum;
}

static void setStkCachedEventNotify(char* cmd, mipc_sim_ps_id_enum sim_ps_id) {
    int i = 0;
    RpStkController* stkController = RpStkController::getInstance(sim_ps_id - 1);
    char** m_Event_notify = stkController->pEvent_notify;

    for (i = 0 ; i < EVENT_NOTIFY_BUFFER_LEN ; i++) {
        if (NULL == m_Event_notify[i]) {
            m_Event_notify[i] = cmd;
            break;
        }
    }
    if (EVENT_NOTIFY_BUFFER_LEN == i) {
        RFX_LOG_D(RFX_LOG_TAG, "setStkCachedEventNotify: No free buffer !!!");
    } else {
        RFX_LOG_D(RFX_LOG_TAG, "setStkCachedEventNotify: [index:%d][%p][%s]", i, m_Event_notify, m_Event_notify);
    }
}

static void resetProCmd(mipc_sim_ps_id_enum sim_ps_id) {
    RpStkController* stkController = RpStkController::getInstance(sim_ps_id - 1);
    ProactiveCmdRecord* m_ProCmdRec = &(stkController->mProCmdRec);
    m_ProCmdRec->cmdType = 0;
    m_ProCmdRec->cmdQualifier = 0;
    m_ProCmdRec->needResponse = false;
}

static char* getStkQueuedEventNotify(int index, mipc_sim_ps_id_enum sim_ps_id) {
    RpStkController* stkController = RpStkController::getInstance(sim_ps_id - 1);
    char** m_Event_notify = stkController->pEvent_notify;

    if (index >= EVENT_NOTIFY_BUFFER_LEN) {
        RFX_LOG_D(RFX_LOG_TAG, "getStkQueuedEventNotify: Invalid index:%d !!!", index);
        return NULL;
    }

    return m_Event_notify[index];
}

static void freeStkQueuedEventNotify(int index, mipc_sim_ps_id_enum sim_ps_id) {
    RpStkController* stkController = RpStkController::getInstance(sim_ps_id - 1);
    char** m_Event_notify = stkController->pEvent_notify;

    if (index >= EVENT_NOTIFY_BUFFER_LEN) {
        RFX_LOG_D(RFX_LOG_TAG, "freeStkQueuedEventNotify: Invalid index:%d !!!", index);
        return;
    }

    if (NULL != m_Event_notify[index]) {
        free(m_Event_notify[index]);
        m_Event_notify[index] = NULL;
    }
}

static void freeStkQueuedProactivCmd(mipc_sim_ps_id_enum sim_ps_id) {
    RpStkController* stkController = RpStkController::getInstance(sim_ps_id - 1);
    if (NULL != stkController->pProactive_cmd) {
        free(stkController->pProactive_cmd);
        stkController->pProactive_cmd = NULL;
    }
}

static void sendStkQueuedCmd(int flag, mipc_sim_ps_id_enum sim_ps_id) {
    RpStkController* stkController = RpStkController::getInstance(sim_ps_id - 1);
    SimRefreshResponse* m_SimRefreshRspWithType = stkController->pSimRefreshRspWithType;
    ProactiveCmdRecord* m_ProCmdRec = &(stkController->mProCmdRec);
    RIL_Errno err = RIL_E_SUCCESS;

    if (true == stkController->isEventNotifyQueued) {
        RFX_LOG_D(RFX_LOG_TAG, "sendStkQueuedCmd: isEventNotifyQueued: true");
        int index = 0;
        while (index < EVENT_NOTIFY_BUFFER_LEN) {
            if (NULL != m_SimRefreshRspWithType) {
                RFX_LOG_D(RFX_LOG_TAG, "sendStkQueuedCmd: wait for sim refresh done!");
                return;
            }
            char *cmd = getStkQueuedEventNotify(index, sim_ps_id);
            if (NULL != cmd) {
                RFX_LOG_D(RFX_LOG_TAG, "Notify Cmd:[%d][%s]", strlen(cmd), cmd);
                stkController->handleStkCommand(cmd, CMD_TYPE_NOTIFY, sim_ps_id);
                freeStkQueuedEventNotify(index, sim_ps_id);
            }
            index++ ;
        }
        stkController->isEventNotifyQueued = false;
    }

    if (true == stkController->isProaCmdQueued) {
        RFX_LOG_D(RFX_LOG_TAG, "sendStkQueuedCmd: isProaCmdQueued: true");
        char *cmd = stkController->pProactive_cmd;;
        if (NULL != cmd) {
            RFX_LOG_D(RFX_LOG_TAG, "Proactive Cmd:[%d][%s]", strlen(cmd), cmd);
            stkController->handleStkCommand(cmd, CMD_TYPE_PROACTIVE, sim_ps_id);
            freeStkQueuedProactivCmd(sim_ps_id);
            stkController->isProaCmdQueued = false;
        }
    } else {
       // For STK service running, need report set up menu to framework
        if (flag == 0) {
            if (m_ProCmdRec->needResponse && m_ProCmdRec->cmdType != 0) {
                sendResponseForSpecial(m_ProCmdRec->cmdType, m_ProCmdRec->cmdQualifier);
            }
            char *cachedMenu = pCachedMenu;
            RFX_LOG_D(RFX_LOG_TAG, "sendStkQueuedCmd, will report menu, cachedMenu :[%s]" , cachedMenu);
            if (NULL != cachedMenu) {
                Parcel * parcel = NULL;
                parcel = new Parcel();
                writeStringToParcel(parcel, cachedMenu);
                RFX_LOG_D(RFX_LOG_TAG, "enter0 p=%p\n",parcel);

                rfx_enqueue_urc_message(RIL_UNSOL_STK_PROACTIVE_COMMAND,parcel,mipc_sim_id_to_slot_id(sim_ps_id),err);
                if(pCachedMenu!= NULL){
                    free(pCachedMenu);
                }
            }
        }
    }
}

static void handleSimRefresh(char* urc, mipc_sim_ps_id_enum sim_ps_id) {
    int aid_len = 0;
    int *cmd = NULL;
    int cmd_length = 0;
    int files_num = 0;
    int i = 0;
    int readIdx = 0;
    int efId = 0;
    char *aid = NULL;
    char *efId_str = NULL;
    char temp_str[5] = {0};   // for read EFID
    int refreshRspMemLen = 0;
    sp<RfxMessage> msg = NULL;
    RIL_SimRefreshResponse_v7 simRefreshRspV7;
    RIL_Errno err = RIL_E_SUCCESS;
    Parcel *parcel = NULL;

    RpStkController* stkController = RpStkController::getInstance(sim_ps_id - 1);
    SimRefreshResponse* m_SimRefreshRspWithType = stkController->pSimRefreshRspWithType;

    memset(&simRefreshRspV7, 0, sizeof(RIL_SimRefreshResponse_v7));
    RFX_LOG_D(RFX_LOG_TAG, "handleSimRefresh: type:%c cmd:%s", urc[9], urc);

    switch(urc[9]) {
        case '0':
            aid_len = decodeStkRefreshAid(urc, &aid);
            simRefreshRspV7.aid = aid;
            simRefreshRspV7.result = SIM_INIT_FULL_FILE_CHANGE;
            break;
        case '1':
            efId_str = decodeStkRefreshFileChange(urc, &cmd , &cmd_length);
            aid_len = decodeStkRefreshAid(urc, &aid);
            simRefreshRspV7.aid = aid;
            simRefreshRspV7.result = SIM_FILE_UPDATE;
            break;
        case '2':
            efId_str = decodeStkRefreshFileChange(urc, &cmd , &cmd_length);
            aid_len = decodeStkRefreshAid(urc, &aid);
            simRefreshRspV7.aid = aid;
            simRefreshRspV7.result = SIM_INIT_FILE_CHANGE;
            break;
        case '3':
            aid_len = decodeStkRefreshAid(urc, &aid);
            simRefreshRspV7.aid = aid;
            simRefreshRspV7.result = SIM_INIT;
            break;
        case '4':
            aid_len = decodeStkRefreshAid(urc, &aid);
            RFX_LOG_D(RFX_LOG_TAG, "handleSimRefresh: aid = %s, %d", aid, aid_len);
#ifdef SIMREFRESH_CPIN
            m_SimRefreshRspWithType = (SimRefreshResponse*)malloc(sizeof(SimRefreshResponse));
            if (m_SimRefreshRspWithType == NULL) {
                RFX_LOG_D(RFX_LOG_TAG, "SimRefreshResponse malloc fail");
                return;
            }
            memset(m_SimRefreshRspWithType, 0, sizeof(SimRefreshResponse));
            m_SimRefreshRspWithType->simRefreshRsp =
                (RIL_SimRefreshResponse_v7*)malloc(sizeof(RIL_SimRefreshResponse_v7));
            if (m_SimRefreshRspWithType->simRefreshRsp == NULL) {
                RFX_LOG_D(RFX_LOG_TAG, "m_SimRefreshResponse->simRefreshRsp malloc fail");
                free(m_SimRefreshRspWithType);
                m_SimRefreshRspWithType = NULL;
                return;
            }
            memset(m_SimRefreshRspWithType->simRefreshRsp, 0, sizeof(RIL_SimRefreshResponse_v7));
            if (NULL != aid) {
                m_SimRefreshRspWithType->simRefreshRsp->aid = (char*)malloc(strlen(aid) + 1);
                if (m_SimRefreshRspWithType->simRefreshRsp->aid == NULL) {
                    RFX_LOG_D(RFX_LOG_TAG, "m_SimRefreshResponse->simRefreshRsp->aid malloc fail");
                    free(m_SimRefreshRspWithType->simRefreshRsp);
                    free(m_SimRefreshRspWithType);
                    m_SimRefreshRspWithType = NULL;
                    return;
                }
                strncpy(m_SimRefreshRspWithType->simRefreshRsp->aid, aid, strlen(aid));
                m_SimRefreshRspWithType->simRefreshRsp->aid[strlen(aid)] = '\0';
            }
            m_SimRefreshRspWithType->simRefreshRsp->result = SIM_RESET;

            //rfx_enqueue_request_message(RIL_REQUEST_STK_QUERY_CPIN_STATE, NULL, NULL, mipc_sim_id_to_slot_id(sim_ps_id));
            //2731 would send RFX_MSG_REQUEST_STK_QUERY_CPIN_STATE, but 2735 logic did not have it

            //msg = RfxMessage::obtainRequest(m_slot_id, RFX_MSG_REQUEST_STK_QUERY_CPIN_STATE, RfxVoidData());
            //requestToMcl(msg);
            return;
#else
            simRefreshRspV7.aid = aid;
            simRefreshRspV7.result = SIM_RESET;
            break;
#endif
        case '5': // ISIM app_reset
            aid_len = decodeStkRefreshAid(urc, &aid);
            simRefreshRspV7.aid = aid;
            simRefreshRspV7.result = APP_INIT;
            break;
        case '6':
            efId_str = decodeStkRefreshFileChange(urc, &cmd , &cmd_length);
            RFX_LOG_D(RFX_LOG_TAG, "handleSimRefresh: efId = %s", efId_str);
            aid_len = decodeStkRefreshAid(urc, &aid);
            RFX_LOG_D(RFX_LOG_TAG, "handleSimRefresh: aid = %s, %d", aid, aid_len);
#ifdef SIMREFRESH_CPIN
            m_SimRefreshRspWithType = (SimRefreshResponse*) malloc(sizeof(SimRefreshResponse));
            if (m_SimRefreshRspWithType == NULL) {
                RFX_LOG_D(RFX_LOG_TAG, "m_SimRefreshRspWithType malloc fail");
                if (NULL != cmd) {
                    free(cmd);
                }
                if (NULL != efId_str) {
                    free(efId_str);
                }
                return;
            }
            memset(m_SimRefreshRspWithType, 0, sizeof(SimRefreshResponse));
            m_SimRefreshRspWithType->simRefreshRsp = (RIL_SimRefreshResponse_v7*) malloc(
                    sizeof(RIL_SimRefreshResponse_v7));
            if (m_SimRefreshRspWithType->simRefreshRsp == NULL) {
                RFX_LOG_D(RFX_LOG_TAG, "m_SimRefreshResponse->simRefreshRsp malloc fail");
                free(m_SimRefreshRspWithType);
                m_SimRefreshRspWithType = NULL;
                if (NULL != cmd) {
                    free(cmd);
                }
                if (NULL != efId_str) {
                    free(efId_str);
                }
                return;
            }
            memset(m_SimRefreshRspWithType->simRefreshRsp, 0, sizeof(RIL_SimRefreshResponse_v7));
            if (aid != NULL) {
                m_SimRefreshRspWithType->simRefreshRsp->aid = (char*) malloc(strlen(aid) + 1);
                if (m_SimRefreshRspWithType->simRefreshRsp->aid == NULL) {
                    RFX_LOG_D(RFX_LOG_TAG, "m_SimRefreshResponse->simRefreshRsp->aid malloc fail");
                    free(m_SimRefreshRspWithType->simRefreshRsp);
                    free(m_SimRefreshRspWithType);
                    m_SimRefreshRspWithType = NULL;
                    if (NULL != cmd) {
                        free(cmd);
                    }
                    if (NULL != efId_str) {
                        free(efId_str);
                    }
                    return;
                }
                strncpy(m_SimRefreshRspWithType->simRefreshRsp->aid, aid, strlen(aid));
                m_SimRefreshRspWithType->simRefreshRsp->aid[strlen(aid)] = '\0';
            }
            if (efId_str != NULL) {
                m_SimRefreshRspWithType->efId = (char*) malloc(strlen(efId_str) + 1);
                if (m_SimRefreshRspWithType->efId == NULL) {
                    RFX_LOG_D(RFX_LOG_TAG, "SimRefreshResponse->efId malloc fail");
                    if (m_SimRefreshRspWithType->simRefreshRsp->aid != NULL) {
                        free(m_SimRefreshRspWithType->simRefreshRsp->aid);
                    }
                    free(m_SimRefreshRspWithType->simRefreshRsp);
                    free(m_SimRefreshRspWithType);
                    m_SimRefreshRspWithType = NULL;
                    free(efId_str);
                    free(cmd);
                    return;
                }
                strncpy(m_SimRefreshRspWithType->efId, efId_str, strlen(efId_str));
                m_SimRefreshRspWithType->efId[strlen(efId_str)] = '\0';
            }
            m_SimRefreshRspWithType->simRefreshRsp->result = SESSION_RESET;

            //rfx_enqueue_request_message(RIL_REQUEST_STK_QUERY_CPIN_STATE, NULL, NULL, mipc_sim_id_to_slot_id(sim_ps_id));
            //2731 would send RFX_MSG_REQUEST_STK_QUERY_CPIN_STATE, but 2735 logic did not have it
            //msg = RfxMessage::obtainRequest(m_slot_id, RFX_MSG_REQUEST_STK_QUERY_CPIN_STATE, RfxVoidData());
            //requestToMcl(msg);

            if (NULL != cmd) {
                free(cmd);
            }
            if (efId_str != NULL) {
                free(efId_str);
                efId_str = NULL;
            }
            return;
#else
            simRefreshRspV7.aid = aid;
            simRefreshRspV7.result = SESSION_RESET;
            break;
#endif
        default:
            RFX_LOG_D(RFX_LOG_TAG, "Refresh type does not support.");
            return;
    }

    parcel = new Parcel();
    RFX_LOG_D(RFX_LOG_TAG, "aid = %s, %d.", simRefreshRspV7.aid, aid_len);
    simRefreshRspV7.ef_id = 0;   // default EFID
    if (NULL != efId_str && 4 <= strlen(efId_str)) {
        files_num = strlen(efId_str)/4;
    }
    // Try to read each EFID and send the URC for SIM REFRESH
    if (NULL != efId_str && 0 < strlen(efId_str)) {
        for (i = 0; i < files_num; i++) {
            memcpy(temp_str, efId_str + readIdx, 4);
            temp_str[4] = '\0';
            efId = strtol(temp_str, NULL, 16);
            simRefreshRspV7.ef_id = efId;
            RFX_LOG_D(RFX_LOG_TAG, "onSimRefresh: efId = %X, file numbers = %d", simRefreshRspV7.ef_id, files_num);

            //Todo: Add the data structure for RIL_SimRefreshResponse_v7
            parcel->writeInt32(simRefreshRspV7.result);
            parcel->writeInt32((simRefreshRspV7.ef_id == UINT32_MAX) ? -1:simRefreshRspV7.ef_id);
            writeStringToParcel(parcel, ((simRefreshRspV7.aid != NULL && strlen(simRefreshRspV7.aid) == 0) ? "": simRefreshRspV7.aid));
            rfx_enqueue_urc_message(RIL_UNSOL_SIM_REFRESH,parcel,mipc_sim_id_to_slot_id(sim_ps_id),err);
            readIdx += 4;  // go to next EFID
        }
    } else {
            //Todo: Add the data structure for RIL_SimRefreshResponse_v7
            parcel->writeInt32(simRefreshRspV7.result);
            parcel->writeInt32((simRefreshRspV7.ef_id == UINT32_MAX) ? -1:simRefreshRspV7.ef_id);
            writeStringToParcel(parcel, ((simRefreshRspV7.aid != NULL && strlen(simRefreshRspV7.aid) == 0) ? "": simRefreshRspV7.aid));
            rfx_enqueue_urc_message(RIL_UNSOL_SIM_REFRESH,parcel,mipc_sim_id_to_slot_id(sim_ps_id),err);
    }

    if (NULL != cmd) {
        free(cmd);
    }
    if (efId_str != NULL) {
        free(efId_str);
        efId_str = NULL;
    }
}

static void mipc_stk_send_bipconf_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_stk_send_bipconf_struct *result_ptr,
    void *cb_priv_ptr)
{
    RIL_Errno err = RIL_E_SUCCESS;
    RFX_LOG_D(RFX_LOG_TAG,"mipc_stk_send_bipconf_cb\n");

    err = (RIL_Errno)result_ptr->result_code;
    if(err != MIPC_RESULT_SUCCESS) {
        RFX_LOG_D(RFX_LOG_TAG,"mipc_stk_send_envelope_cb response error\n");
    }else {
        RFX_LOG_D(RFX_LOG_TAG,"mipc_stk_send_envelope_cb response success, no need to handle\n");
    }
}

static void mipc_stk_pac_set_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_stk_pac_set_struct *result_ptr,
    void *cb_priv_ptr)
{
    int i = 0;
    if (result_ptr != NULL) {
        RFX_LOG_D(RFX_LOG_TAG,"mipc_stk_pac_set_cb result_code %d\n", result_ptr->result_code);
        for (i = 0; i < 32; i++) {
            RFX_LOG_D(RFX_LOG_TAG,"pac[%d][%d][%d][%d][%d][%d][%d][%d]\n",
                result_ptr->pac_profile[(8*i)],result_ptr->pac_profile[(8*i)+1],result_ptr->pac_profile[(8*i)+2],result_ptr->pac_profile[(8*i)+3],
                result_ptr->pac_profile[(8*i)+4],result_ptr->pac_profile[(8*i)+5],result_ptr->pac_profile[(8*i)+6],result_ptr->pac_profile[(8*i)+7]);
        }
    } else {
        RFX_LOG_E(RFX_LOG_TAG,"mipc_stk_pac_set_cb result_code NULL\n");
    }
}

static void mipc_stk_send_envelope_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_stk_envelope_struct *result_ptr,
    void *cb_priv_ptr)
{
    RIL_Errno err = RIL_E_SUCCESS;
    RFX_LOG_D(RFX_LOG_TAG,"mipc_stk_send_envelope_cb\n");
    Parcel * parcel = NULL;
    err = (RIL_Errno)result_ptr->result_code;
    if(err != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        RFX_LOG_D(RFX_LOG_TAG,"mipc_stk_send_envelope_cb response error\n");
        rfx_enqueue_response_message(NULL,cb_priv_ptr,(RIL_SOCKET_ID)sim_ps_id,err);
    }else {
        //parcel = new Parcel();
        //writeStringToParcel(parcel, (uint32_t)result_ptr->status_words);//?
        RFX_LOG_D(RFX_LOG_TAG,"mipc_stk_send_envelope_cb response success\n");
        rfx_enqueue_response_message(NULL,cb_priv_ptr,(RIL_SOCKET_ID)sim_ps_id,err);
    }
}

void mipc_stk_terminal_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_stk_terminal_struct *result_ptr,
    void *cb_priv_ptr)
{
    RIL_Errno err = RIL_E_SUCCESS;
    RFX_LOG_D(RFX_LOG_TAG,"mipc_stk_terminal_cb\n");
    Parcel * parcel = NULL;
    err = (RIL_Errno)result_ptr->result_code;
    if(err != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,(RIL_SOCKET_ID)sim_ps_id,err);
    }else {
    parcel = new Parcel();
    rfx_enqueue_response_message(parcel,cb_priv_ptr,(RIL_SOCKET_ID)sim_ps_id,err);
    }
}

static void mipc_stk_handle_call_setup_requested_from_sim_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_stk_handle_call_setup_requested_from_sim_struct *result_ptr,
    void *cb_priv_ptr)
{
    //RFX_LOG_D(getTag(sim_ps_id).c_str(),"%s, %s", __FUNCTION__, dump_call_dial(result_ptr,cb_priv_ptr).c_str());

    if(result_ptr->result_code != MIPC_RESULT_SUCCESS) {
        //result code to ril error transfer
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),result_ptr->result_code);
    }else {
        rfx_enqueue_response_message(NULL,cb_priv_ptr,mipc_sim_id_to_slot_id(sim_ps_id),RIL_E_SUCCESS);
    }
}

static void mipc_stk_proactive_notification_command_cb(
    mipc_sim_ps_id_enum sim_ps_id,
    mipc_stk_pac_ind_struct_v *result_ptr,
    void *cb_priv_ptr)
{
    RFX_LOG_D(RFX_LOG_TAG,"mipc_stk_session_proactive_command_cb\n");
    Parcel * parcel = NULL;
    RIL_Errno err = RIL_E_SUCCESS;
    int cmdType = 0;
    int cmdQual = 0;
    char* pProCmd = NULL;
    char* cmd = NULL;
    int urc_len = 0;
    char* pEventNotify = NULL;

    urc_len = result_ptr->pac_len;
    cmd = (char *)result_ptr->pac;
    RpStkController* stkController = RpStkController::getInstance(sim_ps_id - 1);
    ProactiveCmdRecord* m_ProCmdRec = &(stkController->mProCmdRec);
    SimRefreshResponse* m_SimRefreshRspWithType = stkController->pSimRefreshRspWithType;
    char* m_Proactive_cmd = stkController->pProactive_cmd;
    bool m_isProaCmdQueued = stkController->isProaCmdQueued;

    switch (result_ptr->pac_type){
        case CMD_TYPE_PROACTIVE: //RIL_UNSOL_STK_PROACTIVE_COMMAND
            parseStkCmdType(cmd, &cmdType);
            m_ProCmdRec->cmdType = cmdType;
            parseStkCmdQualifier(cmd, &cmdQual);
            m_ProCmdRec->cmdQualifier= cmdQual;
            RFX_LOG_D(RFX_LOG_TAG, " m_ProCmdRec->cmdType : 0x%02X, m_ProCmdRec->cmdQualifier : %d", m_ProCmdRec->cmdType, m_ProCmdRec->cmdQualifier);

            switch(cmdType) {
                case CMD_SETUP_MENU:
                    pCachedMenu = (char*)calloc(1, urc_len + 1);
                    if (NULL == pCachedMenu) {
                        RFX_LOG_D(RFX_LOG_TAG, "mipc stk proactive command: cachedMenu is NULL !!!");
                        break;
                    }
                    memset(pCachedMenu, 0x0, urc_len + 1);
                    memcpy(pCachedMenu, cmd, urc_len);
                    RFX_LOG_D(RFX_LOG_TAG, "pCachedMenu:[%s] ", pCachedMenu);
                    break;
                case CMD_LAUNCH_BROWSER:
                case CMD_PLAY_TONE:
                case CMD_DSPL_TXT:
                case CMD_GET_INKEY:
                case CMD_GET_INPUT:
                case CMD_SELECT_ITEM:
                case CMD_PROVIDE_LOCAL_INFO:
                case CMD_IDLE_MODEL_TXT:
                case CMD_LANGUAGE_NOTIFY:
                    m_ProCmdRec->needResponse = true;
                    break;
                default:
                    m_ProCmdRec->needResponse = false;
                     break;
            }

            if (m_SimRefreshRspWithType != NULL) {
                pProCmd = (char*)calloc(1, urc_len + 1);
                if (NULL == pProCmd) {
                    RFX_LOG_D(RFX_LOG_TAG, "handleProactiveCommand: pProCmd is NULL !!!");
                    return;
                }

                memset(pProCmd, 0x0, urc_len);
                memcpy(pProCmd, cmd, urc_len);
                m_Proactive_cmd = pProCmd;
                m_isProaCmdQueued = true;
                RFX_LOG_D(RFX_LOG_TAG, "STK service is not running yet. cmd:[%p]", m_Proactive_cmd);
                return;
            }
            stkController->handleStkCommand(cmd, CMD_TYPE_PROACTIVE, sim_ps_id);
            break;
        case CMD_TYPE_NOTIFY:
            RFX_LOG_D(RFX_LOG_TAG, "CMD_TYPE_NOTIFY :%s ", cmd);

            if (strstr(cmd, "BIP")) {
                RFX_LOG_D(RFX_LOG_TAG, "report BIP: START urc");
                parcel = new Parcel();
                writeStringToParcel(parcel, cmd);
                rfx_enqueue_urc_message(RIL_UNSOL_STK_EVENT_NOTIFY,parcel,mipc_sim_id_to_slot_id(sim_ps_id),err);
                return;
            }

            if (m_SimRefreshRspWithType != NULL) {
                if (cmd != NULL) {
                    urc_len = strlen(cmd);
                } else {
                    RFX_LOG_D(RFX_LOG_TAG,"handleEventNotify: urc_len error!");
                    return;
                }
            if (checkEventNotifyFreeBuffer(sim_ps_id) > 0) {
                pEventNotify = (char*)calloc(1, urc_len + 1);
                if (NULL == pEventNotify) {
                    RFX_LOG_D(RFX_LOG_TAG,"handleEventNotify: pEventNotify is NULL !!!");
                    return;
                }
                memset(pEventNotify, 0x0, urc_len + 1);
                memcpy(pEventNotify, cmd, urc_len);
                setStkCachedEventNotify(pEventNotify, sim_ps_id);
                stkController->isEventNotifyQueued = true;
                RFX_LOG_D(RFX_LOG_TAG, "STK service is not running yet.[%p]", pEventNotify);
            }
            return;
        }

        stkController->handleStkCommand(cmd, CMD_TYPE_NOTIFY, sim_ps_id);
        break;
        case CMD_TYPE_SESSIONEND:
            rfx_enqueue_urc_message(RIL_UNSOL_STK_SESSION_END,NULL,mipc_sim_id_to_slot_id(sim_ps_id),err);
            break;
    }

}

void RpStkController::onInit() {
    RfxController::onInit();  // Required: invoke super class implementation

    isProaCmdQueued = false;
    isStkServiceRunning = false;
    int slotid;
    RFX_LOG_D(RFX_LOG_TAG, "RpStkController onInit");
    const int request_id_list[] = {
        RIL_REQUEST_STK_SEND_ENVELOPE_COMMAND, //69
        RIL_REQUEST_STK_SEND_TERMINAL_RESPONSE,//70
        RIL_REQUEST_STK_HANDLE_CALL_SETUP_REQUESTED_FROM_SIM, //71
        RIL_REQUEST_REPORT_STK_SERVICE_IS_RUNNING,//103
        RIL_REQUEST_STK_SEND_ENVELOPE_WITH_STATUS //107
    };
    uint8_t value[32];
    uint8_t len = 32;
    memset(value, 0xFF, len);

    sInstance[getSlotId()] = this;
    // register request id list
    registerToHandleRequest(request_id_list,
            sizeof(request_id_list) / sizeof(int));
    slotid = getSlotId();
    mipc_stk_pac_ind_register(slot_id_to_mipc_sim_id(slotid), mipc_stk_proactive_notification_command_cb, NULL);
    mipc_stk_pac_set_async(slot_id_to_mipc_sim_id(slotid), mipc_stk_pac_set_cb, NULL, value);
    RFX_LOG_D(RFX_LOG_TAG, "RpStkController onInit done");
}

void RpStkController::onDeinit() {
    RFX_LOG_D(RFX_LOG_TAG, "onDeinit");

    sInstance[getSlotId()] = NULL;
    RfxController::onDeinit();
}

bool RpStkController::onHandleRequest(const sp<RfxMessage>& message) {
    RFX_LOG_D(RFX_LOG_TAG, "Handle request %d", message->getId());
    RfxDispatchThread::addMessageToPendingQueue(message);
    switch (message->getId()) {
        case RIL_REQUEST_STK_SEND_ENVELOPE_COMMAND:
        case RIL_REQUEST_STK_SEND_ENVELOPE_WITH_STATUS:
            handleStkSendEnvelopeRequest(message);
            break;
        case RIL_REQUEST_STK_SEND_TERMINAL_RESPONSE:
            handleStkTerminalRequest(message);
            break;
        case RIL_REQUEST_REPORT_STK_SERVICE_IS_RUNNING:
            handleReportStkIsRunningRequest(message);
            break;
        case RIL_REQUEST_STK_HANDLE_CALL_SETUP_REQUESTED_FROM_SIM:
            handleStkHandleCallSetupRequestedFromSim(message);
        default:
            RFX_LOG_D(RFX_LOG_TAG, "unknown request, ignore!");
            break;
    }
    return true;
}

void RpStkController::handleStkSendEnvelopeRequest(const sp<RfxMessage>& request) {
    RFX_LOG_D(RFX_LOG_TAG, "handleStkSendEnvelopeRequest with clientId: %d, with token: %d",
        request->getClientId(), request->getToken());

    char *string8 = NULL;
    uint32_t envelope_len = 0;
    Parcel *p = request->getParcel();
    RFX_LOG_D(RFX_LOG_TAG, "enter0 p=%p\n",p);

    if(p != NULL) {
        RFX_LOG_D(RFX_LOG_TAG, "enter1\n");
        string8 = strdupReadString(*p);
        RFX_LOG_D(RFX_LOG_TAG, "[ytn-log] string8=%s \n",string8);
        envelope_len = strlen(string8);
        RFX_LOG_D(RFX_LOG_TAG, "[ytn-log] envelope_len=%%d \n",envelope_len);
    }
    RFX_LOG_D(RFX_LOG_TAG, "[ytn-log] sim id=%%d \n",slot_id_to_mipc_sim_id(request->getSlotId()));
    mipc_stk_envelope_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_stk_send_envelope_cb, (void *)request->getRilToken(), envelope_len, (uint8_t *)string8);

    if(string8 != NULL){
        free(string8);
    }
}

void RpStkController::handleStkTerminalRequest(const sp<RfxMessage>& request) {
    RFX_LOG_D(RFX_LOG_TAG, "handleStkSendEnvelopeRequest with clientId: %d, with token: %d",
    request->getClientId(), request->getToken());

    int cmdType = 0;
    int resCode = 0;
    char *string8 = NULL;
    uint32_t terminal_len = 0;
    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;

    Parcel *p = request->getParcel();
    RFX_LOG_D(RFX_LOG_TAG, "enter0 p=%p\n",p);

    if(p != NULL) {
        RFX_LOG_D(RFX_LOG_TAG, "enter1\n");
        string8 = strdupReadString(*p);
        RFX_LOG_D(RFX_LOG_TAG, "[ytn-log] string8=%s \n",string8);
        terminal_len = strlen(string8);
        RFX_LOG_D(RFX_LOG_TAG, "[ytn-log] terminal_len=%%d \n",terminal_len);
    }

    //from 2731 RtcCatController
    parseStkCmdType(request, &cmdType);
    RFX_LOG_D(RFX_LOG_TAG, "mProCmdRec: cmdType:0x%02X, current response type:0x%02X ", mProCmdRec.cmdType, cmdType);

    if (0 != mProCmdRec.cmdType && mProCmdRec.cmdType == cmdType && mProCmdRec.needResponse) {
        mipc_stk_terminal_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_stk_terminal_cb, (void *)request->getRilToken(), terminal_len, (uint8_t *)string8);
        resetProCmd(slot_id_to_mipc_sim_id(request->getSlotId()));
    //Setup Event list may cover current cmd type and cause response block
    } else if (CMD_SETUP_EVENT_LIST == cmdType) {
        mipc_stk_terminal_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_stk_terminal_cb, (void *)request->getRilToken(), terminal_len, (uint8_t *)string8);
        resetProCmd(slot_id_to_mipc_sim_id(request->getSlotId()));
    // BIP @{
    } else if (CMD_OPEN_CHAN == cmdType) {
        parseStkResultCode(request, &resCode);
        if (resCode >= 0) {
            int bip_Data[2];
            bip_Data[0] = mProCmdRec.cmdNum;
            bip_Data[1] = resCode;
            //2731 would send RIL_REQUEST_BIP_SEND_CONFIRM_INFO(BIPCONF), but 2735 L5 did not have it, just finish its logic
            ret = mipc_stk_send_bipconf_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_stk_send_bipconf_cb, (void *)request->getRilToken(), bip_Data[0], bip_Data[1]);

            rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_SUCCESS);
        } else {
            RFX_LOG_D(RFX_LOG_TAG, "parse bip result code fail");
            rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_GENERIC_FAILURE);
        }
        resetProCmd(slot_id_to_mipc_sim_id(request->getSlotId()));
    // BIP @}
    } else {
        RFX_LOG_D(RFX_LOG_TAG, "Not Expected TR. Return directly!!!");
        rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_SUCCESS);
    }

    if(string8 != NULL){
        free(string8);
    }
}

void RpStkController::handleReportStkIsRunningRequest(const sp<RfxMessage>& request) {
    RFX_LOG_D(RFX_LOG_TAG, "handleReportStkIsRunningRequest with clientId: %d, with token: %d",
        request->getClientId(), request->getToken());

    RIL_Errno err = RIL_E_SUCCESS;

    RFX_LOG_D(RFX_LOG_TAG, "requestReportStkServiceIsRunning");
    rfx_enqueue_response_message(NULL, request->getRilToken(), (RIL_SOCKET_ID)request->getSlotId(), err);

    mCardType = getStatusManager()->getIntValue(RFX_STATUS_KEY_CARD_TYPE, -1);
    getStatusManager()->setBoolValue(RFX_STATUS_KEY_IS_CAT_RUNNING, true);
    isStkServiceRunning = true;
    sendStkQueuedCmd(0, slot_id_to_mipc_sim_id(request->getSlotId()));
}

void RpStkController::handleStkHandleCallSetupRequestedFromSim(const sp<RfxMessage>& request) {
    RFX_LOG_D(RFX_LOG_TAG, "handleStkHandleCallSetupRequestedFromSim with clientId: %d, with token: %d",
        request->getClientId(), request->getToken());
    mipc_api_result_enum ret = MIPC_API_RESULT_FAIL;
    status_t status;
    int32_t t;
    int data;

    do {
        Parcel *p = request->getParcel();
        if(p == NULL) {
            RFX_LOG_D(RFX_LOG_TAG, "handleStkHandleCallSetupRequestedFromSim p has no data to transfer\n");
            break;
        }
        RFX_LOG_D(RFX_LOG_TAG, "handleStkHandleCallSetupRequestedFromSim p=%p\n",p);
        status = p->readInt32(&t);
        if (status != android::NO_ERROR) {
            RFX_LOG_D(RFX_LOG_TAG, "parse parcel fail");
            break;
        }
        data = (int)t;

        if (CMD_SETUP_CALL == mProCmdRec.cmdType) {
            //note: For bianco, it is no used to config audio path
            if (false == mProCmdRec.needResponse) {
                RFX_LOG_D(RFX_LOG_TAG, "Not need to send call request, just return!");
                ret = MIPC_API_RESULT_SUCCESS;
                break;
            } else {
                ret = mipc_stk_handle_call_setup_requested_from_sim_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_stk_handle_call_setup_requested_from_sim_cb, (void *)request->getRilToken(), data);
            }
            // BIP @{
            } else if (CMD_OPEN_CHAN == mProCmdRec.cmdType) {
                RFX_LOG_D(RFX_LOG_TAG, "parse bip result code: %d ", data);
                int bip_Data[2];
                bip_Data[0] = mProCmdRec.cmdNum;
                bip_Data[1] = data;
                //2731 would send RIL_REQUEST_BIP_SEND_CONFIRM_INFO(BIPCONF), but 2735 L5 did not have it, just finish its logic
                ret = mipc_stk_send_bipconf_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_stk_send_bipconf_cb, (void *)request->getRilToken(), bip_Data[0], bip_Data[1]);
            // BIP @}
            } else {
                RFX_LOG_D(RFX_LOG_TAG, "Unexpected CALL_SETUP_REQUESTED. Warning!!!");
                ret = mipc_stk_handle_call_setup_requested_from_sim_async(slot_id_to_mipc_sim_id(request->getSlotId()), mipc_stk_handle_call_setup_requested_from_sim_cb, (void *)request->getRilToken(), data);
            }
            // reset mProCmdRec
            resetProCmd(slot_id_to_mipc_sim_id(request->getSlotId()));
    }while(0);

    if(ret != MIPC_API_RESULT_SUCCESS) {
        RFX_LOG_D(RFX_LOG_TAG, "%s fail", __FUNCTION__);
        rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_GENERIC_FAILURE);
    }
    else {
        RFX_LOG_D(RFX_LOG_TAG, "%s success", __FUNCTION__);
        rfx_enqueue_response_message(NULL,request->getRilToken(),(RIL_SOCKET_ID)request->getSlotId(),RIL_E_SUCCESS);
    }
}

void RpStkController::handleStkCommand(char* cmd, int cmdClass, mipc_sim_ps_id_enum sim_ps_id) {
    int urc_len = 0, type_pos = 0, cmdType = -1, cmdNum = 0;
    int cmdQual = 0;
    int cmd_not_understood = 0;
    int duration[1] = {0};
    int notify_info[2];
    char optr[RFX_PROPERTY_VALUE_MAX] = {0};
    char seg[RFX_PROPERTY_VALUE_MAX] = {0};
    RIL_Errno err = RIL_E_SUCCESS;
    Parcel * parcel = NULL;
    Parcel * parcel2 = NULL;

    parseStkCmdType(cmd, &cmdType);
    parseStkCmdQualifier(cmd, &cmdQual);
    mProCmdRec.cmdType = cmdType;
    mProCmdRec.cmdQualifier = cmdQual;

    if (CMD_TYPE_PROACTIVE == cmdClass) {
        switch(cmdType) {
            case CMD_SETUP_MENU:
            case CMD_LAUNCH_BROWSER:
            case CMD_PLAY_TONE:
            case CMD_DSPL_TXT:
            case CMD_GET_INKEY:
            case CMD_GET_INPUT:
            case CMD_SELECT_ITEM:
            case CMD_PROVIDE_LOCAL_INFO:
            case CMD_IDLE_MODEL_TXT:
            case CMD_LANGUAGE_NOTIFY:
                mProCmdRec.needResponse = true;
                break;
            // BIP @{
            case CMD_OPEN_CHAN:
                mProCmdRec.needResponse = false;
                parseStkCmdNum(cmd, &cmdNum);
                mProCmdRec.cmdNum = cmdNum;
                RFX_LOG_D(RFX_LOG_TAG,"handleStkCommand: cmd num is %d", mProCmdRec.cmdNum);
                break;
            // BIP @}
            default:
                mProCmdRec.needResponse = false;
                break;
        }
        if ((CMD_CLOSE_CHAN == cmdType) || (CMD_RECEIVE_DATA == cmdType)
                                                    || (CMD_SEND_DATA == cmdType)) {
            RFX_LOG_D(RFX_LOG_TAG,"onHandleUrc: cmd has no need to send to stk fwk currently!");
            return;
        }
        parcel = new Parcel();
        writeStringToParcel(parcel, cmd);
        rfx_enqueue_urc_message(RIL_UNSOL_STK_PROACTIVE_COMMAND,parcel,mipc_sim_id_to_slot_id(sim_ps_id),err);
    } else if (CMD_TYPE_NOTIFY == cmdClass) {
        mProCmdRec.needResponse = false;
        sp<RfxMessage> msg = NULL;
        if(cmd[2] <= '7' ) {
            type_pos = 10;
        } else if(cmd[2] > '7' ) {
            type_pos = 12;
        }
        /*temp_str[type_pos -6] points to cmd_detail tag*/
        cmd_not_understood = checkStkCmdDisplay(&(cmd[type_pos - 6]));
        RFX_LOG_D(RFX_LOG_TAG, "cmd_not_understood Cmd: %d", cmd_not_understood);
        switch(cmdType) {
            case CMD_REFRESH:
                //handle sim refresh
                //L5 has handled it and we use mipc_stk_sim_refresh_ind_cb to report the sim refresh command.
                break;
            case CMD_SETUP_CALL:
                //handle setup call
                if(cmd_not_understood == 0) {
                    /*temp_str[type_pos -6] points to cmd_detail tag*/
                    duration[0] = (int)findStkCallDuration(&cmd[type_pos - 6]);
                    RFX_LOG_D(RFX_LOG_TAG, "duration: %d", duration[0]);
                    mProCmdRec.cmdType = cmdType;
                    mProCmdRec.needResponse = true;
                } else {
                    notify_info[0] = CMD_SETUP_CALL;
                    notify_info[1] = 50;
                    //2731 would send RFX_MSG_REQUEST_STK_EVENT_NOTIFY, but 2735 logic & L5 did not have it
                    //msg = RfxMessage::obtainRequest(m_slot_id, RFX_MSG_REQUEST_STK_EVENT_NOTIFY, RfxIntsData(notify_info, 2));
                    //requestToMcl(msg);
                }
                break;
            case CMD_SEND_SMS:
                //handle send sms
                notify_info[0] = CMD_SEND_SMS;
                notify_info[1] = 0;
                //2731 would send RFX_MSG_REQUEST_STK_EVENT_NOTIFY, but 2735 logic & L5 did not have it
                //msg = RfxMessage::obtainRequest(m_slot_id, RFX_MSG_REQUEST_STK_EVENT_NOTIFY, RfxIntsData(notify_info, 2));
                //requestToMcl(msg);
                // For CT A and C lab test, CDMA SIM card not show send sms toast
                rfx_property_get("persist.vendor.operator.optr", optr, "");
                rfx_property_get("persist.vendor.operator.seg", seg, "");
                if (((mCardType & RFX_CARD_TYPE_RUIM)
                       || (mCardType & RFX_CARD_TYPE_CSIM))
                       && strncmp(optr, "OP09", strlen("OP09")) == 0
                       && (strncmp(seg, "SEGC", strlen("SEGC")) == 0)) {
                    RFX_LOG_D(RFX_LOG_TAG,"Send sms notify will not send to AP~~~");
                    return;
                }
                break;
            case CMD_SEND_SS:
                //handle send ss
                notify_info[0] = CMD_SEND_SS;
                if(cmd_not_understood == 0) {
                    notify_info[1] = 0;
                } else {
                    notify_info[1] = 50;
                }
                //2731 would send RFX_MSG_REQUEST_STK_EVENT_NOTIFY, but 2735 logic & L5 did not have it
                //msg = RfxMessage::obtainRequest(m_slot_id, RFX_MSG_REQUEST_STK_EVENT_NOTIFY, RfxIntsData(notify_info, 2));
                //requestToMcl(msg);
                break;
            case CMD_SEND_USSD:
                //handle ussd
                notify_info[0] = CMD_SEND_USSD;
                if(cmd_not_understood == 0) {
                    notify_info[1] = 0;
                } else {
                    notify_info[1] = 50;
                }
                //2731 would send RFX_MSG_REQUEST_STK_EVENT_NOTIFY, but 2735 logic & L5 did not have it
                //msg = RfxMessage::obtainRequest(m_slot_id, RFX_MSG_REQUEST_STK_EVENT_NOTIFY, RfxIntsData(notify_info, 2));
                //requestToMcl(msg);
                break;
            case CMD_DTMF:
                //handle dtmf
                notify_info[0] = CMD_DTMF;
                notify_info[1] = 0;
                //2731 would send RFX_MSG_REQUEST_STK_EVENT_NOTIFY, but 2735 logic & L5 did not have it
                //msg = RfxMessage::obtainRequest(m_slot_id, RFX_MSG_REQUEST_STK_EVENT_NOTIFY, RfxIntsData(notify_info, 2));
                //requestToMcl(msg);
                break;
            default:
                break;
        }
        parcel = new Parcel();
        // BIP @{
        //Need to compatible with the AP bip solution
        if (CMD_OPEN_CHAN == cmdType) {
            writeStringToParcel(parcel, cmd);
            rfx_enqueue_urc_message(RIL_UNSOL_STK_PROACTIVE_COMMAND,parcel,mipc_sim_id_to_slot_id(sim_ps_id),err);
            return;
        }
        // BIP @}
        writeStringToParcel(parcel, cmd);
        rfx_enqueue_urc_message(RIL_UNSOL_STK_EVENT_NOTIFY,parcel,mipc_sim_id_to_slot_id(sim_ps_id),err);

        if(CMD_SETUP_CALL == cmdType) {
            parcel2 = new Parcel();
            parcel2->writeInt32(1);
            parcel2->writeInt32(duration[0]);
            rfx_enqueue_urc_message(RIL_UNSOL_STK_CALL_SETUP,parcel2,mipc_sim_id_to_slot_id(sim_ps_id),err);
        }
    }
}
