/*****************************************************************************
*  Copyright Statement:
*  --------------------
*  Copyright (c) [2020], MediaTek Inc. All rights reserved.
*  This software/firmware and related documentation ("MediaTek Software") are
*  protected under relevant copyright laws.
*
*  The information contained herein is confidential and proprietary to
*  MediaTek Inc. and/or its licensors. Except as otherwise provided in the
*  applicable licensing terms with MediaTek Inc. and/or its licensors, any
*  reproduction, modification, use or disclosure of MediaTek Software, and
*  information contained herein, in whole or in part, shall be strictly
*  prohibited.
*****************************************************************************/

#ifndef _MIPC_API_H_
#define _MIPC_API_H_

/*!
    \defgroup COMMON
    @{
*/

#include "mipc_msg_tlv_const.h"
#include "mipc.h"

/*!
    \brief MIPC API result
*/
typedef enum {
    MIPC_API_RESULT_SUCCESS = 0,    /*!< API result is SUCCESS */
    MIPC_API_RESULT_FAIL = 1,       /*!< API result is FAIL */
    MIPC_API_RESULT_TIMEOUT = 2     /*!< API result is TIMEOUT */
} mipc_api_result_enum;

/*!
    \brief MIPC SIM and PS ID (API can use SIM ID or PS ID)
*/
typedef enum {
    MIPC_API_SIM0 = MIPC_SIM0,
    MIPC_API_SIM1 = MIPC_SIM1,
    MIPC_API_SIM2 = MIPC_SIM2,
    MIPC_API_SIM3 = MIPC_SIM3,
    MIPC_API_PS0 = MIPC_PS0,
    MIPC_API_PS1 = MIPC_PS1,
    MIPC_API_PS2 = MIPC_PS2,
    MIPC_API_PS3 = MIPC_PS3,
    MIPC_API_ALL = MIPC_ALL
} mipc_sim_ps_id_enum;


/** @brief data class definition*/
typedef enum {
    MIPC_ENUM_DATA_NONE = MIPC_SYS_CAP_DATA_NONE,/*!<data class unknown.*/
    MIPC_ENUM_DATA_GPRS = MIPC_SYS_CAP_DATA_GPRS,/*!<support GPRS.*/
    MIPC_ENUM_DATA_EDGE = MIPC_SYS_CAP_DATA_EDGE,/*!<support EDGE.*/
    MIPC_ENUM_DATA_UMTS = MIPC_SYS_CAP_DATA_UMTS,/*!<support UMTS.*/
    MIPC_ENUM_DATA_HSDPA = MIPC_SYS_CAP_DATA_HSDPA,/*!<HSDPA .*/
    MIPC_ENUM_DATA_HSUPA = MIPC_SYS_CAP_DATA_HSUPA,/*!<HSUPA .*/
    MIPC_ENUM_DATA_LTE = MIPC_SYS_CAP_DATA_LTE,/*!<LTE.*/
    MIPC_ENUM_DATA_5G_NSA = MIPC_SYS_CAP_DATA_5G_NSA,/*!<5G NSA.*/
    MIPC_ENUM_DATA_5G_SA = MIPC_SYS_CAP_DATA_5G_SA,/*!<5G SA.*/
    MIPC_ENUM_DATA_1XRTT = MIPC_SYS_CAP_DATA_1XRTT,/*!<1xRTT.*/
    MIPC_ENUM_DATA_1XEVDO = MIPC_SYS_CAP_DATA_1XEVDO,/*!<1XEVDO.*/
    MIPC_ENUM_DATA_1XEVDO_REVA = MIPC_SYS_CAP_DATA_1XEVDO_REVA,/*!<1XEVDO_REVA.*/
    MIPC_ENUM_DATA_1XEVDV = MIPC_SYS_CAP_DATA_1XEVDV,/*!<1XEVDV.*/
    MIPC_ENUM_DATA_3XRTT = MIPC_SYS_CAP_DATA_3XRTT,/*!<3XRTT.*/
    MIPC_ENUM_DATA_1XEVDO_REVB = MIPC_SYS_CAP_DATA_1XEVDO_REVB,/*!<1XEVDO_REVB.*/
    MIPC_ENUM_DATA_UMB = MIPC_SYS_CAP_DATA_UMB,/*!<1XEVDO_UMB.*/
    MIPC_ENUM_DATA_HSPA_PLUS = MIPC_SYS_CAP_DATA_HSPA_PLUS,/*!<HSPA+ .*/
    MIPC_ENUM_DATA_CUSTOM = MIPC_SYS_CAP_DATA_CUSTOM/*!<CUSTOM .*/
} mipc_data_enum;

mipc_api_result_enum mipc_set_api_timeout(
    uint32_t timeout_ms
);

/**
  *@brief function for sync. and async. API timeout setting for current thread (save in thread local storage)
  *@param[in] timeout_ms (unit is ms, 0 means INFINITE)
*/
mipc_api_result_enum mipc_set_timeout(
    uint32_t timeout_ms
);


/*!
    @}
*/

#endif
